/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.util.StringUtils;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.query.Versions;
import ca.infodata.syra.services.ObtenirFichValidService;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.util.Validateur;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.Platform;

public class DownloadValideur
extends Validateur {
    static DownloadValideur downloadValideur;
    private String urlValidAddress = "http://www.infodata.ca/ftp/valid/syra/";
    static ExecutorService executor;
    public String agence = "16147";
    public String userId = "AGR16147";
    public String userPswd = "Ramq1234a";
    Properties propFavModels = null;
    long lastFavModelsLoaded = 0L;
    static long m30;

    static {
        executor = Executors.newSingleThreadExecutor();
        m30 = 1800000L;
    }

    private DownloadValideur() {
    }

    public static DownloadValideur getInstance() {
        if (downloadValideur == null) {
            downloadValideur = new DownloadValideur();
        }
        return downloadValideur;
    }

    @Override
    public int doIt() {
        return 0;
    }

    public Status doUpdate(String uid) {
        boolean hasNewValid;
        Status status = new Status(IStatus.Severity.INFO, "Mise \u00e0 jour en cours...");
        boolean bl = hasNewValid = LibPlugin.isInfodata || this.checkIfNewValid();
        if (hasNewValid) {
            boolean ok = this.checkParamComm();
            if (!ok) {
                return new Status(IStatus.Severity.ERROR, "Erreur lors de la validation des identifiants de communication. Veuillez v\u00e9rfier ces valeurs.");
            }
            if (uid == null) {
                Status status2 = this.doUpdateFichierAideSaisie(uid);
                return status2;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DownloadValideur.this.doUpdateFichierAideSaisie(uid);
                }
            });
        } else {
            Status status2 = new Status(IStatus.Severity.OK, "Les fichiers correspondent \u00e0 la version la plus r\u00e9cente.");
            CTypeObject to1 = new CTypeObject("updateFichierAideDoneType", status2);
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message1);
        }
        return status;
    }

    public boolean checkParamComm() {
        SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
        this.agence = globalSettings.get("syra_noAgence");
        this.userId = globalSettings.get("syra_idMach");
        this.userPswd = globalSettings.get("syra_idMachPswd");
        boolean ok = this.verifParamCommunication();
        return ok;
    }

    public Status doUpdateFichierAideSaisie(String uid) {
        Status status2;
        block7: {
            status2 = new Status(IStatus.Severity.OK, "");
            ValidRamq.isUpdating = true;
            try {
                try {
                    status2 = ValidRamq.getInstance().updateFichierAideSaisie(this.userId, this.userPswd, this.agence);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String cause = e.getMessage();
                    if (e.getCause() != null && e.getCause().getMessage() != null) {
                        cause = String.valueOf(cause) + ". Cause: " + e.getCause().getMessage();
                    }
                    status2 = new Status(IStatus.Severity.ERROR, "Erreur lors de la mise \u00e0 jour de la base de donn\u00e9es [" + ObtenirFichValidService.userHomeBaseX + "]. " + cause);
                    ValidRamq.isUpdating = false;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                ValidRamq.isUpdating = false;
                throw throwable;
            }
            ValidRamq.isUpdating = false;
        }
        if (uid != null) {
            CTypeObject to1 = new CTypeObject("updateFichierAideDoneType", status2);
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)uid, (String)message1);
        }
        return status2;
    }

    public boolean verifParamCommunication() {
        return StringUtils.isNotEmpty((String)this.agence) && StringUtils.isNotEmpty((String)this.userId) && StringUtils.isNotEmpty((String)this.userPswd);
    }

    public boolean checkIfNewValid() {
        File file = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/urlsyra.info");
        if (file.exists()) {
            this.urlValidAddress = LibPlugin.fileToStr((String)file.getPath());
        }
        System.out.println(this.urlValidAddress);
        boolean whatToDo = false;
        this.propServeur = new Properties();
        this.propLocal = new Versions().getVersionProp();
        URL urlDuValidServeur = null;
        String fichierAideTxt = String.valueOf(Platform.inDebugMode() ? "debug_" : "") + "fichieraides.txt";
        try {
            urlDuValidServeur = new URL(String.valueOf(this.urlValidAddress) + fichierAideTxt);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        File fileLocalFromServeur = new File(String.valueOf(LibPlugin.MEDOFFICE_HOME) + fichierAideTxt);
        if (fileLocalFromServeur.exists()) {
            fileLocalFromServeur.delete();
        }
        this.propServeur = DownloadValideur.getVersionPropertiesFromServer(fileLocalFromServeur.getAbsolutePath(), urlDuValidServeur);
        if (internetOk) {
            whatToDo = this.getNeedsToUpdate(this.propServeur, this.propLocal);
        }
        return whatToDo;
    }

    public String getFavModel(String modelFile) {
        File file = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/urlsyra.info");
        if (file.exists()) {
            this.urlValidAddress = LibPlugin.fileToStr((String)file.getPath());
        }
        URL urlFavModelFile = null;
        try {
            urlFavModelFile = new URL(String.valueOf(this.urlValidAddress) + modelFile);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        return DownloadValideur.getFileFromServer(urlFavModelFile);
    }

    public Properties getFavModel() {
        long now = System.currentTimeMillis();
        if (this.propFavModels == null || now - this.lastFavModelsLoaded > m30) {
            File file = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/urlsyra.info");
            if (file.exists()) {
                this.urlValidAddress = LibPlugin.fileToStr((String)file.getPath());
            }
            URL urlFavModels = null;
            String favModels = "favmodels.txt";
            try {
                urlFavModels = new URL(String.valueOf(this.urlValidAddress) + "favmodels.txt");
                this.lastFavModelsLoaded = now;
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            this.propFavModels = DownloadValideur.getfavModelFromServer(urlFavModels);
        }
        return this.propFavModels;
    }
}

