/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.syra.SyraPlugin;
import ca.infodata.syra.converter.XmlGregCalConverter;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.util.JoinList;
import ca.infodata.util1.StringUtils;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemAnnuRecev;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.DemPaimtRecev;
import ca.qc.gouv.ramq.rfp.FactFraisDepla210;
import ca.qc.gouv.ramq.rfp.FactServMdcalOmni210;
import ca.qc.gouv.ramq.rfp.FactServMdcalSpec210;
import ca.qc.gouv.ramq.rfp.IdFactRamq;
import ca.qc.gouv.ramq.rfp.IdFactRamqRecev;
import ca.qc.gouv.ramq.rfp.LigneForfaDepla;
import ca.qc.gouv.ramq.rfp.LigneFraisSej;
import ca.qc.gouv.ramq.rfp.LigneFraisTranp;
import ca.qc.gouv.ramq.rfp.LigneTempsDepla;
import ca.qc.gouv.ramq.rfp.ObjectFactory;
import ca.qc.gouv.ramq.rfp.TypAdr;
import ca.qc.gouv.ramq.rfp.TypDem;
import ca.qc.gouv.ramq.rfp.TypDemPaimt;
import ca.qc.gouv.ramq.rfp.TypDemRecev;
import ca.qc.gouv.ramq.rfp.TypDiagnMdcal110;
import ca.qc.gouv.ramq.rfp.TypElmContx;
import ca.qc.gouv.ramq.rfp.TypElmMesur;
import ca.qc.gouv.ramq.rfp.TypFact;
import ca.qc.gouv.ramq.rfp.TypFraisSej;
import ca.qc.gouv.ramq.rfp.TypIdLieu;
import ca.qc.gouv.ramq.rfp.TypIdLieuGeo;
import ca.qc.gouv.ramq.rfp.TypIdLieuGeoDepla;
import ca.qc.gouv.ramq.rfp.TypIdLieuPhys;
import ca.qc.gouv.ramq.rfp.TypIdPersAutre;
import ca.qc.gouv.ramq.rfp.TypInfoMdcalPers110;
import ca.qc.gouv.ramq.rfp.TypInfoPers;
import ca.qc.gouv.ramq.rfp.TypLieuGeoOmni;
import ca.qc.gouv.ramq.rfp.TypLieuGeoSpec;
import ca.qc.gouv.ramq.rfp.TypLieuPhysOmni;
import ca.qc.gouv.ramq.rfp.TypLieuPhysSpec;
import ca.qc.gouv.ramq.rfp.TypLieuRefreGeoOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefreGeoSpec;
import ca.qc.gouv.ramq.rfp.TypLieuRefreOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefrePhysOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefrePhysSpec;
import ca.qc.gouv.ramq.rfp.TypLieuRefreSpec;
import ca.qc.gouv.ramq.rfp.TypLigneDepla;
import ca.qc.gouv.ramq.rfp.TypLigneFactRecev;
import ca.qc.gouv.ramq.rfp.TypLogclFact;
import ca.qc.gouv.ramq.rfp.TypMsgExplRecev;
import ca.qc.gouv.ramq.rfp.TypPers;
import ca.qc.gouv.ramq.rfp.TypPersPatntSansIdt;
import ca.qc.gouv.ramq.rfp.TypPersRepdn;
import ca.qc.gouv.ramq.rfp.TypProf;
import ca.qc.gouv.ramq.rfp.TypProfNonConnu;
import com.cedarsoftware.util.io.JsonWriter;
import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.runtime.Platform;

public class ConvertJavaToFromArray {
    public static final String NO_VERSI_XML102 = "1.0.2";
    public static final String NO_VERSI_XML200 = "2.0.0";
    public static final String NO_VERSI_XML210 = "2.1.0";
    public static final String[] N = new String[]{"~", "|", "^", "\u00a6", "\u0142", "\u0131", "\u012b", "\u012d", "\u012f", "\u012e"};
    public static final String[] SN = new String[]{"~", "|", "^", "\u00a6", "\u0142", "\u0131", "\u012b", "\u012d", "\u012f", "\u012e"};
    public static final String TILDE = "&#126;";
    public static final String VERT_BAR = "&#124;";
    public static final String ACC_CIRC = "&#094;";
    public static final String BROKEN_BAR = "&#166;";
    public static final String L_STROKE = "&#322;";
    public static final String I_DOTLESS = "&#305;";
    public static final String I_MACRON = "&#299;";
    public static final String I_SMALL_BREVE = "&#301;";
    public static final String I_SMALL_OGONEK = "&#302;";
    public static final String I_OGONEK = "&#302;";
    public static final Map<String, String> mapString = new HashMap<String, String>();
    public static final Map<String, String> mapStringAbbr = new HashMap<String, String>();
    public static ObjectFactory of;
    public static DateFormat dateFormatDT;
    public static DateFormat dateFormatD;
    public static DatatypeFactory dataFactory;
    private static Map<String, Object> args;

    static {
        mapString.put("CIE", "Logiciels INFO-DATA inc.");
        mapStringAbbr.put("Logiciels INFO-DATA inc.", "CIE");
        mapString.put("MO", "MED-Office");
        mapStringAbbr.put("MED-Office", "MO");
        mapString.put("OF", "Ofys");
        mapStringAbbr.put("Ofys", "OF");
        of = new ObjectFactory();
        dateFormatDT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        dateFormatD = new SimpleDateFormat("yyyy-MM-dd");
        try {
            dataFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        args = null;
    }

    public static final boolean isVer102(TypLogclFact log) {
        return log == null ? true : log.getNoVersiXmlDem().equals(NO_VERSI_XML102);
    }

    public static final boolean isVer200(TypLogclFact log) {
        return log == null ? true : log.getNoVersiXmlDem().equals(NO_VERSI_XML200);
    }

    public static final boolean isVer210(TypLogclFact log) {
        return log == null ? true : log.getNoVersiXmlDem().equals(NO_VERSI_XML210);
    }

    public static TypLogclFact getLoglFact() {
        TypLogclFact loglFact = of.createTypLogclFact();
        loglFact.setNoDevprLogcl(16147);
        loglFact.setNomDevprLogcl(mapString.get("CIE"));
        loglFact.setNomLogclFact(mapString.get(mapStringAbbr.get(SyraPlugin.nomLogiciel)));
        loglFact.setNoVersiLogclFact(SyraPlugin.version);
        loglFact.setNoVersiXmlDem(SyraPlugin.noVersiXmlDem);
        return loglFact;
    }

    public static TypProf getTypProf(String id, String typ) {
        TypProf prof = of.createTypProf();
        prof.setIdProf(id);
        prof.setTypIdProf(ConvertJavaToFromArray.parseInt(typ));
        return prof;
    }

    public static String toArrayString(JoinList a4, IdFactRamqRecev idFactRecev) {
        if (idFactRecev.getNoFactRamq() != null) {
            a4.add(ConvertJavaToFromArray.isN(idFactRecev.getNoFactRamq()));
        } else {
            a4.add("");
        }
        if (idFactRecev.getJetonComm() != null) {
            a4.add(ConvertJavaToFromArray.isN(idFactRecev.getJetonComm()));
        } else {
            a4.add("");
        }
        return a4.toString();
    }

    public static IdFactRamqRecev fromArrayString(String[] s3, IdFactRamqRecev idFactRecev) {
        boolean hasData = false;
        if (s3.length == 2) {
            if (s3[0].length() > 0) {
                idFactRecev.setNoFactRamq(new BigInteger(s3[0]));
                hasData = true;
            }
            if (s3[1].length() > 0) {
                idFactRecev.setJetonComm(new BigInteger(s3[1]));
                hasData = true;
            }
        }
        return hasData ? idFactRecev : null;
    }

    public static String toArrayString(int level, TypDemRecev.ListeMsgExplRecev listeMsgExplRecev) {
        if (listeMsgExplRecev != null) {
            JoinList a2 = new JoinList(N[level]);
            List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecev.getMsgExplRecev();
            if (!msgExplRecev.isEmpty()) {
                for (TypMsgExplRecev explRecev : msgExplRecev) {
                    JoinList a3 = new JoinList(N[level + 1]);
                    a3.add(ConvertJavaToFromArray.isN(explRecev.getCodMsgExplRecev()));
                    a3.add(explRecev.getTxtMsgExplRecev());
                    a2.add(a3.toString());
                }
            }
            return a2.toString();
        }
        return "";
    }

    public static TypDemRecev.ListeMsgExplRecev fromArrayString(String arr, int level, TypDemRecev.ListeMsgExplRecev listeMsgExplRecev) {
        String[] a2 = ConvertJavaToFromArray.split(arr, SN[level]);
        if (a2.length > 0 && a2[0].length() > 0) {
            String[] stringArray = a2;
            int n = a2.length;
            int n2 = 0;
            while (n2 < n) {
                String aa2 = stringArray[n2];
                String[] a3 = ConvertJavaToFromArray.split(aa2, SN[level + 1]);
                TypMsgExplRecev expl = of.createTypMsgExplRecev();
                expl.setCodMsgExplRecev(new BigInteger(a3[0]));
                expl.setTxtMsgExplRecev(a3[1]);
                listeMsgExplRecev.getMsgExplRecev().add(expl);
                ++n2;
            }
        }
        return listeMsgExplRecev;
    }

    public static TypProfNonConnu getTypProfNonConnu(String id, String typ, String pre, String nom) {
        TypProfNonConnu prof = of.createTypProfNonConnu();
        prof.setCodTerriProfRefre(ConvertJavaToFromArray.parseInt(id));
        prof.setTypPrfsnProf(ConvertJavaToFromArray.parseInt(typ));
        prof.setPreProf(pre);
        prof.setNomProf(nom);
        return prof;
    }

    public static FactFraisDepla210.LieuDepla.LieuDeparDepla.LieuDeplaPhys getTypIdLieuPhysDepla(String id, String typ) {
        FactFraisDepla210.LieuDepla.LieuDeparDepla.LieuDeplaPhys typIdLieuPhysDep = of.createFactFraisDepla210LieuDeplaLieuDeparDeplaLieuDeplaPhys();
        boolean has1val = false;
        if (id.length() > 0) {
            typIdLieuPhysDep.setIdLieuPhys(id);
            has1val = true;
        }
        if (typ.length() > 0) {
            typIdLieuPhysDep.setTypIdLieuPhys(typ);
            has1val = true;
        }
        if (has1val) {
            return typIdLieuPhysDep;
        }
        return null;
    }

    public static TypIdLieuPhys getTypIdLieuPhys(String id, String typ) {
        TypIdLieuPhys typIdLieuPhys = of.createTypIdLieuPhys();
        boolean has1val = false;
        if (id.length() > 0) {
            typIdLieuPhys.setIdLieuPhys(id);
            has1val = true;
        }
        if (typ.length() > 0) {
            typIdLieuPhys.setTypIdLieuPhys(typ);
            has1val = true;
        }
        if (has1val) {
            return typIdLieuPhys;
        }
        return null;
    }

    public static TypIdLieuPhys getTypIdLieuPhys(Entente entente, String id, String typ, String codPre, String codSect, String noSect) {
        TypIdLieuPhys typIdLieuPhys = null;
        if (Entente.OMNI.equals((Object)entente)) {
            typIdLieuPhys = of.createTypLieuPhysOmni();
        } else if (Entente.SPEC.equals((Object)entente)) {
            typIdLieuPhys = of.createTypLieuPhysSpec();
        }
        if (typIdLieuPhys != null) {
            boolean has1val = false;
            if (id.length() > 0) {
                typIdLieuPhys.setIdLieuPhys(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                typIdLieuPhys.setTypIdLieuPhys(typ);
                has1val = true;
            }
            if (codPre.length() > 0) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((TypLieuPhysOmni)typIdLieuPhys).setCodPreciLieu(of.createTypLieuPhysOmniCodPreciLieu(codPre));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((TypLieuPhysSpec)typIdLieuPhys).setCodPreciLieu(of.createTypLieuPhysSpecCodPreciLieu(codPre));
                }
                has1val = true;
            }
            if (codSect.length() > 0 && !"0".equals(codSect)) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((TypLieuPhysOmni)typIdLieuPhys).setCodPreciSectActiv(of.createTypLieuPhysOmniCodPreciSectActiv(ConvertJavaToFromArray.getInt(codSect)));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((TypLieuPhysSpec)typIdLieuPhys).setCodPreciSectActiv(of.createTypLieuPhysSpecCodPreciSectActiv(ConvertJavaToFromArray.getInt(codSect)));
                }
                has1val = true;
            }
            if (noSect.length() > 0) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((TypLieuPhysOmni)typIdLieuPhys).setNoSectActiv(of.createTypLieuPhysOmniNoSectActiv(ConvertJavaToFromArray.getInt(noSect)));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((TypLieuPhysSpec)typIdLieuPhys).setNoSectActiv(of.createTypLieuPhysSpecNoSectActiv(ConvertJavaToFromArray.getInt(noSect)));
                }
                has1val = true;
            }
            if (has1val) {
                return typIdLieuPhys;
            }
        }
        return null;
    }

    public static TypIdLieuPhys getTypIdLieuRefrePhys(Entente entente, String id, String typ, String codPre, String codSect, String noSect) {
        if (Entente.OMNI.equals((Object)entente)) {
            TypLieuRefrePhysOmni l = of.createTypLieuRefrePhysOmni();
            boolean has1val = false;
            if (id.length() > 0) {
                l.setIdLieuPhys(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                l.setTypIdLieuPhys(typ);
                has1val = true;
            }
            if (codPre.length() > 0 && !"0".equals(codPre.trim()) && codPre.length() == 1) {
                l.setCodPreciLieu(of.createTypLieuRefrePhysOmniCodPreciLieu(codPre));
                has1val = true;
            }
            if (codSect.length() > 0 && !"0".equals(codSect.trim())) {
                l.setCodPreciSectActiv(of.createTypLieuRefrePhysOmniCodPreciSectActiv(ConvertJavaToFromArray.getInt(codSect)));
                has1val = true;
            }
            if (noSect.length() > 0) {
                l.setNoSectActiv(of.createTypLieuRefrePhysOmniNoSectActiv(ConvertJavaToFromArray.getInt(noSect)));
                has1val = true;
            }
            if (has1val) {
                return l;
            }
        } else if (Entente.SPEC.equals((Object)entente)) {
            TypLieuRefrePhysSpec l = of.createTypLieuRefrePhysSpec();
            boolean has1val = false;
            if (id.length() > 0) {
                l.setIdLieuPhys(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                l.setTypIdLieuPhys(typ);
                has1val = true;
            }
            if (codPre.length() > 0 && !"0".equals(codPre.trim()) && codPre.length() == 1) {
                l.setCodPreciLieu(of.createTypLieuRefrePhysOmniCodPreciLieu(codPre));
                has1val = true;
            }
            if (codSect.length() > 0 && !"0".equals(codSect.trim())) {
                l.setCodPreciSectActiv(of.createTypLieuRefrePhysOmniCodPreciSectActiv(ConvertJavaToFromArray.getInt(codSect)));
                has1val = true;
            }
            if (noSect.length() > 0) {
                l.setNoSectActiv(of.createTypLieuRefrePhysOmniNoSectActiv(ConvertJavaToFromArray.getInt(noSect)));
                has1val = true;
            }
            if (has1val) {
                return l;
            }
        }
        return null;
    }

    public static TypIdLieuGeo getTypIdLieuGeo(String id, String typ) {
        TypIdLieuGeo typIdLieuGeo = of.createTypIdLieuGeo();
        boolean has1val = false;
        if (id.length() > 0) {
            typIdLieuGeo.setIdLieuGeo(id);
            has1val = true;
        }
        if (typ.length() > 0) {
            typIdLieuGeo.setTypIdLieuGeo(typ);
            has1val = true;
        }
        if (has1val) {
            return typIdLieuGeo;
        }
        return null;
    }

    public static TypIdLieuGeoDepla getTypIdLieuGeoDepla(String id, String typ) {
        TypIdLieuGeoDepla typIdLieuGeo = of.createTypIdLieuGeoDepla();
        boolean has1val = false;
        if (id.length() > 0) {
            typIdLieuGeo.setIdLieuGeo(id);
            has1val = true;
        }
        if (typ.length() > 0) {
            typIdLieuGeo.setTypIdLieuGeo(typ);
            has1val = true;
        }
        if (has1val) {
            return typIdLieuGeo;
        }
        return null;
    }

    public static TypIdLieuGeo getTypIdLieuRefreGeo(Entente entente, String id, String typ, String typLieu, String codPre) {
        boolean has1val = false;
        if (Entente.OMNI.equals((Object)entente)) {
            TypLieuRefreOmni.ListeLieuRefre.LieuRefreGeo l = of.createTypLieuRefreOmniListeLieuRefreLieuRefreGeo();
            if (id.length() > 0) {
                l.setIdLieuGeo(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                l.setTypIdLieuGeo(typ);
                has1val = true;
            }
            if (typLieu.length() > 0 && !"0".equals(typLieu)) {
                l.setTypLieuGeo(typLieu);
                has1val = true;
            }
            if (codPre.length() > 0 && !"0".equals(codPre) && codPre.length() == 1) {
                l.setCodPreciLieu(of.createTypLieuGeoOmniCodPreciLieu(codPre));
                has1val = true;
            }
            if (has1val) {
                return l;
            }
        } else if (Entente.SPEC.equals((Object)entente)) {
            TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo l = of.createTypLieuRefreSpecListeLieuRefreLieuRefreGeo();
            if (id.length() > 0) {
                l.setIdLieuGeo(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                l.setTypIdLieuGeo(typ);
                has1val = true;
            }
            if (typLieu.length() > 0 && !"0".equals(typLieu)) {
                l.setTypLieuGeo(typLieu);
                has1val = true;
            }
            if (codPre.length() > 0 && !"0".equals(codPre) && codPre.length() == 1) {
                l.setCodPreciLieu(of.createTypLieuGeoOmniCodPreciLieu(codPre));
                has1val = true;
            }
            if (has1val) {
                return l;
            }
        }
        return null;
    }

    public static TypIdLieuGeo getTypIdLieuGeo(Entente entente, String id, String typ, String typLieu, String codPre) {
        TypIdLieuGeo typIdLieuGeo = null;
        if (Entente.OMNI.equals((Object)entente)) {
            typIdLieuGeo = of.createTypLieuGeoOmni();
        } else if (Entente.SPEC.equals((Object)entente)) {
            typIdLieuGeo = of.createTypLieuGeoSpec();
        }
        if (typIdLieuGeo != null) {
            boolean has1val = false;
            if (id.length() > 0) {
                typIdLieuGeo.setIdLieuGeo(id);
                has1val = true;
            }
            if (typ.length() > 0) {
                typIdLieuGeo.setTypIdLieuGeo(typ);
                has1val = true;
            }
            if (typLieu.length() > 0) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((TypLieuGeoOmni)typIdLieuGeo).setTypLieuGeo(typLieu);
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((TypLieuGeoSpec)typIdLieuGeo).setTypLieuGeo(typLieu);
                }
                has1val = true;
            }
            if (codPre.length() > 0) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((TypLieuGeoOmni)typIdLieuGeo).setCodPreciLieu(of.createTypLieuGeoOmniCodPreciLieu(codPre));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((TypLieuGeoSpec)typIdLieuGeo).setCodPreciLieu(of.createTypLieuGeoSpecCodPreciLieu(codPre));
                }
                has1val = true;
            }
            if (has1val) {
                return typIdLieuGeo;
            }
        }
        return null;
    }

    public static TypLieuRefreGeoOmni getTypLieuRefreGeoOmni(String id, String typ) {
        TypLieuRefreGeoOmni lieu = of.createTypLieuRefreGeoOmni();
        lieu.setIdLieuGeo(id);
        lieu.setTypIdLieuGeo(typ);
        return lieu;
    }

    public static TypLieuRefreGeoSpec getTypLieuRefreGeoSpec(String id, String typ) {
        TypLieuRefreGeoSpec lieu = of.createTypLieuRefreGeoSpec();
        lieu.setIdLieuGeo(id);
        lieu.setTypIdLieuGeo(typ);
        return lieu;
    }

    protected static String toArrayString(int level, TypDem.Demdr d) {
        JoinList arr = new JoinList(N[level]);
        if (d == null) {
            arr.add("");
            arr.add("");
        } else {
            arr.add(ConvertJavaToFromArray.isN(d.getIdIntvn()));
            arr.add(ConvertJavaToFromArray.isN(d.getTypIdIntvn()));
        }
        return arr.toString();
    }

    protected static TypDem.Demdr fromArrayString(String arr, int level, TypDem.Demdr demdr) {
        String[] s = ConvertJavaToFromArray.split(arr, SN[level]);
        boolean added = false;
        if (s[0].length() > 0) {
            demdr.setIdIntvn(s[0]);
            added = true;
        }
        if (s[1].length() > 0) {
            demdr.setTypIdIntvn(s[1]);
            added = true;
        }
        return added ? demdr : null;
    }

    protected static String toArrayString(int level, TypDem.ExpedDifrnDemdr d) {
        JoinList arr = new JoinList(N[level]);
        arr.add(ConvertJavaToFromArray.isN(d.getIdIntvn()));
        arr.add(ConvertJavaToFromArray.isN(d.getTypIdIntvn()));
        return arr.toString();
    }

    protected static TypDem.ExpedDifrnDemdr fromArrayString(String arr, int level, TypDem.ExpedDifrnDemdr exp) {
        String[] s = ConvertJavaToFromArray.split(arr, SN[level]);
        boolean added = false;
        if (s.length == 2) {
            if (s[0].length() > 0) {
                exp.setIdIntvn(s[0]);
                added = true;
            }
            if (s[1].length() > 0) {
                exp.setTypIdIntvn(s[1]);
                added = true;
            }
        }
        return added ? exp : null;
    }

    protected static String toArrayString(int level, TypLigneFactRecev.ListeMsgExplRecev listeMsgExplRecev) {
        if (listeMsgExplRecev != null) {
            JoinList a2 = new JoinList(N[level]);
            List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecev.getMsgExplRecev();
            if (!msgExplRecev.isEmpty()) {
                for (TypMsgExplRecev explRecev : msgExplRecev) {
                    JoinList a3 = new JoinList(N[level + 1]);
                    a3.add(ConvertJavaToFromArray.isN(explRecev.getCodMsgExplRecev()));
                    a3.add(explRecev.getTxtMsgExplRecev());
                    a2.add(a3.toString());
                }
            }
            return a2.toString();
        }
        return "";
    }

    protected static TypLigneFactRecev.ListeMsgExplRecev fromArrayString(String arr, int level, TypLigneFactRecev.ListeMsgExplRecev listeMsgExplRecev) {
        String[] a2;
        boolean added = false;
        if (listeMsgExplRecev != null && (a2 = ConvertJavaToFromArray.split(arr, N[level])).length > 0 && a2[0].length() > 0) {
            String[] stringArray = a2;
            int n = a2.length;
            int n2 = 0;
            while (n2 < n) {
                String aa2 = stringArray[n2];
                String[] a3 = ConvertJavaToFromArray.split(aa2, N[level + 1]);
                TypMsgExplRecev msgExpl = of.createTypMsgExplRecev();
                msgExpl.setCodMsgExplRecev(new BigInteger(a3[0]));
                msgExpl.setTxtMsgExplRecev(a3[1]);
                listeMsgExplRecev.getMsgExplRecev().add(msgExpl);
                added = true;
                ++n2;
            }
        }
        return added ? listeMsgExplRecev : null;
    }

    protected static String toArrayString(int level, TypLogclFact l) {
        JoinList arr = new JoinList(N[level]);
        arr.add(String.valueOf(l.getNoDevprLogcl()));
        arr.add(ConvertJavaToFromArray.isN(mapStringAbbr.get(l.getNomDevprLogcl())));
        arr.add(ConvertJavaToFromArray.isN(mapStringAbbr.get(l.getNomLogclFact())));
        arr.add(ConvertJavaToFromArray.isN(l.getNoVersiLogclFact()));
        arr.add(ConvertJavaToFromArray.isN(l.getNoVersiXmlDem()));
        return arr.toString();
    }

    protected static void toArray(JoinList arr, TypIdLieu lieu) {
        if (lieu != null) {
            if (lieu instanceof TypIdLieuPhys) {
                TypIdLieuPhys lieuPhysique = (TypIdLieuPhys)lieu;
                arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuPhys()));
                arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuPhys()));
            } else if (lieu instanceof TypIdLieuGeoDepla) {
                TypIdLieuGeoDepla lieuPhysique = (TypIdLieuGeoDepla)lieu;
                arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuGeo()));
                arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuGeo()));
            }
        } else {
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuRefrePhysOmni lieuPhysique) {
        if (lieuPhysique != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isS(lieuPhysique.getCodPreciLieu()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getCodPreciSectActiv()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getNoSectActiv()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuRefrePhysSpec lieuPhysique) {
        if (lieuPhysique != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isS(lieuPhysique.getCodPreciLieu()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getCodPreciSectActiv()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getNoSectActiv()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypIdLieuGeo lieuGeo) {
        if (lieuGeo != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypIdLieuGeo()));
        } else {
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuRefreGeoOmni lieuGeo) {
        if (lieuGeo != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getTypLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getCodPreciLieu()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuRefreGeoSpec lieuGeo) {
        if (lieuGeo != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getTypLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getCodPreciLieu()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuPhysOmni lieuPhysique) {
        if (lieuPhysique != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isS(lieuPhysique.getCodPreciLieu()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getCodPreciSectActiv()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getNoSectActiv()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuGeoOmni lieuGeo) {
        if (lieuGeo != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getCodPreciLieu()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuPhysSpec lieuPhysique) {
        if (lieuPhysique != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getTypIdLieuPhys()));
            arr.add(ConvertJavaToFromArray.isS(lieuPhysique.getCodPreciLieu()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getCodPreciSectActiv()));
            arr.add(ConvertJavaToFromArray.isN(lieuPhysique.getNoSectActiv()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static void toArray(JoinList arr, TypLieuGeoSpec lieuGeo) {
        if (lieuGeo != null) {
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypIdLieuGeo()));
            arr.add(ConvertJavaToFromArray.isN(lieuGeo.getTypLieuGeo()));
            arr.add(ConvertJavaToFromArray.isS(lieuGeo.getCodPreciLieu()));
        } else {
            arr.add("");
            arr.add("");
            arr.add("");
            arr.add("");
        }
    }

    protected static TypLogclFact fromArrayString(String arr, int level, TypLogclFact log) {
        String[] s = ConvertJavaToFromArray.split(arr, SN[level]);
        log.setNoDevprLogcl(ConvertJavaToFromArray.parseInt(s[0]));
        log.setNomDevprLogcl(mapString.get(s[1]));
        log.setNomLogclFact(mapString.get(s[2]));
        log.setNoVersiLogclFact(s[3]);
        log.setNoVersiXmlDem(s[4]);
        return log;
    }

    public static Object getPersPatn(int level, Entente entente, int typePerson, String[] persIdData, String[] adrss, String[] persRep, String typSituConsi, String[] lstDx, String[] evenePers, String[] datesES, String imc) {
        TypInfoMdcalPers110 typInfoMedCal = of.createTypInfoMdcalPers110();
        TypInfoMdcalPers110.ListeDiagnMdcal lstDxMdcal = of.createTypInfoMdcalPers110ListeDiagnMdcal();
        String[] stringArray = lstDx;
        int n = lstDx.length;
        int n2 = 0;
        while (n2 < n) {
            String dxs = stringArray[n2];
            String[] dx = ConvertJavaToFromArray.split(dxs, SN[level + 1]);
            if (dx.length == 2) {
                TypDiagnMdcal110 dxMd = of.createTypDiagnMdcal110();
                int parseInt = ConvertJavaToFromArray.parseInt(dx[0]);
                dxMd.setNoSeqSysCla(parseInt == 0 ? 12 : parseInt);
                dxMd.setCodDiagnMdcal(dx[1]);
                lstDxMdcal.getDiagnMdcal().add(dxMd);
            }
            ++n2;
        }
        if (lstDxMdcal.getDiagnMdcal().size() > 0) {
            typInfoMedCal.setListeDiagnMdcal(lstDxMdcal);
        }
        if (evenePers != null && evenePers.length == 2) {
            TypInfoMdcalPers110.EvenePersObjetFact typEvenePersFact = of.createTypInfoMdcalPers110EvenePersObjetFact();
            typEvenePersFact.setTypEvenePers(evenePers[0]);
            typEvenePersFact.setDatEvenePers(dataFactory.newXMLGregorianCalendar(evenePers[1]));
            typInfoMedCal.setEvenePersObjetFact(typEvenePersFact);
        }
        if (datesES != null && datesES.length > 0 && !datesES[0].isEmpty()) {
            TypInfoMdcalPers110.PerSejPersLieu perSejPersLieu = of.createTypInfoMdcalPers110PerSejPersLieu();
            perSejPersLieu.setDatEntrePersLieu(of.createTypInfoMdcalPersPerSejPersLieuDatEntrePersLieu(dataFactory.newXMLGregorianCalendar(datesES[0])));
            if (datesES.length == 2 && !datesES[1].isEmpty()) {
                perSejPersLieu.setDatSortiPersLieu(of.createTypInfoMdcalPersPerSejPersLieuDatSortiPersLieu(dataFactory.newXMLGregorianCalendar(datesES[1])));
            }
            typInfoMedCal.setPerSejPersLieu(perSejPersLieu);
        }
        Object personPatient = null;
        if (typePerson == ArrPersType.AVEC_ID.getVal()) {
            if (Entente.OMNI.equals((Object)entente)) {
                FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt.InfoMdcalPers infoMdCalPers = of.createFactServMdcalOmni210ListePersObjetFactPersPatntAvecIdtInfoMdcalPers();
                FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt patnAvecId = of.createFactServMdcalOmni210ListePersObjetFactPersPatntAvecIdt();
                patnAvecId.setIdPers(persIdData[0]);
                patnAvecId.setTypIdPers(ConvertJavaToFromArray.getInt(persIdData[1]));
                patnAvecId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                infoMdCalPers.setEvenePersObjetFact(typInfoMedCal.getEvenePersObjetFact());
                infoMdCalPers.setListeDiagnMdcal(typInfoMedCal.getListeDiagnMdcal());
                infoMdCalPers.setPerSejPersLieu(typInfoMedCal.getPerSejPersLieu());
                patnAvecId.setInfoMdcalPers(infoMdCalPers);
                personPatient = patnAvecId;
            } else if (Entente.SPEC.equals((Object)entente)) {
                FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt patnAvecId = of.createFactServMdcalSpec210ListePersObjetFactPersPatntAvecIdt();
                patnAvecId.setIdPers(persIdData[0]);
                patnAvecId.setTypIdPers(ConvertJavaToFromArray.getInt(persIdData[1]));
                patnAvecId.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                patnAvecId.setInfoMdcalPers(typInfoMedCal);
                if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)imc)) {
                    patnAvecId.setValImcPatnt(of.createFactServMdcalSpec210ListePersObjetFactPersPatntAvecIdtValImcPatnt(ConvertJavaToFromArray.getBigDecimal(imc)));
                }
                personPatient = patnAvecId;
            }
        } else if (typePerson == ArrPersType.SANS_ID.getVal()) {
            TypPersPatntSansIdt typPersPatntSansIdt = null;
            if (Entente.OMNI.equals((Object)entente)) {
                typPersPatntSansIdt = of.createFactServMdcalOmni210ListePersObjetFactPersPatntSansIdt();
            } else if (Entente.SPEC.equals((Object)entente)) {
                typPersPatntSansIdt = of.createFactServMdcalSpec210ListePersObjetFactPersPatntSansIdt();
                if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)imc)) {
                    ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setValImcPatnt(of.createFactServMdcalSpec210ListePersObjetFactPersPatntSansIdtValImcPatnt(ConvertJavaToFromArray.getBigDecimal(imc)));
                }
            }
            if (typPersPatntSansIdt != null) {
                Integer codeSexeInt;
                TypPersPatntSansIdt.InfoPersPatnt infoPersPatnt = of.createTypPersPatntSansIdtInfoPersPatnt();
                infoPersPatnt.setNomPers(persIdData[0]);
                if (!persIdData[1].isEmpty()) {
                    infoPersPatnt.setPrePers(of.createTypInfoPersPatntPrePers(persIdData[1]));
                }
                if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)persIdData[2])) {
                    infoPersPatnt.setDatNaissPers(dataFactory.newXMLGregorianCalendar(persIdData[2]));
                }
                if ((codeSexeInt = ConvertJavaToFromArray.getInt(persIdData[3])) == null) {
                    codeSexeInt = new Integer(1);
                }
                infoPersPatnt.setCodSexePers(codeSexeInt);
                String noOrderNaiss = persIdData[4];
                if (!noOrderNaiss.isEmpty()) {
                    infoPersPatnt.setNoOrdreNaissPers(of.createTypPersPatntSansIdtInfoPersPatntNoOrdreNaissPers(ConvertJavaToFromArray.getInt(noOrderNaiss)));
                }
                infoPersPatnt.setNas(of.createTypPersPatntSansIdtInfoPersPatntNas(ConvertJavaToFromArray.getBigInt(persIdData[5])));
                typPersPatntSansIdt.setInfoPersPatnt(infoPersPatnt);
                if (adrss != null && adrss.length == 4) {
                    TypAdr typAdr = of.createTypAdr();
                    boolean isEmpty = true;
                    if (!adrss[0].isEmpty()) {
                        isEmpty = false;
                        typAdr.setAdrLigne1(adrss[0]);
                    }
                    if (!isEmpty) {
                        if (!adrss[1].isEmpty()) {
                            typAdr.setAdrLigne2(of.createTypAdrAdrLigne2(adrss[1]));
                        }
                        if (!adrss[2].isEmpty()) {
                            typAdr.setAdrLigne3(of.createTypAdrAdrLigne3(adrss[2]));
                        }
                        if (!adrss[3].isEmpty()) {
                            typAdr.setCodPostl(adrss[3]);
                        }
                        typPersPatntSansIdt.setAdrPersPatnt(of.createTypPersPatntSansIdtAdrPersPatnt(typAdr));
                    }
                }
                if (persRep != null) {
                    if (PersRepdn_enum.REPDN_AVEC_IDT.getVal() == ConvertJavaToFromArray.parseInt(persRep[0]) && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)persRep[1])) {
                        TypPersRepdn typPersRepdn = of.createTypPersRepdn();
                        typPersRepdn.setIdPers(persRep[1]);
                        typPersRepdn.setTypIdPers(ConvertJavaToFromArray.getInt(persRep[2]));
                        if (Entente.OMNI.equals((Object)entente)) {
                            FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn = of.createFactServMdcalOmni210ListePersObjetFactPersPatntSansIdtPersRepdn();
                            persRepdn.setRepdnAvecIdt(typPersRepdn);
                            ((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setPersRepdn(persRepdn);
                        } else if (Entente.SPEC.equals((Object)entente)) {
                            FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn = of.createFactServMdcalSpec210ListePersObjetFactPersPatntSansIdtPersRepdn();
                            persRepdn.setRepdnAvecIdt(typPersRepdn);
                            ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setPersRepdn(persRepdn);
                        }
                    } else if (PersRepdn_enum.REPDN_SANS_IDT.getVal() == ConvertJavaToFromArray.parseInt(persRep[0]) && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)persRep[1]) && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)persRep[2])) {
                        TypInfoPers persRepdnRepdnSansIdt = null;
                        if (Entente.OMNI.equals((Object)entente)) {
                            persRepdnRepdnSansIdt = of.createFactServMdcalOmni210ListePersObjetFactPersPatntSansIdtPersRepdnRepdnSansIdt();
                        } else if (Entente.SPEC.equals((Object)entente)) {
                            persRepdnRepdnSansIdt = of.createFactServMdcalSpec210ListePersObjetFactPersPatntSansIdtPersRepdnRepdnSansIdt();
                        }
                        if (persRepdnRepdnSansIdt != null) {
                            persRepdnRepdnSansIdt.setNomPers(persRep[1]);
                            persRepdnRepdnSansIdt.setPrePers(persRep[2]);
                            if (!persRep[3].isEmpty()) {
                                JAXBElement<XMLGregorianCalendar> datNaissPers = of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(persRep[3]));
                                persRepdnRepdnSansIdt.setDatNaissPers(datNaissPers);
                            }
                            if (!persRep[4].isEmpty()) {
                                JAXBElement<Integer> codSexePers = of.createTypInfoPersCodSexePers(ConvertJavaToFromArray.getInt(persRep[4]));
                                persRepdnRepdnSansIdt.setCodSexePers(codSexePers);
                            }
                            if (Entente.OMNI.equals((Object)entente)) {
                                FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn = of.createFactServMdcalOmni210ListePersObjetFactPersPatntSansIdtPersRepdn();
                                persRepdn.setRepdnSansIdt((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt.PersRepdn.RepdnSansIdt)persRepdnRepdnSansIdt);
                                ((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setPersRepdn(persRepdn);
                            } else if (Entente.SPEC.equals((Object)entente)) {
                                FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn = of.createFactServMdcalSpec210ListePersObjetFactPersPatntSansIdtPersRepdn();
                                persRepdn.setRepdnSansIdt((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt.PersRepdn.RepdnSansIdt)persRepdnRepdnSansIdt);
                                ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setPersRepdn(persRepdn);
                            }
                        }
                    }
                }
                typPersPatntSansIdt.setTypSituConsi(ConvertJavaToFromArray.parseInt(typSituConsi));
                if (Entente.OMNI.equals((Object)entente)) {
                    ((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setInfoMdcalPers(typInfoMedCal);
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)typPersPatntSansIdt).setInfoMdcalPers(typInfoMedCal);
                }
            }
            personPatient = typPersPatntSansIdt;
        } else if (typePerson == ArrPersType.AUTRE_AVEC_ID.getVal()) {
            TypIdPersAutre autreAvecId = null;
            if (Entente.OMNI.equals((Object)entente)) {
                autreAvecId = of.createFactServMdcalOmni210ListePersObjetFactPersAutreAvecIdt();
            } else if (Entente.SPEC.equals((Object)entente)) {
                autreAvecId = of.createFactServMdcalSpec210ListePersObjetFactPersAutreAvecIdt();
            }
            if (autreAvecId != null) {
                if (Entente.OMNI.equals((Object)entente)) {
                    ((FactServMdcalOmni210.ListePersObjetFact.PersAutreAvecIdt)autreAvecId).setTypPersAutre(of.createFactServMdcalOmni210ListePersObjetFactPersAutreAvecIdtTypPersAutre(ConvertJavaToFromArray.getInt(persIdData[0])));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((FactServMdcalSpec210.ListePersObjetFact.PersAutreAvecIdt)autreAvecId).setTypPersAutre(of.createFactServMdcalSpec210ListePersObjetFactPersAutreAvecIdtTypPersAutre(ConvertJavaToFromArray.getInt(persIdData[0])));
                }
                autreAvecId.setTypIdPersAutre(ConvertJavaToFromArray.getInt(persIdData[1]));
                autreAvecId.setIdPersAutre(persIdData[2]);
            }
            personPatient = autreAvecId;
        } else if (typePerson == ArrPersType.AUTRE_SANS_ID.getVal()) {
            TypInfoPers autreSansId = null;
            if (Entente.OMNI.equals((Object)entente)) {
                autreSansId = of.createFactServMdcalOmni210ListePersObjetFactPersAutreSansIdt();
            } else if (Entente.SPEC.equals((Object)entente)) {
                autreSansId = of.createFactServMdcalSpec210ListePersObjetFactPersAutreSansIdt();
            }
            if (autreSansId != null) {
                autreSansId.setNomPers(persIdData[0]);
                autreSansId.setPrePers(persIdData[1]);
                if (StringUtils.isNotEmpty((String)persIdData[2])) {
                    autreSansId.setDatNaissPers(of.createTypInfoPersDatNaissPers(dataFactory.newXMLGregorianCalendar(persIdData[2])));
                }
                autreSansId.setCodSexePers(of.createTypInfoPersCodSexePers(ConvertJavaToFromArray.getInt(persIdData[3])));
                if (Entente.OMNI.equals((Object)entente)) {
                    ((FactServMdcalOmni210.ListePersObjetFact.PersAutreSansIdt)autreSansId).setTypPersAutre(of.createFactServMdcalOmni210ListePersObjetFactPersAutreSansIdtTypPersAutre(ConvertJavaToFromArray.getInt(persIdData[4])));
                } else if (Entente.SPEC.equals((Object)entente)) {
                    ((FactServMdcalSpec210.ListePersObjetFact.PersAutreSansIdt)autreSansId).setTypPersAutre(of.createFactServMdcalSpec210ListePersObjetFactPersAutreSansIdtTypPersAutre(ConvertJavaToFromArray.getInt(persIdData[4])));
                }
            }
            personPatient = autreSansId;
        }
        return personPatient;
    }

    public static boolean isDec(String s) {
        return !"".equals(s);
    }

    public static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static String isN(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String isN(int s) {
        return String.valueOf(s);
    }

    public static String isN(Integer s) {
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public static String isN(BigInteger s) {
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public static String isN(BigDecimal s) {
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public static String isN(Boolean s) {
        if (s == null) {
            return "0";
        }
        return s != false ? "1" : "0";
    }

    public static String isS(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    public static String isS(JAXBElement<String> s) {
        if (s == null) {
            return "";
        }
        return (String)s.getValue();
    }

    public static String isN(JAXBElement<Integer> s) {
        if (s == null) {
            return "";
        }
        return ConvertJavaToFromArray.isN((Integer)s.getValue());
    }

    public static BigDecimal getBigDecimal(String s) {
        if ("".equals(s)) {
            return null;
        }
        return new BigDecimal(s);
    }

    public static BigInteger getBigInt(String s) {
        if ("".equals(s)) {
            return null;
        }
        return new BigInteger(s);
    }

    public static Integer getInt(String s) {
        if ("".equals(s)) {
            return null;
        }
        return new Integer(s);
    }

    public static Boolean getBooleanInteger(String string) {
        return "1".equals(string);
    }

    public static void toStringDT(JoinList arr, XMLGregorianCalendar xcal) {
        String dtS = ConvertJavaToFromArray.getDateTimeString(xcal);
        arr.add(dtS);
    }

    public static String getDateTimeString(XMLGregorianCalendar xcal) {
        if (xcal == null) {
            return "";
        }
        Calendar calInst = Calendar.getInstance();
        calInst.set(xcal.getYear(), xcal.getMonth() - 1, xcal.getDay(), xcal.getHour(), xcal.getMinute());
        Date dd = calInst.getTime();
        String dtS = dateFormatDT.format(dd);
        return dtS;
    }

    public static void toStringD(JoinList arr, XMLGregorianCalendar xcal) {
        String dateS = ConvertJavaToFromArray.getDateString(xcal);
        arr.add(dateS);
    }

    public static String getDateString(XMLGregorianCalendar xcal) {
        if (xcal == null) {
            return "";
        }
        Calendar calInst = Calendar.getInstance();
        calInst.set(xcal.getYear(), xcal.getMonth() - 1, xcal.getDay());
        Date dd = calInst.getTime();
        String dateS = dateFormatD.format(dd);
        return dateS;
    }

    protected static void addNoLigneDatServIdElmTypIdElmToTypLigneDepla(JoinList arrF4, TypLigneDepla typLigneDepla) {
        arrF4.add(ConvertJavaToFromArray.isN(typLigneDepla.getNoLigneFact()));
        ConvertJavaToFromArray.toStringD(arrF4, typLigneDepla.getDatServElmFact());
        arrF4.add(ConvertJavaToFromArray.isN(typLigneDepla.getIdElmFact()));
        arrF4.add(typLigneDepla.getTypIdElmFact());
    }

    protected static void toStringTypDiagnMdcal(int level, JoinList a5Dx, JoinList a5EvenPers, JoinList a5DatesES, TypInfoMdcalPers110 infoMdcalPers) {
        TypInfoMdcalPers110.PerSejPersLieu perSejPersLieu;
        TypInfoMdcalPers110.EvenePersObjetFact evenePersObjetFact;
        if (infoMdcalPers.getListeDiagnMdcal() != null) {
            List<TypDiagnMdcal110> diagnMdcal = infoMdcalPers.getListeDiagnMdcal().getDiagnMdcal();
            for (TypDiagnMdcal110 mdcal : diagnMdcal) {
                JoinList dxs = new JoinList(N[level]);
                dxs.add(ConvertJavaToFromArray.isN(mdcal.getNoSeqSysCla()));
                dxs.add(mdcal.getCodDiagnMdcal());
                a5Dx.add(dxs.toString());
            }
        }
        if ((evenePersObjetFact = infoMdcalPers.getEvenePersObjetFact()) != null) {
            a5EvenPers.add(evenePersObjetFact.getTypEvenePers());
            ConvertJavaToFromArray.toStringD(a5EvenPers, evenePersObjetFact.getDatEvenePers());
        }
        if ((perSejPersLieu = infoMdcalPers.getPerSejPersLieu()) != null) {
            ConvertJavaToFromArray.toStringD(a5DatesES, perSejPersLieu.getDatEntrePersLieu() == null ? null : (XMLGregorianCalendar)perSejPersLieu.getDatEntrePersLieu().getValue());
            ConvertJavaToFromArray.toStringD(a5DatesES, perSejPersLieu.getDatSortiPersLieu() == null ? null : (XMLGregorianCalendar)perSejPersLieu.getDatSortiPersLieu().getValue());
        }
    }

    public static String getDT4XMLformat(String lig) {
        String sss = String.valueOf(lig.replace(' ', 'T')) + ":00";
        return sss;
    }

    protected static String[] split(String s, String n) {
        List l = Splitter.on((String)n).splitToList((CharSequence)s);
        String[] ss = new String[l.size()];
        l.toArray(ss);
        return ss;
    }

    protected static List<TypLigneFactRecev> fromArrayString(String a2, int level, List<TypLigneFactRecev> ligneFactRecev2) {
        String[] a3 = ConvertJavaToFromArray.split(a2, SN[level]);
        if (a3.length > 0 && a3[0].length() > 0) {
            String[] stringArray = a3;
            int n = a3.length;
            int n2 = 0;
            while (n2 < n) {
                String aa3 = stringArray[n2];
                String[] a4 = ConvertJavaToFromArray.split(aa3, SN[level + 1]);
                TypLigneFactRecev typLigneFactRecev = of.createTypLigneFactRecev();
                typLigneFactRecev.setNoLigneFact(a4[0]);
                typLigneFactRecev.setStaRecev(ConvertJavaToFromArray.getBigInt(a4[1]));
                typLigneFactRecev.setMntPrel(ConvertJavaToFromArray.getBigDecimal(a4[2]));
                typLigneFactRecev.setFormuExpl(a4[3]);
                typLigneFactRecev.setListeMsgExplRecev(ConvertJavaToFromArray.fromArrayString(a4[4], level + 2, of.createTypLigneFactRecevListeMsgExplRecev()));
                ligneFactRecev2.add(typLigneFactRecev);
                ++n2;
            }
        }
        return ligneFactRecev2;
    }

    protected static String toArrayString(int level, List<TypLigneFactRecev> ligneFactRecev2) {
        JoinList a4 = new JoinList(N[level]);
        for (TypLigneFactRecev factRecev : ligneFactRecev2) {
            JoinList a5 = new JoinList(N[level + 1]);
            a5.add(ConvertJavaToFromArray.isN(factRecev.getNoLigneFact()));
            a5.add(ConvertJavaToFromArray.isN(factRecev.getStaRecev()));
            a5.add(ConvertJavaToFromArray.isN(factRecev.getMntPrel()));
            a5.add(ConvertJavaToFromArray.isN(factRecev.getFormuExpl()));
            a5.add(ConvertJavaToFromArray.isN(ConvertJavaToFromArray.toArrayString(level + 2, factRecev.getListeMsgExplRecev())));
            a4.add(a5.toString());
        }
        return a4.toString();
    }

    protected String replaceSeparators(String s) {
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[0], (String)TILDE);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[1], (String)VERT_BAR);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[2], (String)ACC_CIRC);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[3], (String)BROKEN_BAR);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[4], (String)L_STROKE);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[5], (String)I_DOTLESS);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[6], (String)I_MACRON);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[7], (String)I_SMALL_BREVE);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[8], (String)"&#302;");
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)N[9], (String)"&#302;");
        return s;
    }

    protected String resetSeparators(String s) {
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)TILDE, (String)N[0]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)VERT_BAR, (String)N[1]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)ACC_CIRC, (String)N[2]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)BROKEN_BAR, (String)N[3]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)L_STROKE, (String)N[4]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)I_DOTLESS, (String)N[5]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)I_MACRON, (String)N[6]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)I_SMALL_BREVE, (String)N[7]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)"&#302;", (String)N[8]);
        s = ca.infodata.ofys.util.StringUtils.replace((String)s, (String)"&#302;", (String)N[9]);
        return s;
    }

    public static String typeObjectToJson(CTypeObject demPaimt) {
        Map<String, Object> args = ConvertJavaToFromArray.getMappingArgs();
        String jj = JsonWriter.objectToJson((Object)demPaimt, args);
        if (Platform.inDebugMode()) {
            System.out.println(jj);
        }
        return jj;
    }

    public static Map<String, Object> getMappingArgs() {
        if (args != null) {
            return args;
        }
        args = new HashMap<String, Object>();
        args.put("DATE_FORMAT", "yyyy-MM-dd'T'HH:mm:ss");
        args.put("SHORT_META_KEYS", Boolean.TRUE);
        HashMap<Class<XMLGregorianCalendar>, XmlGregCalConverter.Serializer> mapWriters = new HashMap<Class<XMLGregorianCalendar>, XmlGregCalConverter.Serializer>();
        mapWriters.put(XMLGregorianCalendar.class, new XmlGregCalConverter.Serializer());
        args.put("CUSTOM_WRITERS", mapWriters);
        HashMap<String, String> mapTypes = new HashMap<String, String>();
        mapTypes.put("ca.infodata.syra.xsd.valid.InfoEtab$ValEtab$ListeNoEtab$NoEtab", "etblstNo");
        mapTypes.put("ca.infodata.syra.models.CValEtab", "valEtab");
        mapTypes.put("ca.infodata.syra.xsd.valid.InfoEtab$ValEtab$CalenJourFerie$ListeJourFerie$JrFerie", "etbValJrlJf");
        mapTypes.put("ca.infodata.syra.models.CTypeObject", "to");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemAnnu", "da");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemAnnuRecev", "dar");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemModif", "dm");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemModifRecu", "dmr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemPaimt", "dp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.DemPaimtRecev", "dpr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactFraisDepla210", "ffd");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210", "fsmo");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210", "fsms");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FichDem", "fd");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FichRecev", "fr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.IdFactRamq", "ifr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.IdFactRamqRecev", "ifrr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.LigneForfaDepla", "lfd");
        mapTypes.put("ca.qc.gouv.ramq.rfp.LigneFraisSej", "lfs");
        mapTypes.put("ca.qc.gouv.ramq.rfp.LigneFraisTranp", "lft");
        mapTypes.put("ca.qc.gouv.ramq.rfp.LigneTempsDepla", "ltd");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypAdr", "ta");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypDem", "td");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypDemPaimt", "tdp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypDemRecev", "tdr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypDiagnMdcal", "tdm");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypElmContx", "tec");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypElmMesur", "tem");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypEvenePersObjetFact", "tepof");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypFact", "tf");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypFactRecev", "tfr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypFraisSej", "tfs");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIdFactRamq", "tifr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIdLieu", "til");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIdLieuGeo", "tilg");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIdLieuPhys", "tilp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIdPersAutre", "tipa");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypInfoMdcalPers", "timp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypInfoPers", "tip");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypInfoPersPatnt", "tipp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypInfoRembPers", "tirp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypIntervenant", "ti");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLieuRefreGeoOmni", "tlrgo");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLieuRefreGeoSpec", "tlrgs");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLieuRefreOmni", "tlro");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLieuRefreSpec", "tlrs");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLigne", "tl");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLigneDepla", "tld");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLigneFactRecev", "tlfr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLigneServMdcal", "tlsm");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypListeFact", "tlf");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypLogclFact", "tlcf");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypMsgExplRecev", "tmer");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypPers", "tp");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypPersPatntSansIdt", "tppsi");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypPersRepdn", "tpr");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypProf", "tpf");
        mapTypes.put("ca.qc.gouv.ramq.rfp.TypProfNonConnu", "tpnc");
        mapTypes.put("java.util.ArrayList", "al");
        mapTypes.put("org.apache.xerces.jaxp.datatype.XMLGregorianCalendarImpl", "xmlGr");
        mapTypes.put("java.math.BigInteger", "bint");
        mapTypes.put("java.math.Integer", "int");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210$ListeLigneFactServMdcalSpec$LigneFactServMdcalSpec", "fmsli");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210$ListeLigneFactServMdcalSpec$LigneFactServMdcalSpec$ListeElmContx$ElmContx", "fmslflec");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210$ListeElmContx$ElmContx", "fmsleelc");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210$ListeLigneFactServMdcalOmni$LigneFactServMdcalOmni", "fmoli");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210$ListeLigneFactServMdcalOmni$LigneFactServMdcalOmni$ListeElmContx$ElmContx", "fmolflec");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210$ListeElmContx$ElmContx", "fmoleelc");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210$ListePersObjetFact$PersAutreSansIdt", "fmslppasi");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210$ListePersObjetFact$PersAutreSansIdt", "fmolppasi");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalSpec210$ListePersObjetFact$PersPatntSansIdt", "fmslpppsi");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactServMdcalOmni210$ListePersObjetFact$PersPatntSansIdt", "fmolpppsi");
        mapTypes.put("ca.qc.gouv.ramq.rfp.FactFraisDepla210$ListeElmContx$ElmContx", "fdlelc");
        mapTypes.put("ca.qc.gouv.ramq.rfp.LigneFraisTranp$ListeFraisTranp$FraisTranp", "fdlfft");
        args.put("TYPE_NAME_MAP", mapTypes);
        return args;
    }

    public static enum ArrDemType {
        DEM_PAIMT(1, "dem_paimt"),
        DEM_MODIF(2, "dem_modif"),
        DEM_ANNU(3, "dem_annu"),
        DEM_PAIMT_RECEV(4, "dem_paimt_recev"),
        DEM_MODIF_RECEV(5, "dem_modif_recev"),
        DEM_ANNU_RECEV(6, "dem_annu_recev");

        private final int val;
        private final String nameField;

        private ArrDemType(int e, String nameField) {
            this.val = e;
            this.nameField = nameField;
        }

        public int getVal() {
            return this.val;
        }

        public String getNameField() {
            return this.nameField;
        }
    }

    public static enum ArrFactType {
        TYP_FACT(1),
        FACT_SERV_MD_CAL_SPEC(2),
        FACT_SERV_MD_CAL_OMNI(3),
        FACT_FRAIS_DEPLA(4);

        private final int val;

        private ArrFactType(int e) {
            this.val = e;
        }

        public int getVal() {
            return this.val;
        }
    }

    public static enum ArrFraisType {
        LIGNE_FRAIS_TRANSPORT(1),
        LIGNE_TEMPS_DEPLA(2),
        LIGNE_FRAIS_SEJ(3),
        LIGNE_FORFA_DEPLA(4);

        private final int val;

        private ArrFraisType(int e) {
            this.val = e;
        }

        public int getVal() {
            return this.val;
        }
    }

    public static enum ArrPersType {
        AVEC_ID(1),
        SANS_ID(2),
        AUTRE_AVEC_ID(3),
        AUTRE_SANS_ID(4);

        private final int val;

        private ArrPersType(int e) {
            this.val = e;
        }

        public int getVal() {
            return this.val;
        }

        public Integer getValInt() {
            return this.val;
        }
    }

    public static class ConvertDemAnnu {
        public static final int version = 1;

        public static DemAnnu fromArrayString(String demString, DemAnnu dem) {
            String[] s = ConvertJavaToFromArray.split(demString, SN[0]);
            dem.setNoDemExt(s[2]);
            dem.setLogclFact(ConvertJavaToFromArray.fromArrayString(s[3], 1, of.createTypLogclFact()));
            dem.setExpedDifrnDemdr(ConvertJavaToFromArray.fromArrayString(s[4], 1, of.createTypDemExpedDifrnDemdr()));
            dem.setDemdr(ConvertJavaToFromArray.fromArrayString(s[5], 1, new TypDem.Demdr()));
            dem.setListeFactAAnnu(ConvertDemAnnu.ListeFactAAnnuFromArrayString(s[6], 1));
            return dem;
        }

        public static String toArrayString(DemAnnu dem) {
            JoinList a1 = new JoinList(N[0]);
            a1.add(String.valueOf(ArrDemType.DEM_ANNU.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getLogclFact()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getExpedDifrnDemdr()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getDemdr()));
            a1.add(ConvertDemAnnu.toArrayString(1, dem.getListeFactAAnnu()));
            return a1.toString();
        }

        private static String toArrayString(int level, DemAnnu.ListeFactAAnnu d) {
            JoinList a2 = new JoinList(N[level]);
            List<IdFactRamq> factRamq = d.getIdFactRamq();
            for (IdFactRamq i : factRamq) {
                JoinList a3 = new JoinList(N[level + 1]);
                a3.add(i.getNoFactRamq().toString());
                if (i.getJetonComm() == null) {
                    a3.add("");
                } else {
                    a3.add(i.getJetonComm().toString());
                }
                a2.add(a3.toString());
            }
            return a2.toString();
        }

        private static DemAnnu.ListeFactAAnnu ListeFactAAnnuFromArrayString(String arr, int level) {
            DemAnnu.ListeFactAAnnu lf = of.createDemAnnuListeFactAAnnu();
            String[] s = ConvertJavaToFromArray.split(arr, SN[level]);
            boolean added = false;
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                IdFactRamq idf = of.createIdFactRamq();
                String[] l = ConvertJavaToFromArray.split(ss, SN[level + 1]);
                boolean a = false;
                if (l[0].length() > 0) {
                    idf.setNoFactRamq(new BigInteger(l[0]));
                    a = true;
                }
                if (l[1].length() > 0) {
                    idf.setJetonComm(new BigInteger(l[1]));
                    a = true;
                }
                if (a) {
                    lf.getIdFactRamq().add(idf);
                    added = true;
                }
                ++n2;
            }
            return added ? lf : null;
        }
    }

    public static class ConvertDemAnnuRecev {
        public static final int version = 1;

        public static DemAnnuRecev fromArrayString(String demString, DemAnnuRecev dem) {
            String[] s = ConvertJavaToFromArray.split(demString, SN[0]);
            dem.setNoDemExt(s[2]);
            dem.setStaRecev(ConvertJavaToFromArray.parseInt(s[3]));
            dem.setListeFactRecev(ConvertDemAnnuRecev.fromArrayString(s[4], of.createDemAnnuRecevListeFactRecev()));
            dem.setListeMsgExplRecev(ConvertJavaToFromArray.fromArrayString(s[5], 1, of.createTypDemRecevListeMsgExplRecev()));
            return dem;
        }

        public static String toArrayString(DemAnnuRecev dem) {
            JoinList a1 = new JoinList(N[0]);
            a1.add(String.valueOf(ArrDemType.DEM_ANNU_RECEV.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.isN(dem.getStaRecev()));
            a1.add(ConvertDemAnnuRecev.toArrayString(dem.getListeFactRecev()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getListeMsgExplRecev()));
            return a1.toString();
        }

        private static String toArrayString(DemAnnuRecev.ListeFactRecev d) {
            JoinList a2 = new JoinList(N[1]);
            List<DemAnnuRecev.ListeFactRecev.FactRecev> factRamq = d.getFactRecev();
            for (DemAnnuRecev.ListeFactRecev.FactRecev i : factRamq) {
                JoinList a3 = new JoinList(N[2]);
                a3.add(ConvertJavaToFromArray.isN(i.getCodEtaTraitFact()));
                a3.add(ConvertJavaToFromArray.toArrayString(new JoinList(N[3]), i.getIdFactRamqRecev()));
                a3.add(ConvertDemAnnuRecev.toArrayString(i.getListeMsgExplRecev()));
                a2.add(a3.toString());
            }
            return a2.toString();
        }

        private static DemAnnuRecev.ListeFactRecev fromArrayString(String arr, DemAnnuRecev.ListeFactRecev lf) {
            String[] a2 = ConvertJavaToFromArray.split(arr, SN[1]);
            boolean added = false;
            if (a2.length > 0 && a2[0].length() > 0) {
                String[] stringArray = a2;
                int n = a2.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa2 = stringArray[n2];
                    String[] a3 = ConvertJavaToFromArray.split(aa2, SN[2]);
                    DemAnnuRecev.ListeFactRecev.FactRecev factRecev = of.createDemAnnuRecevListeFactRecevFactRecev();
                    factRecev.setCodEtaTraitFact(ConvertJavaToFromArray.parseInt(a3[0]));
                    if (a3.length > 1) {
                        factRecev.setIdFactRamqRecev(ConvertJavaToFromArray.fromArrayString(ConvertJavaToFromArray.split(a3[1], SN[3]), of.createIdFactRamqRecev()));
                        if (a3.length > 2) {
                            factRecev.setListeMsgExplRecev(ConvertDemAnnuRecev.fromArrayString(a3[2], of.createDemAnnuRecevListeFactRecevFactRecevListeMsgExplRecev()));
                        }
                    }
                    lf.getFactRecev().add(factRecev);
                    added = true;
                    ++n2;
                }
            }
            return added ? lf : null;
        }

        private static String toArrayString(DemAnnuRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            if (listeMsgExplRecev != null) {
                JoinList a4 = new JoinList(N[3]);
                List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecev.getMsgExplRecev();
                if (!msgExplRecev.isEmpty()) {
                    for (TypMsgExplRecev explRecev : msgExplRecev) {
                        JoinList a5 = new JoinList(N[4]);
                        a5.add(ConvertJavaToFromArray.isN(explRecev.getCodMsgExplRecev()));
                        a5.add(explRecev.getTxtMsgExplRecev());
                        a4.add(a5.toString());
                    }
                }
                return a4.toString();
            }
            return "";
        }

        private static DemAnnuRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev fromArrayString(String a3, DemAnnuRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            String[] a4 = ConvertJavaToFromArray.split(a3, SN[3]);
            boolean added = false;
            if (a4.length > 0 && a4[0].length() > 0) {
                String[] stringArray = a4;
                int n = a4.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa4 = stringArray[n2];
                    String[] a5 = ConvertJavaToFromArray.split(aa4, SN[4]);
                    TypMsgExplRecev msgExpl = of.createTypMsgExplRecev();
                    msgExpl.setCodMsgExplRecev(new BigInteger(a5[0]));
                    msgExpl.setTxtMsgExplRecev(a5[1]);
                    listeMsgExplRecev.getMsgExplRecev().add(msgExpl);
                    added = true;
                    ++n2;
                }
            }
            return added ? listeMsgExplRecev : null;
        }
    }

    public static class ConvertDemModif {
        public static final int version = 1;

        public static DemModif fromArrayString(String demString, DemModif dem) {
            String[] s = ConvertJavaToFromArray.split(demString, SN[0]);
            dem.setNoDemExt(s[2]);
            dem.setLogclFact(ConvertJavaToFromArray.fromArrayString(s[3], 1, of.createTypLogclFact()));
            dem.setExpedDifrnDemdr(ConvertJavaToFromArray.fromArrayString(s[4], 1, of.createTypDemExpedDifrnDemdr()));
            dem.setDemdr(ConvertJavaToFromArray.fromArrayString(s[5], 1, of.createTypDemDemdr()));
            dem.setIdFactRamq(ConvertDemModif.fromArrayString(s[6], of.createIdFactRamq()));
            if (s[7].length() > 0) {
                dem.setFactAModif(ConvertDemModif.fromArrayString(s[7], 1, of.createDemModifFactAModif(), dem.getLogclFact()));
            }
            return dem;
        }

        public static String toArrayString(DemModif dem) {
            JoinList a1 = new JoinList(N[0]);
            a1.add(String.valueOf(ArrDemType.DEM_ANNU.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getLogclFact()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getExpedDifrnDemdr()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getDemdr()));
            a1.add(ConvertDemModif.toArrayString(dem.getIdFactRamq()));
            a1.add(ConvertDemModif.toArrayString(dem.getFactAModif()));
            return a1.toString();
        }

        private static String toArrayString(DemModif.FactAModif factAModif) {
            if (factAModif != null) {
                DemPaimt.ListeFact listeFact = of.createDemPaimtListeFact();
                listeFact.setFactBase(factAModif.getFactBase());
                return ConvertDemPaimt.toArrayString(1, (TypFact)factAModif.getFactBase().getValue());
            }
            return "";
        }

        private static DemModif.FactAModif fromArrayString(String arr, int level, DemModif.FactAModif factAModif, TypLogclFact log) {
            DemPaimt.ListeFact lstFact = ConvertDemPaimt.fromArrayString(arr, level, of.createDemPaimtListeFact(), log);
            if (lstFact.getFactBase() != null) {
                factAModif.setFactBase(lstFact.getFactBase());
            }
            return factAModif;
        }

        private static String toArrayString(IdFactRamq idFactRamq) {
            JoinList a2 = new JoinList(N[1]);
            a2.add(ConvertJavaToFromArray.isN(idFactRamq.getNoFactRamq()));
            if (idFactRamq.getJetonComm() != null) {
                a2.add(ConvertJavaToFromArray.isN(idFactRamq.getJetonComm()));
            } else {
                a2.add("");
            }
            return a2.toString();
        }

        protected static IdFactRamq fromArrayString(String arr, IdFactRamq idFactRamq) {
            String[] s = ConvertJavaToFromArray.split(arr, SN[1]);
            boolean added = false;
            if (s[0].length() > 0) {
                idFactRamq.setNoFactRamq(new BigInteger(s[0]));
                added = true;
            }
            if (s[1].length() > 0) {
                idFactRamq.setJetonComm(new BigInteger(s[1]));
                added = true;
            }
            return added ? idFactRamq : null;
        }
    }

    public static class ConvertDemModifRecev {
        public static final int version = 1;

        public static String toArrayString(DemModifRecev dem) {
            int level = 0;
            JoinList a1 = new JoinList(N[level]);
            int l2 = level + 1;
            int l3 = level + 2;
            a1.add(String.valueOf(ArrDemType.DEM_ANNU_RECEV.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.isN(dem.getStaRecev()));
            if (dem.getFactRecev() != null) {
                a1.add(ConvertDemModifRecev.toArrayString(l2, dem.getFactRecev()));
            } else {
                a1.add("");
            }
            if (dem.getListeMsgExplRecev() != null) {
                a1.add(ConvertJavaToFromArray.toArrayString(l2, dem.getListeMsgExplRecev()));
            } else {
                a1.add("");
            }
            if (dem.getFactVersiCourn() != null) {
                DemModifRecev.FactVersiCourn factVersiCourn = (DemModifRecev.FactVersiCourn)dem.getFactVersiCourn().getValue();
                JoinList a2 = new JoinList(N[l2]);
                if (factVersiCourn != null) {
                    a2.add(ConvertJavaToFromArray.toArrayString(new JoinList(N[l3]), factVersiCourn.getIdFactRamqRecev()));
                    if (factVersiCourn.getFactBase() != null) {
                        a2.add(ConvertDemPaimt.toArrayString(l3, (TypFact)factVersiCourn.getFactBase().getValue()));
                    } else {
                        a2.add("");
                    }
                }
                a1.add(a2.toString());
            } else {
                a1.add("");
            }
            return a1.toString();
        }

        public static DemModifRecev fromArrayString(String demString, DemModifRecev dem, TypLogclFact log) {
            int level = 0;
            String[] s = ConvertJavaToFromArray.split(demString, SN[level]);
            int l2 = level + 1;
            int l3 = level + 2;
            dem.setNoDemExt(s[2]);
            dem.setStaRecev(ConvertJavaToFromArray.parseInt(s[3]));
            dem.setFactRecev(ConvertDemModifRecev.fromArrayString(s[4], l2, of.createDemModifRecevFactRecev()));
            dem.setListeMsgExplRecev(ConvertJavaToFromArray.fromArrayString(s[5], l2, of.createTypDemRecevListeMsgExplRecev()));
            if (s[6].length() > 0) {
                String[] a2 = ConvertJavaToFromArray.split(s[6], SN[l2]);
                DemModifRecev.FactVersiCourn factVersiCourn = of.createDemModifRecevFactVersiCourn();
                factVersiCourn.setIdFactRamqRecev(ConvertJavaToFromArray.fromArrayString(ConvertJavaToFromArray.split(a2[0], SN[l3]), of.createIdFactRamqRecev()));
                factVersiCourn.setFactBase(ConvertDemModifRecev.fromArrayString(a2[1], l3, of.createDemPaimtListeFact(), log));
                dem.setFactVersiCourn(of.createDemModifRecevFactVersiCourn(factVersiCourn));
            }
            return dem;
        }

        private static JAXBElement<? extends TypFact> fromArrayString(String arr, int level, DemPaimt.ListeFact listFact, TypLogclFact log) {
            DemPaimt.ListeFact lstFact = ConvertDemPaimt.fromArrayString(arr, level, listFact, log);
            if (lstFact.getFactBase() != null) {
                return lstFact.getFactBase();
            }
            return null;
        }

        private static String toArrayString(int level, DemModifRecev.FactRecev factRecev) {
            JoinList a2 = new JoinList(N[level]);
            a2.add(ConvertJavaToFromArray.isN(factRecev.getStaRecev()));
            a2.add(ConvertJavaToFromArray.toArrayString(new JoinList(N[level + 1]), factRecev.getIdFactRamqRecev()));
            a2.add(ConvertDemModifRecev.toArrayString(level + 1, factRecev.getListeLigneFactRecev()));
            a2.add(ConvertDemModifRecev.toArrayString(level + 1, factRecev.getListeMsgExplRecev()));
            return a2.toString();
        }

        private static DemModifRecev.FactRecev fromArrayString(String arr, int level, DemModifRecev.FactRecev lf) {
            boolean added = false;
            String[] a2 = ConvertJavaToFromArray.split(arr, SN[level]);
            if (a2.length > 0 && a2[0].length() > 0) {
                lf.setStaRecev(ConvertJavaToFromArray.parseInt(a2[0]));
                lf.setIdFactRamqRecev(ConvertJavaToFromArray.fromArrayString(ConvertJavaToFromArray.split(a2[1], N[level + 1]), of.createIdFactRamqRecev()));
                DemModifRecev.FactRecev.ListeLigneFactRecev ligneFactRecev = of.createDemModifRecevFactRecevListeLigneFactRecev();
                ConvertJavaToFromArray.fromArrayString(a2[2], level + 1, ligneFactRecev.getLigneFactRecev());
                lf.setListeLigneFactRecev(ligneFactRecev);
                lf.setListeMsgExplRecev(ConvertDemModifRecev.fromArrayString(a2[3], level + 1, of.createDemModifRecevFactRecevListeMsgExplRecev()));
                added = true;
            }
            return added ? lf : null;
        }

        private static String toArrayString(int level, DemModifRecev.FactRecev.ListeLigneFactRecev ligneFactRecev) {
            if (ligneFactRecev != null && !ligneFactRecev.getLigneFactRecev().isEmpty()) {
                return ConvertJavaToFromArray.toArrayString(level, ligneFactRecev.getLigneFactRecev());
            }
            return "";
        }

        private static String toArrayString(int level, DemModifRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            if (listeMsgExplRecev != null) {
                JoinList a4 = new JoinList(N[level]);
                List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecev.getMsgExplRecev();
                if (!msgExplRecev.isEmpty()) {
                    for (TypMsgExplRecev explRecev : msgExplRecev) {
                        JoinList a5 = new JoinList(N[level + 1]);
                        a5.add(ConvertJavaToFromArray.isN(explRecev.getCodMsgExplRecev()));
                        a5.add(explRecev.getTxtMsgExplRecev());
                        a4.add(a5.toString());
                    }
                }
                return a4.toString();
            }
            return "";
        }

        private static DemModifRecev.FactRecev.ListeMsgExplRecev fromArrayString(String a3, int level, DemModifRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            String[] a4 = ConvertJavaToFromArray.split(a3, SN[level]);
            boolean added = false;
            if (a4.length > 0 && a4[0].length() > 0) {
                String[] stringArray = a4;
                int n = a4.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa4 = stringArray[n2];
                    String[] a5 = ConvertJavaToFromArray.split(aa4, SN[level + 1]);
                    TypMsgExplRecev msgExpl = of.createTypMsgExplRecev();
                    msgExpl.setCodMsgExplRecev(new BigInteger(a5[0]));
                    msgExpl.setTxtMsgExplRecev(a5[1]);
                    listeMsgExplRecev.getMsgExplRecev().add(msgExpl);
                    added = true;
                    ++n2;
                }
            }
            return added ? listeMsgExplRecev : null;
        }
    }

    public static class ConvertDemPaimt {
        public static final int version = 1;

        public static DemPaimt fromArrayString(String demString, DemPaimt dem) {
            return ConvertDemPaimt.fromArrayString(demString, dem, 0);
        }

        public static DemPaimt fromArrayString(String demString, DemPaimt dem, int level) {
            String[] s = ConvertJavaToFromArray.split(demString, SN[level++]);
            dem.setNoDemExt(s[2]);
            dem.setLogclFact(ConvertJavaToFromArray.fromArrayString(s[3], level, of.createTypLogclFact()));
            dem.setExpedDifrnDemdr(ConvertJavaToFromArray.fromArrayString(s[4], level, of.createTypDemExpedDifrnDemdr()));
            dem.setDemdr(ConvertJavaToFromArray.fromArrayString(s[5], level, new TypDem.Demdr()));
            dem.setListeFact(ConvertDemPaimt.fromArrayString(s[6], level, of.createDemPaimtListeFact(), dem.getLogclFact()));
            dem.setModaPaimt(ConvertDemPaimt.fromArrayString(s[7], level, of.createTypDemPaimtModaPaimt()));
            return dem;
        }

        public static String toArrayString(DemPaimt dem) {
            return ConvertDemPaimt.toArrayString(dem, 0);
        }

        public static String toArrayString(DemPaimt dem, int level) {
            JoinList a1 = new JoinList(N[level++]);
            a1.add(String.valueOf(ArrDemType.DEM_PAIMT.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.toArrayString(level, dem.getLogclFact()));
            a1.add(ConvertJavaToFromArray.toArrayString(level, dem.getExpedDifrnDemdr()));
            a1.add(ConvertJavaToFromArray.toArrayString(level, dem.getDemdr()));
            if (dem.getListeFact().getFactBase() != null) {
                a1.add(ConvertDemPaimt.toArrayString(level, (TypFact)dem.getListeFact().getFactBase().getValue()));
            } else {
                a1.add("");
            }
            a1.add(ConvertDemPaimt.toArrayString(level, dem.getModaPaimt()));
            return a1.toString();
        }

        private static String toArrayString(int level, TypDemPaimt.ModaPaimt d) {
            JoinList arr = new JoinList(N[level++]);
            arr.add(d == null || d.getNoCpteAdmin() == null ? "" : ConvertJavaToFromArray.isN((Integer)d.getNoCpteAdmin().getValue()));
            arr.add(d == null ? "" : ConvertJavaToFromArray.isN(String.valueOf(d.getTypModaPaimt())));
            return arr.toString();
        }

        protected static TypDemPaimt.ModaPaimt fromArrayString(String arr, int level, TypDemPaimt.ModaPaimt mp) {
            String[] s = ConvertJavaToFromArray.split(arr, SN[level++]);
            boolean added = false;
            if (s[0].length() > 0) {
                mp.setNoCpteAdmin(of.createTypDemPaimtModaPaimtNoCpteAdmin(Integer.valueOf(s[0])));
                added = true;
            }
            if (s[1].length() > 0) {
                mp.setTypModaPaimt(ConvertJavaToFromArray.parseInt(s[1]));
                added = true;
            }
            return added ? mp : null;
        }

        protected static String toArrayString(int level, TypFact d) {
            JoinList a2 = new JoinList(N[level]);
            ++level;
            int l3 = level++;
            int l4 = level++;
            int l5 = level++;
            int l6 = level++;
            ++level;
            a2.add(ConvertJavaToFromArray.isN(d.getNoFactExt()));
            JoinList arrProf = new JoinList(N[l3]);
            arrProf.add(ConvertJavaToFromArray.isN(d.getProf().getIdProf()));
            arrProf.add(String.valueOf(d.getProf().getTypIdProf()));
            a2.add(arrProf.toString());
            if (d instanceof FactFraisDepla210) {
                FactFraisDepla210 ffd = (FactFraisDepla210)d;
                a2.add(String.valueOf(ArrFactType.FACT_FRAIS_DEPLA.getVal()));
                FactFraisDepla210.LieuDepla.LieuDeparDepla lieuDeparDepla = ffd.getLieuDepla().getLieuDeparDepla();
                ConvertJavaToFromArray.toArray(a2, lieuDeparDepla.getLieuDeplaGeo());
                ConvertJavaToFromArray.toArray(a2, lieuDeparDepla.getLieuDeplaPhys());
                FactFraisDepla210.LieuDepla.LieuArrivDepla lieuArrDepla = ffd.getLieuDepla().getLieuArrivDepla();
                ConvertJavaToFromArray.toArray(a2, lieuArrDepla.getLieuDeplaGeo());
                ConvertJavaToFromArray.toArray(a2, lieuArrDepla.getLieuDeplaPhys());
                XMLGregorianCalendar xcalDep = ffd.getLieuDepla().getDhDeparDepla();
                ConvertJavaToFromArray.toStringDT(a2, xcalDep);
                XMLGregorianCalendar xcalArr = ffd.getLieuDepla().getDhArrivDepla();
                ConvertJavaToFromArray.toStringDT(a2, xcalArr);
                if (ffd.getListeElmContx() != null && ffd.getListeElmContx().getElmContx().size() > 0) {
                    JoinList a3 = new JoinList(N[l3]);
                    List<FactFraisDepla210.ListeElmContx.ElmContx> list = ffd.getListeElmContx().getElmContx();
                    for (FactFraisDepla210.ListeElmContx.ElmContx elmContx2 : list) {
                        if (elmContx2.getCodElmContx() == 0) continue;
                        a3.add(String.valueOf(elmContx2.getCodElmContx()));
                    }
                    a2.add(a3.toString());
                } else {
                    a2.add("");
                }
                if (ffd.getListeLigneFraisForfa() != null && ffd.getListeLigneFraisForfa().getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej() != null && ffd.getListeLigneFraisForfa().getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().size() > 0) {
                    List<TypLigneDepla> ligneFraisSej = ffd.getListeLigneFraisForfa().getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej();
                    JoinList joinList = new JoinList(N[l3]);
                    for (TypLigneDepla typLigneDepla : ligneFraisSej) {
                        JoinList a5;
                        List<TypElmContx> elmContx2;
                        JoinList a4 = new JoinList(N[l4]);
                        if (typLigneDepla instanceof LigneFraisSej) {
                            a4.add(ConvertJavaToFromArray.isN(ArrFraisType.LIGNE_FRAIS_SEJ.getVal()));
                            ConvertJavaToFromArray.addNoLigneDatServIdElmTypIdElmToTypLigneDepla(a4, typLigneDepla);
                            LigneFraisSej ligneFraisSej2 = (LigneFraisSej)typLigneDepla;
                            a4.add(ligneFraisSej2.getListeFraisSej().getFraisSej().getTypFraisSej());
                            a4.add(ConvertJavaToFromArray.isN(ligneFraisSej2.getListeFraisSej().getFraisSej().getMntFrais()));
                            if (ligneFraisSej2.getListeElmContx() != null && ligneFraisSej2.getListeElmContx().getElmContx().size() > 0) {
                                elmContx2 = ligneFraisSej2.getListeElmContx().getElmContx();
                                a5 = new JoinList(N[l5]);
                                for (TypElmContx elmContx3 : elmContx2) {
                                    if (elmContx3.getCodElmContx() == 0) continue;
                                    a5.add(ConvertJavaToFromArray.isN(elmContx3.getCodElmContx()));
                                }
                                a4.add(a5.toString());
                            } else {
                                a4.add("");
                            }
                        } else if (typLigneDepla instanceof LigneFraisTranp) {
                            a4.add(ConvertJavaToFromArray.isN(ArrFraisType.LIGNE_FRAIS_TRANSPORT.getVal()));
                            ConvertJavaToFromArray.addNoLigneDatServIdElmTypIdElmToTypLigneDepla(a4, typLigneDepla);
                            LigneFraisTranp ligneFraisTranp = (LigneFraisTranp)typLigneDepla;
                            a4.add(ConvertJavaToFromArray.isN(ligneFraisTranp.getCodMoyenTranpUtil()));
                            a4.add(ConvertJavaToFromArray.isN((Integer)ligneFraisTranp.getNbrKmAller().getValue()));
                            if (ligneFraisTranp.getListeFraisTranp() != null && ligneFraisTranp.getListeFraisTranp().getFraisTranp().size() > 0) {
                                List<LigneFraisTranp.ListeFraisTranp.FraisTranp> fraisTranp = ligneFraisTranp.getListeFraisTranp().getFraisTranp();
                                a5 = new JoinList(N[l5]);
                                for (LigneFraisTranp.ListeFraisTranp.FraisTranp fraisTranp2 : fraisTranp) {
                                    JoinList a6 = new JoinList(N[l6]);
                                    a6.add(fraisTranp2.getTypFraisTranp());
                                    a6.add(ConvertJavaToFromArray.isN(fraisTranp2.getMntFrais()));
                                    a5.add(a6.toString());
                                }
                                a4.add(a5.toString());
                            } else {
                                a4.add("");
                            }
                            if (ligneFraisTranp.getListeElmContx() != null && ligneFraisTranp.getListeElmContx().getElmContx().size() > 0) {
                                List<LigneFraisTranp.ListeElmContx.ElmContx> elmContx3 = ligneFraisTranp.getListeElmContx().getElmContx();
                                a5 = new JoinList(N[l5]);
                                for (LigneFraisTranp.ListeElmContx.ElmContx elmContx4 : elmContx3) {
                                    if (elmContx4.getCodElmContx() == 0) continue;
                                    a5.add(ConvertJavaToFromArray.isN(elmContx4.getCodElmContx()));
                                }
                                a4.add(a5.toString());
                            } else {
                                a4.add("");
                            }
                        } else if (typLigneDepla instanceof LigneForfaDepla) {
                            a4.add(ConvertJavaToFromArray.isN(ArrFraisType.LIGNE_FORFA_DEPLA.getVal()));
                            ConvertJavaToFromArray.addNoLigneDatServIdElmTypIdElmToTypLigneDepla(a4, typLigneDepla);
                            LigneForfaDepla ligneForfaDepla = (LigneForfaDepla)typLigneDepla;
                            if (ligneForfaDepla.getListeElmContx() != null && ligneForfaDepla.getListeElmContx().getElmContx().size() > 0) {
                                elmContx2 = ligneForfaDepla.getListeElmContx().getElmContx();
                                a5 = new JoinList(N[l5]);
                                for (TypElmContx elmContx3 : elmContx2) {
                                    if (elmContx3.getCodElmContx() == 0) continue;
                                    a5.add(ConvertJavaToFromArray.isN(elmContx3.getCodElmContx()));
                                }
                                a4.add(a5.toString());
                            } else {
                                a4.add("");
                            }
                        } else if (typLigneDepla instanceof LigneTempsDepla) {
                            a4.add(ConvertJavaToFromArray.isN(ArrFraisType.LIGNE_TEMPS_DEPLA.getVal()));
                            ConvertJavaToFromArray.addNoLigneDatServIdElmTypIdElmToTypLigneDepla(a4, typLigneDepla);
                            LigneTempsDepla ligneTempsDepla = (LigneTempsDepla)typLigneDepla;
                            a4.add(ConvertJavaToFromArray.isN(ligneTempsDepla.getCodMoyenTranpUtil()));
                            a4.add(ConvertJavaToFromArray.isN((Integer)ligneTempsDepla.getNbrKmAller().getValue()));
                            a4.add(ConvertJavaToFromArray.isN((Integer)ligneTempsDepla.getNbrKmRetou().getValue()));
                            a4.add(ConvertJavaToFromArray.isN((BigDecimal)ligneTempsDepla.getNbrHreAtten().getValue()));
                            a4.add(ConvertJavaToFromArray.isN((BigDecimal)ligneTempsDepla.getNbrHreDepla().getValue()));
                            if (ligneTempsDepla.getListeElmContx() != null && ligneTempsDepla.getListeElmContx().getElmContx().size() > 0) {
                                List<LigneTempsDepla.ListeElmContx.ElmContx> elmContx4 = ligneTempsDepla.getListeElmContx().getElmContx();
                                a5 = new JoinList(N[l5]);
                                for (LigneTempsDepla.ListeElmContx.ElmContx elmContx5 : elmContx4) {
                                    if (elmContx5.getCodElmContx() == 0) continue;
                                    a5.add(ConvertJavaToFromArray.isN(elmContx5.getCodElmContx()));
                                }
                                a4.add(a5.toString());
                            } else {
                                a4.add("");
                            }
                        } else {
                            a4.add("");
                        }
                        joinList.add(a4.toString());
                    }
                    a2.add(joinList.toString());
                } else {
                    a2.add("");
                }
            } else if (d instanceof FactServMdcalSpec210) {
                JoinList a3;
                List<FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec> ligneFactServMdcalSpec;
                List<FactServMdcalSpec210.ListeElmContx.ElmContx> elmContx;
                FactServMdcalSpec210 sm = (FactServMdcalSpec210)d;
                a2.add(String.valueOf(ArrFactType.FACT_SERV_MD_CAL_SPEC.getVal()));
                ConvertJavaToFromArray.toArray(a2, sm.getLieuConsi().getLieuGeo());
                ConvertJavaToFromArray.toArray(a2, sm.getLieuConsi().getLieuPhys());
                if (sm.getIndFactAssocDr() != null) {
                    a2.add(ConvertJavaToFromArray.isN((Boolean)sm.getIndFactAssocDr().getValue()));
                } else {
                    a2.add("");
                }
                JoinList a3d = new JoinList(N[l3]);
                if (sm.getDhdInterAutreMd() != null) {
                    ConvertJavaToFromArray.toStringDT(a3d, (XMLGregorianCalendar)sm.getDhdInterAutreMd().getValue());
                } else {
                    a3d.add("");
                }
                if (sm.getDhdPerTravProf() != null) {
                    ConvertJavaToFromArray.toStringDT(a3d, (XMLGregorianCalendar)sm.getDhdPerTravProf().getValue());
                } else {
                    a3d.add("");
                }
                a2.add(a3d.toString());
                List<FactServMdcalSpec210.ListeElmContx.ElmContx> list = elmContx = sm.getListeElmContx() == null ? null : sm.getListeElmContx().getElmContx();
                if (elmContx != null && elmContx.size() > 0) {
                    JoinList a32 = new JoinList(N[l3]);
                    for (FactServMdcalSpec210.ListeElmContx.ElmContx elmContx2 : elmContx) {
                        JoinList joinList = new JoinList(N[l4]);
                        joinList.add(ConvertJavaToFromArray.isN(elmContx2.getCodElmContx()));
                        if (elmContx2.getCodFactLieElmContx() != null) {
                            joinList.add(ConvertJavaToFromArray.isN((BigInteger)elmContx2.getCodFactLieElmContx().getValue()));
                        } else {
                            joinList.add("");
                        }
                        a32.add(joinList.toString());
                    }
                    a2.add(a32.toString());
                } else {
                    a2.add("");
                }
                List<FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec> list2 = ligneFactServMdcalSpec = sm.getListeLigneFactServMdcalSpec() == null ? null : sm.getListeLigneFactServMdcalSpec().getLigneFactServMdcalSpec();
                if (ligneFactServMdcalSpec != null && ligneFactServMdcalSpec.size() > 0) {
                    a3 = new JoinList(N[l3]);
                    for (FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec lig : ligneFactServMdcalSpec) {
                        List<TypElmMesur> list3;
                        List<FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx> elmContx2;
                        List<Object> lieuRefreGeo;
                        JoinList a4 = new JoinList(N[l4]);
                        a4.add(ConvertJavaToFromArray.isN(lig.getNoLigneFact()));
                        ConvertJavaToFromArray.toStringD(a4, lig.getDatServElmFact());
                        if (lig.getDhdElmFact() != null && lig.getDhdElmFact().getValue() != null) {
                            ConvertJavaToFromArray.toStringDT(a4, (XMLGregorianCalendar)lig.getDhdElmFact().getValue());
                            if (lig.getDhfElmFact() != null && lig.getDhfElmFact().getValue() != null) {
                                ConvertJavaToFromArray.toStringDT(a4, (XMLGregorianCalendar)lig.getDhfElmFact().getValue());
                            } else {
                                a4.add("");
                            }
                        } else {
                            a4.add("");
                            a4.add("");
                        }
                        a4.add(lig.getCodRole());
                        a4.add(ConvertJavaToFromArray.isN(lig.getCodRefreSituSpeci()));
                        a4.add(ConvertJavaToFromArray.isN(lig.getLieuEnRefre() == null ? null : new Integer(lig.getLieuEnRefre().getTypRefreLieu())));
                        List<Object> list4 = lieuRefreGeo = lig.getLieuEnRefre() == null || lig.getLieuEnRefre().getListeLieuRefre() == null ? null : lig.getLieuEnRefre().getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo();
                        if (lieuRefreGeo != null && lieuRefreGeo.size() > 0) {
                            JoinList a5 = new JoinList(N[l5]);
                            for (Object object : lieuRefreGeo) {
                                JoinList a6 = new JoinList(N[l6]);
                                if (object instanceof TypLieuRefrePhysSpec) {
                                    a6.add("C");
                                    TypLieuRefrePhysSpec tilp = (TypLieuRefrePhysSpec)object;
                                    ConvertJavaToFromArray.toArray(a6, tilp);
                                } else if (object instanceof TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo) {
                                    a6.add("N");
                                    TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo tilg = (TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo)object;
                                    ConvertJavaToFromArray.toArray(a6, tilg);
                                }
                                a5.add(a6.toString());
                            }
                            a4.add(a5.toString());
                        } else {
                            a4.add("");
                        }
                        a4.add(ConvertJavaToFromArray.isN(lig.getIdElmFact()));
                        a4.add(lig.getTypIdElmFact() == null ? "1" : lig.getTypIdElmFact());
                        List<FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx> list5 = elmContx2 = lig.getListeElmContx() == null ? null : lig.getListeElmContx().getElmContx();
                        if (elmContx2 != null && elmContx2.size() > 0) {
                            JoinList joinList = new JoinList(N[l5]);
                            for (FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx elmContx3 : elmContx2) {
                                joinList.add(ConvertJavaToFromArray.isN(elmContx3.getCodElmContx()));
                            }
                            a4.add(joinList.toString());
                        } else {
                            a4.add("");
                        }
                        List<TypElmMesur> list6 = list3 = lig.getListeElmMesur() == null ? null : lig.getListeElmMesur().getElmMesur();
                        if (list3 != null && list3.size() > 0) {
                            JoinList a5 = new JoinList(N[l5]);
                            for (TypElmMesur typElmMesur : list3) {
                                JoinList a6 = new JoinList(N[l6]);
                                a6.add(ConvertJavaToFromArray.isN(typElmMesur.getCodElmMesur()));
                                a6.add(ConvertJavaToFromArray.isN(typElmMesur.getValMes()));
                                a5.add(a6.toString());
                            }
                            a4.add(a5.toString());
                        } else {
                            a4.add("");
                        }
                        if (lig.getMntPrcuPatnt() != null) {
                            a4.add(ConvertJavaToFromArray.isN((BigDecimal)lig.getMntPrcuPatnt().getValue()));
                        } else {
                            a4.add("");
                        }
                        if (lig.getRefreAutreProf() != null) {
                            a4.add(ConvertJavaToFromArray.isN(lig.getRefreAutreProf().getTypRefreAutreProf()));
                            FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre infoProfRefre = lig.getRefreAutreProf().getInfoProfRefre();
                            if (infoProfRefre != null) {
                                JoinList a5;
                                if (infoProfRefre.getProfRefreConnu() != null && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)infoProfRefre.getProfRefreConnu().getIdProf())) {
                                    a5 = new JoinList(N[l5]);
                                    a5.add(infoProfRefre.getProfRefreConnu().getIdProf());
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreConnu().getTypIdProf()));
                                    if (lig.getRefreAutreProf().getDhDemCnsul() != null) {
                                        ConvertJavaToFromArray.toStringDT(a5, (XMLGregorianCalendar)lig.getRefreAutreProf().getDhDemCnsul().getValue());
                                    } else {
                                        a5.add("");
                                    }
                                    a4.add(a5.toString());
                                } else {
                                    a4.add("");
                                }
                                if (infoProfRefre.getProfRefreNonConnu() != null) {
                                    a5 = new JoinList(N[l5]);
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreNonConnu().getCodTerriProfRefre()));
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreNonConnu().getTypPrfsnProf()));
                                    a5.add(infoProfRefre.getProfRefreNonConnu().getPreProf());
                                    a5.add(infoProfRefre.getProfRefreNonConnu().getNomProf());
                                    if (lig.getRefreAutreProf().getDhDemCnsul() != null) {
                                        ConvertJavaToFromArray.toStringDT(a5, (XMLGregorianCalendar)lig.getRefreAutreProf().getDhDemCnsul().getValue());
                                    } else {
                                        a5.add("");
                                    }
                                    a4.add(a5.toString());
                                } else {
                                    a4.add("");
                                }
                            } else {
                                a4.add("");
                                a4.add("");
                            }
                        } else {
                            a4.add("");
                            a4.add("");
                            a4.add("");
                        }
                        if (lig.getCodOmim() != null) {
                            a4.add(((BigInteger)lig.getCodOmim().getValue()).toString());
                        } else {
                            a4.add("");
                        }
                        a3.add(a4.toString());
                    }
                    a2.add(a3.toString());
                } else {
                    a2.add("");
                }
                if (sm.getListePersObjetFact() != null) {
                    a3 = new JoinList(N[l3]);
                    List<Object> pts = sm.getListePersObjetFact().getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt();
                    if (pts.size() > 0) {
                        for (Object e : pts) {
                            Object pers;
                            JoinList a4 = new JoinList(N[l4]);
                            String ptIdType = "";
                            JoinList joinList = new JoinList(N[l5]);
                            JoinList a5Addr = new JoinList(N[l5]);
                            JoinList a5PersRep = new JoinList(N[l5]);
                            String typSituConsi = "";
                            JoinList a5Dx = new JoinList(N[l5]);
                            JoinList a5EvenPers = new JoinList(N[l5]);
                            JoinList a5DatesES = new JoinList(N[l5]);
                            String imc = "";
                            if (e instanceof FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt) {
                                pers = (FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AVEC_ID.getVal());
                                joinList.add(((TypPers)pers).getIdPers());
                                joinList.add(ConvertJavaToFromArray.isN(((TypPers)pers).getTypIdPers()));
                                typSituConsi = ConvertJavaToFromArray.isN(((TypPers)pers).getTypSituConsi());
                                if (((FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt)pers).getValImcPatnt() != null) {
                                    imc = ConvertJavaToFromArray.isN((BigDecimal)((FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt)pers).getValImcPatnt().getValue());
                                }
                                TypInfoMdcalPers110 infoMdcalPers = ((FactServMdcalSpec210.ListePersObjetFact.PersPatntAvecIdt)pers).getInfoMdcalPers();
                                ConvertJavaToFromArray.toStringTypDiagnMdcal(l6, a5Dx, a5EvenPers, a5DatesES, infoMdcalPers);
                            } else if (e instanceof FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt) {
                                FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn;
                                pers = (FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.SANS_ID.getVal());
                                typSituConsi = ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getTypSituConsi());
                                joinList.add(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNomPers());
                                if (((TypPersPatntSansIdt)pers).getInfoPersPatnt().getPrePers() != null) {
                                    joinList.add((String)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getPrePers().getValue());
                                } else {
                                    joinList.add("");
                                }
                                ConvertJavaToFromArray.toStringD(joinList, ((TypPersPatntSansIdt)pers).getInfoPersPatnt().getDatNaissPers());
                                joinList.add(ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getCodSexePers()));
                                if (((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNoOrdreNaissPers() != null) {
                                    joinList.add(ConvertJavaToFromArray.isN((Integer)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNoOrdreNaissPers().getValue()));
                                } else {
                                    joinList.add("");
                                }
                                joinList.add(ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNas() == null ? null : (BigInteger)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNas().getValue()));
                                if (((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)pers).getValImcPatnt() != null) {
                                    imc = ConvertJavaToFromArray.isN((BigDecimal)((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)pers).getValImcPatnt().getValue());
                                }
                                if (((TypPersPatntSansIdt)pers).getAdrPersPatnt() != null && ((TypPersPatntSansIdt)pers).getAdrPersPatnt().getValue() != null) {
                                    TypAdr typAdr = (TypAdr)((TypPersPatntSansIdt)pers).getAdrPersPatnt().getValue();
                                    if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)typAdr.getAdrLigne1())) {
                                        a5Addr.add(typAdr.getAdrLigne1());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (typAdr.getAdrLigne2() != null) {
                                        a5Addr.add((String)typAdr.getAdrLigne2().getValue());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (typAdr.getAdrLigne3() != null) {
                                        a5Addr.add((String)typAdr.getAdrLigne3().getValue());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)typAdr.getCodPostl())) {
                                        a5Addr.add(typAdr.getCodPostl());
                                    } else {
                                        a5Addr.add("");
                                    }
                                }
                                if ((persRepdn = ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)pers).getPersRepdn()) != null) {
                                    if (persRepdn.getRepdnAvecIdt() != null) {
                                        a5PersRep.add(ConvertJavaToFromArray.isN(PersRepdn_enum.REPDN_AVEC_IDT.getVal()));
                                        a5PersRep.add(persRepdn.getRepdnAvecIdt().getIdPers());
                                        a5PersRep.add(ConvertJavaToFromArray.isN(persRepdn.getRepdnAvecIdt().getTypIdPers()));
                                    } else if (persRepdn.getRepdnSansIdt() != null) {
                                        a5PersRep.add(ConvertJavaToFromArray.isN(PersRepdn_enum.REPDN_SANS_IDT.getVal()));
                                        a5PersRep.add(persRepdn.getRepdnSansIdt().getNomPers());
                                        a5PersRep.add(persRepdn.getRepdnSansIdt().getPrePers());
                                        if (persRepdn.getRepdnSansIdt().getDatNaissPers() != null) {
                                            ConvertJavaToFromArray.toStringD(a5PersRep, (XMLGregorianCalendar)persRepdn.getRepdnSansIdt().getDatNaissPers().getValue());
                                        } else {
                                            a5PersRep.add("");
                                        }
                                        if (persRepdn.getRepdnSansIdt().getCodSexePers() != null) {
                                            a5PersRep.add(ConvertJavaToFromArray.isN((Integer)persRepdn.getRepdnSansIdt().getCodSexePers().getValue()));
                                        } else {
                                            a5PersRep.add("");
                                        }
                                    }
                                }
                                TypInfoMdcalPers110 infoMdcalPers = ((FactServMdcalSpec210.ListePersObjetFact.PersPatntSansIdt)pers).getInfoMdcalPers();
                                ConvertJavaToFromArray.toStringTypDiagnMdcal(l6, a5Dx, a5EvenPers, a5DatesES, infoMdcalPers);
                            } else if (e instanceof FactServMdcalSpec210.ListePersObjetFact.PersAutreAvecIdt) {
                                pers = (FactServMdcalSpec210.ListePersObjetFact.PersAutreAvecIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AUTRE_AVEC_ID.getVal());
                                joinList.add(ConvertJavaToFromArray.isN(((FactServMdcalSpec210.ListePersObjetFact.PersAutreAvecIdt)pers).getTypPersAutre()));
                                joinList.add(ConvertJavaToFromArray.isN(((TypIdPersAutre)pers).getTypIdPersAutre()));
                                joinList.add(((TypIdPersAutre)pers).getIdPersAutre());
                            } else if (e instanceof FactServMdcalSpec210.ListePersObjetFact.PersAutreSansIdt) {
                                pers = (FactServMdcalSpec210.ListePersObjetFact.PersAutreSansIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AUTRE_SANS_ID.getVal());
                                joinList.add(((TypInfoPers)pers).getNomPers());
                                joinList.add(((TypInfoPers)pers).getPrePers());
                                if (((TypInfoPers)pers).getDatNaissPers() != null) {
                                    ConvertJavaToFromArray.toStringD(joinList, (XMLGregorianCalendar)((TypInfoPers)pers).getDatNaissPers().getValue());
                                } else {
                                    joinList.add("");
                                }
                                if (((TypInfoPers)pers).getCodSexePers() != null) {
                                    joinList.add(ConvertJavaToFromArray.isN((Integer)((TypInfoPers)pers).getCodSexePers().getValue()));
                                } else {
                                    joinList.add("");
                                }
                                joinList.add(ConvertJavaToFromArray.isN(((FactServMdcalSpec210.ListePersObjetFact.PersAutreSansIdt)pers).getTypPersAutre()));
                            }
                            a4.add(ptIdType);
                            a4.add(joinList.toString());
                            a4.add(a5Addr.toString());
                            a4.add(a5PersRep.toString());
                            a4.add(typSituConsi);
                            a4.add(a5Dx.toString());
                            a4.add(a5EvenPers.toString());
                            a4.add(a5DatesES.toString());
                            a4.add(imc);
                            a3.add(a4.toString());
                        }
                        a2.add(a3.toString());
                    } else {
                        a2.add("");
                    }
                } else {
                    a2.add("");
                }
                if (sm.getNoAutor() != null) {
                    a2.add((String)sm.getNoAutor().getValue());
                } else {
                    a2.add("");
                }
            } else if (d instanceof FactServMdcalOmni210) {
                JoinList a3;
                List<FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni> ligneFactServMdcalOmni;
                List<FactServMdcalOmni210.ListeElmContx.ElmContx> elmContx;
                FactServMdcalOmni210 sm = (FactServMdcalOmni210)d;
                a2.add(String.valueOf(ArrFactType.FACT_SERV_MD_CAL_OMNI.getVal()));
                ConvertJavaToFromArray.toArray(a2, sm.getLieuConsi().getLieuGeo());
                ConvertJavaToFromArray.toArray(a2, sm.getLieuConsi().getLieuPhys());
                if (sm.getIndFactAssocDr() != null) {
                    a2.add(ConvertJavaToFromArray.isN((Boolean)sm.getIndFactAssocDr().getValue()));
                } else {
                    a2.add("");
                }
                JoinList a3d = new JoinList(N[l3]);
                if (sm.getDhdInterAutreMd() != null) {
                    ConvertJavaToFromArray.toStringDT(a3d, (XMLGregorianCalendar)sm.getDhdInterAutreMd().getValue());
                } else {
                    a3d.add("");
                }
                if (sm.getDhdPerTravProf() != null) {
                    ConvertJavaToFromArray.toStringDT(a3d, (XMLGregorianCalendar)sm.getDhdPerTravProf().getValue());
                } else {
                    a3d.add("");
                }
                a2.add(a3d.toString());
                List<FactServMdcalOmni210.ListeElmContx.ElmContx> list = elmContx = sm.getListeElmContx() == null ? null : sm.getListeElmContx().getElmContx();
                if (elmContx != null && elmContx.size() > 0) {
                    JoinList a33 = new JoinList(N[l3]);
                    for (FactServMdcalOmni210.ListeElmContx.ElmContx elmContx2 : elmContx) {
                        JoinList joinList = new JoinList(N[l4]);
                        joinList.add(ConvertJavaToFromArray.isN(elmContx2.getCodElmContx()));
                        if (elmContx2.getCodFactLieElmContx() != null) {
                            joinList.add(ConvertJavaToFromArray.isN((BigInteger)elmContx2.getCodFactLieElmContx().getValue()));
                        } else {
                            joinList.add("");
                        }
                        a33.add(joinList.toString());
                    }
                    a2.add(a33.toString());
                } else {
                    a2.add("");
                }
                List<FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni> list7 = ligneFactServMdcalOmni = sm.getListeLigneFactServMdcalOmni() == null ? null : sm.getListeLigneFactServMdcalOmni().getLigneFactServMdcalOmni();
                if (ligneFactServMdcalOmni != null && ligneFactServMdcalOmni.size() > 0) {
                    a3 = new JoinList(N[l3]);
                    for (FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni lig : ligneFactServMdcalOmni) {
                        List<TypElmMesur> list8;
                        List<FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx> elmContx2;
                        List<TypIdLieu> lieuRefre;
                        JoinList a4 = new JoinList(N[l4]);
                        a4.add(ConvertJavaToFromArray.isN(lig.getNoLigneFact()));
                        ConvertJavaToFromArray.toStringD(a4, lig.getDatServElmFact());
                        if (lig.getDhdElmFact() != null && lig.getDhdElmFact().getValue() != null) {
                            ConvertJavaToFromArray.toStringDT(a4, (XMLGregorianCalendar)lig.getDhdElmFact().getValue());
                            if (lig.getDhfElmFact() != null && lig.getDhfElmFact().getValue() != null) {
                                ConvertJavaToFromArray.toStringDT(a4, (XMLGregorianCalendar)lig.getDhfElmFact().getValue());
                            } else {
                                a4.add("");
                            }
                        } else {
                            a4.add("");
                            a4.add("");
                        }
                        a4.add(lig.getCodRole());
                        a4.add(ConvertJavaToFromArray.isN(lig.getCodRefreSituSpeci()));
                        a4.add(ConvertJavaToFromArray.isN(lig.getLieuEnRefre() == null ? null : new Integer(lig.getLieuEnRefre().getTypRefreLieu())));
                        List<TypIdLieu> list9 = lieuRefre = lig.getLieuEnRefre() == null || lig.getLieuEnRefre().getListeLieuRefre() == null ? null : lig.getLieuEnRefre().getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo();
                        if (lieuRefre != null && lieuRefre.size() > 0) {
                            JoinList a5 = new JoinList(N[l5]);
                            for (Object e : lieuRefre) {
                                JoinList a6 = new JoinList(N[l6]);
                                if (e instanceof TypLieuRefrePhysOmni) {
                                    a6.add("C");
                                    TypLieuRefrePhysOmni tilp = (TypLieuRefrePhysOmni)e;
                                    ConvertJavaToFromArray.toArray(a6, tilp);
                                } else if (e instanceof TypLieuRefreOmni.ListeLieuRefre.LieuRefreGeo) {
                                    a6.add("N");
                                    TypLieuRefreGeoOmni tilg = (TypLieuRefreGeoOmni)e;
                                    ConvertJavaToFromArray.toArray(a6, tilg);
                                }
                                a5.add(a6.toString());
                            }
                            a4.add(a5.toString());
                        } else {
                            a4.add("");
                        }
                        a4.add(ConvertJavaToFromArray.isN(lig.getIdElmFact()));
                        a4.add(lig.getTypIdElmFact() == null ? "1" : lig.getTypIdElmFact());
                        List<FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx> list10 = elmContx2 = lig.getListeElmContx() == null ? null : lig.getListeElmContx().getElmContx();
                        if (elmContx2 != null && elmContx2.size() > 0) {
                            JoinList joinList = new JoinList(N[l5]);
                            for (FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx elmContx3 : elmContx2) {
                                joinList.add(ConvertJavaToFromArray.isN(elmContx3.getCodElmContx()));
                            }
                            a4.add(joinList.toString());
                        } else {
                            a4.add("");
                        }
                        List<TypElmMesur> list11 = list8 = lig.getListeElmMesur() == null ? null : lig.getListeElmMesur().getElmMesur();
                        if (list8 != null && list8.size() > 0) {
                            JoinList a5 = new JoinList(N[l5]);
                            for (TypElmMesur typElmMesur : list8) {
                                JoinList a6 = new JoinList(N[l6]);
                                a6.add(ConvertJavaToFromArray.isN(typElmMesur.getCodElmMesur()));
                                a6.add(ConvertJavaToFromArray.isN(typElmMesur.getValMes()));
                                a5.add(a6.toString());
                            }
                            a4.add(a5.toString());
                        } else {
                            a4.add("");
                        }
                        if (lig.getMntPrcuPatnt() != null) {
                            a4.add(ConvertJavaToFromArray.isN((BigDecimal)lig.getMntPrcuPatnt().getValue()));
                        } else {
                            a4.add("");
                        }
                        if (lig.getRefreAutreProf() != null) {
                            a4.add(ConvertJavaToFromArray.isN(lig.getRefreAutreProf().getTypRefreAutreProf()));
                            FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre infoProfRefre = lig.getRefreAutreProf().getInfoProfRefre();
                            if (infoProfRefre != null) {
                                JoinList a5;
                                if (infoProfRefre.getProfRefreConnu() != null && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)infoProfRefre.getProfRefreConnu().getIdProf())) {
                                    a5 = new JoinList(N[l5]);
                                    a5.add(infoProfRefre.getProfRefreConnu().getIdProf());
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreConnu().getTypIdProf()));
                                    a4.add(a5.toString());
                                } else {
                                    a4.add("");
                                }
                                if (infoProfRefre.getProfRefreNonConnu() != null) {
                                    a5 = new JoinList(N[l5]);
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreNonConnu().getCodTerriProfRefre()));
                                    a5.add(ConvertJavaToFromArray.isN(infoProfRefre.getProfRefreNonConnu().getTypPrfsnProf()));
                                    a5.add(infoProfRefre.getProfRefreNonConnu().getPreProf());
                                    a5.add(infoProfRefre.getProfRefreNonConnu().getNomProf());
                                    a4.add(a5.toString());
                                } else {
                                    a4.add("");
                                }
                            } else {
                                a4.add("");
                                a4.add("");
                            }
                        } else {
                            a4.add("");
                            a4.add("");
                            a4.add("");
                        }
                        a3.add(a4.toString());
                    }
                    a2.add(a3.toString());
                } else {
                    a2.add("");
                }
                if (sm.getListePersObjetFact() != null) {
                    a3 = new JoinList(N[l3]);
                    List<Object> pts = sm.getListePersObjetFact().getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt();
                    if (pts.size() > 0) {
                        for (Object e : pts) {
                            Object pers;
                            JoinList a4 = new JoinList(N[l4]);
                            String ptIdType = "";
                            JoinList joinList = new JoinList(N[l5]);
                            JoinList a5Addr = new JoinList(N[l5]);
                            JoinList a5PersRep = new JoinList(N[l5]);
                            String typSituConsi = "";
                            JoinList a5Dx = new JoinList(N[l5]);
                            JoinList a5EvenPers = new JoinList(N[l5]);
                            JoinList a5DatesES = new JoinList(N[l5]);
                            String imc = "";
                            if (e instanceof FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt) {
                                pers = (FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AVEC_ID.getVal());
                                joinList.add(((TypPers)pers).getIdPers());
                                joinList.add(ConvertJavaToFromArray.isN(((TypPers)pers).getTypIdPers()));
                                typSituConsi = ConvertJavaToFromArray.isN(((TypPers)pers).getTypSituConsi());
                                FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt.InfoMdcalPers infoMdcalPers = ((FactServMdcalOmni210.ListePersObjetFact.PersPatntAvecIdt)pers).getInfoMdcalPers();
                                ConvertJavaToFromArray.toStringTypDiagnMdcal(l6, a5Dx, a5EvenPers, a5DatesES, infoMdcalPers);
                            } else if (e instanceof FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt) {
                                FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt.PersRepdn persRepdn;
                                pers = (FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.SANS_ID.getVal());
                                typSituConsi = ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getTypSituConsi());
                                joinList.add(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNomPers());
                                if (((TypPersPatntSansIdt)pers).getInfoPersPatnt().getPrePers() != null) {
                                    joinList.add((String)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getPrePers().getValue());
                                } else {
                                    joinList.add("");
                                }
                                ConvertJavaToFromArray.toStringD(joinList, ((TypPersPatntSansIdt)pers).getInfoPersPatnt().getDatNaissPers());
                                joinList.add(ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getCodSexePers()));
                                if (((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNoOrdreNaissPers() != null) {
                                    joinList.add(ConvertJavaToFromArray.isN((Integer)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNoOrdreNaissPers().getValue()));
                                } else {
                                    joinList.add("");
                                }
                                joinList.add(ConvertJavaToFromArray.isN(((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNas() == null ? null : (BigInteger)((TypPersPatntSansIdt)pers).getInfoPersPatnt().getNas().getValue()));
                                if (((TypPersPatntSansIdt)pers).getAdrPersPatnt() != null && ((TypPersPatntSansIdt)pers).getAdrPersPatnt().getValue() != null) {
                                    TypAdr typAdr = (TypAdr)((TypPersPatntSansIdt)pers).getAdrPersPatnt().getValue();
                                    if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)typAdr.getAdrLigne1())) {
                                        a5Addr.add(typAdr.getAdrLigne1());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (typAdr.getAdrLigne2() != null) {
                                        a5Addr.add((String)typAdr.getAdrLigne2().getValue());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (typAdr.getAdrLigne3() != null) {
                                        a5Addr.add((String)typAdr.getAdrLigne3().getValue());
                                    } else {
                                        a5Addr.add("");
                                    }
                                    if (ca.infodata.ofys.util.StringUtils.isNotEmpty((String)typAdr.getCodPostl())) {
                                        a5Addr.add(typAdr.getCodPostl());
                                    } else {
                                        a5Addr.add("");
                                    }
                                }
                                if ((persRepdn = ((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)pers).getPersRepdn()) != null) {
                                    if (persRepdn.getRepdnAvecIdt() != null) {
                                        a5PersRep.add(ConvertJavaToFromArray.isN(PersRepdn_enum.REPDN_AVEC_IDT.getVal()));
                                        a5PersRep.add(persRepdn.getRepdnAvecIdt().getIdPers());
                                        a5PersRep.add(ConvertJavaToFromArray.isN(persRepdn.getRepdnAvecIdt().getTypIdPers()));
                                    } else if (persRepdn.getRepdnSansIdt() != null) {
                                        a5PersRep.add(ConvertJavaToFromArray.isN(PersRepdn_enum.REPDN_SANS_IDT.getVal()));
                                        a5PersRep.add(persRepdn.getRepdnSansIdt().getNomPers());
                                        a5PersRep.add(persRepdn.getRepdnSansIdt().getPrePers());
                                        if (persRepdn.getRepdnSansIdt().getDatNaissPers() != null) {
                                            ConvertJavaToFromArray.toStringD(a5PersRep, (XMLGregorianCalendar)persRepdn.getRepdnSansIdt().getDatNaissPers().getValue());
                                        } else {
                                            a5PersRep.add("");
                                        }
                                        if (persRepdn.getRepdnSansIdt().getCodSexePers() != null) {
                                            a5PersRep.add(ConvertJavaToFromArray.isN((Integer)persRepdn.getRepdnSansIdt().getCodSexePers().getValue()));
                                        } else {
                                            a5PersRep.add("");
                                        }
                                    }
                                }
                                TypInfoMdcalPers110 infoMdcalPers = ((FactServMdcalOmni210.ListePersObjetFact.PersPatntSansIdt)pers).getInfoMdcalPers();
                                ConvertJavaToFromArray.toStringTypDiagnMdcal(l6, a5Dx, a5EvenPers, a5DatesES, infoMdcalPers);
                            } else if (e instanceof FactServMdcalOmni210.ListePersObjetFact.PersAutreAvecIdt) {
                                pers = (FactServMdcalOmni210.ListePersObjetFact.PersAutreAvecIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AUTRE_AVEC_ID.getVal());
                                joinList.add(ConvertJavaToFromArray.isN(((FactServMdcalOmni210.ListePersObjetFact.PersAutreAvecIdt)pers).getTypPersAutre()));
                                joinList.add(ConvertJavaToFromArray.isN(((TypIdPersAutre)pers).getTypIdPersAutre()));
                                joinList.add(((TypIdPersAutre)pers).getIdPersAutre());
                            } else if (e instanceof FactServMdcalOmni210.ListePersObjetFact.PersAutreSansIdt) {
                                pers = (FactServMdcalOmni210.ListePersObjetFact.PersAutreSansIdt)e;
                                ptIdType = ConvertJavaToFromArray.isN(ArrPersType.AUTRE_SANS_ID.getVal());
                                joinList.add(((TypInfoPers)pers).getNomPers());
                                joinList.add(((TypInfoPers)pers).getPrePers());
                                if (((TypInfoPers)pers).getDatNaissPers() != null) {
                                    ConvertJavaToFromArray.toStringD(joinList, (XMLGregorianCalendar)((TypInfoPers)pers).getDatNaissPers().getValue());
                                } else {
                                    joinList.add("");
                                }
                                if (((TypInfoPers)pers).getCodSexePers() != null) {
                                    joinList.add(ConvertJavaToFromArray.isN((Integer)((TypInfoPers)pers).getCodSexePers().getValue()));
                                } else {
                                    joinList.add("");
                                }
                                joinList.add(ConvertJavaToFromArray.isN(((FactServMdcalOmni210.ListePersObjetFact.PersAutreSansIdt)pers).getTypPersAutre()));
                            }
                            a4.add(ptIdType);
                            a4.add(joinList.toString());
                            a4.add(a5Addr.toString());
                            a4.add(a5PersRep.toString());
                            a4.add(typSituConsi);
                            a4.add(a5Dx.toString());
                            a4.add(a5EvenPers.toString());
                            a4.add(a5DatesES.toString());
                            a4.add(imc);
                            a3.add(a4.toString());
                        }
                        a2.add(a3.toString());
                    } else {
                        a2.add("");
                    }
                } else {
                    a2.add("");
                }
                if (sm.getNoAutor() != null) {
                    a2.add((String)sm.getNoAutor().getValue());
                } else {
                    a2.add("");
                }
            } else {
                a2.add(String.valueOf(ArrFactType.TYP_FACT.getVal()));
            }
            return a2.toString();
        }

        protected static DemPaimt.ListeFact fromArrayString(String arr, int level, DemPaimt.ListeFact lf, TypLogclFact log) {
            TypIdLieuGeo typIdLieuGeoDep;
            Object lieuConsi;
            String[] f = ConvertJavaToFromArray.split(arr, SN[level]);
            ++level;
            int l3 = level++;
            int l4 = level++;
            int l5 = level++;
            int l6 = level++;
            ++level;
            if (ConvertJavaToFromArray.parseInt(f[2]) == ArrFactType.FACT_FRAIS_DEPLA.getVal()) {
                String[] lstLigneFraisF;
                int n;
                FactFraisDepla210 fraisDepla = of.createFactFraisDepla210();
                lf.setFactBase(of.createFactFraisDepla210(fraisDepla));
                FactFraisDepla210.LieuDepla lieuDepla = of.createFactFraisDepla210LieuDepla();
                FactFraisDepla210.LieuDepla.LieuDeparDepla deplaLieuDeplaDep = of.createFactFraisDepla210LieuDeplaLieuDeparDepla();
                TypIdLieuGeoDepla typIdLieuGeoDep2 = ConvertJavaToFromArray.getTypIdLieuGeoDepla(f[3], f[4]);
                deplaLieuDeplaDep.setLieuDeplaGeo(typIdLieuGeoDep2);
                FactFraisDepla210.LieuDepla.LieuDeparDepla.LieuDeplaPhys typIdLieuPhysDep = ConvertJavaToFromArray.getTypIdLieuPhysDepla(f[5], f[6]);
                deplaLieuDeplaDep.setLieuDeplaPhys(typIdLieuPhysDep);
                lieuDepla.setLieuDeparDepla(deplaLieuDeplaDep);
                FactFraisDepla210.LieuDepla.LieuArrivDepla deplaLieuDeplaArr = of.createFactFraisDepla210LieuDeplaLieuArrivDepla();
                TypIdLieuGeoDepla typIdLieuGeoArr = ConvertJavaToFromArray.getTypIdLieuGeoDepla(f[7], f[8]);
                deplaLieuDeplaArr.setLieuDeplaGeo(typIdLieuGeoArr);
                TypIdLieuPhys typIdLieuPhysArr = ConvertJavaToFromArray.getTypIdLieuPhys(f[9], f[10]);
                deplaLieuDeplaArr.setLieuDeplaPhys(typIdLieuPhysArr);
                lieuDepla.setLieuArrivDepla(deplaLieuDeplaArr);
                XMLGregorianCalendar calDepart = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(f[11]));
                XMLGregorianCalendar calArriv = dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(f[12]));
                lieuDepla.setDhDeparDepla(calDepart);
                lieuDepla.setDhArrivDepla(calArriv);
                fraisDepla.setLieuDepla(lieuDepla);
                String[] elmContxs = ConvertJavaToFromArray.split(f[13], SN[l3]);
                if (elmContxs.length > 0) {
                    FactFraisDepla210.ListeElmContx lstElmContx = of.createFactFraisDepla210ListeElmContx();
                    String[] stringArray = elmContxs;
                    n = elmContxs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String elmxx = stringArray[n2];
                        int iElm = ConvertJavaToFromArray.parseInt(elmxx);
                        if (iElm > 0) {
                            FactFraisDepla210.ListeElmContx.ElmContx deplaListeElmContxElmContx = of.createFactFraisDepla210ListeElmContxElmContx();
                            deplaListeElmContxElmContx.setCodElmContx(iElm);
                            lstElmContx.getElmContx().add(deplaListeElmContxElmContx);
                        }
                        ++n2;
                    }
                    if (lstElmContx.getElmContx().size() > 0) {
                        fraisDepla.setListeElmContx(lstElmContx);
                    }
                }
                if ((lstLigneFraisF = ConvertJavaToFromArray.split(f[14], SN[l3])).length > 0) {
                    FactFraisDepla210.ListeLigneFraisForfa ligneFraisF = of.createFactFraisDepla210ListeLigneFraisForfa();
                    String[] iElm = lstLigneFraisF;
                    int n3 = lstLigneFraisF.length;
                    n = 0;
                    while (n < n3) {
                        TypElmContx elmContx;
                        int iElm2;
                        String elm;
                        Object lstElmContx;
                        String[] lstListeElmContx;
                        TypElmContx elmContx2;
                        int iElm3;
                        String[] lstElmC;
                        String lff = iElm[n];
                        String[] lffs = ConvertJavaToFromArray.split(lff, SN[l4]);
                        TypLigneDepla typLigneDepla = null;
                        if (ConvertJavaToFromArray.parseInt(lffs[0]) == ArrFraisType.LIGNE_FRAIS_SEJ.getVal()) {
                            LigneFraisSej ligneFraisSej = of.createLigneFraisSej();
                            LigneFraisSej.ListeFraisSej listeFraisSej = of.createLigneFraisSejListeFraisSej();
                            TypFraisSej typFraisSej = of.createTypFraisSej();
                            typFraisSej.setTypFraisSej(lffs[5]);
                            typFraisSej.setMntFrais(ConvertJavaToFromArray.getBigDecimal(lffs[6]));
                            listeFraisSej.setFraisSej(typFraisSej);
                            ligneFraisSej.setListeFraisSej(listeFraisSej);
                            lstElmC = ConvertJavaToFromArray.split(lffs[7], SN[l5]);
                            if (lstElmC.length > 0 && !lstElmC[0].isEmpty()) {
                                LigneFraisSej.ListeElmContx lstElmContx2 = of.createLigneFraisSejListeElmContx();
                                String[] stringArray = lstElmC;
                                int n4 = lstElmC.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    String elm2 = stringArray[n5];
                                    iElm3 = ConvertJavaToFromArray.parseInt(elm2);
                                    if (iElm3 > 0) {
                                        elmContx2 = of.createLigneFraisSejListeElmContxElmContx();
                                        elmContx2.setCodElmContx(iElm3);
                                        lstElmContx2.getElmContx().add((LigneFraisSej.ListeElmContx.ElmContx)elmContx2);
                                    }
                                    ++n5;
                                }
                                if (lstElmContx2.getElmContx().size() > 0) {
                                    ligneFraisSej.setListeElmContx(lstElmContx2);
                                }
                            }
                            typLigneDepla = ligneFraisSej;
                        } else if (ConvertJavaToFromArray.parseInt(lffs[0]) == ArrFraisType.LIGNE_FRAIS_TRANSPORT.getVal()) {
                            String[] fraisTranp;
                            LigneFraisTranp ligneFraisTranp = of.createLigneFraisTranp();
                            ligneFraisTranp.setCodMoyenTranpUtil(ConvertJavaToFromArray.parseInt(lffs[5]));
                            if (lffs[6].length() > 0) {
                                ligneFraisTranp.setNbrKmAller(of.createLigneFraisTranpNbrKmAller(Integer.valueOf(lffs[6])));
                            }
                            String[] fraisTranps = ConvertJavaToFromArray.split(lffs[7], SN[l5]);
                            LigneFraisTranp.ListeFraisTranp lstFraisTranp = of.createLigneFraisTranpListeFraisTranp();
                            String[] stringArray = fraisTranps;
                            int elm2 = fraisTranps.length;
                            int lstElmContx2 = 0;
                            while (lstElmContx2 < elm2) {
                                String ftps = stringArray[lstElmContx2];
                                String[] ftpss = ConvertJavaToFromArray.split(ftps, SN[l6]);
                                fraisTranp = of.createLigneFraisTranpListeFraisTranpFraisTranp();
                                if (ftpss[0].length() > 0) {
                                    fraisTranp.setTypFraisTranp(ftpss[0]);
                                }
                                if (ftpss.length > 1) {
                                    fraisTranp.setMntFrais(ConvertJavaToFromArray.getBigDecimal(ftpss[1]));
                                }
                                if (fraisTranp.getTypFraisTranp() != null) {
                                    lstFraisTranp.getFraisTranp().add((LigneFraisTranp.ListeFraisTranp.FraisTranp)fraisTranp);
                                }
                                ++lstElmContx2;
                            }
                            ligneFraisTranp.setListeFraisTranp(lstFraisTranp);
                            lstElmC = ConvertJavaToFromArray.split(lffs[8], SN[l5]);
                            if (lstElmC.length > 0 && !lstElmC[0].isEmpty()) {
                                LigneFraisTranp.ListeElmContx lstElmContx3 = of.createLigneFraisTranpListeElmContx();
                                fraisTranp = lstElmC;
                                int ftpss = lstElmC.length;
                                int n6 = 0;
                                while (n6 < ftpss) {
                                    String elm3 = fraisTranp[n6];
                                    iElm3 = ConvertJavaToFromArray.parseInt(elm3);
                                    if (iElm3 > 0) {
                                        elmContx2 = of.createLigneFraisTranpListeElmContxElmContx();
                                        elmContx2.setCodElmContx(iElm3);
                                        lstElmContx3.getElmContx().add((LigneFraisTranp.ListeElmContx.ElmContx)elmContx2);
                                    }
                                    ++n6;
                                }
                                if (lstElmContx3.getElmContx().size() > 0) {
                                    ligneFraisTranp.setListeElmContx(lstElmContx3);
                                }
                            }
                            typLigneDepla = ligneFraisTranp;
                        } else if (ConvertJavaToFromArray.parseInt(lffs[0]) == ArrFraisType.LIGNE_FORFA_DEPLA.getVal()) {
                            LigneForfaDepla ligneForfaDepla = of.createLigneForfaDepla();
                            if (!lffs[5].isEmpty()) {
                                lstListeElmContx = ConvertJavaToFromArray.split(lffs[5], SN[l5]);
                                lstElmContx = of.createLigneForfaDeplaListeElmContx();
                                String[] stringArray = lstListeElmContx;
                                int elm3 = lstListeElmContx.length;
                                int lstElmContx3 = 0;
                                while (lstElmContx3 < elm3) {
                                    elm = stringArray[lstElmContx3];
                                    iElm2 = ConvertJavaToFromArray.parseInt(elm);
                                    if (iElm2 > 0) {
                                        elmContx = of.createLigneForfaDeplaListeElmContxElmContx();
                                        elmContx.setCodElmContx(iElm2);
                                        ((LigneForfaDepla.ListeElmContx)lstElmContx).getElmContx().add((LigneForfaDepla.ListeElmContx.ElmContx)elmContx);
                                    }
                                    ++lstElmContx3;
                                }
                                if (((LigneForfaDepla.ListeElmContx)lstElmContx).getElmContx().size() > 0) {
                                    ligneForfaDepla.setListeElmContx((LigneForfaDepla.ListeElmContx)lstElmContx);
                                }
                            }
                            typLigneDepla = ligneForfaDepla;
                        } else if (ConvertJavaToFromArray.parseInt(lffs[0]) == ArrFraisType.LIGNE_TEMPS_DEPLA.getVal()) {
                            LigneTempsDepla ligneTempsDepla = of.createLigneTempsDepla();
                            ligneTempsDepla.setCodMoyenTranpUtil(ConvertJavaToFromArray.parseInt(lffs[5]));
                            ligneTempsDepla.setNbrKmAller(of.createLigneTempsDeplaNbrKmAller(ConvertJavaToFromArray.getInt(lffs[6])));
                            ligneTempsDepla.setNbrKmRetou(of.createLigneTempsDeplaNbrKmRetou(ConvertJavaToFromArray.getInt(lffs[7])));
                            ligneTempsDepla.setNbrHreAtten(of.createLigneTempsDeplaNbrHreAtten(ConvertJavaToFromArray.getBigDecimal(lffs[8])));
                            ligneTempsDepla.setNbrHreDepla(of.createLigneTempsDeplaNbrHreDepla(ConvertJavaToFromArray.getBigDecimal(lffs[9])));
                            lstListeElmContx = ConvertJavaToFromArray.split(lffs[10], SN[l5]);
                            if (lstListeElmContx.length > 0 && !lstListeElmContx[0].isEmpty()) {
                                lstElmContx = of.createLigneTempsDeplaListeElmContx();
                                String[] stringArray = lstListeElmContx;
                                int elm3 = lstListeElmContx.length;
                                int lstElmContx3 = 0;
                                while (lstElmContx3 < elm3) {
                                    elm = stringArray[lstElmContx3];
                                    iElm2 = ConvertJavaToFromArray.parseInt(elm);
                                    if (iElm2 > 0) {
                                        elmContx = of.createLigneTempsDeplaListeElmContxElmContx();
                                        elmContx.setCodElmContx(iElm2);
                                        ((LigneTempsDepla.ListeElmContx)lstElmContx).getElmContx().add((LigneTempsDepla.ListeElmContx.ElmContx)elmContx);
                                    }
                                    ++lstElmContx3;
                                }
                                if (((LigneTempsDepla.ListeElmContx)lstElmContx).getElmContx().size() > 0) {
                                    ligneTempsDepla.setListeElmContx((LigneTempsDepla.ListeElmContx)lstElmContx);
                                }
                            }
                            typLigneDepla = ligneTempsDepla;
                        }
                        if (typLigneDepla != null) {
                            typLigneDepla.setNoLigneFact(ConvertJavaToFromArray.parseInt(lffs[1]));
                            typLigneDepla.setDatServElmFact(dataFactory.newXMLGregorianCalendar(lffs[2]));
                            typLigneDepla.setIdElmFact(ConvertJavaToFromArray.getBigInt(lffs[3]));
                            typLigneDepla.setTypIdElmFact(lffs[4]);
                            ligneFraisF.getLigneFraisTranpOrLigneTempsDeplaOrLigneFraisSej().add(typLigneDepla);
                        }
                        ++n;
                    }
                    fraisDepla.setListeLigneFraisForfa(ligneFraisF);
                }
            } else if (ConvertJavaToFromArray.parseInt(f[2]) == ArrFactType.FACT_SERV_MD_CAL_SPEC.getVal()) {
                Object lieuRefSpec;
                String[] lignes;
                String[] elmfs;
                String[] a3;
                FactServMdcalSpec210 servMdcalSpec = of.createFactServMdcalSpec210();
                lf.setFactBase(of.createFactServMdcalSpec210(servMdcalSpec));
                lieuConsi = of.createFactServMdcalSpec210LieuConsi();
                typIdLieuGeoDep = ConvertJavaToFromArray.getTypIdLieuGeo(Entente.SPEC, f[3], f[4], f[5], f[6]);
                ((FactServMdcalSpec210.LieuConsi)lieuConsi).setLieuGeo((TypLieuGeoSpec)typIdLieuGeoDep);
                TypIdLieuPhys typIdLieuPhysDep = ConvertJavaToFromArray.getTypIdLieuPhys(Entente.SPEC, f[7], f[8], f[9], f[10], f[11]);
                ((FactServMdcalSpec210.LieuConsi)lieuConsi).setLieuPhys((TypLieuPhysSpec)typIdLieuPhysDep);
                servMdcalSpec.setLieuConsi((FactServMdcalSpec210.LieuConsi)lieuConsi);
                if (!f[12].isEmpty()) {
                    Boolean indFactAssocDr = ConvertJavaToFromArray.getBooleanInteger(f[12]);
                    servMdcalSpec.setIndFactAssocDr(of.createFactServMdcalSpec210IndFactAssocDr(indFactAssocDr));
                }
                if ((a3 = ConvertJavaToFromArray.split(f[13], SN[l3]))[0].length() > 0) {
                    servMdcalSpec.setDhdInterAutreMd(of.createFactServMdcalSpec210DhdInterAutreMd(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(a3[0]))));
                }
                if (a3[1].length() > 0) {
                    servMdcalSpec.setDhdPerTravProf(of.createFactServMdcalSpec210DhdPerTravProf(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(a3[1]))));
                }
                FactServMdcalSpec210.ListeElmContx lstElmContx = of.createFactServMdcalSpec210ListeElmContx();
                String[] elmContxs = elmfs = ConvertJavaToFromArray.split(f[14], SN[l3]);
                int calArriv = elmfs.length;
                int calDepart = 0;
                while (calDepart < calArriv) {
                    String elm = elmContxs[calDepart];
                    if (!elm.isEmpty()) {
                        String[] el = ConvertJavaToFromArray.split(elm, SN[l4]);
                        FactServMdcalSpec210.ListeElmContx.ElmContx listeElmContxElmContx = of.createFactServMdcalSpec210ListeElmContxElmContx();
                        listeElmContxElmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(el[0]));
                        if (!el[1].isEmpty()) {
                            listeElmContxElmContx.setCodFactLieElmContx(of.createFactServMdcalSpec210ListeElmContxElmContxCodFactLieElmContx(new BigInteger(el[1])));
                        }
                        lstElmContx.getElmContx().add(listeElmContxElmContx);
                    }
                    ++calDepart;
                }
                servMdcalSpec.setListeElmContx(lstElmContx);
                FactServMdcalSpec210.ListeLigneFactServMdcalSpec ligneLst = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpec();
                String[] stringArray = lignes = ConvertJavaToFromArray.split(f[15], SN[l3]);
                int listeElmContxElmContx = lignes.length;
                int el = 0;
                while (el < listeElmContxElmContx) {
                    String ligne = stringArray[el];
                    if (!ligne.isEmpty()) {
                        String[] efreNonConnu;
                        String[] lx;
                        String[] lig = ConvertJavaToFromArray.split(ligne, SN[l4]);
                        FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec ligneFact = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpec();
                        ligneFact.setNoLigneFact(ConvertJavaToFromArray.parseInt(lig[0]));
                        ligneFact.setDatServElmFact(dataFactory.newXMLGregorianCalendar(lig[1]));
                        if (lig[2].length() > 0) {
                            ligneFact.setDhdElmFact(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecDhdElmFact(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(lig[2]))));
                            if (lig[3].length() > 0) {
                                ligneFact.setDhfElmFact(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecDhfElmFact(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(lig[3]))));
                            }
                        }
                        ligneFact.setCodRole(lig[4]);
                        if (ConvertJavaToFromArray.getInt(lig[5]) != null) {
                            ligneFact.setCodRefreSituSpeci(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecCodRefreSituSpeci(ConvertJavaToFromArray.getInt(lig[5])));
                        }
                        lieuRefSpec = of.createTypLieuRefreSpec();
                        Integer typeRefreLieu = ConvertJavaToFromArray.getInt(lig[6]);
                        if (typeRefreLieu != null) {
                            ((TypLieuRefreSpec)lieuRefSpec).setTypRefreLieu(typeRefreLieu);
                        }
                        String[] lieuRefs = ConvertJavaToFromArray.split(lig[7], SN[l5]);
                        TypLieuRefreSpec.ListeLieuRefre listLieuRefre = of.createTypLieuRefreSpecListeLieuRefre();
                        String[] elm22 = lieuRefs;
                        int lstElmContx4 = lieuRefs.length;
                        int lstListeElmContx = 0;
                        while (lstListeElmContx < lstElmContx4) {
                            String lieuRefI = elm22[lstListeElmContx];
                            if (!lieuRefI.isEmpty()) {
                                TypIdLieu lieu = null;
                                if (ConvertJavaToFromArray.isVer102(log)) {
                                    lx = ConvertJavaToFromArray.split(lieuRefI, SN[l6]);
                                    if ("C".equals(lx[0])) {
                                        lieu = ConvertJavaToFromArray.getTypIdLieuPhys(lx[1], lx[2]);
                                    } else if ("N".equals(lx[0])) {
                                        lieu = ConvertJavaToFromArray.getTypLieuRefreGeoSpec(lx[1], lx[2]);
                                    }
                                    if (lieu != null) {
                                        listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().add(lieu);
                                        break;
                                    }
                                } else {
                                    lx = ConvertJavaToFromArray.split(lieuRefI, SN[l6]);
                                    if ("C".equals(lx[0])) {
                                        lieu = ConvertJavaToFromArray.getTypIdLieuRefrePhys(Entente.SPEC, lx[1], lx[2], lx[3], lx[4], lx[5]);
                                    } else if ("N".equals(lx[0])) {
                                        lieu = ConvertJavaToFromArray.getTypIdLieuRefreGeo(Entente.SPEC, lx[1], lx[2], lx[3], lx[4]);
                                    }
                                    if (lieu != null) {
                                        listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().add(lieu);
                                    }
                                }
                            }
                            ++lstListeElmContx;
                        }
                        if (listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().size() > 0) {
                            ((TypLieuRefreSpec)lieuRefSpec).setListeLieuRefre(listLieuRefre);
                            ligneFact.setLieuEnRefre((TypLieuRefreSpec)lieuRefSpec);
                        }
                        ligneFact.setIdElmFact(new BigInteger(lig[8]));
                        ligneFact.setTypIdElmFact(lig[9]);
                        String[] elmls = ConvertJavaToFromArray.split(lig[10], SN[l5]);
                        FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx listLigneElmContx = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmContx();
                        lx = elmls;
                        int lieu = elmls.length;
                        int elm22 = 0;
                        while (elm22 < lieu) {
                            String el2 = lx[elm22];
                            if (!el2.isEmpty()) {
                                FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx elmContxElmContx = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmContxElmContx();
                                elmContxElmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(el2));
                                listLigneElmContx.getElmContx().add(elmContxElmContx);
                            }
                            ++elm22;
                        }
                        if (listLigneElmContx.getElmContx().size() > 0) {
                            ligneFact.setListeElmContx(listLigneElmContx);
                        }
                        String[] elmesures = ConvertJavaToFromArray.split(lig[11], SN[l5]);
                        FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmMesur listLigneElMesureContx32 = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecListeElmMesur();
                        String[] iElm = elmesures;
                        int elmContxElmContx = elmesures.length;
                        int lx2 = 0;
                        while (lx2 < elmContxElmContx) {
                            String els = iElm[lx2];
                            if (!els.isEmpty()) {
                                String[] el3 = ConvertJavaToFromArray.split(els, SN[l6]);
                                TypElmMesur typElmMesure = of.createTypElmMesur();
                                typElmMesure.setCodElmMesur(ConvertJavaToFromArray.parseInt(el3[0]));
                                typElmMesure.setValMes(ConvertJavaToFromArray.getBigDecimal(el3[1]));
                                listLigneElMesureContx32.getElmMesur().add(typElmMesure);
                            }
                            ++lx2;
                        }
                        ligneFact.setListeElmMesur(listLigneElMesureContx32);
                        if (ConvertJavaToFromArray.isDec(lig[12])) {
                            ligneFact.setMntPrcuPatnt(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecMntPrcuPatnt(ConvertJavaToFromArray.getBigDecimal(lig[12])));
                        }
                        FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf refreAutreProf = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProf();
                        if (ConvertJavaToFromArray.isInt(lig[13])) {
                            refreAutreProf.setTypRefreAutreProf(ConvertJavaToFromArray.parseInt(lig[13]));
                        }
                        FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre infoProfRefre = null;
                        String[] profRefre = ConvertJavaToFromArray.split(lig[14], SN[l5]);
                        if (profRefre.length >= 2 && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)profRefre[0])) {
                            infoProfRefre = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfInfoProfRefre();
                            infoProfRefre.setProfRefreConnu(ConvertJavaToFromArray.getTypProf(profRefre[0], profRefre[1]));
                            refreAutreProf.setInfoProfRefre(infoProfRefre);
                            if (profRefre.length >= 3 && profRefre[2].length() == 16) {
                                refreAutreProf.setDhDemCnsul(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfDhDemCnsul(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(profRefre[2]))));
                            }
                            ligneFact.setRefreAutreProf(refreAutreProf);
                        }
                        if (infoProfRefre == null && (efreNonConnu = ConvertJavaToFromArray.split(lig[15], SN[l5])).length >= 4 && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)efreNonConnu[2]) && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)efreNonConnu[3])) {
                            infoProfRefre = of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfInfoProfRefre();
                            infoProfRefre.setProfRefreNonConnu(ConvertJavaToFromArray.getTypProfNonConnu(efreNonConnu[0], efreNonConnu[1], efreNonConnu[2], efreNonConnu[3]));
                            refreAutreProf.setInfoProfRefre(infoProfRefre);
                            if (efreNonConnu.length >= 5 && efreNonConnu[4].length() == 16) {
                                refreAutreProf.setDhDemCnsul(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecRefreAutreProfDhDemCnsul(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(efreNonConnu[4]))));
                            }
                            ligneFact.setRefreAutreProf(refreAutreProf);
                        }
                        if (lig.length >= 17 && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)lig[16])) {
                            ligneFact.setCodOmim(of.createFactServMdcalSpec210ListeLigneFactServMdcalSpecLigneFactServMdcalSpecCodOmim(new BigInteger(lig[16])));
                        }
                        ligneLst.getLigneFactServMdcalSpec().add(ligneFact);
                    }
                    ++el;
                }
                if (!ligneLst.getLigneFactServMdcalSpec().isEmpty()) {
                    servMdcalSpec.setListeLigneFactServMdcalSpec(ligneLst);
                }
                String[] persObjectFacts = ConvertJavaToFromArray.split(f[16], SN[l3]);
                FactServMdcalSpec210.ListePersObjetFact listePersObjetFact = of.createFactServMdcalSpec210ListePersObjetFact();
                lieuRefSpec = persObjectFacts;
                int lig = persObjectFacts.length;
                int n = 0;
                while (n < lig) {
                    String persObjectFact = lieuRefSpec[n];
                    if (!persObjectFact.isEmpty()) {
                        String[] pofs = ConvertJavaToFromArray.split(persObjectFact, SN[l4]);
                        Object pof = null;
                        String imc = null;
                        if (pofs.length == 9) {
                            imc = pofs[8];
                        }
                        if ((pof = ConvertJavaToFromArray.getPersPatn(l5, Entente.SPEC, ConvertJavaToFromArray.parseInt(pofs[0]), ConvertJavaToFromArray.split(pofs[1], SN[l5]), ConvertJavaToFromArray.split(pofs[2], SN[l5]), ConvertJavaToFromArray.split(pofs[3], SN[l5]), pofs[4], ConvertJavaToFromArray.split(pofs[5], SN[l5]), ConvertJavaToFromArray.split(pofs[6], SN[l5]), ConvertJavaToFromArray.split(pofs[7], SN[l5]), imc)) != null) {
                            listePersObjetFact.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(pof);
                        }
                    }
                    ++n;
                }
                servMdcalSpec.setListePersObjetFact(listePersObjetFact);
                if (!f[17].isEmpty()) {
                    servMdcalSpec.setNoAutor(of.createFactServMdcalSpec210NoAutor(f[17]));
                }
            } else if (ConvertJavaToFromArray.parseInt(f[2]) == ArrFactType.FACT_SERV_MD_CAL_OMNI.getVal()) {
                String[] elmfs;
                String[] a3;
                FactServMdcalOmni210 servMdcalOmni = of.createFactServMdcalOmni210();
                lf.setFactBase(of.createFactServMdcalOmni210(servMdcalOmni));
                lieuConsi = of.createFactServMdcalOmni210LieuConsi();
                typIdLieuGeoDep = ConvertJavaToFromArray.getTypIdLieuGeo(Entente.OMNI, f[3], f[4], f[5], f[6]);
                ((FactServMdcalOmni210.LieuConsi)lieuConsi).setLieuGeo((TypLieuGeoOmni)typIdLieuGeoDep);
                TypIdLieuPhys typIdLieuPhysDep = ConvertJavaToFromArray.getTypIdLieuPhys(Entente.OMNI, f[7], f[8], f[9], f[10], f[11]);
                ((FactServMdcalOmni210.LieuConsi)lieuConsi).setLieuPhys((TypLieuPhysOmni)typIdLieuPhysDep);
                servMdcalOmni.setLieuConsi((FactServMdcalOmni210.LieuConsi)lieuConsi);
                if (!f[12].isEmpty()) {
                    Boolean indFactAssocDr = ConvertJavaToFromArray.getBooleanInteger(f[12]);
                    servMdcalOmni.setIndFactAssocDr(of.createFactServMdcalOmni210IndFactAssocDr(indFactAssocDr));
                }
                if ((a3 = ConvertJavaToFromArray.split(f[13], SN[l3]))[0].length() > 0) {
                    servMdcalOmni.setDhdInterAutreMd(of.createFactServMdcalOmni210DhdInterAutreMd(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(a3[0]))));
                }
                if (a3[1].length() > 0) {
                    servMdcalOmni.setDhdPerTravProf(of.createFactServMdcalOmni210DhdPerTravProf(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(a3[1]))));
                }
                FactServMdcalOmni210.ListeElmContx lstElmContx = of.createFactServMdcalOmni210ListeElmContx();
                String[] persObjectFacts = elmfs = ConvertJavaToFromArray.split(f[14], SN[l3]);
                int lignes = elmfs.length;
                int ligneFact = 0;
                while (ligneFact < lignes) {
                    String elm = persObjectFacts[ligneFact];
                    if (!elm.isEmpty()) {
                        String[] el = ConvertJavaToFromArray.split(elm, SN[l4]);
                        FactServMdcalOmni210.ListeElmContx.ElmContx listeElmContxElmContx = of.createFactServMdcalOmni210ListeElmContxElmContx();
                        listeElmContxElmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(el[0]));
                        if (!el[1].isEmpty()) {
                            listeElmContxElmContx.setCodFactLieElmContx(of.createFactServMdcalOmni210ListeElmContxElmContxCodFactLieElmContx(new BigInteger(el[1])));
                        }
                        lstElmContx.getElmContx().add(listeElmContxElmContx);
                    }
                    ++ligneFact;
                }
                servMdcalOmni.setListeElmContx(lstElmContx);
                FactServMdcalOmni210.ListeLigneFactServMdcalOmni ligneLst = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmni();
                String[] stringArray = lignes = ConvertJavaToFromArray.split(f[15], SN[l3]);
                int listeElmContxElmContx = lignes.length;
                int el = 0;
                while (el < listeElmContxElmContx) {
                    String ligne = stringArray[el];
                    if (!ligne.isEmpty()) {
                        Object lieu22;
                        String[] lig = ConvertJavaToFromArray.split(ligne, SN[l4]);
                        FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni ligneFact2 = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmni();
                        ligneFact2.setNoLigneFact(ConvertJavaToFromArray.parseInt(lig[0]));
                        ligneFact2.setDatServElmFact(dataFactory.newXMLGregorianCalendar(lig[1]));
                        if (lig[2].length() > 0) {
                            ligneFact2.setDhdElmFact(of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniDhdElmFact(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(lig[2]))));
                            if (lig[3].length() > 0) {
                                ligneFact2.setDhfElmFact(of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniDhfElmFact(dataFactory.newXMLGregorianCalendar(ConvertJavaToFromArray.getDT4XMLformat(lig[3]))));
                            }
                        }
                        ligneFact2.setCodRole(lig[4]);
                        ligneFact2.setCodRefreSituSpeci(of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniCodRefreSituSpeci(ConvertJavaToFromArray.getInt(lig[5])));
                        TypLieuRefreOmni lieuRefOmni = of.createTypLieuRefreOmni();
                        Integer typeRefreLieu = ConvertJavaToFromArray.getInt(lig[6]);
                        if (typeRefreLieu != null) {
                            lieuRefOmni.setTypRefreLieu(typeRefreLieu);
                        }
                        String[] lieuRefs = ConvertJavaToFromArray.split(lig[7], SN[l5]);
                        TypLieuRefreOmni.ListeLieuRefre listLieuRefre = of.createTypLieuRefreOmniListeLieuRefre();
                        Object listLigneElMesureContx32 = lieuRefs;
                        int elmesures = lieuRefs.length;
                        int listLigneElmContx = 0;
                        while (listLigneElmContx < elmesures) {
                            String lieuRefI = listLigneElMesureContx32[listLigneElmContx];
                            if (!lieuRefI.isEmpty()) {
                                String[] lx = ConvertJavaToFromArray.split(lieuRefI, SN[l6]);
                                lieu22 = null;
                                if (ConvertJavaToFromArray.isVer102(log)) {
                                    if ("C".equals(lx[0])) {
                                        lieu22 = ConvertJavaToFromArray.getTypIdLieuPhys(lx[1], lx[2]);
                                    } else if ("N".equals(lx[0])) {
                                        lieu22 = ConvertJavaToFromArray.getTypLieuRefreGeoOmni(lx[1], lx[2]);
                                    }
                                    if (lieu22 != null) {
                                        listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().add((TypIdLieu)lieu22);
                                        break;
                                    }
                                } else {
                                    if ("C".equals(lx[0])) {
                                        lieu22 = ConvertJavaToFromArray.getTypIdLieuRefrePhys(Entente.OMNI, lx[1], lx[2], lx[3], lx[4], lx[5]);
                                    } else if ("N".equals(lx[0])) {
                                        lieu22 = ConvertJavaToFromArray.getTypIdLieuRefreGeo(Entente.OMNI, lx[1], lx[2], lx[3], lx[4]);
                                    }
                                    if (lieu22 != null) {
                                        listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().add((TypIdLieu)lieu22);
                                    }
                                }
                            }
                            ++listLigneElmContx;
                        }
                        if (listLieuRefre.getLieuRefrePhysOrLieuRefreGeo().size() > 0) {
                            lieuRefOmni.setListeLieuRefre(listLieuRefre);
                            ligneFact2.setLieuEnRefre(lieuRefOmni);
                        }
                        ligneFact2.setIdElmFact(new BigInteger(lig[8]));
                        ligneFact2.setTypIdElmFact(lig[9]);
                        String[] elmls = ConvertJavaToFromArray.split(lig[10], SN[l5]);
                        FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx listLigneElmContx2 = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmContx();
                        lieu22 = elmls;
                        int lx = elmls.length;
                        int listLigneElMesureContx32 = 0;
                        while (listLigneElMesureContx32 < lx) {
                            String el4 = lieu22[listLigneElMesureContx32];
                            if (!el4.isEmpty()) {
                                FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx elmContxElmContx = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmContxElmContx();
                                elmContxElmContx.setCodElmContx(ConvertJavaToFromArray.parseInt(el4));
                                listLigneElmContx2.getElmContx().add(elmContxElmContx);
                            }
                            ++listLigneElMesureContx32;
                        }
                        if (listLigneElmContx2.getElmContx().size() > 0) {
                            ligneFact2.setListeElmContx(listLigneElmContx2);
                        }
                        String[] elmesures2 = ConvertJavaToFromArray.split(lig[11], SN[l5]);
                        listLigneElMesureContx32 = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniListeElmMesur();
                        String[] efreNonConnu = elmesures2;
                        int elmContxElmContx = elmesures2.length;
                        int lieu22 = 0;
                        while (lieu22 < elmContxElmContx) {
                            String els = efreNonConnu[lieu22];
                            if (!els.isEmpty()) {
                                String[] el5 = ConvertJavaToFromArray.split(els, SN[l6]);
                                TypElmMesur typElmMesure = of.createTypElmMesur();
                                typElmMesure.setCodElmMesur(ConvertJavaToFromArray.parseInt(el5[0]));
                                typElmMesure.setValMes(ConvertJavaToFromArray.getBigDecimal(el5[1]));
                                ((FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmMesur)listLigneElMesureContx32).getElmMesur().add(typElmMesure);
                            }
                            ++lieu22;
                        }
                        ligneFact2.setListeElmMesur((FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmMesur)listLigneElMesureContx32);
                        if (ConvertJavaToFromArray.isDec(lig[12])) {
                            ligneFact2.setMntPrcuPatnt(of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniMntPrcuPatnt(ConvertJavaToFromArray.getBigDecimal(lig[12])));
                        }
                        FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf refreAutreProf = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniRefreAutreProf();
                        if (ConvertJavaToFromArray.isInt(lig[13])) {
                            refreAutreProf.setTypRefreAutreProf(ConvertJavaToFromArray.parseInt(lig[13]));
                        }
                        FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre infoProfRefre = null;
                        String[] profRefre = ConvertJavaToFromArray.split(lig[14], SN[l5]);
                        if (profRefre.length == 2 && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)profRefre[0])) {
                            infoProfRefre = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniRefreAutreProfInfoProfRefre();
                            infoProfRefre.setProfRefreConnu(ConvertJavaToFromArray.getTypProf(profRefre[0], profRefre[1]));
                            refreAutreProf.setInfoProfRefre(infoProfRefre);
                            ligneFact2.setRefreAutreProf(refreAutreProf);
                        }
                        if (infoProfRefre == null && (efreNonConnu = ConvertJavaToFromArray.split(lig[15], SN[l5])).length == 4 && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)efreNonConnu[2]) && ca.infodata.ofys.util.StringUtils.isNotEmpty((String)efreNonConnu[3])) {
                            infoProfRefre = of.createFactServMdcalOmni210ListeLigneFactServMdcalOmniLigneFactServMdcalOmniRefreAutreProfInfoProfRefre();
                            infoProfRefre.setProfRefreNonConnu(ConvertJavaToFromArray.getTypProfNonConnu(efreNonConnu[0], efreNonConnu[1], efreNonConnu[2], efreNonConnu[3]));
                            refreAutreProf.setInfoProfRefre(infoProfRefre);
                            ligneFact2.setRefreAutreProf(refreAutreProf);
                        }
                        ligneLst.getLigneFactServMdcalOmni().add(ligneFact2);
                    }
                    ++el;
                }
                if (!ligneLst.getLigneFactServMdcalOmni().isEmpty()) {
                    servMdcalOmni.setListeLigneFactServMdcalOmni(ligneLst);
                }
                persObjectFacts = ConvertJavaToFromArray.split(f[16], SN[l3]);
                FactServMdcalOmni210.ListePersObjetFact listePersObjetFact = of.createFactServMdcalOmni210ListePersObjetFact();
                String[] stringArray2 = persObjectFacts;
                int n = persObjectFacts.length;
                int n7 = 0;
                while (n7 < n) {
                    String persObjectFact = stringArray2[n7];
                    if (!persObjectFact.isEmpty()) {
                        String[] pofs = ConvertJavaToFromArray.split(persObjectFact, SN[l4]);
                        Object pof = null;
                        String imc = null;
                        if (pofs.length == 9) {
                            imc = pofs[8];
                        }
                        if ((pof = ConvertJavaToFromArray.getPersPatn(l5, Entente.OMNI, ConvertJavaToFromArray.parseInt(pofs[0]), ConvertJavaToFromArray.split(pofs[1], SN[l5]), ConvertJavaToFromArray.split(pofs[2], SN[l5]), ConvertJavaToFromArray.split(pofs[3], SN[l5]), pofs[4], ConvertJavaToFromArray.split(pofs[5], SN[l5]), ConvertJavaToFromArray.split(pofs[6], SN[l5]), ConvertJavaToFromArray.split(pofs[7], SN[l5]), imc)) != null) {
                            listePersObjetFact.getPersPatntAvecIdtOrPersPatntSansIdtOrPersAutreAvecIdt().add(pof);
                        }
                    }
                    ++n7;
                }
                servMdcalOmni.setListePersObjetFact(listePersObjetFact);
                if (!f[17].isEmpty()) {
                    servMdcalOmni.setNoAutor(of.createFactServMdcalOmni210NoAutor(f[17]));
                }
            } else {
                TypFact tf = of.createTypFact();
                lf.setFactBase(of.createFactBase(tf));
            }
            TypFact factBase = (TypFact)lf.getFactBase().getValue();
            factBase.setNoFactExt(f[0]);
            String[] p = ConvertJavaToFromArray.split(f[1], SN[l3]);
            TypProf prof = ConvertJavaToFromArray.getTypProf(p[0], p[1]);
            factBase.setProf(prof);
            return lf;
        }
    }

    public static class ConvertDemPaimtRecev {
        public static final int version = 1;

        public static DemPaimtRecev fromArrayString(String demString, DemPaimtRecev dem) {
            String[] s = ConvertJavaToFromArray.split(demString, SN[0]);
            dem.setNoDemExt(s[2]);
            dem.setStaRecev(ConvertJavaToFromArray.parseInt(s[3]));
            dem.setListeFactRecev(ConvertDemPaimtRecev.fromArrayString(s[4], 1, of.createDemPaimtRecevListeFactRecev()));
            dem.setListeMsgExplRecev(ConvertJavaToFromArray.fromArrayString(s[5], 1, of.createTypDemRecevListeMsgExplRecev()));
            return dem;
        }

        public static String toArrayString(DemPaimtRecev dem) {
            JoinList a1 = new JoinList(N[0]);
            a1.add(String.valueOf(ArrDemType.DEM_ANNU_RECEV.getVal()));
            a1.add(String.valueOf(1));
            a1.add(dem.getNoDemExt());
            a1.add(ConvertJavaToFromArray.isN(dem.getStaRecev()));
            a1.add(ConvertDemPaimtRecev.toArrayString(dem.getListeFactRecev()));
            a1.add(ConvertJavaToFromArray.toArrayString(1, dem.getListeMsgExplRecev()));
            return a1.toString();
        }

        private static String toArrayString(DemPaimtRecev.ListeFactRecev d) {
            JoinList a2 = new JoinList(N[1]);
            List<DemPaimtRecev.ListeFactRecev.FactRecev> factRamq = d.getFactRecev();
            for (DemPaimtRecev.ListeFactRecev.FactRecev i : factRamq) {
                JoinList a3 = new JoinList(N[2]);
                a3.add(ConvertJavaToFromArray.isN(i.getStaRecev()));
                a3.add(i.getNoFactExt());
                if (i.getIdFactRamqRecev() != null) {
                    a3.add(ConvertJavaToFromArray.toArrayString(new JoinList(N[3]), i.getIdFactRamqRecev()));
                } else {
                    a3.add("");
                }
                if (i.getListeLigneFactRecev() != null) {
                    a3.add(ConvertJavaToFromArray.toArrayString(3, i.getListeLigneFactRecev().getLigneFactRecev()));
                } else {
                    a3.add("");
                }
                a3.add(ConvertDemPaimtRecev.toArrayString(i.getListeMsgExplRecev()));
                a2.add(a3.toString());
            }
            return a2.toString();
        }

        private static String toArrayString(int level, DemPaimtRecev.ListeFactRecev.FactRecev.ListeLigneFactRecev listeLigneFactRecev) {
            if (listeLigneFactRecev != null) {
                JoinList a4 = new JoinList(N[level]);
                List<TypLigneFactRecev> factRecevs = listeLigneFactRecev.getLigneFactRecev();
                if (!factRecevs.isEmpty()) {
                    for (TypLigneFactRecev factRecev : factRecevs) {
                        JoinList a5 = new JoinList(N[level + 1]);
                        a5.add(ConvertJavaToFromArray.isN(factRecev.getStaRecev()));
                        a5.add(factRecev.getNoLigneFact());
                        a4.add(a5.toString());
                    }
                }
                return a4.toString();
            }
            return "";
        }

        private static DemPaimtRecev.ListeFactRecev fromArrayString(String arr, int level, DemPaimtRecev.ListeFactRecev lf) {
            String[] a2 = ConvertJavaToFromArray.split(arr, SN[level]);
            boolean added = false;
            if (a2.length > 0 && a2[0].length() > 0) {
                String[] stringArray = a2;
                int n = a2.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa2 = stringArray[n2];
                    String[] a3 = ConvertJavaToFromArray.split(aa2, SN[level + 1]);
                    DemPaimtRecev.ListeFactRecev.FactRecev factRecev = of.createDemPaimtRecevListeFactRecevFactRecev();
                    factRecev.setStaRecev(ConvertJavaToFromArray.parseInt(a3[0]));
                    factRecev.setNoFactExt(a3[1]);
                    factRecev.setIdFactRamqRecev(ConvertJavaToFromArray.fromArrayString(ConvertJavaToFromArray.split(a3[2], SN[level + 2]), of.createIdFactRamqRecev()));
                    DemPaimtRecev.ListeFactRecev.FactRecev.ListeLigneFactRecev listeLigneFactRecev = of.createDemPaimtRecevListeFactRecevFactRecevListeLigneFactRecev();
                    ConvertJavaToFromArray.fromArrayString(a3[3], level + 2, listeLigneFactRecev.getLigneFactRecev());
                    factRecev.setListeLigneFactRecev(listeLigneFactRecev);
                    factRecev.setListeMsgExplRecev(ConvertDemPaimtRecev.fromArrayString(a3[4], level + 2, of.createDemPaimtRecevListeFactRecevFactRecevListeMsgExplRecev()));
                    lf.getFactRecev().add(factRecev);
                    added = true;
                    ++n2;
                }
            }
            return added ? lf : null;
        }

        private static DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev fromArrayString(String a3, int level, DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            String[] a4 = ConvertJavaToFromArray.split(a3, SN[level]);
            boolean added = false;
            if (a4.length > 0 && a4[0].length() > 0) {
                String[] stringArray = a4;
                int n = a4.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa4 = stringArray[n2];
                    String[] a5 = ConvertJavaToFromArray.split(aa4, SN[level + 1]);
                    TypMsgExplRecev msgExpl = of.createTypMsgExplRecev();
                    msgExpl.setCodMsgExplRecev(new BigInteger(a5[0]));
                    msgExpl.setTxtMsgExplRecev(a5[1]);
                    listeMsgExplRecev.getMsgExplRecev().add(msgExpl);
                    added = true;
                    ++n2;
                }
            }
            return added ? listeMsgExplRecev : null;
        }

        private static String toArrayString(DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            if (listeMsgExplRecev != null) {
                JoinList a4 = new JoinList(N[3]);
                List<TypMsgExplRecev> msgExplRecev = listeMsgExplRecev.getMsgExplRecev();
                if (!msgExplRecev.isEmpty()) {
                    for (TypMsgExplRecev explRecev : msgExplRecev) {
                        JoinList a5 = new JoinList(N[4]);
                        a5.add(ConvertJavaToFromArray.isN(explRecev.getCodMsgExplRecev()));
                        a5.add(explRecev.getTxtMsgExplRecev());
                        a4.add(a5.toString());
                    }
                }
                return a4.toString();
            }
            return "";
        }

        private static DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev fromArrayString(String a3, DemPaimtRecev.ListeFactRecev.FactRecev.ListeMsgExplRecev listeMsgExplRecev) {
            String[] a4 = ConvertJavaToFromArray.split(a3, SN[3]);
            boolean added = false;
            if (a4.length > 0 && a4[0].length() > 0) {
                String[] stringArray = a4;
                int n = a4.length;
                int n2 = 0;
                while (n2 < n) {
                    String aa4 = stringArray[n2];
                    String[] a5 = ConvertJavaToFromArray.split(aa4, SN[4]);
                    TypMsgExplRecev msgExpl = of.createTypMsgExplRecev();
                    msgExpl.setCodMsgExplRecev(new BigInteger(a5[0]));
                    msgExpl.setTxtMsgExplRecev(a5[1]);
                    listeMsgExplRecev.getMsgExplRecev().add(msgExpl);
                    added = true;
                    ++n2;
                }
            }
            return added ? listeMsgExplRecev : null;
        }
    }

    public static enum Entente {
        OMNI(1),
        SPEC(2);

        private final int val;

        private Entente(int e) {
            this.val = e;
        }

        public int getVal() {
            return this.val;
        }
    }

    public static enum PersRepdn_enum {
        REPDN_AVEC_IDT(1),
        REPDN_SANS_IDT(2);

        private final int val;

        private PersRepdn_enum(int e) {
            this.val = e;
        }

        public int getVal() {
            return this.val;
        }

        public Integer getValInt() {
            return this.val;
        }
    }
}

