/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.util.Helper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Transaction<C extends Serializable, R extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = Logger.getLogger(Transaction.class.getName());
    private final List<RequestFault> faults;
    private final String eventType;
    private final String eventId;
    private final long eventTime;
    private final String rawResponse;
    private final String rawRequest;
    private final C criteria;
    private final R result;
    private final ArrayList<Exception> warnings;
    private final String endpointAddress;
    private final Long communicationWithB2BTimeMillis;

    protected Transaction(String eventType, String eventId, long eventTime, String rawResponse, String rawRequest, C criteria, R result, List<RequestFault> faults, List<Exception> warnings, String endpointAddress, Long communicationWithB2BTimeMillis) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (eventId == null) {
            throw new NullPointerException("eventId");
        }
        if (faults == null) {
            throw new NullPointerException("faults");
        }
        this.eventType = eventType;
        this.eventId = eventId;
        this.eventTime = eventTime;
        this.rawResponse = rawResponse;
        this.rawRequest = rawRequest;
        this.criteria = criteria;
        this.result = result;
        this.faults = Collections.unmodifiableList(faults);
        this.warnings = new ArrayList<Exception>(warnings);
        this.endpointAddress = endpointAddress;
        this.communicationWithB2BTimeMillis = communicationWithB2BTimeMillis;
        logger.log(Level.INFO, "Transaction done", this);
        if (warnings.size() > 0) {
            System.out.println("WARNINGS");
            System.out.println(Helper.join(warnings, "\n"));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Transaction other = (Transaction)obj;
        if (this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId)) {
            return false;
        }
        return !(this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType));
    }

    public boolean containsOnlyFaults(String code) {
        return this.getFaults().size() == 1 && this.containsFaults(code);
    }

    public boolean containsFaults(String code) {
        for (RequestFault f : this.getFaults()) {
            if (!f.equalsByCode(code)) continue;
            return true;
        }
        return false;
    }

    public RequestFault getFault(String code) {
        for (RequestFault f : this.getFaults()) {
            if (!f.equalsByCode(code)) continue;
            return f;
        }
        return null;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventId() {
        return this.eventId;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String getRawRequest() {
        return this.rawRequest;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public R getResult() {
        return this.result;
    }

    public List<RequestFault> getFaults() {
        return this.faults;
    }

    public C getCriteria() {
        return this.criteria;
    }

    public Long getCommunicationWithB2BTimeMillis() {
        return this.communicationWithB2BTimeMillis;
    }

    public String toStringShort() {
        return String.format("Transaction [eventId=%s, eventTime=%s(%s), eventType=%s, communicationWithB2BTimeMillis=%s ms, faults=%s, warnings=%s]", this.eventId, this.eventTime, Helper.formatFULLDATETIME(this.eventTime), this.eventType, this.communicationWithB2BTimeMillis, this.faults, this.warnings);
    }

    public String toString() {
        return String.format("Transaction [eventId=%s, eventTime=%s(%s), eventType=%s, endpointAddress=%s, communicationWithB2BTimeMillis=%s ms, criteria=%s, faults=%s, warnings=%s, result=%s, rawRequest=%s, rawResponse=%s]", this.eventId, this.eventTime, Helper.formatFULLDATETIME(this.eventTime), this.eventType, this.endpointAddress, this.communicationWithB2BTimeMillis, this.criteria, this.faults, this.warnings, this.result, this.rawRequest, this.rawResponse);
    }

    public ArrayList<Exception> getWarnings() {
        return this.warnings;
    }

    public static class TransactionBuilder<C extends Serializable, R extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<RequestFault> faults = new ArrayList<RequestFault>(2);
        private List<Exception> warnings = new ArrayList<Exception>(2);
        private String eventType;
        private String eventId;
        private long eventTime;
        private String rawResponse;
        private String rawRequest;
        private C criteria;
        private R result;
        private String endpointAddress;
        private Long communicationWithB2BTimeMillis;

        public TransactionBuilder() {
            this(System.currentTimeMillis());
        }

        private TransactionBuilder(long eventTime) {
            this.eventTime = eventTime;
        }

        public List<RequestFault> getFaults() {
            return this.faults;
        }

        public TransactionBuilder<C, R> setFaults(List<RequestFault> faults) {
            this.faults = faults;
            return this;
        }

        public String getEventType() {
            return this.eventType;
        }

        public TransactionBuilder<C, R> setEventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public String getEventId() {
            return this.eventId;
        }

        public TransactionBuilder<C, R> setEventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public long getEventTime() {
            return this.eventTime;
        }

        public TransactionBuilder<C, R> setEventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public String getRawResponse() {
            return this.rawResponse;
        }

        public TransactionBuilder<C, R> setRawResponse(String rawResponse) {
            this.rawResponse = rawResponse;
            return this;
        }

        public String getRawRequest() {
            return this.rawRequest;
        }

        public TransactionBuilder<C, R> setRawRequest(String rawRequest) {
            this.rawRequest = rawRequest;
            return this;
        }

        public C getCriteria() {
            return this.criteria;
        }

        public TransactionBuilder<C, R> setCriteria(C criteria) {
            this.criteria = criteria;
            return this;
        }

        public R getResult() {
            return this.result;
        }

        public TransactionBuilder<C, R> setResult(R result) {
            this.result = result;
            return this;
        }

        public String getEndpointAddress() {
            return this.endpointAddress;
        }

        public TransactionBuilder<C, R> setEndpointAddress(String endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        public Long getCommunicationWithB2BTimeMillis() {
            return this.communicationWithB2BTimeMillis;
        }

        public TransactionBuilder<C, R> setcommunicationWithB2BTimeMillis(Long communicationWithB2BTimeMillis) {
            this.communicationWithB2BTimeMillis = communicationWithB2BTimeMillis;
            return this;
        }

        public List<Exception> getWarnings() {
            return this.warnings;
        }

        public Transaction<C, R> build() {
            return new Transaction<C, R>(this.getEventType(), this.getEventId(), this.getEventTime(), this.getRawResponse(), this.getRawRequest(), this.getCriteria(), this.getResult(), this.getFaults(), this.getWarnings(), this.getEndpointAddress(), this.getCommunicationWithB2BTimeMillis());
        }
    }
}

