/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public final class RequestFault
implements Serializable {
    public static final String XML_MARSHALL_FAULT_TYPE = "XML_MARSHALL_FAULT";
    public static final String ERREUR_RAMQ = "ERREUR RAMQ";
    public static final String RESPONSE_PARTIAL_FAULT = "RESPONSE_PARTIAL_FAULT";
    public static final String REQUEST_PROCESSING_FAULT = "REQUEST_PROCESSING_FAULT";
    public static final String RESPONSE_PROCESSING_FAULT = "RESPONSE_PROCESSING_FAULT";
    public static final String CALL_STOPPED_FAULT = "CALL_STOPPED_FAULT";
    private static final long serialVersionUID = 1L;
    private final String code;
    private final String message;
    private final String priorityCode;
    private final Throwable throwable;

    public RequestFault(String code, String message) {
        this(null, code, message, null);
    }

    public RequestFault(String code, String message, Throwable throwable) {
        this(null, code, message, throwable);
    }

    @Deprecated
    public RequestFault(String typeCode, String code, String message, Throwable throwable) {
        this.code = typeCode != null && code != null ? String.valueOf(typeCode) + "_" + code : (typeCode != null ? typeCode : code);
        this.message = message;
        this.throwable = throwable;
        this.priorityCode = null;
    }

    public RequestFault(String typeCode, String code, String priorityCode, String message, Throwable throwable) {
        this.code = typeCode != null && code != null ? String.valueOf(typeCode) + "_" + code : (typeCode != null ? typeCode : code);
        this.message = message;
        this.throwable = throwable;
        this.priorityCode = priorityCode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.message == null ? 20 : this.message.length() + 20);
        if (this.priorityCode != null) {
            b.append(this.priorityCode);
            b.append(" - ");
        }
        b.append(this.code);
        b.append(" - ");
        b.append(this.message);
        if (this.throwable != null) {
            b.append(" - ");
            b.append(RequestFault.getStackTrace(this.throwable));
        }
        return b.toString();
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return ((Object)writer).toString();
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean equalsByCode(String code) {
        return RequestFault.areEqualsIgnoreCase(code, this.code);
    }

    private static boolean areEqualsIgnoreCase(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equalsIgnoreCase(o2);
    }

    public String getPriorityCode() {
        return this.priorityCode;
    }
}

