/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.handlers.ThreadSafeLastCallLogHandler;
import ca.infodata.syra.services.ObtenirFichValidCriteria;
import ca.infodata.syra.services.ObtenirFichValidResult;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ZipUnzip;
import ca.qc.gouv.ramq.ramq_rfp_npb4_obtnfichvalidb2b_svc._1.IServObtnFichValidB2B;
import ca.qc.gouv.ramq.ramq_rfp_npb4_obtnfichvalidb2b_svc._1.ObjectFactory;
import ca.qc.gouv.ramq.ramq_rfp_npb4_obtnfichvalidb2b_svc._1.ObtnFichValid;
import ca.qc.gouv.ramq.ramq_rfp_npb4_obtnfichvalidb2b_svc._1.ObtnFichValidResponse;
import ca.qc.gouv.ramq.ramq_rfp_npb4_obtnfichvalidb2b_svc._1.ParamObtnFichValidSorti;
import cod1_v4outilbase_cpo._1.ArrayOfMsgTrait;
import cod1_v4outilbase_cpo._1.MsgTrait;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;

public class ObtenirFichValidService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NP/NPB_GereEchgOrga/NPB4_ObtnFichValidB2B_svc/ServObtnFichValidB2B.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NP/NPB_GereEchgOrga/NPB4_ObtnFichValidB2B_svc/ServObtnFichValidB2B.svc";
    public static final String EVENT_TYPE = "ObtenirFichierValid";
    private ObjectFactory objectFactory;
    private IServObtnFichValidB2B proxy;
    private Map<String, Object> requestContext;
    private String endpointAddress;
    private ThreadSafeLastCallLogHandler threadSafeLastCallLogHandler;
    private DsMessageParser dsMessageParser;
    public static final String userHomeBaseX = String.valueOf(System.getProperty("user.home")) + "/BaseXData/";
    public static final String userHomeBaseXValidXml = String.valueOf(System.getProperty("user.home")) + "/BaseXData/valid_xml/";

    public ObtenirFichValidService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public ObtenirFichValidService(Collection<Handler> handlers, String endpoint) throws Exception {
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        File baseXml = new File(userHomeBaseXValidXml);
        if (!baseXml.exists()) {
            FileUtils.forceMkdir((File)baseXml);
        }
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlers);
        this.threadSafeLastCallLogHandler = new ThreadSafeLastCallLogHandler();
        handlerChain.add(0, (Handler)this.threadSafeLastCallLogHandler);
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(IServObtnFichValidB2B.class);
        factory.setHandlers(handlerChain);
        factory.setAddress(this.endpointAddress);
        this.proxy = (IServObtnFichValidB2B)factory.create(IServObtnFichValidB2B.class);
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(false);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
    }

    public Transaction<ObtenirFichValidCriteria, ObtenirFichValidResult> obtenir(ObtenirFichValidCriteria criteria) {
        Transaction.TransactionBuilder<ObtenirFichValidCriteria, ObtenirFichValidResult> builder;
        block10: {
            if (criteria == null) {
                throw new NullPointerException("criteria");
            }
            Client client = ClientProxy.getClient((Object)this.proxy);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            http.getAuthorization().setUserName(criteria.getUserId());
            http.getAuthorization().setPassword(criteria.getUserPswd());
            this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getUserId());
            this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getUserPswd());
            builder = new Transaction.TransactionBuilder<ObtenirFichValidCriteria, ObtenirFichValidResult>();
            builder.setEventType(EVENT_TYPE);
            builder.setCriteria(criteria);
            builder.setEndpointAddress(this.endpointAddress);
            builder.setEventId(UUID.randomUUID().toString());
            try {
                ObtnFichValid obtnFichValid = this.objectFactory.createObtnFichValid();
                ObtnFichValidResponse obtnFichValidResponse = this.proxy.obtnFichValid(obtnFichValid);
                if (!this.isResponseOK(obtnFichValidResponse, builder)) break block10;
                String strFile = (String)((ParamObtnFichValidSorti)obtnFichValidResponse.getObtnFichValidResult().getValue()).getNomFichier().getValue();
                GregorianCalendar version = ((ParamObtnFichValidSorti)obtnFichValidResponse.getObtnFichValidResult().getValue()).getVersion().toGregorianCalendar();
                String destinFolder = strFile.substring(0, strFile.lastIndexOf(46));
                if (strFile.equals(destinFolder)) {
                    strFile = String.valueOf(strFile) + System.currentTimeMillis();
                }
                builder.setResult(new ObtenirFichValidResult(version, strFile, userHomeBaseX));
                System.out.println("D\u00e9compression du contenu de <" + strFile + "> ... dans le dossier <" + userHomeBaseX + ">");
                try {
                    byte[] attObj = (byte[])((ParamObtnFichValidSorti)obtnFichValidResponse.getObtnFichValidResult().getValue()).getDonnees().getValue();
                    if (attObj != null && attObj.length > 0) {
                        FileUtils.writeByteArrayToFile((File)new File(userHomeBaseX, strFile), (byte[])attObj);
                        File[] fileArray = new File(userHomeBaseXValidXml).listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File oldFile = fileArray[n2];
                            FileUtils.deleteQuietly((File)oldFile);
                            ++n2;
                        }
                        List<String> files = ZipUnzip.unZip(String.valueOf(userHomeBaseX) + strFile, userHomeBaseXValidXml, false);
                        if (files == null || files.isEmpty()) {
                            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", "Erreur unzip", new Exception(String.valueOf(userHomeBaseXValidXml) + strFile)));
                        } else {
                            builder.getResult().setFiles(files);
                        }
                        break block10;
                    }
                    builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", "Erreur - Pas de donnees recues de la RAMQ.", new Exception()));
                }
                catch (Exception e) {
                    builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
                }
            }
            catch (Exception e) {
                builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
            }
        }
        builder.setRawRequest(this.threadSafeLastCallLogHandler.getRequest());
        builder.setRawResponse(this.threadSafeLastCallLogHandler.getResponse());
        Transaction<ObtenirFichValidCriteria, ObtenirFichValidResult> r = builder.build();
        return r;
    }

    private boolean isResponseOK(ObtnFichValidResponse result, Transaction.TransactionBuilder<ObtenirFichValidCriteria, ObtenirFichValidResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de InitierEnvoi"));
        } else {
            ParamObtnFichValidSorti validSorti = (ParamObtnFichValidSorti)result.getObtnFichValidResult().getValue();
            ArrayOfMsgTrait infoMsgTrait = validSorti.getInfoMsgTrait();
            if (infoMsgTrait != null && !infoMsgTrait.getMsgTrait().isEmpty()) {
                ArrayList<String> lstMsgs = new ArrayList<String>();
                ArrayList<String> lstMsg = new ArrayList<String>();
                for (MsgTrait mt : infoMsgTrait.getMsgTrait()) {
                    lstMsg.add("codAppl:" + mt.getCodAppli());
                    lstMsg.add("codServer:" + mt.getCodSever());
                    lstMsg.add("Msg Fr:" + mt.getTxtMsgFran());
                    lstMsg.add("Msg An:" + mt.getTxtMsgAngl());
                    lstMsgs.add(new JoinList(", ", lstMsg).toString());
                }
                this.processStrMessage(builder, new JoinList("\n", lstMsgs).toString());
            }
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, ObtenirFichValidResult> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            builder.getFaults().add(new RequestFault("ERREUR RAMQ", strMessage));
        }
    }
}

