/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.services.GereEchgElctrB2BCriteria;
import ca.infodata.syra.services.GereEchgElctrB2BResult;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import ca.infodata.syra.util.JoinList;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.IServGereEchgElctrB2B;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.ObjectFactory;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.ParamTrnsmElctrDemEntre;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.ParamTrnsmElctrDemSorti;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.ServGereEchgElctrB2B;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.TransmettreElctrDem;
import ca.qc.gouv.ramq.ramq_rfp_nma5_gereechgelctrb2b_svc._1.TransmettreElctrDemResponse;
import cod1_v4outilbase_cpo._1.ArrayOfMsgTrait;
import cod1_v4outilbase_cpo._1.MsgTrait;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;

public class GereEchgElctrB2BService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/RFP/RFP_ServSysRemuAct/NM/NMA_RecvrDem/NMA5_GereEchgElctrB2B_svc/ServGereEchgElctrB2B.svc";
    public static final String EVENT_TYPE = "GereEchgElctrB2B";
    private ObjectFactory objectFactory;
    private IServGereEchgElctrB2B proxy;
    private Map<String, Object> requestContext;
    private String endpointAddress;
    private DsMessageParser dsMessageParser;
    public final String pathRecevabiliteXsd = "xsd/valid/XML_RFP_Recevabilite.xsd";

    public GereEchgElctrB2BService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public GereEchgElctrB2BService(Collection<Handler> handlers, String endpoint) throws Exception {
        URL resource;
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        ServGereEchgElctrB2B.WSDL_LOCATION = resource = Thread.currentThread().getContextClassLoader().getResource("wsdl/ServGereEchgElctrB2B.wsdl");
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(IServGereEchgElctrB2B.class);
        factory.setAddress(this.endpointAddress);
        this.proxy = (IServGereEchgElctrB2B)factory.create();
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(false);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
    }

    public Transaction<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> envoyer(GereEchgElctrB2BCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        Client client = ClientProxy.getClient((Object)this.proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.getAuthorization().setUserName(criteria.getUserId());
        http.getAuthorization().setPassword(criteria.getUserPswd());
        this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getUserId());
        this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getUserPswd());
        GereEchgElctrB2BResult gereEchgElctrB2BResult = new GereEchgElctrB2BResult(criteria.getDpNoInterne());
        Transaction.TransactionBuilder<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> builder = new Transaction.TransactionBuilder<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult>();
        builder.setEventType(EVENT_TYPE);
        builder.setCriteria(criteria);
        builder.setEndpointAddress(this.endpointAddress);
        builder.setEventId(UUID.randomUUID().toString());
        builder.setResult(gereEchgElctrB2BResult);
        String xmlPmt = null;
        try {
            xmlPmt = criteria.getXmlDem();
        }
        catch (Exception e1) {
            Throwable cause;
            String msg = e1.getMessage();
            if (StringUtils.isEmpty((CharSequence)msg) && (cause = e1.getCause()) != null) {
                msg = cause.getMessage();
            }
            builder.getFaults().add(new RequestFault("XML_MARSHALL_FAULT", msg, e1));
        }
        if (xmlPmt == null) {
            return builder.build();
        }
        System.out.println(xmlPmt);
        try {
            TransmettreElctrDem transmettreElctrDem = this.objectFactory.createTransmettreElctrDem();
            ParamTrnsmElctrDemEntre paramTrnsmElctrDemEntre = this.objectFactory.createParamTrnsmElctrDemEntre();
            paramTrnsmElctrDemEntre.setValContXmlDemRecu(xmlPmt);
            transmettreElctrDem.setObjParamEntre(this.objectFactory.createTransmettreElctrDemObjParamEntre(paramTrnsmElctrDemEntre));
            TransmettreElctrDemResponse transmettreElctrDemResponse = this.proxy.transmettreElctrDem(transmettreElctrDem);
            JAXBElement<ParamTrnsmElctrDemSorti> transmettreElctrDemResult = transmettreElctrDemResponse.getTransmettreElctrDemResult();
            ParamTrnsmElctrDemSorti demSorti = (ParamTrnsmElctrDemSorti)transmettreElctrDemResult.getValue();
            if (this.isResponseOK(demSorti, builder)) {
                builder.getResult().setDemPaimtRecev(demSorti);
            }
        }
        catch (Exception e) {
            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
        }
        Transaction<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> r = builder.build();
        return r;
    }

    private boolean isResponseOK(ParamTrnsmElctrDemSorti result, Transaction.TransactionBuilder<GereEchgElctrB2BCriteria, GereEchgElctrB2BResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9e lors de l'envoi d'une dp"));
        } else {
            ArrayOfMsgTrait infoMsgTrait = result.getInfoMsgTrait();
            if (infoMsgTrait != null && !infoMsgTrait.getMsgTrait().isEmpty()) {
                ArrayList<String> lstMsgs = new ArrayList<String>();
                ArrayList<String> lstMsg = new ArrayList<String>();
                for (MsgTrait mt : infoMsgTrait.getMsgTrait()) {
                    lstMsg.add("codAppl:" + mt.getCodAppli());
                    lstMsg.add("codServer:" + mt.getCodSever());
                    lstMsg.add("Msg Fr:" + mt.getTxtMsgFran());
                    lstMsg.add("Msg An:" + mt.getTxtMsgAngl());
                    lstMsgs.add(new JoinList(", ", lstMsg).toString());
                }
                this.processStrMessage(builder, new JoinList("\n", lstMsgs).toString());
            }
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, ?> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            builder.getFaults().add(new RequestFault("ERREUR RAMQ", strMessage));
        }
    }

    protected void setCookie(BindingProvider provider) {
    }
}

