/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.handlers.PrefixFileLogHandler;
import ca.infodata.syra.services.EchgLotFichExplnSortantCriteria;
import ca.infodata.syra.services.EchgLotFichExplnSortantResult;
import ca.infodata.syra.services.EchgLotFichExplnSortantService;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.JoinList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.Commands;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class EchgLotFichExplnSortantServiceTest {
    private EchgLotFichExplnSortantService service;
    private final String dbname = "expl_valid";
    private final Context context = new Context();

    public void deleteDatabase() {
        this.deleteDb("expl_valid");
    }

    public void test() throws Exception {
        if (this.dbOpen("expl_valid")) {
            this.testRequests(1, "doul abdo");
        }
    }

    public void testOpenDb() throws Exception {
        String fichier = "EX20161006127215.xml";
        String folderXml = "/Users/pdrolet/.fmedx_63724/clientramq/expl_xml";
        System.out.println("Nom du fichier:" + fichier + ", dossier:" + folderXml);
        if (this.deleteDb("expl_valid") && !this.dbOpen("expl_valid")) {
            this.createDb("expl_valid", Arrays.asList(String.valueOf(folderXml) + "/" + fichier));
        }
        this.testRequests(0, null);
    }

    @Test
    public void testObtenir() throws Exception {
        String noInterv = "16147";
        String userId = "AGR16147J";
        String userPswd = "sx[`3EX88Mz";
        this.service = new EchgLotFichExplnSortantService(PrefixFileLogHandler.create("/Users/pdrolet/Desktop/DSQTEST", "EchgLotFichExplnSortant", true), null);
        EchgLotFichExplnSortantResult result = this.demander(userId, userPswd, noInterv);
        System.out.println("Nom du fichier:" + result.getNomFichierZip() + ", dossier:" + result.getFolder());
    }

    private boolean deleteDb(String dbname2) {
        try {
            new DropDB(dbname2).execute(this.context);
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    private EchgLotFichExplnSortantResult demander(String userId, String uPswd, String noInterv) {
        EchgLotFichExplnSortantCriteria criteria = new EchgLotFichExplnSortantCriteria(userId, uPswd, noInterv);
        Transaction<EchgLotFichExplnSortantCriteria, EchgLotFichExplnSortantResult> call = this.service.demander(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
        }
        Assert.assertNotNull((String)faults, (Object)call.getResult());
        return call.getResult();
    }

    @Deprecated
    public void testRequests(int i) {
        this.testRequests(i, null);
    }

    public void testRequests(int i, String name) {
        try {
            switch (i) {
                case 0: {
                    try {
                        EchgLotFichExplnSortantServiceTest.process((String)"/expl_calculs/fn:string-join((dat_coup_per/text(),dat_etat_cpt/text(),dd_per_fact/text(),df_per_fact/text(),no_trnsm/text()),':')", (Context)this.context);
                    }
                    catch (QueryException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    try {
                        String names = "";
                        String query = "";
                        if (name != null) {
                            String[] n = name.split("[ ,']");
                            ArrayList<String> l = new ArrayList<String>();
                            String[] stringArray = n;
                            int n2 = n.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String ss = stringArray[n3];
                                if (ss.length() > 2) {
                                    l.add(ss);
                                }
                                ++n3;
                            }
                            names = "'" + new JoinList(".*','", l).toString() + ".*'";
                            query = "/cod_diagn_mdcal/val_cod_diagn_mdcal[des_long_diagn_mdcal contains text {" + names + "} all using wildcards]";
                        } else {
                            query = "/cod_diagn_mdcal/val_cod_diagn_mdcal";
                        }
                        System.out.println(query);
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (QueryProcessor proc = new QueryProcessor(query, this.context);){
                            Item item;
                            Iter iter = proc.iter();
                            while ((item = iter.next()) != null) {
                                String node = new XQuery(item.toString()).execute(this.context).toString();
                                String code = new XQuery(String.valueOf(node) + "/cod_diagn_mdcal/text()").execute(this.context).toString();
                                String desc = new XQuery(String.valueOf(node) + "/des_abr_diagn_mdcal/text()").execute(this.context).toString();
                                System.out.println(String.valueOf(code) + ":" + desc);
                            }
                            break;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }
        catch (BaseXException e) {
            e.printStackTrace();
        }
    }

    public void testOpenExplXml() {
        if (!this.dbOpen("expl_valid")) {
            this.createDb("expl_valid", this.getFiles());
        }
        this.testRequests(1, "doul abdo");
    }

    private boolean dbOpen(String string) {
        try {
            this.setContextOptions();
            new Open(string).execute(this.context);
            System.out.print(new InfoDB().execute(this.context));
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public void setContextOptions() throws BaseXException {
        this.context.options.assign("MAINMEM", "true");
        this.context.options.assign("STEMMING", "true");
        this.context.options.assign("LANGUAGE", "fr");
        this.context.options.assign("INTPARSE", "true");
        this.context.options.assign("XINCLUDE", "true");
        this.context.options.assign("STRIPNS", "true");
        this.context.options.assign("CHOP", "true");
        this.context.options.assign("QUERYINFO", "true");
    }

    private List<String> getFiles() {
        ArrayList<String> lstFiles = new ArrayList<String>();
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/secteurActivite_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/infoEtablissement_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeDiagnostic_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeFacturation_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeFacturation_Specialiste_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeLocalite_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/elementContexte_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/elementContexte_Specialiste_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/messageExplicatif_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/messageExplicatif_Specialiste_V2_20160429.xml");
        return lstFiles;
    }

    private void createDb(String dbname, List<String> lstFiles) {
        if (lstFiles != null && lstFiles.size() > 0) {
            try {
                new CreateDB(dbname).execute(this.context);
                for (String dataFile : lstFiles) {
                    new Add("", dataFile).execute(this.context);
                }
                new CreateIndex((Object)Commands.CmdIndex.TEXT).execute(this.context);
                System.out.print(new InfoDB().execute(this.context));
            }
            catch (BaseXException e) {
                e.printStackTrace();
            }
        }
    }

    static void process(String query, Context context) throws QueryException, BaseXException {
        long t1 = System.currentTimeMillis();
        Throwable throwable = null;
        Object var5_5 = null;
        try (QueryProcessor proc = new QueryProcessor(query, context);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                System.out.println(item);
                long t2 = System.currentTimeMillis();
                String node = new XQuery(item.toString()).execute(context).toString();
                long t3 = System.currentTimeMillis();
                System.out.println(node);
            }
            long t1_1 = System.currentTimeMillis();
            System.out.println("t1_1-t1= " + (t1_1 - t1) + "ms");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

