/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.CorrellerDemander;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.CorrellerDemanderResponse;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.DemanderLot;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.DemanderLotResponse;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.EnteteRAMQ;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.IServEchgLotFichECSortant;
import ca.infodata.syra.generated.cxf.ServEchgLotFichECSortant.ObjectFactory;
import ca.infodata.syra.handlers.ThreadSafeLastCallLogHandler;
import ca.infodata.syra.services.EchgLotFichECSortantCriteria;
import ca.infodata.syra.services.EchgLotFichECSortantResult;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import ca.infodata.syra.util.ZipUnzip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EchgLotFichECSortantService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichECSortant.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichECSortant.svc";
    public static final String EVENT_TYPE = "EchgLotFichECSortant";
    public static String fmedxHomeClientRamq;
    private ObjectFactory objectFactory;
    private IServEchgLotFichECSortant proxy;
    private Map<String, Object> requestContext;
    private String endpointAddress;
    private ThreadSafeLastCallLogHandler threadSafeLastCallLogHandler;
    private DsMessageParser dsMessageParser;

    static {
        try {
            fmedxHomeClientRamq = String.valueOf(LibPlugin.getFMEDX_HOME()) + "clientramq/";
        }
        catch (Exception e) {
            fmedxHomeClientRamq = "clientramq/";
            e.printStackTrace();
        }
    }

    public EchgLotFichECSortantService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public EchgLotFichECSortantService(Collection<Handler> handlers, String endpoint) {
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlers);
        this.threadSafeLastCallLogHandler = new ThreadSafeLastCallLogHandler();
        handlerChain.add(0, (Handler)this.threadSafeLastCallLogHandler);
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setHandlers(handlerChain);
        factory.setServiceClass(IServEchgLotFichECSortant.class);
        factory.setAddress(this.endpointAddress);
        this.proxy = (IServEchgLotFichECSortant)factory.create();
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(true);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        try {
            this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Transaction<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult> demander(EchgLotFichECSortantCriteria criteria) {
        Transaction.TransactionBuilder<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult> builder;
        block13: {
            if (criteria == null) {
                throw new NullPointerException("criteria");
            }
            Client client = ClientProxy.getClient((Object)this.proxy);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            http.getAuthorization().setUserName(criteria.getUserId());
            http.getAuthorization().setPassword(criteria.getUserPswd());
            this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getUserId());
            this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getUserPswd());
            builder = new Transaction.TransactionBuilder<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult>();
            builder.setEventType(EVENT_TYPE);
            builder.setCriteria(criteria);
            builder.setEndpointAddress(this.endpointAddress);
            builder.setEventId(UUID.randomUUID().toString());
            builder.setResult(new EchgLotFichECSortantResult());
            try {
                EnteteRAMQ enteteRAMQ = this.objectFactory.createEnteteRAMQ();
                enteteRAMQ.setIdEntIntvnEchg(this.objectFactory.createEnteteRAMQIdEntIntvnEchg(criteria.getNoIntervenant()));
                enteteRAMQ.setEtatEchgFich(this.objectFactory.createEnteteRAMQEtatEchgFich(""));
                enteteRAMQ.setNoEchgFich(this.objectFactory.createEnteteRAMQNoEchgFich(""));
                enteteRAMQ.setTypEntIntvnEchg(this.objectFactory.createEnteteRAMQTypEntIntvnEchg("NT"));
                JAXBElement<EnteteRAMQ> jaxEnteteRAMQ = this.objectFactory.createDemanderLotObjEnteteRamq(enteteRAMQ);
                DemanderLot demanderLot = this.objectFactory.createDemanderLot();
                demanderLot.setStrXmlSortie(this.objectFactory.createDemanderLotStrXmlSortie(""));
                demanderLot.setObjEnteteRamq(jaxEnteteRAMQ);
                demanderLot.setBytContFich(this.objectFactory.createDemanderLotBytContFich(new byte[0]));
                DemanderLotResponse demanderLotResponse = this.proxy.demanderLot(demanderLot);
                if (!this.isResponseOK(demanderLotResponse, builder)) break block13;
                String etatEchgFich = null;
                String noEchgFich = null;
                if (demanderLotResponse.getObjEnteteRamq() != null) {
                    if (((EnteteRAMQ)demanderLotResponse.getObjEnteteRamq().getValue()).getEtatEchgFich() != null) {
                        etatEchgFich = (String)((EnteteRAMQ)demanderLotResponse.getObjEnteteRamq().getValue()).getEtatEchgFich().getValue();
                    }
                    if (((EnteteRAMQ)demanderLotResponse.getObjEnteteRamq().getValue()).getNoEchgFich() != null) {
                        noEchgFich = (String)((EnteteRAMQ)demanderLotResponse.getObjEnteteRamq().getValue()).getNoEchgFich().getValue();
                    }
                }
                String strFile = builder.getResult().getNomFichierZip();
                System.out.println("D\u00e9compression du contenu de <" + strFile + "> ... dans le dossier <" + fmedxHomeClientRamq + ">");
                try {
                    byte[] attObj;
                    byte[] byArray = attObj = demanderLotResponse.getBytContFich() == null ? null : (byte[])demanderLotResponse.getBytContFich().getValue();
                    if (attObj != null && attObj.length > 0) {
                        FileUtils.writeByteArrayToFile((File)new File(fmedxHomeClientRamq, strFile), (byte[])attObj);
                        List<String> files = ZipUnzip.unZip(String.valueOf(fmedxHomeClientRamq) + strFile, fmedxHomeClientRamq, true);
                        if (files == null || files.isEmpty()) {
                            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", "Erreur unzip", new Exception(String.valueOf(fmedxHomeClientRamq) + strFile)));
                        } else {
                            builder.getResult().setFiles(files);
                            builder.getResult().setFolder(fmedxHomeClientRamq);
                        }
                    } else {
                        builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", "Erreur - Pas de donnees recues de la RAMQ.", new Exception()));
                    }
                }
                catch (Exception e) {
                    System.out.println(this.threadSafeLastCallLogHandler.getRequest());
                    System.out.println(this.threadSafeLastCallLogHandler.getResponse());
                    builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
                }
                EnteteRAMQ enteteRAMQRep = this.objectFactory.createEnteteRAMQ();
                enteteRAMQRep.setIdEntIntvnEchg(this.objectFactory.createEnteteRAMQIdEntIntvnEchg(criteria.getNoIntervenant()));
                enteteRAMQRep.setEtatEchgFich(this.objectFactory.createEnteteRAMQEtatEchgFich(etatEchgFich));
                enteteRAMQRep.setNoEchgFich(this.objectFactory.createEnteteRAMQNoEchgFich(noEchgFich));
                enteteRAMQRep.setTypEntIntvnEchg(this.objectFactory.createEnteteRAMQTypEntIntvnEchg("NT"));
                CorrellerDemander correllerDemander = this.objectFactory.createCorrellerDemander();
                JAXBElement<String> correllerDemanderStrXmlEntre = this.objectFactory.createCorrellerDemanderStrXmlEntre("<param><no_accu_recept>" + builder.getResult().getNoAccuRecept() + "</no_accu_recept></param>");
                correllerDemander.setStrXmlEntre(correllerDemanderStrXmlEntre);
                JAXBElement<EnteteRAMQ> correllerDemanderObjEnteteRamq = this.objectFactory.createCorrellerDemanderObjEnteteRamq(enteteRAMQRep);
                correllerDemander.setObjEnteteRamq(correllerDemanderObjEnteteRamq);
                JAXBElement<String> correllerDemanderStrXmlSorti = this.objectFactory.createCorrellerDemanderStrXmlSorti("");
                correllerDemander.setStrXmlSorti(correllerDemanderStrXmlSorti);
                CorrellerDemanderResponse correllerDemanderResponse = this.proxy.correllerDemander(correllerDemander);
                if (this.isResponseOK(correllerDemanderResponse, builder)) {
                    builder.getResult().setConfirmedCorrellerDemander(true);
                }
            }
            catch (Exception e) {
                System.out.println(this.threadSafeLastCallLogHandler.getRequest());
                System.out.println(this.threadSafeLastCallLogHandler.getResponse());
                builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
            }
        }
        builder.setRawRequest(this.threadSafeLastCallLogHandler.getRequest());
        builder.setRawResponse(this.threadSafeLastCallLogHandler.getResponse());
        Transaction<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult> r = builder.build();
        return r;
    }

    private boolean isResponseOK(CorrellerDemanderResponse result, Transaction.TransactionBuilder<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de CorrellerDemander"));
        } else {
            String strMessage = (String)result.getStrXmlSorti().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private boolean isResponseOK(DemanderLotResponse result, Transaction.TransactionBuilder<EchgLotFichECSortantCriteria, EchgLotFichECSortantResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de CorrellerDemander"));
        } else {
            String strMessage = (String)result.getStrXmlSortie().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, EchgLotFichECSortantResult> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(strMessage.getBytes("utf-8"))));
                String info_err = doc.getElementsByTagName("info_err").item(0).getTextContent();
                if (StringUtils.isNotEmpty((CharSequence)info_err)) {
                    String message = this.dsMessageParser == null ? "dsMessageParser est null: " + info_err : this.dsMessageParser.parse(info_err, DsMessageParser.TYPE.TEXT);
                    builder.getFaults().add(new RequestFault("ERREUR RAMQ", message));
                } else {
                    String no_accu_recept = null;
                    String nom_fich = null;
                    if (doc.getElementsByTagName("no_accu_recept") != null && doc.getElementsByTagName("no_accu_recept").getLength() > 0) {
                        no_accu_recept = doc.getElementsByTagName("no_accu_recept").item(0).getTextContent();
                        builder.getResult().setNoAccuRecept(no_accu_recept);
                    }
                    if (doc.getElementsByTagName("nom_fich") != null && doc.getElementsByTagName("nom_fich").getLength() > 0) {
                        nom_fich = doc.getElementsByTagName("nom_fich").item(0).getTextContent();
                        builder.getResult().setNomFichierZip(nom_fich);
                    }
                }
            }
            catch (Exception e) {
                builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Erreur", e));
            }
        }
    }
}

