/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.generated.cxf.ServActivIdMachn.ActiverIDMachine;
import ca.infodata.syra.generated.cxf.ServActivIdMachn.ActiverIDMachineResponse;
import ca.infodata.syra.generated.cxf.ServActivIdMachn.ConfirmerActivationIdMachine;
import ca.infodata.syra.generated.cxf.ServActivIdMachn.ConfirmerActivationIdMachineResponse;
import ca.infodata.syra.generated.cxf.ServActivIdMachn.IServActivIdMachn;
import ca.infodata.syra.generated.cxf.ServActivIdMachn.ObjectFactory;
import ca.infodata.syra.handlers.ThreadSafeLastCallLogHandler;
import ca.infodata.syra.services.ActiverIdMachineCriteria;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;

public class ActiverIdMachineService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServActivIdMachn_svc/ServActivIdMachn.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServActivIdMachn_svc/ServActivIdMachn.svc";
    public static final String EVENT_TYPE = "ActiverIdMachine";
    private ObjectFactory objectFactory;
    private IServActivIdMachn proxy;
    private Map<String, Object> requestContext;
    private String endpointAddress;
    private ThreadSafeLastCallLogHandler threadSafeLastCallLogHandler;
    private DsMessageParser dsMessageParser;

    public ActiverIdMachineService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public ActiverIdMachineService(Collection<Handler> handlers, String endpoint) throws Exception {
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlers);
        this.threadSafeLastCallLogHandler = new ThreadSafeLastCallLogHandler();
        handlerChain.add(0, (Handler)this.threadSafeLastCallLogHandler);
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(IServActivIdMachn.class);
        factory.setAddress(this.endpointAddress);
        this.proxy = (IServActivIdMachn)factory.create();
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(true);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
    }

    public Transaction<ActiverIdMachineCriteria, String> renew(ActiverIdMachineCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        Client client = ClientProxy.getClient((Object)this.proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.getAuthorization().setUserName(criteria.getMachineId());
        http.getAuthorization().setPassword(criteria.getPassword());
        this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getMachineId());
        this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getPassword());
        Transaction.TransactionBuilder<ActiverIdMachineCriteria, String> builder = new Transaction.TransactionBuilder<ActiverIdMachineCriteria, String>();
        builder.setEventType(EVENT_TYPE);
        builder.setCriteria(criteria);
        builder.setEndpointAddress(this.endpointAddress);
        builder.setEventId(UUID.randomUUID().toString());
        try {
            ActiverIDMachine renewParam = this.objectFactory.createActiverIDMachine();
            renewParam.setStrIDMachine(this.objectFactory.createActiverIDMachineStrIDMachine(criteria.getMachineId()));
            renewParam.setStrAncienMotDePasse(this.objectFactory.createActiverIDMachineStrAncienMotDePasse(criteria.getPassword()));
            renewParam.setStrNoIntervenant(this.objectFactory.createActiverIDMachineStrNoIntervenant(criteria.getNoIntervenant()));
            ActiverIDMachineResponse renewResponse = this.proxy.activerIDMachine(renewParam);
            if (this.isResponseOK(renewResponse, builder)) {
                String strMotDePasseMachine = (String)renewResponse.getStrMotDePasseMachine().getValue();
                ConfirmerActivationIdMachine confirmParam = this.objectFactory.createConfirmerActivationIdMachine();
                confirmParam.setStrMotDePasseMachine(this.objectFactory.createConfirmerActivationIdMachineStrMotDePasseMachine(strMotDePasseMachine));
                confirmParam.setStrAncienMotDePasse(this.objectFactory.createConfirmerActivationIdMachineStrAncienMotDePasse(criteria.getPassword()));
                confirmParam.setStrIDMachine(this.objectFactory.createConfirmerActivationIdMachineStrIDMachine(criteria.getMachineId()));
                confirmParam.setStrNoIntervenant(this.objectFactory.createConfirmerActivationIdMachineStrNoIntervenant(criteria.getNoIntervenant()));
                ConfirmerActivationIdMachineResponse confirmerActivationIdMachine = this.proxy.confirmerActivationIdMachine(confirmParam);
                if (this.isResponseOK(confirmerActivationIdMachine, builder)) {
                    builder.setResult(strMotDePasseMachine);
                }
            }
        }
        catch (Exception e) {
            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
        }
        builder.setRawRequest(this.threadSafeLastCallLogHandler.getRequest());
        builder.setRawResponse(this.threadSafeLastCallLogHandler.getResponse());
        Transaction<ActiverIdMachineCriteria, String> r = builder.build();
        return r;
    }

    private boolean isResponseOK(ActiverIDMachineResponse result, Transaction.TransactionBuilder<ActiverIdMachineCriteria, String> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est survenue lors de la demande"));
        } else {
            String strMessage = (String)result.getCodeErreur().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private boolean isResponseOK(ConfirmerActivationIdMachineResponse result, Transaction.TransactionBuilder<ActiverIdMachineCriteria, String> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors du renouvellement"));
        } else {
            String strMessage = (String)result.getCodeErreur().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, String> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            try {
                String message = this.dsMessageParser.parse(strMessage, DsMessageParser.TYPE.NO_AND_TEXT_FICHIER);
                builder.getFaults().add(new RequestFault("ERREUR RAMQ", message));
            }
            catch (Exception e) {
                builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Erreur", e));
            }
        }
    }
}

