/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.omni.TypDatAttr;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URIConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.tukaani.xz.LZMASerialiser;

public abstract class IBaseXQuery {
    protected static final Logger logger = Logger.getLogger(IBaseXQuery.class.getName());
    protected static DatatypeFactory dataFactory;
    protected Context context = null;

    public IBaseXQuery() {
        try {
            dataFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            logger.log(Level.SEVERE, "could not instanciate DatatypeFactory ", e);
        }
    }

    public void setContext(Context c) {
        this.context = c;
    }

    public abstract String getDescription(QueryCriteria var1);

    public abstract String getDescriptionLong(QueryCriteria var1);

    public abstract Object[] getJavaObjects(QueryCriteria var1);

    public abstract Object getJavaObjectFromNode(CProfessionnal.Entente var1, String var2, XStream var3);

    public abstract List<String> getDataByCriteria(QueryCriteria var1, DataType var2) throws QueryException, IOException;

    public abstract List<String[]> getCodeDescription(QueryCriteria var1) throws QueryException, IOException;

    public Set<String> getAllOnlyCode(QueryCriteria criteria) throws QueryException, IOException {
        return null;
    }

    protected abstract String getQueryString(QueryCriteria var1, DataType var2);

    protected String getNamesWithWildcards(String name) {
        String[] n = name.split("[ ,']");
        return this.getNamesWithWildcards(n);
    }

    public List<String> getNode(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String> lstNode = new ArrayList<String>();
        String query = this.getQueryString(criteria, DataType.NODE);
        Context contexte = this.context == null ? ValidRamq.getInstance().getContext() : this.context;
        Throwable throwable = null;
        Object var6_7 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                lstNode.add(node);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    protected String getNamesWithWildcards(String[] n) {
        ArrayList<String> l = new ArrayList<String>();
        String[] stringArray = n;
        int n2 = n.length;
        int n3 = 0;
        while (n3 < n2) {
            String ss = stringArray[n3];
            if (ss.length() > 2) {
                l.add(ss);
            }
            ++n3;
        }
        String names = this.joinListForWildcards(l);
        return names;
    }

    protected String joinListForWildcards(Collection<String> l) {
        String names = "'" + new JoinList(".*','", l).toString() + ".*'";
        return names;
    }

    public XStream getXstream() {
        QNameMap qnameMap = new QNameMap();
        QName qnameCsst = new QName("urn:ramq-gouv-qc-ca:RFP", "med_admn_csst");
        QName qnameEtablSlm = new QName("urn:ramq-gouv-qc-ca:RFP", "med_admn_csst");
        QName qnameCabSlm = new QName("urn:ramq-gouv-qc-ca:RFP", "en_cab_seulm");
        QName qnamenAutor = new QName("urn:ramq-gouv-qc-ca:RFP", "no_autor");
        qnameMap.registerMapping(qnameCsst, TypDatAttr.class);
        qnameMap.registerMapping(qnameEtablSlm, TypDatAttr.class);
        qnameMap.registerMapping(qnameCabSlm, TypDatAttr.class);
        qnameMap.registerMapping(qnamenAutor, TypDatAttr.class);
        XStream xs = new XStream((HierarchicalStreamDriver)new StaxDriver(qnameMap));
        this.setConverters(xs);
        return xs;
    }

    protected void setConverters(XStream xs) {
        Mapper mapper = xs.getMapper();
        xs.registerConverter((Converter)new NullConverter(), 10000);
        xs.registerConverter((SingleValueConverter)new IntConverter(), 0);
        xs.registerConverter((SingleValueConverter)new FloatConverter(), 0);
        xs.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
        xs.registerConverter((SingleValueConverter)new LongConverter(), 0);
        xs.registerConverter((SingleValueConverter)new ShortConverter(), 0);
        xs.registerConverter((Converter)new CharConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
        xs.registerConverter((SingleValueConverter)new ByteConverter(), 0);
        xs.registerConverter((SingleValueConverter)new StringConverter(), 0);
        xs.registerConverter((SingleValueConverter)new StringBufferConverter(), 0);
        xs.registerConverter((SingleValueConverter)new MyDateConverter(), 0);
        xs.registerConverter((SingleValueConverter)new MyXMLGregorianCalendarConverter(), 0);
        xs.registerConverter((Converter)new BitSetConverter(), 0);
        xs.registerConverter((SingleValueConverter)new URIConverter(), 0);
        xs.registerConverter((SingleValueConverter)new URLConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BigIntegerConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BigDecimalConverter(), 0);
        xs.registerConverter((Converter)new ArrayConverter(mapper), 0);
        xs.registerConverter((Converter)new CharArrayConverter(), 0);
        xs.registerConverter((Converter)new CollectionConverter(mapper), 0);
        xs.registerConverter((Converter)new MapConverter(mapper), 0);
        xs.registerConverter((Converter)new TreeMapConverter(mapper), 0);
        xs.registerConverter((Converter)new TreeSetConverter(mapper), 0);
        xs.registerConverter((Converter)new SingletonCollectionConverter(mapper), 0);
        xs.registerConverter((Converter)new SingletonMapConverter(mapper), 0);
        xs.registerConverter((Converter)new PropertiesConverter(), 0);
        xs.registerConverter((Converter)new EncodedByteArrayConverter(), 0);
        xs.registerConverter((SingleValueConverter)new FileConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlTimestampConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlTimeConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlDateConverter(), 0);
        xs.registerConverter((SingleValueConverter)new LocaleConverter(), 0);
        xs.registerConverter((Converter)new GregorianCalendarConverter(), 0);
    }

    public static Object deserialize(byte[] object, boolean isLzmaCompressed) {
        if (object == null) {
            return null;
        }
        InputStream is = null;
        InputStream fis = null;
        if (isLzmaCompressed) {
            InputStream[] iss = LZMASerialiser.lzmaToInputStream((byte[])object);
            is = iss[0];
            fis = iss[1];
        } else {
            is = new ByteArrayInputStream(object);
        }
        try {
            Object object2 = IBaseXQuery.deserializePlain(is);
            return object2;
        }
        catch (Exception e) {
            return null;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static Object deserializePlain(InputStream fis) {
        Object ret = null;
        if (fis != null) {
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(fis);
                    ret = in.readObject();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static enum DataType {
        NODE,
        CODE,
        DESCRIPTION,
        DESCRIPTION_LONG,
        CODE_DESCR,
        CODE_DESCR_SHORT_LONG,
        SYS_CLA;

    }

    protected static class MyDateConverter
    extends AbstractSingleValueConverter {
        private SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd");

        protected MyDateConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(Date.class);
        }

        public String toString(Object v) {
            if (v instanceof Date) {
                return this.format.format(v);
            }
            return "";
        }

        public Date fromString(String v) {
            try {
                return this.format.parse(v);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected static class MyXMLGregorianCalendarConverter
    extends AbstractSingleValueConverter {
        private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

        protected MyXMLGregorianCalendarConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(XMLGregorianCalendar.class);
        }

        public String toString(Object v) {
            if (v instanceof XMLGregorianCalendar) {
                return this.format.format(new Timestamp(((XMLGregorianCalendar)v).toGregorianCalendar().getTimeInMillis()));
            }
            return "";
        }

        public XMLGregorianCalendar fromString(String v) {
            try {
                Date utilDate = this.format.parse(v);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(utilDate);
                DatatypeFactory dataType = DatatypeFactory.newInstance();
                XMLGregorianCalendar retXmlCal = dataType.newXMLGregorianCalendar(cal);
                return retXmlCal;
            }
            catch (ParseException | DatatypeConfigurationException e) {
                logger.log(Level.SEVERE, "XMLGregorianCalendar fromString " + v, e);
                return null;
            }
        }
    }
}

