/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.syra.models.CFactExplPmt;
import ca.infodata.syra.models.CProfExplPmt;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.ValidRamq;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URIConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;

public abstract class IBaseXExplPaimtQuery {
    protected static final Logger logger = Logger.getLogger(IBaseXExplPaimtQuery.class.getName());
    protected static DatatypeFactory dataFactory;
    protected Context context = null;
    private XStream xs = null;

    public IBaseXExplPaimtQuery() {
        try {
            dataFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            logger.log(Level.SEVERE, "could not instanciate DatatypeFactory ", e);
        }
    }

    public void setContext(Context c) {
        this.context = c;
    }

    public abstract Object[] getJavaObjects(QueryCriteria var1);

    public abstract Object getFactExplPmtFromNode(String var1, XStream var2);

    public abstract Object geProfExplPmtFromNode(String var1, XStream var2);

    public abstract List<String> getDataByCriteria(QueryCriteria var1, DataType var2) throws QueryException, IOException;

    protected abstract String getQueryString(QueryCriteria var1, DataType var2);

    public List<String> getNode(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String> lstNode = new ArrayList<String>();
        String query = this.getQueryString(criteria, DataType.ALL_NODE);
        Context contexte = this.context == null ? ValidRamq.getInstance().getContext() : this.context;
        Throwable throwable = null;
        Object var6_7 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                lstNode.add(node);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    public XStream getXstream() {
        if (this.xs == null) {
            this.xs = new XStream();
            this.setConverters(this.xs);
        }
        return this.xs;
    }

    protected void setConverters(XStream xs) {
        Mapper mapper = xs.getMapper();
        xs.registerConverter((Converter)new NullConverter(), 10000);
        xs.registerConverter((SingleValueConverter)new IntConverter(), 0);
        xs.registerConverter((SingleValueConverter)new FloatConverter(), 0);
        xs.registerConverter((SingleValueConverter)new DoubleConverter(), 0);
        xs.registerConverter((SingleValueConverter)new LongConverter(), 0);
        xs.registerConverter((SingleValueConverter)new ShortConverter(), 0);
        xs.registerConverter((Converter)new CharConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BooleanConverter(), 0);
        xs.registerConverter((SingleValueConverter)new ByteConverter(), 0);
        xs.registerConverter((SingleValueConverter)new StringConverter(), 0);
        xs.registerConverter((SingleValueConverter)new StringBufferConverter(), 0);
        xs.registerConverter((SingleValueConverter)new MyDateConverter(), 0);
        xs.registerConverter((SingleValueConverter)new MyXMLGregorianCalendarConverter(), 0);
        xs.registerConverter((Converter)new BitSetConverter(), 0);
        xs.registerConverter((SingleValueConverter)new URIConverter(), 0);
        xs.registerConverter((SingleValueConverter)new URLConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BigIntegerConverter(), 0);
        xs.registerConverter((SingleValueConverter)new BigDecimalConverter(), 0);
        xs.registerConverter((Converter)new ArrayConverter(mapper), 0);
        xs.registerConverter((Converter)new CharArrayConverter(), 0);
        xs.registerConverter((Converter)new CollectionConverter(mapper), 0);
        xs.registerConverter((Converter)new MapConverter(mapper), 0);
        xs.registerConverter((Converter)new TreeMapConverter(mapper), 0);
        xs.registerConverter((Converter)new TreeSetConverter(mapper), 0);
        xs.registerConverter((Converter)new SingletonCollectionConverter(mapper), 0);
        xs.registerConverter((Converter)new SingletonMapConverter(mapper), 0);
        xs.registerConverter((Converter)new PropertiesConverter(), 0);
        xs.registerConverter((Converter)new EncodedByteArrayConverter(), 0);
        xs.registerConverter((SingleValueConverter)new FileConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlTimestampConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlTimeConverter(), 0);
        xs.registerConverter((SingleValueConverter)new SqlDateConverter(), 0);
        xs.registerConverter((SingleValueConverter)new LocaleConverter(), 0);
        xs.registerConverter((Converter)new GregorianCalendarConverter(), 0);
    }

    public static enum DataType {
        BASE_DATA,
        ALL_NODE,
        FACT_PAIMT;

    }

    public class FactExplPmtConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return type.equals(CFactExplPmt.class);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CFactExplPmt mt = new CFactExplPmt();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("no_fact_ramq".equals(reader.getNodeName())) {
                    String sNoRf = (String)context.convertAnother((Object)mt, String.class);
                    mt.noRq = Long.valueOf(sNoRf);
                } else if ("liste_ligne_fact_paimt".equals(reader.getNodeName())) {
                    while (reader.hasMoreChildren()) {
                        CFactExplPmt.CLigneFactPmt line = new CFactExplPmt.CLigneFactPmt();
                        reader.moveDown();
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            if ("no_ligne_fact".equals(reader.getNodeName())) {
                                line.no = (Integer)context.convertAnother((Object)line, Integer.class);
                            } else if ("dat_serv".equals(reader.getNodeName())) {
                                line.ds = (String)context.convertAnother((Object)line, String.class);
                            } else if ("dat_paimt".equals(reader.getNodeName())) {
                                line.dp = (String)context.convertAnother((Object)line, String.class);
                            } else if ("formu_expl".equals(reader.getNodeName())) {
                                line.expl = (String)context.convertAnother((Object)line, String.class);
                            } else if ("mnt_paimt".equals(reader.getNodeName())) {
                                line.mnt = (BigDecimal)context.convertAnother((Object)line, BigDecimal.class);
                            }
                            reader.moveUp();
                        }
                        mt.mapLine.put(line.no, line);
                        reader.moveUp();
                    }
                }
                reader.moveUp();
            }
            return mt;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }
    }

    public class FactProfConverter
    implements Converter {
        public boolean canConvert(Class type) {
            return type.equals(CProfExplPmt.class);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            CProfExplPmt prof = new CProfExplPmt();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("no_prof".equals(reader.getNodeName())) {
                    prof.no = (String)context.convertAnother((Object)prof, String.class);
                } else if ("no_cpte_admin".equals(reader.getNodeName())) {
                    prof.grp = (String)context.convertAnother((Object)prof, String.class);
                } else if ("liste_fact_paimt".equals(reader.getNodeName())) {
                    while (reader.hasMoreChildren()) {
                        FactExplPmtConverter factExplPmtConverter = new FactExplPmtConverter();
                        reader.moveDown();
                        while (reader.hasMoreChildren()) {
                            CFactExplPmt fep = (CFactExplPmt)factExplPmtConverter.unmarshal(reader, context);
                            prof.addLine(fep);
                        }
                        reader.moveUp();
                    }
                }
                reader.moveUp();
            }
            return prof;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }
    }

    protected static class MyDateConverter
    extends AbstractSingleValueConverter {
        private SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd");

        protected MyDateConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(Date.class);
        }

        public String toString(Object v) {
            if (v instanceof Date) {
                return this.format.format(v);
            }
            return "";
        }

        public Date fromString(String v) {
            try {
                return this.format.parse(v);
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected static class MyXMLGregorianCalendarConverter
    extends AbstractSingleValueConverter {
        private SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd");

        protected MyXMLGregorianCalendarConverter() {
        }

        public boolean canConvert(Class type) {
            return type.equals(XMLGregorianCalendar.class);
        }

        public String toString(Object v) {
            if (v instanceof XMLGregorianCalendar) {
                return this.format.format(new Timestamp(((XMLGregorianCalendar)v).toGregorianCalendar().getTimeInMillis()));
            }
            return "";
        }

        public XMLGregorianCalendar fromString(String v) {
            try {
                Date utilDate = this.format.parse(v);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(utilDate);
                DatatypeFactory dataType = DatatypeFactory.newInstance();
                XMLGregorianCalendar retXmlCal = dataType.newXMLGregorianCalendar(cal);
                return retXmlCal;
            }
            catch (ParseException | DatatypeConfigurationException e) {
                logger.log(Level.SEVERE, "XMLGregorianCalendar fromString " + v, e);
                return null;
            }
        }
    }
}

