/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.hibernate.Patient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.syra.models.B2bPatientData;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CObjectUtils;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CProfessionnal;
import java.io.Serializable;
import java.util.Calendar;

public class PatientData
implements Serializable {
    public Integer id;
    public String firstName;
    public String lastName;
    public String gender;
    public Long birthDate;
    public String bds;
    public String nam;
    public Integer languageCode;
    public CProfessionnal prof;
    public CProfessionnal resident;
    public String patientRecordNumber;
    public Integer representantType;
    public CPatient representant;
    public B2bPatientData b2bPatientData;

    public PatientData() {
    }

    public PatientData(Patient patient) {
        this.setFirstName(patient.getFirstName());
        this.setId(patient.getId());
        this.setLastName(patient.getLastName());
        this.setGender(patient.getGender());
        if (patient.getBirthDate() != null) {
            this.setBirthDate(new Long(patient.getBirthDate().getTimeInMillis()));
            this.setBds(DateUtil.dtoc((Calendar)patient.getBirthDate()));
        }
        this.setNam(patient.getHealthInsuranceNumber());
        this.setLanguageCode(patient.getLanguageCode());
        IProfessionnal p = patient.getTreatingProfessionnal();
        if (p != null) {
            this.prof = CObjectUtils.getCProfFromIProf(p);
        }
        this.setPatientRecordNumber(patient.getPatientRecordNumber());
    }

    public PatientData(CDemContainer cDemContainer) {
        CPatient patient = cDemContainer.getCurrentPatient();
        this.setId(patient.getId());
        this.setFirstName(patient.getFirstName());
        this.setLastName(patient.getLastName());
        this.setGender(patient.getGender());
        if (patient.bds != null) {
            this.setBds(patient.bds);
        } else if (patient.getBirthDate() != null) {
            this.setBirthDate(new Long(patient.getBirthDate().getTimeInMillis()));
            this.setBds(DateUtil.dtoc((Calendar)patient.getBirthDate()));
        }
        this.setNam(patient.getHealthInsuranceNumber());
        this.setLanguageCode(patient.getLanguageCode());
        IProfessionnal p = patient.getTreatingProfessionnal();
        if (p != null) {
            this.prof = CObjectUtils.getCProfFromIProf(p);
        }
        this.setPatientRecordNumber(patient.getPatientRecordNumber());
    }

    public final Integer getId() {
        return this.id;
    }

    public final void setId(Integer id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public Long getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Long birthDate) {
        this.birthDate = birthDate;
    }

    public String getBds() {
        return this.bds;
    }

    public void setBds(String bds) {
        this.bds = bds;
    }

    public String getNam() {
        return this.nam;
    }

    public void setNam(String nam) {
        this.nam = nam;
    }

    public Integer getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(Integer language) {
        this.languageCode = language;
    }

    public String getPatientRecordNumber() {
        return this.patientRecordNumber;
    }

    public void setPatientRecordNumber(String patientRecordNumber) {
        this.patientRecordNumber = patientRecordNumber;
    }

    public Integer getRepresentantType() {
        return this.representantType;
    }

    public void setRepresentantType(Integer patientRepresentantType) {
        this.representantType = patientRepresentantType;
    }

    public CPatient getRepresentant() {
        return this.representant;
    }

    public void setRepresentant(CPatient patientRepresentant) {
        this.representant = patientRepresentant;
    }

    public B2bPatientData getB2bPatientData() {
        return this.b2bPatientData;
    }

    public void setB2bPatientData(B2bPatientData b2bPatientData) {
        this.b2bPatientData = b2bPatientData;
    }

    public String toString() {
        return String.format("PatientData [firstName=%s, lastName=%s, gender=%s, birthDate=%s, nam=%s, languageCode=%s, treatingProfessionnalCode=%s, patientRecordNumber=%s, patientRepresentantType=%s, patientRepresentant=%s, residentCode=%s, b2bPatientData=%s]", this.firstName, this.lastName, this.gender, this.birthDate, this.nam, this.languageCode, this.prof, this.patientRecordNumber, this.representantType, this.representant, this.resident, this.b2bPatientData);
    }
}

