/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.HibFonctions;
import ca.infodata.dossier.hibernate.base.BaseProfessionnalDAO;
import ca.infodata.dossier.hibernate.dao.AppointmentLists;
import ca.infodata.dossier.lib.dsq.IAdresseDsq;
import ca.infodata.interfaces.IAdresse;
import ca.infodata.interfaces.ICity;
import ca.infodata.interfaces.IPays;
import ca.infodata.interfaces.IProv;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICitizenship;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.util.StringUtils;
import ca.infodata.syra.models.CArchivedBill;
import ca.infodata.syra.models.CTypDiagnMdcal;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.PatientData;
import ca.infodata.syra.util.ModelUtil;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CPatient
implements IPatient,
Comparable<CPatient> {
    private static final transient AtomicInteger atomicInteger = new AtomicInteger(-1);
    public static final transient HashFunction hashFunction = Hashing.md5();
    private Integer id;
    private Integer tag;
    private Integer typIdPerson;
    private Integer idPerson;
    private String ln;
    private String mi;
    private String fn;
    private String gender;
    private Integer race;
    private transient Calendar bd;
    public String bds = "";
    public transient LocalDate ldbd;
    public Integer no = new Integer(1);
    private String note;
    private String title;
    private Boolean isDeleted;
    private Integer patientContactLien;
    private Integer patientRepresentantType;
    private String hin;
    private String dos;
    private String expCAM;
    private Integer isInsc;
    private Integer category;
    private String txProfN;
    public String allDisCodes;
    private CAdresse adr;
    public Set<CTypDiagnMdcal> lstCTypDiagnMdcal;
    public String typEvenePers = "0";
    public String datEvenePers;
    public String datEntree;
    public String datSortie;
    public List<CodeDesc> lstDx;
    private int typSituConsi;
    private int typePerson;
    private String nas;
    private CPatient persRepdn;
    private String idPersAutre;
    private Integer typPersAutre;
    private Integer typIdPersAutre;
    private BigDecimal imc;
    private PatientData ptData;
    public transient ListMultimap<String, CArchivedBill> mmPlafBill = ArrayListMultimap.create();
    private static final long serialVersionUID = 1L;

    public CPatient() {
    }

    public CPatient(AppointmentLists.PatientListText patientListText) {
        if (patientListText.getBirthDate() != null) {
            this.bds = LocalDate.fromCalendar((Calendar)patientListText.getBirthDate()).formatHyphen();
        }
        this.setGender(patientListText.getGender());
        this.setNaissanceOrder(patientListText.getNaissanceOrder());
        this.setHealthInsuranceNumber(patientListText.getHealthInsuranceNumber());
        if (StringUtils.isNotEmpty((String)this.getHealthInsuranceNumber())) {
            this.setTypIdPerson(new Integer(1));
            this.setTypePerson(1);
            this.setTypSituConsi(1);
        } else {
            this.setTypIdPerson(null);
            this.setTypePerson(2);
            int age = this.getAge();
            this.setTypSituConsi(age < 1 ? 2 : 3);
        }
        this.tag = patientListText.getIdPatient() == null ? CPatient.getTempId() : patientListText.getIdPatient();
    }

    public static Integer getTempId() {
        return new Integer(atomicInteger.getAndDecrement());
    }

    public static String getIdent(CPatient p) {
        String ident = "";
        if (p.typePerson < 3) {
            if (StringUtils.isNotEmpty((String)p.hin)) {
                ident = p.hin;
            } else if (StringUtils.isNotEmpty((String)p.ln)) {
                String ddnNo = StringUtils.isNotEmpty((String)p.bds) ? ", " + p.bds.substring(0, 10) + ":" + p.no : "";
                String sexe = StringUtils.isNotEmpty((String)p.gender) ? "(" + p.gender + ")" : "";
                String firstName = StringUtils.isNotEmpty((String)p.fn) ? " " + p.fn : "";
                ident = String.valueOf(p.ln) + firstName + ddnNo + sexe;
            }
        } else if (StringUtils.isNotEmpty((String)p.idPersAutre)) {
            ident = p.idPersAutre;
        } else if (StringUtils.isNotEmpty((String)p.ln)) {
            String firstName = StringUtils.isNotEmpty((String)p.fn) ? " " + p.fn : "";
            ident = String.valueOf(p.ln) + firstName;
        }
        return ident;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public final Integer getTag() {
        return this.tag;
    }

    public final void setTag(Integer tag) {
        this.tag = tag;
    }

    public Integer getTypIdPerson() {
        return this.typIdPerson;
    }

    public void setTypIdPerson(Integer typIdPerson) {
        this.typIdPerson = typIdPerson;
    }

    public void initialize() {
    }

    public void setLastName(String lastName) {
        this.ln = lastName;
    }

    public String getSearchLastName() {
        return null;
    }

    public void setSearchLastName(String searchLastName) {
    }

    public String getMidInitial() {
        return this.mi;
    }

    public void setMidInitial(String midInitial) {
        this.mi = midInitial;
    }

    public void setFirstName(String firstName) {
        this.fn = firstName;
    }

    public String getSearchFirstName() {
        return null;
    }

    public void setSearchFirstName(String searchFirstName) {
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public void setRace(Integer race) {
        this.race = race;
    }

    public Integer getLanguageCode() {
        return null;
    }

    public void setLanguageCode(Integer languageCode) {
    }

    public Integer getMaritalStatus() {
        return null;
    }

    public void setMaritalStatus(Integer maritalStatus) {
    }

    public void setBirthDate(Calendar birthDate) {
        this.bd = birthDate;
    }

    public final LocalDate getLdbirthDate() {
        return this.ldbd;
    }

    public final void setLdbirthDate(LocalDate ldbirthDate) {
        this.ldbd = ldbirthDate;
        this.bds = ldbirthDate == null ? "" : ldbirthDate.formatHyphen();
    }

    public final Integer getPatientContactLien() {
        return this.patientContactLien;
    }

    public final void setPatientContactLien(Integer patientContactLien) {
        this.patientContactLien = patientContactLien;
    }

    public final Integer getPatientRepresentantType() {
        return this.patientRepresentantType;
    }

    public final void setPatientRepresentantType(Integer patientRepresentantType) {
        this.patientRepresentantType = patientRepresentantType;
    }

    public final void setHealthInsuranceNumber(String healthInsuranceNumber) {
        this.hin = healthInsuranceNumber;
    }

    public final void setPatientRecordNumber(String patientRecordNumber) {
        this.dos = patientRecordNumber;
    }

    public final void setExpirationCAM(String expirationCAM) {
        this.expCAM = expirationCAM;
    }

    public Boolean getIsUser() {
        return Boolean.FALSE;
    }

    public void setIsUser(Boolean isUser) {
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public ICitizenship getCitizenship() {
        return null;
    }

    public void setCitizenship(ICitizenship citizenship) {
    }

    public String getPswdForProtectedDoc() {
        return null;
    }

    public void setPswdForProtectedDoc(String pswdForProtectedDoc) {
    }

    public Integer getScanned() {
        return null;
    }

    public void setScanned(Integer s) {
    }

    public void setNiu(String niu) {
    }

    public String getAliasSk() {
        return null;
    }

    public void setAliasSk(String aliasSk) {
    }

    public String getLastNameDsq() {
        return null;
    }

    public void setLastNameDsq(String lastNameDsq) {
    }

    public String getFirstNameDsq() {
        return null;
    }

    public void setFirstNameDsq(String firstNameDsq) {
    }

    public MultiStatus save() {
        return null;
    }

    public void delete() {
    }

    public IAdresseDsq getAddressDsq() {
        return null;
    }

    public Integer getId() {
        return this.id;
    }

    public List<Integer> getAllIds() {
        return null;
    }

    public String getFirstName() {
        return this.fn;
    }

    public String getLastName() {
        return this.ln;
    }

    public String getName() {
        return null;
    }

    public String getNameBirthdateSex() {
        return null;
    }

    public String getPatientRecordNumber() {
        return this.dos;
    }

    public String getHealthInsuranceNumber() {
        return this.hin;
    }

    public String getExpirationCAM() {
        return this.expCAM;
    }

    public IProfessionnal getTreatingProfessionnal() {
        return StringUtils.isEmpty((String)this.txProfN) ? null : BaseProfessionnalDAO.getInstance().getProfTxFromNoProf(this.txProfN);
    }

    public Integer getIsInscritGMF() {
        return this.isInsc;
    }

    public void setIsInscritGMF(Integer isInscritGMF) {
        this.isInsc = isInscritGMF;
    }

    public final Integer getCategory() {
        return this.category;
    }

    public final void setCategory(Integer category) {
        this.category = category;
    }

    public LocalDate getLDBirthDate() {
        return this.ldbd;
    }

    public Calendar getBirthDate() {
        if (this.bd != null) {
            return this.bd;
        }
        Calendar calendar = this.bd = this.ldbd == null ? null : DateUtil.getCalendarFromLong((long)this.ldbd.toTimeInMillisUTC());
        if (this.bd == null && this.bds != null) {
            this.bd = DateUtil.ctod((String)this.bds);
        }
        return this.bd;
    }

    public String getGender() {
        return this.gender;
    }

    public Integer getRace() {
        return this.race;
    }

    public String getNiu() {
        return null;
    }

    public int getAge() {
        return this.getAge(this.getBirthDate());
    }

    public Integer getIdPerson() {
        return this.idPerson;
    }

    public void setIdPerson(Integer i) {
        this.idPerson = i;
    }

    public IPatient clone() {
        return null;
    }

    public Integer getIdContact1() {
        return null;
    }

    public Integer getTypeContact1() {
        return null;
    }

    public IContactInformation getFirstContactInformation() {
        return null;
    }

    public Integer getIdContact2() {
        return null;
    }

    public Integer getTypeContact2() {
        return null;
    }

    public IContactInformation getSecondContactInformation() {
        return null;
    }

    public static int getAge(LocalDate birthdate) {
        return CPatient.getAgeAtASpecificDate(birthdate, LocalDate.today());
    }

    public static int getAgeAtASpecificDate(LocalDate birthdate, LocalDate base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        if (birthdate == null) {
            return -1;
        }
        LocalDate today = base;
        int age = today.year - birthdate.year;
        if (today.before((IPartialDate)birthdate.withYear(today.year))) {
            --age;
        }
        return age;
    }

    public int getAge(Calendar birthdate) {
        return CPatient.getAge(LocalDate.fromCalendar((Calendar)birthdate));
    }

    public static Integer getAgeAtASpecificDate(Calendar birthdate, LocalDate base) {
        return new Integer(CPatient.getAgeAtASpecificDate(LocalDate.fromCalendar((Calendar)birthdate), base));
    }

    public double getAgeEnMois(Calendar birthdate) {
        if (birthdate == null) {
            return 0.0;
        }
        Calendar today = DateUtil.newCalendar();
        double AVERAGE_MILLIS_PER_MONTH = 2.629728E9;
        double rep = (double)(today.getTimeInMillis() - birthdate.getTimeInMillis()) / AVERAGE_MILLIS_PER_MONTH;
        return rep;
    }

    public void setTreatingProfessionnalName(String treatingProfessionnalName) {
        this.setTxProfN(treatingProfessionnalName);
    }

    public void setAllDisabilityCodes(String allDisabilityCodes) {
        this.allDisCodes = allDisabilityCodes;
    }

    public final Set<CTypDiagnMdcal> getLstCTypDiagnMdcal() {
        if (this.lstCTypDiagnMdcal == null) {
            this.lstCTypDiagnMdcal = new TreeSet<CTypDiagnMdcal>();
        }
        return this.lstCTypDiagnMdcal;
    }

    public final void addCTypDiagnMdcal(CTypDiagnMdcal dx) {
        this.getLstCTypDiagnMdcal().add(dx);
    }

    public final void removeCTypDiagnMdcal(CTypDiagnMdcal dx) {
        this.getLstCTypDiagnMdcal().remove(dx);
    }

    public IAdresse getAdresse() {
        if (this.adr == null) {
            this.adr = new CAdresse();
        }
        return this.adr;
    }

    public void setAdresse(IAdresse a) {
        this.adr = (CAdresse)a;
    }

    public int getTypSituConsi() {
        return this.typSituConsi;
    }

    public void setTypSituConsi(int t) {
        this.typSituConsi = t;
    }

    public int getTypePerson() {
        return this.typePerson;
    }

    public void setTypePerson(int typePerson) {
        this.typePerson = typePerson;
    }

    public int hashCode() {
        return ModelUtil.hashCodeFor(this.tag);
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof CPatient)) {
            return false;
        }
        CPatient that = (CPatient)aThat;
        return HibFonctions.EqualsUtil.areEqual((Object)this.tag, (Object)that.tag);
    }

    @Override
    public int compareTo(CPatient o) {
        if (this.hin != null && o.hin != null) {
            return this.hin.compareTo(o.hin);
        }
        if (this.hin == null && o.hin == null) {
            int i = this.getLastName().compareTo(o.getLastName());
            if (i == 0) {
                i = this.getFirstName().compareTo(o.getFirstName());
            }
            return i;
        }
        return 0;
    }

    public void setNas(String s) {
        this.nas = s;
    }

    public String getNas() {
        return this.nas;
    }

    public String getTxProfN() {
        return this.txProfN;
    }

    public void setTxProfN(String txProfN) {
        this.txProfN = txProfN;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, (ToStringStyle)new RecursiveToStringStyle()).toString();
    }

    public String getStringForHash(int i) {
        String stringToHash;
        if (i != 0 && StringUtils.isNotEmpty((String)this.getHealthInsuranceNumber())) {
            stringToHash = this.getHealthInsuranceNumber();
        } else {
            String ddn = this.bds;
            if (StringUtils.isEmpty((String)ddn)) {
                if (this.getLDBirthDate() != null) {
                    ddn = this.bds = this.getLDBirthDate().formatHyphen();
                } else {
                    return "";
                }
            }
            if (this.getAdresse() == null || StringUtils.isEmpty((String)this.getAdresse().getPostalCode())) {
                return "";
            }
            String g = this.getGender();
            if (StringUtils.isEmpty((String)g)) {
                return "";
            }
            String l = this.getLastName();
            if (StringUtils.isEmpty((String)l)) {
                return "";
            }
            String cp = this.getAdresse().getPostalCode();
            stringToHash = String.valueOf(l) + ", " + ddn + ":" + this.getNaissanceOrder() + "(" + this.getGender() + "), " + cp;
        }
        return stringToHash;
    }

    public static int getStringToHashCode(String s) {
        return hashFunction.newHasher().putString((CharSequence)s.replaceAll("[, /(/)/:/-]", ""), Charsets.UTF_8).hash().asInt();
    }

    public Integer getNaissanceOrder() {
        return this.no;
    }

    public void setNaissanceOrder(Integer i) {
        this.no = i;
    }

    public CPatient getPersRepdn() {
        return this.persRepdn;
    }

    public void setPersRepdn(CPatient persRepdn) {
        this.persRepdn = persRepdn;
    }

    public Integer getTypIdPersAutre() {
        return this.typIdPersAutre;
    }

    public void setTypIdPersAutre(Integer typIdPersAutre) {
        this.typIdPersAutre = typIdPersAutre;
    }

    public String getIdPersAutre() {
        return this.idPersAutre;
    }

    public void setIdPersAutre(String idPersAutre) {
        this.idPersAutre = idPersAutre;
    }

    public Integer getTypPersAutre() {
        return this.typPersAutre;
    }

    public void setTypPersAutre(Integer typPersAutre) {
        this.typPersAutre = typPersAutre;
    }

    public BigDecimal getImc() {
        return this.imc;
    }

    public void setImc(BigDecimal imc) {
        this.imc = imc;
    }

    public PatientData getPtData() {
        return this.ptData;
    }

    public void setPtData(PatientData ptData) {
        this.ptData = ptData;
    }

    public static class Ages {
        private int jours;
        private int mois;
        private int ans;

        public Ages() {
        }

        public Ages(LocalDate birthdate, LocalDate base) {
            if (base == null) {
                base = LocalDate.today();
            }
            int age = base.year - birthdate.year;
            this.setAns(age);
            if (base.before((IPartialDate)birthdate.withYear(base.year))) {
                this.setAns(this.getAns() - 1);
            }
            int m = base.month - birthdate.month;
            int ageMois = age * 12 + m;
            this.setMois(ageMois);
            if (base.day < birthdate.day) {
                this.setMois(this.getMois() - 1);
            }
            this.setJours(base.dayFrom1970 - birthdate.dayFrom1970);
        }

        public int getAns() {
            return this.ans;
        }

        public void setAns(int ans) {
            this.ans = ans;
        }

        public int getMois() {
            return this.mois;
        }

        public void setMois(int mois) {
            this.mois = mois;
        }

        public int getJours() {
            return this.jours;
        }

        public void setJours(int jours) {
            this.jours = jours;
        }
    }

    public static class CAdresse
    implements IAdresse {
        Integer i;
        String a1;
        CCity cy;
        String cp;
        CProv pr;
        CPays py;

        public CAdresse() {
        }

        public CAdresse(Integer i, String a1, CCity cy, String cp, CProv pr, CPays py) {
            this.i = i;
            this.a1 = a1;
            this.cy = cy;
            this.cp = cp;
            this.pr = pr;
            this.py = py;
        }

        public final Integer getId() {
            return this.i;
        }

        public final void setId(Integer i) {
            this.i = i;
        }

        public final String getStreet() {
            return this.a1;
        }

        public final void setStreet(String a1) {
            this.a1 = a1;
        }

        public final ICity getCity() {
            if (this.cy == null) {
                this.cy = new CCity();
            }
            return this.cy;
        }

        public final void setCity(ICity cy) {
            this.cy = (CCity)cy;
        }

        public final String getPostalCode() {
            return this.cp;
        }

        public final void setPostalCode(String cp) {
            this.cp = cp;
        }

        public final IProv getProvince() {
            if (this.pr == null) {
                this.pr = new CProv();
            }
            return this.pr;
        }

        public final void setProvince(IProv pr) {
            this.pr = (CProv)pr;
        }

        public final IPays getCountry() {
            return this.py;
        }

        public final void setCountry(IPays py) {
            this.py = (CPays)py;
        }
    }

    public static class CCity
    implements ICity {
        Integer i;
        String n;

        public CCity() {
        }

        public CCity(Integer id, String name) {
            this.i = id;
            this.n = name;
        }

        public final Integer getId() {
            return this.i;
        }

        public final void setId(Integer i) {
            this.i = i;
        }

        public final String getName() {
            return this.n;
        }

        public final void setName(String n) {
            this.n = n;
        }
    }

    public static class CPays
    implements IPays {
        Integer i;
        String n;

        public CPays() {
        }

        public CPays(Integer id, String name) {
            this.i = id;
            this.n = name;
        }

        public final Integer getId() {
            return this.i;
        }

        public final void setId(Integer i) {
            this.i = i;
        }

        public final String getName() {
            return this.n;
        }

        public final void setName(String n) {
            this.n = n;
        }
    }

    public static class CProv
    implements IProv {
        Integer i;
        String n;

        public CProv(Integer id, String name) {
            this.i = id;
            this.n = name;
        }

        public CProv() {
        }

        public final Integer getId() {
            return this.i;
        }

        public final void setId(Integer i) {
            this.i = i;
        }

        public final String getName() {
            return this.n;
        }

        public final void setName(String n) {
            this.n = n;
        }
    }
}

