/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.hibernate.base.BaseProfessionnalDAO;
import ca.infodata.dossier.hibernate.fmedx.Groupe;
import ca.infodata.dossier.hibernate.fmedx.base.BaseGroupeDAO;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.models.CEtab;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.xsd.valid.CodLocal;
import ca.infodata.syra.xsd.valid.InfoEtab;
import ca.infodata.util1.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class CObjectUtils {
    protected static transient DateFormat dateFormatDT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    protected static transient DateFormat dateFormatD = new SimpleDateFormat("yyyy-MM-dd");
    protected static transient SyraController controller = (SyraController)SonarDispatcher.getController((String)"/syra/*");

    public static InfoEtab.ValEtab getEtab(String idLieuPhysArr) {
        InfoEtab.ValEtab valEtab = null;
        Object[] res = controller.getEtablissement(idLieuPhysArr);
        if (res instanceof InfoEtab.ValEtab[] && res.length > 0) {
            InfoEtab.ValEtab[] local = (InfoEtab.ValEtab[])res;
            valEtab = local[0];
        }
        return valEtab;
    }

    public static CodLocal.ValCodLocal getLocal(String idLieuGeoArr) {
        CodLocal.ValCodLocal nameGeoArr = null;
        Object[] res = controller.getLocalite(idLieuGeoArr);
        if (res instanceof CodLocal.ValCodLocal[] && res.length > 0) {
            CodLocal.ValCodLocal[] local = (CodLocal.ValCodLocal[])res;
            nameGeoArr = local[0];
        }
        return nameGeoArr;
    }

    public static CProfessionnal getProf(String idProf) {
        return CObjectUtils.getCProfFromIProf((IProfessionnal)BaseProfessionnalDAO.getInstance().findByCode(idProf));
    }

    public static CProfessionnal getCProfFromIProf(IProfessionnal p) {
        if (p == null || "0000000".equals(p.getCode())) {
            return null;
        }
        String codSpec = "00";
        String specDesc = "S/O";
        if (p.getSpeciality() != null) {
            codSpec = p.getSpeciality().getCode();
            specDesc = p.getSpeciality().getDescription();
        }
        String noAgence = "";
        String noGroup = "";
        String specTx = "";
        String particularSitu = "";
        Integer modeRemu = new Integer(0);
        if (p.getProfessionnalFacturation() != null) {
            boolean alwaysUseGroup = false;
            if (p.getProfessionnalFacturation().getAlwaysUseGroup() != null) {
                Groupe groupe;
                boolean bl = alwaysUseGroup = p.getProfessionnalFacturation().getAlwaysUseGroup() != 0;
                if (alwaysUseGroup && p.getProfessionnalFacturation().getNoGroup() != null && (groupe = BaseGroupeDAO.getInstance().load(p.getProfessionnalFacturation().getNoGroup())) != null) {
                    noGroup = groupe.getNumero();
                }
            }
            modeRemu = p.getProfessionnalFacturation().getRemunerationType();
            noAgence = p.getProfessionnalFacturation().getNoAgenceRamq();
            specTx = p.getProfessionnalFacturation().getSpecialTreatment();
            particularSitu = p.getProfessionnalFacturation().getParticularSituation();
        }
        CProfessionnal pr = new CProfessionnal(p.getId(), p.getCode(), codSpec, specDesc, p.getType(), modeRemu, noAgence, noGroup, particularSitu, specTx, p.getFirstName(), p.getLastName(), p.getIsTreatingProfessionnal());
        return pr;
    }

    public static CodeDesc getGroupe(String noCpteAdmin) {
        Groupe grp;
        CodeDesc cd = null;
        if (noCpteAdmin != null && (grp = BaseGroupeDAO.getInstance().findByNumero(StringUtils.padLeft((String)noCpteAdmin.toString(), (int)5, (char)'0'))) != null) {
            cd = new CodeDesc(grp.getNumero(), grp.getDescrip());
        }
        return cd;
    }

    public static CEtab.CValNoSectActiv getSecteur(String noSect, int ent, String d) {
        return controller.getValNoSecteur(StringUtils.padLeft((String)noSect.toString(), (int)2, (char)'0'), CProfessionnal.Entente.valueOf(ent), d);
    }
}

