/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.util.date.LocalDate;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.SyraPlugin;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.controller.SyraPrefAndXmlDataController;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CEtab;
import ca.infodata.syra.models.CLieu;
import ca.infodata.syra.models.CLocal;
import ca.infodata.syra.models.CObjectUtils;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CProfessionnalPrefData;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.models.CodeBigIntCodFact;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.INoLigne;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.xsd.valid.IElmMesur;
import ca.infodata.syra.xsd.valid.InfoEtab;
import ca.infodata.syra.xsd.valid.omni.CodFact;
import ca.infodata.syra.xsd.valid.spec.CodFact;
import ca.infodata.util1.StringUtils;
import ca.qc.gouv.ramq.rfp.FactServMdcalOmni210;
import ca.qc.gouv.ramq.rfp.FactServMdcalSpec210;
import ca.qc.gouv.ramq.rfp.TypElmMesur;
import ca.qc.gouv.ramq.rfp.TypIdLieu;
import ca.qc.gouv.ramq.rfp.TypIdLieuGeo;
import ca.qc.gouv.ramq.rfp.TypLieuRefreGeoOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefreOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefrePhysOmni;
import ca.qc.gouv.ramq.rfp.TypLieuRefrePhysSpec;
import ca.qc.gouv.ramq.rfp.TypLieuRefreSpec;
import ca.qc.gouv.ramq.rfp.TypProf;
import ca.qc.gouv.ramq.rfp.TypProfNonConnu;
import com.google.gson.GsonBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;

public class CLigneTypServMdcal
extends CObjectUtils
implements INoLigne {
    protected transient SyraController controller;
    public int noLigne;
    public String dateServ;
    public String typIdElmFact;
    public CodeBigIntCodFact codFact;
    public Integer codRefreSituSpeci;
    public Integer codRole;
    public String dhdElmFact;
    public String dhfElmFact;
    public List<Mesur> lstTempMesur;
    public List<CodeDesc> lstTempElmCx;
    public List<CodeDesc> lstElmCx;
    public List<Mesur> lstMesur;
    public BigDecimal mntPrcuPatnt;
    public int typRefreAutreProf;
    public int typProfRef;
    public int typIdProfRefreConnu;
    public String idProfRefConnu;
    public int codTerriProfRefre;
    public int typPrfsnProfRefre;
    public String nomProfRefre;
    public String preProfRefre;
    public String dhDemConsult;
    public BigInteger codOmim;
    public int typRefreLieu;
    public List<CLieu> lstTempLieuEnRef;
    public List<CLieu> lstLieuEnRef;
    private static transient List<BigInteger> lstPlateauOmni = Arrays.asList(BigInteger.valueOf(1098L));
    private static transient List<BigInteger> lstPlateauSpec = Arrays.asList(BigInteger.valueOf(1097L), BigInteger.valueOf(1098L), BigInteger.valueOf(1099L));
    private static transient Map<Integer, List<BigInteger>> mapPlateaux = new HashMap<Integer, List<BigInteger>>();
    static Set<BigInteger> lstMdRefSpec;
    static Set<BigInteger> lstRefInfSpec;
    static Set<BigInteger> lstRefSagFSpec;
    static Set<BigInteger> lstRefPharmSpec;
    static Set<BigInteger> lstRefIntSpec;
    static Set<BigInteger> lstRefAudioSpec;
    static Set<BigInteger> lstMdRefOmni;
    static Set<BigInteger> lstRefInfOmni;
    static Set<BigInteger> lstRefSagFOmni;
    static Set<BigInteger> lstRefPharmOmni;
    static Set<BigInteger> lstRefIntOmni;
    static Set<BigInteger> lstLieuRef;
    static Set<BigInteger> lstNeedDDM;
    static Set<BigInteger> lstNeedDPA;
    static Map<BigInteger, CodeBigIntCodFact.AddedCode[]> mapAddedCodes;

    static {
        mapPlateaux.put(new Integer(1), lstPlateauOmni);
        mapPlateaux.put(new Integer(2), lstPlateauSpec);
        lstMdRefSpec = new HashSet<BigInteger>(0);
        lstRefInfSpec = new HashSet<BigInteger>(0);
        lstRefSagFSpec = new HashSet<BigInteger>(0);
        lstRefPharmSpec = new HashSet<BigInteger>(0);
        lstRefIntSpec = new HashSet<BigInteger>(0);
        lstRefAudioSpec = new HashSet<BigInteger>(0);
        lstMdRefOmni = new HashSet<BigInteger>(0);
        lstRefInfOmni = new HashSet<BigInteger>(0);
        lstRefSagFOmni = new HashSet<BigInteger>(0);
        lstRefPharmOmni = new HashSet<BigInteger>(0);
        lstRefIntOmni = new HashSet<BigInteger>(0);
        lstLieuRef = new HashSet<BigInteger>(0);
        lstNeedDDM = new HashSet<BigInteger>(0);
        lstNeedDPA = new HashSet<BigInteger>(0);
        mapAddedCodes = new HashMap<BigInteger, CodeBigIntCodFact.AddedCode[]>();
    }

    public CLigneTypServMdcal() {
    }

    /*
     * WARNING - void declaration
     */
    public CLigneTypServMdcal(CDemContainer demContainer, Integer role, BigInteger codeFact, boolean addedCode) {
        CProfessionnal prof = demContainer.getCurrentProf();
        this.noLigne = ++demContainer.getCurrentDemPaimt().servNextNoLigne;
        this.dateServ = demContainer.getSyraSettings(ConnectionFactory.connectionLabel).getDateDef();
        this.lstTempElmCx = new ArrayList<CodeDesc>();
        CProfessionnal.Entente entente = null;
        if (prof != null) {
            entente = prof.getType() == null ? CProfessionnal.Entente.NON_DEF : CProfessionnal.Entente.valueOf(prof.getType());
            CProfessionnalPrefData prefData = SyraAccessorClient.getInstance().getPrefData(prof.getId());
            String autoCx = prefData.getPrefAutre("autoCx");
            if (Boolean.TRUE.equals(demContainer.getSyraSettings().getBoolean("autoContexte")) && StringUtils.isNotEmpty((String)autoCx)) {
                String[] cxs;
                CLieu currentLieu = demContainer.getCurrentLieu(prof);
                String activeLieu = null;
                String activeSect = null;
                if ("C".equals(currentLieu.typLocEtab)) {
                    if (currentLieu.etab != null && StringUtils.isNotEmpty((String)currentLieu.etab.noSelectedEtab)) {
                        activeLieu = currentLieu.etab.noSelectedEtab;
                        if (currentLieu.etab.valSect != null && StringUtils.isNotEmpty((String)currentLieu.etab.valSect.getNoSectActiv())) {
                            activeSect = currentLieu.etab.valSect.getNoSectActiv();
                        }
                    }
                } else if ("N".equals(currentLieu.typLocEtab) && currentLieu.local != null && currentLieu.local.valCodLocal != null && StringUtils.isNotEmpty((String)currentLieu.local.valCodLocal.getCodLocal())) {
                    activeLieu = currentLieu.local.valCodLocal.getCodLocal();
                }
                String[] stringArray = cxs = autoCx.split(";");
                int n = cxs.length;
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    String cx = stringArray[n2];
                    String[] stringArray2 = cx.split(":");
                    String[] c = stringArray2[0].split("-");
                    String codeEtab = c[0];
                    String string2 = string = c.length == 2 ? c[1] : null;
                    if (stringArray2.length == 2 && codeEtab.equals(activeLieu) && (string == null || string.equals(activeSect))) {
                        String[] ctxs = stringArray2[1].split(" ");
                        String[] stringArray3 = ctxs;
                        int n3 = ctxs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String code = stringArray3[n4];
                            QueryCriteria.CodNiveau codNiveau = QueryCriteria.CodNiveau.from("L");
                            String date = this.dateServ;
                            Integer idAnchorProf = prof.getId();
                            String repn = SyraPlugin.syraController.getElmContxDesc(idAnchorProf, code, date, codNiveau);
                            CodeDesc res = new CodeDesc(code, repn);
                            this.lstTempElmCx.add(res);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            CLieu currentLieu2 = demContainer.getCurrentLieu(prof);
            boolean mustAddCtx70 = false;
            if (prof.getType() == 2 && Boolean.TRUE.equals(demContainer.getSyraSettings().getBoolean("autoInsertCtx1810", Boolean.TRUE))) {
                if (Boolean.TRUE.equals(demContainer.getSyraSettings().getBoolean("is_soir_nuit"))) {
                    mustAddCtx70 = true;
                } else if (demContainer.getDateDefaut() != null && currentLieu2 != null && currentLieu2.etab != null && currentLieu2.etab.getValEtab() != null && currentLieu2.etab.getValEtab().getCalenJourFerie() != null && currentLieu2.etab.getValEtab().getCalenJourFerie().getListeJourFerie() != null) {
                    LocalDate d = demContainer.getDateDefaut();
                    mustAddCtx70 = CLigneTypServMdcal.isFinSemOuFerie(currentLieu2, d);
                }
            }
            if (mustAddCtx70) {
                CodeDesc ctx = new CodeDesc("70", "Soins d'urgence");
                this.lstTempElmCx.add(ctx);
            }
        }
        String spec = null;
        if (role == null) {
            this.codRole = new Integer(1);
            if (prof != null && "03".equals(spec = prof.getCodSpec())) {
                this.codRole = new Integer(2);
            }
        } else {
            this.codRole = role;
        }
        if (codeFact != null && prof != null && entente != null) {
            int nbMaxPlat;
            CLieu currentLieu = demContainer.getCurrentLieu(prof);
            QueryCriteria.EtablType typEtab = QueryCriteria.EtablType.CABINET;
            if ("C".equals(currentLieu.typLocEtab) && currentLieu.etab != null && StringUtils.isNotEmpty((String)currentLieu.etab.noSelectedEtab)) {
                typEtab = "ETAB".equals(currentLieu.etab.valEtab.getTypEtab()) ? QueryCriteria.EtablType.ETABLISSEMENT : QueryCriteria.EtablType.CABINET;
            }
            List<BigInteger> listPlat = mapPlateaux.get(entente.value);
            HashMap<Integer, CLigneTypServMdcal> mapLineWithPlateau = new HashMap<Integer, CLigneTypServMdcal>();
            HashMap<Integer, CLigneTypServMdcal> mapLineNotWithPlateau = new HashMap<Integer, CLigneTypServMdcal>();
            HashMap mapLineWithModifiedPlateau = new HashMap();
            ArrayList<Integer> lstLineToDel = new ArrayList<Integer>();
            CodeBigIntCodFact addedCodFact = null;
            int n = nbMaxPlat = CProfessionnal.Entente.OMNI.equals((Object)entente) ? 1 : 2;
            if (addedCode && Integer.valueOf(1).equals(demContainer.getCurrentDemPaimt().type) && demContainer.getCurrentDemPaimt().serv != null) {
                if (demContainer.getCurrentDemPaimt().serv.mapTempLigneFact.size() > 1) {
                    for (Map.Entry entry : demContainer.getCurrentDemPaimt().serv.mapTempLigneFact.entrySet()) {
                        Integer noLigne = (Integer)entry.getKey();
                        CLigneTypServMdcal cLigneTypServMdcal = (CLigneTypServMdcal)entry.getValue();
                        System.out.println("CLigneTypServMdcal = " + cLigneTypServMdcal.dateServ + ", r\u00e9p. = " + (cLigneTypServMdcal == null ? null : String.valueOf(cLigneTypServMdcal.dateServ) + ", " + (cLigneTypServMdcal.codFact == null ? "codFact is null" : cLigneTypServMdcal.codFact.c)));
                        if (cLigneTypServMdcal.codFact == null) continue;
                        if (listPlat.contains(cLigneTypServMdcal.codFact.c)) {
                            mapLineWithPlateau.put(noLigne, cLigneTypServMdcal);
                            continue;
                        }
                        mapLineNotWithPlateau.put(noLigne, cLigneTypServMdcal);
                    }
                    if (mapLineWithPlateau.size() <= mapLineNotWithPlateau.size() && (mapLineWithPlateau.size() < 1 || nbMaxPlat != 1)) {
                        if (mapLineWithPlateau.size() == 0) {
                            addedCodFact = CProfessionnal.Entente.OMNI.equals((Object)entente) ? CLigneTypServMdcal.getCodFactOmni(null, SyraPlugin.syraController, prof.getId(), true, codeFact, null, this.dateServ, this.codRole, typEtab) : CLigneTypServMdcal.getCodFactSpec(null, SyraPlugin.syraController, prof.getId(), true, codeFact, null, this.dateServ, this.codRole, typEtab);
                            if (addedCodFact != null && addedCodFact.c != null) {
                                this.codFact = addedCodFact;
                            }
                        } else if (mapLineWithPlateau.size() >= 1 && nbMaxPlat > 1) {
                            CodeDesc codeDesc = new CodeDesc("720", "PDT multiple exe\u0301cute\u0301 lors d'une me\u0302me se\u0301ance");
                            addedCodFact = CLigneTypServMdcal.getCodFactSpec(null, SyraPlugin.syraController, prof.getId(), true, codeFact, null, this.dateServ, this.codRole, typEtab);
                            if (addedCodFact != null && addedCodFact.c != null) {
                                Set esLineWithPlateau = mapLineWithPlateau.entrySet();
                                ArrayList<CLigneTypServMdcal> lstCodPlat = new ArrayList<CLigneTypServMdcal>(esLineWithPlateau.size());
                                for (Map.Entry entry : esLineWithPlateau) {
                                    lstCodPlat.add((CLigneTypServMdcal)entry.getValue());
                                }
                                if (lstCodPlat.size() == 1) {
                                    if (addedCodFact.c.longValue() <= ((CLigneTypServMdcal)lstCodPlat.get((int)0)).codFact.c.longValue()) {
                                        this.lstTempElmCx.contains(codeDesc);
                                    } else if (addedCodFact.c.longValue() > ((CLigneTypServMdcal)lstCodPlat.get((int)0)).codFact.c.longValue()) {
                                        if (((CLigneTypServMdcal)lstCodPlat.get((int)0)).lstTempElmCx == null) {
                                            ((CLigneTypServMdcal)lstCodPlat.get((int)0)).lstTempElmCx = new ArrayList<CodeDesc>();
                                        }
                                        ((CLigneTypServMdcal)lstCodPlat.get((int)0)).lstTempElmCx.contains(codeDesc);
                                    }
                                    this.codFact = addedCodFact;
                                } else {
                                    Collections.sort(lstCodPlat, new Comparator<CLigneTypServMdcal>(){

                                        @Override
                                        public int compare(CLigneTypServMdcal o1, CLigneTypServMdcal o2) {
                                            return o1.codFact.c.compareTo(o2.codFact.c);
                                        }
                                    });
                                    if (addedCodFact.c.longValue() > ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 1))).codFact.c.longValue()) {
                                        void var20_34;
                                        boolean bl = false;
                                        while (var20_34 < lstCodPlat.size() - 1) {
                                            lstLineToDel.add(new Integer(((CLigneTypServMdcal)lstCodPlat.get((int)var20_34)).getNoLigne()));
                                            ++var20_34;
                                        }
                                        if (((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 1))).lstTempElmCx == null) {
                                            ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 1))).lstTempElmCx = new ArrayList<CodeDesc>();
                                        }
                                        ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 1))).lstTempElmCx.contains(codeDesc);
                                        this.codFact = addedCodFact;
                                    } else if (addedCodFact.c.longValue() == ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 1))).codFact.c.longValue()) {
                                        if (addedCodFact.c.longValue() > ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 2))).codFact.c.longValue()) {
                                            void var20_36;
                                            boolean bl = false;
                                            while (var20_36 < lstCodPlat.size() - 1) {
                                                lstLineToDel.add(new Integer(((CLigneTypServMdcal)lstCodPlat.get((int)var20_36)).getNoLigne()));
                                                ++var20_36;
                                            }
                                            this.lstTempElmCx.contains(codeDesc);
                                            this.codFact = addedCodFact;
                                        }
                                    } else if (addedCodFact.c.longValue() > ((CLigneTypServMdcal)lstCodPlat.get((int)(lstCodPlat.size() - 2))).codFact.c.longValue()) {
                                        void var20_38;
                                        boolean bl = false;
                                        while (var20_38 < lstCodPlat.size() - 1) {
                                            lstLineToDel.add(new Integer(((CLigneTypServMdcal)lstCodPlat.get((int)var20_38)).getNoLigne()));
                                            ++var20_38;
                                        }
                                        this.lstTempElmCx.contains(codeDesc);
                                        this.codFact = addedCodFact;
                                    }
                                    if (!lstLineToDel.isEmpty()) {
                                        for (Integer n5 : lstLineToDel) {
                                            demContainer.getCurrentDemPaimt().serv.mapTempLigneFact.remove(n5);
                                        }
                                        CTypeObject cTypeObject = new CTypeObject("removeLignesByNoServMdcalFromLst", lstLineToDel);
                                        String msgCLigneTypServMdcalType = new GsonBuilder().create().toJson((Object)cTypeObject);
                                        HtmlBrowserTools.sendMessageToWebClient((String)demContainer.uid, (String)msgCLigneTypServMdcalType);
                                    }
                                }
                                if (!mapLineWithModifiedPlateau.isEmpty()) {
                                    CTypeObject cTypeObject = new CTypeObject("modifiyLignesServMdcalOfLst", mapLineWithModifiedPlateau);
                                    String msgDemPaimtType = new GsonBuilder().create().toJson((Object)cTypeObject);
                                    HtmlBrowserTools.sendMessageToWebClient((String)demContainer.uid, (String)msgDemPaimtType);
                                }
                            }
                        }
                    }
                } else {
                    this.codFact = CProfessionnal.Entente.OMNI.equals((Object)entente) ? CLigneTypServMdcal.getCodFactOmni(null, SyraPlugin.syraController, prof.getId(), true, codeFact, null, this.dateServ, this.codRole, typEtab) : CLigneTypServMdcal.getCodFactSpec(null, SyraPlugin.syraController, prof.getId(), true, codeFact, null, this.dateServ, this.codRole, typEtab);
                }
            }
        } else {
            this.codFact = new CodeBigIntCodFact();
        }
        if (this.lstTempElmCx.isEmpty()) {
            this.lstTempElmCx.add(new CodeDesc("", null));
        }
        this.lstTempLieuEnRef = new ArrayList<CLieu>();
        this.lstTempLieuEnRef.add(new CLieu("C", "0", new Integer(0), "3", "0"));
        this.typRefreLieu = entente == null || entente.equals((Object)CProfessionnal.Entente.OMNI) ? 12 : 5;
        this.typRefreAutreProf = 1;
        this.typIdProfRefreConnu = 1;
        this.codTerriProfRefre = 1;
        this.typPrfsnProfRefre = 1;
        this.typProfRef = 1;
    }

    public static boolean isFinSemOuFerie(CLieu currentLieu2, LocalDate d) {
        boolean mustAddCtx70 = false;
        if (d.dayOfWeek == 1 || d.dayOfWeek == 7) {
            mustAddCtx70 = true;
        } else if (d.month == 1 && d.day == 1) {
            mustAddCtx70 = true;
        } else if (d.month == 6 && d.day == 24) {
            mustAddCtx70 = true;
        } else if (d.month == 7 && d.day == 1) {
            mustAddCtx70 = true;
        } else if (d.month == 12 && d.day == 25) {
            mustAddCtx70 = true;
        } else if (d.month == 9 && d.dayOfWeek == 2 && d.day < 8) {
            mustAddCtx70 = true;
        } else if (d.month == 10 && d.dayOfWeek == 2 && d.day > 7 && d.day < 16) {
            mustAddCtx70 = true;
        } else if (currentLieu2 != null && currentLieu2.etab != null && currentLieu2.etab.getValEtab() != null) {
            List<Serializable> listJrFer = currentLieu2.etab.getValEtab().getCalenJourFerie().getListeJourFerie().getContent();
            for (Serializable jrFerO : listJrFer) {
                InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.JrFerie jrFer = (InfoEtab.ValEtab.CalenJourFerie.ListeJourFerie.JrFerie)jrFerO;
                XMLGregorianCalendar dtJrFerie = jrFer.getDtJrFerie();
                if (dtJrFerie.getDay() == 14) {
                    System.out.println("day 14");
                }
                LocalDate ldFer = LocalDate.from((int)dtJrFerie.getDay(), (int)dtJrFerie.getMonth(), (int)dtJrFerie.getYear());
                System.out.println("day = " + dtJrFerie.getDay() + ", month = " + dtJrFerie.getMonth() + ", year = " + dtJrFerie.getYear());
                if (d.dayFrom1970 != ldFer.dayFrom1970) continue;
                mustAddCtx70 = true;
                break;
            }
        }
        return mustAddCtx70;
    }

    public CLigneTypServMdcal(CDemContainer cDemContainer, SyraController controller, Object o, Integer idProfAnchor, boolean withDetail) {
        this.controller = controller;
        this.lstTempLieuEnRef = new ArrayList<CLieu>();
        this.typRefreAutreProf = 1;
        this.typIdProfRefreConnu = 1;
        this.codTerriProfRefre = 1;
        this.typPrfsnProfRefre = 1;
        this.typProfRef = 1;
        if (o instanceof FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni) {
            FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf refreAutreProf;
            TypLieuRefreOmni lieuEnRefre;
            FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni l = (FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni)o;
            this.noLigne = l.getNoLigneFact();
            this.dateServ = ConvertJavaToFromArray.getDateString(l.getDatServElmFact());
            this.typRefreLieu = 12;
            Integer codR = new Integer(1);
            try {
                codR = Integer.valueOf(l.getCodRole());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.codRole = codR;
            FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmMesur listeElmMesur2 = l.getListeElmMesur();
            boolean hasElmMesur = listeElmMesur2 != null && !listeElmMesur2.getElmMesur().isEmpty();
            HashSet<Integer> setIdElmMesur = new HashSet<Integer>();
            if (l.getIdElmFact() != null) {
                this.codFact = CLigneTypServMdcal.getCodFactOmni(cDemContainer, controller, idProfAnchor, withDetail || hasElmMesur, l.getIdElmFact(), setIdElmMesur, this.dateServ, this.codRole, QueryCriteria.EtablType.SO);
            }
            this.typIdElmFact = l.getTypIdElmFact();
            Integer n = this.codRefreSituSpeci = l.getCodRefreSituSpeci() == null ? null : (Integer)l.getCodRefreSituSpeci().getValue();
            if (l.getDhdElmFact() != null) {
                this.dhdElmFact = ConvertJavaToFromArray.getDateTimeString((XMLGregorianCalendar)l.getDhdElmFact().getValue());
            }
            if (l.getDhfElmFact() != null) {
                this.dhfElmFact = ConvertJavaToFromArray.getDateTimeString((XMLGregorianCalendar)l.getDhfElmFact().getValue());
            }
            if ((lieuEnRefre = l.getLieuEnRefre()) != null) {
                this.typRefreLieu = lieuEnRefre.getTypRefreLieu();
                if (lieuEnRefre.getListeLieuRefre() != null && !lieuEnRefre.getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo().isEmpty()) {
                    for (TypIdLieu ol : lieuEnRefre.getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo()) {
                        CLieu lieuER;
                        if (ol instanceof TypLieuRefrePhysOmni) {
                            TypLieuRefrePhysOmni tp = (TypLieuRefrePhysOmni)ol;
                            lieuER = new CLieu();
                            lieuER.typLocEtab = "C";
                            lieuER.etab = new CEtab(tp.getIdLieuPhys(), tp.getCodPreciLieu() == null ? "0" : (String)tp.getCodPreciLieu().getValue());
                            if (withDetail) {
                                lieuER.etab.valEtab = CLigneTypServMdcal.getEtab(tp.getIdLieuPhys());
                            }
                            lieuER.etab.codPreciSectActiv = tp.getCodPreciSectActiv() != null ? (Integer)tp.getCodPreciSectActiv().getValue() : new Integer(0);
                            Integer noSect = null;
                            CEtab.CValNoSectActiv valSect = null;
                            if (tp.getNoSectActiv() != null) {
                                noSect = (Integer)tp.getNoSectActiv().getValue();
                                valSect = withDetail ? CLigneTypServMdcal.getSecteur(noSect.toString(), CProfessionnal.Entente.OMNI.getValue(), this.dateServ) : new CEtab.CValNoSectActiv(String.valueOf(noSect), "", CProfessionnal.Entente.OMNI);
                                lieuER.etab.valSect = valSect;
                            } else {
                                lieuER.etab.valSect = new CEtab.CValNoSectActiv();
                            }
                            this.lstTempLieuEnRef.add(lieuER);
                            continue;
                        }
                        if (!(ol instanceof TypLieuRefreOmni.ListeLieuRefre.LieuRefreGeo)) continue;
                        Iterator<TypElmMesur> tl = (TypLieuRefreOmni.ListeLieuRefre.LieuRefreGeo)ol;
                        lieuER = new CLieu();
                        lieuER.typLocEtab = "N";
                        lieuER.local = new CLocal(((TypIdLieuGeo)((Object)tl)).getIdLieuGeo(), ((TypLieuRefreGeoOmni)((Object)tl)).getCodPreciLieu() == null ? "0" : (String)((TypLieuRefreGeoOmni)((Object)tl)).getCodPreciLieu().getValue(), ((TypIdLieuGeo)((Object)tl)).getTypIdLieuGeo(), ((TypLieuRefreGeoOmni)((Object)tl)).getTypLieuGeo());
                        if (withDetail && "3".equals(((TypIdLieuGeo)((Object)tl)).getTypIdLieuGeo())) {
                            lieuER.local.valCodLocal = CLigneTypServMdcal.getLocal(((TypIdLieuGeo)((Object)tl)).getIdLieuGeo());
                        }
                        this.lstTempLieuEnRef.add(lieuER);
                    }
                }
            }
            if (this.lstTempLieuEnRef.isEmpty()) {
                CLieu lieuER = new CLieu("C", "0", new Integer(0), null, null);
                this.lstTempLieuEnRef.add(lieuER);
            }
            FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx listeElmContx = l.getListeElmContx();
            this.lstTempElmCx = new ArrayList<CodeDesc>();
            if (listeElmContx != null && !listeElmContx.getElmContx().isEmpty()) {
                for (FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.ListeElmContx.ElmContx ec : l.getListeElmContx().getElmContx()) {
                    String elmContxDesc;
                    String desc = "";
                    if (withDetail && StringUtils.isNotEmpty((String)(elmContxDesc = controller.getElmContxDesc(idProfAnchor, String.valueOf(ec.getCodElmContx()), this.dateServ != null ? this.dateServ.substring(0, 10) : null, QueryCriteria.CodNiveau.NONE)))) {
                        desc = elmContxDesc;
                    }
                    CodeDesc cx = new CodeDesc(String.valueOf(ec.getCodElmContx()), desc);
                    this.lstTempElmCx.add(cx);
                }
                Collections.sort(this.lstTempElmCx);
            } else {
                CodeDesc cx = new CodeDesc("", "");
                this.lstTempElmCx.add(cx);
            }
            if (hasElmMesur) {
                this.lstTempMesur = new ArrayList<Mesur>();
                for (TypElmMesur m : listeElmMesur2.getElmMesur()) {
                    Integer idElm = new Integer(m.getCodElmMesur());
                    if (!setIdElmMesur.contains(idElm)) continue;
                    IElmMesur iElmMesur = this.codFact.mapElmMesur.get(idElm);
                    this.lstTempMesur.add(new Mesur(idElm, iElmMesur.getNomElmMesur(), iElmMesur.getTypUnitMes(), m.getValMes()));
                    setIdElmMesur.remove(idElm);
                }
                for (Integer idElm : setIdElmMesur) {
                    IElmMesur iElmMesur = this.codFact.mapElmMesur.get(idElm);
                    this.lstTempMesur.add(new Mesur(idElm, iElmMesur.getNomElmMesur(), iElmMesur.getTypUnitMes(), new BigDecimal(0)));
                }
                Collections.sort(this.lstTempMesur);
            }
            if (l.getMntPrcuPatnt() != null) {
                this.mntPrcuPatnt = (BigDecimal)l.getMntPrcuPatnt().getValue();
            }
            if ((refreAutreProf = l.getRefreAutreProf()) != null) {
                this.typRefreAutreProf = refreAutreProf.getTypRefreAutreProf();
                FactServMdcalOmni210.ListeLigneFactServMdcalOmni.LigneFactServMdcalOmni.RefreAutreProf.InfoProfRefre infoProfRefre = refreAutreProf.getInfoProfRefre();
                TypProf profRefreConnu = infoProfRefre.getProfRefreConnu();
                if (profRefreConnu != null && StringUtils.isNotEmpty((String)profRefreConnu.getIdProf())) {
                    this.setProfRefreConnu(controller, withDetail, profRefreConnu);
                } else {
                    TypProfNonConnu profRefreNonConnu = infoProfRefre.getProfRefreNonConnu();
                    this.setProfRefreNonconnu(profRefreNonConnu);
                }
            }
        } else if (o instanceof FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec) {
            FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf refreAutreProf;
            FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmMesur listeElmMesur;
            FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx listeElmContx;
            TypLieuRefreSpec lieuRefreSpec;
            FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec l = (FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec)o;
            this.noLigne = l.getNoLigneFact();
            this.dateServ = ConvertJavaToFromArray.getDateString(l.getDatServElmFact());
            this.typRefreLieu = 5;
            Integer codR = new Integer(1);
            try {
                codR = Integer.valueOf(l.getCodRole());
            }
            catch (NumberFormatException listeElmMesur2) {
                // empty catch block
            }
            this.codRole = codR;
            HashSet<Integer> setIdElmMesur = new HashSet<Integer>();
            if (l.getIdElmFact() != null) {
                this.codFact = CLigneTypServMdcal.getCodFactSpec(cDemContainer, controller, idProfAnchor, withDetail, l.getIdElmFact(), setIdElmMesur, this.dateServ, this.codRole, QueryCriteria.EtablType.SO);
            }
            this.typIdElmFact = l.getTypIdElmFact();
            Integer n = this.codRefreSituSpeci = l.getCodRefreSituSpeci() == null ? null : (Integer)l.getCodRefreSituSpeci().getValue();
            if (l.getDhdElmFact() != null) {
                this.dhdElmFact = ConvertJavaToFromArray.getDateTimeString((XMLGregorianCalendar)l.getDhdElmFact().getValue());
            }
            if (l.getDhfElmFact() != null) {
                this.dhfElmFact = ConvertJavaToFromArray.getDateTimeString((XMLGregorianCalendar)l.getDhfElmFact().getValue());
            }
            if (l.getCodOmim() != null) {
                this.codOmim = (BigInteger)l.getCodOmim().getValue();
            }
            if ((lieuRefreSpec = l.getLieuEnRefre()) != null) {
                this.typRefreLieu = lieuRefreSpec.getTypRefreLieu();
                if (lieuRefreSpec.getListeLieuRefre() != null && !lieuRefreSpec.getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo().isEmpty()) {
                    for (Object ol : lieuRefreSpec.getListeLieuRefre().getLieuRefrePhysOrLieuRefreGeo()) {
                        CLieu lieuER;
                        if (ol instanceof TypLieuRefrePhysSpec) {
                            TypLieuRefrePhysSpec tp = (TypLieuRefrePhysSpec)ol;
                            lieuER = new CLieu();
                            lieuER.typLocEtab = "C";
                            lieuER.etab = new CEtab(tp.getIdLieuPhys(), tp.getCodPreciLieu() == null ? "0" : (String)tp.getCodPreciLieu().getValue());
                            if (withDetail) {
                                lieuER.etab.valEtab = CLigneTypServMdcal.getEtab(tp.getIdLieuPhys());
                            }
                            lieuER.etab.codPreciSectActiv = tp.getCodPreciSectActiv() != null ? (Integer)tp.getCodPreciSectActiv().getValue() : new Integer(0);
                            Integer noSect = null;
                            CEtab.CValNoSectActiv valSect = null;
                            if (tp.getNoSectActiv() != null) {
                                noSect = (Integer)tp.getNoSectActiv().getValue();
                                valSect = withDetail ? CLigneTypServMdcal.getSecteur(noSect.toString(), CProfessionnal.Entente.SPEC.getValue(), this.dateServ) : new CEtab.CValNoSectActiv(String.valueOf(noSect), "", CProfessionnal.Entente.SPEC);
                                lieuER.etab.valSect = valSect;
                            } else {
                                lieuER.etab.valSect = new CEtab.CValNoSectActiv();
                            }
                            this.lstTempLieuEnRef.add(lieuER);
                            continue;
                        }
                        if (!(ol instanceof TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo)) continue;
                        TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo tl = (TypLieuRefreSpec.ListeLieuRefre.LieuRefreGeo)ol;
                        lieuER = new CLieu();
                        lieuER.typLocEtab = "N";
                        lieuER.local = new CLocal(tl.getIdLieuGeo(), tl.getCodPreciLieu() == null ? "0" : (String)tl.getCodPreciLieu().getValue(), tl.getTypIdLieuGeo(), tl.getTypLieuGeo());
                        if (withDetail && "3".equals(tl.getTypIdLieuGeo())) {
                            lieuER.local.valCodLocal = CLigneTypServMdcal.getLocal(tl.getIdLieuGeo());
                        }
                        this.lstTempLieuEnRef.add(lieuER);
                    }
                }
            }
            if (this.lstTempLieuEnRef.isEmpty()) {
                CLieu lieuER = new CLieu("C", "0", new Integer(0), null, null);
                this.lstTempLieuEnRef.add(lieuER);
            }
            if ((listeElmContx = l.getListeElmContx()) != null && !listeElmContx.getElmContx().isEmpty()) {
                this.lstTempElmCx = new ArrayList<CodeDesc>();
                for (FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.ListeElmContx.ElmContx ec : l.getListeElmContx().getElmContx()) {
                    String elmContxDesc;
                    Object desc = "";
                    if (withDetail && StringUtils.isNotEmpty((String)(elmContxDesc = controller.getElmContxDesc(idProfAnchor, String.valueOf(ec.getCodElmContx()), this.dateServ != null ? this.dateServ.substring(0, 10) : null, QueryCriteria.CodNiveau.NONE)))) {
                        desc = elmContxDesc;
                    }
                    CodeDesc cx = new CodeDesc(String.valueOf(ec.getCodElmContx()), (String)desc);
                    this.lstTempElmCx.add(cx);
                }
                Collections.sort(this.lstTempElmCx);
            }
            if ((listeElmMesur = l.getListeElmMesur()) != null && !listeElmMesur.getElmMesur().isEmpty()) {
                this.lstTempMesur = new ArrayList<Mesur>();
                for (TypElmMesur m : listeElmMesur.getElmMesur()) {
                    Integer idElm = new Integer(m.getCodElmMesur());
                    if (!setIdElmMesur.contains(idElm)) continue;
                    IElmMesur iElmMesur = this.codFact.mapElmMesur.get(idElm);
                    this.lstTempMesur.add(new Mesur(idElm, iElmMesur.getNomElmMesur(), iElmMesur.getTypUnitMes(), m.getValMes()));
                    setIdElmMesur.remove(idElm);
                }
                for (Integer idElm : setIdElmMesur) {
                    IElmMesur iElmMesur = this.codFact.mapElmMesur.get(idElm);
                    this.lstTempMesur.add(new Mesur(idElm, iElmMesur.getNomElmMesur(), iElmMesur.getTypUnitMes(), new BigDecimal(0)));
                }
                Collections.sort(this.lstTempMesur);
            }
            if (l.getMntPrcuPatnt() != null) {
                this.mntPrcuPatnt = (BigDecimal)l.getMntPrcuPatnt().getValue();
            }
            if ((refreAutreProf = l.getRefreAutreProf()) != null) {
                this.typRefreAutreProf = refreAutreProf.getTypRefreAutreProf();
                FactServMdcalSpec210.ListeLigneFactServMdcalSpec.LigneFactServMdcalSpec.RefreAutreProf.InfoProfRefre infoProfRefre = refreAutreProf.getInfoProfRefre();
                TypProf profRefreConnu = infoProfRefre.getProfRefreConnu();
                if (profRefreConnu != null && StringUtils.isNotEmpty((String)profRefreConnu.getIdProf())) {
                    this.setProfRefreConnu(controller, withDetail, profRefreConnu);
                } else {
                    TypProfNonConnu profRefreNonConnu = infoProfRefre.getProfRefreNonConnu();
                    this.setProfRefreNonconnu(profRefreNonConnu);
                }
                if (refreAutreProf.getDhDemCnsul() != null) {
                    this.dhDemConsult = ConvertJavaToFromArray.getDateTimeString((XMLGregorianCalendar)refreAutreProf.getDhDemCnsul().getValue());
                }
            }
        }
    }

    public static void needMdRefSpec(String val) {
        lstMdRefSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needInfSpec(String val) {
        lstRefInfSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needSagFSpec(String val) {
        lstRefSagFSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needPharmSpec(String val) {
        lstRefPharmSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needIntSpec(String val) {
        lstRefIntSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needAudioSpec(String val) {
        lstRefAudioSpec = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needMdRefOmni(String val) {
        lstMdRefOmni = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needInfOmni(String val) {
        lstRefInfOmni = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needSagFOmni(String val) {
        lstRefSagFOmni = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needPharmOmni(String val) {
        lstRefPharmOmni = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needIntOmni(String val) {
        lstRefIntOmni = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needLieuRef(String val) {
        lstLieuRef = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needDDM(String val) {
        lstNeedDDM = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void needDPA(String val) {
        lstNeedDPA = SyraPrefAndXmlDataController.bigIntSetFromString(val);
    }

    public static void putAddCode(String s) {
        if (StringUtils.isNotEmpty((String)s)) {
            String[] codSect;
            String[] stringArray = codSect = s.split("~");
            int n = codSect.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                String[] sAddCodes = cd[1].split(";");
                CodeBigIntCodFact.AddedCode[] addCodes = new CodeBigIntCodFact.AddedCode[sAddCodes.length];
                int i = 0;
                while (i < sAddCodes.length) {
                    String[] add = sAddCodes[i].split("-");
                    addCodes[i] = new CodeBigIntCodFact.AddedCode(new Integer(add[0]), new BigInteger(add[1]), new Boolean("1".equals(add[2])));
                    ++i;
                }
                mapAddedCodes.put(new BigInteger(cd[0]), addCodes);
                ++n2;
            }
        }
    }

    public static CodeBigIntCodFact getCodFactOmni(CDemContainer cDemContainer, SyraPrefAndXmlDataController controller, Integer idProfAnchor, boolean withDetail, BigInteger idElmFact, Set<Integer> setIdElmMesur, String dateServ, Integer iRole, QueryCriteria.EtablType etablType) {
        CodeBigIntCodFact codFactTemp = null;
        String codeFactDesc = "";
        String dateServDTOS = dateServ.replaceAll("[/-]", "");
        CodFact.ValCodFact elmFact = null;
        HashMap<Integer, IElmMesur> elmMesur = null;
        Boolean csst = Boolean.FALSE;
        Boolean noAutor = Boolean.FALSE;
        ArrayList<Integer> lstRoles = new ArrayList<Integer>();
        Boolean needRefMd = Boolean.FALSE;
        Boolean needRefInf = Boolean.FALSE;
        Boolean needRefSagF = Boolean.FALSE;
        Boolean needRefPharm = Boolean.FALSE;
        Boolean needRefInt = Boolean.FALSE;
        Boolean needRefAudio = Boolean.FALSE;
        Boolean needLieuRef = Boolean.FALSE;
        Boolean needDDM = Boolean.FALSE;
        Boolean needDPA = Boolean.FALSE;
        CodeBigIntCodFact.AddedCode[] addedCodes2 = null;
        if (withDetail) {
            Integer role1 = new Integer(1);
            elmFact = (CodFact.ValCodFact)controller.getCodeFacturation(cDemContainer, idProfAnchor, idElmFact.toString(), dateServ, iRole, etablType);
            if (elmFact == null && !role1.equals(iRole)) {
                elmFact = (CodFact.ValCodFact)controller.getCodeFacturation(cDemContainer, idProfAnchor, idElmFact.toString(), dateServ, role1, etablType);
            }
            if (elmFact != null) {
                codeFactDesc = elmFact.getDesCodFact();
                CodFact.ValCodFact.ListeAttri listeAttri = elmFact.getListeAttri();
                if (listeAttri != null && listeAttri.getContent().size() > 0) {
                    elmMesur = new HashMap<Integer, IElmMesur>();
                    for (Serializable content : listeAttri.getContent()) {
                        Serializable lContent;
                        if (content instanceof CodFact.ValCodFact.ListeAttri.ListeElmMesur) {
                            lContent = (CodFact.ValCodFact.ListeAttri.ListeElmMesur)content;
                            for (Serializable oContent : ((CodFact.ValCodFact.ListeAttri.ListeElmMesur)lContent).getContent()) {
                                XMLGregorianCalendar df;
                                IElmMesur mes;
                                XMLGregorianCalendar dd;
                                boolean dateValid;
                                if (!(oContent instanceof IElmMesur) || !(dateValid = CLigneTypServMdcal.valueValidForDateServ(dateServDTOS, dd = (mes = (IElmMesur)oContent).getDdEffecElmMesur(), df = mes.getDfEffecElmMesur()))) continue;
                                Integer id = new Integer(mes.getCodElmMesur());
                                if (setIdElmMesur != null) {
                                    setIdElmMesur.add(id);
                                }
                                elmMesur.put(id, mes);
                            }
                            continue;
                        }
                        if (content instanceof CodFact.ValCodFact.ListeAttri.ListeRole) {
                            lContent = (CodFact.ValCodFact.ListeAttri.ListeRole)content;
                            for (Serializable oContent : ((CodFact.ValCodFact.ListeAttri.ListeRole)lContent).getContent()) {
                                if (!(oContent instanceof CodFact.ValCodFact.ListeAttri.ListeRole.Role)) continue;
                                CodFact.ValCodFact.ListeAttri.ListeRole.Role r = (CodFact.ValCodFact.ListeAttri.ListeRole.Role)oContent;
                                lstRoles.add(new Integer(r.getCodRole().intValue()));
                            }
                            continue;
                        }
                        if (!(content instanceof JAXBElement)) continue;
                        JAXBElement iJaxb = (JAXBElement)content;
                        if ("med_admn_csst".equals(iJaxb.getName().getLocalPart())) {
                            csst = Boolean.TRUE;
                            continue;
                        }
                        if (!"no_autor".equals(iJaxb.getName().getLocalPart())) continue;
                        noAutor = Boolean.TRUE;
                    }
                }
                needRefMd = lstMdRefOmni.contains(idElmFact);
                needRefInf = lstRefInfOmni.contains(idElmFact);
                needRefSagF = lstRefSagFOmni.contains(idElmFact);
                needRefPharm = lstRefPharmOmni.contains(idElmFact);
                needRefInt = lstRefIntOmni.contains(idElmFact);
                needLieuRef = lstLieuRef.contains(idElmFact);
                needDDM = lstNeedDDM.contains(idElmFact);
                needDPA = lstNeedDPA.contains(idElmFact);
                addedCodes2 = mapAddedCodes.get(idElmFact);
                codFactTemp = new CodeBigIntCodFact(idElmFact, codeFactDesc, elmMesur, csst, noAutor, needRefMd, needRefInf, needRefSagF, needRefPharm, needRefInt, needRefAudio, needLieuRef, needDDM, needDPA, addedCodes2, lstRoles.toArray(new Integer[0]));
            }
        } else {
            codFactTemp = new CodeBigIntCodFact(idElmFact, codeFactDesc, elmMesur, csst, noAutor, needRefMd, needRefInf, needRefSagF, needRefPharm, needRefInt, needRefAudio, needLieuRef, needDDM, needDPA, addedCodes2, lstRoles.toArray(new Integer[0]));
        }
        return codFactTemp;
    }

    private static boolean valueValidForDateServ(String dateServDTOS, XMLGregorianCalendar dd, XMLGregorianCalendar df) {
        String dfs;
        String dds;
        boolean valid = true;
        if (dd != null && dateServDTOS.compareTo(dds = String.valueOf(dd.getYear()) + (dd.getMonth() < 9 ? "0" + dd.getMonth() : String.valueOf(dd.getMonth())) + (dd.getDay() < 10 ? "0" + dd.getDay() : String.valueOf(dd.getDay()))) < 0) {
            valid = false;
        }
        if (valid && df != null && dateServDTOS.compareTo(dfs = String.valueOf(df.getYear()) + (df.getMonth() < 9 ? "0" + df.getMonth() : String.valueOf(df.getMonth())) + (df.getDay() < 10 ? "0" + df.getDay() : String.valueOf(df.getDay()))) >= 0) {
            valid = false;
        }
        return valid;
    }

    public static CodeBigIntCodFact getCodFactSpec(CDemContainer cDemContainer, SyraPrefAndXmlDataController controller, Integer idProfAnchor, boolean withDetail, BigInteger idElmFact, Set<Integer> setIdElmMesur, String dateServ, Integer iRole, QueryCriteria.EtablType etablType) {
        CodeBigIntCodFact codFactTemp = null;
        String codeFactDesc = "";
        String dateServDTOS = dateServ.replaceAll("[/-]", "");
        CodFact.ValCodFact elmFact = null;
        HashMap<Integer, IElmMesur> elmMesur = null;
        Boolean csst = Boolean.FALSE;
        Boolean noAutor = Boolean.FALSE;
        ArrayList<Integer> lstRoles = new ArrayList<Integer>();
        Boolean needRefMd = Boolean.FALSE;
        Boolean needRefInf = Boolean.FALSE;
        Boolean needRefSagF = Boolean.FALSE;
        Boolean needRefPharm = Boolean.FALSE;
        Boolean needRefInt = Boolean.FALSE;
        Boolean needRefAudio = Boolean.FALSE;
        Boolean needLieuRef = Boolean.FALSE;
        Boolean needDDM = Boolean.FALSE;
        Boolean needDPA = Boolean.FALSE;
        CodeBigIntCodFact.AddedCode[] addedCodes2 = null;
        if (withDetail) {
            Integer role1 = new Integer(1);
            elmFact = (CodFact.ValCodFact)controller.getCodeFacturation(cDemContainer, idProfAnchor, idElmFact.toString(), dateServ, iRole, etablType);
            if (elmFact == null && !role1.equals(iRole)) {
                elmFact = (CodFact.ValCodFact)controller.getCodeFacturation(cDemContainer, idProfAnchor, idElmFact.toString(), dateServ, role1, etablType);
            }
            if (elmFact != null) {
                codeFactDesc = elmFact.getDesCodFact();
                CodFact.ValCodFact.ListeAttri listeAttri = elmFact.getListeAttri();
                if (listeAttri != null && listeAttri.getContent().size() > 0) {
                    elmMesur = new HashMap<Integer, IElmMesur>();
                    for (Serializable content : listeAttri.getContent()) {
                        Serializable lContent;
                        if (content instanceof CodFact.ValCodFact.ListeAttri.ListeElmMesur) {
                            lContent = (CodFact.ValCodFact.ListeAttri.ListeElmMesur)content;
                            for (Serializable oContent : ((CodFact.ValCodFact.ListeAttri.ListeElmMesur)lContent).getContent()) {
                                XMLGregorianCalendar df;
                                IElmMesur mes;
                                XMLGregorianCalendar dd;
                                boolean dateValid;
                                if (!(oContent instanceof IElmMesur) || !(dateValid = CLigneTypServMdcal.valueValidForDateServ(dateServDTOS, dd = (mes = (IElmMesur)oContent).getDdEffecElmMesur(), df = mes.getDfEffecElmMesur()))) continue;
                                Integer id = new Integer(mes.getCodElmMesur());
                                if (setIdElmMesur != null) {
                                    setIdElmMesur.add(id);
                                }
                                elmMesur.put(id, mes);
                            }
                            continue;
                        }
                        if (content instanceof CodFact.ValCodFact.ListeAttri.ListeRoleSpec) {
                            lContent = (CodFact.ValCodFact.ListeAttri.ListeRoleSpec)content;
                            for (Serializable oContent : ((CodFact.ValCodFact.ListeAttri.ListeRoleSpec)lContent).getContent()) {
                                if (!(oContent instanceof CodFact.ValCodFact.ListeAttri.ListeRoleSpec.RoleSpec)) continue;
                                lstRoles.add(new Integer(((CodFact.ValCodFact.ListeAttri.ListeRoleSpec.RoleSpec)oContent).getCodRole().intValue()));
                            }
                            continue;
                        }
                        if (!(content instanceof JAXBElement)) continue;
                        JAXBElement iJaxb = (JAXBElement)content;
                        if ("med_admn_csst".equals(iJaxb.getName().getLocalPart())) {
                            csst = Boolean.TRUE;
                            continue;
                        }
                        if (!"no_autor".equals(iJaxb.getName().getLocalPart())) continue;
                        noAutor = Boolean.TRUE;
                    }
                }
                needRefMd = lstMdRefSpec.contains(idElmFact);
                needRefInf = lstRefInfSpec.contains(idElmFact);
                needRefSagF = lstRefSagFSpec.contains(idElmFact);
                needRefPharm = lstRefPharmSpec.contains(idElmFact);
                needRefInt = lstRefIntSpec.contains(idElmFact);
                needRefAudio = lstRefAudioSpec.contains(idElmFact);
                needLieuRef = lstLieuRef.contains(idElmFact);
                needDDM = lstNeedDDM.contains(idElmFact);
                needDPA = lstNeedDPA.contains(idElmFact);
                addedCodes2 = mapAddedCodes.get(idElmFact);
                codFactTemp = new CodeBigIntCodFact(idElmFact, codeFactDesc, elmMesur, csst, noAutor, needRefMd, needRefInf, needRefSagF, needRefPharm, needRefInt, needRefAudio, needLieuRef, needDDM, needDPA, addedCodes2, lstRoles.toArray(new Integer[0]));
            }
        } else {
            codFactTemp = new CodeBigIntCodFact(idElmFact, codeFactDesc, elmMesur, csst, noAutor, needRefMd, needRefInf, needRefSagF, needRefPharm, needRefInt, needRefAudio, needLieuRef, needDDM, needDPA, addedCodes2, lstRoles.toArray(new Integer[0]));
        }
        return codFactTemp;
    }

    protected void setProfRefreNonconnu(TypProfNonConnu profRefreNonConnu) {
        if (profRefreNonConnu != null) {
            this.typProfRef = 2;
            this.typPrfsnProfRefre = profRefreNonConnu.getTypPrfsnProf();
            this.nomProfRefre = profRefreNonConnu.getNomProf();
            this.preProfRefre = profRefreNonConnu.getPreProf();
            this.codTerriProfRefre = profRefreNonConnu.getCodTerriProfRefre();
        }
    }

    protected void setProfRefreConnu(SyraController controller, boolean withDetail, TypProf profRefreConnu) {
        if (profRefreConnu != null) {
            CProfessionnal[] cProfessionnals;
            this.typProfRef = 1;
            this.typIdProfRefreConnu = profRefreConnu.getTypIdProf();
            this.idProfRefConnu = profRefreConnu.getIdProf();
            if (withDetail && (cProfessionnals = controller.findProfessionals(this.idProfRefConnu)) != null && cProfessionnals.length == 1) {
                this.nomProfRefre = cProfessionnals[0].getLastName();
                this.preProfRefre = cProfessionnals[0].getFirstName();
            }
        }
    }

    @Override
    public int getNoLigne() {
        return this.noLigne;
    }

    public static class Mesur
    implements Comparable<Mesur> {
        public final Integer code;
        public final String nom;
        public final String unit;
        public BigDecimal val;

        public Mesur(Integer code, String n, String u, BigDecimal val) {
            this.code = code;
            this.nom = n;
            this.unit = u;
            this.val = val;
        }

        @Override
        public int compareTo(Mesur o) {
            return this.code.compareTo(o.code);
        }
    }
}

