/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemModifRecev;
import ca.infodata.syra.models.CDemPaimt;
import ca.infodata.syra.models.CDemdr;
import ca.infodata.syra.models.CIdFactRamqRecev;
import ca.infodata.syra.models.IDem;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.IdFactRamq;
import ca.qc.gouv.ramq.rfp.ObjectFactory;
import ca.qc.gouv.ramq.rfp.TypDem;
import ca.qc.gouv.ramq.rfp.TypFact;

public class CDemModif
extends IDem {
    public String cNoDemExt;
    public CDemdr cDemdr;
    public CDemModifRecev recev;
    public CIdFactRamqRecev idFact;

    public CDemModif(DemModif dem, CDemContainer cDemContainer, boolean withDetail, boolean forPrint) {
        this.cNoDemExt = dem.getNoDemExt();
        this.cDemdr = new CDemdr(dem.getDemdr(), false);
        DemModif.FactAModif factAModif = dem.getFactAModif();
        if (factAModif != null && factAModif.getFactBase() != null) {
            TypFact typFact = (TypFact)factAModif.getFactBase().getValue();
            CDemPaimt.setTypFact(cDemContainer, withDetail, forPrint, typFact, this);
        }
        this.idFact = new CIdFactRamqRecev();
        IdFactRamq idFactRamq = dem.getIdFactRamq();
        if (idFactRamq.getJetonComm() != null) {
            this.idFact.jetonComm = idFactRamq.getJetonComm();
        }
        this.idFact.noFactRamq = idFactRamq.getNoFactRamq();
    }

    public DemModif convert2Dem(CDemContainer cDemContainer) {
        ObjectFactory of = ConvertJavaToFromArray.of;
        DemModif pmt = of.createDemModif();
        pmt.setNoDemExt(this.cNoDemExt);
        pmt.setLogclFact(ConvertJavaToFromArray.getLoglFact());
        TypDem.Demdr demdr = of.createTypDemDemdr();
        demdr.setIdIntvn(this.cDemdr.idIntvn);
        demdr.setTypIdIntvn(this.cDemdr.typIdIntvn);
        pmt.setDemdr(demdr);
        TypDem.ExpedDifrnDemdr expDemdr = of.createTypDemExpedDifrnDemdr();
        expDemdr.setIdIntvn(SyraGlobalSettings.getInstance((String)(String.valueOf(ConnectionFactory.connectionLabel) + "/")).get("syra_noAgence"));
        expDemdr.setTypIdIntvn("3");
        pmt.setExpedDifrnDemdr(expDemdr);
        IdFactRamq idFactRamq = of.createIdFactRamq();
        idFactRamq.setNoFactRamq(this.idFact.noFactRamq);
        if (this.idFact.jetonComm != null) {
            idFactRamq.setJetonComm(this.idFact.jetonComm);
        }
        pmt.setIdFactRamq(idFactRamq);
        return pmt;
    }
}

