/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.models;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.syra.models.CDemAnnuRecev;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemdr;
import ca.infodata.syra.models.CIdFactRamqRecev;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.IdFactRamq;
import ca.qc.gouv.ramq.rfp.ObjectFactory;
import ca.qc.gouv.ramq.rfp.TypDem;
import java.io.Serializable;
import java.util.List;

public class CDemAnnu
implements Serializable {
    public String cNoDemExt;
    public CDemdr cDemdr;
    public CDemAnnuRecev recev;
    public CIdFactRamqRecev idFact;

    public CDemAnnu(DemAnnu dem, CDemContainer cDemContainer, boolean b, boolean c) {
        List<IdFactRamq> idFactRamq;
        int len;
        this.cNoDemExt = dem.getNoDemExt();
        if ("null".equals(this.cNoDemExt)) {
            this.cNoDemExt = null;
        }
        this.cDemdr = new CDemdr(dem.getDemdr(), false);
        if (dem.getListeFactAAnnu() != null && dem.getListeFactAAnnu().getIdFactRamq() != null && (len = (idFactRamq = dem.getListeFactAAnnu().getIdFactRamq()).size()) > 0) {
            IdFactRamq ramq = idFactRamq.get(len - 1);
            this.idFact = new CIdFactRamqRecev();
            if (ramq.getJetonComm() != null) {
                this.idFact.jetonComm = ramq.getJetonComm();
            }
            this.idFact.noFactRamq = ramq.getNoFactRamq();
        }
    }

    public DemAnnu convert2Dem(CDemContainer cDemContainer) {
        ObjectFactory of = ConvertJavaToFromArray.of;
        DemAnnu pmt = of.createDemAnnu();
        pmt.setNoDemExt(this.cNoDemExt);
        pmt.setLogclFact(ConvertJavaToFromArray.getLoglFact());
        TypDem.Demdr demdr = of.createTypDemDemdr();
        if (this.cDemdr != null) {
            demdr.setIdIntvn(this.cDemdr.idIntvn);
            demdr.setTypIdIntvn(this.cDemdr.typIdIntvn);
        }
        pmt.setDemdr(demdr);
        TypDem.ExpedDifrnDemdr expDemdr = of.createTypDemExpedDifrnDemdr();
        expDemdr.setIdIntvn(SyraGlobalSettings.getInstance((String)ConnectionFactory.connectionLabel).get("syra_noAgence"));
        expDemdr.setTypIdIntvn("3");
        pmt.setExpedDifrnDemdr(expDemdr);
        DemAnnu.ListeFactAAnnu listeFactAAnnu = of.createDemAnnuListeFactAAnnu();
        IdFactRamq idFactRamq = of.createIdFactRamq();
        idFactRamq.setNoFactRamq(this.idFact.noFactRamq);
        if (this.idFact.jetonComm != null) {
            idFactRamq.setJetonComm(this.idFact.jetonComm);
        }
        listeFactAAnnu.getIdFactRamq().add(idFactRamq);
        pmt.setListeFactAAnnu(listeFactAAnnu);
        return pmt;
    }
}

