/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.handlers;

import ca.infodata.syra.handlers.Handlers;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class ThreadSafeLastCallLogHandler
implements SOAPHandler<SOAPMessageContext> {
    private ThreadLocal<ByteArrayOutputStream> request = new ThreadLocal();
    private ThreadLocal<ByteArrayOutputStream> response = new ThreadLocal();
    private boolean doit = true;

    public boolean isActive() {
        return this.doit;
    }

    public void setActive(boolean value) {
        if (value != this.isActive()) {
            this.reset();
        }
        this.doit = value;
    }

    public void reset() {
        if (this.request.get() != null) {
            this.request.get().reset();
        }
        if (this.response.get() != null) {
            this.response.get().reset();
        }
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        if (this.doit) {
            Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                Handlers.logger.fine("ThreadSafeLastCallLogHandler.handleMessage() out");
                try {
                    this.reset();
                    if (this.request.get() == null) {
                        this.request.set(new ByteArrayOutputStream(15000));
                    }
                    smc.getMessage().saveChanges();
                    smc.getMessage().writeTo((OutputStream)this.request.get());
                }
                catch (Exception e) {
                    Handlers.logger.log(Level.WARNING, "failed to write request to temp memory", e);
                }
            } else {
                try {
                    if (this.response.get() == null) {
                        this.response.set(new ByteArrayOutputStream(15000));
                    } else {
                        this.response.get().reset();
                    }
                    smc.getMessage().writeTo((OutputStream)this.response.get());
                }
                catch (Exception e) {
                    Handlers.logger.log(Level.WARNING, "failed to write response to temp memory", e);
                }
            }
        }
        return true;
    }

    public String getRequest() {
        if (this.request.get() == null || this.request.get().size() == 0) {
            return null;
        }
        return this.request.get().toString();
    }

    public String getResponse() {
        if (this.response.get() == null || this.response.get().size() == 0) {
            return null;
        }
        return this.response.get().toString();
    }

    public Set getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

