/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.handlers;

import ca.infodata.syra.handlers.Handlers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public abstract class AbstractFileLogHandler
implements SOAPHandler<SOAPMessageContext> {
    protected abstract File getRequest();

    protected abstract File getResponse();

    public boolean handleMessage(SOAPMessageContext smc) {
        block14: {
            Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outboundProperty.booleanValue()) {
                Handlers.logger.fine("AbstractFileLogHandler.handleMessage() out");
                File request = null;
                try {
                    request = this.getRequest();
                    if (request == null) break block14;
                    try (FileOutputStream fos = new FileOutputStream(request);){
                        Handlers.logger.fine("writing to fos " + request);
                        smc.getMessage().saveChanges();
                        smc.getMessage().writeTo((OutputStream)fos);
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    Handlers.logger.log(Level.WARNING, "failed to write request", e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Handlers.logger.log(Level.WARNING, "failed to write request to " + request == null ? null : request.getAbsolutePath(), e);
                }
            } else {
                File response = null;
                try {
                    response = this.getResponse();
                    if (response == null) break block14;
                    try (FileOutputStream fos = new FileOutputStream(response);){
                        smc.getMessage().writeTo((OutputStream)fos);
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    Handlers.logger.log(Level.WARNING, "failed to write response", e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Handlers.logger.log(Level.WARNING, "failed to write response to " + response == null ? null : response.getAbsolutePath(), e);
                }
            }
        }
        return true;
    }

    public Set getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

