/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.fich_valid;

import ca.infodata.ofys.ui.browser.sonar.ActionResult;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.fich_valid.BaseTest;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.query.CodeFacturation;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.syra.xsd.valid.omni.CodFact;
import ca.infodata.syra.xsd.valid.spec.CodFact;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.junit.Test;

public class CodFactTest
extends BaseTest {
    public void queryByNameTest() throws QueryException, IOException {
        this.callPrimeService();
        CodeFacturation dx = new CodeFacturation();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(1), new Integer(1), null, "hotel", null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.CABINET);
        List<String> l = dx.getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
        Context contexte = ValidRamq.getInstance().getContext();
        for (String s : l) {
            String code = new XQuery(String.valueOf(s) + "/cod_fact/text()").execute(contexte).toString();
            String desc = new XQuery(String.valueOf(s) + "/des_cod_fact/text()").execute(contexte).toString();
            System.out.println(String.valueOf(code) + ":" + desc);
        }
    }

    public void queryFacturationAllTest() {
        Object[] object;
        this.callPrimeService();
        long t0 = System.currentTimeMillis();
        SyraController controller = new SyraController();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", "1");
        ActionResult action = controller.getAction("/syra/pref/fact", params);
        Object[] objectArray = object = (Object[])action.getResponse().get("data");
        int n = object.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            System.out.println(o);
            ++n2;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("--------------------------- String " + (t1 - t0) + "ms");
    }

    @Test
    public void queryElementContextTest0() throws QueryException, IOException {
        long t0 = System.currentTimeMillis();
        CodeFacturation dx = new CodeFacturation();
        CProfessionnal.Entente entente = CProfessionnal.Entente.OMNI;
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(entente.value), new Integer(1), null, "vis", null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        List<String> l = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
        XStream xs = dx.getXstream();
        for (String s : l) {
            Serializable msg;
            Object act = ((IBaseXQuery)dx).getJavaObjectFromNode(entente, s, xs);
            if (CProfessionnal.Entente.OMNI.equals((Object)entente)) {
                msg = (CodFact.ValCodFact)act;
                System.out.println(String.valueOf(((CodFact.ValCodFact)msg).getCodFact()) + ": " + ((CodFact.ValCodFact)msg).getDesCodFact());
                continue;
            }
            if (!CProfessionnal.Entente.SPEC.equals((Object)entente)) continue;
            msg = (CodFact.ValCodFact)act;
            System.out.println(String.valueOf(((CodFact.ValCodFact)msg).getCodFact()) + ": " + ((CodFact.ValCodFact)msg).getDesCodFact());
        }
        long t1 = System.currentTimeMillis();
        System.out.println("--------------------------- String " + (t1 - t0) + "ms");
    }

    public void queryElementContextTest1() throws QueryException, IOException {
        this.callPrimeService();
        long t0 = System.currentTimeMillis();
        CodeFacturation dx = new CodeFacturation();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(1), new Integer(1), new String[]{"56", "9116", "97", "9119"}, null, null, "2016-03-01", null, QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL, QueryCriteria.EtablType.ETABLISSEMENT);
        criteria.setAgeYears(20);
        List<String> l = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.CODE_DESCR);
        for (String s : l) {
            System.out.println(s);
        }
        long t1 = System.currentTimeMillis();
        System.out.println("--------------------------- String " + (t1 - t0) + "ms");
    }

    public void queryElementContextTest2() throws QueryException, IOException {
        this.callPrimeService();
        long t0 = System.currentTimeMillis();
        CodeFacturation dx = new CodeFacturation();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(1), new Integer(1), new String[]{"210"}, null, null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        List<String> l = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
        Context contexte = ValidRamq.getInstance().getContext();
        for (String s : l) {
            String code = new XQuery(String.valueOf(s) + "/cod_elm_contx/text()").execute(contexte).toString();
            String desc = new XQuery(String.valueOf(s) + "/txt_elm_contx/text()").execute(contexte).toString();
            System.out.println(String.valueOf(code) + ":" + desc);
        }
        long t1 = System.currentTimeMillis();
        System.out.println("--------------------------- Node " + (t1 - t0) + "ms");
    }

    public void queryElementContextForCodeFactTest() throws QueryException, IOException {
        this.callPrimeService();
        CodeFacturation dx = new CodeFacturation();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(2), new Integer(1), null, null, null, "2016-03-01", new Integer(2619), QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        List<String> l = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
        Context contexte = ValidRamq.getInstance().getContext();
        for (String s : l) {
            String code = new XQuery(String.valueOf(s) + "/cod_elm_contx/text()").execute(contexte).toString();
            String desc = new XQuery(String.valueOf(s) + "/txt_elm_contx/text()").execute(contexte).toString();
            System.out.println(String.valueOf(code) + ":" + desc);
        }
    }

    public void primeService() {
        CodeFacturation dx = new CodeFacturation();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, new Integer(1), new Integer(1), new String[]{"190"}, null, null, "2016-03-01", null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.ETABLISSEMENT);
        try {
            List<String> dataByCriteria = ((IBaseXQuery)dx).getDataByCriteria(criteria, IBaseXQuery.DataType.CODE_DESCR);
            for (String s : dataByCriteria) {
                System.out.print(".");
            }
            System.out.print(" ");
        }
        catch (IOException | QueryException e) {
            e.printStackTrace();
        }
    }
}

