/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.controller;

import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.hibernate.fmedx.Groupe;
import ca.infodata.dossier.hibernate.fmedx.base.BaseGroupeDAO;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.ui.browser.sonar.Controller;
import ca.infodata.ofys.util.date.LocalDate;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.enumitems.UnitDuree;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CEtab;
import ca.infodata.syra.models.CLieu;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CProfessionnalPrefData;
import ca.infodata.syra.models.CodeBigIntCodFact;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.CodeDescDx;
import ca.infodata.syra.models.PrefCodeDesc;
import ca.infodata.syra.models.ReglePlafonnement;
import ca.infodata.syra.query.CodeDxQuery;
import ca.infodata.syra.query.CodeFacturation;
import ca.infodata.syra.query.CodeLocalite;
import ca.infodata.syra.query.ElementContext;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.InfoEtablissement;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.query.SecteurActivite;
import ca.infodata.syra.util.Helper;
import ca.infodata.syra.xsd.valid.omni.SectActiv;
import ca.infodata.syra.xsd.valid.spec.SectActiv;
import com.google.common.collect.SetMultimap;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.basex.query.QueryException;

public class SyraPrefAndXmlDataController
extends Controller {
    private static final Logger logger = Logger.getLogger(SyraPrefAndXmlDataController.class.getName());
    protected static DateFormat dateFormatD = new SimpleDateFormat("yyyy-MM-dd");
    protected final SyraAccessorClient accessor;
    protected Map<String, CDemContainer> mapDemContainer = new HashMap<String, CDemContainer>();
    public static Pattern LettreChiffreOu2chiffres = Pattern.compile("[a-zA-Z][0-9]|[0-9][0-9]");
    public static Pattern Chiffres = Pattern.compile("[0-9]*");
    private static Map<Integer, List<Integer>> mapCodeOnlyInSect = new HashMap<Integer, List<Integer>>();
    private static Map<Integer, List<Integer>> mapCodeNotInSect = new HashMap<Integer, List<Integer>>();
    private static Map<Integer, List<Integer>> mapCodFsFer = new HashMap<Integer, List<Integer>>();
    private static Map<Integer, List<Integer>> mapCodNotFsFer = new HashMap<Integer, List<Integer>>();
    private static Map<String, Set<String>> setSpec = new TreeMap<String, Set<String>>();
    private static Map<String, List<ReglePlafonnement>> mapSpecCodReglePlafs = new TreeMap<String, List<ReglePlafonnement>>();
    private static Map<String, Set<String>> mapMajorationDx = new HashMap<String, Set<String>>();
    private static final ConcurrentHashMap<String, List<String>> mapAbbr = new ConcurrentHashMap();

    static {
        MultiValueMap map = new MultiValueMap();
        map.put((Object)"AAA", (Object)"4414");
        map.put((Object)"AC", (Object)"4275");
        map.put((Object)"ACD", (Object)"2501");
        map.put((Object)"AI", (Object)"4139");
        map.put((Object)"ICT", (Object)"4359");
        map.put((Object)"AVC", (Object)"4379");
        map.put((Object)"BAV", (Object)"4261");
        map.put((Object)"BBG", (Object)"4262");
        map.put((Object)"BBD", (Object)"4264");
        map.put((Object)"BMR", (Object)"0404");
        map.put((Object)"BSA", (Object)"4266");
        map.put((Object)"CMD", (Object)"4259");
        map.put((Object)"CMV", (Object)"0785");
        map.put((Object)"CPC", (Object)"4169");
        map.put((Object)"DL", (Object)"6259");
        map.put((Object)"DL", (Object)"7194");
        map.put((Object)"DL", (Object)"7295");
        map.put((Object)"DL", (Object)"7865");
        map.put((Object)"DL", (Object)"7890");
        map.put((Object)"DL", (Object)"A005");
        map.put((Object)"DEG", (Object)"7807");
        map.put((Object)"DH", (Object)"5645");
        map.put((Object)"DB", (Object)"2500");
        map.put((Object)"DRS", (Object)"7865");
        map.put((Object)"DTA", (Object)"3310");
        map.put((Object)"ECA", (Object)"2930");
        map.put((Object)"EP", (Object)"4151");
        map.put((Object)"ES", (Object)"4276");
        map.put((Object)"FA", (Object)"4273");
        map.put((Object)"AS", (Object)"634");
        map.put((Object)"FV", (Object)"4274");
        map.put((Object)"GE", (Object)"5589");
        map.put((Object)"GEU", (Object)"6339");
        map.put((Object)"GMC", (Object)"2731");
        map.put((Object)"GNA", (Object)"5809");
        map.put((Object)"GNC", (Object)"5829");
        map.put((Object)"HBP", (Object)"6009");
        map.put((Object)"HD", (Object)"7222");
        map.put((Object)"HDH", (Object)"578");
        map.put((Object)"HDB", (Object)"5693");
        map.put((Object)"HI", (Object)"5509");
        map.put((Object)"HPM", (Object)"7891");
        map.put((Object)"HSD", (Object)"4321");
        map.put((Object)"HTA", (Object)"4019");
        map.put((Object)"HTAP", (Object)"4160");
        map.put((Object)"HTAP", (Object)"4169");
        map.put((Object)"HTP", (Object)"5723");
        map.put((Object)"HU", (Object)"5997");
        map.put((Object)"IA", (Object)"7464");
        map.put((Object)"IAMI", (Object)"4439");
        map.put((Object)"IC", (Object)"4289");
        map.put((Object)"IDM", (Object)"4129");
        map.put((Object)"IM", (Object)"7466");
        map.put((Object)"IVG", (Object)"7796");
        map.put((Object)"IRA", (Object)"5849");
        map.put((Object)"IRC", (Object)"5859");
        map.put((Object)"VMI", (Object)"454");
        map.put((Object)"IVRS", (Object)"465");
        map.put((Object)"LLA", (Object)"2040");
        map.put((Object)"LMA", (Object)"2050");
        map.put((Object)"LED", (Object)"7100");
        map.put((Object)"LLC", (Object)"2041");
        map.put((Object)"LMC", (Object)"2051");
        map.put((Object)"PTT", (Object)"4466");
        map.put((Object)"MC", (Object)"4140");
        map.put((Object)"MCAS", (Object)"4140");
        map.put((Object)"MII", (Object)"5552");
        map.put((Object)"MII", (Object)"5569");
        map.put((Object)"MM", (Object)"1729");
        map.put((Object)"MPOC", (Object)"4912");
        map.put((Object)"MTE", (Object)"4539");
        map.put((Object)"MVAS", (Object)"4402");
        map.put((Object)"NV", (Object)"7870");
        map.put((Object)"NTA", (Object)"5845");
        map.put((Object)"OAP", (Object)"5184");
        map.put((Object)"OMI", (Object)"7570");
        map.put((Object)"OMI", (Object)"9927");
        map.put((Object)"PAR", (Object)"7140");
        map.put((Object)"PMD", (Object)"2966");
        map.put((Object)"PR", (Object)"7140");
        map.put((Object)"RAA", (Object)"3909");
        map.put((Object)"RU", (Object)"7882");
        map.put((Object)"RCH", (Object)"5569");
        map.put((Object)"RGO", (Object)"5309");
        map.put((Object)"RGO", (Object)"5309");
        map.put((Object)"RVU", (Object)"5937");
        map.put((Object)"SAS", (Object)"7869");
        map.put((Object)"SCA", (Object)"4109");
        map.put((Object)"SEP", (Object)"3409");
        map.put((Object)"SIADH", (Object)"2531");
        map.put((Object)"SIDA", (Object)"0429");
        map.put((Object)"TB", (Object)"0119");
        map.put((Object)"TC", (Object)"8509");
        map.put((Object)"TC", (Object)"9070");
        map.put((Object)"TOC", (Object)"3003");
        map.put((Object)"TV", (Object)"4271");
        map.put((Object)"TVP", (Object)"4539");
        map.put((Object)"UD", (Object)"5329");
        map.put((Object)"UG", (Object)"531");
        map.put((Object)"VIH", (Object)"0432");
        Set set = map.entrySet();
        for (Map.Entry e : set) {
            mapAbbr.put((String)e.getKey(), (List)e.getValue());
        }
    }

    public SyraPrefAndXmlDataController() {
        this.accessor = SyraAccessorClient.getInstance();
    }

    protected SyraAccessorClient getAccessor() {
        return this.accessor;
    }

    protected CProfessionnalPrefData getPrefData(Integer idAnchorProf) {
        CProfessionnalPrefData pd = this.accessor.getPrefData(idAnchorProf);
        return pd;
    }

    public Collection<CProfessionnal> getAllCProfessionnal() {
        if (this.getAccessor().mapProf.isEmpty()) {
            this.fillMaps();
        }
        return this.getAccessor().mapProf.values();
    }

    public CProfessionnal getCProfessionnal(Integer idAnchorProf) {
        if (idAnchorProf == null) {
            return null;
        }
        CProfessionnal pd = this.accessor.getCProfessionnals(idAnchorProf);
        if (pd == null) {
            this.fillMaps();
        }
        return pd;
    }

    private void fillMaps() {
        CProfessionnal[] profs;
        CProfessionnal[] cProfessionnalArray = profs = this.getBillingProfessionals(null);
        int n = profs.length;
        int n2 = 0;
        while (n2 < n) {
            CProfessionnal cp = cProfessionnalArray[n2];
            this.getAccessor().mapProf.put(cp.getId(), cp);
            ++n2;
        }
    }

    protected CProfessionnal[] getBillingProfessionals(Map<String, String> params) {
        String searchString = null;
        Integer ent = null;
        String spec = null;
        if (params != null) {
            String entente;
            searchString = params.get("k");
            if (searchString == null) {
                searchString = params.get("c");
            }
            if ((entente = params.get("e")) != null && NumberUtils.isDigits((String)entente)) {
                ent = Integer.valueOf(entente);
            }
            spec = params.get("s");
        }
        List<IProfessionnal> profs = this.getAccessor().getBillingProfessionnals(searchString, ent, spec);
        ArrayList<CProfessionnal> viewProfs = new ArrayList<CProfessionnal>();
        for (IProfessionnal p : profs) {
            String codSpec = "00";
            String specDesc = "S/O";
            Integer modeRemu = new Integer(0);
            String noAgence = "00000";
            boolean alwaysUseGroup = false;
            String noGroup = "";
            String particularSituation = "";
            String specialTx = "";
            if (p.getSpeciality() != null) {
                codSpec = p.getSpeciality().getCode();
                specDesc = p.getSpeciality().getDescription();
            }
            if (p.getProfessionnalFacturation() != null) {
                if (p.getProfessionnalFacturation().getRemunerationType() != null) {
                    modeRemu = p.getProfessionnalFacturation().getRemunerationType();
                }
                if (p.getProfessionnalFacturation().getNoAgenceRamq() != null) {
                    noAgence = p.getProfessionnalFacturation().getNoAgenceRamq();
                }
                if (p.getProfessionnalFacturation().getAlwaysUseGroup() != null) {
                    Groupe groupe;
                    boolean bl = alwaysUseGroup = p.getProfessionnalFacturation().getAlwaysUseGroup() != 0;
                    if (alwaysUseGroup && p.getProfessionnalFacturation().getNoGroup() != null && (groupe = BaseGroupeDAO.getInstance().load(p.getProfessionnalFacturation().getNoGroup())) != null) {
                        noGroup = groupe.getNumero();
                    }
                }
                if (p.getProfessionnalFacturation().getParticularSituation() != null) {
                    particularSituation = p.getProfessionnalFacturation().getParticularSituation();
                }
                if (p.getProfessionnalFacturation().getSpecialTreatment() != null) {
                    specialTx = p.getProfessionnalFacturation().getSpecialTreatment();
                }
            }
            CProfessionnal pr = new CProfessionnal(p.getId(), p.getCode(), codSpec, specDesc, p.getType(), modeRemu, noAgence, noGroup, particularSituation, specialTx, p.getFirstName(), p.getLastName(), p.getIsTreatingProfessionnal());
            viewProfs.add(pr);
        }
        if (viewProfs.size() > 0) {
            return viewProfs.toArray(new CProfessionnal[viewProfs.size()]);
        }
        return new CProfessionnal[0];
    }

    protected PrefCodeDesc[] getDiagnosticAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CodeDxQuery dx = new CodeDxQuery();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, null, null, null);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeDiag.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeDiag.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getDiagnosticAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefDiagnostic(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefDiag(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefDiag(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtyDx(true);
    }

    protected PrefCodeDesc[] getFacturationAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
            CodeFacturation dx = new CodeFacturation();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
            if (cp != null && cp.getType() != null) {
                entente = CProfessionnal.Entente.valueOf(cp.getType());
            }
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, entente.getValue(), null, null, null, null, ca.infodata.util1.date.LocalDate.today().formatHyphen(), null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeFact.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeFact.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getDiagnosticAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefFacturation(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefFact(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefFact(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtyCode(true);
    }

    protected PrefCodeDesc[] getLocaliteAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CodeLocalite dx = new CodeLocalite();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_LOCAL, null, null, null);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeLocal.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeLocal.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getlocaliteAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefLocalite(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefLocal(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefLocal(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtyLocal(true);
    }

    protected PrefCodeDesc[] getElmContxAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
            ElementContext dx = new ElementContext();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
            if (cp != null && cp.getType() != null) {
                entente = CProfessionnal.Entente.valueOf(cp.getType());
            }
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.ELM_CONTX, entente.getValue(), null, null, null, null, ca.infodata.util1.date.LocalDate.today().formatHyphen(), null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeElmContx.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeElmContx.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getElmContxAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefElmContx(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefElmContx(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefElmContx(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtyCx(true);
    }

    public Object[] getLocalite(String code) {
        Object[] ojbect = new Object[]{};
        CodeLocalite ix = new CodeLocalite();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_LOCAL, null, null, new String[]{code}, null, null, null, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        Object[] javaObjects = ((IBaseXQuery)ix).getJavaObjects(criteria);
        if (javaObjects.length == 1) {
            return javaObjects;
        }
        return ojbect;
    }

    public Object[] getEtablissement(String code) {
        Object[] ojbect = new Object[]{};
        InfoEtablissement ix = new InfoEtablissement();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.INFO_ETAB, null, null, new String[]{code}, null, null, null, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        Object[] javaObjects = ((IBaseXQuery)ix).getJavaObjects(criteria);
        if (javaObjects.length == 1) {
            return javaObjects;
        }
        return ojbect;
    }

    public CEtab.CValNoSectActiv getValNoSecteur(String v, CProfessionnal.Entente e, String date) {
        if (v == null) {
            return null;
        }
        CEtab.CValNoSectActiv ns = null;
        Object[] secteurs = this.getSecteur(v, e, date);
        if (secteurs != null && secteurs.length == 1) {
            Object oSect = secteurs[0];
            if (oSect instanceof SectActiv.ValNoSectActiv) {
                SectActiv.ValNoSectActiv sectActiv = (SectActiv.ValNoSectActiv)oSect;
                ns = new CEtab.CValNoSectActiv(sectActiv.getNoSectActiv(), sectActiv.getDesSectActiv(), e);
                List<SectActiv.ValNoSectActiv.ListeCatgEtab> listeListCatgEtab = sectActiv.getListeCatgEtab();
                for (SectActiv.ValNoSectActiv.ListeCatgEtab catgEtab : listeListCatgEtab) {
                    ns.addCatgEtab((String)((Object)catgEtab));
                }
            } else if (oSect instanceof SectActiv.ValNoSectActiv) {
                SectActiv.ValNoSectActiv sectActiv = (SectActiv.ValNoSectActiv)oSect;
                ns = new CEtab.CValNoSectActiv(sectActiv.getNoSectActiv(), sectActiv.getDesSectActiv(), e);
                List<SectActiv.ValNoSectActiv.ListeCatgEtab> listeListCatgEtab = sectActiv.getListeCatgEtab();
                for (SectActiv.ValNoSectActiv.ListeCatgEtab catgEtab : listeListCatgEtab) {
                    ns.addCatgEtab((String)((Object)catgEtab));
                }
            }
        } else {
            ns = new CEtab.CValNoSectActiv(v, "", e);
        }
        return ns;
    }

    public Object[] getSecteur(String code, CProfessionnal.Entente ent, String date) {
        Object[] ojbect = new Object[]{};
        SecteurActivite ix = new SecteurActivite();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.INFO_ETAB, new Integer(ent.getValue()), null, new String[]{code}, null, null, date, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        Object[] javaObjects = ((IBaseXQuery)ix).getJavaObjects(criteria);
        if (javaObjects.length == 1) {
            return javaObjects;
        }
        return ojbect;
    }

    protected PrefCodeDesc[] getEtablissementAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            InfoEtablissement dx = new InfoEtablissement();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.INFO_ETAB, null, null, null);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeEtabl.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeEtabl.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getEtablissementAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefEtablissement(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefEtabl(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefEtabl(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtyEtab(true);
    }

    protected PrefCodeDesc[] getSecteurActiviteAll(Integer idAnchorProf) {
        PrefCodeDesc[] prefCodeDesc = new PrefCodeDesc[]{};
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CProfessionnal prof = this.getCProfessionnal(idAnchorProf);
            Integer ent = new Integer(CProfessionnal.Entente.NON_DEF.getValue());
            if (prof != null) {
                ent = prof.getType();
            }
            SecteurActivite dx = new SecteurActivite();
            ArrayList<String[]> lstNode = new ArrayList<String[]>();
            QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.SECT_ACTIV, null, null, null);
            criteria.setEntente(ent);
            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
            prefCodeDesc = new PrefCodeDesc[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                PrefCodeDesc cd;
                Character pref = Character.valueOf(' ');
                if (pd.prefCodeSectActiv.containsKey(((String[])lstNode.get(i))[0])) {
                    pref = pd.prefCodeSectActiv.get(((String[])lstNode.get(i))[0]);
                }
                prefCodeDesc[i] = cd = new PrefCodeDesc(pref, ((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1]);
                ++i;
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getSecteurActiviteAll", e);
        }
        return prefCodeDesc;
    }

    protected void modPrefSecteurActivite(Integer idAnchorProf, String prev_pref, String new_pref, String code) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        if (prev_pref != null && !prev_pref.trim().isEmpty()) {
            pd.removePrefSectActiv(Character.valueOf(prev_pref.charAt(0)), code);
        }
        if (new_pref != null && !new_pref.trim().isEmpty()) {
            pd.addPrefSectActiv(Character.valueOf(new_pref.charAt(0)), code);
        }
        pd.setDirtySect(true);
    }

    protected Map<String, String> getAutreAll(Integer idAnchorProf) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        Map<String, String> prefAutreAll = pd.getPrefAutreAll();
        return prefAutreAll;
    }

    protected Map<String, Map<String, String>> getAutreAllProf() {
        CProfessionnal[] professionnals;
        HashMap<String, Map<String, String>> maps = new HashMap<String, Map<String, String>>();
        CProfessionnal[] cProfessionnalArray = professionnals = this.getBillingProfessionals(null);
        int n = professionnals.length;
        int n2 = 0;
        while (n2 < n) {
            CProfessionnal cp = cProfessionnalArray[n2];
            CProfessionnalPrefData pd = this.getPrefData(cp.getId());
            Map<String, String> prefAutreAll = pd.getPrefAutreAll();
            maps.put(cp.getId() + "~" + cp.getLastName() + " " + cp.getFirstName() + "~" + cp.getType() + "~" + cp.getNoProf(), prefAutreAll);
            ++n2;
        }
        return maps;
    }

    protected void modPrefAutre(Integer idAnchorProf, String key, String val) {
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        pd.setPrefAutreValue(key, val);
        pd.setDirtyAutre(true);
    }

    protected void copyPrefFromTo(Integer idAnchorProf, Integer toIdAnchorProf, QueryCriteria.ModelType modelType, boolean replace) {
        CProfessionnalPrefData pdFrom = this.getPrefData(idAnchorProf);
        CProfessionnalPrefData pdTo = this.getPrefData(toIdAnchorProf);
        switch (modelType.value) {
            case 0: {
                this.copyPrefFromTo(pdFrom.prefDiag, pdFrom.prefCodeDiag, pdTo.prefDiag, pdTo.prefCodeDiag, replace);
                pdTo.setDirtyDx(true);
                break;
            }
            case 1: {
                this.copyPrefFromTo(pdFrom.prefFact, pdFrom.prefCodeFact, pdTo.prefFact, pdTo.prefCodeFact, replace);
                pdTo.setDirtyCode(true);
                break;
            }
            case 2: {
                this.copyPrefFromTo(pdFrom.prefElmContx, pdFrom.prefCodeElmContx, pdTo.prefElmContx, pdTo.prefCodeElmContx, replace);
                pdTo.setDirtyCx(true);
                break;
            }
            case 3: {
                this.copyPrefFromTo(pdFrom.prefLocal, pdFrom.prefCodeLocal, pdTo.prefLocal, pdTo.prefCodeLocal, replace);
                pdTo.setDirtyLocal(true);
                break;
            }
            case 4: {
                this.copyPrefFromTo(pdFrom.prefEtabl, pdFrom.prefCodeEtabl, pdTo.prefEtabl, pdTo.prefCodeEtabl, replace);
                pdTo.setDirtyEtab(true);
                break;
            }
            case 5: {
                this.copyPrefFromTo(pdFrom.prefSectActiv, pdFrom.prefCodeSectActiv, pdTo.prefSectActiv, pdTo.prefCodeSectActiv, replace);
                pdTo.setDirtySect(true);
                break;
            }
        }
    }

    private void copyPrefFromTo(SetMultimap<Character, String> prefFrom, Map<String, Character> prefCodeFrom, SetMultimap<Character, String> prefTo, Map<String, Character> prefCodeTo, boolean replace) {
        if (replace) {
            prefCodeTo.clear();
        }
        prefCodeTo.putAll(prefCodeFrom);
        if (replace) {
            prefTo.clear();
        }
        prefTo.putAll(prefFrom);
    }

    public Set<String> getAllCodeDx() {
        CodeDxQuery dx = new CodeDxQuery();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, null, null, null);
        try {
            return ((IBaseXQuery)dx).getAllOnlyCode(criteria);
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getAllCodeDx", e);
            return null;
        }
    }

    public CodeDescDx[] searchDiagnostic(Integer idAnchorProf, String searchString) {
        CodeDescDx[] listdx = new CodeDescDx[]{};
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
        try {
            CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
            CodeDxQuery dx = new CodeDxQuery();
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                QueryCriteria criteria;
                boolean doNotUsePref = searchString.charAt(0) == ' ' || pd == null;
                String ss = searchString.trim();
                ArrayList lst = new ArrayList();
                if (!doNotUsePref && ss.length() == 1) {
                    if (StringUtils.isAlpha((CharSequence)ss)) {
                        TreeSet set;
                        Set activeSet = pd.prefDiag.get((Object)Character.valueOf(ss.toUpperCase().charAt(0)));
                        if (activeSet != null && !activeSet.isEmpty() && !(set = new TreeSet(activeSet)).isEmpty()) {
                            lst.addAll(set);
                        }
                        if (!lst.isEmpty()) {
                            criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, lst.toArray(new String[lst.size()]), null, null);
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        }
                    }
                } else {
                    String[] sss = ss.split("[ ,']");
                    criteria = null;
                    if (sss.length == 1) {
                        if (mapAbbr.containsKey(sss[0])) {
                            List<String> list = mapAbbr.get(sss[0]);
                            String[] array = list.toArray(new String[list.size()]);
                            criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, array, null, null);
                            criteria.setExactCode(Boolean.TRUE);
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        } else if (sss[0].length() > 1 && LettreChiffreOu2chiffres.matcher(searchString.substring(0, 2)).matches()) {
                            criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, new String[]{sss[0]}, null, null);
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        } else if (sss[0].length() > 3) {
                            criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, null, sss[0], null);
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        }
                    } else {
                        int totalLength = 0;
                        String newSearchString = "";
                        String[] codeDx = null;
                        String[] stringArray = sss;
                        int n = sss.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String m = stringArray[n2];
                            if (m.length() > 1 && LettreChiffreOu2chiffres.matcher(searchString.substring(0, 2)).matches()) {
                                criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, sss, null, null);
                                criteria.setExactCode(Boolean.TRUE);
                                break;
                            }
                            if (m.length() > 2) {
                                newSearchString = String.valueOf(newSearchString) + m + " ";
                                totalLength += m.length();
                            } else if ("*".equals(m) && cp != null && cp.getCodSpec() != null && mapMajorationDx.containsKey(cp.getCodSpec())) {
                                codeDx = mapMajorationDx.get(cp.getCodSpec()).toArray(new String[0]);
                            }
                            ++n2;
                        }
                        if (criteria != null) {
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        } else if (totalLength > 4 || totalLength > 2 && codeDx != null) {
                            criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, codeDx, newSearchString, null);
                            lstNode.addAll(((IBaseXQuery)dx).getCodeDescription(criteria));
                        }
                    }
                }
            }
        }
        catch (IOException | QueryException e) {
            logger.log(Level.SEVERE, "getDiagnostic with <" + searchString + "> for idAnchorProf " + idAnchorProf, e);
        }
        listdx = new CodeDescDx[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDescDx cd;
            listdx[i] = cd = new CodeDescDx(((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1], ((String[])lstNode.get(i))[2], ((String[])lstNode.get(i))[3]);
            if (cp != null && cp.getCodSpec() != null && mapMajorationDx.containsKey(cp.getCodSpec()) && mapMajorationDx.get(cp.getCodSpec()).contains(cd.c)) {
                cd.da = "* " + cd.da;
                cd.dl = "* " + cd.dl;
            }
            ++i;
        }
        return listdx;
    }

    protected CodeDesc[] findSecteur(Integer idAnchorProf, String searchString) {
        CodeDesc[] codeDesc = new CodeDesc[]{};
        ArrayList<String> lstCode = new ArrayList<String>();
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        SetMultimap<Character, String> prefFact = pd == null ? null : pd.prefSectActiv;
        QueryCriteria.ModelType codFact = QueryCriteria.ModelType.SECT_ACTIV;
        SecteurActivite dx = new SecteurActivite();
        ArrayList<String[]> lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefFact, codFact, dx, null, null, null, null, null);
        codeDesc = new CodeDesc[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDesc cd;
            codeDesc[i] = cd = new CodeDesc(lstNode.get(i)[0], lstNode.get(i)[1]);
            ++i;
        }
        return codeDesc;
    }

    protected CodeDesc[] findEtablissement(Integer idAnchorProf, String searchString) {
        CodeDesc[] codeDesc = new CodeDesc[]{};
        ArrayList<String> lstCode = new ArrayList<String>();
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        SetMultimap<Character, String> prefEtab = pd == null ? null : pd.prefEtabl;
        QueryCriteria.ModelType codFact = QueryCriteria.ModelType.INFO_ETAB;
        InfoEtablissement dx = new InfoEtablissement();
        String[] sss = searchString.split("[ ,']");
        if (sss.length > 1) {
            String[] stringArray = sss;
            int n = sss.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m.length() > 4 && Chiffres.matcher(searchString.substring(0, 4)).matches()) {
                    lstCode.add(m);
                }
                ++n2;
            }
            if (lstCode.size() > 0) {
                searchString = " ";
            }
        }
        ArrayList<String[]> lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefEtab, codFact, dx, null, null, null, null, null);
        codeDesc = new CodeDesc[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDesc cd;
            codeDesc[i] = cd = new CodeDesc(lstNode.get(i)[0], lstNode.get(i)[1]);
            ++i;
        }
        return codeDesc;
    }

    protected CodeDesc[] findLocalite(Integer idAnchorProf, String searchString) {
        CodeDesc[] codeDesc = new CodeDesc[]{};
        ArrayList<String> lstCode = new ArrayList<String>();
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        SetMultimap<Character, String> prefFact = pd == null ? null : pd.prefLocal;
        QueryCriteria.ModelType codFact = QueryCriteria.ModelType.COD_LOCAL;
        CodeLocalite dx = new CodeLocalite();
        String[] sss = searchString.split("[ ,']");
        if (sss.length > 1) {
            String[] stringArray = sss;
            int n = sss.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m.length() > 4 && Chiffres.matcher(searchString.substring(0, 4)).matches()) {
                    lstCode.add(m);
                }
                ++n2;
            }
            if (lstCode.size() > 0) {
                searchString = " ";
            }
        }
        ArrayList<String[]> lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefFact, codFact, dx, null, null, null, null, null);
        codeDesc = new CodeDesc[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDesc cd;
            codeDesc[i] = cd = new CodeDesc(lstNode.get(i)[0], lstNode.get(i)[1]);
            ++i;
        }
        return codeDesc;
    }

    public CodeDesc[] getCodesDescFacturation(Integer idAnchorProf, String searchString, CDemContainer demContainer) {
        ArrayList<String[]> lstNode;
        CodeDesc[] codeDesc = new CodeDesc[]{};
        ArrayList<String> lstCode = new ArrayList<String>();
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        SetMultimap<Character, String> prefFact = pd == null ? null : pd.prefFact;
        QueryCriteria.ModelType codFact = QueryCriteria.ModelType.COD_FACT;
        CodeFacturation baseXquery = new CodeFacturation();
        QueryCriteria.EtablType etablType = QueryCriteria.EtablType.CABINET;
        Integer noSect = null;
        CLieu lieu = demContainer.getCurrentLieu(null);
        if ("C".equals(lieu.typLocEtab) && lieu.etab != null && lieu.etab.getValEtab() != null) {
            if ("ETAB".equals(lieu.etab.getValEtab().getTypEtab())) {
                etablType = QueryCriteria.EtablType.ETABLISSEMENT;
            }
            if (lieu.etab.valSect != null && StringUtils.isNotEmpty((CharSequence)lieu.etab.valSect.getNoSectActiv())) {
                try {
                    noSect = Integer.valueOf(lieu.etab.valSect.getNoSectActiv());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        Object[] elmFact = null;
        Object[] elmFactRole1 = null;
        CLigneTypServMdcal ligneService = demContainer.getCurrentCLigneServMdcal();
        if (ligneService != null) {
            ca.infodata.util1.date.LocalDate time = null;
            try {
                Date parseDate = DateUtils.parseDate((String)ligneService.dateServ, (String[])new String[]{"yyyy-MM-dd", "yyyy/MM/dd"});
                time = ca.infodata.util1.date.LocalDate.fromTimeInMillisLOCAL((Long)new Long(parseDate.getTime()));
            }
            catch (ParseException e) {
                System.out.println("Date: " + ligneService.dateServ);
                e.printStackTrace();
            }
            CPatient.Ages ages = null;
            CPatient patient = demContainer.getCurrentPatient();
            if (patient != null) {
                if (patient.bds != null && patient.getLDBirthDate() == null) {
                    patient.setLdbirthDate(ca.infodata.util1.date.LocalDate.fromCalendar((Calendar)DateUtil.ctod((String)patient.bds)));
                }
                if (patient.getLDBirthDate() != null) {
                    ages = new CPatient.Ages(patient.getLDBirthDate(), time);
                }
            }
            Object[] objectArray = new Object[5];
            objectArray[0] = ligneService.dateServ;
            objectArray[1] = ligneService.codRole;
            objectArray[3] = ages;
            objectArray[4] = demContainer.getSyraSettings().getBoolean("codePlusLibre", Boolean.FALSE);
            elmFact = objectArray;
            if (ligneService.codRole == 2) {
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = ligneService.dateServ;
                objectArray2[1] = new Integer(1);
                objectArray2[3] = ages;
                objectArray2[4] = demContainer.getSyraSettings().getBoolean("codePlusLibre", Boolean.FALSE);
                elmFactRole1 = objectArray2;
            }
        }
        if ((lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefFact, codFact, baseXquery, lieu, etablType, noSect, QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL, elmFact)).size() == 0 && elmFactRole1 != null) {
            lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefFact, codFact, baseXquery, lieu, etablType, noSect, QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL, elmFactRole1);
        }
        codeDesc = new CodeDesc[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDesc cd;
            codeDesc[i] = cd = new CodeDesc(lstNode.get(i)[0], lstNode.get(i)[1]);
            ++i;
        }
        return codeDesc;
    }

    public static BigInteger[] getBigIntArr(String s) {
        String[] b = s.split(",");
        BigInteger[] a = new BigInteger[b.length];
        int i = 0;
        String[] stringArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (StringUtils.isNotEmpty((CharSequence)t.trim())) {
                a[i++] = new BigInteger(t.trim());
            }
            ++n2;
        }
        return a;
    }

    public static Integer[] getIntArr(String s) {
        String[] b = s.split(",");
        Integer[] a = new Integer[b.length];
        int i = 0;
        String[] stringArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (StringUtils.isNotEmpty((CharSequence)t.trim())) {
                a[i++] = new Integer(t.trim());
            }
            ++n2;
        }
        return a;
    }

    public static Set<Integer> intSetFromString(String val) {
        Integer[] intArr = SyraPrefAndXmlDataController.getIntArr(val);
        HashSet<Integer> s = new HashSet<Integer>();
        Integer[] integerArray = intArr;
        int n = intArr.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = integerArray[n2];
            s.add(i);
            ++n2;
        }
        return s;
    }

    public static Set<BigInteger> bigIntSetFromString(String val) {
        BigInteger[] intArr = SyraPrefAndXmlDataController.getBigIntArr(val);
        HashSet<BigInteger> s = new HashSet<BigInteger>();
        BigInteger[] bigIntegerArray = intArr;
        int n = intArr.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger i = bigIntegerArray[n2];
            s.add(i);
            ++n2;
        }
        return s;
    }

    public static List<BigInteger> bigIntListFromString(String val) {
        return Arrays.asList(SyraPrefAndXmlDataController.getBigIntArr(val));
    }

    private static List<Integer> intListFromString(String val) {
        return Arrays.asList(SyraPrefAndXmlDataController.getIntArr(val));
    }

    public static void putCodOnlyInSect(String s) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            String[] codSect;
            String[] stringArray = codSect = s.split("~");
            int n = codSect.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                mapCodeOnlyInSect.put(Integer.valueOf(cd[0]), SyraPrefAndXmlDataController.intListFromString(cd[1]));
                ++n2;
            }
        }
    }

    public static void putCodNotInSect(String s) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            String[] codSect;
            String[] stringArray = codSect = s.split("~");
            int n = codSect.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                mapCodeNotInSect.put(Integer.valueOf(cd[0]), SyraPrefAndXmlDataController.intListFromString(cd[1]));
                ++n2;
            }
        }
    }

    public static void putCodFsFer(String val) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            String[] code;
            String[] stringArray = code = val.split("~");
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                mapCodFsFer.put(Integer.valueOf(cd[0]), SyraPrefAndXmlDataController.intListFromString(cd[1]));
                ++n2;
            }
        }
    }

    public static void putCodNotFsFer(String val) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            String[] code;
            String[] stringArray = code = val.split("~");
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                mapCodNotFsFer.put(Integer.valueOf(cd[0]), SyraPrefAndXmlDataController.intListFromString(cd[1]));
                ++n2;
            }
        }
    }

    public static void putCodNewCodPlaf(String val) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            String[] codePlaf;
            String[] stringArray = codePlaf = val.split("~");
            int n = codePlaf.length;
            int n2 = 0;
            while (n2 < n) {
                String[] specs;
                String c = stringArray[n2];
                String[] plafSpec = c.split(":");
                String[] stringArray2 = specs = plafSpec[0].split("[|]");
                int n3 = specs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] regles;
                    String spec = stringArray2[n4];
                    String rSpec = spec.indexOf(46) == -1 ? spec : spec.split("[/.]")[0];
                    Set<String> setSpecs = setSpec.get(rSpec);
                    if (setSpecs == null) {
                        setSpecs = new HashSet<String>();
                        setSpec.put(rSpec, setSpecs);
                    }
                    setSpecs.add(spec);
                    String[] stringArray3 = regles = plafSpec[1].split(";");
                    int n5 = regles.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String[] codesEtRech;
                        int n7;
                        int n8;
                        String[] stringArray4;
                        String rgl = stringArray3[n6];
                        String[] regle = rgl.split("-");
                        String duree = regle[0].substring(0, regle[0].length() - 1);
                        String unit = regle[0].substring(regle[0].length() - 1, regle[0].length());
                        int nbPermis = Integer.parseInt(regle[1]);
                        ReglePlafonnement reglePlaf = new ReglePlafonnement();
                        reglePlaf.setDuree(Integer.parseInt(duree));
                        reglePlaf.setUnit(UnitDuree.getFromDuree(unit.charAt(0)));
                        reglePlaf.setMaxPermis(nbPermis);
                        if (regle.length > 2 && regle[2].trim().length() > 0) {
                            String[] ctx;
                            stringArray4 = ctx = regle[2].split("[|]");
                            n8 = ctx.length;
                            n7 = 0;
                            while (n7 < n8) {
                                String eCtx = stringArray4[n7];
                                reglePlaf.addElmCtx(Integer.valueOf(eCtx));
                                ++n7;
                            }
                        }
                        stringArray4 = codesEtRech = plafSpec[2].split(";");
                        n8 = codesEtRech.length;
                        n7 = 0;
                        while (n7 < n8) {
                            String cer = stringArray4[n7];
                            ReglePlafonnement rp = reglePlaf.clone();
                            String[] codesCodeRech = cer.split("-");
                            String[] codes = codesCodeRech[0].split("[|]");
                            Integer codeRech = codesCodeRech.length > 1 ? Integer.valueOf(codesCodeRech[1]) : null;
                            rp.setCodeRechange(codeRech);
                            rp.addCodesToGroupeDeCode(codes);
                            String[] stringArray5 = codes;
                            int n9 = codes.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                String cc = stringArray5[n10];
                                String k = String.valueOf(spec) + "~" + cc;
                                List<ReglePlafonnement> lstRP = mapSpecCodReglePlafs.get(k);
                                if (lstRP == null) {
                                    lstRP = new ArrayList<ReglePlafonnement>();
                                    mapSpecCodReglePlafs.put(k, lstRP);
                                }
                                lstRP.add(rp);
                                ++n10;
                            }
                            ++n7;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            System.out.println("mapSpecCodReglePlafs=" + mapSpecCodReglePlafs.toString());
        }
    }

    public static Set<String> getSetSpec(String s) {
        return setSpec.get(s);
    }

    public static List<ReglePlafonnement> getListReglePlafonnement(String k) {
        return mapSpecCodReglePlafs.get(k);
    }

    public static void putMajorationDx(String s, Set<String> lstAllCodeDx) {
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            String[] majDx;
            String[] stringArray = majDx = s.split("~");
            int n = majDx.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                String[] cd = c.split(":");
                String[] dxs = cd[1].split(",");
                HashSet<String> lstDx = new HashSet<String>();
                int totalPotCode = 0;
                int totalReelCode = 0;
                String[] stringArray2 = dxs;
                int n3 = dxs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dx = stringArray2[n4];
                    if (dx.contains("-")) {
                        String[] sp1 = dx.split("-");
                        String[] sp1s = sp1[0].split("\\.");
                        String[] sp2s = sp1[1].split("\\.");
                        int lenDxI1 = sp1s[0].length();
                        int lenDxD1 = sp1s[1].length();
                        int lenDxD2 = sp2s[1].length();
                        int iDx1i = Integer.parseInt(sp1s[0]);
                        int iDx1d = Integer.parseInt(sp1s[1]);
                        int iDx2i = Integer.parseInt(sp2s[0]);
                        int iDx2d = Integer.parseInt(sp2s[1]);
                        int iDx1iTemp = iDx1i;
                        while (iDx1iTemp <= iDx2i) {
                            int maxDec = iDx1iTemp == iDx2i ? iDx2d : (iDx2d > 9 || iDx1d > 9 ? 99 : 9);
                            int lenDec = iDx1iTemp == iDx2i ? lenDxD2 : lenDxD1;
                            String iDx1is = Helper.padLeft(String.valueOf(iDx1iTemp), lenDxI1, '0');
                            int iDx1dTemp = iDx1iTemp == iDx1i ? iDx1d : 0;
                            while (iDx1dTemp <= maxDec) {
                                String code = String.valueOf(iDx1is) + Helper.padLeft(String.valueOf(iDx1dTemp++), lenDec, '0');
                                ++totalPotCode;
                                if (lstAllCodeDx.contains(code)) {
                                    ++totalReelCode;
                                    lstDx.add(code);
                                }
                                if (lenDec != 2) continue;
                                ++totalPotCode;
                                code = String.valueOf(iDx1is) + Helper.padLeft(String.valueOf(iDx1dTemp), 1, '0');
                                if (!lstAllCodeDx.contains(code)) continue;
                                ++totalReelCode;
                                lstDx.add(code);
                            }
                            ++iDx1iTemp;
                        }
                    } else {
                        ++totalPotCode;
                        ++totalReelCode;
                        lstDx.add(dx.replace(".", ""));
                    }
                    ++n4;
                }
                System.out.print(String.valueOf(cd[0]) + "(" + String.valueOf(totalReelCode) + "/" + String.valueOf(totalPotCode) + "):");
                for (String string : lstDx) {
                    System.out.print(String.valueOf(string) + ",");
                }
                System.out.println("");
                mapMajorationDx.put(cd[0], lstDx);
                ++n2;
            }
        }
    }

    protected ArrayList<String[]> genericSearchData(Integer idAnchorProf, String searchString, ArrayList<String> lstCode, CProfessionnalPrefData prefData, SetMultimap<Character, String> prefFact, QueryCriteria.ModelType codFact, IBaseXQuery dx, CLieu lieu, QueryCriteria.EtablType etablType, Integer secteur, QueryCriteria.CodNiveau codeNiveau, Object[] elmFact) {
        ArrayList<String[]> lstNode;
        block41: {
            lstNode = new ArrayList<String[]>();
            try {
                if (!StringUtils.isNotEmpty((CharSequence)searchString) && (lstCode == null || lstCode.isEmpty())) break block41;
                String filterDesc = CProfessionnalPrefData.getExcludeFitlterMapInscritValue(prefData.getPrefAutre("inscrit"));
                CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
                CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
                String codeSpec = null;
                if (cp != null && cp.getType() != null) {
                    entente = CProfessionnal.Entente.valueOf(cp.getType());
                    if (cp.getType() == 2) {
                        codeSpec = cp.getCodSpec();
                    }
                }
                String date = null;
                Integer role = null;
                Integer code = null;
                CPatient.Ages ages = null;
                Boolean codPlusLibre = Boolean.FALSE;
                if (QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL.equals((Object)codeNiveau)) {
                    if (elmFact != null) {
                        date = (String)elmFact[0];
                        role = (Integer)elmFact[1];
                        if (elmFact[2] != null) {
                            code = new Integer(((BigInteger)elmFact[2]).intValue());
                        }
                        if (elmFact.length > 3) {
                            ages = (CPatient.Ages)elmFact[3];
                            if (elmFact.length > 4 && elmFact[4] != null && elmFact[4] instanceof Boolean) {
                                codPlusLibre = (Boolean)elmFact[4];
                            }
                        }
                    }
                } else if (!QueryCriteria.CodNiveau.FACTURE_SERV_MDCAL.equals((Object)codeNiveau) && !QueryCriteria.CodNiveau.NONE.equals((Object)codeNiveau) && elmFact != null) {
                    date = (String)elmFact[0];
                    Integer n = code = elmFact[2] == null ? null : new Integer(((BigInteger)elmFact[2]).intValue());
                }
                if (etablType == null) {
                    etablType = QueryCriteria.EtablType.SO;
                }
                if (date == null) {
                    date = ca.infodata.util1.date.LocalDate.today().formatHyphen();
                }
                int firstChar = searchString.length() > 0 ? (int)searchString.charAt(0) : 32;
                Integer iEntente = entente.getValue();
                if (firstChar == 46) {
                    QueryCriteria criteria = new QueryCriteria(codFact, iEntente, role, null, null, filterDesc, date, code, codeNiveau, etablType);
                    criteria.setCodeSpec(codeSpec);
                    criteria.setAges(ages);
                    criteria.setCodePlusLibre(codPlusLibre);
                    lstNode.addAll(dx.getCodeDescription(criteria));
                    break block41;
                }
                boolean doNotUsePref = firstChar == 32 || prefFact == null;
                String ss = searchString.trim();
                ArrayList lst = new ArrayList();
                if (ss.length() == 1) {
                    if (doNotUsePref || !StringUtils.isAlpha((CharSequence)ss) || prefFact == null) break block41;
                    Set activeSet = prefFact.get((Object)Character.valueOf(ss.toUpperCase().charAt(0)));
                    if (activeSet != null && !activeSet.isEmpty()) {
                        Object sc;
                        TreeSet set = new TreeSet(activeSet);
                        HashSet<String> setToRemove = new HashSet<String>();
                        if (secteur != null) {
                            for (String s : set) {
                                sc = Integer.valueOf(s);
                                if (mapCodeOnlyInSect.containsKey(sc) && !mapCodeOnlyInSect.get(sc).contains(secteur)) {
                                    setToRemove.add(((Integer)sc).toString());
                                }
                                if (!mapCodeNotInSect.containsKey(sc) || !mapCodeNotInSect.get(sc).contains(secteur)) continue;
                                setToRemove.add(((Integer)sc).toString());
                            }
                        } else {
                            for (String s : set) {
                                sc = Integer.valueOf(s);
                                if (!mapCodeOnlyInSect.containsKey(sc)) continue;
                                setToRemove.add(((Integer)sc).toString());
                            }
                        }
                        boolean mustCheckFsFer = false;
                        for (String s : set) {
                            Integer sc2 = Integer.valueOf(s);
                            if (!mapCodFsFer.get(iEntente).contains(sc2) && !mapCodNotFsFer.get(iEntente).contains(sc2)) continue;
                            mustCheckFsFer = true;
                            break;
                        }
                        if (mustCheckFsFer) {
                            Boolean isFsFer = null;
                            Date ld = null;
                            try {
                                ld = DateUtils.parseDate((String)date, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss"});
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            if (ld != null) {
                                LocalDate lDate = LocalDate.fromTimeInMillisLOCAL((Long)new Long(ld.getTime()));
                                isFsFer = CLigneTypServMdcal.isFinSemOuFerie(lieu, lDate);
                            }
                            if (isFsFer != null) {
                                for (String s : set) {
                                    Integer sc3 = Integer.valueOf(s);
                                    if (mapCodFsFer.get(iEntente).contains(sc3) && !isFsFer.booleanValue()) {
                                        setToRemove.add(sc3.toString());
                                    }
                                    if (!mapCodNotFsFer.get(iEntente).contains(sc3) || !isFsFer.booleanValue()) continue;
                                    setToRemove.add(sc3.toString());
                                }
                            }
                        }
                        set.removeAll(setToRemove);
                        lst.addAll(set);
                    }
                    if (!lst.isEmpty()) {
                        QueryCriteria criteria = new QueryCriteria(codFact, iEntente, role, lst.toArray(new String[lst.size()]), null, filterDesc, date, code, codeNiveau, etablType);
                        criteria.setCodeSpec(codeSpec);
                        criteria.setAges(ages);
                        criteria.setCodePlusLibre(codPlusLibre);
                        lstNode.addAll(dx.getCodeDescription(criteria));
                    }
                    break block41;
                }
                if (ss.length() == 0 && lstCode != null && !lstCode.isEmpty()) {
                    String[] codeArr = new String[lstCode.size()];
                    lstCode.toArray(codeArr);
                    QueryCriteria criteria = new QueryCriteria(codFact, iEntente, role, codeArr, null, filterDesc, date, code, codeNiveau, etablType);
                    criteria.setCodeSpec(codeSpec);
                    criteria.setAges(ages);
                    criteria.setCodePlusLibre(codPlusLibre);
                    lstNode.addAll(dx.getCodeDescription(criteria));
                } else {
                    String[] sss = ss.split("[ ,']");
                    QueryCriteria criteria = null;
                    if (sss.length == 1) {
                        if (sss[0].length() > 1 && Chiffres.matcher(searchString).matches()) {
                            criteria = new QueryCriteria(codFact, iEntente, role, new String[]{sss[0]}, null, filterDesc, date, code, codeNiveau, etablType);
                            criteria.setCodeSpec(codeSpec);
                            criteria.setAges(ages);
                            criteria.setCodePlusLibre(codPlusLibre);
                        } else if (sss[0].length() > 3 || dx instanceof SecteurActivite && sss[0].length() > 2) {
                            criteria = new QueryCriteria(codFact, iEntente, role, null, sss[0], filterDesc, date, code, codeNiveau, etablType);
                            criteria.setCodeSpec(codeSpec);
                            criteria.setAges(ages);
                            criteria.setCodePlusLibre(codPlusLibre);
                        }
                        if (criteria != null) {
                            lstNode.addAll(dx.getCodeDescription(criteria));
                        }
                    } else {
                        int totalLength = 0;
                        String newSearchString = "";
                        String[] stringArray = sss;
                        int n = sss.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String m = stringArray[n2];
                            if (m.length() > 2) {
                                newSearchString = String.valueOf(newSearchString) + m + " ";
                                totalLength += m.length();
                            }
                            ++n2;
                        }
                        if (totalLength > 4) {
                            criteria = new QueryCriteria(codFact, iEntente, role, null, newSearchString, filterDesc, date, code, codeNiveau, etablType);
                            criteria.setCodeSpec(codeSpec);
                            criteria.setAges(ages);
                            criteria.setCodePlusLibre(codPlusLibre);
                            lstNode.addAll(dx.getCodeDescription(criteria));
                        }
                    }
                }
            }
            catch (IOException | QueryException e) {
                logger.log(Level.SEVERE, "getCodeFacturation with <" + searchString + "> for idAnchorProf " + idAnchorProf, e);
            }
        }
        return lstNode;
    }

    public Object[] getCodeFacturation(String code, CDemContainer demContainer) {
        BigInteger bCode = null;
        try {
            bCode = new BigInteger(code);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] codeDesc = new Object[]{};
        if (demContainer.getCurrentCLigneServMdcal() == null || bCode == null) {
            logger.log(Level.SEVERE, "getCodeFacturation", new Exception("demContainer.getCurrentCLigneServMdcal()=" + demContainer.getCurrentCLigneServMdcal() + ", bCode (bigInt)=" + bCode + ", code=" + code));
            return codeDesc;
        }
        String date = demContainer.getCurrentCLigneServMdcal().dateServ;
        Integer iRole = demContainer.getCurrentCLigneServMdcal().codRole;
        CProfessionnal prof = demContainer.getCurrentProf();
        if (prof == null) {
            return codeDesc;
        }
        CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
        if (prof.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(prof.getType());
        }
        QueryCriteria.EtablType etablType = QueryCriteria.EtablType.CABINET;
        CLieu lieu = demContainer.getCurrentLieu(prof);
        if ("C".equals(lieu.typLocEtab) && lieu.etab != null && lieu.etab.getValEtab() != null && "ETAB".equals(lieu.etab.getValEtab().getTypEtab())) {
            etablType = QueryCriteria.EtablType.ETABLISSEMENT;
        }
        if (CProfessionnal.Entente.OMNI.equals((Object)entente)) {
            return new CodeBigIntCodFact[]{CLigneTypServMdcal.getCodFactOmni(demContainer, this, prof.getId(), true, bCode, null, date, iRole, etablType)};
        }
        return new CodeBigIntCodFact[]{CLigneTypServMdcal.getCodFactSpec(demContainer, this, prof.getId(), true, bCode, null, date, iRole, etablType)};
    }

    protected CodeDesc[] getElmContx(Integer idAnchorProf, QueryCriteria.CodNiveau codeNiveau, String searchString, CDemContainer demContainer) {
        CLigneTypServMdcal ligneService;
        CodeDesc[] codeDesc = new CodeDesc[]{};
        ArrayList<String> lstCode = new ArrayList<String>();
        CProfessionnalPrefData pd = this.getPrefData(idAnchorProf);
        SetMultimap<Character, String> prefFact = pd == null ? null : pd.prefElmContx;
        QueryCriteria.ModelType codFact = QueryCriteria.ModelType.ELM_CONTX;
        ElementContext dx = new ElementContext();
        QueryCriteria.EtablType etablType = QueryCriteria.EtablType.CABINET;
        CLieu lieu = demContainer.getCurrentLieu(null);
        if ("C".equals(lieu.typLocEtab) && lieu.etab != null && lieu.etab.getValEtab() != null && "ETAB".equals(lieu.etab.getValEtab().getTypEtab())) {
            etablType = QueryCriteria.EtablType.ETABLISSEMENT;
        }
        Object[] elmFact = null;
        if (QueryCriteria.CodNiveau.LIGNE_SERV_MDCAL.equals((Object)codeNiveau) && (ligneService = demContainer.getCurrentCLigneServMdcal()) != null) {
            elmFact = new Object[]{ligneService.dateServ, ligneService.codRole, ligneService.codFact.c};
        }
        ArrayList<String[]> lstNode = this.genericSearchData(idAnchorProf, searchString, lstCode, pd, prefFact, codFact, dx, null, etablType, null, codeNiveau, elmFact);
        codeDesc = new CodeDesc[lstNode.size()];
        int i = 0;
        while (i < lstNode.size()) {
            CodeDesc cd;
            codeDesc[i] = cd = new CodeDesc(lstNode.get(i)[0], lstNode.get(i)[1]);
            ++i;
        }
        return codeDesc;
    }

    public Object[] getElmContx(Integer idAnchorProf, String code, String date, QueryCriteria.CodNiveau codNiveau) {
        QueryCriteria criteria;
        Object[] javaObjects;
        Object[] codeDesc = new Object[]{};
        CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
        ElementContext ix = new ElementContext();
        CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
        if (cp != null && cp.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(cp.getType());
        }
        if ((javaObjects = ((IBaseXQuery)ix).getJavaObjects(criteria = new QueryCriteria(QueryCriteria.ModelType.ELM_CONTX, entente.getValue(), null, new String[]{code}, null, null, date, null, codNiveau, QueryCriteria.EtablType.SO))).length == 1) {
            return javaObjects;
        }
        return codeDesc;
    }

    public String getElmContxDesc(Integer idAnchorProf, String code, String date, QueryCriteria.CodNiveau codNiveau) {
        CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
        ElementContext ix = new ElementContext();
        CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
        if (cp != null && cp.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(cp.getType());
        }
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.ELM_CONTX, entente.getValue(), null, new String[]{code}, null, null, date, null, codNiveau, QueryCriteria.EtablType.SO);
        return ((IBaseXQuery)ix).getDescriptionLong(criteria);
    }

    public Object getCodeFacturation(CDemContainer cDemContainer, Integer idAnchorProf, String code, String date, Integer iRole, QueryCriteria.EtablType etablType) {
        CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
        CodeFacturation ix = new CodeFacturation();
        CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
        Object act = null;
        String codSpec = null;
        if (cp != null && cp.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(cp.getType());
            if (cp.getType() == 2) {
                codSpec = cp.getCodSpec();
            }
        }
        if (etablType == null) {
            etablType = QueryCriteria.EtablType.SO;
        }
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, entente.getValue(), iRole, new String[]{code}, null, null, date, null, QueryCriteria.CodNiveau.NONE, etablType);
        criteria.setCodeSpec(codSpec);
        if (cDemContainer != null) {
            criteria.setCodePlusLibre(cDemContainer.getSyraSettings().getBoolean("codePlusLibre", Boolean.FALSE));
        }
        try {
            List<String> l = ((IBaseXQuery)ix).getDataByCriteria(criteria, IBaseXQuery.DataType.NODE);
            XStream xs = ix.getXstream();
            Iterator<String> iterator = l.iterator();
            if (iterator.hasNext()) {
                String s = iterator.next();
                act = ((IBaseXQuery)ix).getJavaObjectFromNode(entente, s, xs);
            }
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return act;
    }

    public String getCodeFacturationDesc(Integer idAnchorProf, String code, String date) {
        CProfessionnal cp = this.getCProfessionnal(idAnchorProf);
        CodeFacturation ix = new CodeFacturation();
        CProfessionnal.Entente entente = CProfessionnal.Entente.NON_DEF;
        if (cp != null && cp.getType() != null) {
            entente = CProfessionnal.Entente.valueOf(cp.getType());
        }
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_FACT, entente.getValue(), null, new String[]{code}, null, null, date, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        return ((IBaseXQuery)ix).getDescriptionLong(criteria);
    }

    public String getDiagnosticDesc(String code) {
        CodeDxQuery ix = new CodeDxQuery();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, null, null, new String[]{code}, null, null, null, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        return ((IBaseXQuery)ix).getDescriptionLong(criteria);
    }

    public Object[] getDiagnostic(String code) {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        Object[] listdx = new CodeDescDx[]{};
        CodeDxQuery ix = new CodeDxQuery();
        QueryCriteria criteria = new QueryCriteria(QueryCriteria.ModelType.COD_DIAGN_MDCAL, null, null, new String[]{code}, null, null, null, null, QueryCriteria.CodNiveau.NONE, QueryCriteria.EtablType.SO);
        criteria.setExactCode(Boolean.TRUE);
        try {
            lstNode.addAll(((IBaseXQuery)ix).getCodeDescription(criteria));
            listdx = new CodeDescDx[lstNode.size()];
            int i = 0;
            while (i < lstNode.size()) {
                CodeDescDx cd = new CodeDescDx(((String[])lstNode.get(i))[0], ((String[])lstNode.get(i))[1], ((String[])lstNode.get(i))[2], ((String[])lstNode.get(i))[3]);
                listdx[i] = cd;
                ++i;
            }
        }
        catch (QueryException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return listdx;
    }

    protected Object saveAllPrefProf(Integer idAnchorProf) {
        Integer rep = this.getAccessor().savePref(idAnchorProf);
        return rep;
    }

    public class ExcludeClass
    implements ExclusionStrategy {
        private final Class<?> typeToSkip;

        public ExcludeClass(Class<?> typeToSkip) {
            this.typeToSkip = typeToSkip;
        }

        public boolean shouldSkipClass(Class<?> clas_s) {
            return clas_s == this.typeToSkip;
        }

        public boolean shouldSkipField(FieldAttributes fieldAttributes) {
            if ("content".equals(fieldAttributes.getName())) {
                return fieldAttributes.getName().contains("ListeAttri");
            }
            if ("ddEffecCodFact".equals(fieldAttributes.getName())) {
                return true;
            }
            if ("dfEffecCodFact".equals(fieldAttributes.getName())) {
                return true;
            }
            return this.typeToSkip.equals(fieldAttributes.getDeclaredClass());
        }
    }
}

