/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.controller;

import ca.infodata.CacheService;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemPaimt;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CTypeObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hazelcast.core.IQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class OfysBillingConsumer {
    protected final ScheduledExecutorService billExecutor;
    protected final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
    protected int queueSize = 0;
    protected final SyraController controller;
    protected String activeUid = null;
    protected String prevUid = null;

    public OfysBillingConsumer(SyraController c) {
        this.controller = c;
        this.billExecutor = Executors.newScheduledThreadPool(1);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                IQueue queue = CacheService.getInstance().getQueue("billadd");
                Object peek = queue.peek();
                if (peek != null && OfysBillingConsumer.this.activeUid != null) {
                    CDemContainer cDemContainer = (CDemContainer)OfysBillingConsumer.this.controller.mapDemContainer.get(OfysBillingConsumer.this.activeUid);
                    if (cDemContainer != null) {
                        CDemPaimt demPaimt = cDemContainer.getCurrentDemPaimt();
                        if (demPaimt != null && CDemPaimt.TYPE_SERV.equals(demPaimt.type) && demPaimt.serv != null && demPaimt.serv.prof != null && StringUtils.isNotEmpty((CharSequence)demPaimt.serv.prof.getNoProf()) && demPaimt.serv.lieu != null && StringUtils.isNotEmpty((CharSequence)demPaimt.serv.lieu.typLocEtab) && (cDemContainer.getCurrentPatient() == null || cDemContainer.getCurrentPatient().getHealthInsuranceNumber() == null && cDemContainer.getCurrentPatient().getLastName() == null)) {
                            String val = (String)peek;
                            CPatient pt = (CPatient)OfysBillingConsumer.this.gson.fromJson(val, CPatient.class);
                            System.out.println("poll=" + pt);
                            if (StringUtils.isNotEmpty((CharSequence)pt.getHealthInsuranceNumber())) {
                                pt.setTypIdPerson(new Integer(1));
                                pt.setTypePerson(1);
                                pt.setTypSituConsi(1);
                            } else {
                                pt.setTypIdPerson(null);
                                pt.setTypePerson(2);
                                int age = pt.getAge();
                                pt.setTypSituConsi(age < 1 ? 2 : 3);
                            }
                            pt.setTag(CPatient.getTempId());
                            CTypeObject toDemPaimt = new CTypeObject("setCurrentPatient", pt);
                            String msgDemPaimtType = new GsonBuilder().create().toJson((Object)toDemPaimt);
                            boolean messageToWebClient = HtmlBrowserTools.sendMessageToWebClient((String)OfysBillingConsumer.this.activeUid, (String)msgDemPaimtType);
                            if (messageToWebClient) {
                                cDemContainer.setCurrentValue("currentPatient", pt);
                                System.out.println("Succ\u00e8s du send - je retire l'\u00e9l\u00e9ment de la liste");
                                queue.poll();
                            }
                            System.out.println("After sendMessageToWebClient:" + pt);
                        }
                        OfysBillingConsumer.this.prevUid = OfysBillingConsumer.this.activeUid;
                        OfysBillingConsumer.this.queueSize = queue.size();
                        CTypeObject toDemPaimt = new CTypeObject("billQueueSize", new Integer(OfysBillingConsumer.this.queueSize));
                        String msgDemPaimtType = new GsonBuilder().create().toJson((Object)toDemPaimt);
                        HtmlBrowserTools.sendMessageToWebClient((String)OfysBillingConsumer.this.activeUid, (String)msgDemPaimtType);
                    }
                } else if (OfysBillingConsumer.this.queueSize > 0 && queue.size() == 0) {
                    OfysBillingConsumer.this.queueSize = 0;
                    CTypeObject toDemPaimt = new CTypeObject("billQueueSize", new Integer(OfysBillingConsumer.this.queueSize));
                    String msgDemPaimtType = new GsonBuilder().create().toJson((Object)toDemPaimt);
                    HtmlBrowserTools.sendMessageToWebClient((String)OfysBillingConsumer.this.activeUid, (String)msgDemPaimtType);
                }
            }
        };
        this.billExecutor.scheduleAtFixedRate(run, 10L, 2L, TimeUnit.SECONDS);
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public final String getActiveUid() {
        return this.activeUid;
    }

    public final void setActiveUid(String activeUid) {
        this.activeUid = activeUid;
    }
}

