/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra;

import ca.infodata.CacheService;
import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.hibernate.fmedx.dao.FmedxBaseDAO;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import ca.infodata.ofys.ui.controls.windows.Dialog;
import ca.infodata.ofys.util.date.LocalDate;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.controller.SyraPrefAndXmlDataController;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.models.IdentSyra;
import ca.infodata.syra.services.EchgLotFichDPEntrantCriteria;
import ca.infodata.syra.services.EchgLotFichDPEntrantResult;
import ca.infodata.syra.services.EchgLotFichECSortantCriteria;
import ca.infodata.syra.services.EchgLotFichErrSortantCriteria;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.DownloadValideur;
import ca.infodata.syra.util.ValidRamq;
import com.google.gson.GsonBuilder;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryEvictedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapClearedListener;
import com.hazelcast.map.listener.MapEvictedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.osgi.framework.BundleContext;

public class SyraPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "ca.infodata.syra";
    private static SyraPlugin plugin;
    public static String version;
    public static String nomLogiciel;
    public static String noVersiXmlDem;
    public static SyraController syraController;
    String entryListenerKeyOfys = null;
    String billItemListenerOfysKey = null;
    String mdItemListenerOfysKey = null;
    private static String urlValidAddress;
    private static boolean internetOk;
    OfysProp ofysProp = null;

    static {
        version = "6.6.0";
        nomLogiciel = "MED-Office";
        noVersiXmlDem = "ACTE";
        urlValidAddress = "http://www.infodata.ca/ftp/valid/syratest/";
        internetOk = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.out.println("SyraPlugin.start()");
        plugin = this;
        syraController = this.startSyraController();
        this.checkFichierSyraValidVersion();
        this.checkIfNewInstalledVersion();
        this.checkFichiersAideSaisieVersion(context, syraController);
        this.checkLastModDateIdMachine(context, syraController);
    }

    public void activateSharing() {
        if (CacheService.getInstance() != null && this.entryListenerKeyOfys == null) {
            this.entryListenerKeyOfys = CacheService.getInstance().getMap("ofys").addEntryListener((MapListener)new MyEntryListener(EntryListenerType.OFYS), true);
            this.billItemListenerOfysKey = CacheService.getInstance().getQueue("billadd").addItemListener((ItemListener)new BillItemListener(EntryListenerType.OFYS), true);
            this.mdItemListenerOfysKey = CacheService.getInstance().getQueue("mdadd").addItemListener((ItemListener)new MdItemListener(EntryListenerType.OFYS), true);
        }
    }

    public void stopSharing(String t) {
        if (CacheService.getInstance() != null) {
            CacheService.getInstance().getMap("ofys").remove((Object)"uid");
            if (this.entryListenerKeyOfys != null) {
                CacheService.getInstance().getMap("ofys").removeEntryListener(this.entryListenerKeyOfys);
            }
            if (this.billItemListenerOfysKey != null) {
                CacheService.getInstance().getQueue("bill").removeItemListener(this.billItemListenerOfysKey);
            }
            if (this.mdItemListenerOfysKey != null) {
                CacheService.getInstance().getQueue("mdadd").removeItemListener(this.mdItemListenerOfysKey);
            }
        }
    }

    public SyraController startSyraController() {
        BundleContext context = this.getBundle().getBundleContext();
        syraController = new SyraController();
        try {
            HtmlBrowserTools.getClasspathHandler().addClassLoader("/syra/Resources/*", context);
            HashMap<String, SyraController> controllers = new HashMap<String, SyraController>();
            controllers.put("/syra/*", syraController);
            SonarDispatcher.getInstance().addControllers(controllers, context, "/syra");
        }
        catch (IllegalArgumentException e) {
            System.out.println("ajout d'un path existant - exception sans importance: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return syraController;
    }

    public void stopSyraController() {
        if (syraController != null) {
            syraController.dispose();
        }
    }

    private void checkIfNewInstalledVersion() {
        try {
            File file = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/medoffice.version");
            File fileV = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/application/medoffice.version");
            if (fileV.exists()) {
                if (!file.exists()) {
                    FileUtils.copyFile((File)fileV, (File)file);
                    CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).set("show_news", (Object)Boolean.TRUE);
                } else {
                    String version = FileUtils.readFileToString((File)file);
                    String appVersion = FileUtils.readFileToString((File)fileV);
                    if (appVersion.compareTo(version) > 0) {
                        CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel).set("show_news", (Object)Boolean.TRUE);
                    }
                    file.delete();
                    FileUtils.copyFile((File)fileV, (File)file);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkFichierSyraValidVersion() {
        File file = new File(String.valueOf(LibPlugin.MEDO_PATH) + "/syravalid.info");
        if (file.exists()) {
            urlValidAddress = LibPlugin.fileToStr((String)file.getPath());
        }
        System.out.println(urlValidAddress);
        Properties propServeur = new Properties();
        URL urlDuValidServeur = null;
        String syraValid = "syra_valid.txt";
        try {
            urlDuValidServeur = new URL(String.valueOf(urlValidAddress) + "syra_valid.txt");
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        propServeur = SyraPlugin.getVersionPropertiesFromServer(urlDuValidServeur);
        if (internetOk && !propServeur.isEmpty()) {
            Set<Map.Entry<Object, Object>> props = propServeur.entrySet();
            Session session = null;
            for (Map.Entry<Object, Object> p : props) {
                block80: {
                    String type = (String)p.getKey();
                    Integer vers = Integer.valueOf((String)p.getValue());
                    try {
                        try {
                            block82: {
                                boolean hasData;
                                session = FmedxBaseDAO.getInstance().getSession();
                                SQLQuery query = session.createSQLQuery("select aversion from public.syra_valid_version where atype='" + type + "'").addScalar("aversion", (Type)IntegerType.INSTANCE);
                                List list = query.list();
                                boolean bl = hasData = list.size() > 0;
                                if (!hasData) {
                                    SQLQuery queryUpdate = session.createSQLQuery("insert into public.syra_valid_version (atype, aversion) values ('" + type + "'," + vers + ")");
                                    queryUpdate.executeUpdate();
                                }
                                if (hasData && vers.equals(list.get(0))) break block80;
                                URL urlValidType = null;
                                String validType = String.valueOf(type) + ".txt";
                                try {
                                    urlValidType = new URL(String.valueOf(urlValidAddress) + (String)validType);
                                }
                                catch (MalformedURLException e1) {
                                    e1.printStackTrace();
                                }
                                String valTxt = SyraPlugin.getFileFromServer(urlValidType);
                                if (!StringUtils.isNotEmpty((String)valTxt)) break block80;
                                Scanner scanner = null;
                                try {
                                    try {
                                        SQLQuery update;
                                        String line;
                                        StringBuffer sb;
                                        SQLQuery update2;
                                        String sql;
                                        SQLQuery queryUpdate;
                                        if ("syra_needs".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public." + type + " where atype like 'need%'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public." + type + " (atype, avalue) values ('__TYPE__','__VALUE__')";
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                String line2 = scanner.nextLine();
                                                if (line2.startsWith("#") || line2.length() <= 2) continue;
                                                String[] needs = line2.split("=");
                                                update2 = session.createSQLQuery(sql.replace("__TYPE__", needs[0]).replace("__VALUE__", needs[1]));
                                                update2.executeUpdate();
                                            }
                                        } else if ("syra_add_code".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'add_code'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('add_code','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_sect_only_in".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'sect_only%'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('sect_only_in','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_sect_not_in".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'sect_not%'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('sect_not_in','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("majoration_dx".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'majoration_dx'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('majoration_dx','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_fs_fer".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'syra_fs_fer'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('syra_fs_fer','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_not_fs_fer".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'syra_not_fs_fer'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('syra_not_fs_fer','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_new_cod_plaf".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public.syra_needs where atype like 'syra_new_cod_plaf'");
                                            queryUpdate.executeUpdate();
                                            sql = "insert into public.syra_needs (atype, avalue) values ('syra_new_cod_plaf','__VALUE__')";
                                            sb = new StringBuffer();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                line = scanner.nextLine();
                                                if (line.startsWith("#") || line.length() <= 2) continue;
                                                sb.append(line).append("~");
                                            }
                                            sb.deleteCharAt(sb.length() - 1);
                                            update = session.createSQLQuery(sql.replace("__VALUE__", sb.toString()));
                                            update.executeUpdate();
                                        } else if ("syra_cod_plaf".equals(type)) {
                                            queryUpdate = session.createSQLQuery("delete from public." + type);
                                            queryUpdate.executeUpdate();
                                            scanner = new Scanner(valTxt);
                                            while (scanner.hasNextLine()) {
                                                String line3 = scanner.nextLine();
                                                if (line3.startsWith("NO_ENTEN") || line3.length() < 2) continue;
                                                String sql2 = "insert into public." + type + " (NO_ENTEN,COD_SPEC,LIEU,COD_ACTE,MOIS,MOIS003,PLAFDIFF,CODERECH,PLAF_ACT,PLAF_NB,PLAF_INT) " + "values (_NE_,_CS_,_L_,_CA_,_MS_,_MS3_,_PD_,_CR_,_PA_,_PN_,_PI_)";
                                                String[] c = line3.split(",");
                                                sql2 = sql2.replace("_NE_", String.valueOf(ConvertJavaToFromArray.parseInt(c[0])));
                                                sql2 = sql2.replace("_CS_", String.valueOf(ConvertJavaToFromArray.parseInt(c[1])));
                                                sql2 = sql2.replace("_L_", "'" + c[2] + "'");
                                                sql2 = sql2.replace("_CA_", String.valueOf(ConvertJavaToFromArray.parseInt(c[3])));
                                                sql2 = sql2.replace("_MS_", String.valueOf(ConvertJavaToFromArray.parseInt(c[4])));
                                                sql2 = sql2.replace("_MS3_", String.valueOf(ConvertJavaToFromArray.parseInt(c[5])));
                                                sql2 = sql2.replace("_PD_", "'" + c[6] + "'");
                                                sql2 = sql2.replace("_CR_", String.valueOf(ConvertJavaToFromArray.parseInt(c[7])));
                                                sql2 = sql2.replace("_PA_", String.valueOf(ConvertJavaToFromArray.parseInt(c[8])));
                                                sql2 = sql2.replace("_PN_", String.valueOf(ConvertJavaToFromArray.parseInt(c[9])));
                                                sql2 = sql2.replace("_PI_", String.valueOf(ConvertJavaToFromArray.parseInt(c[10])));
                                                update2 = session.createSQLQuery(sql2);
                                                update2.executeUpdate();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        LibPlugin.log((String)"Erreur", (Exception)e);
                                        try {
                                            if (scanner != null) {
                                                scanner.close();
                                            }
                                            break block82;
                                        }
                                        catch (Exception e2) {
                                            LibPlugin.log((String)"Erreur", (Exception)e2);
                                        }
                                        break block82;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (scanner != null) {
                                            scanner.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        LibPlugin.log((String)"Erreur", (Exception)e);
                                    }
                                    throw throwable;
                                }
                                try {
                                    if (scanner != null) {
                                        scanner.close();
                                    }
                                }
                                catch (Exception e) {
                                    LibPlugin.log((String)"Erreur", (Exception)e);
                                }
                            }
                            SQLQuery udpate = session.createSQLQuery("update public.syra_valid_version set aversion=" + p.getValue() + " where atype='" + (String)p.getKey() + "'");
                            udpate.executeUpdate();
                        }
                        catch (Exception e) {
                            LibPlugin.log((String)"SQL Erreur", (Exception)e);
                            FmedxBaseDAO.getInstance().closeSession(session);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        FmedxBaseDAO.getInstance().closeSession(session);
                        throw throwable;
                    }
                }
                FmedxBaseDAO.getInstance().closeSession(session);
            }
        }
        Session session = null;
        try {
            try {
                session = FmedxBaseDAO.getInstance().getSession();
                SQLQuery query = session.createSQLQuery("select atype, avalue from public.syra_needs").addScalar("atype", (Type)StringType.INSTANCE).addScalar("avalue", (Type)StringType.INSTANCE);
                List list = query.list();
                for (Object[] oo : list) {
                    String t = (String)oo[0];
                    String val = (String)oo[1];
                    if ("needMdRefSpec".equals(t)) {
                        CLigneTypServMdcal.needMdRefSpec(val);
                        continue;
                    }
                    if ("needInfSpec".equals(t)) {
                        CLigneTypServMdcal.needInfSpec(val);
                        continue;
                    }
                    if ("needSagFSpec".equals(t)) {
                        CLigneTypServMdcal.needSagFSpec(val);
                        continue;
                    }
                    if ("needPharmSpec".equals(t)) {
                        CLigneTypServMdcal.needPharmSpec(val);
                        continue;
                    }
                    if ("needIntSpec".equals(t)) {
                        CLigneTypServMdcal.needIntSpec(val);
                        continue;
                    }
                    if ("needAudioSpec".equals(t)) {
                        CLigneTypServMdcal.needAudioSpec(val);
                        continue;
                    }
                    if ("needMdRefOmni".equals(t)) {
                        CLigneTypServMdcal.needMdRefOmni(val);
                        continue;
                    }
                    if ("needInfOmni".equals(t)) {
                        CLigneTypServMdcal.needInfOmni(val);
                        continue;
                    }
                    if ("needSagFOmni".equals(t)) {
                        CLigneTypServMdcal.needSagFOmni(val);
                        continue;
                    }
                    if ("needPharmOmni".equals(t)) {
                        CLigneTypServMdcal.needPharmOmni(val);
                        continue;
                    }
                    if ("needIntOmni".equals(t)) {
                        CLigneTypServMdcal.needIntOmni(val);
                        continue;
                    }
                    if ("needLieuRef".equals(t)) {
                        CLigneTypServMdcal.needLieuRef(val);
                        continue;
                    }
                    if ("needDDM".equals(t)) {
                        CLigneTypServMdcal.needDDM(val);
                        continue;
                    }
                    if ("needDPA".equals(t)) {
                        CLigneTypServMdcal.needDPA(val);
                        continue;
                    }
                    if ("add_code".equals(t)) {
                        CLigneTypServMdcal.putAddCode(val);
                        continue;
                    }
                    if ("sect_not_in".equals(t)) {
                        SyraPrefAndXmlDataController.putCodNotInSect(val);
                        continue;
                    }
                    if ("sect_only_in".equals(t)) {
                        SyraPrefAndXmlDataController.putCodOnlyInSect(val);
                        continue;
                    }
                    if ("majoration_dx".equals(t)) {
                        String[] majDx;
                        Collection<CProfessionnal> profs = syraController.getAllCProfessionnal();
                        HashSet<String> noSpecActive = new HashSet<String>();
                        for (CProfessionnal cProf : profs) {
                            noSpecActive.add(cProf.getCodSpec());
                        }
                        boolean hasASpec = false;
                        if (!StringUtils.isNotEmpty((String)val)) continue;
                        String[] stringArray = majDx = val.split("~");
                        int n = majDx.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String c = stringArray[n2];
                            String[] cd = c.split(":");
                            if (noSpecActive.contains(cd[0])) {
                                hasASpec = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!hasASpec) continue;
                        Set<String> lstAllCodeDx = syraController.getAllCodeDx();
                        SyraPrefAndXmlDataController.putMajorationDx(val, lstAllCodeDx);
                        continue;
                    }
                    if ("syra_fs_fer".equals(t)) {
                        SyraPrefAndXmlDataController.putCodFsFer(val);
                        continue;
                    }
                    if ("syra_not_fs_fer".equals(t)) {
                        SyraPrefAndXmlDataController.putCodNotFsFer(val);
                        continue;
                    }
                    if (!"syra_new_cod_plaf".equals(t)) continue;
                    SyraPrefAndXmlDataController.putCodNewCodPlaf(val);
                }
            }
            catch (Exception e) {
                LibPlugin.log((String)"SQL Erreur", (Exception)e);
                FmedxBaseDAO.getInstance().closeSession(session);
            }
        }
        finally {
            FmedxBaseDAO.getInstance().closeSession(session);
        }
    }

    protected static Properties getVersionPropertiesFromServer(URL urlFileVersion) {
        Properties serverProp = new Properties();
        try {
            String r = SyraPlugin.getFileFromServer(urlFileVersion);
            if (internetOk) {
                ByteArrayInputStream stream = new ByteArrayInputStream(r.getBytes(StandardCharsets.UTF_8));
                serverProp.load(stream);
                ((InputStream)stream).close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return serverProp;
    }

    protected static String getFileFromServer(URL url) {
        String rep = null;
        internetOk = true;
        byte[] buffer = new byte[16384];
        InputStream in = null;
        try {
            in = (InputStream)url.getContent();
        }
        catch (IOException e1) {
            internetOk = false;
        }
        if (in != null) {
            try {
                int count;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((count = in.read(buffer)) != -1) {
                    out.write(buffer, 0, count);
                }
                in.close();
                out.close();
                rep = new String(out.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rep;
    }

    private void checkFichiersAideSaisieVersion(BundleContext context, SyraController syraController) {
        if (LibPlugin.isInfodata) {
            return;
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Object res;
                if (DownloadValideur.getInstance().checkParamComm() && new Integer(1).equals(res = syraController.newAvailVersionFichiersVersions())) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Dialog.infoAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Fichiers d'aide \u00e0 la saisie", (String)"Une nouvelle version est disponible et doit \u00eatre install\u00e9e imm\u00e9diatement. Veuillez attendre le message suivant avant d'utiliser MED-Office.");
                        }
                    });
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    new ProgressMonitorDialog(LibPlugin.getDefault().getShell()).run(true, false, (IRunnableWithProgress)new NewFichierAideSaisieOperation());
                                }
                                catch (InvocationTargetException e) {
                                    MessageDialog.openError((Shell)LibPlugin.getDefault().getShell(), (String)"Error", (String)e.getMessage());
                                    if (CacheService.getServiceInstance() != null) {
                                        CacheService.getServiceInstance().clearAllMap();
                                    }
                                }
                                catch (InterruptedException e) {
                                    MessageDialog.openInformation((Shell)LibPlugin.getDefault().getShell(), (String)"Cancelled", (String)e.getMessage());
                                    if (CacheService.getServiceInstance() != null) {
                                        CacheService.getServiceInstance().clearAllMap();
                                    }
                                }
                            }
                            finally {
                                if (CacheService.getServiceInstance() != null) {
                                    CacheService.getServiceInstance().clearAllMap();
                                }
                            }
                        }
                    });
                }
            }
        };
        Timer time = new Timer();
        time.schedule(task, 100L);
    }

    private void checkLastModDateIdMachine(BundleContext context, SyraController syraController) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (DownloadValideur.getInstance().checkParamComm()) {
                    SyraGlobalSettings globalSettings = CDemContainer.getSyraglobalsettings(ConnectionFactory.connectionLabel);
                    final String agence = globalSettings.get("syra_noAgence");
                    final String userId = globalSettings.get("syra_idMach");
                    final String userPswd = globalSettings.get("syra_idMachPswd");
                    String userPswdDate = globalSettings.get("syra_idMachPswdDate");
                    if (userPswdDate != null && userPswdDate.length() >= 10) {
                        userPswdDate = userPswdDate.substring(0, 10);
                    }
                    Calendar cal = DateUtil.ctod((String)userPswdDate);
                    LocalDate lastDate = null;
                    if (cal != null) {
                        lastDate = LocalDate.fromCalendar((Calendar)cal);
                    }
                    LocalDate lastMonth = LocalDate.today().plusMonth(-1);
                    if (lastDate == null || lastDate.before(lastMonth)) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Dialog.infoAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Mot de passe machine", (String)"Il est temps de demander un nouveau mot de passe machine Syra!");
                            }
                        });
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    new ProgressMonitorDialog(LibPlugin.getDefault().getShell()).run(true, false, (IRunnableWithProgress)new NewIdMachineOperation(agence, userId, userPswd, syraController));
                                }
                                catch (InvocationTargetException e) {
                                    MessageDialog.openError((Shell)LibPlugin.getDefault().getShell(), (String)"Error", (String)e.getMessage());
                                }
                                catch (InterruptedException e) {
                                    MessageDialog.openInformation((Shell)LibPlugin.getDefault().getShell(), (String)"Cancelled", (String)e.getMessage());
                                }
                            }
                        });
                    }
                }
            }
        };
        Timer time = new Timer();
        time.schedule(task, 100L);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (CacheService.getInstance() != null && this.entryListenerKeyOfys != null) {
            CacheService.getInstance().getMap("ofys").removeEntryListener(this.entryListenerKeyOfys);
        }
        this.stopSyraController();
        super.stop(context);
    }

    public static SyraPlugin getDefault() {
        return plugin;
    }

    public EchgLotFichDPEntrantCriteria getEchgLotFichDPEntrantCriteria() {
        EchgLotFichDPEntrantCriteria criteria = null;
        DownloadValideur valideur = DownloadValideur.getInstance();
        if (valideur.checkParamComm()) {
            criteria = new EchgLotFichDPEntrantCriteria(valideur.userId, valideur.userPswd, valideur.agence);
        }
        return criteria;
    }

    public EchgLotFichECSortantCriteria getEchgLotFichECSortanttCriteria() {
        EchgLotFichECSortantCriteria criteria = null;
        DownloadValideur valideur = DownloadValideur.getInstance();
        if (valideur.checkParamComm()) {
            criteria = new EchgLotFichECSortantCriteria(valideur.userId, valideur.userPswd, valideur.agence);
        }
        return criteria;
    }

    public EchgLotFichErrSortantCriteria getEchgLotFichErrSortantCriteria() {
        EchgLotFichErrSortantCriteria criteria = null;
        DownloadValideur valideur = DownloadValideur.getInstance();
        if (valideur.checkParamComm()) {
            criteria = new EchgLotFichErrSortantCriteria(valideur.userId, valideur.userPswd, valideur.agence);
        }
        return criteria;
    }

    public EchgLotFichDPEntrantResult getEchgLotFichDPEntrantResult() {
        DownloadValideur valideur = DownloadValideur.getInstance();
        EchgLotFichDPEntrantResult result = null;
        if (valideur.checkParamComm()) {
            result = new EchgLotFichDPEntrantResult(valideur.userId, valideur.userPswd);
        }
        return result;
    }

    public void sendBillQueueCount() {
        IQueue queue = CacheService.getInstance().getQueue("bill");
        if (queue != null) {
            CTypeObject to1 = new CTypeObject("billQueueCountType", new Integer(queue.size()));
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)this.ofysProp.getUid(), (String)message1);
        }
    }

    class BillItemListener
    implements ItemListener<Object> {
        final EntryListenerType type;

        public BillItemListener(EntryListenerType type) {
            this.type = type;
        }

        public void itemAdded(ItemEvent<Object> item) {
            System.out.println("BillItemListener Item added = " + item);
        }

        public void itemRemoved(ItemEvent<Object> item) {
            System.out.println("BillItemListener Item removed = " + item);
        }
    }

    static enum EntryListenerType {
        OSCAR,
        OFYS;

    }

    class MdItemListener
    implements ItemListener<Object> {
        final EntryListenerType type;

        public MdItemListener(EntryListenerType type) {
            this.type = type;
        }

        public void itemAdded(ItemEvent<Object> item) {
            System.out.println("MdItemListener Item added = " + item);
        }

        public void itemRemoved(ItemEvent<Object> item) {
            System.out.println("MdItemListener Item removed = " + item);
        }
    }

    class MyEntryListener
    implements EntryAddedListener<String, String>,
    EntryRemovedListener<String, String>,
    EntryUpdatedListener<String, String>,
    EntryEvictedListener<String, String>,
    MapEvictedListener,
    MapClearedListener {
        final EntryListenerType type;

        public MyEntryListener(EntryListenerType type) {
            this.type = type;
        }

        public void entryAdded(EntryEvent<String, String> event) {
            System.out.println("Entry Added:" + event);
            this.setOfysProp(event);
        }

        private void setOfysProp(EntryEvent<String, String> event) {
            if (EntryListenerType.OFYS.equals((Object)this.type)) {
                if (SyraPlugin.this.ofysProp == null) {
                    SyraPlugin.this.ofysProp = new OfysProp();
                }
                this.setOfysPropValues(event);
            }
        }

        public void entryRemoved(EntryEvent<String, String> event) {
            System.out.println("Entry Removed:" + event);
            this.setOfysPropValues(event);
        }

        public void entryUpdated(EntryEvent<String, String> event) {
            System.out.println("Entry Updated:" + event);
            this.setOfysPropValues(event);
        }

        public void entryEvicted(EntryEvent<String, String> event) {
            System.out.println("Entry Evicted:" + event);
        }

        public void mapEvicted(MapEvent event) {
            System.out.println("Map Evicted:" + event);
        }

        public void mapCleared(MapEvent event) {
            System.out.println("Map Cleared:" + event);
            if (SyraPlugin.this.ofysProp != null) {
                if (SyraPlugin.this.ofysProp.getIdentifiant() != null) {
                    this.sendDisconnectedFromDme();
                }
                SyraPlugin.this.ofysProp = null;
            }
        }

        public void setOfysPropValues(EntryEvent<String, String> event) {
            OfysProp prop = SyraPlugin.this.ofysProp;
            if ("uid".equals(event.getKey())) {
                prop.setUid((String)event.getValue());
            }
            if ("identifiant".equals(event.getKey())) {
                if (event.getValue() == null) {
                    this.sendDisconnectedFromDme();
                }
                prop.setIdentifiant((String)event.getValue());
            }
            if ("url".equals(event.getKey())) {
                prop.setUrl((String)event.getValue());
            }
            if ("password".equals(event.getKey())) {
                prop.setPassword((String)event.getValue());
            }
            if ("codeClient".equals(event.getKey())) {
                prop.setCodeClient((String)event.getValue());
            }
            if (prop.isDmeConnected()) {
                CTypeObject to1 = new CTypeObject("shareDmeType", "1");
                String message1 = new GsonBuilder().create().toJson((Object)to1);
                HtmlBrowserTools.sendMessageToWebClient((String)prop.getUid(), (String)message1);
            }
        }

        public void sendDisconnectedFromDme() {
            CTypeObject to1 = new CTypeObject("shareDmeType", "0");
            String message1 = new GsonBuilder().create().toJson((Object)to1);
            HtmlBrowserTools.sendMessageToWebClient((String)SyraPlugin.this.ofysProp.getUid(), (String)message1);
        }
    }

    class NewFichierAideSaisieOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("T\u00e9l\u00e9chargement et int\u00e9gration des fichiers...", -1);
            final Status status = DownloadValideur.getInstance().doUpdate(null);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (status.isOK()) {
                        Dialog.infoAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Fichiers d'aide \u00e0 la saisie", (String)"Proc\u00e9dure termin\u00e9e avec succ\u00e8s.");
                    } else {
                        Dialog.warningAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Fichiers d'aide \u00e0 la saisie", (String)("Erreur lors de la proc\u00e9dure:\n" + status.getMessage()));
                    }
                }
            });
            monitor.done();
            if (monitor.isCanceled()) {
                throw new InterruptedException("La proc\u00e9dure a \u00e9t\u00e9 annul\u00e9e");
            }
        }
    }

    class NewIdMachineOperation
    implements IRunnableWithProgress {
        final String agence;
        final String userId;
        final String userPswd;
        final SyraController sc;
        Status status;

        public NewIdMachineOperation(String agence, String userId, String userPswd, SyraController syraController) {
            this.agence = agence;
            this.userId = userId;
            this.userPswd = userPswd;
            this.sc = syraController;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Demande d'un nouveau mot de passe...", -1);
            this.status = new Status(IStatus.Severity.OK, "");
            try {
                this.status = ValidRamq.getInstance().renewIdMach(this.userId, this.userPswd, this.agence);
            }
            catch (Exception e) {
                String cause = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    cause = String.valueOf(cause) + ". Cause: " + e.getCause().getMessage();
                }
                this.status = new Status(IStatus.Severity.ERROR, "Erreur lors du renouvellement du mot de passe pour [" + this.userId + "]. " + cause);
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (NewIdMachineOperation.this.status.isOK()) {
                        IdentSyra data = (IdentSyra)NewIdMachineOperation.this.status.getData();
                        NewIdMachineOperation.this.sc.getIdentSyra().syra_idMachPswd = data.syra_idMachPswd;
                        Dialog.infoAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Nouveau mot de passe machine", (String)"Proc\u00e9dure termin\u00e9e avec succ\u00e8s.");
                    } else {
                        Dialog.warningAlert((Shell)LibPlugin.getDefault().getShell(), (String)"Nouveau mot de passe machine", (String)("Erreur lors de la proc\u00e9dure:\n" + NewIdMachineOperation.this.status.getMessage()));
                    }
                }
            });
            monitor.done();
            if (monitor.isCanceled()) {
                throw new InterruptedException("La proc\u00e9dure a \u00e9t\u00e9 annul\u00e9e");
            }
        }
    }

    class OfysProp {
        private String url = null;
        private String identifiant = null;
        private String password = null;
        private String codeClient = null;
        private String uid = null;

        OfysProp() {
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getIdentifiant() {
            return this.identifiant;
        }

        public final void setIdentifiant(String identifiant) {
            this.identifiant = identifiant;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getCodeClient() {
            return this.codeClient;
        }

        public final void setCodeClient(String pin) {
            this.codeClient = pin;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public boolean isDmeConnected() {
            return this.getIdentifiant() != null && this.getUrl() != null && this.getPassword() != null && this.getCodeClient() != null;
        }
    }
}

