/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra;

import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.DemListCriteria;
import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.dossier.hibernate.City;
import ca.infodata.dossier.hibernate.DemForListe;
import ca.infodata.dossier.hibernate.DiagnosticCIM9;
import ca.infodata.dossier.hibernate.DossierHibernatePlugin;
import ca.infodata.dossier.hibernate.Patient;
import ca.infodata.dossier.hibernate.Person;
import ca.infodata.dossier.hibernate.PrefProf;
import ca.infodata.dossier.hibernate.PrefProfType;
import ca.infodata.dossier.hibernate.Professionnal;
import ca.infodata.dossier.hibernate.Speciality;
import ca.infodata.dossier.hibernate.StatusInscr;
import ca.infodata.dossier.hibernate.XDisabilityCode;
import ca.infodata.dossier.hibernate.XInscriptionCategory;
import ca.infodata.dossier.hibernate.base.BaseCitizenshipDAO;
import ca.infodata.dossier.hibernate.base.BaseCityDAO;
import ca.infodata.dossier.hibernate.base.BaseDemForListeDAO;
import ca.infodata.dossier.hibernate.base.BasePatientDAO;
import ca.infodata.dossier.hibernate.base.BasePrefProfDAO;
import ca.infodata.dossier.hibernate.base.BaseProfessionnalDAO;
import ca.infodata.dossier.hibernate.base.BaseSpecialityDAO;
import ca.infodata.dossier.hibernate.dao.AppointmentLists;
import ca.infodata.dossier.hibernate.fmedx.Archive_dpacte;
import ca.infodata.dossier.hibernate.fmedx.Groupe;
import ca.infodata.dossier.hibernate.fmedx.base.BaseArchive_dpacteDAO;
import ca.infodata.dossier.hibernate.fmedx.base.BaseGroupeDAO;
import ca.infodata.dossier.hibernate.fmedx.dao.FmedxBaseDAO;
import ca.infodata.dossier.hibernate.login.User;
import ca.infodata.dossier.hibernate.login.base.BaseUserDAO;
import ca.infodata.dossier.hibernate.valid.base.BaseCod_plafDAO;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.dossier.person.ui.PersonUiPlugin;
import ca.infodata.dossier.person.ui.search.ProfessionnalSearchView;
import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICitizenship;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPatient;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ISpeciality;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.StringUtils;
import ca.infodata.syra.models.B2bPatientData;
import ca.infodata.syra.models.B2bSituSant;
import ca.infodata.syra.models.CArchivedBill;
import ca.infodata.syra.models.CDemContainer;
import ca.infodata.syra.models.CDemForListe;
import ca.infodata.syra.models.CDemModif;
import ca.infodata.syra.models.CDemModifRecev;
import ca.infodata.syra.models.CDemPaimt;
import ca.infodata.syra.models.CDemPaimtFactFraisDepl;
import ca.infodata.syra.models.CDemPaimtFactServMdcal;
import ca.infodata.syra.models.CDemPaimtRecev;
import ca.infodata.syra.models.CLigneForfaDepla;
import ca.infodata.syra.models.CLigneFraisSej;
import ca.infodata.syra.models.CLigneFraisTranp;
import ca.infodata.syra.models.CLigneTempsDepla;
import ca.infodata.syra.models.CLigneTypServMdcal;
import ca.infodata.syra.models.CModaPaimt;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.CProfessionnalPrefData;
import ca.infodata.syra.models.CSummaryBill;
import ca.infodata.syra.models.CTypDiagnMdcal;
import ca.infodata.syra.models.CTypLigneFactRecev;
import ca.infodata.syra.models.CUser;
import ca.infodata.syra.models.CodeDesc;
import ca.infodata.syra.models.IDem;
import ca.infodata.syra.models.PatientData;
import ca.infodata.syra.util.ConvertJavaToFromArray;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.TestData;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.web.meddata.ProfessionnalSearchService;
import ca.qc.gouv.ramq.rfp.DemAnnu;
import ca.qc.gouv.ramq.rfp.DemAnnuRecev;
import ca.qc.gouv.ramq.rfp.DemModif;
import ca.qc.gouv.ramq.rfp.DemModifRecev;
import ca.qc.gouv.ramq.rfp.DemPaimt;
import ca.qc.gouv.ramq.rfp.DemPaimtRecev;
import ca.qc.gouv.ramq.rfp.IdFactRamq;
import ca.qc.gouv.ramq.rfp.IdFactRamqRecev;
import ca.qc.gouv.ramq.rfp.TypDem;
import ca.qc.gouv.ramq.rfp.TypDemRecev;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.validator.GenericValidator;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class SyraAccessorClient {
    private static final Logger logger = Logger.getLogger(SyraAccessorClient.class.getName());
    private static SyraAccessorClient accessor;
    private boolean useTestData = false;
    private static final String NO_DEM_EXT = "SYRA_NO_DEM_EXT";
    public static Pattern[] patNAM3to5;
    public Map<Integer, CUser> mapUser = new HashMap<Integer, CUser>();
    private static List<String> strCode;
    public Map<Integer, CProfessionnalPrefData> mapPrefData = new HashMap<Integer, CProfessionnalPrefData>();
    public Map<Integer, CProfessionnal> mapProf = new HashMap<Integer, CProfessionnal>();

    static {
        patNAM3to5 = new Pattern[]{Pattern.compile("[A-Z][A-Z][A-Z]"), Pattern.compile("[A-Z][A-Z][A-Z][A-Z|*]"), Pattern.compile("[A-Z][A-Z][A-Z][A-Z|*][0-9]")};
        strCode = BaseCod_plafDAO.getInstance().findCodPlafByNoEntenAndPlafdiff('1', 'A');
    }

    public static SyraAccessorClient getInstance() {
        if (accessor == null) {
            accessor = new SyraAccessorClient();
        }
        return accessor;
    }

    public CPatient[] findPatients(String k) {
        CPatient[] patients = new CPatient[]{};
        ArrayList lst = new ArrayList();
        lst.addAll(BasePatientDAO.getInstance().findPatientTextBy(false, k, "", "", null, "", null, "", "", 0, null, null, null, 0, 0, null, null));
        patients = new CPatient[lst.size()];
        int i = 0;
        for (AppointmentLists.PatientListText pt : lst) {
            CPatient p = new CPatient();
            p.setHealthInsuranceNumber(pt.getHealthInsuranceNumber());
            p.setPatientRecordNumber(pt.getPatientRecordNumber());
            p.setFirstName(pt.getPt_firstName());
            p.setLastName(pt.getPt_lastName());
            if (pt.getBirthDate() != null) {
                p.bds = LocalDate.fromCalendar((Calendar)pt.getBirthDate()).formatHyphen();
            }
            p.setGender(pt.getGender());
            p.setId(pt.getIdPatient());
            p.setTag(p.getId());
            CPatient.CAdresse adr = new CPatient.CAdresse();
            boolean hasAdr = false;
            if (StringUtils.isNotEmpty((String)pt.getStreet())) {
                adr.setStreet(pt.getStreet());
                hasAdr = true;
            }
            if (StringUtils.isNotEmpty((String)pt.getCityName())) {
                CPatient.CCity city = new CPatient.CCity();
                city.setName(pt.getCityName());
                adr.setCity(city);
                hasAdr = true;
            }
            if (StringUtils.isNotEmpty((String)pt.getPostalCode())) {
                adr.setPostalCode(pt.getPostalCode());
                hasAdr = true;
            }
            if (hasAdr) {
                p.setAdresse(adr);
            }
            if (pt.getIdProfTx() != null) {
                IProfessionnal prof = PersonUiPlugin.getDefault().getIProfessionnalFromIdProf(pt.getIdProfTx());
                String nop = prof.getCode().trim();
                if (prof.getType() < 3 && nop.length() > 6) {
                    nop = nop.substring(0, 6);
                }
                p.setTxProfN(nop);
            }
            p.setAllDisabilityCodes(pt.getPatient().getAllDisabilityCodes());
            p.setIsInscritGMF(pt.getIsInscritGMF());
            p.setCategory(pt.getPatient().getCategory() == null ? new Integer(0) : new Integer(pt.getPatient().getCategory().getValue()));
            System.out.println(p.toString());
            patients[i++] = p;
        }
        return patients;
    }

    public Multimap<String, CPatient> findMapPatients(String k) {
        ArrayListMultimap mapPatients = ArrayListMultimap.create();
        ArrayList lst = new ArrayList();
        lst.addAll(BasePatientDAO.getInstance().findPatientTextBy(false, k, "", "", null, "", null, "", "", 0, null, null, null, 0, 0, null, null));
        boolean i = false;
        for (AppointmentLists.PatientListText pt : lst) {
            CPatient p = new CPatient();
            p.setHealthInsuranceNumber(pt.getHealthInsuranceNumber());
            p.setPatientRecordNumber(pt.getPatientRecordNumber());
            p.setFirstName(pt.getPt_firstName());
            p.setLastName(pt.getPt_lastName());
            if (pt.getBirthDate() != null) {
                p.bds = LocalDate.fromCalendar((Calendar)pt.getBirthDate()).formatHyphen();
            }
            p.setGender(pt.getGender());
            p.setId(pt.getIdPatient());
            p.setTag(p.getId());
            CPatient.CAdresse adr = new CPatient.CAdresse();
            boolean hasAdr = false;
            if (StringUtils.isNotEmpty((String)pt.getStreet())) {
                adr.setStreet(pt.getStreet());
                hasAdr = true;
            }
            if (StringUtils.isNotEmpty((String)pt.getCityName())) {
                CPatient.CCity city = new CPatient.CCity();
                city.setName(pt.getCityName());
                adr.setCity(city);
                hasAdr = true;
            }
            if (StringUtils.isNotEmpty((String)pt.getPostalCode())) {
                adr.setPostalCode(pt.getPostalCode());
                hasAdr = true;
            }
            if (hasAdr) {
                p.setAdresse(adr);
            }
            if (pt.getIdProfTx() != null) {
                IProfessionnal prof = PersonUiPlugin.getDefault().getIProfessionnalFromIdProf(pt.getIdProfTx());
                String nop = prof.getCode().trim();
                if (prof.getType() < 3 && nop.length() > 6) {
                    nop = nop.substring(0, 6);
                }
                p.setTxProfN(nop);
            }
            p.setAllDisabilityCodes(pt.getPatient().getAllDisabilityCodes());
            p.setIsInscritGMF(pt.getIsInscritGMF());
            System.out.println(p.toString());
            mapPatients.put((Object)p.getHealthInsuranceNumber(), (Object)p);
        }
        return mapPatients;
    }

    public Multimap<String, Archive_dpacte> findMapNamFromHistoricFact(String k) {
        Multimap map = BaseArchive_dpacteDAO.getInstance().findFacturation(k);
        return map;
    }

    public Object[] findNamFromHistoricFact(String k) {
        Multimap map = BaseArchive_dpacteDAO.getInstance().findFacturation(k);
        Set keys = map.keySet();
        Object[] patients = new Object[keys.size()];
        int i = 0;
        for (String kk : keys) {
            int j = 0;
            Collection coll = map.get((Object)kk);
            Object[] arcs = new Object[coll.size()];
            for (Archive_dpacte arc : coll) {
                arcs[j] = arc;
                ++j;
            }
            patients[i] = new Object[]{kk, arcs};
            ++i;
        }
        return patients;
    }

    public IProfessionnal getBillingProfFromId(Integer id) {
        return PersonUiPlugin.getDefault().getIProfessionnalFromIdProf(id);
    }

    public List<IProfessionnal> getBillingProfessionnals(String searchString, Integer entente, String spec) {
        ArrayList<IProfessionnal> profs = new ArrayList<IProfessionnal>();
        Collection allProf = BaseProfessionnalDAO.getInstance().findAllTreatingProfessionnals().values();
        String code = null;
        String[] name = null;
        if (StringUtils.isNotBlank((String)searchString)) {
            boolean wantsAll;
            boolean bl = wantsAll = searchString.charAt(0) == '.';
            if (wantsAll) {
                if (entente == null && spec == null) {
                    return new ArrayList<IProfessionnal>(allProf);
                }
                for (IProfessionnal ip : allProf) {
                    if (entente != null && !entente.equals(ip.getTypeProfessionnal()) || spec != null && ip.getSpeciality() != null && !spec.equals(ip.getSpeciality().getCode())) continue;
                    profs.add(ip);
                }
                return profs;
            }
            if (NumberUtils.isDigits((String)searchString)) {
                code = searchString;
            } else {
                name = StringUtils.removeAccent((String)searchString.toLowerCase()).split("[ ,]");
            }
        } else {
            return new ArrayList<IProfessionnal>(allProf);
        }
        for (IProfessionnal ip : allProf) {
            if (entente != null && !entente.equals(ip.getTypeProfessionnal()) || spec != null && ip.getSpeciality() != null && !spec.equals(ip.getSpeciality().getCode())) continue;
            if (code != null) {
                if (!ip.getCode().contains(code)) continue;
                profs.add(ip);
                continue;
            }
            if (name == null || name.length <= 0 || !StringUtils.isNotBlank((String)name[0])) continue;
            int c = 0;
            String[] stringArray = name;
            int n = name.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (StringUtils.removeAccent((String)ip.getLastName().toLowerCase()).contains(n3) || StringUtils.removeAccent((String)ip.getFirstName().toLowerCase()).contains(n3)) {
                    ++c;
                }
                ++n2;
            }
            if (c != name.length) continue;
            profs.add(ip);
        }
        return profs;
    }

    public List<Groupe> getGroups(String searchString) {
        ArrayList<Groupe> groups = new ArrayList<Groupe>();
        List allGroup = BaseGroupeDAO.getInstance().findAll();
        String code = null;
        String[] name = null;
        if (StringUtils.isNotBlank((String)searchString)) {
            boolean wantsAll;
            boolean bl = wantsAll = searchString.charAt(0) == '.';
            if (wantsAll) {
                return allGroup;
            }
            if (NumberUtils.isDigits((String)searchString)) {
                code = searchString;
            } else {
                name = StringUtils.removeAccent((String)searchString.toLowerCase()).split("[ ,]");
            }
        } else {
            return allGroup;
        }
        for (Groupe ip : allGroup) {
            if (code != null) {
                if (!ip.getNumero().contains(code)) continue;
                groups.add(ip);
                continue;
            }
            if (name == null || name.length <= 0 || !StringUtils.isNotBlank((String)name[0])) continue;
            int c = 0;
            String[] stringArray = name;
            int n = name.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                if (StringUtils.removeAccent((String)ip.getDescrip().toLowerCase()).contains(n3) || StringUtils.removeAccent((String)ip.getDescrip().toLowerCase()).contains(n3)) {
                    ++c;
                }
                ++n2;
            }
            if (c != name.length) continue;
            groups.add(ip);
        }
        return groups;
    }

    public List<City> getCities(String searchString) {
        List<Object> cities = new ArrayList<City>();
        if (StringUtils.isNotBlank((String)searchString)) {
            cities = BaseCityDAO.getInstance().findAllByName(searchString);
        }
        return cities;
    }

    public List<IProfessionnal> findProfessionnals(String s, boolean fromWeb) {
        ArrayList<IProfessionnal> profs = new ArrayList<IProfessionnal>();
        if (fromWeb) {
            if (LibPlugin.checkInternetConnection()) {
                ProfessionnalSearchService professionnalSearch = new ProfessionnalSearchService();
                Professionnal professionnal = null;
                Person person = null;
                int i = 0;
                try {
                    ArrayList lst = new ArrayList();
                    List searchProfessionnal = professionnalSearch.searchProfessionnal(DossierHibernatePlugin.getGlobalPreference().getClientCode(), s, ProfessionnalSearchView.Province.QC.getId());
                    if (searchProfessionnal != null) {
                        lst.addAll(searchProfessionnal);
                        i = 0;
                        while (i < lst.size()) {
                            String[] keywords = (String.valueOf((String)lst.get(i)) + "; ").split(";");
                            if (!keywords[0].startsWith("!ERR")) {
                                professionnal = !keywords[0].equals("0000000") ? BaseProfessionnalDAO.getInstance().findByCode(keywords[0]) : null;
                                if (professionnal == null) {
                                    professionnal = new Professionnal();
                                    person = new Person();
                                    person.setCitizenship((ICitizenship)BaseCitizenshipDAO.getInstance().get(new Integer(2)));
                                    professionnal.setPerson((IPerson)person);
                                    professionnal.setCode(keywords[0]);
                                    professionnal.setIsTreatingProfessionnal(new Integer(0));
                                    professionnal.setGestionAppointment(new Integer(0));
                                    professionnal.setType(new Integer(0));
                                    professionnal.setOnCallLocation(new Integer(0));
                                    professionnal.setEncounterHeader("");
                                    person.setLastName(keywords[1]);
                                    person.setFirstName(keywords[2]);
                                    professionnal.setSpeciality((ISpeciality)BaseSpecialityDAO.getInstance().findByCode("00"));
                                    person.setNote(keywords[4]);
                                }
                                profs.add((IProfessionnal)professionnal);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    LibPlugin.log((String)"Erreur", (Exception)e);
                }
            }
        } else {
            try {
                List list = BaseProfessionnalDAO.getInstance().findFromViewInfo(s, false, 0, false);
                for (Professionnal pp : list) {
                    profs.add((IProfessionnal)pp);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "getProfessionnals with " + s, e);
            }
        }
        return profs;
    }

    public CodeDesc[] getProfessionnalTypes() {
        CodeDesc[] types = new CodeDesc[Professionnal.PROFESSIONNAL_TYPE_TEXT.length];
        int j = 0;
        while (j < Professionnal.PROFESSIONNAL_TYPE_TEXT.length) {
            String t = Professionnal.PROFESSIONNAL_TYPE_TEXT[j];
            types[j] = new CodeDesc(String.valueOf(j), t);
            ++j;
        }
        return types;
    }

    public CodeDesc[] getAllSpeciality() {
        List lst = BaseSpecialityDAO.getInstance().findAll();
        CodeDesc[] types = new CodeDesc[lst.size()];
        int j = 0;
        while (j < lst.size()) {
            Speciality spec = (Speciality)lst.get(j);
            types[j] = new CodeDesc(String.valueOf(j), String.valueOf(spec.getCode()) + ": " + spec.getDescription());
            ++j;
        }
        return types;
    }

    public String getNextNoDemExt() {
        return FmedxBaseDAO.getInstance().getNewId(NO_DEM_EXT, 40);
    }

    public CUser getUser(Integer i) {
        return this.mapUser.get(i);
    }

    public List<CUser> getActiveUsers() {
        List users = BaseUserDAO.getInstance().getActiveUsers();
        ArrayList<CUser> lst = new ArrayList<CUser>();
        for (User user : users) {
            CUser u = new CUser(user.getId(), user.getName());
            lst.add(u);
            this.mapUser.put(u.id, u);
        }
        return lst;
    }

    public CUser getActiveUser() {
        User user = DossierHibernatePlugin.getCurrentUser();
        if (user != null) {
            return new CUser(user.getId(), user.getName());
        }
        return null;
    }

    public List<CDemForListe> getDemListe(DemListCriteria criteria) {
        ArrayList<CDemForListe> lstDem;
        block7: {
            block8: {
                block6: {
                    lstDem = new ArrayList<CDemForListe>();
                    if (this.useTestData) {
                        List<CDemForListe> demListe = TestData.getDemListe();
                        return demListe;
                    }
                    if (!Boolean.TRUE.equals(criteria.getCodesFromArch)) break block6;
                    List archivesByCriteria = BaseDemForListeDAO.getInstance().findWithCodesFromArchivesByCriteria(criteria);
                    if (archivesByCriteria == null) break block7;
                    for (Object[] dl : archivesByCriteria) {
                        String[] codes = null;
                        codes = dl[1] != null ? ((String)dl[1]).split(",") : new String[]{};
                        this.getCDemForListeFromDemForListe(lstDem, (DemForListe)dl[0], codes, null);
                    }
                    break block7;
                }
                if (!Boolean.TRUE.equals(criteria.getEtabFromArch)) break block8;
                List archivesByCriteria = BaseDemForListeDAO.getInstance().findWithEtabFromArchivesByCriteria(criteria);
                if (archivesByCriteria == null) break block7;
                for (Object[] dl : archivesByCriteria) {
                    String[] codes = null;
                    String etab = null;
                    codes = dl[1] != null ? ((String)dl[1]).split(",") : new String[]{};
                    if (dl.length > 2 && dl[2] != null) {
                        etab = (String)dl[2];
                    }
                    this.getCDemForListeFromDemForListe(lstDem, (DemForListe)dl[0], codes, etab);
                }
                break block7;
            }
            List demLst = BaseDemForListeDAO.getInstance().findByCriteria(criteria);
            if (demLst != null) {
                for (DemForListe dl : demLst) {
                    this.getCDemForListeFromDemForListe(lstDem, dl, null, null);
                }
            }
        }
        return lstDem;
    }

    public void getCDemForListeFromDemForListe(List<CDemForListe> lstDem, DemForListe dl, String[] codes, String etab) {
        String created = null;
        String modified = null;
        long maxDt = 0L;
        if (dl.getCreatedDateTime() != null) {
            maxDt = dl.getCreatedDateTime();
            created = DateUtil.format((Long)dl.getCreatedDateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (dl.getModifiedDateTime() != null) {
            long modifDt = dl.getModifiedDateTime();
            if (modifDt > maxDt) {
                maxDt = modifDt;
            }
            modified = DateUtil.format((Long)dl.getModifiedDateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        }
        CDemForListe cdl = new CDemForListe(dl.getId(), CDemContainer.getTagInteger(), dl.getIdUser(), created, modified);
        if (maxDt != 0L) {
            cdl.setDate(DateUtil.format((Long)new Long(maxDt), (String)"yyyy-MM-dd"));
        }
        cdl.setIdProf(dl.getProfessionnal().getId());
        cdl.setIdPatients(dl.getIdPatients());
        cdl.setPatientStrings(dl.getPatientStrings());
        cdl.setMntPrel(dl.getHonTotaux());
        cdl.setIdIntvn(dl.getIdIntvn());
        cdl.setIdUser(dl.getIdUser());
        cdl.setManualMode(dl.getManualMode());
        cdl.setProgressCommunication(dl.getProgressComm());
        cdl.setErrMessage(dl.getErrMessage());
        cdl.setNotePers(dl.getNotePers());
        cdl.setNoExt(dl.getNoExt());
        cdl.setNoRfp(dl.getNoRfp());
        cdl.setIsDeleted(dl.getIsDeleted());
        if (dl.getMntPmt() != null) {
            cdl.setMntPaye(new Double(dl.getMntPmt().doubleValue()));
        }
        cdl.setStatPmt(dl.statPmtInt);
        if (dl.getPatientStrings() != null && dl.getPatientStrings().length > 0) {
            cdl.setPatient(new JoinList("; ", Arrays.asList(dl.getPatientStrings())).toString());
        } else {
            cdl.setPatient("\u00f8");
        }
        cdl.setReady(dl.getReady());
        cdl.setStaRecev(dl.getStaRecev());
        cdl.setDem(dl.getDemPaimt(), dl.getDemModif(), dl.getDemAnnu());
        cdl.setRec(dl.getDemPaimtRecev(), dl.getDemModifRecev(), dl.getDemAnnuRecev());
        cdl.setDemType(dl.getDemType());
        cdl.setCodesFromArch(codes);
        cdl.setEtab(etab);
        lstDem.add(cdl);
    }

    public String getLastDiagnostic(String nam) {
        return BasePatientDAO.getInstance().getLastDiagnostic(nam);
    }

    public int isMedecinFamille(Professionnal medecin, String nam) {
        if (nam.length() != 12) {
            return 0;
        }
        return BasePatientDAO.getInstance().isMedecinFamille(medecin, nam, null);
    }

    public Calendar getLastDateAccident(String nam) {
        return BasePatientDAO.getInstance().getLastDateAccident(nam);
    }

    public Calendar getLastDateAdmission(String nam) {
        return BasePatientDAO.getInstance().getLastDateAdmission(nam);
    }

    public CArchivedBill[] getHistoricFacturation(String nam, String dossier) {
        CArchivedBill[] historic = new CArchivedBill[]{};
        if (!GenericValidator.isBlankOrNull((String)nam) || !GenericValidator.isBlankOrNull((String)dossier)) {
            List lstFacturation = BaseArchive_dpacteDAO.getInstance().findFacturation(nam, dossier);
            historic = new CArchivedBill[lstFacturation.size()];
            int i = 0;
            while (i < lstFacturation.size()) {
                CArchivedBill bill;
                Object[] oFact = (Object[])lstFacturation.get(i);
                Archive_dpacte fact = (Archive_dpacte)oFact[0];
                String dx = null;
                if (fact.getAr_codedx() != null) {
                    dx = new JoinList(", ", fact.getAr_codedx()).toString();
                }
                historic[i] = bill = new CArchivedBill(DateUtil.dtoc((Calendar)fact.getAr_date()), fact.getAr_md(), fact.getAr_code() == null ? "" : fact.getAr_code().toString(), dx, fact.getAr_cdetabl(), fact.getNoRfp(), fact.getDateEve() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEve()), fact.getDateEntree() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEntree()), fact.getTypEve(), null, null, null, null, null);
                ++i;
            }
        }
        return historic;
    }

    public CArchivedBill[] getLastDateEntreeFromHistoricFacturation(int[] hashCode) {
        CArchivedBill[] historic = new CArchivedBill[]{};
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(hashCode);
        historic = new CArchivedBill[lstFacturation.size()];
        int i = 0;
        while (i < lstFacturation.size()) {
            CArchivedBill bill;
            Archive_dpacte fact = (Archive_dpacte)lstFacturation.get(i);
            String dx = null;
            if (fact.getAr_codedx() != null) {
                dx = new JoinList(", ", fact.getAr_codedx()).toString();
            }
            historic[i] = bill = new CArchivedBill(DateUtil.dtoc((Calendar)fact.getAr_date()), fact.getAr_md(), fact.getAr_code() == null ? "" : fact.getAr_code().toString(), dx, fact.getAr_cdetabl(), fact.getNoRfp(), fact.getDateEve() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEve()), fact.getDateEntree() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEntree()), fact.getTypEve(), null, null, null, null, null);
            ++i;
        }
        return historic;
    }

    public String getLastDateEntree(int[] hashCode, String noEtab) {
        return BaseArchive_dpacteDAO.getInstance().findLastDateEntree(hashCode, noEtab);
    }

    public CArchivedBill[] getHistoricFacturation(int[] hashCode) {
        CArchivedBill[] historic = new CArchivedBill[]{};
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(hashCode);
        historic = new CArchivedBill[lstFacturation.size()];
        int i = 0;
        while (i < lstFacturation.size()) {
            CArchivedBill bill;
            Archive_dpacte fact = (Archive_dpacte)lstFacturation.get(i);
            String dx = null;
            if (fact.getAr_codedx() != null) {
                dx = new JoinList(", ", fact.getAr_codedx()).toString();
            }
            historic[i] = bill = new CArchivedBill(DateUtil.dtoc((Calendar)fact.getAr_date()), fact.getAr_md(), fact.getAr_code() == null ? "" : fact.getAr_code().toString(), dx, fact.getAr_cdetabl(), fact.getNoRfp(), fact.getDateEve() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEve()), fact.getDateEntree() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEntree()), fact.getTypEve(), null, null, null, null, null);
            ++i;
        }
        return historic;
    }

    public CArchivedBill[] getPlafFacturation(int[] hashCode, Set<String> setCodePlaf) {
        CArchivedBill[] historic = new CArchivedBill[]{};
        LocalDate fromDate = LocalDate.today().plusYear(-1);
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(hashCode, fromDate, setCodePlaf);
        historic = new CArchivedBill[lstFacturation.size()];
        int i = 0;
        while (i < lstFacturation.size()) {
            CArchivedBill bill;
            Archive_dpacte fact = (Archive_dpacte)lstFacturation.get(i);
            String dx = null;
            if (fact.getAr_codedx() != null) {
                dx = new JoinList(", ", fact.getAr_codedx()).toString();
            }
            historic[i] = bill = new CArchivedBill(DateUtil.dtoc((Calendar)fact.getAr_date()), fact.getAr_md(), fact.getAr_code() == null ? "" : fact.getAr_code().toString(), dx, fact.getAr_cdetabl(), fact.getNoRfp(), fact.getDateEve() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEve()), fact.getDateEntree() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEntree()), fact.getTypEve(), null, null, null, null, null);
            ++i;
        }
        return historic;
    }

    public CArchivedBill[] getArchiveFacturationFromFactCreationDate(String deb, String fin, boolean andModified) {
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturationFromFactCreationDate(deb, fin, andModified);
        ArrayList<String> nams = new ArrayList<String>();
        for (Archive_dpacte arc : lstFacturation) {
            if (!StringUtils.isNotEmpty((String)arc.getAr_nam())) continue;
            nams.add(arc.getAr_nam());
        }
        CArchivedBill[] historic = this.setInscrVulnToArchive(lstFacturation, nams);
        return historic;
    }

    public CArchivedBill[] getArchiveFacturation(String deb, String fin) {
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(deb, fin);
        ArrayList<String> nams = new ArrayList<String>();
        for (Archive_dpacte arc : lstFacturation) {
            if (!StringUtils.isNotEmpty((String)arc.getAr_nam())) continue;
            nams.add(arc.getAr_nam());
        }
        CArchivedBill[] historic = this.setInscrVulnToArchive(lstFacturation, nams);
        return historic;
    }

    public CSummaryBill[] getSummarayFromArchiveFacturation(List<Long> lstNoRfp) {
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturation(lstNoRfp);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        CSummaryBill[] sbs = new CSummaryBill[lstFacturation.size()];
        int i = 0;
        for (Object[] o : lstFacturation) {
            String nomd = ((String)o[0]).trim();
            if (o[3] != null && o[3] instanceof String && ((String)o[3]).trim().length() > 0 && Integer.valueOf(((String)o[3]).trim()) > 0) {
                nomd = String.valueOf(nomd) + "-" + ((String)o[3]).toString();
            }
            Integer nb_serv = null;
            if (o[4] != null && o[4] instanceof BigInteger) {
                nb_serv = ((BigInteger)o[4]).intValue();
            }
            Double mt_prl = null;
            if (o[5] != null && o[5] instanceof BigDecimal) {
                mt_prl = ((BigDecimal)o[5]).doubleValue();
            }
            CSummaryBill sb = new CSummaryBill(nomd, (String)o[6], (String)o[1], sdf1.format((Date)o[2]), nb_serv, mt_prl);
            sbs[i++] = sb;
        }
        return sbs;
    }

    public CArchivedBill[] getArchiveFacturationGroupByNam(String deb, String fin) {
        List lstFacturation = BaseArchive_dpacteDAO.getInstance().findArchiveFacturationGroupByNam(deb, fin);
        ArrayList<String> nams = new ArrayList<String>();
        for (Archive_dpacte arc : lstFacturation) {
            if (!StringUtils.isNotEmpty((String)arc.getAr_nam())) continue;
            nams.add(arc.getAr_nam());
        }
        CArchivedBill[] historic = this.setInscrVulnToArchive(lstFacturation, nams);
        return historic;
    }

    private CArchivedBill[] setInscrVulnToArchive(List<Archive_dpacte> lstFacturation, List<String> nams) {
        Map inscrByNam = BasePatientDAO.getInstance().findStatusInscrByHealthInsuranceNumber(nams);
        CArchivedBill[] historic = new CArchivedBill[lstFacturation.size()];
        int i = 0;
        while (i < lstFacturation.size()) {
            CArchivedBill bill;
            Archive_dpacte fact = lstFacturation.get(i);
            String dx = null;
            if (fact.getAr_codedx() != null) {
                dx = new JoinList(", ", fact.getAr_codedx()).toString();
            }
            StatusInscr si = (StatusInscr)inscrByNam.get(fact.getAr_nam());
            Integer inscr = new Integer(0);
            Integer vuln = new Integer(0);
            String inscrVuln = CArchivedBill.IV.NI.text;
            if (si != null && si.insc == 1) {
                vuln = si.vuln;
                if (si.noPr != null && si.noPr.length() > 5 && fact.getAr_md() != null && fact.getAr_md().length() > 5) {
                    if (fact.getAr_md().startsWith(si.noPr.substring(0, 6))) {
                        inscr = new Integer(1);
                        inscrVuln = vuln == 0 ? CArchivedBill.IV.MD_INSCR_NON_VULN.text : CArchivedBill.IV.MD_INSCR_VULN.text;
                    } else {
                        inscr = new Integer(2);
                        inscrVuln = vuln == 0 ? CArchivedBill.IV.INSCR_NON_VULN.text : CArchivedBill.IV.INSCR_VULN.text;
                    }
                } else {
                    inscrVuln = vuln == 0 ? CArchivedBill.IV.INSCR_NON_VULN.text : CArchivedBill.IV.INSCR_VULN.text;
                }
            }
            historic[i] = bill = new CArchivedBill(DateUtil.dtoc((Calendar)fact.getAr_date()), fact.getAr_md(), fact.getCodes() == null ? (fact.getAr_code() == null ? "" : fact.getAr_code().toString()) : fact.getCodes(), dx, fact.getAr_cdetabl(), fact.getNoRfp(), fact.getDateEve() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEve()), fact.getDateEntree() == null ? null : DateUtil.dtoc((Calendar)fact.getDateEntree()), fact.getTypEve(), inscr, vuln, inscrVuln, fact.getAr_nam(), fact.getAr_hon());
            ++i;
        }
        return historic;
    }

    public Object[][] getRepondant(CPatient pt) {
        Integer hashCode = new Integer(CPatient.getStringToHashCode(pt.getStringForHash(1)));
        Object[][] s = BaseArchive_dpacteDAO.getInstance().getRepondant(hashCode);
        return s;
    }

    public CProfessionnalPrefData getPrefData(Integer idAnchorProf) {
        if (this.mapPrefData.isEmpty()) {
            for (Integer id : this.mapProf.keySet()) {
                this.addPrefDataForThisId(id);
            }
        }
        if (!this.mapPrefData.keySet().contains(idAnchorProf)) {
            this.addPrefDataForThisId(idAnchorProf);
        }
        return this.mapPrefData.get(idAnchorProf);
    }

    private void addPrefDataForThisId(Integer id) {
        HashMap<PrefProfType, PrefProf> prefProf = BaseProfessionnalDAO.getInstance().getPrefProf(id);
        if (prefProf == null) {
            prefProf = new HashMap<PrefProfType, PrefProf>();
        }
        CProfessionnalPrefData pd = new CProfessionnalPrefData(id);
        PrefProfType[] prefProfTypeArray = PrefProfType.values();
        int n = prefProfTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrefProfType ppt = prefProfTypeArray[n2];
            PrefProf prof = (PrefProf)prefProf.get(ppt);
            if (prefProf.containsKey(ppt)) {
                prof = (PrefProf)prefProf.get(ppt);
            } else {
                prof = new PrefProf();
                prof.setIdProf(id);
                prof.setTypePref(ppt);
                prefProf.put(ppt, prof);
            }
            if (PrefProfType.DX.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefDiag", "setIdDx");
            } else if (PrefProfType.CODES.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefFact", "setIdCode");
            } else if (PrefProfType.CX.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefElmContx", "setIdCx");
            } else if (PrefProfType.LOCAL.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefLocal", "setIdLocal");
            } else if (PrefProfType.ETAB.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefEtabl", "setIdEtab");
            } else if (PrefProfType.SECT.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "addPrefSectActiv", "setIdSect");
            } else if (PrefProfType.AUTRES.equals((Object)ppt)) {
                this.addProfPrefToData(pd, prof, "setPrefAutreValue", "setIdAutre");
            }
            ++n2;
        }
        this.mapPrefData.put(id, pd);
    }

    public void addProfPrefToData(CProfessionnalPrefData pd, PrefProf prof, String methodName, String setIdMethodName) {
        Class[] parameterTypes = new Class[]{"setPrefAutreValue".equals(methodName) ? String.class : Character.class, String.class};
        Class[] idParTypes = new Class[]{Integer.class};
        try {
            Method addMethod = CProfessionnalPrefData.class.getMethod(methodName, parameterTypes);
            Object[] parameters = new Object[2];
            String[] prefs = prof.getPrefs();
            if (prefs != null) {
                String[] stringArray = prefs;
                int n = prefs.length;
                int n2 = 0;
                while (n2 < n) {
                    String favs = stringArray[n2];
                    String[] fav = favs.split("~");
                    String letter = fav[0];
                    int i = 1;
                    while (i < fav.length) {
                        String f = fav[i];
                        parameters[0] = "setPrefAutreValue".equals(methodName) ? letter : Character.valueOf(letter.charAt(0));
                        parameters[1] = f;
                        addMethod.invoke((Object)pd, parameters);
                        ++i;
                    }
                    ++n2;
                }
            }
            Method addMethodId = CProfessionnalPrefData.class.getMethod(setIdMethodName, idParTypes);
            Object[] paramId = new Object[]{prof.getId()};
            addMethodId.invoke((Object)pd, paramId);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void findXDate_async(JobCallback callback, LocalDate start, LocalDate end, ArrayList<Integer> arrayList) {
    }

    public void getCompleteData_sync(Callback callback, LocalDate startDate, LocalDate endDate, List<Integer> asList) {
    }

    public IPatient savePatient(CPatient pat) {
        if (pat.bds != null && pat.getBirthDate() == null) {
            pat.bds = pat.bds.substring(0, 10);
            pat.setBirthDate(DateUtil.ctod((String)pat.bds));
        }
        Patient pt = BasePatientDAO.getInstance().fromOtherPatientData((IPatient)pat);
        boolean modified = false;
        if (pat.bds != null) {
            if (pt.getPerson().getBirthDate() == null) {
                pat.setBirthDate(DateUtil.ctod((String)pat.bds));
                pt.getPerson().setBirthDate(pat.getBirthDate());
                modified = true;
            } else {
                String bds = DateUtil.dtoc((Calendar)pt.getPerson().getBirthDate());
                if (!bds.equals(pat.bds)) {
                    pat.setBirthDate(DateUtil.ctod((String)pat.bds));
                    pt.getPerson().setBirthDate(pat.getBirthDate());
                    modified = true;
                }
            }
            if (modified) {
                pt.getPerson().save();
            }
        }
        return pt;
    }

    public MultiStatus savePatientData(PatientData patData, CPatient cPt) {
        MultiStatus status = new MultiStatus();
        try {
            Patient patient = BasePatientDAO.getInstance().get(cPt.getId());
            if (patient.getNaissanceOrder() == null) {
                patient.setNaissanceOrder(new Integer(1));
            }
            if (patData.getRepresentant() != null && patData.getRepresentant().getId() != null) {
                patient.setPatientRepresentantType(patData.getRepresentantType());
                patient.setPatientRepresentant(BasePatientDAO.getInstance().get(patData.getRepresentant().getId()));
            } else {
                patient.setPatientRepresentant(null);
                patient.setPatientRepresentantType(new Integer(0));
            }
            if (patData.resident != null && patData.resident.getId() != null) {
                patient.setResident(BaseProfessionnalDAO.getInstance().get(patData.resident.getId()));
            } else {
                patient.setResident(null);
            }
            B2bPatientData data = patData.getB2bPatientData();
            if (data != null) {
                patient.setIsInscritGMF(data.getStatus());
                patient.setCategory(XInscriptionCategory.from((Integer)data.getCategory()));
                patient.setDateInscriptionCalendar(DateUtil.ctod((String)data.getDateDebutInscr()));
                patient.setDateFinInscriptionCalendar(DateUtil.ctod((String)data.getDateFinInscr()));
                patient.setCodeRaisonStatut(data.getEndReason());
                String lieuSuiv = "";
                if (data.getLieuSuiv() != null) {
                    if ("N".equals(data.getLieuSuiv().typLocEtab)) {
                        if (data.getLieuSuiv().local != null && data.getLieuSuiv().local.valCodLocal != null && StringUtils.isNotEmpty((String)data.getLieuSuiv().local.valCodLocal.getCodLocal())) {
                            lieuSuiv = String.valueOf(data.getLieuSuiv().typLocEtab) + "~" + data.getLieuSuiv().local.typIdLieuGeo + "~" + data.getLieuSuiv().local.valCodLocal.getCodLocal();
                        }
                    } else if ("C".equals(data.getLieuSuiv().typLocEtab) && data.getLieuSuiv().etab != null && StringUtils.isNotEmpty((String)data.getLieuSuiv().etab.noSelectedEtab)) {
                        lieuSuiv = String.valueOf(data.getLieuSuiv().typLocEtab) + "~" + data.getLieuSuiv().etab.noSelectedEtab;
                    }
                }
                patient.setLieuSuivi(lieuSuiv);
                patient.setFollowUpLocationDateCalendar(DateUtil.ctod((String)data.getFollUpLocatationDate()));
                List<B2bSituSant> situSant = data.getSituSant();
                if (situSant != null && situSant.size() == 3) {
                    B2bSituSant vul1 = situSant.get(0);
                    B2bSituSant vul2 = situSant.get(1);
                    B2bSituSant vul3 = situSant.get(2);
                    patient.setDisabilityCode1(XDisabilityCode.fromCode((String)vul1.c));
                    patient.setDisabilityDate(DateUtil.ctod((String)vul1.dd));
                    patient.setDisabilityCode2(XDisabilityCode.fromCode((String)vul2.c));
                    patient.setDisabilityDate2Calendar(DateUtil.ctod((String)vul2.dd));
                    patient.setDisabilityCode3(XDisabilityCode.fromCode((String)vul3.c));
                    patient.setDisabilityDate3Calendar(DateUtil.ctod((String)vul3.dd));
                }
            }
            status = patient.save();
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur lors de la sauvegarde du patient " + e.getMessage()));
        }
        MultiStatus status2 = status.isOK() ? new MultiStatus(IStatus.Severity.OK) : new MultiStatus(status.getSeverity(), status.getMessage(), null);
        return status2;
    }

    public Integer savePref(Integer idAnchorProf) {
        int rep = 0;
        if (idAnchorProf == null) {
            int i = 0;
            for (Integer id : this.mapPrefData.keySet()) {
                i = this.savePrefProfFromPrefData(this.getPrefData(id));
                if (rep == 2 || rep == 1) continue;
                rep = i;
            }
        } else {
            rep = this.savePrefProfFromPrefData(this.getPrefData(idAnchorProf));
        }
        return new Integer(rep);
    }

    private int savePrefProfFromPrefData(CProfessionnalPrefData pd) {
        int dirties = 0;
        int cleaned = 0;
        if (pd != null) {
            PrefProfType[] prefProfTypeArray = PrefProfType.values();
            int n = prefProfTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PrefProfType ppt = prefProfTypeArray[n2];
                if (PrefProfType.DX.equals((Object)ppt)) {
                    if (pd.isDirtyDx()) {
                        ++dirties;
                        pd.setDirtyDx(this.savePrefProf(pd, ppt, pd.prefDiag, "getIdDx", "setIdDx"));
                        if (!pd.isDirtyDx()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.CODES.equals((Object)ppt)) {
                    if (pd.isDirtyCode()) {
                        ++dirties;
                        pd.setDirtyCode(this.savePrefProf(pd, ppt, pd.prefFact, "getIdCode", "setIdCode"));
                        if (!pd.isDirtyCode()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.CX.equals((Object)ppt)) {
                    if (pd.isDirtyCx()) {
                        ++dirties;
                        pd.setDirtyCx(this.savePrefProf(pd, ppt, pd.prefElmContx, "getIdCx", "setIdCx"));
                        if (!pd.isDirtyCx()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.LOCAL.equals((Object)ppt)) {
                    if (pd.isDirtyLocal()) {
                        ++dirties;
                        pd.setDirtyLocal(this.savePrefProf(pd, ppt, pd.prefLocal, "getIdLocal", "setIdLocal"));
                        if (!pd.isDirtyLocal()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.ETAB.equals((Object)ppt)) {
                    if (pd.isDirtyEtab()) {
                        ++dirties;
                        pd.setDirtyEtab(this.savePrefProf(pd, ppt, pd.prefEtabl, "getIdEtab", "setIdEtab"));
                        if (!pd.isDirtyEtab()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.SECT.equals((Object)ppt)) {
                    if (pd.isDirtySect()) {
                        ++dirties;
                        pd.setDirtySect(this.savePrefProf(pd, ppt, pd.prefSectActiv, "getIdSect", "setIdSect"));
                        if (!pd.isDirtySect()) {
                            ++cleaned;
                        }
                    }
                } else if (PrefProfType.AUTRES.equals((Object)ppt) && pd.isDirtyAutre()) {
                    ++dirties;
                    pd.setDirtyAutre(this.savePrefProfAutre(pd, ppt, pd.prefAutre, "getIdAutre", "setIdAutre"));
                    if (!pd.isDirtyAutre()) {
                        ++cleaned;
                    }
                }
                ++n2;
            }
        }
        return dirties > 0 ? (dirties == cleaned ? 1 : 2) : 0;
    }

    private boolean savePrefProf(CProfessionnalPrefData pd, PrefProfType t, SetMultimap<Character, String> pref, String getIdMethod, String setIdMethod) {
        boolean stillDirty = true;
        Set keys = pref.keys().elementSet();
        String[] prefs = new String[keys.size()];
        Integer id = null;
        int i = 0;
        for (Character ch : keys) {
            Set values = pref.get((Object)ch);
            try {
                Class[] idParTypes = new Class[]{};
                Method getMethodId = CProfessionnalPrefData.class.getMethod(getIdMethod, idParTypes);
                Object[] paramId = new Object[]{};
                id = (Integer)getMethodId.invoke((Object)pd, paramId);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            prefs[i++] = String.valueOf(ch.toString()) + "~" + new JoinList("~", values).toString();
        }
        PrefProf prefProf = new PrefProf(id);
        prefProf.setIdProf(pd.getIdProf());
        prefProf.setPrefs(prefs);
        prefProf.setTypePref(t);
        prefProf.setPrefName(t.name());
        PrefProf actualPrefProf = BasePrefProfDAO.getInstance().findByProfIdTypeId(prefProf.getTypePref(), prefProf.getIdProf());
        if (actualPrefProf != null) {
            actualPrefProf.setPrefs(prefProf.getPrefs());
            BasePrefProfDAO.getInstance().update(actualPrefProf);
        } else {
            prefProf.setNew();
            BasePrefProfDAO.getInstance().save(prefProf);
        }
        try {
            Class[] idParTypes = new Class[]{Integer.class};
            Method setId = CProfessionnalPrefData.class.getMethod(setIdMethod, idParTypes);
            Object[] paramId = new Object[]{prefProf.getId()};
            setId.invoke((Object)pd, paramId);
            stillDirty = false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return stillDirty;
    }

    private boolean savePrefProfAutre(CProfessionnalPrefData pd, PrefProfType t, Map<String, String> pref, String getIdMethod, String setIdMethod) {
        boolean stillDirty = true;
        Set<String> keys = pref.keySet();
        String[] prefs = new String[keys.size()];
        Integer id = null;
        int i = 0;
        for (String ch : keys) {
            String values = pref.get(ch);
            try {
                Class[] idParTypes = new Class[]{};
                Method getMethodId = CProfessionnalPrefData.class.getMethod(getIdMethod, idParTypes);
                Object[] paramId = new Object[]{};
                id = (Integer)getMethodId.invoke((Object)pd, paramId);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            prefs[i++] = String.valueOf(ch.toString()) + "~" + values;
        }
        PrefProf prefProf = new PrefProf(id);
        prefProf.setIdProf(pd.getIdProf());
        prefProf.setPrefs(prefs);
        prefProf.setTypePref(t);
        prefProf.setPrefName(t.name());
        BasePrefProfDAO.getInstance().saveOrUpdate(prefProf);
        try {
            Class[] idParTypes = new Class[]{Integer.class};
            Method setId = CProfessionnalPrefData.class.getMethod(setIdMethod, idParTypes);
            Object[] paramId = new Object[]{prefProf.getId()};
            setId.invoke((Object)pd, paramId);
            stillDirty = false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return stillDirty;
    }

    public CProfessionnal getCProfessionnals(Integer idAnchorProf) {
        if (this.mapProf.containsKey(idAnchorProf)) {
            return this.mapProf.get(idAnchorProf);
        }
        return null;
    }

    public void restoreBill(Integer b) {
        BaseDemForListeDAO.getInstance().setDeleted(b, new Integer(0));
    }

    public void deleteBill(Integer b) {
        BaseDemForListeDAO.getInstance().setDeleted(b, new Integer(1));
    }

    public IProfessionnal saveProfessionnal(CProfessionnal prof) {
        Professionnal findByCode = BaseProfessionnalDAO.getInstance().findByCode(prof.getNoProf());
        if (findByCode == null) {
            Professionnal p = new Professionnal();
            p.setCode(prof.getNoProf());
            p.setIsTreatingProfessionnal(prof.getIsProfTx());
            p.setGestionAppointment(new Integer(0));
            p.setType(prof.getType());
            p.setOnCallLocation(new Integer(0));
            p.setEncounterHeader("");
            String spec = prof.getCodSpec();
            if (StringUtils.isEmpty((String)spec)) {
                spec = "00";
            }
            Speciality speciality = BaseSpecialityDAO.getInstance().findByCode(spec);
            p.setSpeciality((ISpeciality)speciality);
            Person person = new Person();
            person.setCitizenship((ICitizenship)BaseCitizenshipDAO.getInstance().get(new Integer(2)));
            person.setLastName(prof.getLastName());
            person.setFirstName(prof.getFirstName());
            p.setPerson((IPerson)person);
            ((Person)p.getPerson()).save();
            p.save();
            return p;
        }
        return findByCode;
    }

    public void deleteArchiveDp(DemPaimt dp, CDemForListe dfl) {
        DemAnnuRecev recev = dfl.getDemAnnuRecev(dfl.iLastDemAnnu);
        ArrayList<Long> lstNoFactRamq = new ArrayList<Long>();
        if (recev != null && recev.getListeFactRecev() != null) {
            List<DemAnnuRecev.ListeFactRecev.FactRecev> factRecev = recev.getListeFactRecev().getFactRecev();
            for (DemAnnuRecev.ListeFactRecev.FactRecev fr : factRecev) {
                IdFactRamqRecev idfr = fr.getIdFactRamqRecev();
                if (idfr == null || idfr.getNoFactRamq() == null) continue;
                lstNoFactRamq.add(new Long(idfr.getNoFactRamq().longValue()));
            }
        }
        if (!lstNoFactRamq.isEmpty()) {
            BaseArchive_dpacteDAO.getInstance().deletePrev(lstNoFactRamq);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal archiveDp(TypDem td, CDemForListe dfl, DemPaimt lastDemPaimt) {
        BigDecimal total;
        block55: {
            BigDecimal mntPrel;
            CTypLigneFactRecev ligneFactRecev;
            HashMap<String, CTypLigneFactRecev> mapLineRec;
            CDemPaimtFactFraisDepl depl;
            String group;
            String noProf;
            String etabl;
            Long noFactRamq;
            Integer idDp;
            String hreDebut;
            String contx;
            Integer code;
            Calendar date;
            String[] dx;
            block56: {
                TypDemRecev paimtRecev;
                IDem cDemPaimt;
                TypDem dp;
                total = new BigDecimal(0);
                IDem idem = null;
                String noCpteAdmin = null;
                if (td instanceof DemPaimt) {
                    dp = (DemPaimt)td;
                    idem = new CDemPaimt((DemPaimt)dp, null, false, true);
                } else if (td instanceof DemModif) {
                    dp = (DemModif)td;
                    CModaPaimt cModaPaimt = new CModaPaimt(lastDemPaimt.getModaPaimt(), false);
                    noCpteAdmin = cModaPaimt.no == null ? null : StringUtils.padLeft((String)cModaPaimt.no.toString(), (int)5, (char)'0');
                    idem = new CDemModif((DemModif)dp, null, false, true);
                } else if (td instanceof DemAnnu) {
                    DemAnnu da = (DemAnnu)td;
                    ArrayList<Long> lstNoFactRamq = new ArrayList<Long>();
                    if (da.getListeFactAAnnu() != null && da.getListeFactAAnnu().getIdFactRamq() != null) {
                        for (IdFactRamq idf : da.getListeFactAAnnu().getIdFactRamq()) {
                            Long noFactRamq2;
                            Long l = noFactRamq2 = idf.getNoFactRamq() == null ? null : new Long(idf.getNoFactRamq().longValue());
                            if (noFactRamq2 == null) continue;
                            lstNoFactRamq.add(noFactRamq2);
                        }
                    }
                    if (!lstNoFactRamq.isEmpty()) {
                        BaseArchive_dpacteDAO.getInstance().deletePrev(lstNoFactRamq);
                    }
                }
                if (idem == null) break block55;
                dx = null;
                date = null;
                code = null;
                contx = null;
                hreDebut = null;
                idDp = null;
                noFactRamq = null;
                etabl = null;
                noProf = null;
                group = noCpteAdmin;
                CDemPaimtFactServMdcal serv = null;
                depl = null;
                if (idem.serv != null && idem.serv.prof != null) {
                    serv = idem.serv;
                    noProf = serv.prof.getNoProf();
                    if (group == null && idem instanceof CDemPaimt) {
                        cDemPaimt = idem;
                        String string = group = cDemPaimt.cModaPaimt == null || cDemPaimt.cModaPaimt.no == null || cDemPaimt.cModaPaimt.no == 0 ? "" : StringUtils.padLeft((String)String.valueOf(cDemPaimt.cModaPaimt.no), (int)5, (char)'0');
                    }
                    if (serv.lieu.typLocEtab.equals("C")) {
                        etabl = serv.lieu.etab.noSelectedEtab;
                    } else if (serv.lieu.typLocEtab.equals("N")) {
                        etabl = serv.lieu.local.valCodLocal.getCodLocal();
                    }
                } else if (idem.depl != null && idem.depl.prof != null) {
                    depl = idem.depl;
                    noProf = depl.prof.getNoProf();
                    if (group == null && idem instanceof CDemPaimt) {
                        cDemPaimt = idem;
                        String string = group = cDemPaimt.cModaPaimt == null || cDemPaimt.cModaPaimt.no == null || cDemPaimt.cModaPaimt.no == 0 ? "" : StringUtils.padLeft((String)String.valueOf(cDemPaimt.cModaPaimt.no), (int)5, (char)'0');
                    }
                    if (depl.lieuArr.typLocEtab.equals("C")) {
                        etabl = depl.lieuArr.etab.noSelectedEtab;
                    } else if (depl.lieuArr.typLocEtab.equals("N")) {
                        etabl = depl.lieuArr.local.valCodLocal.getCodLocal();
                    }
                }
                idDp = dfl.getId();
                mapLineRec = new HashMap<String, CTypLigneFactRecev>();
                ArrayList<Long> lstNoFactRamq = new ArrayList<Long>();
                if (idem instanceof CDemPaimt) {
                    IDem cDemPaimt2 = idem;
                    paimtRecev = dfl.getDemPaimtRecev(dfl.iLastDemPaimt);
                    if (paimtRecev != null) {
                        cDemPaimt2.recev = new CDemPaimtRecev((DemPaimtRecev)paimtRecev);
                        for (CDemPaimtRecev.CFactRecev cFactRecev : cDemPaimt2.recev.listeFactRecev) {
                            if ((cFactRecev.staRecev & 1) != 1) continue;
                            Long l = noFactRamq = cFactRecev.idFactRamqRecev == null ? null : new Long(cFactRecev.idFactRamqRecev.noFactRamq.longValue());
                            if (noFactRamq != null) {
                                lstNoFactRamq.add(noFactRamq);
                            }
                            for (CTypLigneFactRecev cTypLigneFactRecev : cFactRecev.listeLigneFactRecev) {
                                if (cTypLigneFactRecev.staRecev == null || cTypLigneFactRecev.staRecev.intValue() != 1) continue;
                                mapLineRec.put(cTypLigneFactRecev.noLigneFact, cTypLigneFactRecev);
                            }
                        }
                    }
                } else if (idem instanceof CDemModif) {
                    CDemModif CDemModif2 = (CDemModif)idem;
                    paimtRecev = dfl.getDemModifRecev(dfl.iLastDemModif);
                    if (paimtRecev != null) {
                        CDemModif2.recev = new CDemModifRecev((DemModifRecev)paimtRecev);
                        if (CDemModif2.recev.factRecev != null) {
                            CDemModifRecev.CFactRecev cFactRecev = CDemModif2.recev.factRecev;
                            if ((cFactRecev.staRecev & 1) == 1) {
                                Long l = noFactRamq = cFactRecev.idFactRamqRecev == null ? null : new Long(cFactRecev.idFactRamqRecev.noFactRamq.longValue());
                                if (noFactRamq != null) {
                                    lstNoFactRamq.add(noFactRamq);
                                }
                                for (CTypLigneFactRecev cTypLigneFactRecev : cFactRecev.listeLigneFactRecev) {
                                    if (cTypLigneFactRecev.staRecev == null || cTypLigneFactRecev.staRecev.intValue() != 1) continue;
                                    mapLineRec.put(cTypLigneFactRecev.noLigneFact, cTypLigneFactRecev);
                                }
                            }
                        }
                    }
                }
                if (!lstNoFactRamq.isEmpty()) {
                    BaseArchive_dpacteDAO.getInstance().deletePrev(lstNoFactRamq);
                }
                if (serv == null || serv.mapTempPatients == null) break block56;
                int size = serv.mapTempPatients.values().size();
                if (size == 0) {
                    size = 1;
                    CPatient ptXXX = new CPatient();
                    ptXXX.setHealthInsuranceNumber("XXXX01010112");
                    serv.mapTempPatients.put(new Integer(0), ptXXX);
                }
                BigDecimal nbPt = new BigDecimal(size);
                for (CPatient cPatient : serv.mapTempPatients.values()) {
                    Integer n;
                    CPatient rep;
                    Object var25_39 = null;
                    Calendar datEve = null;
                    Object var27_46 = null;
                    String stringToHash = cPatient.getStringForHash(1);
                    int hashCode = CPatient.getStringToHashCode(stringToHash);
                    String[] persRepdn = null;
                    if (cPatient.getPersRepdn() != null && (rep = cPatient.getPersRepdn()).getTypPersAutre() != null) {
                        if (rep.getTypPersAutre() == 1) {
                            persRepdn = new String[]{"1", String.valueOf(rep.getTypIdPersAutre()), rep.getIdPersAutre()};
                        } else if (rep.getTypPersAutre() == 2) {
                            persRepdn = new String[]{"2", rep.getLastName(), cPatient.getFirstName(), cPatient.bds, cPatient.getGender()};
                        }
                    }
                    if (cPatient.getLstCTypDiagnMdcal() == null || cPatient.getLstCTypDiagnMdcal().size() == 0) {
                        dx = null;
                    } else {
                        dx = new String[cPatient.getLstCTypDiagnMdcal().size()];
                        int iDx = 0;
                        for (CTypDiagnMdcal d : cPatient.getLstCTypDiagnMdcal()) {
                            dx[iDx++] = d.code;
                        }
                    }
                    if (cPatient.typEvenePers != null && (n = ConvertJavaToFromArray.getInt(cPatient.typEvenePers)) != null && n != 0 && cPatient.datEvenePers != null) {
                        datEve = DateUtil.ctod((String)cPatient.datEvenePers);
                    }
                    if (cPatient.datEntree != null) {
                        Calendar calendar = DateUtil.ctod((String)cPatient.datEntree);
                    }
                    if (serv.mapTempLigneFact == null) continue;
                    for (CLigneTypServMdcal line : serv.mapTempLigneFact.values()) {
                        void var27_45;
                        void var25_41;
                        CTypLigneFactRecev ligneFactRecev2 = (CTypLigneFactRecev)mapLineRec.get(String.valueOf(line.noLigne));
                        if (ligneFactRecev2 == null || line.codFact == null) continue;
                        BigDecimal mntPrel2 = null;
                        if (ligneFactRecev2.mntPrel != null) {
                            mntPrel2 = ligneFactRecev2.mntPrel.divide(nbPt);
                            total = total.add(mntPrel2);
                        }
                        date = DateUtil.ctod((String)line.dateServ);
                        code = line.codFact.c != null ? new Integer(line.codFact.c.intValue()) : new Integer(0);
                        contx = null;
                        if (line.lstElmCx != null) {
                            for (CodeDesc ctx : line.lstElmCx) {
                                String string = contx = contx == null ? ctx.c : "," + ctx.c;
                            }
                        }
                        hreDebut = line.dhdElmFact;
                        BaseArchive_dpacteDAO.getInstance().addLine(line.noLigne, date, code, contx, hreDebut, idDp, noFactRamq, group, etabl, noProf, stringToHash, (Integer)var25_41, datEve, (Calendar)var27_45, dx, mntPrel2, hashCode, persRepdn);
                    }
                }
                break block55;
            }
            if (depl == null) break block55;
            CPatient pt = new CPatient();
            pt.setHealthInsuranceNumber("TTTT01010110");
            Integer typEve = null;
            Calendar calendar = null;
            Calendar calendar2 = null;
            String string = pt.getStringForHash(1);
            int hashCode = CPatient.getStringToHashCode(string);
            if (depl.mapTempForfaDepla != null) {
                for (CLigneForfaDepla cLigneForfaDepla : depl.mapTempForfaDepla.values()) {
                    ligneFactRecev = (CTypLigneFactRecev)mapLineRec.get(String.valueOf(cLigneForfaDepla.noLigne));
                    if (ligneFactRecev == null || (mntPrel = ligneFactRecev.mntPrel) == null) continue;
                    code = cLigneForfaDepla.idElmFact == null ? null : new Integer(cLigneForfaDepla.idElmFact.intValue());
                    BaseArchive_dpacteDAO.getInstance().addLine(cLigneForfaDepla.noLigne, date, code, contx, hreDebut, idDp, noFactRamq, group, etabl, noProf, string, typEve, calendar, calendar2, dx, mntPrel, hashCode, null);
                    total = total.add(mntPrel);
                }
            }
            if (depl.mapTempFraisSej != null) {
                for (CLigneFraisSej cLigneFraisSej : depl.mapTempFraisSej.values()) {
                    ligneFactRecev = (CTypLigneFactRecev)mapLineRec.get(String.valueOf(cLigneFraisSej.noLigne));
                    if (ligneFactRecev == null || (mntPrel = ligneFactRecev.mntPrel) == null) continue;
                    date = DateUtil.ctod((String)cLigneFraisSej.dateServ);
                    code = cLigneFraisSej.idElmFact == null ? null : new Integer(cLigneFraisSej.idElmFact.intValue());
                    BaseArchive_dpacteDAO.getInstance().addLine(cLigneFraisSej.noLigne, date, code, contx, hreDebut, idDp, noFactRamq, group, etabl, noProf, string, typEve, calendar, calendar2, dx, mntPrel, hashCode, null);
                    total = total.add(mntPrel);
                }
            }
            if (depl.mapTempFraisTranp != null) {
                for (CLigneFraisTranp cLigneFraisTranp : depl.mapTempFraisTranp.values()) {
                    ligneFactRecev = (CTypLigneFactRecev)mapLineRec.get(String.valueOf(cLigneFraisTranp.noLigne));
                    if (ligneFactRecev == null || (mntPrel = ligneFactRecev.mntPrel) == null) continue;
                    date = DateUtil.ctod((String)cLigneFraisTranp.dateServ);
                    code = cLigneFraisTranp.idElmFact == null ? null : new Integer(cLigneFraisTranp.idElmFact.intValue());
                    BaseArchive_dpacteDAO.getInstance().addLine(cLigneFraisTranp.noLigne, date, code, contx, hreDebut, idDp, noFactRamq, group, etabl, noProf, string, typEve, calendar, calendar2, dx, mntPrel, hashCode, null);
                    total = total.add(mntPrel);
                }
            }
            if (depl.mapTempTempsDepla != null) {
                for (CLigneTempsDepla cLigneTempsDepla : depl.mapTempTempsDepla.values()) {
                    ligneFactRecev = (CTypLigneFactRecev)mapLineRec.get(String.valueOf(cLigneTempsDepla.noLigne));
                    if (ligneFactRecev == null || (mntPrel = ligneFactRecev.mntPrel) == null) continue;
                    date = DateUtil.ctod((String)cLigneTempsDepla.dateServ);
                    code = cLigneTempsDepla.idElmFact == null ? null : new Integer(cLigneTempsDepla.idElmFact.intValue());
                    BaseArchive_dpacteDAO.getInstance().addLine(cLigneTempsDepla.noLigne, date, code, contx, hreDebut, idDp, noFactRamq, group, etabl, noProf, string, typEve, calendar, calendar2, dx, mntPrel, hashCode, null);
                    total = total.add(mntPrel);
                }
            }
        }
        return total;
    }

    public Status validForPlafond(int hash, CProfessionnal medecin, String noEtab, Calendar ddn, DiagnosticCIM9 diagnostic, Long noRfp, Calendar dateDp, Integer leCode, String lesCtx) {
        Status status = null;
        if (dateDp != null && medecin != null && leCode != null) {
            String codes;
            Integer plafNb;
            Integer codeRech;
            Integer mois;
            String plafDiff;
            block21: {
                dateDp = (Calendar)dateDp.clone();
                Session session = null;
                plafDiff = null;
                mois = null;
                Integer mois003 = null;
                codeRech = null;
                Integer plafAct = null;
                plafNb = null;
                Integer plafInt = null;
                codes = null;
                try {
                    try {
                        session = FmedxBaseDAO.getInstance().getSession();
                        String strAgg = "string_agg(cast(c.cod_acte as varchar),',')";
                        if (ConnectionFactory.isPatientRecordDialectH2()) {
                            strAgg = "GROUP_CONCAT(cast(c.cod_acte as varchar))";
                        }
                        int noSpec = Integer.parseInt(medecin.getCodSpec());
                        String sqlSpec = "cod_spec=" + noSpec;
                        if (noSpec == 39) {
                            sqlSpec = "cod_spec in (0," + noSpec + ")";
                        }
                        Integer entente = medecin.getType();
                        SQLQuery query = session.createSQLQuery("select s.plafdiff, s.mois, s.mois003, s.coderech, s.plaf_act, s.plaf_nb, s.plaf_int, (select " + strAgg + " from syra_cod_plaf c where c.plafdiff in (select d.plafdiff from syra_cod_plaf d where d.no_enten=" + entente + " and d." + sqlSpec + " and d.cod_acte=" + leCode + ") " + "and c.no_enten=" + entente + " and c." + sqlSpec + ")  as codes from syra_cod_plaf s where s.no_enten=" + entente + " and s." + sqlSpec + " and s.cod_acte=" + leCode);
                        query.addScalar("plafdiff", (Type)StringType.INSTANCE).addScalar("mois", (Type)IntegerType.INSTANCE).addScalar("mois003", (Type)IntegerType.INSTANCE).addScalar("coderech", (Type)IntegerType.INSTANCE).addScalar("plaf_act", (Type)IntegerType.INSTANCE).addScalar("plaf_nb", (Type)IntegerType.INSTANCE).addScalar("plaf_int", (Type)IntegerType.INSTANCE).addScalar("codes", (Type)StringType.INSTANCE);
                        System.out.println("Query=" + query.getQueryString());
                        List list = query.list();
                        if (list.size() == 1) {
                            Object[] oo = (Object[])list.get(0);
                            plafDiff = (String)oo[0];
                            mois = (Integer)oo[1];
                            mois003 = (Integer)oo[2];
                            codeRech = (Integer)oo[3];
                            plafAct = (Integer)oo[4];
                            plafNb = (Integer)oo[5];
                            plafInt = (Integer)oo[6];
                            codes = (String)oo[7];
                        }
                    }
                    catch (Exception e) {
                        LibPlugin.log((String)"SQL Erreur", (Exception)e);
                        if (session != null && session.isOpen()) {
                            session.close();
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null && session.isOpen()) {
                        session.close();
                    }
                    throw throwable;
                }
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            if (plafDiff != null && mois != null && plafNb != null && codes != null) {
                int nbMois = mois;
                int nbCodePermit = plafNb;
                boolean isOlderThan21mois = true;
                if (leCode.equals(new Integer(8877)) && ddn != null) {
                    Calendar newDate = (Calendar)dateDp.clone();
                    newDate.set(2, -21);
                    isOlderThan21mois = newDate.after(ddn);
                    if (isOlderThan21mois) {
                        nbMois = 12;
                        nbCodePermit = 1;
                    }
                }
                String[] arrCodes = codes.split(",");
                List<String> lstCodesPlaf = Arrays.asList(arrCodes);
                int nbCodePlaf = BaseArchive_dpacteDAO.getInstance().getNbCodesInLastXMonth(lstCodesPlaf, dateDp, nbMois, hash, medecin.getNoProf(), noRfp);
                if (nbCodePlaf >= nbCodePermit) {
                    if (codeRech != null && codeRech > 0) {
                        status = new Status(IStatus.Severity.INFO, "");
                        status.setData((Serializable)codeRech);
                    } else {
                        status = new Status(IStatus.Severity.WARNING, "Code non permis - fact. " + nbCodePlaf + " dans les derniers " + nbMois + " mois");
                    }
                } else {
                    status = new Status(IStatus.Severity.OK, "");
                }
            } else {
                status = new Status(IStatus.Severity.OK, "");
            }
        } else {
            status = new Status(IStatus.Severity.WARNING, "Code non permis");
        }
        return status;
    }

    public void removeMapPrefData(Integer idProf) {
        this.mapPrefData.remove(idProf);
        BaseProfessionnalDAO.getInstance().removeMapPrefProf(idProf);
    }
}

