/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra;

import ca.infodata.syra.B2bLogStatus;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.DateUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class LogWriter {
    private final StringBuilder writer = new StringBuilder(2000);
    private JoinList warningNError = new JoinList("\n");
    private Set<B2bLogStatus> status = new HashSet<B2bLogStatus>();
    private long timeStart1;

    public LogWriter() {
        this.status.add(B2bLogStatus.SUCCESS);
        this.timeStart1 = DateUtil.nowUTC();
    }

    public LogWriter error(String s) {
        this.newline();
        this.writer.append("E: ").append(s);
        this.warningNError.add((CharSequence)("E: " + s));
        this.status.add(B2bLogStatus.ERROR);
        return this;
    }

    public LogWriter error(String s, Exception e) {
        this.newline();
        this.writer.append("E: ").append(s);
        this.warningNError.add((CharSequence)("E: " + s));
        this.newline();
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        String s2 = errors.toString();
        this.writer.append("E: ").append(s2);
        this.warningNError.add((CharSequence)("E: " + s2));
        this.status.add(B2bLogStatus.ERROR);
        return this;
    }

    public LogWriter newline() {
        this.writer.append('\n');
        return this;
    }

    public LogWriter warning(String s) {
        this.newline();
        this.writer.append("A: ").append(s);
        this.warningNError.add((CharSequence)("A: " + s));
        this.status.add(B2bLogStatus.WARNING);
        return this;
    }

    public LogWriter info(String s) {
        this.newline();
        this.writer.append("I: ").append(s);
        return this;
    }

    public LogWriter sectionStart(String s) {
        this.writer.append("\n=============================================");
        this.writer.append("\nSS: ").append(s);
        this.writer.append("\n=============================================");
        return this;
    }

    public LogWriter sectionEnd(String s) {
        this.writer.append("\n=============================================");
        this.writer.append("\nSE: ").append(s);
        this.writer.append("\n=============================================");
        return this;
    }

    public void setFailed() {
        this.status.remove((Object)B2bLogStatus.SUCCESS);
        this.status.add(B2bLogStatus.FAIL);
    }

    public String toString() {
        String s = this.writer.toString();
        String s2 = "\n=============================================\nR\u00e9capitulatif des avertissements et erreurs\n=============================================\n" + this.warningNError.toString() + "\n=============================================";
        return String.valueOf(s2) + s;
    }

    public String toStringWarningNErrorOnly() {
        String s2 = "\n=============================================\nR\u00e9capitulatif des avertissements et erreurs\n=============================================\n" + this.warningNError.toString() + "\n=============================================";
        return s2;
    }

    public Set<B2bLogStatus> getStatus() {
        return this.status;
    }

    public long computeDurationInMinutes() {
        long nowUTC = DateUtil.nowUTC();
        long diff = nowUTC - this.timeStart1;
        return TimeUnit.MILLISECONDS.toMinutes(diff);
    }
}

