/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra;

import ca.infodata.controls.DateUtil;
import ca.infodata.dossier.gmf.ChangerMotPasseMachine2;
import ca.infodata.dossier.gmf.GmfPlugin;
import ca.infodata.dossier.gmf.Inscription2;
import ca.infodata.dossier.gmf.ModifierInscription2;
import ca.infodata.dossier.hibernate.DossierHibernatePlugin;
import ca.infodata.dossier.hibernate.Gmf;
import ca.infodata.dossier.hibernate.Patient;
import ca.infodata.dossier.hibernate.Person;
import ca.infodata.dossier.hibernate.Professionnal;
import ca.infodata.dossier.hibernate.XDisabilityCode;
import ca.infodata.dossier.hibernate.base.BasePatientDAO;
import ca.infodata.dossier.hibernate.base.BaseProfessionnalDAO;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPerson;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IProfessionnal;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.ui.browser.HtmlBrowserTools;
import ca.infodata.ramq.b2b2.B2BServiceConfiguration;
import ca.infodata.ramq.b2b2.B2bFautes;
import ca.infodata.ramq.b2b2.ChangMotpsIdMachin.ChangeMachineIdPasswordService;
import ca.infodata.ramq.b2b2.Domains;
import ca.infodata.ramq.b2b2.MessageTraitement;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.Clien2;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.InscriptionCriteria;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.InscriptionService;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.LieuSuiv2;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.Repre2;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.Resid2;
import ca.infodata.ramq.b2b2.ServEnrgtInscr.SituSant2;
import ca.infodata.ramq.b2b2.ServModifInscr.AjouterLieuSuiviCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.CarSanteCode;
import ca.infodata.ramq.b2b2.ServModifInscr.CesserInscriptionCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierCarSanteCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierDateInscriptionCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierInscriptionService;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierRepresentantCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierResidentCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.ModifierResult;
import ca.infodata.ramq.b2b2.ServModifInscr.PatientIdentificationCriteria;
import ca.infodata.ramq.b2b2.ServModifInscr.StatusReasonCode;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.GetInscriptionCriteria;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.GetInscriptionService;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.Inscription;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.InscriptionSituSant;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.InscriptionType;
import ca.infodata.ramq.b2b2.ServObtnInscrDisp.PatientIdentification;
import ca.infodata.ramq.b2b2.Transaction;
import ca.infodata.syra.Messages;
import ca.infodata.syra.SyraAccessorClient;
import ca.infodata.syra.controller.SyraController;
import ca.infodata.syra.models.B2bModPatientsInscr;
import ca.infodata.syra.models.B2bPatientData;
import ca.infodata.syra.models.B2bSituSant;
import ca.infodata.syra.models.CProfessionnalPrefData;
import ca.infodata.syra.models.CQuest;
import ca.infodata.syra.models.CTypeObject;
import ca.infodata.syra.models.PatientData;
import ca.infodata.util1.date.LocalDate;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;

public class InscriptionB2bMethods {
    protected static final String AUCUN = ca.infodata.dossier.person.ui.Messages.getString((String)"AUCUN");
    protected static final String NON_SUCCES_MODIF = ca.infodata.dossier.person.ui.Messages.getString((String)"PatientControl.NON_SUCCES_MODIF");
    protected static final String SUCCES_MODIF = ca.infodata.dossier.person.ui.Messages.getString((String)"PatientControl.SUCCES_MODIF");
    protected static final String AJOUTER_VULN = ca.infodata.dossier.person.ui.Messages.getString((String)"BasePatientControl.AJOUTER");
    protected static final String MODIFIER_VULN = ca.infodata.dossier.person.ui.Messages.getString((String)"BasePatientControl.MODIFIER");
    protected static final String SUPPRIMER_VULN = ca.infodata.dossier.person.ui.Messages.getString((String)"BasePatientControl.SUPPRIMER");
    private static final String SUCCES = Messages.getString("GmfPreferencesEditor.SUCCES");
    private static final String LA_MISE_A_JOUR_DU_MOT_DE_PASSE_A_REUSSI = Messages.getString("GmfPreferencesEditor.LA_MISE_A_JOUR_DU_MOT_DE_PASSE_A_REUSSI");
    static final String ECHEC = Messages.getString("GmfPreferencesEditor.ECHEC");
    private static final String IMPOSSIBLE_DE_CONTACTER_LE_SERVICE_WEB_DE_LA_RAMQ = Messages.getString("GmfPreferencesEditor.IMPOSSIBLE_DE_CONTACTER_LE_SERVICE_WEB_DE_LA_RAMQ");
    private static final String REESSAYER_PLUS_TARD = Messages.getString("GmfPreferencesEditor.REESSAYER_PLUS_TARD");
    private final Patient currentPatient;
    private final PatientData currentPatientData;
    private final Map<Integer, ListVulnerabilites> currentMapVuln = new HashMap<Integer, ListVulnerabilites>();
    private final Gmf gmf;
    final String uid;
    private final Map<Integer, ListVulnerabilites> mapModVuln = new HashMap<Integer, ListVulnerabilites>();
    protected final SyraController syraController;
    Map<String, Professionnal> mapProf = new HashMap<String, Professionnal>();
    static final String IDEM = "Non modifi\u00e9s";
    static final String ADD = "Ajout\u00e9s";
    static final String DEL = "Retir\u00e9s";
    static final String MOD = "Modifi\u00e9s";

    public InscriptionB2bMethods(Gmf gmf, String uid, SyraController sc) {
        this.syraController = sc;
        if (gmf == null) {
            throw new NullPointerException("gmf cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)gmf.getIdMachineGMF())) {
            Gmf cGmf = new Gmf();
            cGmf.setNoEtablGMF(gmf.getNoEtablGMF());
            cGmf.setIdUserGMF(this.syraController.getIdentSyra().syra_idMach);
            cGmf.setIdMachineGMF(this.syraController.getIdentSyra().syra_idMach);
            cGmf.setPasswordMachineGMF(this.syraController.getIdentSyra().syra_idMachPswd);
            this.gmf = cGmf;
        } else {
            this.gmf = gmf;
        }
        this.currentPatient = null;
        this.currentPatientData = null;
        this.uid = uid;
    }

    public InscriptionB2bMethods(PatientData patientData, Gmf gmf, String uid, SyraController sc) {
        this.syraController = sc;
        if (patientData == null || patientData.getId() == null) {
            throw new NullPointerException("patientData and its id cannot be null");
        }
        this.currentPatient = BasePatientDAO.getInstance().get(patientData.getId());
        if (this.currentPatient == null) {
            throw new NullPointerException("currentPatient for id " + patientData.getId() + " cannot be null");
        }
        if (gmf == null) {
            throw new NullPointerException("gmf cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)gmf.getIdMachineGMF())) {
            Gmf cGmf = new Gmf();
            cGmf.setNoEtablGMF(gmf.getNoEtablGMF());
            cGmf.setIdUserGMF(this.syraController.getIdentSyra().syra_idMach);
            cGmf.setIdMachineGMF(this.syraController.getIdentSyra().syra_idMach);
            cGmf.setPasswordMachineGMF(this.syraController.getIdentSyra().syra_idMachPswd);
            this.gmf = cGmf;
        } else {
            this.gmf = gmf;
        }
        this.currentPatientData = patientData;
        this.uid = uid;
    }

    private void setResident() {
        Professionnal resident = this.currentPatient.getResident();
        if (resident != null || this.currentPatientData.resident != null && this.currentPatientData.resident.getId() != null) {
            if (resident != null && (this.currentPatientData.resident == null || this.currentPatientData.resident.getId() == null)) {
                this.currentPatient.setResident(null);
            } else if (resident == null && this.currentPatientData.resident != null && this.currentPatientData.resident.getId() != null) {
                this.currentPatient.setResident(BaseProfessionnalDAO.getInstance().get(this.currentPatientData.resident.getId()));
            } else if (resident != null && resident.getId() != null && this.currentPatientData.resident.getId() != null && !resident.getId().equals(this.currentPatientData.resident.getId())) {
                this.currentPatient.setResident(BaseProfessionnalDAO.getInstance().get(this.currentPatientData.resident.getId()));
            }
        }
    }

    private void setRepresentant() {
        Patient representant = this.currentPatient.getPatientRepresentant();
        if (representant != null || this.currentPatientData.representant != null && this.currentPatientData.representant.getId() != null) {
            if (representant != null && (this.currentPatientData.representant == null || this.currentPatientData.representant.getId() == null)) {
                this.currentPatient.setPatientRepresentant(null);
            } else if (representant == null && this.currentPatientData.representant != null && this.currentPatientData.representant.getId() != null) {
                this.currentPatient.setPatientRepresentant(BasePatientDAO.getInstance().get(this.currentPatientData.representant.getId()));
                this.currentPatient.setPatientRepresentantType(this.currentPatientData.representantType);
            } else if (representant != null && representant.getId() != null && this.currentPatientData.representant.getId() != null && !representant.getId().equals(this.currentPatientData.representant.getId())) {
                this.currentPatient.setPatientRepresentant(BasePatientDAO.getInstance().get(this.currentPatientData.representant.getId()));
                this.currentPatient.setPatientRepresentantType(this.currentPatientData.representantType);
            }
        }
    }

    private void setLieuSuivi() {
        String lieuSuiv = null;
        if (this.currentPatientData.b2bPatientData.getLieuSuiv() != null) {
            B2bPatientData data = this.currentPatientData.b2bPatientData;
            if ("N".equals(this.currentPatientData.b2bPatientData.getLieuSuiv().typLocEtab)) {
                if (data.getLieuSuiv().local != null && data.getLieuSuiv().local.valCodLocal != null && StringUtils.isNotEmpty((CharSequence)data.getLieuSuiv().local.valCodLocal.getCodLocal())) {
                    lieuSuiv = String.valueOf(data.getLieuSuiv().typLocEtab) + "~" + data.getLieuSuiv().local.typIdLieuGeo + "~" + data.getLieuSuiv().local.valCodLocal.getCodLocal();
                }
            } else if ("C".equals(data.getLieuSuiv().typLocEtab) && data.getLieuSuiv().etab != null && StringUtils.isNotEmpty((CharSequence)data.getLieuSuiv().etab.noSelectedEtab)) {
                lieuSuiv = String.valueOf(data.getLieuSuiv().typLocEtab) + "~" + data.getLieuSuiv().etab.noSelectedEtab;
            }
        }
        this.currentPatient.setLieuSuivi(lieuSuiv);
    }

    private void setDateFL() {
        Date dateFLD = null;
        try {
            if (this.currentPatientData.b2bPatientData.fld != null) {
                dateFLD = DateUtils.parseDate((String)this.currentPatientData.b2bPatientData.fld, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss"});
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("La date de suivi n'a pu \u00eatre interpr\u00e9t\u00e9e.");
        }
        this.currentPatient.setFollowUpLocationDate(dateFLD == null ? null : new Long(dateFLD.getTime()));
    }

    private void setDateFI() {
        Date dateDFI = null;
        try {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.currentPatientData.b2bPatientData.dfi})) {
                dateDFI = DateUtils.parseDate((String)this.currentPatientData.b2bPatientData.dfi, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss"});
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("La date de fin d'inscription n'a pu \u00eatre interpr\u00e9t\u00e9e.");
        }
        this.currentPatient.setDateFinInscription(dateDFI == null ? null : new Long(dateDFI.getTime()));
    }

    private void setDateDI() {
        Date dateDI = null;
        try {
            dateDI = DateUtils.parseDate((String)this.currentPatientData.b2bPatientData.ddi, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mm:ss"});
        }
        catch (ParseException e) {
            throw new RuntimeException("La date de d\u00e9but d'inscription n'a pu \u00eatre interpr\u00e9t\u00e9e.");
        }
        this.currentPatient.setDateInscription(dateDI == null ? null : new Long(dateDI.getTime()));
    }

    private void setListVulnList() {
        List<B2bSituSant> situSant = this.currentPatientData.getB2bPatientData().getSituSant();
        XDisabilityCode noDisCode = XDisabilityCode.C00;
        ListVulnerabilites vuln1 = new ListVulnerabilites(this.currentPatient.getDisabilityCode1().getCodeInt(), this.currentPatient.getDisabilityLocalDate1());
        this.currentMapVuln.put(new Integer(1), vuln1);
        ListVulnerabilites vuln2 = new ListVulnerabilites(this.currentPatient.getDisabilityCode2().getCodeInt(), this.currentPatient.getDisabilityLocalDate2());
        this.currentMapVuln.put(new Integer(2), vuln2);
        ListVulnerabilites vuln3 = new ListVulnerabilites(this.currentPatient.getDisabilityCode3().getCodeInt(), this.currentPatient.getDisabilityLocalDate3());
        this.currentMapVuln.put(new Integer(3), vuln3);
        this.currentPatient.setDisabilityCode1(noDisCode);
        this.currentPatient.setDisabilityCode2(noDisCode);
        this.currentPatient.setDisabilityCode3(noDisCode);
        this.currentPatient.setDisabilityDate(null);
        this.currentPatient.setDisabilityDate2(null);
        this.currentPatient.setDisabilityDate3(null);
        int i = 1;
        for (B2bSituSant sant : situSant) {
            boolean toDelAndToAdd;
            ListVulnerabilites vuln = this.currentMapVuln.get(new Integer(i));
            boolean toAdd = sant.getCodeI() != 0 && vuln.getCode() == 0;
            boolean bl = toDelAndToAdd = sant.getCodeI() != 0 && vuln.getCode() != 0 && (sant.getCodeI() != vuln.getCode() || sant.getDateI() != vuln.getDate());
            if (sant.getCodeI() == 0 && vuln.getCode() == 0) {
                this.mapModVuln.put(new Integer(i), vuln);
                this.setDisabilityToCurrentPatient(i, sant);
            } else if (sant.getCodeI() == 0 && vuln.getCode() != 0) {
                vuln.setToDo(TODO.DEL);
                this.mapModVuln.put(new Integer(i), vuln);
            } else if (toAdd) {
                vuln.setCode(sant.getCodeI());
                vuln.setDate(sant.getDateI());
                vuln.setToDo(TODO.ADD);
                this.mapModVuln.put(new Integer(i), vuln);
            } else if (toDelAndToAdd) {
                ListVulnerabilites vulnToDel = new ListVulnerabilites(vuln.code, vuln.date);
                vulnToDel.setToDo(TODO.DEL);
                this.mapModVuln.put(new Integer(-i), vulnToDel);
                vuln.setCode(sant.getCodeI());
                vuln.setDate(sant.getDateI());
                vuln.setToDo(TODO.ADD);
                this.mapModVuln.put(new Integer(i), vuln);
            } else {
                this.mapModVuln.put(new Integer(i), vuln);
                this.setDisabilityToCurrentPatient(i, sant);
            }
            ++i;
        }
    }

    private void setDisabilityToCurrentPatient(int i, B2bSituSant sant) {
        XDisabilityCode disCode00 = null;
        if (sant == null) {
            disCode00 = XDisabilityCode.C00;
        }
        if (i == 1) {
            if (sant == null) {
                this.currentPatient.setDisabilityCode1(disCode00);
                this.currentPatient.setDisabilityDate(null);
            } else {
                XDisabilityCode disCode = XDisabilityCode.fromCode((int)sant.getCodeI());
                this.currentPatient.setDisabilityCode1(disCode);
                if (sant.getDateI() == 0) {
                    this.currentPatient.setDisabilityDate(null);
                } else {
                    this.currentPatient.setDisabilityDate(LocalDate.fromDayFrom1970((int)sant.getDateI()).toCalendar());
                }
            }
        } else if (i == 2) {
            if (sant == null) {
                this.currentPatient.setDisabilityCode2(disCode00);
                this.currentPatient.setDisabilityDate2(null);
            } else {
                XDisabilityCode disCode = XDisabilityCode.fromCode((int)sant.getCodeI());
                this.currentPatient.setDisabilityCode2(disCode);
                if (sant.getDateI() == 0) {
                    this.currentPatient.setDisabilityDate2(null);
                } else {
                    this.currentPatient.setDisabilityDate2(new Long(LocalDate.fromDayFrom1970((int)sant.getDateI()).toCalendar().getTimeInMillis()));
                }
            }
        } else if (i == 3) {
            if (sant == null) {
                this.currentPatient.setDisabilityCode3(disCode00);
                this.currentPatient.setDisabilityDate3(null);
            } else {
                XDisabilityCode disCode = XDisabilityCode.fromCode((int)sant.getCodeI());
                this.currentPatient.setDisabilityCode3(disCode);
                if (sant.getDateI() == 0) {
                    this.currentPatient.setDisabilityDate3(null);
                } else {
                    this.currentPatient.setDisabilityDate3(new Long(LocalDate.fromDayFrom1970((int)sant.getDateI()).toCalendar().getTimeInMillis()));
                }
            }
        }
    }

    public MultiStatus updatePasswordB2b() throws Exception {
        MultiStatus status = new MultiStatus();
        String errMessage = null;
        if (this.gmf != null && StringUtils.isNotEmpty((CharSequence)this.gmf.getIdMachineGMF()) && StringUtils.isNotEmpty((CharSequence)this.gmf.getPasswordMachineGMF())) {
            Object[] rec = new Object[]{this.gmf.getTag(), "prg", new Integer(1)};
            String message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
            HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
            this.sleep();
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ChangeMachineIdPasswordService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ChangerMotPasseMachine2 service = new ChangerMotPasseMachine2(configuration, this.gmf.getIdUserGMF());
            Transaction result = service.renew(this.gmf.getIdMachineGMF(), this.gmf.getPasswordMachineGMF());
            List lstFautes = result.getFaults();
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                rec = new Object[]{this.gmf.getTag(), "prg", new Integer(3)};
                message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                return status;
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)((Object)result.getResult())))) {
                this.gmf.setDateModifPasswordGMF(new Long(System.currentTimeMillis()));
                this.gmf.setPasswordMachineGMF((String)((Object)result.getResult()));
                GmfPlugin.getDefault().saveGmf(this.gmf);
                rec = new Object[]{this.gmf.getTag(), "pswd", result.getResult()};
                message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                this.sleep();
                rec = new Object[]{this.gmf.getTag(), "dateModPswd", LocalDate.today().formatHyphen()};
                message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                this.sleep();
                rec = new Object[]{this.gmf.getTag(), "prg", new Integer(2)};
                message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                this.sleep();
                status = new MultiStatus(IStatus.Severity.OK, String.valueOf(SUCCES) + ": " + LA_MISE_A_JOUR_DU_MOT_DE_PASSE_A_REUSSI, null);
            } else {
                rec = new Object[]{this.gmf.getTag(), "prg", new Integer(3)};
                message3 = new GsonBuilder().create().toJson((Object)new CTypeObject("idInscrUpdatedType", rec));
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                errMessage = String.valueOf(IMPOSSIBLE_DE_CONTACTER_LE_SERVICE_WEB_DE_LA_RAMQ) + REESSAYER_PLUS_TARD;
                status = new MultiStatus(IStatus.Severity.ERROR, errMessage, null);
            }
        }
        return status;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public MultiStatus getInscription(List<String> noProfs) throws Exception {
        MultiStatus status = new MultiStatus();
        ArrayList<B2bModPatientsInscr> lstNonMod = new ArrayList<B2bModPatientsInscr>();
        ArrayList<B2bModPatientsInscr> lstAdd = new ArrayList<B2bModPatientsInscr>();
        ArrayList<B2bModPatientsInscr> lstMod = new ArrayList<B2bModPatientsInscr>();
        ArrayList<B2bModPatientsInscr> lstDel = new ArrayList<B2bModPatientsInscr>();
        for (String no : noProfs) {
            GetInscriptionCriteria criteria = new GetInscriptionCriteria();
            criteria.setProfClassNo(no.substring(0, 1));
            criteria.setProfNo(no.substring(1, 6));
            criteria.setGmfNo(StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null);
            criteria.setSiteNo(this.gmf.getNoEtablGMF());
            criteria.setType(criteria.getGmfNo() == null ? InscriptionType.H : InscriptionType.G);
            criteria.setUserId(this.gmf.getIdUserGMF());
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = GetInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            GetInscriptionService service = new GetInscriptionService(configuration);
            CTypeObject to3 = new CTypeObject("b2bObtenirInscrType", "MD " + no + "<br>" + "Obtention des donn\u00e9es de la RAMQ...");
            String message3 = new GsonBuilder().create().toJson((Object)to3);
            HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
            Transaction result = service.get(criteria);
            List lstFautes = result.getFaults();
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "MD " + no + ": " + msg));
            }
            Iterator<String> iterator = errMsg.iterator();
            if (iterator.hasNext()) {
                String msg;
                msg = iterator.next();
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
                return status;
            }
            if (result.getResult() == null || ((ArrayList)result.getResult()).isEmpty()) continue;
            try {
                this.obtenirInscriptionMethod(status, no, (List)((Object)result.getResult()), lstNonMod, lstAdd, lstMod, lstDel);
            }
            catch (Exception e) {
                e.printStackTrace();
                status.add((IStatus)new Status(IStatus.Severity.ERROR, "Erreur dans obtenirInscriptionMethod", (Throwable)e));
                return status;
            }
        }
        CTypeObject to3 = new CTypeObject("b2bObtenirInscrFinType", "MD Tous<br><b>Fin des importations.");
        String message3 = new GsonBuilder().create().toJson((Object)to3);
        HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
        Status stDel = new Status(IStatus.Severity.INFO, "Retir\u00e9s: " + lstDel.size());
        status.add((IStatus)stDel);
        Status stAdd = new Status(IStatus.Severity.INFO, "Ajout\u00e9s: " + lstAdd.size());
        status.add((IStatus)stAdd);
        Status stMod = new Status(IStatus.Severity.INFO, "Modifi\u00e9s: " + lstMod.size());
        status.add((IStatus)stMod);
        Status stNonMod = new Status(IStatus.Severity.INFO, "Non modifi\u00e9s: " + lstNonMod.size());
        status.add((IStatus)stNonMod);
        lstDel.addAll(lstAdd);
        lstDel.addAll(lstMod);
        lstDel.addAll(lstNonMod);
        Collections.sort(lstDel, new Comparator<B2bModPatientsInscr>(){

            @Override
            public int compare(B2bModPatientsInscr o1, B2bModPatientsInscr o2) {
                if (o1.np.equals(o2.np)) {
                    if (o1.t.equals(o2.t)) {
                        if (o1.nam != null && o2.nam != null) {
                            return o1.nam.compareTo(o2.nam);
                        }
                        if (o1.nam != null && o2.fn != null) {
                            return o1.nam.substring(0, 4).compareTo(o2.fn);
                        }
                        if (o2.nam != null && o1.fn != null) {
                            return o1.fn.compareTo(o2.nam.substring(0, 4));
                        }
                        return (String.valueOf(o1.ln) + o1.fn + o1.ddn + o1.sex).compareTo(String.valueOf(o2.ln) + o2.fn + o2.ddn + o2.sex);
                    }
                    return o1.t.compareTo(o2.t);
                }
                return o1.np.compareTo(o2.np);
            }
        });
        Status stOk = new Status(IStatus.Severity.OK, String.valueOf(lstDel.size()) + " clients totaux synchronis\u00e9s.");
        stOk.setData(lstDel);
        status.add((IStatus)stOk);
        String statusJson = new GsonBuilder().create().toJson((Object)status);
        File dir = new File(SyraController.fmedxHomeInscrClient);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileUtils.writeStringToFile((File)new File(String.valueOf(SyraController.fmedxHomeInscrClient) + "ic" + this.gmf.getNoEtablGMF() + "-" + DateUtil.ttoc((long)System.currentTimeMillis(), (boolean)false, (boolean)false) + ".json"), (String)statusJson);
        return status;
    }

    public MultiStatus transmettreInscription(boolean preInscrit, ArrayList<CQuest> arrayOfQuest) throws Exception {
        SituSant2 ss2;
        MultiStatus status = new MultiStatus();
        InscriptionCriteria criteria = new InscriptionCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    status.setSeverity(IStatus.Severity.INFO);
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        this.setDateDI();
        this.setDateFI();
        this.setDateFL();
        this.setLieuSuivi();
        this.setRepresentant();
        this.setResident();
        this.setListVulnList();
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.codContxUtil = preInscrit ? Domains.CodContxUtil.Preinscription : Domains.CodContxUtil.Inscription;
        criteria.datPrisEfet = LocalDate.fromCalendar((Calendar)this.currentPatient.getDateInscriptionCalendar());
        criteria.lieuSuivi = new ArrayList();
        LieuSuiv2 suiv = new LieuSuiv2();
        suiv.cod = this.currentPatient.getNoEtabFromLieuSuivi() == null ? -1 : this.currentPatient.getNoEtabFromLieuSuivi();
        suiv.datDeb = this.currentPatient.getFollowUpLocationDate() == null ? null : LocalDate.fromTimeInMillisLOCAL((Long)this.currentPatient.getFollowUpLocationDate());
        criteria.lieuSuivi.add(suiv);
        criteria.noGmf = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
        criteria.treatingProfessionnalNo = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        criteria.client = new Clien2();
        criteria.client.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.client.birthdate = this.currentPatient.getLDBirthDate();
        criteria.client.firstName = this.currentPatient.getFirstName();
        criteria.client.lastName = this.currentPatient.getLastName();
        criteria.client.sex = this.currentPatient.getGender();
        criteria.client.codLangCorre = this.currentPatient.getLanguageCode() != null && this.currentPatient.getLanguageCode() == 1 ? "A" : "F";
        ArrayList<SituSant2> lstSituSant = new ArrayList<SituSant2>();
        ListVulnerabilites vuln1 = this.mapModVuln.get(new Integer(1));
        ListVulnerabilites vuln2 = this.mapModVuln.get(new Integer(2));
        ListVulnerabilites vuln3 = this.mapModVuln.get(new Integer(3));
        if (vuln1.code > 0 && vuln1.date > 0) {
            ss2 = new SituSant2();
            ss2.codProfiSant = Domains.CodProfiSant.Clientele_vulnerable.value;
            ss2.codCarSant = vuln1.code;
            ss2.datDebSituSant = LocalDate.fromDayFrom1970((int)vuln1.date);
            lstSituSant.add(ss2);
            this.setDisabilityToCurrentPatient(1, new B2bSituSant(ss2));
        }
        if (vuln2.code > 0 && vuln2.date > 0) {
            ss2 = new SituSant2();
            ss2.codProfiSant = Domains.CodProfiSant.Clientele_vulnerable.value;
            ss2.codCarSant = vuln2.code;
            ss2.datDebSituSant = LocalDate.fromDayFrom1970((int)vuln2.date);
            lstSituSant.add(ss2);
            this.setDisabilityToCurrentPatient(2, new B2bSituSant(ss2));
        }
        if (vuln3.code > 0 && vuln3.date > 0) {
            ss2 = new SituSant2();
            ss2.codProfiSant = Domains.CodProfiSant.Clientele_vulnerable.value;
            ss2.codCarSant = vuln3.code;
            ss2.datDebSituSant = LocalDate.fromDayFrom1970((int)vuln3.date);
            lstSituSant.add(ss2);
            this.setDisabilityToCurrentPatient(3, new B2bSituSant(ss2));
        }
        if (!lstSituSant.isEmpty()) {
            criteria.situSante = lstSituSant;
        }
        if (this.currentPatient.getResident() != null) {
            criteria.resident = new Resid2();
            criteria.resident.profCode = this.currentPatient.getResident().getCode();
        }
        if (this.currentPatient.getPatientRepresentant() != null && this.currentPatient.getPatientRepresentantType() != null) {
            criteria.representant = new Repre2();
            if (StringUtils.isNotEmpty((CharSequence)this.currentPatient.getPatientRepresentant().getHealthInsuranceNumber()) && !LibPlugin.isDebug) {
                criteria.representant.nam = this.currentPatient.getPatientRepresentant().getHealthInsuranceNumber();
            }
            criteria.representant.firstName = this.currentPatient.getPatientRepresentant().getFirstName();
            criteria.representant.lastName = this.currentPatient.getPatientRepresentant().getLastName();
            criteria.representant.title = Patient.RepresentantType.getValue((int)this.currentPatient.getPatientRepresentantType());
        }
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = InscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        Inscription2 service = new Inscription2(configuration, this.gmf.getIdUserGMF());
        Transaction result = service.transmettreInscription(criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            this.currentPatient.setIsInscritGMF(new Integer(preInscrit ? 1 : 2));
            BasePatientDAO.getInstance().update(this.currentPatient);
            ArrayList<String> s = new ArrayList<String>();
            s.add("<p><strong>- - - Succ\u00e8s de l'inscription - - -</strong></p>");
            s.add("<p>Patient: <b>" + this.currentPatient.getName() + "</b></p>");
            s.add("<p>M\u00e9decin: <b>" + this.currentPatient.getTreatingProfessionnal().getName() + "</b></p>");
            s.add("<p>Car Sant\u00e9: <b>" + this.currentPatient.getAllDisabilityCodes() + "</b></p>");
            StringBuffer sb = new StringBuffer();
            for (String ss : s) {
                sb.append(ss);
            }
            status.add((IStatus)new Status(IStatus.Severity.OK, sb.toString()));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus cesserInscription(ArrayList<CQuest> arrayOfQuest, StatusReasonCode raison, Calendar date) throws Exception {
        MultiStatus status = new MultiStatus();
        if (raison == null) {
            raison = StatusReasonCode.CR99;
        }
        if (date == null) {
            date = Calendar.getInstance();
        }
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
        CesserInscriptionCriteria criteria = new CesserInscriptionCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.patient = new PatientIdentificationCriteria();
        criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
        criteria.patient.firstname = this.currentPatient.getFirstName();
        criteria.patient.lastname = this.currentPatient.getLastName();
        criteria.patient.sex = this.currentPatient.getGender();
        criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        criteria.codRaisSta = raison;
        criteria.datFinInscr = LocalDate.fromCalendar((Calendar)date);
        Transaction result = service.modifInscription(ModifierInscription2.ModifTask.cesserInscription, (Object)criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            this.currentPatient.setIsInscritGMF(new Integer(0));
            this.currentPatient.setDateInscription(null);
            this.currentPatient.setDateFinInscriptionCalendar(date);
            BasePatientDAO.getInstance().update(this.currentPatient);
            String msgSucces = "Succ\u00e8s de l'arr\u00eat de l'inscription en date du " + criteria.datFinInscr.formatHyphen() + ".";
            status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus supprimerInscription(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
        ModifierCriteria criteria = new ModifierCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.patient = new PatientIdentificationCriteria();
        criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
        criteria.patient.firstname = this.currentPatient.getFirstName();
        criteria.patient.lastname = this.currentPatient.getLastName();
        criteria.patient.sex = this.currentPatient.getGender();
        criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        Transaction result = service.modifInscription(ModifierInscription2.ModifTask.supprimerInscription, (Object)criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            this.currentPatient.setIsInscritGMF(new Integer(0));
            this.currentPatient.setDateInscription(null);
            this.currentPatient.setDateFinInscriptionCalendar(null);
            BasePatientDAO.getInstance().update(this.currentPatient);
            String msgSucces = "Succ\u00e8s de la suppression de l'inscription.";
            status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus changeDate(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setDateDI();
        Calendar newDateInscr = this.currentPatient.getDateInscriptionCalendar();
        if (newDateInscr != null) {
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            ModifierDateInscriptionCriteria criteria = new ModifierDateInscriptionCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        status.setSeverity(IStatus.Severity.INFO);
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            criteria.datPriseEfetInscr = LocalDate.fromCalendar((Calendar)newDateInscr);
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            Transaction result = service.modifInscription(ModifierInscription2.ModifTask.modifierDate, (Object)criteria);
            List lstFautes = result.getFaults();
            ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                return status;
            }
            if (lstQuest.size() > 0) {
                Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                return status;
            }
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s du changement de la date de d\u00e9but de l'inscription.";
                status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
            }
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "La nouvelle date est absente!"));
        }
        return status;
    }

    public MultiStatus modifierRepres(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setRepresentant();
        if (this.currentPatient.getPatientRepresentant() != null) {
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            ModifierRepresentantCriteria criteria = new ModifierRepresentantCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            if (StringUtils.isNotEmpty((CharSequence)this.currentPatient.getPatientRepresentant().getHealthInsuranceNumber()) && !LibPlugin.isDebug) {
                criteria.namRepre = this.currentPatient.getPatientRepresentant().getHealthInsuranceNumber();
            }
            criteria.firstNameRepre = this.currentPatient.getPatientRepresentant().getPerson().getFirstName();
            criteria.lastNameRepre = this.currentPatient.getPatientRepresentant().getPerson().getLastName();
            criteria.titreTitulRepre = Patient.RepresentantType.getValue((int)this.currentPatient.getPatientRepresentantType());
            Transaction result = service.modifInscription(ModifierInscription2.ModifTask.modifierRepres, (Object)criteria);
            List lstFautes = result.getFaults();
            ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                return status;
            }
            if (lstQuest.size() > 0) {
                Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                return status;
            }
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s de la modification du repr\u00e9sentant.";
                status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
            }
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le repr\u00e9sentant est absent!"));
        }
        return status;
    }

    public MultiStatus supprimerRepres(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
        ModifierCriteria criteria = new ModifierCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    status.setSeverity(IStatus.Severity.INFO);
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.patient = new PatientIdentificationCriteria();
        criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
        criteria.patient.firstname = this.currentPatient.getFirstName();
        criteria.patient.lastname = this.currentPatient.getLastName();
        criteria.patient.sex = this.currentPatient.getGender();
        criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
        criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        Transaction result = service.modifInscription(ModifierInscription2.ModifTask.supprimerRepres, (Object)criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            this.currentPatient.setPatientRepresentant(null);
            this.currentPatient.setPatientRepresentantType(new Integer(0));
            BasePatientDAO.getInstance().update(this.currentPatient);
            String msgSucces = "Succ\u00e8s de la suppression du repr\u00e9sentant.";
            status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus modifierResident(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setResident();
        if (this.currentPatient.getResident() != null) {
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            ModifierResidentCriteria criteria = new ModifierResidentCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        status.setSeverity(IStatus.Severity.INFO);
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            criteria.residentProfessionnalCode = this.currentPatient.getResident().getCode();
            Transaction result = service.modifInscription(ModifierInscription2.ModifTask.modifierResident, (Object)criteria);
            List lstFautes = result.getFaults();
            ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                return status;
            }
            if (lstQuest.size() > 0) {
                Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                return status;
            }
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s de la modification du r\u00e9sident.";
                status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
            }
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le r\u00e9sident est absent!"));
        }
        return status;
    }

    public MultiStatus supprimerResident(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
        ModifierCriteria criteria = new ModifierCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    status.setSeverity(IStatus.Severity.INFO);
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.patient = new PatientIdentificationCriteria();
        criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
        criteria.patient.firstname = this.currentPatient.getFirstName();
        criteria.patient.lastname = this.currentPatient.getLastName();
        criteria.patient.sex = this.currentPatient.getGender();
        criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
        criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        Transaction result = service.modifInscription(ModifierInscription2.ModifTask.supprimerResident, (Object)criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            this.currentPatient.setResident(null);
            BasePatientDAO.getInstance().update(this.currentPatient);
            String msgSucces = "Succ\u00e8s de la suppression du r\u00e9sident.";
            status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus ajouterLieuSuivi(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setDateFL();
        this.setLieuSuivi();
        Integer lieuSuivi = this.currentPatient.getNoEtabFromLieuSuivi();
        if (lieuSuivi != null) {
            LocalDate fld = this.currentPatient.getFollowUpLocationDate() == null ? LocalDate.today() : LocalDate.fromTimeInMillisLOCAL((Long)this.currentPatient.getFollowUpLocationDate());
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            AjouterLieuSuiviCriteria criteria = new AjouterLieuSuiviCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        status.setSeverity(IStatus.Severity.INFO);
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            criteria.code = lieuSuivi;
            criteria.startDate = fld;
            Transaction result = service.modifInscription(ModifierInscription2.ModifTask.ajouterLieuSuivi, (Object)criteria);
            List lstFautes = result.getFaults();
            ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                return status;
            }
            if (lstQuest.size() > 0) {
                Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                return status;
            }
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s du changement du lieu de suivi.";
                status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
            }
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu de suivi est absent!"));
        }
        return status;
    }

    public MultiStatus corrigerLieuSuivi(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setDateFL();
        this.setLieuSuivi();
        Integer lieuSuivi = this.currentPatient.getNoEtabFromLieuSuivi();
        if (lieuSuivi != null) {
            LocalDate fld = this.currentPatient.getFollowUpLocationDate() == null ? LocalDate.today() : LocalDate.fromTimeInMillisLOCAL((Long)this.currentPatient.getFollowUpLocationDate());
            B2BServiceConfiguration configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            AjouterLieuSuiviCriteria criteria = new AjouterLieuSuiviCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        status.setSeverity(IStatus.Severity.INFO);
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            criteria.code = lieuSuivi;
            criteria.startDate = fld;
            Transaction result = service.modifInscription(ModifierInscription2.ModifTask.corrigerLieuSuivi, (Object)criteria);
            List lstFautes = result.getFaults();
            ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
            List<String> errMsg = this.getErrorFromFautes(lstFautes);
            List<String> infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (!errMsg.isEmpty()) {
                return status;
            }
            if (lstQuest.size() > 0) {
                Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                return status;
            }
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s du changement du lieu de suivi.";
                status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
            } else {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
            }
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Le lieu de suivi est absent!"));
        }
        return status;
    }

    public MultiStatus supprimerLieuSuivi(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        B2BServiceConfiguration configuration = new B2BServiceConfiguration();
        configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
        configuration.username = this.gmf.getIdMachineGMF();
        configuration.password = this.gmf.getPasswordMachineGMF();
        this.setLogToSystemOut(configuration);
        ModifierInscription2 service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
        ModifierCriteria criteria = new ModifierCriteria();
        if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
            for (CQuest cq : arrayOfQuest) {
                if ("N".equals(cq.rep)) {
                    status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                    status.setSeverity(IStatus.Severity.INFO);
                    return status;
                }
                criteria.addQuest(cq.seq, cq.rep);
            }
        }
        criteria.userId = this.gmf.getIdUserGMF();
        criteria.patient = new PatientIdentificationCriteria();
        criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
        criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
        criteria.patient.firstname = this.currentPatient.getFirstName();
        criteria.patient.lastname = this.currentPatient.getLastName();
        criteria.patient.sex = this.currentPatient.getGender();
        criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
        criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
        Transaction result = service.modifInscription(ModifierInscription2.ModifTask.supprimerLieuSuivi, (Object)criteria);
        List lstFautes = result.getFaults();
        ArrayList<CQuest> lstQuest = this.setQuestionsInArray(lstFautes);
        List<String> errMsg = this.getErrorFromFautes(lstFautes);
        List<String> infoMsg = this.getInfoFromFautes(lstFautes);
        for (String msg : infoMsg) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
        }
        for (String msg : errMsg) {
            status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
        }
        if (!errMsg.isEmpty()) {
            return status;
        }
        if (lstQuest.size() > 0) {
            Status qStatus = new Status(IStatus.Severity.WARNING, "Questions");
            status.setData(lstQuest);
            status.add((IStatus)qStatus);
            return status;
        }
        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
            BasePatientDAO.getInstance().update(this.currentPatient);
            String msgSucces = "Succ\u00e8s de la suppression du lieu de suivi.";
            status.add((IStatus)new Status(IStatus.Severity.OK, msgSucces));
        } else {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    public MultiStatus sendModVuln(ArrayList<CQuest> arrayOfQuest) throws Exception {
        MultiStatus status = new MultiStatus();
        this.setListVulnList();
        for (Map.Entry<Integer, ListVulnerabilites> vulns : this.mapModVuln.entrySet()) {
            Status qStatus;
            List<String> infoMsg;
            List<String> errMsg;
            ArrayList<CQuest> lstQuest;
            List lstFautes;
            Transaction result;
            ModifierInscription2 service;
            B2BServiceConfiguration configuration;
            Object todoMsg;
            LocalDate ld;
            ModifierCarSanteCriteria criteria;
            Integer key = vulns.getKey();
            if (key < 0) continue;
            ListVulnerabilites vuln = vulns.getValue();
            ListVulnerabilites vulnToDel = this.mapModVuln.get(new Integer(-key.intValue()));
            if (vulnToDel != null) {
                criteria = new ModifierCarSanteCriteria();
                if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                    for (CQuest cq : arrayOfQuest) {
                        if ("N".equals(cq.rep)) {
                            status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                            status.setSeverity(IStatus.Severity.INFO);
                            return status;
                        }
                        criteria.addQuest(cq.seq, cq.rep);
                    }
                }
                ld = LocalDate.fromDayFrom1970((int)vulnToDel.date);
                criteria.code = CarSanteCode.from((Integer)new Integer(vulnToDel.code));
                criteria.startdate = ld;
                todoMsg = "";
                if (TODO.DEL.equals((Object)vulnToDel.toDo)) {
                    criteria.action = ModifierCarSanteCriteria.Action.REMOVE;
                    todoMsg = "la suppression";
                }
                if (criteria.action != null) {
                    criteria.userId = this.gmf.getIdUserGMF();
                    criteria.patient = new PatientIdentificationCriteria();
                    criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
                    criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
                    criteria.patient.firstname = this.currentPatient.getFirstName();
                    criteria.patient.lastname = this.currentPatient.getLastName();
                    criteria.patient.sex = this.currentPatient.getGender();
                    criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
                    criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
                    configuration = new B2BServiceConfiguration();
                    configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
                    configuration.username = this.gmf.getIdMachineGMF();
                    configuration.password = this.gmf.getPasswordMachineGMF();
                    this.setLogToSystemOut(configuration);
                    service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
                    result = service.modifInscription(ModifierInscription2.ModifTask.modifierCarSante, (Object)criteria);
                    lstFautes = result.getFaults();
                    lstQuest = this.setQuestionsInArray(lstFautes);
                    errMsg = this.getErrorFromFautes(lstFautes);
                    infoMsg = this.getInfoFromFautes(lstFautes);
                    for (String msg : infoMsg) {
                        status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
                    }
                    for (String msg : errMsg) {
                        status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
                    }
                    if (lstQuest.size() > 0) {
                        qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                        status.setData(lstQuest);
                        status.add((IStatus)qStatus);
                    } else if (errMsg.isEmpty()) {
                        if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                            this.setDisabilityToCurrentPatient(key, null);
                            BasePatientDAO.getInstance().update(this.currentPatient);
                            String msgSucces = "Succ\u00e8s de " + (String)todoMsg + " de la caract\u00e9ristique de sant\u00e9 '" + this.addZero(vulnToDel.code) + "' en date du " + LocalDate.fromDayFrom1970((int)vulnToDel.date).formatHyphen() + ".";
                            Status statusOk = new Status(IStatus.Severity.OK, msgSucces);
                            status.add((IStatus)statusOk);
                            vulnToDel = null;
                        } else {
                            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
                        }
                    }
                }
            }
            if (vulnToDel != null) continue;
            criteria = new ModifierCarSanteCriteria();
            if (arrayOfQuest != null && !arrayOfQuest.isEmpty()) {
                for (CQuest cq : arrayOfQuest) {
                    if ("N".equals(cq.rep)) {
                        status.add((IStatus)new Status(IStatus.Severity.INFO, "La r\u00e9ponse n\u00e9gative annulle cette requ\u00eate.", null));
                        status.setSeverity(IStatus.Severity.INFO);
                        return status;
                    }
                    criteria.addQuest(cq.seq, cq.rep);
                }
            }
            ld = LocalDate.fromDayFrom1970((int)vuln.date);
            criteria.code = CarSanteCode.from((Integer)new Integer(vuln.code));
            criteria.startdate = ld;
            todoMsg = "";
            if (TODO.DEL.equals((Object)vuln.toDo)) {
                criteria.action = ModifierCarSanteCriteria.Action.REMOVE;
                todoMsg = "la suppression";
            } else if (TODO.MOD.equals((Object)vuln.toDo)) {
                criteria.action = ModifierCarSanteCriteria.Action.MODIFY;
                todoMsg = "la modification";
            } else if (TODO.ADD.equals((Object)vuln.toDo)) {
                criteria.action = ModifierCarSanteCriteria.Action.ADD;
                todoMsg = "l'ajout";
            }
            if (criteria.action == null) continue;
            criteria.userId = this.gmf.getIdUserGMF();
            criteria.patient = new PatientIdentificationCriteria();
            criteria.patient.nam = this.currentPatient.getHealthInsuranceNumber();
            criteria.patient.birthdate = this.currentPatient.getLDBirthDate();
            criteria.patient.firstname = this.currentPatient.getFirstName();
            criteria.patient.lastname = this.currentPatient.getLastName();
            criteria.patient.sex = this.currentPatient.getGender();
            criteria.patient.gmfNo = StringUtils.isNotEmpty((CharSequence)this.gmf.getNoGMF()) ? this.gmf.getNoGMF().trim() : null;
            criteria.patient.treatingProfessionnalCode = this.currentPatient.getTreatingProfessionnal().getCode().substring(0, 6);
            configuration = new B2BServiceConfiguration();
            configuration.endpointAddress = ModifierInscriptionService.getEndpoint((boolean)LibPlugin.isDebug);
            configuration.username = this.gmf.getIdMachineGMF();
            configuration.password = this.gmf.getPasswordMachineGMF();
            this.setLogToSystemOut(configuration);
            service = new ModifierInscription2(configuration, this.gmf.getIdUserGMF());
            result = service.modifInscription(ModifierInscription2.ModifTask.modifierCarSante, (Object)criteria);
            lstFautes = result.getFaults();
            lstQuest = this.setQuestionsInArray(lstFautes);
            errMsg = this.getErrorFromFautes(lstFautes);
            infoMsg = this.getInfoFromFautes(lstFautes);
            for (String msg : infoMsg) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, msg));
            }
            for (String msg : errMsg) {
                status.add((IStatus)new Status(IStatus.Severity.ERROR, msg));
            }
            if (lstQuest.size() > 0) {
                qStatus = new Status(IStatus.Severity.WARNING, "Questions");
                status.setData(lstQuest);
                status.add((IStatus)qStatus);
                continue;
            }
            if (!errMsg.isEmpty()) continue;
            if (result.getResult() != null && ((ModifierResult)result.getResult()).success) {
                B2bSituSant sant2 = new B2bSituSant();
                sant2.c = this.addZero(vuln.code);
                sant2.dd = LocalDate.fromDayFrom1970((int)vuln.date).formatHyphen();
                if (ModifierCarSanteCriteria.Action.REMOVE.equals((Object)criteria.action)) {
                    this.setDisabilityToCurrentPatient(key, null);
                    sant2.c = "00";
                    sant2.dd = null;
                } else if (ModifierCarSanteCriteria.Action.MODIFY.equals((Object)criteria.action)) {
                    this.setDisabilityToCurrentPatient(key, sant2);
                } else if (ModifierCarSanteCriteria.Action.ADD.equals((Object)criteria.action)) {
                    this.setDisabilityToCurrentPatient(key, sant2);
                }
                BasePatientDAO.getInstance().update(this.currentPatient);
                String msgSucces = "Succ\u00e8s de " + (String)todoMsg + " de la caract\u00e9ristique de sant\u00e9 '" + this.addZero(vuln.code) + "' en date du " + LocalDate.fromDayFrom1970((int)vuln.date).formatHyphen() + ".";
                Status statusOk = new Status(IStatus.Severity.OK, msgSucces);
                statusOk.setData((Serializable)new Object[]{new Integer(key - 1), sant2});
                status.add((IStatus)statusOk);
                continue;
            }
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Code de r\u00e9ponse inconnu."));
        }
        return status;
    }

    private void setLogToSystemOut(B2BServiceConfiguration configuration) {
        if (LibPlugin.isDebug) {
            LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
            loggingInInterceptor.setPrettyLogging(true);
            loggingInInterceptor.setPrintWriter(new PrintWriter(System.out));
            configuration.inInterceptors.add(loggingInInterceptor);
            LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
            loggingOutInterceptor.setPrettyLogging(true);
            loggingOutInterceptor.setPrintWriter(new PrintWriter(System.out));
            configuration.outInterceptors.add(loggingOutInterceptor);
        }
    }

    private List<String> getErrorFromFautes(List<B2bFautes> lstFautes) {
        ArrayList<String> errMessage = new ArrayList<String>();
        for (B2bFautes fautes : lstFautes) {
            List lstErr;
            if (StringUtils.isNotEmpty((CharSequence)fautes.getMessage())) {
                errMessage.add(fautes.getMessage());
            }
            if ((lstErr = fautes.getErreur()).size() <= 0) continue;
            for (MessageTraitement mte : lstErr) {
                String frMsg = mte.getFrenchMessage();
                String enMsg = mte.getEnglishMessage();
                errMessage.add(frMsg);
            }
        }
        return errMessage;
    }

    private List<String> getInfoFromFautes(List<B2bFautes> lstFautes) {
        ArrayList<String> errMessage = new ArrayList<String>();
        for (B2bFautes fautes : lstFautes) {
            List lstInfo = fautes.getInfo();
            if (lstInfo.size() <= 0) continue;
            for (MessageTraitement mte : lstInfo) {
                String frMsg = mte.getFrenchMessage();
                String enMsg = mte.getEnglishMessage();
                errMessage.add(frMsg);
            }
        }
        return errMessage;
    }

    private ArrayList<CQuest> setQuestionsInArray(List<B2bFautes> lstFautes) {
        ArrayList<CQuest> arrQst = new ArrayList<CQuest>();
        if (lstFautes != null && lstFautes.size() > 0) {
            for (B2bFautes fautes : lstFautes) {
                List lstQst = fautes.getQuestion();
                if (lstQst.size() <= 0) continue;
                for (MessageTraitement mtq : lstQst) {
                    CQuest quest = new CQuest();
                    quest.seq = mtq.getSeq();
                    String frMsg = mtq.getFrenchMessage();
                    String enMsg = mtq.getEnglishMessage();
                    quest.msg = frMsg;
                    arrQst.add(quest);
                }
            }
        }
        return arrQst;
    }

    public void doSavePatient() {
        boolean isClientLidi = DossierHibernatePlugin.getIsClientLidi();
        if (!isClientLidi) {
            this.currentPatient.save();
        }
    }

    protected void obtenirInscriptionMethod(MultiStatus status, String noProf, List<Inscription> inscriptions, List<B2bModPatientsInscr> lstNonMod, List<B2bModPatientsInscr> lstAdd, List<B2bModPatientsInscr> lstMod, List<B2bModPatientsInscr> lstDel) {
        try {
            int z = 0;
            int tot = 0;
            List<IProfessionnal> professionnals = SyraAccessorClient.getInstance().getBillingProfessionnals(noProf, null, null);
            if (professionnals != null && professionnals.size() == 1) {
                IProfessionnal pp = professionnals.get(0);
                String noSiteActif = this.gmf.getNoEtablGMF();
                CProfessionnalPrefData prefData = SyraAccessorClient.getInstance().getPrefData(pp.getId());
                String profSites = prefData.prefAutre.get("gmf");
                System.out.println(profSites);
                List listIdPatientsInscrit = BasePatientDAO.getInstance().getPatientInscrit(pp.getId());
                ArrayList<String[]> listPatientModVuln = new ArrayList<String[]>();
                for (Inscription inscr : inscriptions) {
                    if (inscr.endDate != null) continue;
                    ++tot;
                }
                for (Inscription inscr : inscriptions) {
                    int item;
                    Integer id = this.importPatients(status, inscr, pp, listPatientModVuln, lstNonMod, lstAdd, lstMod, lstDel);
                    if (id != null && listIdPatientsInscrit != null && listIdPatientsInscrit.size() > 0 && (item = Collections.binarySearch(listIdPatientsInscrit, id)) > -1) {
                        listIdPatientsInscrit.remove(item);
                    }
                    if (++z % 20 != 0) continue;
                    CTypeObject to3 = new CTypeObject("b2bObtenirInscrType", "MD " + noProf + "<br><b>Importation " + String.valueOf(z) + "</b> / " + String.valueOf(tot));
                    String message3 = new GsonBuilder().create().toJson((Object)to3);
                    HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                }
                CTypeObject to3 = new CTypeObject("b2bObtenirInscrType", "MD " + noProf + "<br><b>Importation " + String.valueOf(z) + "</b> / " + String.valueOf(tot));
                String message3 = new GsonBuilder().create().toJson((Object)to3);
                HtmlBrowserTools.sendMessageToWebClient((String)this.uid, (String)message3);
                if (listIdPatientsInscrit != null && listIdPatientsInscrit.size() > 0) {
                    ArrayList<Integer> lstPtToRemoveSameSite = new ArrayList<Integer>();
                    List listPatientByIds = BasePatientDAO.getInstance().getListPatientByIds(listIdPatientsInscrit);
                    if (listPatientByIds != null) {
                        for (Patient pt : listPatientByIds) {
                            if (pt.getLieuSuivi() != null && !pt.getLieuSuivi().endsWith(noSiteActif)) continue;
                            lstPtToRemoveSameSite.add(pt.getId());
                            B2bModPatientsInscr i = new B2bModPatientsInscr(noProf, pt.getHealthInsuranceNumber(), pt.getLastName(), pt.getFirstName(), pt.getBirthDate() == null ? null : DateUtil.dtoc((Calendar)pt.getBirthDate()), pt.getGender());
                            i.addA(4);
                            lstDel.add(i);
                        }
                    }
                    if (lstPtToRemoveSameSite.size() > 0) {
                        BasePatientDAO.getInstance().setPatientNonInscrit(lstPtToRemoveSameSite);
                    }
                }
                long lastVerDate = Calendar.getInstance().getTimeInMillis();
                BasePatientDAO.getInstance().setPatientLastVerificationDate(pp.getId(), lastVerDate);
            }
        }
        catch (Exception e) {
            LibPlugin.log((String)"Erreur", (Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer importPatients(MultiStatus status, Inscription inscr, IProfessionnal professionnal, List<String[]> listPatientModVuln, List<B2bModPatientsInscr> lstNonMod, List<B2bModPatientsInscr> lstAdd, List<B2bModPatientsInscr> lstMod, List<B2bModPatientsInscr> lstDel) {
        Integer idPatient = null;
        try {
            boolean inscrChangedAddProf;
            boolean inscrChanged;
            boolean personChanged;
            boolean changedCarSant;
            boolean changed;
            B2bModPatientsInscr i;
            Patient patient;
            block82: {
                ArrayList<B2bSituSant> situSant;
                block84: {
                    block83: {
                        String repre_nam;
                        String newStartDate;
                        String actualStartDate;
                        String newFUDate;
                        String actualFUDate;
                        boolean sameLieu;
                        String noProf = professionnal.getCode().trim();
                        String lieu = inscr.followUpLocation;
                        String newLieu = "";
                        if (StringUtils.isNotEmpty((CharSequence)lieu)) {
                            newLieu = lieu.startsWith("6") ? "N~3~" + lieu : "C~" + lieu;
                        }
                        PatientIdentification pers_assu = inscr.patient;
                        Calendar dbStartDateInscr = inscr.startDate == null ? null : DateUtil.getDateFromLong((long)inscr.startDate);
                        Calendar dbFULocDateInscr = inscr.followUpLocationDate == null ? null : DateUtil.getDateFromLong((long)inscr.followUpLocationDate);
                        PatientIdentification repres = inscr.patientRepresentant == null || inscr.patientRepresentant.lastname == null || inscr.patientRepresentantType == null ? null : inscr.patientRepresentant;
                        String residNo = inscr.residentCode == null ? null : inscr.residentCode;
                        situSant = new ArrayList<B2bSituSant>();
                        B2bSituSant ss1 = new B2bSituSant();
                        B2bSituSant ss2 = new B2bSituSant();
                        B2bSituSant ss3 = new B2bSituSant();
                        List ss = inscr.situSant;
                        if (ss != null && ss.size() > 0) {
                            ss1.c = this.addZero(((InscriptionSituSant)ss.get((int)0)).code, 2);
                            ss1.dd = ((InscriptionSituSant)ss.get((int)0)).startDate.formatHyphen();
                            if (ss.size() > 1) {
                                ss2.c = this.addZero(((InscriptionSituSant)ss.get((int)1)).code, 2);
                                ss2.dd = ((InscriptionSituSant)ss.get((int)1)).startDate.formatHyphen();
                                if (ss.size() > 2) {
                                    ss3.c = this.addZero(((InscriptionSituSant)ss.get((int)2)).code, 2);
                                    ss3.dd = ((InscriptionSituSant)ss.get((int)2)).startDate.formatHyphen();
                                }
                            }
                        }
                        situSant.add(ss1);
                        situSant.add(ss2);
                        situSant.add(ss3);
                        Collections.sort(situSant);
                        patient = null;
                        Calendar ddn = null;
                        if (pers_assu.birthdate != null) {
                            ddn = DateUtil.getDateFromLong((long)pers_assu.birthdate);
                        }
                        if (pers_assu.nam != null) {
                            patient = BasePatientDAO.getInstance().findByHealthInsuranceNumber(pers_assu.nam);
                        } else {
                            List lstPatient = BasePatientDAO.getInstance().findNewBorn(pers_assu.firstname, pers_assu.lastname, pers_assu.sex, ddn);
                            if (lstPatient != null) {
                                if (lstPatient.size() == 1) {
                                    patient = (Patient)lstPatient.get(0);
                                } else if (lstPatient.size() > 1) {
                                    try {
                                        String ptData = "Importation B2B - Plus d'un patient trouv\u00e9 (" + lstPatient.size() + ") - donn\u00e9es non synchronis\u00e9es pour " + ((Patient)lstPatient.get(0)).getName() + ", " + DateUtil.dtoc((Calendar)((Patient)lstPatient.get(0)).getPerson().getBirthDate());
                                        LibPlugin.log((String)ptData, null);
                                        status.add((IStatus)new Status(IStatus.Severity.WARNING, ptData));
                                    }
                                    catch (Exception e) {
                                        LibPlugin.log((String)"Importation B2B - Plus d'un patient trouv\u00e9", (Exception)e);
                                    }
                                }
                            }
                        }
                        XDisabilityCode disCode00 = XDisabilityCode.C00;
                        if (patient == null) {
                            String repre_nam2;
                            if (inscr.endDate != null) {
                                return null;
                            }
                            if (inscr.endDate != null) return idPatient;
                            i = new B2bModPatientsInscr(noProf, inscr.patient.nam, inscr.patient.lastname, inscr.patient.firstname, inscr.patient.birthdate == null ? null : DateUtil.dtoc((long)inscr.patient.birthdate), inscr.patient.sex);
                            i.addA(2);
                            String note = "Ajout B2B RAMQ. ";
                            patient = new Patient();
                            patient.setHealthInsuranceNumber(pers_assu.nam != null ? pers_assu.nam : "");
                            patient.setPatientRecordNumber(Patient.getFormatedNextPatientRecordNumber());
                            patient.setTreatingProfessionnal(professionnal);
                            patient.setPerson((IPerson)new Person());
                            patient.getPerson().setFirstName(pers_assu.firstname);
                            patient.getPerson().setLastName(pers_assu.lastname);
                            patient.getPerson().setBirthDate(ddn);
                            patient.getPerson().setGender(pers_assu.sex);
                            patient.getPerson().setLanguageCode(inscr.languageCode);
                            patient.getPerson().setNote(note);
                            patient.getPerson().save();
                            patient.setIsInscritGMF(inscr.status);
                            B2bSituSant sant = (B2bSituSant)situSant.get(0);
                            if ("00".equals(sant.c)) {
                                patient.setDisabilityCode1(disCode00);
                                patient.setDisabilityDate(null);
                            } else {
                                patient.setDisabilityCode1(XDisabilityCode.fromCode((String)sant.c));
                                patient.setDisabilityDate(sant.dd != null ? DateUtil.ctod((String)sant.dd) : null);
                            }
                            sant = (B2bSituSant)situSant.get(1);
                            if ("00".equals(sant.c)) {
                                patient.setDisabilityCode2(disCode00);
                                patient.setDisabilityDate2Calendar(null);
                            } else {
                                patient.setDisabilityCode2(XDisabilityCode.fromCode((String)sant.c));
                                patient.setDisabilityDate2Calendar(sant.dd != null ? DateUtil.ctod((String)sant.dd) : null);
                            }
                            sant = (B2bSituSant)situSant.get(2);
                            if ("00".equals(sant.c)) {
                                patient.setDisabilityCode3(disCode00);
                                patient.setDisabilityDate3Calendar(null);
                            } else {
                                patient.setDisabilityCode3(XDisabilityCode.fromCode((String)sant.c));
                                patient.setDisabilityDate3Calendar(sant.dd != null ? DateUtil.ctod((String)sant.dd) : null);
                            }
                            patient.setFollowUpLocationDateCalendar(dbFULocDateInscr);
                            if (StringUtils.isNotEmpty((CharSequence)newLieu)) {
                                patient.setLieuSuivi(newLieu);
                            }
                            patient.setDateInscriptionCalendar(dbStartDateInscr);
                            if (repres != null && (repre_nam2 = repres.nam) != null) {
                                Patient patientRepr = BasePatientDAO.getInstance().findByHealthInsuranceNumber(repre_nam2);
                                if (patientRepr == null) {
                                    String newNom = repres.lastname;
                                    String newPre = repres.firstname;
                                    boolean isCompleteData = true;
                                    patientRepr = BasePatientDAO.getInstance().addSimplePatient(repre_nam2, "", "", professionnal, newNom, newPre, isCompleteData);
                                }
                                if (patientRepr != null) {
                                    patient.setPatientRepresentant(patientRepr);
                                    patient.setPatientRepresentantType(inscr.patientRepresentantType);
                                }
                            }
                            if (residNo != null) {
                                Professionnal residProf = BaseProfessionnalDAO.getInstance().findByCode(residNo);
                                if (residProf == null) {
                                    String newNom = "Resident";
                                    String newPre = "AjoutB2b";
                                    residProf = BaseProfessionnalDAO.getInstance().addSimpleProfessionnal(residNo, newNom, newPre);
                                }
                                if (residProf != null) {
                                    patient.setResident(residProf);
                                }
                            }
                            patient.save();
                            System.out.println(patient.getId() + ": " + patient.getHealthInsuranceNumber());
                            lstAdd.add(i);
                            return idPatient;
                        }
                        if (inscr.endDate != null) {
                            if (patient.getTreatingProfessionnal() == null) return patient.getId();
                            if (professionnal.getId().equals(patient.getTreatingProfessionnal().getId())) return patient.getId();
                            return null;
                        }
                        i = new B2bModPatientsInscr(noProf, inscr.patient.nam, inscr.patient.lastname, inscr.patient.firstname, inscr.patient.birthdate == null ? null : DateUtil.dtoc((long)inscr.patient.birthdate), inscr.patient.sex);
                        idPatient = patient.getId();
                        changed = false;
                        changedCarSant = false;
                        personChanged = false;
                        inscrChanged = false;
                        inscrChangedAddProf = false;
                        boolean ptNullLieu = patient.getLieuSuivi() == null;
                        boolean bl = sameLieu = !ptNullLieu && patient.getLieuSuivi().endsWith(lieu);
                        if (!patient.getPerson().getFirstName().trim().toLowerCase().startsWith(pers_assu.firstname.trim().toLowerCase())) {
                            i.addModif(128, StringUtils.isEmpty((CharSequence)patient.getPerson().getFirstName()) ? "\u00f8" : patient.getPerson().getFirstName().trim(), pers_assu.firstname);
                            patient.getPerson().setFirstName(pers_assu.firstname);
                            personChanged = true;
                        }
                        if (!patient.getPerson().getLastName().trim().toLowerCase().startsWith(pers_assu.lastname.trim().toLowerCase())) {
                            i.addModif(128, StringUtils.isEmpty((CharSequence)patient.getPerson().getLastName()) ? "\u00f8" : patient.getPerson().getLastName().trim(), pers_assu.lastname);
                            patient.getPerson().setLastName(pers_assu.lastname);
                            personChanged = true;
                        }
                        if (!patient.getPerson().getGender().equals(pers_assu.sex)) {
                            i.addModif(128, "sexe de " + (StringUtils.isEmpty((CharSequence)patient.getPerson().getGender()) ? "\u00f8" : patient.getPerson().getGender()), pers_assu.sex);
                            patient.getPerson().setGender(pers_assu.sex);
                            personChanged = true;
                        }
                        if (personChanged) {
                            patient.getPerson().save();
                            System.out.println("MODIFIED person: " + patient.getName());
                        }
                        if (inscr.status == 2) {
                            if (patient.getIsInscritGMF() != 2) {
                                patient.setIsInscritGMF(new Integer(2));
                                i.addA(2);
                                lstAdd.add(i);
                                inscrChanged = true;
                            }
                        } else {
                            if (patient.getIsInscritGMF() != 2) return null;
                            if (patient.getTreatingProfessionnal() != null) {
                                if (!professionnal.getId().equals(patient.getTreatingProfessionnal().getId())) return null;
                            }
                            if (!sameLieu) return null;
                            patient.setIsInscritGMF(new Integer(0));
                            i.addA(4);
                            lstDel.add(i);
                            inscrChanged = true;
                        }
                        if (i.isDeleting() || patient.getIsInscritGMF() != 2 || !sameLieu) break block82;
                        if (patient.getTreatingProfessionnal() == null || professionnal.getId().intValue() != patient.getTreatingProfessionnal().getId().intValue()) {
                            patient.setTreatingProfessionnal(professionnal);
                            if (!i.isAdding() && !i.isDeleting()) {
                                i.addA(2);
                                lstAdd.add(i);
                            }
                            inscrChangedAddProf = true;
                        }
                        if (inscr.endReason == null && (patient.getCodeRaisonStatut() == null || patient.getCodeRaisonStatut() != 0)) {
                            patient.setCodeRaisonStatut(new Integer(0));
                            changed = true;
                        }
                        if (inscr.endReason != null && (patient.getCodeRaisonStatut() == null || patient.getCodeRaisonStatut().intValue() != inscr.endReason.intValue())) {
                            patient.setCodeRaisonStatut(inscr.endReason);
                            changed = true;
                        }
                        if (patient.getCodeRaisonStatut() == null) {
                            patient.setCodeRaisonStatut(new Integer(0));
                        }
                        if (!(actualFUDate = DateUtil.dtos((Calendar)patient.getFollowUpLocationDateCalendar())).equals(newFUDate = DateUtil.dtos((Calendar)dbFULocDateInscr))) {
                            i.addModif(256, actualFUDate.length() == 0 ? "\u00f8" : actualFUDate, newFUDate);
                            patient.setFollowUpLocationDateCalendar(dbFULocDateInscr);
                            changed = true;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)patient.getLieuSuivi())) {
                            String[] actualLieu = patient.getLieuSuivi().split("~");
                            String actLieu = actualLieu[actualLieu.length - 1];
                            if (!actLieu.equals(lieu)) {
                                i.addModif(512, actLieu, lieu);
                                patient.setLieuSuivi(newLieu);
                                changed = true;
                            }
                        } else if (StringUtils.isNotEmpty((CharSequence)lieu)) {
                            i.addModif(512, "\u00f8", lieu);
                            patient.setLieuSuivi(newLieu);
                            changed = true;
                        }
                        if (!(actualStartDate = DateUtil.dtos((Calendar)patient.getDateInscriptionCalendar())).equals(newStartDate = DateUtil.dtos((Calendar)dbStartDateInscr))) {
                            i.addModif(16, actualStartDate.length() == 0 ? "\u00f8" : actualStartDate, newStartDate);
                            patient.setDateInscriptionCalendar(dbStartDateInscr);
                            changed = true;
                        }
                        if (repres != null && (repre_nam = repres.nam) != null) {
                            Patient patientRepr = BasePatientDAO.getInstance().findByHealthInsuranceNumber(repre_nam);
                            if (patientRepr == null) {
                                String newNom = repres.lastname;
                                String newPre = repres.firstname;
                                boolean isCompleteData = true;
                                patientRepr = BasePatientDAO.getInstance().addSimplePatient(repre_nam, "", "", professionnal, newNom, newPre, isCompleteData);
                            }
                            if (patientRepr == null) {
                                if (patient.getPatientRepresentant() != null) {
                                    i.addModif(32, patient.getPatientRepresentant().getName(), "\u00f8");
                                    patient.setPatientRepresentant(null);
                                    patient.setPatientRepresentantType(new Integer(0));
                                    changed = true;
                                }
                            } else if (patient.getPatientRepresentant() == null) {
                                patient.setPatientRepresentant(patientRepr);
                                i.addModif(32, "\u00f8", patient.getPatientRepresentant().getName());
                                patient.setPatientRepresentantType(inscr.patientRepresentantType);
                                changed = true;
                            } else if (patientRepr.getId().intValue() != patient.getPatientRepresentant().getId().intValue()) {
                                i.addModif(32, patient.getPatientRepresentant().getName(), patientRepr.getName());
                                patient.setPatientRepresentant(patientRepr);
                                patient.setPatientRepresentantType(inscr.patientRepresentantType);
                                changed = true;
                            }
                        }
                        if (residNo == null) break block83;
                        Professionnal residProf = BaseProfessionnalDAO.getInstance().findByCode(residNo);
                        if (residProf == null) {
                            String newNom = "Resident";
                            String newPre = "Ajout";
                            residProf = BaseProfessionnalDAO.getInstance().addSimpleProfessionnal(residNo, newNom, newPre);
                        }
                        if (residProf != null) {
                            if (patient.getResident() == null) {
                                i.addModif(64, "\u00f8", residProf.getName());
                                patient.setResident(residProf);
                                changed = true;
                                break block84;
                            } else if (patient.getResident().getId() == null || residProf.getId().intValue() != patient.getResident().getId().intValue()) {
                                i.addModif(64, patient.getResident().getCodeAndName(), residProf.getName());
                                patient.setResident(residProf);
                                changed = true;
                            }
                        }
                        break block84;
                    }
                    if (patient.getResident() != null) {
                        block81: {
                            try {
                                i.addModif(64, patient.getResident().getCodeAndName(), "\u00f8");
                            }
                            catch (Exception e) {
                                if (patient.getResident().getCode() == null) break block81;
                                i.addModif(64, patient.getResident().getCode(), "\u00f8");
                            }
                        }
                        patient.setResident(null);
                        changed = true;
                    }
                }
                ArrayList<B2bSituSant> actualSant = new ArrayList<B2bSituSant>();
                B2bSituSant ass1 = new B2bSituSant();
                B2bSituSant ass2 = new B2bSituSant();
                B2bSituSant ass3 = new B2bSituSant();
                if (patient.getDisabilityCode1() == null || "00".equals(patient.getDisabilityCode1().getCode2chifres())) {
                    ass1.c = "00";
                } else {
                    ass1.c = patient.getDisabilityCode1().getCode2chifres();
                    String string = ass1.dd = patient.getDisabilityDate() == null ? null : LocalDate.fromCalendar((Calendar)patient.getDisabilityDate()).formatHyphen();
                }
                if (patient.getDisabilityCode2() == null || "00".equals(patient.getDisabilityCode2().getCode2chifres())) {
                    ass2.c = "00";
                } else {
                    ass2.c = patient.getDisabilityCode2().getCode2chifres();
                    String string = ass2.dd = patient.getDisabilityDate2Calendar() == null ? null : LocalDate.fromCalendar((Calendar)patient.getDisabilityDate2Calendar()).formatHyphen();
                }
                if (patient.getDisabilityCode3() == null || "00".equals(patient.getDisabilityCode3().getCode2chifres())) {
                    ass3.c = "00";
                } else {
                    ass3.c = patient.getDisabilityCode3().getCode2chifres();
                    ass3.dd = patient.getDisabilityDate3Calendar() == null ? null : LocalDate.fromCalendar((Calendar)patient.getDisabilityDate3Calendar()).formatHyphen();
                }
                actualSant.add(ass1);
                actualSant.add(ass2);
                actualSant.add(ass3);
                Collections.sort(actualSant);
                int ii = 0;
                while (ii < situSant.size()) {
                    if (!((B2bSituSant)situSant.get(ii)).equals(actualSant.get(ii))) {
                        changedCarSant = true;
                        break;
                    }
                    ++ii;
                }
                if (changedCarSant) {
                    String actualVulnCode = String.valueOf(patient.getAllDisabilityCodes()) + " : " + patient.getAllDisabilityDates();
                    patient.setDisabilityCode1(XDisabilityCode.fromCode((String)((B2bSituSant)situSant.get((int)0)).c));
                    patient.setDisabilityDate(DateUtil.ctod((String)((B2bSituSant)situSant.get((int)0)).dd));
                    patient.setDisabilityCode2(XDisabilityCode.fromCode((String)((B2bSituSant)situSant.get((int)1)).c));
                    patient.setDisabilityDate2Calendar(DateUtil.ctod((String)((B2bSituSant)situSant.get((int)1)).dd));
                    patient.setDisabilityCode3(XDisabilityCode.fromCode((String)((B2bSituSant)situSant.get((int)2)).c));
                    patient.setDisabilityDate3Calendar(DateUtil.ctod((String)((B2bSituSant)situSant.get((int)2)).dd));
                    i.addModif(8, actualVulnCode, String.valueOf(patient.getAllDisabilityCodes()) + " : " + patient.getAllDisabilityDates());
                }
            }
            if (!(changed || changedCarSant || personChanged || inscrChangedAddProf || inscrChanged)) {
                i.addA(1);
                lstNonMod.add(i);
                return idPatient;
            }
            i.setTxModif();
            if (!i.isAdding() && !i.isDeleting()) {
                lstMod.add(i);
            }
            try {
                patient.save();
                return idPatient;
            }
            catch (Exception e) {
                status.add((IStatus)new Status(IStatus.Severity.WARNING, "Erreur save patient. " + InscriptionB2bMethods.getStringFromException(e)));
                LibPlugin.log((String)"Erreur save patient", (Exception)e);
                String oldNodossier = patient.getPatientRecordNumber();
                if (BasePatientDAO.getInstance().findPatientByRecordNumber(oldNodossier) == null) return idPatient;
                patient.setPatientRecordNumber(BasePatientDAO.getInstance().getUniqueNextNoDossierTemporary());
                patient.getPerson().setNote(String.valueOf(patient.getPerson().getNote()) + "\n" + "Ancien no duplique lors importation GMF B2B: " + oldNodossier);
                try {
                    patient.getPerson().save();
                    patient.save();
                    return idPatient;
                }
                catch (Exception e1) {
                    status.add((IStatus)new Status(IStatus.Severity.WARNING, "2e erreur save patient - on abandonne."));
                    LibPlugin.log((String)"2e Erreur save patient - j'abandonne.", (Exception)e);
                    return idPatient;
                }
            }
        }
        catch (Exception e) {
            status.add((IStatus)new Status(IStatus.Severity.WARNING, "Erreur importPatient. " + InscriptionB2bMethods.getStringFromException(e)));
            LibPlugin.log((String)"Erreur", (Exception)e);
        }
        return idPatient;
    }

    public String validNoProf(String psNoProf) {
        String sNoProf = psNoProf.trim();
        try {
            if (sNoProf.length() < 6 || Integer.valueOf(sNoProf) == 0) {
                return "";
            }
        }
        catch (NumberFormatException e) {
            return "";
        }
        int[] pNo = new int[6];
        int x = 0;
        int i = 5;
        while (i > 0) {
            pNo[x] = Integer.parseInt(String.valueOf(sNoProf.charAt(i)));
            ++x;
            --i;
        }
        pNo[0] = InscriptionB2bMethods.noMdadd(pNo[0]);
        pNo[2] = InscriptionB2bMethods.noMdadd(pNo[2]);
        pNo[4] = InscriptionB2bMethods.noMdadd(pNo[4]);
        pNo[5] = 1;
        int iTotal = pNo[0] + pNo[1] + pNo[2] + pNo[3] + pNo[4] + pNo[5];
        String sPt = new StringBuffer(3).append("0").append(new Integer(iTotal).toString()).toString();
        sPt = sPt.length() == 2 ? sPt : sPt.substring(1);
        int pValver = 10 - Integer.valueOf(sPt.substring(1, 2));
        pValver = pValver == 10 ? 0 : pValver;
        Integer pValr = new Integer(pValver);
        return pValr.toString();
    }

    private static int noMdadd(int pNombre) {
        int z = pNombre * 2;
        if (z > 9) {
            String p = String.valueOf(z);
            int x = Integer.parseInt(p.substring(0, 1));
            int y = Integer.parseInt(p.substring(1, 2));
            return x + y;
        }
        return z;
    }

    protected void setModifiedDisability(XDisabilityCode d, int p) {
        switch (p) {
            case 1: {
                this.currentPatient.setDisabilityCode1(d);
                if (this.currentPatient.getDisabilityDate() != null) break;
                this.currentPatient.setDisabilityDate(Calendar.getInstance());
                break;
            }
            case 2: {
                this.currentPatient.setDisabilityCode2(d);
                if (this.currentPatient.getDisabilityDate2Calendar() != null) break;
                this.currentPatient.setDisabilityDate2Calendar(Calendar.getInstance());
                break;
            }
            case 3: {
                this.currentPatient.setDisabilityCode3(d);
                if (this.currentPatient.getDisabilityDate3Calendar() != null) break;
                this.currentPatient.setDisabilityDate3Calendar(Calendar.getInstance());
                break;
            }
        }
    }

    protected void setModifiedDisabilityDate(Calendar c, int p) {
        switch (p) {
            case 1: {
                this.currentPatient.setDisabilityDate(c);
                break;
            }
            case 2: {
                this.currentPatient.setDisabilityDate2Calendar(c);
                break;
            }
            case 3: {
                this.currentPatient.setDisabilityDate3Calendar(c);
                break;
            }
        }
    }

    protected String addZero(String s, int l) {
        String ss;
        int ll;
        String c = s == null ? "00000000000".substring(0, l) : ((ll = (ss = s.trim()).length()) < l ? String.valueOf("00000000000".substring(0, l - ll)) + ss : ss);
        return c;
    }

    protected String addZero(int s) {
        String c = s < 10 ? "0" + String.valueOf(s) : String.valueOf(s);
        return c;
    }

    public static String getStringFromException(Exception e) {
        StringWriter errors = new StringWriter();
        PrintWriter writer = new PrintWriter(errors);
        e.printStackTrace(writer);
        String s = errors.toString();
        try {
            writer.close();
            errors.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s;
    }

    public static enum CODE_RAISON_FIN {
        S_O(new Integer(0), "-"),
        CR1(new Integer(1), "D\u00e9m\u00e9nagement de la personne assur\u00e9e"),
        CR2(new Integer(2), "A la demande du professionnel"),
        CR3(new Integer(3), "D\u00e9part volontaire de la personne assur\u00e9e");

        private final Integer id;
        private final String t;

        private CODE_RAISON_FIN(Integer i, String s) {
            this.id = i;
            this.t = s;
        }

        public String getTexte() {
            return this.t;
        }

        public Integer getId() {
            return this.id;
        }

        public static CODE_RAISON_FIN fromId(Integer i) {
            CODE_RAISON_FIN[] cODE_RAISON_FINArray = CODE_RAISON_FIN.values();
            int n = cODE_RAISON_FINArray.length;
            int n2 = 0;
            while (n2 < n) {
                CODE_RAISON_FIN v = cODE_RAISON_FINArray[n2];
                if (v.id.equals(i)) {
                    return v;
                }
                ++n2;
            }
            return S_O;
        }
    }

    protected class ListVulnerabilites {
        int code;
        int date;
        int prevCode;
        int prevDate;
        TODO toDo = TODO.S_O;

        ListVulnerabilites(int c, int d) {
            this.code = c;
            this.date = d;
            this.prevCode = c;
            this.prevDate = d;
        }

        public final int getCode() {
            return this.code;
        }

        public final void setCode(int code) {
            this.code = code;
        }

        public final int getDate() {
            return this.date;
        }

        public final void setDate(int date) {
            this.date = date;
        }

        public final void setToDo(TODO t) {
            this.toDo = t;
        }

        public final TODO getToDo() {
            return this.toDo;
        }
    }

    static enum TODO {
        S_O(new Integer(0), "-"),
        ADD(new Integer(1), AJOUTER_VULN),
        MOD(new Integer(2), MODIFIER_VULN),
        DEL(new Integer(3), SUPPRIMER_VULN);

        private final Integer id;
        private final String f;

        private TODO(Integer i, String s) {
            this.id = i;
            this.f = s;
        }

        public String getToDo() {
            return this.f;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

