
function DrawZone(idCanvas, idInput, ajustLeft, ajustTop, debug) {
	this.idCanvas = idCanvas || null;
	this.idInput = idInput || null;
	this.debugMode = debug || false;
	this.ajustLeft = ajustLeft || 0;
	this.ajustTop = ajustTop || 0;
	
	this.actColor = "rgb(0,0,0)";
	this.actSize = 1
	this.actColor = "DrawLine";
	
	this.painting = false;
	this.canvas = null;
	this.context = null;
	this.actLine = null;
	
	
	this.init = function() {
		if (this.canGo()) {
			__draw_tool_bar.setDrawer(this);
			this.canvas.css("cursor","crosshair");
			var that = this;
			if('ontouchstart' in window == true){
				this.canvas[0].addEventListener("touchstart",function(e) {
					e.preventDefault();
					__draw_tool_bar.setDrawer(that);
					logDrawer("DrawZone.touchstart");
					that.actLine = __Object_Register.buildObjectFromClassName(that.actTool);// new DrawLine();
					that.actLine.color = that.actColor;
					that.actLine.size = that.actSize;
					x = Math.round((e.pageX - $(this).offset().left)+that.ajustLeft);
					y = Math.round((e.pageY - $(this).offset().top)+that.ajustTop);
					that.actLine.addPoint(x, y);
					that.drawSaver.addLine(that.actLine);
					that.painting = true;
				},false);
				this.canvas[0].addEventListener("touchmove", function(e) {
					e.preventDefault();
					$("#position").text( Math.round((e.pageX - $(this).offset().left) - 10+that.ajustLeft) +" :: "+Math.round((e.pageY - $(this).offset().top) - 10+that.ajustTop));
					if (that.painting) {
						// Set Coordonn?es de la souris :
						x = Math.round((e.pageX - $(this).offset().left)+that.ajustLeft); // 10 = d?calage du curseur
						y = Math.round((e.pageY - $(this).offset().top)+that.ajustTop);
						// Dessine une ligne :
						that.actLine.addPoint(x,y, that.context);
					}
				},false);
				this.canvas[0].addEventListener("touchend", function(e) {
					logDrawer("DrawZone.touchestop :");
					if (that.painting) {
						that.painting = false;
						that.actLine.finish();
						that.drawSaver.save();
					}
				},false);
			}
			// Click souris enfonce sur le canvas, je dessine :
			this.canvas.mousedown(function(e) {
				__draw_tool_bar.setDrawer(that);
				logDrawer("DrawZone.mousedown");
				that.actLine = __Object_Register.buildObjectFromClassName(that.actTool);// new DrawLine();
				that.actLine.color = that.actColor;
				that.actLine.size = that.actSize;
				x = Math.round((e.pageX - $(this).offset().left)+that.ajustLeft);
				y = Math.round((e.pageY - $(this).offset().top)+that.ajustTop);
				that.actLine.addPoint(x, y);
				that.drawSaver.addLine(that.actLine);
				that.painting = true;
			});
			
			$(document).mouseup(function() {
				logDrawer("DrawZone.mouseup :");
				if (that.painting) {
					that.painting = false;
					that.actLine.finish();
					that.drawSaver.save();
				}
				
			});

			// Mouvement de la souris sur le canvas :
			this.canvas.mousemove(function(e) {
				// Si je suis en train de dessiner (click souris enfonc?) :
				$("#position").text( Math.round((e.pageX - $(this).offset().left) - 10+that.ajustLeft) +" :: "+Math.round((e.pageY - $(this).offset().top) - 10+that.ajustTop));
				if (that.painting) {
					// Set Coordonn?es de la souris :
					x = Math.round((e.pageX - $(this).offset().left)+that.ajustLeft); // 10 = d?calage du curseur
					y = Math.round((e.pageY - $(this).offset().top)+that.ajustTop);
					// Dessine une ligne :
					that.actLine.addPoint(x,y, that.context);
				}
			});
		}
	}
	
	
	this.canGo = function() {
		return this.idCanvas != null && this.idInput != null;
	}
	
	this.clear = function() {
		this.drawSaver.clear();
	}
	
	if ( __isDrawable() ) {
		//Draw var
		this.canvas = $("#"+this.idCanvas);
		this.context = this.canvas[0].getContext('2d');
		// Trait arrondi :
		this.context.lineJoin = 'round';
		this.context.lineCap = 'round';
		this.drawSaver = new CanvasData(this.idInput, this.context, this.canvas);
		
		try {
			this.init();
			this.drawSaver.checkForLoad();
		} catch(err) { /*alert(err)*/};
	} else {
		this.showImpossible();
	}
}

function LineOptimiser() {
	this.toOptimises = new Array();
	this.lastTime = 0;
	this.timeLap = 750;
	this.offLap = 1000;
	
	this.optimizedAngle = 15;
	
	this.pushToOptimise = function(line, drawer) {
		this.updateLastTime();
		this.toOptimises.push({line: line, drawer: drawer});
	}
	
	this.updateLastTime = function() {
		this.lastTime = (new Date()).getTime();
	}

	this.canOptimise = function() {
		if (this.lastTime + this.offLap > (new Date()).getTime() ) {
			logDrawer("optimise plus tard ..."+this.lastTime);
			return false;
		}

		return true;
	}
	
	this.optimizeLine = function(lineObj) {
		var x = lineObj.line.x;
		var y = lineObj.line.y;

		var nX = new Array();
		var nY = new Array();
		var p1;
		var p2;
		var c;
		var count = 0;
		for (var i = 0; i < x.length; i++) {
			c = {x:x[i],y:y[i]};
			var mustAdd = true;
			if (i > 0 && i < x.length-1) {
				p2 = {x:x[i+1],y:y[i+1]};
				var dist = find_run_distance(p1,p2,c);
				var distTolerance = (this.size || 1) * 1.25+2;
//				logDrawer("dist: "+dist+"/"+distTolerance);
				var a = find_angle(p1,p2,c);
				if (
					dist < distTolerance
					|| a > 180-this.optimizedAngle && a < 180+this.optimizedAngle
				) {
					mustAdd = false;
				}
			}
			if (mustAdd){
				count++;
				p1 = {x:x[i],y:y[i]};
				nX.push(x[i]);
				nY.push(y[i]);
			}
		}
		lineObj.line.x = nX;
		lineObj.line.y = nY;
		if (x.length == nX.length) {
			lineObj.line.optimized = true
		}
	}
	this.loopOptimise = function() {
		if ( this.canOptimise() ) {
			
			var li = this.toOptimises.pop();
			
			if (typeof(li) != 'undefined' && li != null) {
				logDrawer("optimiseLine");
				
				li.line.optimized = true;
				//Optimiser
				this.optimizeLine(li);
				//Voir si ca a optimiser qqchose
				if ( li.line.optimized ) {
					li.drawer.save();
				} else {
					this.toOptimises.push(li);
				}
			}
		}
		var that = this;
		setTimeout(function(){that.loopOptimise();}, this.timeLap);
	}
	this.loopOptimise();
}

function RedrawReporter() {
	this.drawers = new Array();
	this.timeLap = 500;
	this.lastTime = 0;
	
	this.pushToRedraw = function(drawer) {
		var dObj = this.getDrawerObj(drawer);
		dObj.toRedraw = true;
	}
	
	this.setPaintingState = function(drawer, painting) {
		var dObj = this.getDrawerObj(drawer);
		dObj.painting = painting;
	}
	this.setPainting = function(drawer) {
		var dObj = this.getDrawerObj(drawer);
		dObj.toRedraw = true;
		this.lastTime = (new Date()).getTime();
	}
	
	
	this.getDrawerObj = function(drawer) {
		var oldD = null;
		for (var i = 0; i < this.drawers.length; i++) {
			if ( this.drawers[i].drawer.id == drawer.id ) {
				oldD = this.drawers[i];
				break;
			}
		}
		
		if (oldD == null) {
			oldD = {drawer: drawer, paiting: false, toRedraw: false};
			this.drawers.push(oldD);
		}
		return oldD;
	}
	
	this.canRedraw = function() {
		if (this.lastTime + this.timeLap > (new Date()).getTime() ) {
			logDrawer("redraw plus tard ..."+this.lastTime);
			return false;
		}

		return true;
	}
	
	this.loopRedraw = function() {
		if ( this.canRedraw() ) {
			for (var i = 0; i < this.drawers.length; i++) {
				if ( this.drawers[i].toRedraw ) {
					logDrawer("Redraw");
					this.drawers[i].drawer.redraw();
					this.drawers[i].toRedraw = false;
					break;
				}
			}
		}
		var that = this;
		setTimeout(function(){that.loopRedraw();}, this.timeLap);
	}
	this.loopRedraw();
}


/**
 *	Gre la sauvegarde et la mise en optimisation des lignes
 *	
 *	
 */
var _can_data_count = 0;
function CanvasData(idInput, context, canvas) {
	this.id = _can_data_count++;
	this.lines = new Array();
	this.idInput = idInput || null;
	this.context = context;
	this.canvas = canvas;
	
	this.addLine = function(line) {
		this.maxCount = 0;
		this.lines.push(line);
	}
	
	this.redraw = function() {
		this.context.clearRect(0,0, this.canvas.width(), this.canvas.height());
		for (var i = 0; i < this.lines.length; i++) {
			this.lines[i].drawOnCanvas(this.context);
		}
	}
	
	this.clear = function() {
		this.lines = new Array();
		this.save();
	}
	this.save = function() {
		var st = "{\"lines\":[";
		
		for (var i = 0; i < this.lines.length; i++) {
			st += this.lines[i].jstring();
			if (i < this.lines.length-1) {
				st += ",";
			}
		}
		
		st += "]}";
	
		$("#"+this.idInput).val(st);
		
		__draw_reporter.setPainting(this);
		if (this.lines.length > 0) {
			var li = this.lines[this.lines.length-1];
			if (!li.optimized) {
				__draw_optimizer.pushToOptimise(li, this);
			}
		}
//		this.redraw();
	}
	
	this.maxCount = 40
	this.checkForLoad = function() {
		if (this.maxCount > 0) {
			var val = $("#"+this.idInput).val();
			if (typeof(val) != 'undefined' && val.length > 0) {
				this.maxCount = 0;
				this.load(val);
			} else {
				this.maxCount--;
				var that = this;
				setTimeout(function() {that.checkForLoad()}, 1000);
			}
		}
	}	
	this.load = function(val) {
		var obj = $.parseJSON(val);
		for (var i = 0; i < obj.lines.length; i++) {
			var line = __Object_Register.buildObjectFromClassName(obj.lines[i].classId || "DrawLine");
			if (typeof(line) != 'undefined' && line != null) {
				line.loadFromObj(obj.lines[i]);
				this.lines.push(line);
			}
		}
		
		this.redraw();
	}	
}

function DrawObjectRegister() {
	this.buildObjectFromClassName = function(className) {
		var obj = eval("new "+className+"()");
		return obj;
	}
	
}

var __Object_Register = new DrawObjectRegister();

function DrawLine() {
	logDrawer("NEW LINE");
	this.classId = "DrawLine";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = false;
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.drawOnCanvas = function(context) {
		context.beginPath()
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		context.moveTo(this.x[0], this.y[0]);
		
		for (var i = 1; i < this.x.length; i++) {
			context.lineTo(this.x[i], this.y[i]);
			context.stroke();
		}
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
function DrawArrow() {
	logDrawer("NEW ARROW");
	this.classId = "DrawArrow";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	
	this.relPoints = [
		{x: 0,y: 0},
		{x: 1,y: 0},
		{x: 0.8,y:0.2 },
		{x: 0.8,y:-0.2 }
	]
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var nPoints = getRelDrawPoint(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]},
			this.relPoints
		);
		
		
		context.beginPath()
		context.moveTo(nPoints[0].x, nPoints[0].y);
		context.lineTo(nPoints[1].x, nPoints[1].y);
		context.stroke();
		context.beginPath()
		context.moveTo(nPoints[2].x, nPoints[2].y);
		context.lineTo(nPoints[1].x, nPoints[1].y);
		context.stroke();
		context.lineTo(nPoints[3].x, nPoints[3].y);
		context.stroke();
		
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
function DrawPointedArrow() {
	logDrawer("NEW Pointed ARROW");
	this.classId = "DrawPointedArrow";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	
	this.relPoints = [
		{x: 0,y: 0},
		{x: 0.85,y: 0},
		{x: 1,y: 0},
		{x: 0.85,y:0.1 },
		{x: 0.85,y:-0.1 }
	]
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var nPoints = getRelDrawPoint(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]},
			this.relPoints
		);
		
		
		context.beginPath()
		context.moveTo(nPoints[0].x, nPoints[0].y);
		context.lineTo(nPoints[1].x, nPoints[1].y);
		context.stroke();
		context.beginPath()
		context.moveTo(nPoints[3].x, nPoints[3].y);
		context.lineTo(nPoints[2].x, nPoints[2].y);
		context.stroke();
		context.lineTo(nPoints[4].x, nPoints[4].y);
		context.stroke();
		context.lineTo(nPoints[3].x, nPoints[3].y);
		context.stroke();
		
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
function DrawCircle() {
	logDrawer("NEW CIRCLE");
	this.classId = "DrawCircle";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.getRelPoints = function(p1, p2) {
		var relPoint = new Array();
		var dist = find_distance(p1,p2)/2;
		
		var nb = Math.floor(Math.sqrt(dist)*3)+1;
		for (var i = 0; i <= nb; i++) {
			var pt = rotatePoint({x: 1, y: 0}, i*360/nb);
			relPoint.push(pt);
		}
		
		return relPoint;
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var relPoints = this.getRelPoints(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]}
		);
		
		var centerP = {
			x: this.x[0] + (this.x[1]-this.x[0])/2,
			y: this.y[0] + (this.y[1]-this.y[0])/2
		}
		var nPoints = getRelDrawPoint(
			centerP,
			{x: this.x[1], y: this.y[1]},
			relPoints
		);
		
		context.beginPath()
		context.moveTo(nPoints[0].x, nPoints[0].y);
		
		for (var i = 1; i < nPoints.length; i++) {
			context.lineTo(nPoints[i].x, nPoints[i].y);
			context.stroke();
		}
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
function DrawCircle2() {
	logDrawer("NEW CIRCLE2");
	this.classId = "DrawCircle2";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.getRelPoints = function(p1, p2) {
		var relPoint = new Array();
		var dist = find_distance(p1,p2);
		
		var nb = Math.floor(Math.sqrt(dist)*3)+1;
		for (var i = 0; i <= nb; i++) {
			var pt = rotatePoint({x: 1, y: 0}, i*360/nb);
			relPoint.push(pt);
		}
		
		return relPoint;
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var relPoints = this.getRelPoints(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]}
		);
		
		var nPoints = getRelDrawPoint(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]},
			relPoints
		);
		
		
		context.beginPath()
		context.moveTo(nPoints[0].x, nPoints[0].y);
		
		for (var i = 1; i < nPoints.length; i++) {
			context.lineTo(nPoints[i].x, nPoints[i].y);
			context.stroke();
		}
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
function DrawNormal() {
	logDrawer("NEW CIRCLE2");
	this.classId = "DrawNormal";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.getRelPoints = function(p1, p2) {
		var relPoint = new Array();
		var relPoint2 = new Array();
		var dist = find_distance(p1,p2);
		
		var nb = Math.floor(Math.sqrt(dist)*3)+1;
		for (var i = 0; i <= nb; i++) {
			var pt = rotatePoint({x: 1, y: 0}, i*360/nb);
			relPoint.push(pt);
		}
		
		relPoint2.push(rotatePoint({x: 0.80-(this.size/dist), y: 0}, 55));
		relPoint2.push(rotatePoint({x: 0.80-(this.size/dist), y: 0}, -55));
		relPoint2.push(rotatePoint({x: 0.80-(this.size/dist), y: 0}, 125));
		relPoint2.push(rotatePoint({x: 0.80-(this.size/dist), y: 0}, -125));
		
		return {circ: relPoint, n: relPoint2};
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var relPoints = this.getRelPoints(
			{x: this.x[0], y: this.y[0]},
			{x: this.x[1], y: this.y[1]}
		);
		
		var centerP = {
			x: this.x[0] + (this.x[1]-this.x[0])/2,
			y: this.y[0] + (this.y[1]-this.y[0])/2
		}
		var nPoints = getRelDrawPoint(
			centerP,
			{x: this.x[1], y: this.y[1]},
			relPoints.circ
		);
		var nPoints2 = getRelDrawPoint(
			centerP,
			{x: this.x[1], y: this.y[1]},
			relPoints.n
		);
		
		context.beginPath()
		context.moveTo(nPoints[0].x, nPoints[0].y);
		
		for (var i = 1; i < nPoints.length; i++) {
			context.lineTo(nPoints[i].x, nPoints[i].y);
			context.stroke();
		}
		context.beginPath()
		context.moveTo(nPoints2[0].x, nPoints2[0].y);
		context.lineWidth = Math.max(1, Math.round(this.size/3));
		for (var i = 1; i < nPoints2.length; i++) {
			context.lineTo(nPoints2[i].x, nPoints2[i].y);
			context.stroke();
		}
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
/*
function DrawHeart() {
	logDrawer("NEW CIRCLE2");
	this.classId = "DrawHeart";
	this.x = new Array();
	this.y = new Array();
	this.color = "rgb(0,0,0)";
	this.size = 1;
	this.optimized = true;
	this.imgSrc = "heart.png";
	
	this.addPoint = function(x, y, context) {
		var c = context || null;
		if (context != null) {
			if (this.x.length == 1) {
				c.beginPath()
				c.strokeStyle = this.color;
				c.lineWidth = this.size;
				c.moveTo(this.x[0], this.y[0]);
			} 
			
			if ( this.x.length > 0) {
				c.lineTo(x, y);
				c.stroke();
			}
		}
		if (this.x.length == 2) {
			this.x.pop();
			this.y.pop();
		}
		this.x.push(x);
		this.y.push(y);
	}
	
	this.finish = function() {
		if (this.x.length == 1) {
			this.x.push(this.x[0]);
			this.y.push(this.y[0]);
		}
	}
	
	this.loadFromObj = function(obj) {
		this.x = obj.x;
		this.y = obj.y;
		this.color = obj.color || "rgb(0,0,0)";
		this.size = obj.size || 1;
	}
	
	this.drawOnCanvas = function(context) {
		context.strokeStyle = this.color;
		context.lineWidth = this.size;
		
		var topLeftPt = {
			x: Math.min(this.x[0],this.x[1]),
			y: Math.min(this.y[0],this.y[1])
		};
		
		var size = {
			w: Math.abs(this.x[1] - this.x[0]),
			h: Math.abs(this.y[1] - this.y[0])
		};
		
		var img = $("#img-"+this.classId);
		if ( img.size() == 0 ) {
			img = $("<img>");
			img.attr("src",this.imgSrc);
			img.css("visibility","hidden");
			img.attr("id", "img-"+this.classId);
			$("body").append(img);
		}
		img = img.get(0);
		context.drawImage(img, topLeftPt.x, topLeftPt.y, size.w, size.h);
	}

	this.jstring = function() {
		return JSON.stringify(this);
	}
}
*/
function logDrawer(msg) {
	var p  = $("<p></p>").text(msg);
//	$("#log").append(p);
	try {
	console.log(msg);
	} catch(err) {}
}
function logDrawer2(msg) {
//	alert(msg);
	var p  = $("<p></p>").text(msg);
	$("#log").append(p);
}
function __isCanvasable() {
	var acceptCanvas = false;
	try{
		canvas = $("<canvas>");
		if (typeof canvas[0].getContext == 'function') {
			acceptCanvas = true;
		}
	}catch(e){};
	return acceptCanvas;
}

function DrawToolBar() {
	this.on = false;
	this.actDrawer = null;
	this.actColor = "rgb(0,0,0)";
	this.actSize = 2;
	this.actTool = "DrawLine";
	
	this.setDrawer = function(drawer) {
		this.actDrawer = drawer;
		this.setInnerColor();
		this.setInnerSize();
		drawer.actColor = this.actColor;
		drawer.actSize = this.actSize;
		drawer.actTool = this.actTool;
	}
	
	this.build = function() {
	
		$('head').append('<link rel="stylesheet" href="../tools/draw.css" type="text/css" />');
		var mDiv = $("<div>");
		var mDivMove = $("<div>");
		var mDivColor = $("<div>");
		var tSize = $("<table>");
		
		
		var sDivColor = $("<div>");
		var sDivColorSelect = $("<div>");

		var tColor = $("<table>");
		var trColor = $("<tr>");
		var tdColorLight = $("<td>");
//		var tdColorDark = $("<td>");
		var tdColorGrey = $("<td>");
		
		var trSize = $("<tr>");
		var tdPlus = $("<td>");
		var tdMinus = $("<td>");
		var tdSize = $("<td>");
		var divSize = $("<div>");
		var aPlus = $("<a>");
		var aMinus = $("<a>");
		var dPlus = $("<div>");
		var dMinus = $("<div>");

		var dClear = $("<div>");
		var aClear = $("<a>");
		
		var dSel = $("<div>");
		var select = $("<div>");
		
		
		mDiv.append(mDivMove).append(mDivColor).append(tSize).append(dClear).append(dSel);
		mDivColor.append(sDivColor).append(sDivColorSelect);
		sDivColorSelect.append(tColor);
		tColor.append(trColor);
		trColor.append(tdColorLight)/*.append(tdColorDark)*/.append(tdColorGrey);
		tSize.append(trSize);
		trSize.append(tdMinus).append(tdSize).append(tdPlus);
		tdSize.append(divSize);
		tdPlus.append(aPlus);
		tdMinus.append(aMinus);
		aPlus.append(dPlus);
		aMinus.append(dMinus);
		dClear.append(aClear);
		dSel.append(select);
		
		mDiv.attr("id","_tool_bar_infodata");
		sDivColor.addClass("color-name");
		tdSize.addClass("color-size");
		
		mDivMove.addClass("move-handle");
		
		dSel.addClass("select-div");
		
		this.fillSelectTool(select);
		
		mDivColor.css("width","100%");
		tSize.css("width","100%");
		
		sDivColorSelect.addClass("color-select");
		
		tColor.addClass("color-select-table");

		tSize.addClass("size-select-table");
		dPlus.css("float","left");
		aMinus.css("float","right");
		tdSize.css("text-align","center");
		tdSize.css("width","30px");
		divSize.css("border","2px solid black");
		divSize.css("position","relative");
		divSize.css("left","14px");
		dPlus.text("+");
		dMinus.text("-");
		
		aPlus.attr("href","javascript:__draw_tool_bar.upSize()");
		aMinus.attr("href","javascript:__draw_tool_bar.downSize()");
		
		dClear.addClass("clear-draw-div");
		aClear.attr("href","javascript:__draw_tool_bar.clearZone()");
		aClear.text("Effacer");
		
		this.buildColorPaletteLight(tdColorLight);
//		this.buildColorPaletteDark(tdColorDark);
		this.buildColorPaletteGrey(tdColorGrey);

		
		
		$("body").append(mDiv);
		
		this.setMoveable(mDiv, mDivMove);
		this.setInnerColor();
		this.setInnerSize();
	}
	
	this.setMoveable = function(mDiv, moveDiv) {
		this.move = {
			move: false,
			div: {x: 0, y: 0},
			cursor: {x: 0, y: 0}
		}
		var that = this;
		moveDiv.mousedown(function(e){
			console.log("y="+$(document).scrollTop()+"/"+$(this).parent().offset().top);
			that.move.move = true;
			that.move.div.x = $(this).parent().offset().left-$(document).scrollLeft();
			that.move.div.y = $(this).parent().offset().top-$(document).scrollTop();
			that.move.cursor.x = e.pageX;
			that.move.cursor.y = e.pageY;
		});
		$(document).mouseup(function(e){
			that.move.move = false;
		});
		$(document).mousemove(function(e){
			if (that.move.move) {
				console.log(JSON.stringify(that.move));
				console.log(e.pageX+"/"+e.pageY);
				var x = that.move.div.x + (e.pageX - that.move.cursor.x);
				var y = that.move.div.y + (e.pageY - that.move.cursor.y);
				moveDiv.parent().css("left", x+"px");
				moveDiv.parent().css("top", y+"px");
			}
		});
		
		
		moveDiv[0].addEventListener("touchstart",function(e) {
			console.log("y="+$(document).scrollTop()+"/"+$(this).parent().offset().top);
			that.move.move = true;
			that.move.div.x = $(this).parent().offset().left-$(document).scrollLeft();
			that.move.div.y = $(this).parent().offset().top-$(document).scrollTop();
			that.move.cursor.x = e.pageX;
			that.move.cursor.y = e.pageY;
		},false);
		document.addEventListener("touchmove", function(e) {
			if (that.move.move) {
				e.preventDefault();
				console.log(JSON.stringify(that.move));
				console.log(e.pageX+"/"+e.pageY);
				var x = that.move.div.x + (e.pageX - that.move.cursor.x);
				var y = that.move.div.y + (e.pageY - that.move.cursor.y);
				moveDiv.parent().css("left", x+"px");
				moveDiv.parent().css("top", y+"px");
			}
		},false);
		document.addEventListener("touchend", function(e) {
			that.move.move = false;
		},false);
		
	}

	this.fillSelectTool = function(select) {
		var op = [
			{text: "Crayon", className: "DrawLine" },
			{text: "Fl\u00E8che en pointe", className: "DrawPointedArrow" },
			{text: "Normal", className: "DrawNormal" },
//			{text: "Fl\u00E8che", className: "DrawArrow" },
			{text: "Cercle (diam.)", className: "DrawCircle" },
			{text: "Cercle (rayon)", className: "DrawCircle2" }
		];
		
		var optionsList = new Array();
		var that = this;
		for (var i = 0; i < op.length; i++) {
			var option = $("<div>");
			option.addClass("tool-btn");
			option.addClass("tool-btn-"+op[i].className);
			if (i == 0) {option.addClass("selected")}
			option.attr("className", op[i].className);
			option.attr("title", op[i].text);
/*			var option = $("<option>");
			option.val(op[i].className);
			option.text(op[i].text);*/
			optionsList.push(option);
			//select.append(option);
			
			option.click(function() {
				$(".tool-btn.selected").removeClass("selected");
				$(this).addClass("selected");
				that.setTool();
			});
		}
		
		for (var i = 0; i < optionsList.length; i+=3) {
			var t = $("<table>");
			var tr = $("<tr>");
			
			t.addClass("option-layout-table");
			if (i < optionsList.length) {
				var td = $("<td>");
				td.append(optionsList[i]);
				tr.append(td);
			}
			if (i+1 < optionsList.length) {
				var td = $("<td>");
				td.append(optionsList[i+1]);
				tr.append(td);
			}
			if (i+2 < optionsList.length) {
				var td = $("<td>");
				td.append(optionsList[i+2]);
				tr.append(td);
			}
			select.append(t.append(tr));
		}
		
		select.change(function() {
			that.setTool();
		});

	}

	this.clearZone = function() {
		if (this.actDrawer != null) {
			this.actDrawer.clear();
		}
	}
	this.appendColor = function(c, mDiv) {
		var a = $("<a>");
		var d = $("<div>");
		var br = $("<br/>");
		
		a.css("width","100%");
		a.css("line-height","4px");
		a.css("font-size","4px");
		d.css("width","100%");
		d.css("background-color","rgb("+c.r+","+c.g+","+c.b+")");
		d.css("height", "20px");
		a.append(d);
		mDiv.append(a);
		
		a.attr("href","javascript:__draw_tool_bar.setColor('"+d.css("background-color")+"')");
	}
	this.buildColorPaletteLight = function(mDiv) {
		var c = { r: 255, g: 0, b: 0};
		var steps = [
						{r:255, g: 0, b: 255},
						{r:0, g: 0, b: 255},
						{r:0, g: 255, b: 255},
						{r:0, g: 255, b: 0},
						{r:255, g: 255, b: 0},
						{r:255, g: 0, b: 0}
					];
		var saut = 255;
		for (var i = 0; i < steps.length; i++) {
			while ( c.r != steps[i].r || c.g != steps[i].g || c.b != steps[i].b ) {
				if (c.r > steps[i].r) {
					c.r = Math.max(0, c.r-saut);
				}
				if (c.g > steps[i].g) {
					c.g = Math.max(0, c.g-saut);
				}
				if (c.b > steps[i].b) {
					c.b = Math.max(0, c.b-saut);
				}
				if (c.r < steps[i].r) {
					c.r = Math.min(255, c.r+saut);
				}
				if (c.g < steps[i].g) {
					c.g = Math.min(255, c.g+saut);
				}
				if (c.b < steps[i].b) {
					c.b = Math.min(255, c.b+saut);
				}
				
				this.appendColor(c,mDiv);
			}
		}
		
	}
	this.buildColorPaletteGrey = function(mDiv) {
		var c = { r: 0, g: 0, b: 0};
		var steps = [
						{r:0, g: 0, b: 0},
						{r:180, g: 180, b: 180},
					];
		var saut = 30;
		for (var i = 0; i < steps.length; i++) {
			while ( c.r != steps[i].r || c.g != steps[i].g || c.b != steps[i].b ) {
				if (c.r > steps[i].r) {
					c.r = Math.max(0, c.r-saut);
				}
				if (c.g > steps[i].g) {
					c.g = Math.max(0, c.g-saut);
				}
				if (c.b > steps[i].b) {
					c.b = Math.max(0, c.b-saut);
				}
				if (c.r < steps[i].r) {
					c.r = Math.min(255, c.r+saut);
				}
				if (c.g < steps[i].g) {
					c.g = Math.min(255, c.g+saut);
				}
				if (c.b < steps[i].b) {
					c.b = Math.min(255, c.b+saut);
				}

				this.appendColor(c,mDiv);
			}
		}
		
	}
	this.buildColorPaletteDark = function(mDiv) {
		var c = { r: 128, g: 0, b: 0};
		var steps = [
						{r:128, g: 0, b: 128},
						{r:0, g: 0, b: 128},
						{r:0, g: 128, b: 128},
						{r:0, g: 128, b: 0},
						{r:128, g: 128, b: 0},
						{r:128, g: 0, b: 0}
					];
		var saut = 64;
		for (var i = 0; i < steps.length; i++) {
			while ( c.r != steps[i].r || c.g != steps[i].g || c.b != steps[i].b ) {
				if (c.r > steps[i].r) {
					c.r = Math.max(0, c.r-saut);
				}
				if (c.g > steps[i].g) {
					c.g = Math.max(0, c.g-saut);
				}
				if (c.b > steps[i].b) {
					c.b = Math.max(0, c.b-saut);
				}
				if (c.r < steps[i].r) {
					c.r = Math.min(255, c.r+saut);
				}
				if (c.g < steps[i].g) {
					c.g = Math.min(255, c.g+saut);
				}
				if (c.b < steps[i].b) {
					c.b = Math.min(255, c.b+saut);
				}

				this.appendColor(c,mDiv);
			}
		}
		
	}
	
	this.setColor = function(color) {
		this.actColor = color;
		this.setInnerColor();
		if (this.actDrawer != null) {
			this.actDrawer.actColor = color;
		}
	}
	this.rgbPatt = /rgb\( *([0-9]*) *, *([0-9]*) *, *([0-9]*) *\)/;
	this.setInnerColor = function() {
		var textColor = null;//"'rgb("+((c.r+128)%255)+","+((c.g+128)%255)+","+((c.b+128)%255)+")'";
		var c = this.actColor || "rgb(0,0,0)";
		var r = this.rgbPatt.exec(c);
		var cc = null;
		if (r != null & r.length == 4) {
			try {
				cc = { r: parseInt(r[1]), g: parseInt(r[2]), b: parseInt(r[3])};
				textColor = "rgb("+((cc.r+128)%255)+","+((cc.g+128)%255)+","+((cc.b+128)%255)+")";
			} catch( e) {}
		}
		$("#_tool_bar_infodata .color-name").text(c);
		$("#_tool_bar_infodata .color-name").css("background-color",c);
		$("#_tool_bar_infodata .color-name").css("color",textColor || "#000000");
		$("#_tool_bar_infodata .color-size > div").css("background-color",c);
		if ( cc != null && (cc.r+cc.b+cc.g) < 300 ) {
			$("#_tool_bar_infodata .color-size > div").css("border-color","rgb(140,255,140)");
		} else {
			$("#_tool_bar_infodata .color-size > div").css("border-color","rgb(0,0,0)");
		}
	}
	this.setInnerSize = function() {
		var size = this.actSize || 2;
		$("#_tool_bar_infodata .color-size").attr("title", "size: "+size);
		
		$("#_tool_bar_infodata .color-size > div").css("width",size+"px");
		$("#_tool_bar_infodata .color-size > div").css("height",size+"px");
		$("#_tool_bar_infodata .color-size > div").css("left",(15-size/2)+"px");
		$("#_tool_bar_infodata .color-size > div").css("border-radius",Math.floor(size)+"px");
	}
	
	this.upSize = function() {
		var size = Math.min(10,this.actSize + 1);
		this.setSize(size)
	}
	
	this.downSize = function() {
		var size = Math.max(1,this.actSize - 1);
		this.setSize(size)
	}
	
	this.setSize = function(size) {
		this.actSize = size;
		this.setInnerSize();
		if (this.actDrawer != null) {
			this.actDrawer.actSize = size;
		}
	}
	this.setTool = function() {
		this.actTool = $("#_tool_bar_infodata .select-div .selected").attr("className") || "DrawLine";
		if (this.actDrawer != null) {
			this.actDrawer.actTool = this.actTool;
		}
	}
	
	this.build();
	
	this.show = function() {
	}
}
var __draw_tool_bar = null;
var __draw_reporter = null;
var __draw_optimizer = null;
$(document).ready(function() {
	__draw_tool_bar = new DrawToolBar();
	__draw_reporter = new RedrawReporter();
	__draw_optimizer= new LineOptimiser();
});

function showToolBar() {
	__draw_tool_bar.show();
}

function getRelDrawPoint(p1, p2, points) {
	var stretchSize = find_distance(p1,p2);
	
	var p3 = {x: p2.x, y: p1.y};

	
	var angle = find_angle(p3, p2, p1);
	
	if (p2.x < p1.x) {
		if (p2.y < p1.y) {
			angle = 180 - angle;
		} else {
			angle = 180 + angle;
		}
	} else {
		if (p2.y > p1.y) {
			angle = 360 - angle;
		}
	}
	
	var nPoints = new Array();
	
	for (var i = 0; i < points.length; i++) {
		var sP = stretchPoint(points[i],stretchSize);
		var nP = rotatePoint(sP, angle);
		nP.x = Math.round(nP.x+p1.x);
		nP.y = Math.round(nP.y+p1.y);
		nPoints.push(nP);
	}
	return nPoints;
}

function stretchPoint(point, stretch) {
	return {x: point.x*stretch, y: point.y*stretch};
}
function rotatePoint(point, angle) {
	var rad = angle*3.1416/180;
	return {
		x: point.x*Math.cos(rad)+ point.y*Math.sin(rad),
		y: -point.x*Math.sin(rad)+ point.y*Math.cos(rad)
	};
}

function __isDrawable() {
	var drawable = __isCanvasable();
	return drawable;
}
function find_angle(p0,p1,c) {
    var p0c = Math.sqrt(Math.pow(c.x-p0.x,2)+
                        Math.pow(c.y-p0.y,2)); // p0->c (b)   
    var p1c = Math.sqrt(Math.pow(c.x-p1.x,2)+
                        Math.pow(c.y-p1.y,2)); // p1->c (a)
    var p0p1 = Math.sqrt(Math.pow(p1.x-p0.x,2)+
                         Math.pow(p1.y-p0.y,2)); // p0->p1 (c)
    return Math.acos((p1c*p1c+p0c*p0c-p0p1*p0p1)/(2*p1c*p0c))*(180/3.1416);
}
function find_distance(p1,p2) {
	return Math.sqrt(Math.pow( p1.x - p2.x, 2) + Math.pow( p1.y - p2.y, 2));
}
function find_run_distance(p1, p2, c) {
	return Math.sqrt(Math.pow( p1.x - c.x, 2) + Math.pow( p1.y - c.y, 2)) + Math.sqrt(Math.pow( p2.x - c.x, 2) + Math.pow( p2.y - c.y, 2)); 
}