function getAssistText() {

	return "[{\"id\":12015,\"name\":\"labo mémoire\",\"text\":\"Labos re problème congitif: FSC, TSH, folate, b12, ca, alb, gaj, creat, E+\",\"type\":20,\"user\":{\"id\":111,\"idUser\":3733,\"application\":\"ofys\",\"idClient\":180},\"isHtml\":false,\"isClientPrivate\":false,\"type2\":\"ENCOUNTER_NOTE\",\"flag\":1}]";
//	return "[]";
}

/**
 * AutoComplete: Widget Feature used in Med-office and Ofys software 
 * for auto-completion of text input and entry assist.
 * 
 * Original Author: Nicolas Joly
 * Revised and commented by : Albert B. 2016-04-30
 * © Logiciels infodata
 * =============================================================
 * 
 * 
 * 
 */


var AutoComplete = {};
(function(assist) {
	/* "assist" is the private reference to the Autocomplete widget 
	 * 
	 * Three wrappers are offered for integration in ofys, 
	 * - TinyMCE wrapper
	 * - eform wrapper
	 * - encounter wrapper for ofys integration.
	 * 
	 */
	
	assist.tinyMceWrap = function(selector, fnUpdate, urlDifferer) {
		if (typeof(tinymce) != 'undefined') {
/*	        "advlist autolink autosave link image lists charmap print preview hr anchor pagebreak spellchecker",
			"searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			"table contextmenu directionality emoticons template textcolor paste fullpage textcolor"

			toolbar1: "newdocument fullpage | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | styleselect formatselect fontselect fontsizeselect",
			toolbar2: "cut copy paste | searchreplace | bullist numlist | outdent indent blockquote | undo redo | link unlink anchor image media code | inserttime preview | forecolor backcolor",
			toolbar3: "table | hr removeformat | subscript superscript | charmap emoticons | print fullscreen | ltr rtl | spellchecker | visualchars visualblocks nonbreaking template pagebreak restoredraft",
*/
			
			tinymce.init({
				selector:selector,
				menubar: false,
				// General options
				theme: "modern",
				plugins: [
					"advlist autolink lists link image charmap print preview hr anchor pagebreak",
					"searchreplace wordcount visualblocks visualchars code fullscreen",
					"insertdatetime media nonbreaking save table contextmenu directionality",
					"emoticons template paste textcolor autocomplete"
				],
				toolbar1: "undo redo | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist | forecolor backcolor | auto",
				statusbar: false,
				contextmenu: 'auto',
				setup: function(editor) {
					editor.urlDifferer = urlDifferer || "";
					editor.on("change", function() {
						try {
							fnUpdate(editor.getContent({format:"html"}));
						} catch(e) {}
					});
					editor.on("keyup", function() {
						try {
							fnUpdate(editor.getContent({format:"html"}));
						} catch(e) {}
					});
				}

			});
		} else {
			return "TinyMCE is unvalable";
		}
	}

	assist.eformWrap = function(id, fnOnSelect) {
		assist.NEW(
			id,
			function(text) {

				var list = new Array();
				if ( typeof(this.originalSel) != 'undefined' ) {
					var txtAdd = $(this.element).val();
					var idType = $(this.element).attr("idType");
					if (this.originalSel.s != this.originalSel.e) {
						txtAdd = txtAdd.substring(this.originalSel.s, this.originalSel.e);
					}
				}


				try {
					var idType = $(this.element).attr("idType");
					var sObj = getAssistText(idType, text);
					var obj = $.parseJSON(sObj);
					

					for (var i = 0 ;i  < obj.length; i++) {
						list.push(obj[i]);
					}
				} catch(e) {alert(e.description||e.message)};
				
				return list;
				
			}, function(text) {
				var div = $("<div>");
				var name = this.name;
				if (typeof(text) != 'undefined' && text.trim().length > 0) {
					name = name.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>"+text+"</span>");
				}
				if (typeof(this.flag) != 'undefined') {
					if (this.flag == 1) {
						div.css("background","rgb(237,176,71)")
					} else if (this.flag == 2) {
						div.css("background","rgb(237,195,71)")
					} else if (this.flag == 3) {
						div.css("background","rgb(237,212,71)")
					} else if (this.flag == 4) {
						div.css("background","rgb(242,232,187)")
					}
				}
				div.html(name);
				div.css("cursor","pointer");
				return div;
			}, function(text) {
				var div = $("<div>");
				if (!this.computeDescription) {
					try {
						this.computeDescription = gabaritGetDescription(this.text);
					} catch (e) {
						this.computeDescription = this.text;
					}
				}
				
				var desc = this.computeDescription;
		
				if (typeof(text) != 'undefined' && text.trim().length > 0) {
					desc = desc.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>"+text+"</span>");
				}
				div.html(desc);
				div.css("word-wrap","break-word");
				return div;
			}, function(baseElement, assistant) {
				baseElement.keydown(function(e) {
					if (e.ctrlKey && e.which == 32) {
						e.preventDefault();
						e.stopPropagation();
						assistant.openAssistant();
					}
				});
			}, function(assistant) { //onselect
				var sel = assistant.sel || {
					s: assistant.element.val.length(),
					e: assistant.element.val.length()
				};
				
				var val = assistant.element.val();
				var txt = val.substring(0, sel.s);
				try {
					var t = gabaritGetFinalText(this.text);
					txt += t;
				} catch(e){
					txt += this.text;
				}
				var cursor = txt.length;
				txt += val.substring(sel.e);

				assistant.element.val(txt);
				if (typeof(this.id) != 'undefined') {
					assistantSelectedCount(this.id);
				}

				//Place the cursor to the right place
				assistant.element.get(0).selectionStart = cursor;
				assistant.element.get(0).selectionEnd = cursor;
				
				if (fnOnSelect) { fnOnSelect();}
			}, function(assistant) {//positioning
				var sel = {
					s: this.element.get(0).selectionStart || 0,
					e: this.element.get(0).selectionEnd || 0
				};
				assistant.originalSel = {
					s: this.element.get(0).selectionStart || 0,
					e: this.element.get(0).selectionEnd || 0
				};
				var sel2 = {
					s: Math.min(sel.s, sel.e),
					e: Math.max(sel.s, sel.e)
				}
				sel = sel2;
				assistant.sel = sel;
				var m = Math.max(sel.s, sel.e);
				var txt = this.element.val().substring(0,m).replace("  ","&nbsp; ").replace("\r\n","</br>").replace("\n\r","</br>").replace("\n","</br>").replace("\r","</br>");
				if (m == 0) {
					txt = "&nbsp;";
				}
				var div = $("<div>");
				div.html(txt);
				div.css(getComputedStyle(this.element.get(0)));
				
				div.css("width", this.element.width()+"px");
				div.css("height", "");
				
				div.css("visibility", "hidden");
				div.css("position", "absolute");
				$(document.body).append(div);
				
				var h = div.height();
				
				//Scroll check
				if (h > this.element.height()) {
					h -= this.element.scrollTop();
				}
				
				
				if (typeof(document.documentMode) == 'undefined') {
					h += 4;
				}
//				div.remove();
				return h+2;
			}, null //otherObject
			, null//endFocus on close
			, function(){//onOpen
				var val = "";
				
				if (this.sel) {
					//first step, if nothing select, try to get the word before.
					var txt = this.element.val();
					var unacceptChar = " ;.,:'()$%&*/|!@#<>=+~\\\"\n\r\t";
					if (this.sel.s == this.sel.e) {
						while (this.sel.s > 0) {
							var c = txt.substring(this.sel.s-1, this.sel.s);
							if (unacceptChar.indexOf(c) != -1) {
								break;
							}
							this.sel.s--;
						}
					}
					//second step, if we finaly have something selected, copy it as start value for search
					if (this.sel.s != this.sel.e) {
						val = txt.substring(this.sel.s, this.sel.e);
					}
				}
				
				this.filterInput.val("");
				this.searchInput.val(val.trim());
				
				var toFocus = this.searchInput;
				if (val.trim().length > 0) {
					toFocus = this.filterInput;
				}
				var that = this;
				setTimeout(function() {
					that.searchInput.val(that.searchInput.val().trim());
					that.filterInput.val(that.filterInput.val().trim());
				},200);
				if ( typeof(this.searchInput.get(0).selectionStart) != 'undefined') {
					this.searchInput.get(0).selectionStart = val.trim().length;
					this.searchInput.get(0).selectionEnd = val.trim().length;
				}
				toFocus.focus();
			}, function() {//fnLegend
				var main = $("<div>");
				var clear = $("<div>");
				main.css("width","100%");
				clear.css("clear","both");

				var tableA = $("<table>");
				var trA = $("<tr>");
				var tdA1 = $("<td>");
				var tdA2 = $("<td>");
				var divA = $("<div>");
				
				tableA.css({
					"float":"left",
					"border-collapse":"collapse",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"margin-left":"5px",
				});
				tdA1.css("vertical-align","middle");
				tdA2.css("vertical-align","middle");
				divA.css({
					"width":"14px",
					"height":"14px",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"border":"1px solid black",
					"background-color":"rgb(237,176,71)",
				});
				tdA2.text("Derniers utilis\u00E9s (moi)");
				tdA1.append(divA);
				trA.append(tdA1).append(tdA2);
				tableA.append(trA);
				main.append(tableA);
				
				
				var tableB = $("<table>");
				var trB = $("<tr>");
				var tdB1 = $("<td>");
				var tdB2 = $("<td>");
				var divB = $("<div>");
				
				tableB.css({
					"float":"left",
					"border-collapse":"collapse",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"margin-left":"5px",
				});
				tdB1.css("vertical-align","middle");
				tdB2.css("vertical-align","middle");
				divB.css({
					"width":"14px",
					"height":"14px",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"border":"1px solid black",
					"background-color":"rgb(237,195,71)",
				});
				tdB2.text("Plus utilis\u00E9s (moi)");
				tdB1.append(divB);
				trB.append(tdB1).append(tdB2);
				tableB.append(trB);
				main.append(tableB);
				
				
				var tableC = $("<table>");
				var trC = $("<tr>");
				var tdC1 = $("<td>");
				var tdC2 = $("<td>");
				var divC = $("<div>");
				
				tableC.css({
					"float":"left",
					"border-collapse":"collapse",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"margin-left":"5px",
				});
				tdC1.css("vertical-align","middle");
				tdC2.css("vertical-align","middle");
				divC.css({
					"width":"14px",
					"height":"14px",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"border":"1px solid black",
					"background-color":"rgb(237,212,71)",
				});
				tdC2.text("Plus utilis\u00E9s (clinique)");
				tdC1.append(divC);
				trC.append(tdC1).append(tdC2);
				tableC.append(trC);
				main.append(tableC);
				
				
				var tableD = $("<table>");
				var trD = $("<tr>");
				var tdD1 = $("<td>");
				var tdD2 = $("<td>");
				var divD = $("<div>");
				
				tableD.css({
					"float":"left",
					"border-collapse":"collapse",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"margin-left":"5px",
				});
				tdD1.css("vertical-align","middle");
				tdD2.css("vertical-align","middle");
				divD.css({
					"width":"14px",
					"height":"14px",
					"box-sizing":"border-box",
					"-moz-box-sizing":"border-box",
					"border":"1px solid black",
				});
				tdD2.text("Plus utilis\u00E9s (partag\u00E9s)");
				tdD1.append(divD);
				trD.append(tdD1).append(tdD2);
				tableD.append(trD);
				main.append(tableD);
				
				main.append(clear);
				
				return main;
			}, function() {
//				<div class="template-i-positionner"><div class="template-i-obj" onclick="openTemplateEditor(18)"></div></div>
				try {
				var divP = $("<div>");
				var divI = $("<div>");

				divP.css({
					"position":"relative",
					"top":"0px",
				});
				divI.css({
					"position": "absolute",
					"top": "0px",
					"left": "-10px",
					"width": "8px",
					"height": "8px",
					"background-image": "url('http://ofys.ca/formulaires/images/i8.png')",
					"cursor": "pointer",
					"z-index": "1000",
				});
				divP.addClass("hide-on-print");
				divP.append(divI);
				document.querySelector('style').textContent += "@media print {.hide-on-print { display: none; }}";
				var that = this;
				divI.click(function() {
					openTemplateEditor(parseInt(that.element.attr("idType")));
				});
				this.element.before(divP);
				} catch(e){ alert(""+e.message)}
			}
		);
	}
	
	
	assist.encounterWrap = function(id, fnOnSelect) {
		assist.NEW(
				id,
				function(text) {
					var list = new Array();
					try {
						var idType = $(this.element).attr("idType");
						var sObj = getAssistText(idType, text);
						var obj = $.parseJSON(sObj);
						
						
						for (var i = 0 ;i  < obj.length; i++) {
							list.push(obj[i]);
						}
					} catch(e) {alert(e.description)};
					
					return list;
					
				}, function(text) {
					var div = $("<div>");
					var name = this.name;
					if (typeof(text) != 'undefined' && text.trim().length > 0) {
						name = name.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>"+text+"</span>");
					}
					if (typeof(this.flag) != 'undefined') {
						if (this.flag == 1) {
							div.css("background","rgb(237,176,71)")
						} else if (this.flag == 2) {
							div.css("background","rgb(237,195,71)")
						} else if (this.flag == 3) {
							div.css("background","rgb(237,212,71)")
						} else if (this.flag == 4) {
							div.css("background","rgb(242,232,187)")
						}
					}
					div.html(name);
					div.css("cursor","pointer");
					return div;
				}, function(text) {
					var div = $("<div>");
					if (!this.computeDescription) {
						try {
							this.computeDescription = gabaritGetDescription(this.text);
						} catch (e) {
							this.computeDescription = this.text;
						}
					}
					
					var desc = this.computeDescription;
					
					if (typeof(text) != 'undefined' && text.trim().length > 0) {
						desc = desc.replace(new RegExp(text.trim(), "gi"), "<span style='font-weight: bolder; background-color: yellow;'>"+text+"</span>");
					}
					div.html(desc);
					div.css("word-wrap","break-word");
					return div;
				}, function(baseElement, assistant) {
					baseElement.keydown(function(e) {
						if (e.ctrlKey && e.which == 32) {
							e.preventDefault();
							e.stopPropagation();
							assistant.openAssistant();
						}
					});
				}, function(assistant) { //onselect
					var sel = assistant.sel || {
						s: assistant.element.val.length(),
						e: assistant.element.val.length()
					};
					
					var val = assistant.element.val();
					var txt = val.substring(0, sel.s);
					try {
						var t = gabaritGetFinalText(this.text);
						txt += t;
					} catch(e){
						txt += this.text;
					}
					var cursor = txt.length;

					txt += val.substring(sel.e);
					
					assistant.element.val(txt);
					if (typeof(this.id) != 'undefined') {
						assistantSelectedCount(this.id);
					}
					
					//Place the cursor to the right place
					assistant.element.get(0).selectionStart = cursor;
					assistant.element.get(0).selectionEnd = cursor;
					
					if (fnOnSelect) { fnOnSelect();}
				}, function(assistant) {//positioning
					var sel = {
							s: this.element.get(0).selectionStart || 0,
							e: this.element.get(0).selectionEnd || 0
					};
					var sel2 = {
							s: Math.min(sel.s, sel.e),
							e: Math.max(sel.s, sel.e)
					}
					sel = sel2;
					assistant.sel = sel;
					var m = Math.max(sel.s, sel.e);
					var txt = this.element.val().substring(0,m).replace("  ","&nbsp; ").replace("\r\n","</br>").replace("\n\r","</br>").replace("\n","</br>").replace("\r","</br>");
					if (m == 0) {
						txt = "&nbsp;";
					}
					var div = $("<div>");
					div.html(txt);
					div.css(getComputedStyle(this.element.get(0)));
					
					div.css("width", this.element.width()+"px");
					div.css("height", "");
					
					div.css("visibility", "hidden");
					div.css("position", "absolute");
					$(document.body).append(div);
					
					var h = div.height();
					
					//Scroll check
					if (h > this.element.height()) {
						h -= this.element.scrollTop();
					}
					
					
					if (typeof(document.documentMode) == 'undefined') {
						h += 4;
					}
//				div.remove();
					return h+2;
				}, null //otherObject
				, null//endFocus on close
				, function(){//onOpen
					var val = "";
					
					if (this.sel) {
						//first step, if nothing select, try to get the word before.
						var txt = this.element.val();
						var unacceptChar = " ;.,:'()$%&*/|!@#<>=+~\\\"\n\r\t";
						if (this.sel.s == this.sel.e) {
							while (this.sel.s > 0) {
								var c = txt.substring(this.sel.s-1, this.sel.s);
								if (unacceptChar.indexOf(c) != -1) {
									break;
								}
								this.sel.s--;
							}
						}
						//second step, if we finaly have something selected, copy it as start value for search
						if (this.sel.s != this.sel.e) {
							val = txt.substring(this.sel.s, this.sel.e);
						}
					}
					
					this.filterInput.val("");
					this.searchInput.val(val.trim());
					
					var toFocus = this.searchInput;
					if (val.trim().length > 0) {
						toFocus = this.filterInput;
					}
					var that = this;
					setTimeout(function() {
						that.searchInput.val(that.searchInput.val().trim());
						that.filterInput.val(that.filterInput.val().trim());
					},200);
					if ( typeof(this.searchInput.get(0).selectionStart) != 'undefined') {
						this.searchInput.get(0).selectionStart = val.trim().length;
						this.searchInput.get(0).selectionEnd = val.trim().length;
					}
					toFocus.focus();
				}, function() {//fnLegend
					var main = $("<div>");
					var clear = $("<div>");
					main.css("width","100%");
					clear.css("clear","both");
					
					var tableA = $("<table>");
					var trA = $("<tr>");
					var tdA1 = $("<td>");
					var tdA2 = $("<td>");
					var divA = $("<div>");
					
					tableA.css({
						"float":"left",
						"border-collapse":"collapse",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"margin-left":"5px",
					});
					tdA1.css("vertical-align","middle");
					tdA2.css("vertical-align","middle");
					divA.css({
						"width":"14px",
						"height":"14px",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"border":"1px solid black",
						"background-color":"rgb(237,176,71)",
					});
					tdA2.text("Derniers utilis\u00E9s (moi)");
					tdA1.append(divA);
					trA.append(tdA1).append(tdA2);
					tableA.append(trA);
					main.append(tableA);
					
					
					var tableB = $("<table>");
					var trB = $("<tr>");
					var tdB1 = $("<td>");
					var tdB2 = $("<td>");
					var divB = $("<div>");
					
					tableB.css({
						"float":"left",
						"border-collapse":"collapse",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"margin-left":"5px",
					});
					tdB1.css("vertical-align","middle");
					tdB2.css("vertical-align","middle");
					divB.css({
						"width":"14px",
						"height":"14px",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"border":"1px solid black",
						"background-color":"rgb(237,195,71)",
					});
					tdB2.text("Plus utilis\u00E9s (moi)");
					tdB1.append(divB);
					trB.append(tdB1).append(tdB2);
					tableB.append(trB);
					main.append(tableB);
					
					
					var tableC = $("<table>");
					var trC = $("<tr>");
					var tdC1 = $("<td>");
					var tdC2 = $("<td>");
					var divC = $("<div>");
					
					tableC.css({
						"float":"left",
						"border-collapse":"collapse",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"margin-left":"5px",
					});
					tdC1.css("vertical-align","middle");
					tdC2.css("vertical-align","middle");
					divC.css({
						"width":"14px",
						"height":"14px",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"border":"1px solid black",
						"background-color":"rgb(237,212,71)",
					});
					tdC2.text("Plus utilis\u00E9s (clinique)");
					tdC1.append(divC);
					trC.append(tdC1).append(tdC2);
					tableC.append(trC);
					main.append(tableC);
					
					
					var tableD = $("<table>");
					var trD = $("<tr>");
					var tdD1 = $("<td>");
					var tdD2 = $("<td>");
					var divD = $("<div>");
					
					tableD.css({
						"float":"left",
						"border-collapse":"collapse",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"margin-left":"5px",
					});
					tdD1.css("vertical-align","middle");
					tdD2.css("vertical-align","middle");
					divD.css({
						"width":"14px",
						"height":"14px",
						"box-sizing":"border-box",
						"-moz-box-sizing":"border-box",
						"border":"1px solid black",
					});
					tdD2.text("Plus utilis\u00E9s (partag\u00E9s)");
					tdD1.append(divD);
					trD.append(tdD1).append(tdD2);
					tableD.append(trD);
					main.append(tableD);
					
					main.append(clear);
					
					return main;
				}
		);
	}
	
	function getComputedStyle( dom ) {
        var style;
        var returns = {};
        // FireFox and Chrome way
        if(window.getComputedStyle){
            style = window.getComputedStyle(dom, null);
            for(var i = 0, l = style.length; i < l; i++){
                var prop = style[i];
                var val = style.getPropertyValue(prop);
                returns[prop] = val;
            }
            return returns;
        }
        // IE and Opera way
        if(dom.currentStyle){
            style = dom.currentStyle;
            for(var prop in style){
                returns[prop] = style[prop];
            }
            return returns;
        }
        // Style from style attribute
        if(style = dom.style){
            for(var prop in style){
                if(typeof style[prop] != 'function'){
                    returns[prop] = style[prop];
                }
            }
            return returns;
        }
        return returns;
    };
	
	assist.NEW = function(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild) {
		return new Autocomplete(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild);
	}

	/**
	 * Autocomplete function
	 * params : 
	 * - fnIL : Item list function 
	 * - fnSIN : default name of item to show
	 * - fnSID : default item description to show
	 * - fnSetOpenTrigger : trigger function e.g : (Ctrl + Space) in Ofys encounter
	 * - fnSelect : 
	 * - fnPositionning: 
	 * - otherObject :
	 * - fnFocus : 
	 * - fnOpen :
	 * - fnLegend :
	 * - fnOnBuild :
	 */
	function Autocomplete(id, fnIL, fnSIN, fnSID, fnSetOpenTrigger, fnSelect, fnPositionning, otherObject, fnFocus, fnOpen, fnLegend, fnOnBuild) {
		this.id = id;
		//Must be redefined
		this.getItemList = fnIL || function() { return [];}
		this.defaultShowItemName = fnSIN || function() {return "";}
		this.defaultShowItemDescription = fnSID || function() {return "";}
		this.defaultSelect = fnSelect || function(autoComplete) {
			alert(this.description);
		}
		this.defaultMustCloseWhenSelect = true;
		//Can be redefined
		this.getSpecialItemList = function() { return [];}
		this.defaultShowSpecialItemName = function() {return "";}
		this.defaultShowSpecialItemDescription = function() {return "";}
		this.setOpenTrigger = fnSetOpenTrigger || function(baseElement) {};
		this.getVerticalPosition = fnPositionning || function(){return 0;};
		this.otherObject = otherObject;
		this.open = false;
		this.regainFocus = fnFocus || function(){$("#"+this.id).focus();};
		this.onOpen = fnOpen || function(){this.searchInput.focus();};
		this.cache = new CacheList();
		this.buildLegend = fnLegend || function(){ return null;}
		this.buildExtension = fnOnBuild || function() {};
		
		this.showThisOne = function(divElement) {
			$(".auto-list-selected").css("background-color", $(".auto-list-selected").attr("originalbg")).removeClass("auto-list-selected");
			divElement.attr("originalbg",divElement.css("background-color"));
			divElement.addClass("auto-list-selected").css("background-color",this.selectedColor);
			var desc = divElement.get(0).assistElement.showItemDescription(this.filterInput.val());
			this.rightPanel.children().html(desc);
			this.rightPanel.children().children().css("word-wrap","break-word");
			var pC = this.rightPanel;
			var pI = this.rightPanel.children();
			if (pI.height() > pC.height()) {
				pC.css("overflow-y","scroll");
				pC.scrollTop(0);
			} else {
				pC.css("overflow-y","hidden");
			}
			
			var p = divElement.parent().parent();
			var s = divElement;
			if (
				p.css("overflow-y") == "scroll" && 
				(s.offset().top - p.offset().top + s.height() ) > (p.height())
			) {
				p.scrollTop( (s.offset().top - p.offset().top + s.height() + p.scrollTop()) -  p.height() );
			} else if (
				p.css("overflow-y") == "scroll" && 
				(s.offset().top - p.offset().top ) < 0
			){
				p.scrollTop( p.scrollTop() + (s.offset().top - p.offset().top ) );
			}
		}
		this.showItemList = function() {
			var that = this;
			var text = this.searchInput.val();
			var list = [];
			if ( typeof(text) != 'undefined' && text != null) { // && text.length > 0) {
				var c = this.cache.get(text);
				if ( c != null) {
					list = c;
				} else {
					list = this.getItemList(text);
					this.cache.put(text, list);
				}
			}
			var listS = this.getSpecialItemList(text);
			if (list.length == 0 ){
				var e = {
					showItemName : function() {
						var div = $("<div>");
						div.text("Aucun assistant disponible");
						return div;
					},
					showItemDescription : function() {
						var div = $("<div>");
						var div2 = $("<div>");
						var h = $("<h5>");
						h.text("Aucun assistant disponible");
						h.css("margin-top", "3px");
						h.css("margin-bottom", "3px");
						if (text.length >= 3) {
							div2.text("Aucun assistant \u00E0 \u00E9t\u00E9 trouv\u00E9 avec le terme '"+text+"'.");
						} else {
							div2.text("Vous devez entrer 3 caract\u00E8res pour que la recherche soit effectu\u00E9e.")
						}
						div.append(h).append(div2);
						return div;
					},mustCloseWhenSelect: false,
					select: function() {
						that.searchInput.focus();
					}
				};
				listS.push(e);
			}
			//Prepare elements
			for (var i = 0; i < list.length; i++) {
				if ( ! list[i].showItemName) {
					list[i].showItemName = this.defaultShowItemName;
				}
				if ( ! list[i].showItemDescription) {
					list[i].showItemDescription = this.defaultShowItemDescription;
				}
				if ( ! list[i].select) {
					list[i].select = this.defaultSelect;
				}
				if ( typeof(list[i].mustCloseWhenSelect) == 'undefined' || list[i].mustCloseWhenSelect == null) {
					list[i].mustCloseWhenSelect = this.defaultMustCloseWhenSelect;
				}
			}
			
			//FILTER
			var f = this.filterInput.val().trim();
			if (f.length > 0) {
				var list2 = list;
				list = new Array();
				for (var i = 0; i < list2.length; i++) {
					var t = $("<div>").html(list2[i].showItemDescription()).text();
					var n = $("<div>").html(list2[i].showItemName()).text();
					if (n.indexOf(f) != -1 || t.indexOf(f) != -1) {
						list.push(list2[i]);
					}
				}
			}
			
			for (var i = 0; i < listS.length; i++) {
				if ( ! listS[i].showItemName) {
					listS[i].showItemName = this.defaultSpecialShowItemName;
				}
				if ( ! listS[i].showItemDescription) {
					listS[i].showItemDescription = this.defaultSpecialShowItemDescription;
				}
				if ( ! listS[i].select) {
					listS[i].select = this.defaultSelect;
				}
				if ( typeof(listS[i].mustCloseWhenSelect) == 'undefined' || listS[i].mustCloseWhenSelect == null) {
					listS[i].mustCloseWhenSelect = this.defaultMustCloseWhenSelect;
				}
			}
			
			this.leftPanel.children().children().remove();

			var fnOver = function() {
				that.showThisOne($(this));
			}
			var fnClick = function() {
				that.selectSelected();
			}
			
			for (var i = 0; i < listS.length; i++) {
				var d = listS[i].showItemName(f);
				d.get(0).assistElement = listS[i];
				d.addClass("auto-left-panel-element");
				applyCss("left-panel-element",d);
				this.leftPanel.children().append(d);
				d.mouseover(fnOver);
				d.click(fnClick);
			}
			for (var i = 0; i < list.length; i++) {
				var d = list[i].showItemName(f);
				d.get(0).assistElement = list[i];
				d.addClass("auto-left-panel-element");
				applyCss("left-panel-element",d);
				this.leftPanel.children().append(d);
				d.mouseover(fnOver);
				d.click(fnClick);
			}
			
			var pC = this.leftPanel;
			var pI = this.leftPanel.children();
			if (pI.height() > pC.height()) {
				pC.css("overflow-y","scroll");
			} else {
				pC.css("overflow-y","hidden");
			}
			if (this.leftPanel.children().children().size()) {
				this.showThisOne(this.leftPanel.children().children().first());
			}
		}
		
		this.init = function() {
			this.element = $("#"+this.id);
			
			var positionner = $("<div>");
			var container = $("<div>");
			var table = $("<table>");
			this.assistDiv = container;
			
			positionner.addClass("auto-positionner");
			positionner.css("position","relative");

			//Calculate maxWidth
			var w = Math.max(this.size.minWidth, this.element.width());
			w = Math.min(w, this.size.maxWidth);

			var tr1 = $("<tr>");
			var tr2 = $("<tr>");
			var tr3 = $("<tr>");
			var tdInput = $("<td>");
			var tdList = $("<td>");
			var tdDescription = $("<td>");
			var tdLegend = $("<td>");
			
			//Set the general table
			container.css({
				"visibility":"hidden",
				"position":"absolute",
				"box-sizing":"border-box",
				"-moz-box-sizing":"border-box",
				"z-index":"100",
				"width": (w+5)+"px",
			});
			table.css({
				"border-collapse":"separate",
				"border-spacing":"2px;",
				"box-sizing":"border-box",
				"-moz-box-sizing":"border-box",
			});
			tdDescription.css("vertical-align","top");
			tdList.css("vertical-align","top");
			applyCss("container-td",tdInput);
			applyCss("container-td",tdList);
			applyCss("container-td",tdDescription);
			applyCss("container-td",tdLegend);
			
			tdDescription.attr("rowspan","2");
			tdLegend.attr("colspan","2");
			
			var lw = Math.floor(this.size.nWidth / 100 * w - this.size.distance);
			tdInput.css("width",lw+"px");
			tdDescription.css("width",(w-lw)+"px");
			
			//BUILD INPUT
			var hInput = $("<input type='text'>");
			var fInput = $("<input type='text'>");
			
			applyCss("search-input",hInput);
			applyCss("search-input",fInput);
			
			tdInput.append(hInput);
			tdInput.append(fInput);
			
			this.searchInput = hInput;
			this.filterInput = fInput;
			//BUILD LIST
			var panelLC = $("<div>");
			var panelL = $("<div>");
			this.leftPanel = panelLC;
			panelLC.append(panelL);
			tdList.append(panelLC);
			applyCss("container-div",panelLC);

			//BUILD DESCRIPTION
			var panelRC = $("<div>");
			var panelR = $("<div>");
			this.rightPanel = panelRC;
			panelRC.append(panelR);
			tdDescription.append(panelRC);
			applyCss("container-div",panelRC);
			
			//RECONSTITUTION
			tr1.append(tdInput).append(tdDescription);
			tr2.append(tdList);
			tr3.append(tdLegend);
			table.append(tr1).append(tr2);

			container.append(table);
			positionner.append(container);
			
			this.element.before(positionner);
			this.open = false;
			this.setOpenTrigger($("#"+this.id), this);
			this.initSearchInput();
			this.initFilterInput();
			positionner.click(function(e) {
				e.stopPropagation();
				e.preventDefault();
			});
			var that = this;
			$(document).click(function(e) {
				that.closeAssistant();
			});
			
			//BUILD AND FIX WIDTH LEGEND
			var legend = this.buildLegend();
			if (legend != null) {
				table.append(tr3);
				tdLegend.width(tdLegend.width()+"px");
			}
			if (legend != null) {
				tdLegend.append(legend);
			}

			//FIX HEIGHT
			tdList.height(this.size.height+"px");
			var h1 = tdDescription.height();
			tdDescription.height(h1+"px");
			var h2 = tdDescription.height();
			if (h1 != h2) {
				tdDescription.height((h1+(h2-h1))+"px");
			}
			panelRC.height(panelRC.height()+"px");
			panelLC.height(panelLC.height()+"px");
			
			//FIX WIDTH 
			panelRC.width(panelRC.width()+"px");
			panelLC.width(panelLC.width()+"px");
			
			//FORCE LAST CSS
			container.css({
				"visibility":"",
				"display":"none",
			});

			this.buildExtension();
		}
		
		this.selectSelected = function() {
			var s = this.leftPanel.find(".auto-left-panel-element.auto-list-selected");
			if (s.size() == 1) {
				var assist = s.get(0).assistElement;
				assist.select(this);
				if (assist.mustCloseWhenSelect) {
					this.closeAssistant();
				}
			}
		}
		
		this.initSearchInput = function() {
			var input = this.searchInput;
			var that = this;
			input.keyup(function(e) {
			
				if (e.which == 27) {
					e.preventDefault();
					e.stopPropagation();
					that.closeAssistant();
				} else if (e.which == 40) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").next();
					if (s.size() == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").first();
					}
					that.showThisOne(s);
				} else if (e.which == 38) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").prev();
					if (s.size() == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").last();
					}
					that.showThisOne(s);
				} else if (e.which == 13) {
					e.preventDefault();
					e.stopPropagation();
					that.selectSelected();
				} else if (
					e.which != 9
					&& e.which != 16
					&& e.which != 17
					&& e.which != 18
				){
					that.showItemList();
				}

			});
		}
		
		this.initFilterInput = function() {
			var input = this.filterInput;
			var that = this;
			input.keyup(function(e) {
			
				if (e.which == 27) {
					e.preventDefault();
					e.stopPropagation();
					that.closeAssistant();
				} else if (e.which == 40) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").next();
					if (s.size() == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").first();
					}
					that.showThisOne(s);
				} else if (e.which == 38) {
					e.preventDefault();
					e.stopPropagation();
					var s = that.leftPanel.find(".auto-left-panel-element.auto-list-selected").prev();
					if (s.size() == 0) {
						s = that.leftPanel.find(".auto-left-panel-element").last();
					}
					that.showThisOne(s);
				} else if (e.which == 13) {
					e.preventDefault();
					e.stopPropagation();
					that.selectSelected();
				} else if (
					e.which != 9
					&& e.which != 16
					&& e.which != 17
					&& e.which != 18
				){
					that.showItemList();
				}
			});
		}
		
		this.openAssistant = function() {
			var vPos = this.getVerticalPosition(this);
			this.assistDiv.css("top",vPos+"px");
			this.assistDiv.show();
			this.onOpen();
			this.showItemList();
			this.activeTime = (new Date()).getTime();
		}
		this.closeAssistant = function() {
			var nTime = (new Date()).getTime();
			var oTime = this.activeTime || null;
			if (oTime != null && nTime - oTime > 300) {
				this.activeTime = null;
				this.assistDiv.hide();
				this.regainFocus();
			}
		}

		this.id = id;
		this.size = {
			height: 250,	//Hauteur total
			dWidth: 50,		//Largeur description (%)
			nWidth: 50,		//Largeur nom (%)
			minWidth: 400,	//Largeur min (px)
			maxWidth: 900,	//Largeur min (px)
			distance: 2		//Distance entre les paneaux
		}
		this.selectedColor = "rgb(207,198,159)";
		
		
		this.init();

	}
	
	function applyCss(cssClass, element) {
		var css = CSS[cssClass];
		if (css != null && typeof(css) != 'undefined') {
			element.css(css);
		} else {
//			console.log("failed to "+cssClass);
		}
	}
	
	
	
	function CacheList() {
		var cache = {};//{key:?, obj:[?]}
		
		this.get = function(key) {
			return cache[key] || null;
		}
		
		this.put = function( key, obj) {
			if (typeof(key) != 'undefined' && key != null) {
				cache[key] = obj;
			}
		}
	}
	
	
	CSS = {}
/*	private static final Color BG_COLOR = ResourceGetter.getColor(201,156,71);
	private static final Color INNER_COLOR = ResourceGetter.getColor(242,232,187);
	private static final Color TEXT_COLOR = ResourceGetter.getColor(31,32,25);
	private static final Color SEARCH_COLOR = ResourceGetter.getColor(255,255,255);
*/
	CSS['container-td'] = {
		"padding":"1px",
		"color":"rgb(31,32,25)",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};
	CSS['container-div'] = {
		"width": '100%',
		"height": '100%',
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
		"overflow":"hidden",
	};
	CSS['auto-panel'] = {
		"width":"100%",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};
	CSS['search-input'] = {
		"width":"98%",
		"margin":"0",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
		"margin-bottom":"3px",
		"background-color":"rgb(255,255,255))",
		"border":"1px solid #ccc"
	};
	CSS['left-panel-element'] = {
		"overflow":"hidden",
		"padding":"2px 5px",
	};

/*	CSS['border-box'] = {
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};
	CSS['auto-positionner'] = {
		"position":"relative",
		"top":"0px",
	};
	CSS['auto-positionner-sub-div'] = {
		"position":"absolute",
		"top":"0px",
		"display":"none",
	};
	CSS['full-width'] = {
		"width":"100%"
	};
	CSS['head-input'] = {
		"width":"100%",
		"border":"none",
		"background-color":"rgb(242,220,94)"
	};
	CSS['left-panel'] = {
		"float":"left",
		"margin":"2px 1px 2px 0px",
		"overflow":"hidden",
	};
	CSS['right-panel'] = {
		"float":"right",
		"margin":"2px 0px 2px 1px",
		"overflow":"hidden",
		"padding":"2px 5px"
	};
	CSS['right-panel-element'] = {
		"word-wrap":"normal"
	};
	CSS['normal-panel'] = {
		"background-color":"rgb(230,209,115)",
		"border":"1px solid rgb(179,163,89)",
		"box-sizing":"border-box",
		"-moz-box-sizing":"border-box",
	};*/

})(AutoComplete)
