/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.resource.BadResource;
import ca.infodata.ofys.ui.browser.resource.URLResource2;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.SonarRythmTemplateResource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.osgi.framework.BundleContext;
import org.rythmengine.RythmEngine;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.resource.ResourceLoaderBase;
import org.rythmengine.resource.TemplateResourceManager;

public class SonarTemplateResourceLoader
extends ResourceLoaderBase
implements ITemplateResourceLoader {
    private static final Logger logger = Logger.getLogger(ClasspathResourceHandler.class.getName());
    private RythmEngine engine;
    private ComponentLoader cloader;

    SonarTemplateResourceLoader() {
    }

    public ComponentLoader getCloader() {
        return this.cloader;
    }

    public void setCloader(ComponentLoader cloader) {
        this.cloader = cloader;
    }

    public Resource getResource(String path) throws MalformedURLException {
        if (this.cloader != null) {
            BundleContext loader = this.cloader.getCtx();
            String path2 = path;
            URL url = loader.getBundle().getResource(path2);
            if (url != null) {
                path2 = URIUtil.canonicalPath((String)path);
                return SonarTemplateResourceLoader.newResource(url, true);
            }
        }
        return null;
    }

    private static Resource newResource(URL url, boolean useCaches) {
        if (url == null) {
            return null;
        }
        String url_string = url.toExternalForm();
        if (url_string.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url);
                return fileResource;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error loading resource with url " + url, e);
                return new BadResource(url, e.toString());
            }
        }
        if (url_string.startsWith("jar:file:")) {
            logger.severe("unsupported resource type jar:file with url " + url);
            return new BadResource(url, "unsupported resource type jar:file");
        }
        if (url_string.startsWith("jar:")) {
            logger.severe("unsupported resource type jar: with url " + url);
            return new BadResource(url, "unsupported resource type jar:");
        }
        return new URLResource2(url, null, useCaches);
    }

    public void setEngine(RythmEngine engine) {
        this.engine = engine;
    }

    public RythmEngine getEngine() {
        return this.engine;
    }

    public String getResourceLoaderRoot() {
        String root = this.cloader.getComponentPath();
        return root;
    }

    public ITemplateResource load(String path) {
        try {
            Resource res = this.getResource(path);
            SonarRythmTemplateResource t = new SonarRythmTemplateResource(res, this);
            return t;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void scan(TemplateResourceManager manager) {
        System.out.println("Render Engine:::::Scan feature Not implemeted");
        System.out.println("King stuff!");
    }
}

