/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.ui.browser.sonar.ActionResult;
import ca.infodata.ofys.ui.browser.sonar.ComponentLoader;
import ca.infodata.ofys.ui.browser.sonar.Controller;
import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.IRenderEngine;
import ca.infodata.ofys.ui.browser.sonar.RythmRenderEngine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.http.PathMap;
import org.osgi.framework.BundleContext;
import org.rythmengine.Rythm;

public class SonarDispatcher {
    private static final Logger logger = Logger.getLogger(SonarDispatcher.class.getName());
    public IRenderEngine renderer = new RythmRenderEngine();
    private static SonarDispatcher sonar = null;
    private PathMap<Object> pathMap;
    public static final String INSERTPARAM = "insert";
    public static final String CALLBACKPARAM = "cb";
    public static final String API_DATA_KEY = "data";

    private SonarDispatcher() {
    }

    public static SonarDispatcher getInstance() {
        if (sonar == null) {
            sonar = new SonarDispatcher();
        }
        return sonar;
    }

    public static Controller getController(String target) {
        return SonarDispatcher.getInstance().getMatch((String)target).cloader.getCtrl();
    }

    public ViewConfig getMatch(String target) {
        if (this.pathMap == null) {
            return null;
        }
        PathMap.MappedEntry match = this.pathMap.getMatch(target);
        if (match == null) {
            return null;
        }
        ViewConfig config = new ViewConfig();
        config.cloader = (ComponentLoader)match.getValue();
        return config;
    }

    public String callback(IComponent elem, ViewConfig config) {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String skin = elem.getSkin();
        if (skin != null && !skin.isEmpty()) {
            elem.getResponse().put("view", skin);
        }
        if (config.callback == null || config.callback.equals("")) {
            String string = config.callback = config.params.containsKey(CALLBACKPARAM) ? config.params.get(CALLBACKPARAM) : "";
        }
        if (config.params.containsKey(INSERTPARAM)) {
            String updateElement = config.params.get(INSERTPARAM);
            elem.getResponse().put("updateElement", updateElement);
        }
        String data = elem.getResponse().size() == 1 && elem.getResponse().containsKey(API_DATA_KEY) ? gson.toJson(elem.getResponse().get(API_DATA_KEY)) : gson.toJson(elem.getResponse());
        return data;
    }

    public void addControllers(Map<String, Controller> mapping, BundleContext context, String viewFolder) {
        for (String pattern : mapping.keySet()) {
            ComponentLoader cloader = new ComponentLoader(mapping.get(pattern), context, viewFolder);
            this.addController(pattern, cloader);
        }
    }

    public void addController(String pattern, ComponentLoader cloader) {
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        if (this.pathMap.containsKey((Object)pattern)) {
            throw new IllegalArgumentException("The Path " + pattern + "is already mapped");
        }
        if (cloader.getCtrl() == null) {
            throw new NullPointerException("Controller");
        }
        if (pattern == null || pattern.length() == 0 || !pattern.startsWith("/")) {
            throw new IllegalArgumentException("pattern");
        }
        if (this.pathMap == null) {
            this.pathMap = new PathMap(true);
        }
        this.pathMap.put(pattern, (Object)cloader);
    }

    public ViewConfig processQuery(ViewConfig config) {
        if (config.query == null || config.query.equals("")) {
            return config;
        }
        HashMap<String, String> tempParams = new HashMap<String, String>();
        if (config.query.contains("?")) {
            String[] temp = config.query.split("\\?");
            config.path = temp[0];
            String[] params = temp[1].split("&");
            int i = 0;
            while (i < params.length) {
                temp = params[i].split("=");
                if (temp.length > 1) {
                    tempParams.put(temp[0], temp[1]);
                }
                ++i;
            }
            config.params = tempParams;
        } else {
            config.path = config.query.trim();
            config.params = new HashMap<String, String>();
        }
        return config;
    }

    public String renderComponent(IComponent view, ViewConfig config) {
        try {
            this.renderer.setRoot(config.cloader);
            return config.partial != false ? this.renderer.getViewContent(view) : this.renderer.getViewPartialContent(view);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorPage = "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"><title>500</title></head><body><h1>Erreur 500</h1><p>Nous somme desol\u00e9, une erreur s'est produit. Essayer de redemarer le logiciel. Si le probl\u00e8me persistent contactez INFO-DATA.</p></body></html>";
            return errorPage;
        }
    }

    public String getView(ViewConfig config) {
        IComponent comp = this.getComponent(config);
        String res = this.renderComponent(comp, config);
        return res;
    }

    @Deprecated
    public String getViewPath(ViewConfig config) {
        return this.renderer.getView(this.getComponent(config));
    }

    @Deprecated
    public String getPartialPath(ViewConfig config) {
        IComponent component = this.getComponent(config);
        String res = this.renderer.getPartialView(component);
        return res;
    }

    public IComponent getComponent(ViewConfig config) {
        if (config.path == null) {
            this.processQuery(config);
        }
        try {
            ActionResult res = config.cloader.getCtrl().getAction(config.path, config.params);
            if (res == null) {
                if (config.cloader.getCtrl().response != null) {
                    config.cloader.getCtrl().response.sendError(400, "Ressource non trouv\u00e9e " + config.path);
                }
                return this.NotFound(config.path);
            }
            return res;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Request error 500 " + config.cloader.getComponentPath() + ": ", e);
            try {
                if (config.cloader.getCtrl().response != null) {
                    config.cloader.getCtrl().response.sendError(500, "Request error 500 " + config.path + ": " + e.getMessage());
                }
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Request error 500 " + config.cloader.getComponentPath() + ": ", e);
            }
            return this.ErrorOccured(config.path);
        }
    }

    private IComponent NotFound(String uri) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uri", uri);
        ActionResult res = new ActionResult("notFound400");
        res.setSkin(Rythm.render((String)"<h1>Impossible de trouver les ressources demand\u00e9es.</h1><p>La requ\u00eate \"@(uri)\" a produit une erreur</p><p>@(msg)</p>", (Object[])new Object[]{uri}));
        return res;
    }

    private IComponent ErrorOccured(String uri) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("uri", uri);
        ActionResult res = new ActionResult("error500");
        res.setSkin(Rythm.render((String)"<h1>Erreur lors du traitement de la requ\u00eate.</h1><p>La requ\u00eate \"@(uri)\" a produit une erreur</p><p>@(msg)</p>", (Object[])new Object[]{uri}));
        return res;
    }

    public void dispose() {
        this.renderer.dispose();
    }

    public class ViewConfig {
        public Boolean partial;
        public ComponentLoader cloader;
        public String callback;
        public String query;
        public String path;
        public Map<String, String> params;
        public Boolean async;
    }
}

