/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.WriterOutputStream;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JettySonar
extends AbstractHandler {
    private static final Logger logger = Logger.getLogger(JettySonar.class.getName());
    private SonarDispatcher sonar = SonarDispatcher.getInstance();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SonarDispatcher.ViewConfig config = this.initViewConfig(target, request, response);
        String requestObject = "";
        if (config == null) {
            return;
        }
        if (request.getMethod().equals("POST") && (requestObject = this.doPost(request)).length() > 0) {
            config.params.put("jsonData", requestObject);
        }
        try {
            byte[] content = this.resolveRequest(config);
            baseRequest.setHandled(true);
            if (config.cloader.getCtrl().response.isCommitted()) {
                return;
            }
            JettySonar.doResponse(content, response);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Request error 500" + target + ": ", e);
            e.printStackTrace();
            try {
                response.sendError(500);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private SonarDispatcher.ViewConfig initViewConfig(String target, HttpServletRequest request, HttpServletResponse response) {
        SonarDispatcher.ViewConfig config = this.sonar.getMatch(target);
        String path = request.getPathInfo();
        if (config == null || path == null) {
            return null;
        }
        config.path = path;
        config.cloader.getCtrl().request = request;
        config.cloader.getCtrl().response = response;
        try {
            config.params = this.getParams(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        config.partial = true;
        config.async = true;
        return config;
    }

    private Map<String, String> getParams(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Map raw = request.getParameterMap();
        for (String key : raw.keySet()) {
            String[] str = (String[])raw.get(key);
            params.put(key, str[0]);
        }
        return params;
    }

    public byte[] resolveRequest(SonarDispatcher.ViewConfig config) {
        byte[] res = null;
        config = this.sonar.processQuery(config);
        IComponent view = this.sonar.getComponent(config);
        if (config.cloader.getCtrl().response.isCommitted()) {
            return null;
        }
        String content = this.resolveComponentToString(config, view);
        try {
            res = content.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String mime = JettySonar.getViewMime(view.getSkinPath(), this.isJson(config.params, view.isJson()));
        JettySonar.doResponseHeaders(config.cloader.getCtrl().response, res.length, mime);
        return res;
    }

    public String resolveComponentToString(SonarDispatcher.ViewConfig config, IComponent view) {
        String content = "";
        boolean json = false;
        if (view != null) {
            if (view.getSkin() != null) {
                content = view.getSkin();
            } else {
                content = this.sonar.renderComponent(view, config);
                view.setSkin(content);
            }
        } else {
            return null;
        }
        json = config.params.containsKey("cb");
        if (json) {
            view.getResponse().put("cb", config.params.get("cb"));
        }
        if (json || config.params.containsKey("insert") || view.isJson()) {
            try {
                content = this.sonar.callback(view, config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private boolean isJson(Map<String, String> params, boolean isJson) {
        return params.containsKey("cb") || params.containsKey("insert") || isJson;
    }

    public static String getViewMime(String path, boolean isJson) {
        MimeTypes mimeType = new MimeTypes();
        String mime = isJson ? "application/json" : (path != null && !path.isEmpty() ? mimeType.getMimeByExtension(path).toString() : "text/html");
        return mime;
    }

    private String doPost(HttpServletRequest request) {
        String res = "";
        String line = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), "UTF-8"));
            while ((line = bufferedReader.readLine()) != null) {
                res = String.valueOf(res) + line + "\n";
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    protected static void doResponseHeaders(HttpServletResponse response, long length, String mimeType) {
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        if (response instanceof Response) {
            HttpFields fields = ((Response)response).getHttpFields();
            if (length > 0L) {
                fields.putLongField(HttpHeader.CONTENT_LENGTH, length);
            }
        } else if (length > 0L) {
            response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), String.valueOf(length));
        }
    }

    private static void doResponse(byte[] content, HttpServletResponse response) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(content);
            out.close();
        }
        catch (IllegalStateException illegalStateException) {
            try {
                out = new WriterOutputStream((Writer)response.getWriter(), "UTF-8");
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendFile(String fileName, byte[] fileContent, HttpServletResponse response) {
        JettySonar.doResponseHeaders(response, fileContent.length, JettySonar.getViewMime(fileName, false));
        response.setHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
        JettySonar.doResponse(fileContent, response);
    }
}

