/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import ca.infodata.ofys.ui.browser.sonar.IComponent;
import ca.infodata.ofys.ui.browser.sonar.SonarDispatcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Display;

public class BrowserSonar {
    private Browser browser;
    private Job resourceJob;
    private SonarDispatcher sonar = SonarDispatcher.getInstance();

    public BrowserSonar(Browser browser) {
        this.browser = browser;
        new GetView(browser, "view");
    }

    private void callback(IComponent elem, SonarDispatcher.ViewConfig config) {
        String data = this.sonar.callback(elem, config);
        this.browser.execute("updateScript(" + data + ")");
        if (!config.callback.equals("")) {
            this.browser.execute(String.valueOf(config.callback) + "(" + data + ")");
        }
    }

    private boolean canStartJob(String jobName) {
        boolean makeJob;
        if (this.resourceJob != null) {
            if (!this.resourceJob.getName().equals(jobName)) {
                this.resourceJob.done(Status.CANCEL_STATUS);
                this.resourceJob = null;
                makeJob = true;
            } else {
                makeJob = false;
            }
        } else {
            makeJob = true;
        }
        return makeJob;
    }

    public void getAsyncView(final SonarDispatcher.ViewConfig config) {
        String jobName = "Obtention du ressource " + config.query;
        if (this.canStartJob(jobName)) {
            this.resourceJob = new Job(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    BrowserSonar.this.getAsyncView(config, (IProgressMonitor)subMonitor.newChild(100));
                    subMonitor.done();
                    return Status.OK_STATUS;
                }
            };
        }
        if (this.resourceJob.getState() == 4) {
            System.out.println("Ressource already running");
        } else {
            this.resourceJob.schedule();
        }
    }

    private void asyncCallback(final IComponent elem, final SonarDispatcher.ViewConfig config) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                BrowserSonar.this.callback(elem, config);
            }
        });
        this.resourceJob = null;
    }

    public void getAsyncView(SonarDispatcher.ViewConfig config, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IComponent view = this.sonar.getComponent(config);
        subMonitor.worked(40);
        String res = this.sonar.renderComponent(view, config);
        subMonitor.worked(30);
        view.setSkin(res);
        subMonitor.worked(10);
        if (monitor.isCanceled()) {
            return;
        }
        this.asyncCallback(view, config);
        subMonitor.done();
    }

    public class GetView
    extends BrowserFunction {
        private Browser browser;

        public GetView(Browser browser, String name) {
            super(browser, name);
            this.browser = browser;
        }

        public Object function(Object[] arguments) {
            try {
                SonarDispatcher.ViewConfig config = this.getConfig(arguments);
                if (!config.async.booleanValue()) {
                    return BrowserSonar.this.sonar.getView(config);
                }
                BrowserSonar.this.getAsyncView(config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private SonarDispatcher.ViewConfig getConfig(Object[] arguments) {
            if (arguments.length > 2) {
                String query = (String)arguments[0];
                SonarDispatcher.ViewConfig config = BrowserSonar.this.sonar.getMatch(query);
                if (config == null) {
                    this.browser.execute("updateScript(" + null + ")");
                    throw new IllegalArgumentException("Invalid Request. No match was found for the browser request " + query);
                }
                config.cloader.getCtrl().browser = this.browser;
                config.query = query;
                config.callback = (String)arguments[1];
                config.partial = (Boolean)arguments[2];
                config.async = arguments.length > 3 ? (Boolean)arguments[3] : true;
                return config;
            }
            throw new IllegalArgumentException("Illegal number of parameters for view function");
        }
    }
}

