/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.dossier.lib.FileUtil;
import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.ofys.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class SyraSocket
extends WebSocketAdapter {
    private static final Logger LOG = Log.getLogger(SyraSocket.class);
    private Session session;
    private RemoteEndpoint remote;
    private static Map<String, SyraSocket> instances = new ConcurrentHashMap<String, SyraSocket>();
    private String clientUid;
    private Map<String, File> linkedFiles = new ConcurrentHashMap<String, File>();

    public static Map<String, SyraSocket> getInstances() {
        return instances;
    }

    public void sendMessage(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            LOG.info("Sending message [{}]", new Object[]{message});
            this.remote.sendStringByFuture(message);
        }
    }

    public final String getClientUid() {
        return this.clientUid;
    }

    public final void setClientUid(String clientUid) {
        this.clientUid = clientUid;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        this.session = null;
        this.remote = null;
        instances.remove(this.getClientUid());
        this.deleteFileLinkedToSession(null);
        LOG.info("WebSocket Close: {} - {}", new Object[]{statusCode, reason});
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
        this.session.setIdleTimeout(TimeUnit.HOURS.toMillis(24L));
        this.remote = this.session.getRemote();
        Map parameterMap = this.session.getUpgradeRequest().getParameterMap();
        LOG.info("WebSocket Connect: {}", new Object[]{session});
        LOG.info("clientUid: {}", new Object[]{parameterMap.get("u")});
        List list = (List)parameterMap.get("u");
        if (list != null && !list.isEmpty()) {
            String uid = (String)list.get(0);
            this.setClientUid(uid);
            instances.put(uid, this);
        } else {
            System.out.println("u est nul??? ");
        }
    }

    public void onWebSocketError(Throwable cause) {
        LOG.warn("WebSocket Error", cause);
    }

    public void onWebSocketText(String message) {
        if (this.session != null && this.session.isOpen() && this.remote != null) {
            LOG.info("Echoing back text message [{}]", new Object[]{message});
            this.remote.sendStringByFuture(message);
        }
    }

    public void addFileLinkToSession(String fileName, String data) {
        if (StringUtils.isNotEmpty((String)fileName) && StringUtils.isNotEmpty((String)data)) {
            File file = new File(String.valueOf(LibPlugin.MEDOFFICE_HOME) + fileName);
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            FileUtil.saveToFile((File)file, (InputStream)is);
            this.linkedFiles.put(fileName, file);
        }
    }

    public void deleteFileLinkedToSession(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            for (Map.Entry<String, File> file : this.linkedFiles.entrySet()) {
                if (file.getValue() == null || !file.getValue().exists()) continue;
                file.getValue().delete();
            }
        } else {
            File file = this.linkedFiles.get(fileName);
            if (file != null && file.exists()) {
                file.delete();
            }
        }
    }
}

