/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser;

import ca.infodata.dossier.database.ConnectionFactory;
import ca.infodata.ofys.SyraGlobalSettings;
import ca.infodata.ofys.ui.browser.Activator;
import ca.infodata.ofys.ui.browser.ClasspathResourceHandler;
import ca.infodata.ofys.ui.browser.SyraSocket;
import ca.infodata.ofys.ui.browser.SyraSocketServlet;
import ca.infodata.ofys.ui.browser.sonar.JettySonar;
import ca.infodata.ofys.ui.library.LibPlugin;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class HtmlBrowserTools {
    private static final Logger logger = Logger.getLogger(HtmlBrowserTools.class.getName());
    private static final int MIN_PORT_NUMBER = 10000;
    private static final int MAX_PORT_NUMBER = 65535;
    private static String HOST = "127.0.0.1";
    private static int randomPort;
    private static Server server;
    private static SyraSocketServlet syraSocketServlet;
    private static ClasspathResourceHandler classpathHandler;
    private static JettySonar dispatchHandler;
    public static final String VIEWER_HTML = "templates/viewer.html";
    public static final String VIEWER_HTML_NO_PRINT = "templates/viewer-noprint.html";
    public static final String VIEWER_IMAGE_HTML = "templates/viewer_image.html";
    private static Map<String, String> originalHtmlTemplates;

    static {
        originalHtmlTemplates = new HashMap<String, String>();
    }

    public static int getJettyPort() {
        return randomPort;
    }

    public static String getHost() {
        return "http://" + HOST + ":" + HtmlBrowserTools.getJettyPort();
    }

    public static String getUrl(String path) {
        return String.valueOf(HtmlBrowserTools.getHost()) + path;
    }

    public static synchronized ClasspathResourceHandler getClasspathHandler() {
        return classpathHandler;
    }

    public static synchronized void startJetty(BundleContext bundleContext) {
        SyraGlobalSettings settings = SyraGlobalSettings.getInstance(ConnectionFactory.connectionLabel);
        boolean shareConn = settings.getBoolean("share_shareConn");
        boolean staticPort = settings.getBoolean("share_staticPort");
        boolean needsPswd = settings.getBoolean("share_needsPswd");
        String port = settings.get("share_port");
        if (Platform.inDebugMode()) {
            port = "8203";
            settings.set("share_port", port);
        }
        String pswd = settings.get("share_motDePasse");
        HtmlBrowserTools.startJetty(bundleContext, shareConn, staticPort, port, needsPswd, pswd);
    }

    public static synchronized void startJetty(BundleContext bundleContext, boolean shareConn, boolean staticPort, String port, boolean needsPswd, String motDePasse) {
        boolean toolsOk = HtmlBrowserTools.saveFilesToTools();
        randomPort = staticPort && port != null && NumberUtils.isNumber((String)port) ? Integer.parseInt(port) : HtmlBrowserTools.getRandomAvailablePortNumber();
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(randomPort);
        if (!shareConn) {
            connector.setHost(HOST);
        }
        connector.setIdleTimeout(180000L);
        ServletContextHandler context = new ServletContextHandler(1);
        DefaultServlet defaultServlet = new DefaultServlet();
        ServletHolder holder = new ServletHolder((Servlet)defaultServlet);
        holder.setInitParameter("useFileMappedBuffer", "false");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitParameter("cacheControl", "max-age=0, public");
        context.setResourceBase(LibPlugin.OFYS_HOME);
        context.addServlet(holder, "/");
        classpathHandler = new ClasspathResourceHandler();
        classpathHandler.setServer(server);
        classpathHandler.addClassLoader("/tools/*", bundleContext);
        dispatchHandler = new JettySonar();
        dispatchHandler.setServer(server);
        HandlerList handlerList = new HandlerList();
        if (toolsOk) {
            handlerList.addHandler((Handler)classpathHandler);
            handlerList.addHandler((Handler)dispatchHandler);
            handlerList.addHandler((Handler)context);
        } else {
            AbstractHandler handler = new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    response.sendError(500, "Le serveur local n'a pu d\u00e9marrer correctement.\nFermez tous les applications Ofys et red\u00e9marrer Ofys.\nSi le probl\u00e8me persiste, contactez INFO-DATA.");
                }
            };
            handler.setServer(server);
            handlerList.addHandler((Handler)handler);
        }
        server.setConnectors(new Connector[]{connector});
        handlerList.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlerList);
        syraSocketServlet = new SyraSocketServlet();
        ServletHolder wsHolder = new ServletHolder("syrawebsocket", (Servlet)syraSocketServlet);
        context.addServlet(wsHolder, "/syrawebsocket");
        try {
            server.setStopTimeout(5L);
            server.start();
            while (server.isStarting()) {
                logger.log(Level.INFO, "starting jetty");
            }
            logger.log(Level.INFO, "Jetty is " + (server.isStarted() ? "STARTED on PORT " + randomPort + " with base root " + LibPlugin.OFYS_HOME : "NOT started"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to start Jetty ", e);
        }
    }

    public static void saveFileLinkedToSyraSocket(String clientUid, String fileName, String data) {
        SyraSocket ss;
        if (clientUid != null && (ss = SyraSocket.getInstances().get(clientUid)) != null) {
            ss.addFileLinkToSession(fileName, data);
        }
    }

    public static void deleteFileLinkedToSyraSocket(String clientUid, String fileName) {
        SyraSocket ss;
        if (clientUid != null && (ss = SyraSocket.getInstances().get(clientUid)) != null) {
            ss.deleteFileLinkedToSession(fileName);
        }
    }

    public static boolean sendMessageToWebClient(String clientUid, String message) {
        boolean ok = false;
        if (clientUid != null) {
            SyraSocket ss = null;
            int i = 0;
            while (i < 10 && (ss = SyraSocket.getInstances().get(clientUid)) == null) {
                System.out.println("SyraSocket.getInstances().get(clientUid)) == null:" + i);
                try {
                    Thread.sleep(500L);
                    ++i;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (ss != null) {
                ss.sendMessage(message);
                ok = true;
            } else {
                ok = false;
                System.out.println("syraSocket is null for uid " + clientUid);
            }
        } else {
            if (!SyraSocket.getInstances().isEmpty()) {
                for (SyraSocket socket : SyraSocket.getInstances().values()) {
                    socket.sendMessage(message);
                }
            }
            ok = true;
        }
        return ok;
    }

    public static void stopJetty() {
        if (server.isStarted()) {
            try {
                server.stop();
                dispatchHandler.stop();
                classpathHandler.stop();
                server.destroy();
                dispatchHandler.destroy();
                classpathHandler.destroy();
                syraSocketServlet.destroy();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Erreur pour server.stop() de Jetty ", e);
            }
        }
    }

    private static int getRandomAvailablePortNumber() {
        Random r = new Random();
        int p = r.nextInt(55535) + 10000;
        while (!HtmlBrowserTools.available(p)) {
            p = r.nextInt(55535) + 10000;
        }
        return p;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean available(int port) {
        if (port < 10000 || port > 65535) {
            return false;
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        ss = new ServerSocket(port);
        ss.setReuseAddress(true);
        ds = new DatagramSocket(port);
        ds.setReuseAddress(true);
        if (ds != null) {
            ds.close();
        }
        if (ss == null) return true;
        try {
            ss.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (IOException iOException) {
            try {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) return false;
            }
            catch (Throwable throwable) {
                if (ds != null) {
                    ds.close();
                }
                if (ss == null) throw throwable;
                try {
                    ss.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ss.close();
                return false;
            }
            catch (IOException iOException3) {}
            return false;
        }
    }

    private HtmlBrowserTools() {
    }

    public static String getHtmlTemplate(String filename, String ... addItemName) {
        return HtmlBrowserTools.getHtmlTemplate(Activator.getDefault().getBundle(), filename, addItemName);
    }

    public static String getHtmlTemplate(Bundle bundle, String filename, String ... addItemName) {
        String html = null;
        if (html == null) {
            StringWriter writer;
            block6: {
                writer = new StringWriter();
                FileInputStream is = null;
                try {
                    try {
                        URL url = bundle.getEntry(filename);
                        URL resolvedFileURL = FileLocator.toFileURL((URL)url);
                        URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
                        File file = new File(resolvedURI);
                        is = new FileInputStream(file);
                        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Error loading resource " + filename, e);
                        IOUtils.closeQuietly(is);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            html = writer.toString();
        }
        return html;
    }

    public static String escapeSS(String base) {
        return HtmlBrowserTools.escapeSS(base, "\"");
    }

    public static String escapeSS(String base, String stringCollapse) {
        return base.replace("\\", "\\\\").replace(stringCollapse, "\\" + stringCollapse).replace("\r\n", "\\n").replace("\r", "\\n").replace("\n", "\\n");
    }

    public static String replaceString(String base, String pattern, String newString) {
        int index = base.indexOf(pattern);
        if (index != -1) {
            String s = base.substring(0, index);
            s = String.valueOf(s) + newString;
            s = String.valueOf(s) + base.substring(index + pattern.length());
            return s;
        }
        return base;
    }

    public static String formatHtmlString(String txt) {
        return txt.replace("\r\n", "<br/>").replace("\r", "<br/>").replace("\n", "<br/>").replace("  ", " &#160;");
    }

    private static boolean saveFilesToTools() {
        try {
            HtmlBrowserTools.deleteToolsFolders();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to deploy or update tools folder", e);
            return false;
        }
    }

    private static void deleteToolsFolders() {
        try {
            File[] files;
            File rootFolder = new File(LibPlugin.OFYS_HOME);
            File[] fileArray = files = rootFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && (name.startsWith("tools_") || name.equals("tools"));
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to delete old tools folder " + file.getName(), e);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while clean old tools folders ", e);
        }
    }

    public static String[] divideStringAtFirstNewline(String s) {
        int i = s.indexOf("<br />");
        String[] ret = new String[2];
        if (i == -1) {
            ret[0] = new String(s);
            ret[1] = null;
        } else {
            ret[0] = s.substring(0, i);
            ret[1] = s.substring(i + 6);
        }
        return ret;
    }

    public static String getStringFromFile(String file, String url) {
        String s;
        block17: {
            s = file;
            InputStream is = null;
            try {
                try {
                    is = HtmlBrowserTools.class.getResourceAsStream(file);
                    s = IOUtils.toString((InputStream)is, (String)"UTF-8");
                }
                catch (IOException iOException) {
                    if (url != null) {
                        InputStream in = null;
                        try {
                            in = new URL(String.valueOf(url) + file).openStream();
                        }
                        catch (MalformedURLException e2) {
                            logger.log(Level.WARNING, "bad url exception loading file:" + file + ", url:" + url, e2);
                        }
                        catch (IOException e2) {
                            logger.log(Level.WARNING, "oi exception loading file:" + file + ", url:" + url, e2);
                        }
                        if (in != null) {
                            try {
                                try {
                                    s = IOUtils.toString((InputStream)in, (String)"UTF-8");
                                }
                                catch (IOException e) {
                                    logger.log(Level.WARNING, "oi exception loading file:" + file + ", url:" + url, e);
                                }
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)in);
                            }
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return s;
    }

    public static byte[] addPrintedByToPdf(byte[] pdf, String printedBy) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            PdfReader reader = new PdfReader(pdf);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)output);
            int p = 1;
            while (p <= reader.getNumberOfPages()) {
                PdfContentByte overContent = stamper.getOverContent(p);
                BaseFont font = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
                overContent.setFontAndSize(font, 10.0f);
                overContent.beginText();
                float x = overContent.getPdfDocument().getPageSize().getWidth() / 2.0f;
                float y = overContent.getPdfDocument().getPageSize().getBorderWidthBottom() + 5.0f;
                overContent.showTextAligned(1, printedBy, x, y, 0.0f);
                overContent.endText();
                overContent.stroke();
                ++p;
            }
            stamper.close();
        }
        catch (Exception exception) {
            return pdf;
        }
        return output.toByteArray();
    }
}

