/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.base.util.TestConnectionUtility;

public class RemoteStatusData {
    private static int TIMEOUT = 60000;

    public static boolean isAnyRemoteHelpUnavailable() {
        ArrayList sites = RemoteStatusData.getRemoteSites();
        if (sites.isEmpty()) {
            return false;
        }
        int s = 0;
        while (s < sites.size()) {
            if (!RemoteStatusData.isConnected((URL)sites.get(s))) {
                return true;
            }
            ++s;
        }
        return false;
    }

    public static ArrayList checkSitesConnectivity(ArrayList sites) {
        ArrayList badSites = new ArrayList();
        int i = 0;
        while (i < sites.size()) {
            if (!RemoteStatusData.isConnected((URL)sites.get(i))) {
                badSites.add(sites.get(i));
            }
            ++i;
        }
        return badSites;
    }

    public static boolean isConnected(URL site) {
        ConnectionCache cache = ConnectionCache.getCache();
        try {
            return cache.isConnected(site);
        }
        catch (CoreException coreException) {
            boolean connected = TestConnectionUtility.testConnection(site.getHost(), "" + site.getPort(), site.getPath(), site.getProtocol());
            cache.put(site, connected);
            cache.resetTimer();
            return connected;
        }
    }

    public static ArrayList getRemoteSites() {
        ArrayList<URL> sites = new ArrayList<URL>();
        boolean remoteHelpEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        if (!remoteHelpEnabled) {
            return sites;
        }
        String[] hosts = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpHost", "", null).split(",");
        String[] paths = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPath", "", null).split(",");
        String[] protocols = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpProtocol", "", null).split(",");
        String[] ports = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpPort", "", null).split(",");
        String[] enableds = Platform.getPreferencesService().getString("org.eclipse.help.base", "remoteHelpICEnabled", "", null).split(",");
        int i = 0;
        while (i < hosts.length) {
            try {
                if (enableds[i].equalsIgnoreCase("true")) {
                    URL url = new URL(String.valueOf(protocols[i]) + "://" + hosts[i] + ':' + ports[i] + paths[i]);
                    sites.add(url);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return sites;
    }

    public static void clearCache() {
        ConnectionCache.clear();
    }

    private static class ConnectionCache {
        private static ConnectionCache instance;
        private Hashtable cache = new Hashtable();
        private long start;

        private ConnectionCache() {
            this.resetTimer();
        }

        public void resetTimer() {
            this.start = new Date().getTime();
        }

        public static ConnectionCache getCache() {
            if (instance == null || instance.isExpired()) {
                instance = new ConnectionCache();
            }
            return instance;
        }

        public static void clear() {
            instance = null;
        }

        public boolean isExpired() {
            long now = new Date().getTime();
            return now > this.start + (long)TIMEOUT;
        }

        public boolean isConnected(URL url) throws CoreException {
            Boolean b = (Boolean)this.cache.get(url);
            if (b == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.help.base", "Cache Unavailable"));
            }
            return b;
        }

        public void put(URL url, boolean connected) {
            this.cache.put(url, new Boolean(connected));
        }
    }
}

