(function(){
	var app = angular.module("sommaire", ['ui.grid','ui.grid.resizeColumns','ui.grid.grouping', 'ui.grid.infiniteScroll','ngTouch','widget']);
			
	app.controller('SommaireController', ['$scope', '$http', '$log', '$filter', 'uiGridConstants', 'uiGridGroupingConstants', 'clientUid','model','$uibModal', function ($scope, $http, $log, $filter, uiGridConstants, uiGridGroupingConstants, clientUid, model, $uibModal) {
		this.dataLoading = false;
		this.somType = -1;
		this.clientUid = clientUid;
		this.prof = {};
		this.factUrl = "/syra/somm_fact/get";
		this.factEtabUrl = "/syra/somm_fact/get";
		this.factCodesUrl = "/syra/somm_fact/get";
		this.servUrl = "/syra/somm_serv/get";
		this.servEtabUrl = "/syra/somm_serv/get";
		this.servNamUrl = "/syra/somm_serv_nam/get";
		this.andModified = false;
		var that = this;
		that.model = model;
		$scope.model = model;
		
		$scope.def = {
				typeSommaire: function(newVal) {
					if (arguments.length) {
						that.model.setCurrDefaultValues('type_sommaire', newVal);
						that.model.saveCurrDefaultValues('type_sommaire');
						return;
					}
					return that.model.currentDefault()['type_sommaire'];
				},
				andModified: function(newVal) {
					if (arguments.length) {
						that.model.setCurrDefaultValues('sommaire_and_modified', newVal);
						that.model.saveCurrDefaultValues('sommaire_and_modified');
						return;
					}
					return that.model.currentDefault()['sommaire_and_modified'];
				}
		};
		
		$scope.typeSommaires = [
		     {id: 1,label: 'Factures (date de création)'},
		     {id: 2,label: 'Factures - services/date/établ (date de création)'},
		     {id: 3,label: 'Factures avec codes (date de création)'},
		     {id: 4,label: 'Services fournis (date du service)'},
		     {id: 5,label: 'Services fournis/établ (date du service)'},
		     {id: 6,label: 'Services/NAM (date du service)'}
		     ];
		
		$scope.factData = [];
		$scope.factEtabData = [];
		$scope.servData = [];
		$scope.servNamData = [];
		
		that.inscriptions = {
				0:"Non",		
				1:"MD",
				2:"Autre"
		};
		that.OuiNon = {
				0:"Non",
				1:"Oui"
		};
		
		that.jourFeries = {				
				100:"Samedi",
				200:"Dimanche"
		};
		
		$scope.debut = moment().format("YYYY-MM-DD");
		
		var dateDebut = new DynaDate({elem:"dateDebut", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, maxDateElm:'dateFin'});
		dateDebut.onDateSelected = function(selectedDate){
			showJourFerie(null, selectedDate, dateDebut.baseElement);
		};

		var dateFin = new DynaDate({elem:"dateFin", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, minDateElm:'dateDebut'});
		dateFin.getDefault = function(){
			var defaut = moment($scope.debut);
			return defaut;
		};
		dateFin.onDateSelected = function(selectedDate){
			showJourFerie(null, selectedDate, dateFin.baseElement);
		};
		
		function showJourFerie(l, d, o) {
			var type = that.model.isJourFerie(l, d);
			if (type>0) {
				o.addClass("date-ferie");
				o.attr('title',that.jourFeries[type]);
			} else {
				o.removeClass("date-ferie");				
				o.attr('title',"");		
			}
		}
				
		function jNotice(msg, color){
			new jBox('Notice', {
				color : color,
				autoClose: 2500,
			    content: msg
			});
		}
						
		that.doit = function() {
			if ($scope.def.typeSommaire()==1) {
				loadFactData($scope.debut, $scope.fin);
			} else if ($scope.def.typeSommaire()==2) {
				loadFactEtabData($scope.debut, $scope.fin);
			} else if ($scope.def.typeSommaire()==3) {
				loadFactCodesData($scope.debut, $scope.fin);
			} else if ($scope.def.typeSommaire()==4) {
				loadServData($scope.debut, $scope.fin);				
			} else if ($scope.def.typeSommaire()==5) {
				loadServEtabData($scope.debut, $scope.fin);				
			} else if ($scope.def.typeSommaire()==6) {
				loadServNamData($scope.debut, $scope.fin);				
			}
		};
		
		var filterNumber = [{
				condition: uiGridConstants.filter.GREATER_THAN,
				placeholder: ' > que'
        	},
        	{
        		condition: uiGridConstants.filter.LESS_THAN,
        		placeholder: ' < que'
        	}
        	];
		var filterWithNot = {
		          condition: function(searchTerm, cellValue) {
		        	  var st = searchTerm.trim().replace(/\\/g, '').toUpperCase();
		        	  if (st.startsWith('!')) {
		        		  var nst = st.substr(1);
		        		  if (nst.length==0) return true;
	        			  return cellValue? cellValue.toUpperCase().indexOf(nst)===-1: false;	        			  
		        	  } else {
		        		  return cellValue ? cellValue.toUpperCase().indexOf(st)!==-1: false;
		        	  }
		        	  return false;
		          }
			};
		
		$scope.gridFactOptions = { data: $scope.factData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "fact_somm.csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: "Sommaire des factures: " + getIntervalle(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth:480,
			    treeRowHeaderAlwaysVisible: false,
			    exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				appScopeProvider: that,
				columnDefs: [
					{field: 'ii', displayName: 'No. Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Numéro du professionnel qui a rendu le service";}, width: '15%', enableHiding: true, cellTooltip: false},
					{field: 'd', displayName: 'Date',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Date et heure de création";}, width: "20%", enableHiding: true, cellTooltip: false},
					{field: 'hon', displayName: 'Honor.', enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM, customTreeAggregationFinalizerFn: function( aggregation ) {
				          aggregation.rendered = aggregation.value;
				        }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: true, width: "20%"},
					{field: 'pt', displayName: 'Patient',filter: _.cloneDeep(filterWithNot), width: '25%', enableHiding: true, cellTooltip:false},
					{field: 'iu', displayName: 'Util.',enableFiltering:false,enableSorting:false, cellFilter: 'userName:grid.appScope', headerTooltip: function(col) {return "Créée ou modifiée par";}, width: '15%', enableHiding: true, cellTooltip: false}
			 ],
             exporterFieldCallback: function( grid, row, col, input ) {
           	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
           	    var filters = col.cellFilter.split('|');
           	    for(i=0; i<filters.length;i++) {
           	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
           	      var filterName=pars[0].trim();
           	      var filterPar = null;
           	      if (pars.length==2) {
//           	    	  filterPar = pars[1].slice(1, -1);
           	        filterPar = eval(pars[1]);
           	        input = $filter(filterName)( input,filterPar);
           	      } else {
           	        input = $filter(filterName)( input );
           	      }
           	    }
           	  }
           	  return input;
            },
			 onRegisterApi: function(gridApi){
				 $scope.gridFactApi = gridApi;
			}
		};
		
		function loadFactData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.factUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&u=" + that.clientUid + "&m=" +	(that.model.currentDefault()['sommaire_and_modified']?'1':'0'))
			.success(function(data) {
				$scope.gridFactOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridFactApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridFactApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridFactApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridFactApi.treeBase.expandRow(tree[i].row);
						}
						that.dataLoading = false;						
					}
				});
			});
		}
		
		$scope.gridFactEtabOptions = { data: $scope.factEtabData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "fact_etab_somm.csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: "Sommaire des factures / établissements: " + getIntervalle(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth:480,
			    treeRowHeaderAlwaysVisible: false,
			    exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				appScopeProvider: that,
				columnDefs: [
		             { field: 'np', displayName: 'Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "15%"},
		             { field: 'ds', displayName: 'Date',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "17%"},
		             { field: 'lieu', displayName: 'Lieu',filter: _.cloneDeep(filterWithNot), enableSorting:false, grouping: { groupPriority: 2 }, sort: { priority: 2, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "10%"},
		             { field: 'iv', displayName: 'Inscr./vuln.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 3 }, sort: { priority: 3, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "18%"},
		             { field: 'nam', displayName: 'Patient',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 4 }, sort: { priority: 4, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "20%"},
		             { field: 'hon', displayName: 'Honor.', enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM,  customTreeAggregationFinalizerFn: function( aggregation ) {
		            	 aggregation.rendered = aggregation.value;
		             }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: false, width: "12%"},
		             { field: 'cod', displayName: 'Code',filter: _.cloneDeep(filterWithNot), enableSorting:false, width: "10%"},
		             { field: 'dx', displayName: 'Dx',filter: _.cloneDeep(filterWithNot), type:'string', enableSorting:false, width: "15%"}
			 ],
             exporterFieldCallback: function( grid, row, col, input ) {
           	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
           	    var filters = col.cellFilter.split('|');
           	    for(i=0; i<filters.length;i++) {
           	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
           	      var filterName=pars[0].trim();
           	      var filterPar = null;
           	      if (pars.length==2) {
//           	    	  filterPar = pars[1].slice(1, -1);
           	        filterPar = eval(pars[1]);
           	        input = $filter(filterName)( input,filterPar);
           	      } else {
           	        input = $filter(filterName)( input );
           	      }
           	    }
           	  }
           	  return input;
            },
			 onRegisterApi: function(gridApi){
				 $scope.gridFactEtabApi = gridApi;
			}
		};
		
		function loadFactEtabData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.factEtabUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') +"&e=1" + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&u=" + that.clientUid + "&m=" +	(that.model.currentDefault()['sommaire_and_modified']?'1':'0'))
			.success(function(data) {
				$scope.gridFactEtabOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridFactEtabApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridFactEtabApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridFactEtabApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridFactEtabApi.treeBase.expandRow(tree[i].row);
							var tree2 = tree[i].children;
							for (var j = tree2.length-1; j >= 0; j--) {
								$scope.gridFactEtabApi.treeBase.expandRow(tree2[j].row);
							}
						}
						that.dataLoading = false;						
					}
				});
			});
		}
		
		$scope.gridFactCodesOptions = { data: $scope.factData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "fact_somm.csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: "Sommaire des factures: " + getIntervalle(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth:480,
			    treeRowHeaderAlwaysVisible: false,
			    exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				appScopeProvider: that,
				columnDefs: [
					{field: 'ii', displayName: 'No. Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Numéro du professionnel qui a rendu le service";}, width: '14%', enableHiding: true, cellTooltip: false},
					{field: 'd', displayName: 'Date',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Date et heure de création";}, width: "17%", enableHiding: true, cellTooltip: false},
					{field: 'hon', displayName: 'Honor.', enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM, customTreeAggregationFinalizerFn: function( aggregation ) {
				          aggregation.rendered = aggregation.value;
				        }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: true, width: "12%"},
					{field: 'pt', displayName: 'Patient',filter: _.cloneDeep(filterWithNot), width: '15%', enableHiding: true, cellTooltip:false},
					{field: 'cd.toString()', displayName: 'Codes',width: '18%', enableHiding: true, cellTooltip:false},
					{field: 'cd.length', displayName: 'Nb',filters:filterNumber,enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM, customTreeAggregationFinalizerFn: function( aggregation ) {
				          aggregation.rendered = aggregation.value;
				        }, exporterPdfAlign: 'right', enableHiding: true, width: "10%"},
					{field: 'iu', displayName: 'Util.',enableFiltering:false,enableSorting:false, cellFilter: 'userName:grid.appScope', headerTooltip: function(col) {return "Créée ou modifiée par";}, width: '10%', enableHiding: true, cellTooltip: false},
			 ],
             exporterFieldCallback: function( grid, row, col, input ) {
           	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
           	    var filters = col.cellFilter.split('|');
           	    for(i=0; i<filters.length;i++) {
           	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
           	      var filterName=pars[0].trim();
           	      var filterPar = null;
           	      if (pars.length==2) {
//           	    	  filterPar = pars[1].slice(1, -1);
           	        filterPar = eval(pars[1]);
           	        input = $filter(filterName)( input,filterPar);
           	      } else {
           	        input = $filter(filterName)( input );
           	      }
           	    }
           	  }
           	  return input;
            },
			 onRegisterApi: function(gridApi){
				 $scope.gridFactCodesApi = gridApi;
			}
		};
		
		function loadFactCodesData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.factCodesUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&c=1" + "&u=" + that.clientUid + "&m=" +	(that.model.currentDefault()['sommaire_and_modified']?'1':'0'))
			.success(function(data) {
				$scope.gridFactCodesOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridFactCodesApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridFactCodesApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridFactCodesApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridFactCodesApi.treeBase.expandRow(tree[i].row);
						}
						that.dataLoading = false;						
					}
				});
			});
		}
		
		
		$scope.gridServOptions = { data: $scope.servData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "som_serv.csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: "Sommaire des services: " + getIntervalle(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
			    exporterPdfMaxGridWidth:480,
				appScopeProvider: this,
				columnDefs: [
		             { field: 'np', displayName: 'Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "15%"},
		             { field: 'ds', displayName: 'Date',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "17%"},
		             { field: 'iv', displayName: 'Inscr./vuln.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 2 }, sort: { priority: 2, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "18%"},
					 { field: 'nam', displayName: 'Patient',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 3 }, sort: { priority: 3, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "20%"},
					 { field: 'hon', displayName: 'Honor.', enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM,  customTreeAggregationFinalizerFn: function( aggregation ) {
				          aggregation.rendered = aggregation.value;
				        }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: true, width: "12%"},
					 { field: 'cod', displayName: 'Code',filter: _.cloneDeep(filterWithNot),enableHiding: true, enableSorting:false, width: "10%"},
					 { field: 'dx', displayName: 'Dx',filter: _.cloneDeep(filterWithNot),enableHiding: true, enableSorting:false, width: "15%"},
					 { field: 'lieu', displayName: 'Lieu',filter: _.cloneDeep(filterWithNot), enableHiding: true, enableSorting:false, width: "10%"}
			 ],
             exporterFieldCallback: function( grid, row, col, input ) {
           	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
           	    var filters = col.cellFilter.split('|');
           	    for(i=0; i<filters.length;i++) {
           	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
           	      var filterName=pars[0].trim();
           	      var filterPar = null;
           	      if (pars.length==2) {
           	        filterPar = pars[1].slice(1, -1);
           	        input = $filter(filterName)( input,filterPar);
           	      } else {
           	        input = $filter(filterName)( input );
           	      }
           	    }
           	  }
           	  return input;
            },
			 onRegisterApi: function(gridApi){
			    $scope.gridServApi = gridApi;
			 }
		};
			
		function loadServData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.servUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&u=" + that.clientUid)
			.success(function(data) {
				$scope.gridServOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridServApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridServApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridServApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridServApi.treeBase.expandRow(tree[i].row);
							var tree2 = tree[i].children;
							for (var j = tree2.length-1; j >= 0; j--) {
								$scope.gridServApi.treeBase.expandRow(tree2[j].row);
							}
						}
						that.dataLoading = false;						
					}
				});
			});
		}
		
		$scope.gridServEtabOptions = { data: $scope.servEtabData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "som_serv.csv";},
				exporterPdfDefaultStyle: {fontSize: 9},
				exporterPdfTableStyle: {margin: [0,0,0,0]},
				exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
				exporterPdfHeader: function () { return {text: "Sommaire des services par code d'établissement: " + getIntervalle(), style: 'headerStyle' };},
				exporterPdfFooter: function ( currentPage, pageCount ) {
					return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
				},
				exporterPdfCustomFormatter: function ( docDefinition ) {
					docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
					docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
					return docDefinition;
				},
				exporterPdfOrientation: 'portrait',
				exporterPdfPageSize: 'LETTER',
				exportPdfIf: function(gdata){
					if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
					else {
						model.warning(MSG_TEXT['TROP_DATA']);
						return false;
					}
				},
				onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});
					
					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
					}, function () {
						$scope.inscriptionOpened = false;
					});
				},
				exporterPdfMaxGridWidth:480,
				appScopeProvider: this,
				columnDefs: [
				             { field: 'np', displayName: 'Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "15%"},
				             { field: 'ds', displayName: 'Date',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "17%"},
				             { field: 'lieu', displayName: 'Lieu',filter: _.cloneDeep(filterWithNot), enableSorting:false, grouping: { groupPriority: 2 }, sort: { priority: 2, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "10%"},
				             { field: 'iv', displayName: 'Inscr./vuln.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 3 }, sort: { priority: 3, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "18%"},
				             { field: 'nam', displayName: 'Patient',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 4 }, sort: { priority: 4, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "20%"},
				             { field: 'hon', displayName: 'Honor.', enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM,  customTreeAggregationFinalizerFn: function( aggregation ) {
				            	 aggregation.rendered = aggregation.value;
				             }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: false, width: "12%"},
				             { field: 'cod', displayName: 'Code',filter: _.cloneDeep(filterWithNot), enableSorting:false, width: "10%"},
				             { field: 'dx', displayName: 'Dx',filter: _.cloneDeep(filterWithNot),enableSorting:false, width: "15%"}
				             ],
				             exporterFieldCallback: function( grid, row, col, input ) {
				            	 if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
				            		 var filters = col.cellFilter.split('|');
				            		 for(i=0; i<filters.length;i++) {
				            			 var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
				            			 var filterName=pars[0].trim();
				            			 var filterPar = null;
				            			 if (pars.length==2) {
				            				 filterPar = pars[1].slice(1, -1);
				            				 input = $filter(filterName)( input,filterPar);
				            			 } else {
				            				 input = $filter(filterName)( input );
				            			 }
				            		 }
				            	 }
				            	 return input;
				             },
				             onRegisterApi: function(gridApi){
				            	 $scope.gridServEtabApi = gridApi;
				             }
		};
		
		function loadServEtabData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.servEtabUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&e=1&u=" + that.clientUid)
			.success(function(data) {
				$scope.gridServEtabOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridServEtabApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridServEtabApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridServEtabApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridServEtabApi.treeBase.expandRow(tree[i].row);
							var tree2 = tree[i].children;
							for (var j = tree2.length-1; j >= 0; j--) {
								$scope.gridServEtabApi.treeBase.expandRow(tree2[j].row);
							}
						}
						that.dataLoading = false;						
						var nbWatches = $scope.$$watchersCount;
						$log.log("il y a " + nbWatches + " actifs actuellement.");
					}
				});
			});
		}
		
		$scope.gridServNamOptions = { data: $scope.servNamData,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "som_serv_nam.csv";},
				exporterPdfDefaultStyle: {fontSize: 9},
				exporterPdfTableStyle: {margin: [0,0,0,0]},
				exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
				exporterPdfHeader: function () { return {text: "Sommaire des services: " + getIntervalle(), style: 'headerStyle' };},
				exporterPdfFooter: function ( currentPage, pageCount ) {
					return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
				},
				exporterPdfCustomFormatter: function ( docDefinition ) {
					docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
					docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
					return docDefinition;
				},
				exporterPdfOrientation: 'portrait',
				exportPdfIf: function(gdata){
					if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
					else {
						model.warning(MSG_TEXT['TROP_DATA']);
						return false;
					}
				},
				onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Sommaire",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				exporterPdfPageSize: 'LETTER',
				exporterPdfMaxGridWidth:480,
				appScopeProvider: this,
				columnDefs: [
				             { field: 'np', displayName: 'Prof.',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "15%"},
				             { field: 'ds', displayName: 'Date',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "17%"},
				             { field: 'iv', displayName: 'Inscr./vuln.',filter: _.cloneDeep(filterWithNot),grouping: { groupPriority: 2 }, sort: { priority: 2, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, width: "17%"},
				             { field: 'nam', displayName: 'Patient',filter: _.cloneDeep(filterWithNot),width: "20%"},
				             { field: 'hon', displayName: 'Honor.',enableSorting:false,aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM,  customTreeAggregationFinalizerFn: function( aggregation ) {
				            	 aggregation.rendered = aggregation.value;
				             }, exporterPdfAlign: 'right', cellFilter: 'currency', enableHiding: false, width: "12%"},
				             { field: 'cod', displayName: 'Code(s)',filter: _.cloneDeep(filterWithNot),enableSorting:false, width: "20%"},
				             { field: 'dx', displayName: 'Dx',filter: _.cloneDeep(filterWithNot),enableSorting:false, width: "15%"},
				             { field: 'lieu', displayName: 'Lieu',filter: _.cloneDeep(filterWithNot),enableSorting:false, width: "10%"}
				             ],
				             exporterFieldCallback: function( grid, row, col, input ) {
				            	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
				            	    var filters = col.cellFilter.split('|');
				            	    for(i=0; i<filters.length;i++) {
				            	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
				            	      var filterName=pars[0].trim();
				            	      var filterPar = null;
				            	      if (pars.length==2) {
				            	        filterPar = pars[1].slice(1, -1);
				            	        input = $filter(filterName)( input,filterPar);
				            	      } else {
				            	        input = $filter(filterName)( input );
				            	      }
				            	    }
				            	  }
				            	  return input;
				             },
				             onRegisterApi: function(gridApi){
				            	 $scope.gridServNamApi = gridApi;
				             }
		};
		
		function loadServNamData(deb, fin){
			if (angular.isUndefined(fin) || ''==fin || fin==null) {
				fin = deb;
			}
			that.dataLoading = true;
			$http.get(that.servNamUrl + "?d="+ new moment(deb).format('YYYY-MM-DD') + "&f="+ new moment(fin).format('YYYY-MM-DD') + "&u=" + that.clientUid)
			.success(function(data) {
				$scope.gridServNamOptions.data = data;
				if (data.length==0) {
					jNotice("Aucune donnée trouvée...", "blue");
					that.dataLoading = false;
				}
				$scope.gridServNamApi.core.on.rowsRendered($scope, function() {
					if (that.dataLoading) {
						$scope.gridServNamApi.core.on.sortChanged( $scope, $scope.sortChanged );
						var tree = $scope.gridServNamApi.grid.treeBase.tree;
						for (var i = tree.length-1; i >= 0; i--) {
							$scope.gridServNamApi.treeBase.expandRow(tree[i].row);
							var tree2 = tree[i].children;
							for (var j = tree2.length-1; j >= 0; j--) {
								$scope.gridServNamApi.treeBase.expandRow(tree2[j].row);
							}
						}
						that.dataLoading = false;						
					}
				});
			});
		}
		
		function getIntervalle() {
			var intervalle = $scope.debut;
			if (MyNamespace.helpers.isNotEmpty($scope.fin)) {
				intervalle += " au " + $scope.fin;
			}
			return intervalle;
		}
		
	}]);
})();