(function(){
	var app = angular.module("professional", []);
	
	app.directive('profValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.profValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.profCtrl.model.currentProf().lastName) && scope.profCtrl.model.currentProf().noProf==viewValue) {
						deferred.resolve();
					} else if (viewValue.match(/^[0-9]+$/) != null && viewValue.length>2) {
						delete scope.profCtrl.model.currentProf().id;
						$http({
							method : "GET",
							url : "/syra/professionals/search?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.profCtrl.setCurrentProfessional(res);
									deferred.resolve();
									if (res.noGroup.length>0) {
										$http({
											method : "GET",
											url : "/syra/group/search?k=" + res.noGroup + "&u=" + clientUid
										}).then(function mySucces(response) {
											if(response.data.length == 1 && response.data[0].c*1>0){
												scope.profCtrl.model.currentDemPaimt().cModaPaimt.type=2;
												scope.profCtrl.setCurrentGroup(response.data[0]);
											}
										}, function myError(response) {
											$scope.myWelcome = response.statusText;
										});
									}
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	app.factory('ProfTypes', function(clientUid, $http){
		var types = [];
		$http({
			method : "GET",
			url : "/syra/professionaltypes?u=" + clientUid,
			headers: {'Content-Type': 'application/json; charset=utf-8'}
		}).then(function mySucces(response) {
			types = addRamqMapping(response.data);
		}, function myError(response) {
			
		});
		
		function conversionMap(){
			//Mapping of prof types from syra(s) to ramq(r) liste.
			var conversionArray = [{s:"0", r:99},{s:"1", r:15},{s:"2", r:16},{s:"3", r:18},{s:"4", r:2},
			 {s:"5", r:99},{s:"6", r:4},{s:"7", r:8},{s:"8", r:7},{s:"9", r:5},{s:"10", r:99},{s:"11", r:99},
			 {s:"12", r:17},{s:"13", r:6},{s:"14", r:1},{s:"15", r:3},{s:"16", r:9},{s:"17", r:10},
			 {s:"18", r:11},{s:"19", r:12},{s:"20", r:13},{s:"21", r:14}]
			var convMap = new Map();
			for(i = 0; i < conversionArray.length; i++){
				convMap.set(conversionArray[i].s,conversionArray[i].r );
			}
			//Map
			return convMap;
		}
		function addRamqMapping(typeList){
			for(i = 0; i < typeList.length; i++){
				typeList[i].r = convMap.get(typeList[i].c);
			}
			return typeList;
		}
		var convMap = conversionMap();
		return {
			list : function(){
				return types;
				}
		};
		
	});
	app.controller('NewProfessionalController', ['$scope','$http', '$log','clientUid','model','ProfTypes', '$uibModal',
	                                          function($scope, $http, $log, clientUid, model, ProfTypes, $uibModal){
		var that = this;
		that.model = model;
		$scope.model = model;
		this.prof = $scope.mObject.modalData;
		$scope.types = ProfTypes;
		$scope.specialites = [];
		
		$http({
			method : "GET",
			url : "/syra/professionalspeciality?u=" + clientUid,
			headers: {'Content-Type': 'application/json; charset=utf-8'}
		}).then(function mySucces(response) {
			$scope.specialites = response.data;
		}, function myError(response) {
			
		});
		$scope.cityAssist = {
				assistId: "autocomplete_city_edit_prof",
				headerHtml: '<button class="btn sm primary" type="button" ng-click="newCity()"><i class="glyphicon glyphicon-user"></i> Nouvelle ville</button>', 
				hasDetails: false,
				trigger: 'focus',
				getAjaxData: function(query){
					return { url:"/syra/city/search",
						data: { k: query, u: clientUid }};
				},
				getKey: function(c) {return c.d;},
				getDescription: function(c) {return c.d;},
				selection: function(c) {
					that.prof.city = c.d;
					return c.d;
				}
			};
		$scope.newCity = function(){
			$scope.newCityOpened = true;
			$scope.modalInstance = $uibModal.open({
				animation: $scope.animationsEnabled,
				templateUrl: "/syra/Resources/views/modal.html",
				controller: 'ModalInstanceCtrl',
				size: "md",
				resolve: {
					mObject: function () {
						return {
							title: "Nouvelle Ville",
							templateUrl:"/syra/Resources/views/editCity.html"
						};
					}
				}
			});
			
			$scope.modalInstance.result.then(function () {
				$scope.newCityOpened = false;
	        }, function () {
	            $scope.newCityOpened = false;
	        });
			
//			$scope.pgwModelOpen = {};
//			$.pgwModal({
//			    url: '/syra/Resources/views/editProfessional.html',
//			    loadingContent: '<span style="text-align:center">Chargement des données</span>',
//			    maxWidth: $( window ).width() * .5,
//			    angular: true,
//			    modalData : that.model.currentPatient(),
//			    closeOnEscape : false,
//			    closeOnBackgroundClick : true,
//			    title: 'Nouveau Professionel'
//			});
		};
		$scope.add = function(valid, prof){
			if(valid){
				var sObj = JSON.stringify(prof);
				var cUidObject = {'o': sObj, 'u': clientUid};
				$http({
					method : "POST",
					url : "/syra/addProfessionals/post",
					data:  JSON.stringify(cUidObject),
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
					// response est un integer?
//					$log.log("save prof:" + response.data);
					if (angular.isDefined(response.data.length) && response.data.length==1) {
						var id = response.data[0];
						if (isNaN(id)) {
							that.model.error("Erreur lors de la sauvegarde...");
						} else {
							prof.id = id;
							$scope.modal.ok(prof);
							that.model.info("Professionnel ajouté avec succès!");
						}
					} else {
						that.model.error("Erreur:\n" + response.data);
					}
				}, function myError(response) {
					new jBox('Notice', {
						color : 'red',
						content: "Erreur d'ajout du professionel",
						attributes: {
							x: 'right',
							y: 'bottom'
						}
					});
				});
			}else{
				new jBox('Notice', {
					color : 'red',
					content: "Veuillez saisir les champs.",
					attributes: {
						x: 'right',
						y: 'bottom'
					}
				});
			}
		}
			
	}]);
	
	app.controller('ProfessionalController', ['$scope','$http', '$timeout', '$log','clientUid','model', '$uibModal',
	                                          function($scope, $http, $timeout, $log, clientUid, model, $uibModal){
		var that = this;
		this.model = model;
		$scope.model = model;
		this.listProf;
		this.listGroup;
		
		that.modaPaimts = [
	                      {'id': 1, 'label': 'Cpte personnel du professionnel'},
	                      {'id': 2, 'label': 'Cpte administratif'}
		                ]; // pref 'TYP_LOC_ETAB':'typ_loc_etab'
				
		this.setModaPaimtType = function() {
			that.model.setCurrModaPaimtType(that.model.currentDemPaimt().cModaPaimt.type, true);
			if (that.model.currentDemPaimt().cModaPaimt.type===2) {
				$timeout(function(){$scope.focusOnGroup();},200);
			}
		};
		
		this.changeDp = function() {
			that.model.setDirtyStatus(that.model.currentDemPaimt(), true);
		};
		
		$scope.currProf = {
			noProf: function(v) {
				if (arguments.length) {
					that.model.currentProf().noProf = v;
					if (angular.isUndefined(that.model.currentDemPaimt().cDemdr)) {
						that.model.currentDemPaimt().cDemdr = {};
					}
					that.model.currentDemPaimt().cDemdr.idIntvn = v;
				}
				return that.model.currentProf().noProf;
			},
			modaPaimtType: function(v) {
				if (arguments.length) {
					if (angular.isUndefined(that.model.currentDemPaimt().cModaPaimt)) {
						that.model.currentDemPaimt().cModaPaimt = {};
					}
					that.model.currentDemPaimt().cModaPaimt.type = v;
				} else if (angular.isDefined(that.model.currentDemPaimt().cModaPaimt)) {
					return that.model.currentDemPaimt().cModaPaimt.type;
				}
			},
			groupeCode: function(v) {
				if (arguments.length) {
					that.model.currentGroup().c = v;
					if (angular.isUndefined(that.model.currentDemPaimt().cModaPaimt)) {
						that.model.currentDemPaimt().cModaPaimt = {};
					}
					that.model.currentDemPaimt().cModaPaimt.no = v*1;
				}
				return that.model.currentGroup().c;
			},
			noAutor: function(v) {
				if (angular.isDefined(that.model.currentDemPaimt().serv)) {
					if (arguments.length) {
						return that.model.currentDemPaimt().serv.noAutor = v;
					}
					return that.model.currentDemPaimt().serv.noAutor;					
				}
			}
		};
					
		$scope.def = {
			recherchePatients: function(newVal) {
				console.log(newVal);
				if (arguments.length) {
					that.model.setCurrDefaultValues('recherchePatients', newVal);
					that.model.saveCurrDefaultValues('recherchePatients');
					return;
				}
				return that.model.currentDefault()['recherchePatients'];
			}
		};
		$scope.profAssist = {
			assistId: "autocomplete_prof",
			getAjaxData: function(query){
				delete that.model.currentProf().id;
				return { url:"/syra/professionals/search",
					data: { k: query, u:clientUid }};
			},
			listWidth: 300,
			hasHeader: false, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
			selection: function(elem) {
				this.lockEntry();
				that.setCurrentProfessional(elem);
				if (elem.noGroup.length>0) {
					$http({
						method : "GET",
						url : "/syra/group/search?k=" + elem.noGroup + "&u=" + clientUid
					}).then(function mySucces(response) {
						if(response.data.length == 1 && response.data[0].c*1>0){
							that.model.currentDemPaimt().cModaPaimt.type=2;
							that.setCurrentGroup(response.data[0]);
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
				}
				return elem.noProf;
			},
			suggestOnDataLoaded: function(data) {
				if(data.length === 1){
					this.select(data[0]);
					return false;
				}
				return true;
			}
		};
				
		this.setCurrentProfessional = function(prof){
			that.model.setCurrProf(prof, true);
			if (angular.isDefined(prof.noProf)) {
				that.model.currentDemPaimt().cDemdr.idIntvn = prof.noProf;			
			} else {
				delete that.model.currentDemPaimt().cDemdr.idIntvn;				
			}
			that.model.currentDemPaimt().cModaPaimt.type=1;
		};
		
		$scope.groupAssist = {
				assistId: "autocomplete_group",
				getAjaxData: function(query){return { url:"/syra/group/search",
					data: { k: query, u:clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
				selection: function(elem) {
					this.lockEntry();
					that.setCurrentGroup(elem);
					return elem.c;
				},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			};
				
		this.setCurrentGroup = function(group){
			that.model.setCurrGroup(group, true);
			if (angular.isDefined(group) && angular.isDefined(group.c)) {
				that.model.currentDemPaimt().cModaPaimt.no = group.c*1;	
			} else {
				delete that.model.currentDemPaimt().cModaPaimt.no;				
			}
		};
		
		this.editProfessional = function(prof){
			if(prof != null && prof != undefined){
				this.newProf = prof;
			}
		};
	}]);
})();