(function(){
	var patient = angular.module("patient", ['syraFilters','cfp.hotkeys','ngTouch', 'ui.grid', 'ui.grid.cellNav', 'ui.grid.resizeColumns', 'ui.grid.selection', 'ui.grid.autoResize']);

	patient.directive('dxValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.dxValid = function(modelValue, viewValue) {
					var deferred = $q.defer();	// scope.patientCtrl.model.currentPatient().typePerson!=1 || 
					if (angular.isUndefined(viewValue) || viewValue==null || viewValue=='') {
						delete scope.model.currentDx().da;
						delete scope.model.currentDx().dl;						
						deferred.resolve();
					} else if (angular.isDefined(scope.patientCtrl.model.currentDx().da) && scope.patientCtrl.model.currentDx().c==viewValue) {
						deferred.resolve();
					} else {
						viewValue = viewValue.trim().toUpperCase();
						if (viewValue.length<3 || viewValue.substring(0,3).match(/^[A-Z0-9][0-9][0-9]$/) == null) {
							deferred.reject();
						} else {
							$http({
								method : "GET",
								url : "/syra/diagnostic/get?c=" + viewValue +"&u=" + clientUid
							}).then(function mySucces(response) {
								var res = response.data;
								var dx;
								if (angular.isUndefined(res.length)) {
									dx = res;
								} else if (res.length==1) {
									dx = res[0];
								}
								if (angular.isDefined(dx)) {
									scope.model.setDirtyStatus(scope.model.currentPatient(), true);
									scope.model.currentDx().c = dx.c;
									scope.model.currentDx().da = dx.da;
									scope.model.currentDx().dl = dx.dl;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							}, function myError(response) {
								$scope.myWelcome = response.statusText;
							});
						}
					}
					return deferred.promise;
				};
			}
		};
	});

	patient.directive('namValid', function($q, $http, $timeout, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.namValid = function(modelValue, viewValue) {
					var deferred = $q.defer();	// scope.patientCtrl.model.currentPatient().typePerson!=1 || 
					if (angular.isUndefined(viewValue) || viewValue==null) {
						deferred.resolve();
					} else {
						viewValue = viewValue.trim();
						if (viewValue.length==0) {
							// a effacé le nam
							scope.model.currentPatient().hin = '';
							scope.model.currPatientUpdated(true);
							deferred.resolve();
						} else if (viewValue.length>2 && viewValue.substring(0,3).match(/[xX]{3}/) !== null) {
							scope.model.message("Avec Syra, vous ne devez pas saisir de patient fictif si le service fourni n'exige pas de patient (par exemple, pour une garde ou une supervision). Dans ces situations, complétez seulement la section 'Services médicaux'.", "yellow", 10000);
							deferred.reject();
						} else if (viewValue.length!=12) {
							deferred.reject();
						} else if (viewValue==scope.model.currentPatient().hin && angular.isDefined(scope.model.currentPatient().bds) && angular.isDefined(scope.patientCtrl.model.currentPatient().gender)) {
							deferred.resolve();
						} else if (viewValue.toUpperCase().match(/^[A-Z][A-Z][A-Z][A-Z|*][0-9][0-9][0156][0-9][0-3][0-9]([A-Z]|[0-9])[0-9]$/) != null) {
							$http({
								method : "GET",
								url : "/syra/validNam/get?c="+viewValue.toUpperCase()+"&u="+clientUid
							}).then(function mySucces(response) {
								var res = response.data;
								if (res==0) {
									deferred.reject();
								} else if (res==1) {	// n'a pas trouvé le pt. mais nam valid. Ne va pas chercher dans archives si index-pt.
									scope.changeTypePerson();
//									if (angular.isDefined(elm[0].dxA)) {
//										elm[0].dxA.internal.emulateTabbing(elm, 1);
//									}
									delete scope.model.currentPatient().codeDx;	// il faut supprimer ce champs, sinon il suggérera dx du pt précédent.
									deferred.resolve();
								} else if (res.bds) {
									// l'A trouvé dans l'index patient - donc va faire un select
									scope.model.currentPatient().hin = viewValue;
									scope.model.currentPatient().bds = res.bds;
									scope.model.currentPatient().gender = res.gender;
									scope.model.currentPatient().ident = scope.model.getIdent();
									scope.changeTypePerson();
									if (angular.isDefined(elm[0].dxA)) {
										if (elm[0].id=='ptSearchInput') {
											elm[0].dxA.internal.emulateTabbing(elm, 1);											
										}
									} else {
										scope.model.currPatientUpdated(true);										
									}
									deferred.resolve();
								} else {
									deferred.reject();
								}
							}, function myError(response) {
							});
						} else {
							deferred.reject();
						}
					}
					return deferred.promise;
				};
			}
		};
	});

	patient.controller('PatientController', ['$scope','$http', '$log', '$timeout','hotkeys', 'uiGridConstants', 'clientUid', 'model', '$uibModal',
	                                         function($scope, $http, $log, $timeout, hotkeys, uiGridConstants, clientUid, model, $uibModal){
		var that = this;
		var helpers = MyNamespace.helpers;
		var showTag = false;
		this.model = model;
		$scope.model = model;
		$scope.pgwModelOpen = {};	// mettre valeur pour la fenêtre ouvert, p.ex. $scope.pgwModelOpen.pref = true .fav, .print ...
		$scope.history = that.model.currentDefault()['see_histTjrs'];

		this.dxList = [];

		that.recherche_patients = [
		                           {'id': 1, 'label': 'Index patient'},
		                           {'id': 2, 'label': 'Historique de facturation'},
		                           {'id': 3, 'label': 'Index et historique'},
		                           {'id': 4, 'label': 'Aucune recherche'}
		                           ];
		that.recherche_patients_title="Mode de saisie des données du patient.";

		that.typeIdPersons = [
		                      {'id': 1, 'label': 'RAMQ'},
		                      {'id': 2, 'label': 'Autre'}
		                      ];

		that.typeIdPersAutres = [
		                         {'id':2 , 'label': "Numéro de l'Ordre des dentistes du Québec"},
		                         {'id':3 , 'label': "Numéro d'étudiant attribué par l'Ordre des sages-femmes du Québec"},
		                         {'id':4 , 'label': "Numéro du Collège des médecins du Québec"},
		                         {'id':5 , 'label': "Numéro de l'Ordre des infirmières et des infirmiers du Québec"}
		                         ];

		that.typEvenePersItems = [
		                          {'id': '0', 'label': 'S/O'},
		                          {'id': '1', 'label': 'C.S.S.T.'},
		                          {'id': '2', 'label': 'D.D.M.'},
		                          {'id': '3', 'label': 'D.P.A.'}
		                          ];

		that.typePersons = [
		                    {'id': 1, 'label': 'Avec identifiant (NAM)'},
		                    {'id': 2, 'label': 'Sans identifiant'},
		                    {'id': 3, 'label': 'Autre personne avec identifiant'},
		                    {'id': 4, 'label': 'Autre personne sans identifiant'}
		                    ];
		that.typePersRepondants = [
		                           {'id': 1, 'label': 'Répondant avec identifiant'},
		                           {'id': 2, 'label': 'Répondant sans identifiant'}
		                           ];

		that.typeSituConsids = [
		                        [],
		                        [
		                         {'id': 1, 'label': 'Situation normale'},
		                         {'id': 10, 'label': "Délai de carence, services nécessaires aux victimes de violence conjugale ou familiale ou d'une agression"},
		                         {'id': 11, 'label': "Délai de carence, services liés à la grossesse, à l'accouchement ou à l'interruption de grossesse"},
		                         {'id': 12, 'label': "Délai de carence, services aux personnes avec dx d'infection ayant une incidence sur la santé publique"},
		                         {'id': 99, 'label': "Situation Non-définie"}
		                         ],[
		                            {'id': 2, 'label': "Enfant âgé de moins d'un an"},
		                            {'id': 3, 'label': "Patient requérant des soins urgents"},
		                            {'id': 4, 'label': "Patient admis dans un CHSLD (incluant ceux pour les autochtones/cris), CA ou centre de réadaptation"},
		                            {'id': 5, 'label': "Patient âgé entre 14 ans et 18 ans sans l'autorisation des parents"},
		                            {'id': 6, 'label': "Personne faisant l’objet d’une ordonnance du tribunal"},
		                            {'id': 7, 'label': "Service professionnel à la demande du coroner"},
		                            {'id': 8, 'label': "Demandeur d’asile lorsque refus de  paiement des services médicaux par Croix Bleue Medavie"},
		                            {'id': 9, 'label': "Demande de remboursement à remettre au patient"},
		                            {'id': 14, 'label': "Donneur non québécois"},
		                            {'id': 99, 'label': "Situation Non-définie"}
		                            ],[],[]];

		that.typPersAutreAvecIds = [
		                            {'id': 2, 'label': "Dentiste résident en chirurgie buccale et maxillo-faciale"},
		                            {'id': 3, 'label': "Étudiante en pratique sage-femme"},
		                            {'id': 4, 'label': "Externe"},
		                            {'id': 5, 'label': "Infirmière praticienne spécialisée"},
		                            {'id': 6, 'label': "Moniteur clinique"},
		                            {'id': 7, 'label': "Résident"}
		                            ];

		that.typPersAutreSansIds = [
		                            {'id': 1, 'label': "Conseillère ou conseiller en génétique"}
		                            ];

		that.secteurExterne = ['01','24','31','35','36','42','44','52'];
		// getter setter for def
		$scope.def = {
				recherchePatients: function(newVal) {
					if (arguments.length) {
						that.model.setCurrDefaultValues('recherchePatients', newVal);
						that.model.saveCurrDefaultValues('recherchePatients');
						that.setUiForRechPats(newVal);
						return;
					}
					return that.model.currentDefault()['recherchePatients'];
				}
		};

		$scope.isIndexed = function() {
			return that.model.currentDefault()['recherchePatients']==1 || that.model.currentDefault()['recherchePatients']==3;
		}

		$scope.addOrEdit = function(){
			var edit = 0; // 1 = add, 2 = edit
			if ($scope.isIndexed()) {
				if (that.model.currentPatient().id) {
					edit = 2;
				} else {
					edit = 1;
				}
			}
			return edit;
		};

		this.updateReg = function(){
			if($scope.inscriptionOpened===true) return;
			$http({
				method : "GET",
				url : "/syra/b2bData/get?u=" + clientUid 
			}).then(function mySucces(response) {
				var data = response.data;
				that.model.setCurrPatientData(data);
				$scope.inscriptionOpened = true;
				$scope.modalInstance = $uibModal.open({
					animation: $scope.animationsEnabled,
					templateUrl: "/syra/Resources/views/modal.html",
					controller: 'ModalInstanceCtrl',
					size: "lg",
					resolve: {
						mObject: function () {
							return {
								title: "Modifier l'inscription",
								templateUrl:"/syra/Resources/views/b2b/update-b2b.html"
							};
						}
					}
				});

				$scope.modalInstance.result.then(function () {
					$scope.inscriptionOpened = false;
				}, function () {
					$scope.inscriptionOpened = false;
				});		    	
			}, function myError(response) {
				//TODO : Handle error
			});
		};

		this.showDateES = function() {
			var hasDateEntree = helpers.isNotEmpty($scope.currPt.datEntree());
			if (that.model.currentDefault()['see_doNotShowES'] && !hasDateEntree) return false;
			return hasDateEntree || that.model.currentDefault()['see_dateEntree'] || 
			that.model.currentDemForListe().mm || 
			(angular.isDefined(that.model.currentLieu().etab.valEtab) && that.model.currentLieu().etab.valEtab.catgEtab=='CH' && 
					(angular.isUndefined(that.model.currentLieu().etab.valSect.noSectActiv) || 
							'01;42;44;52'.indexOf(that.model.currentLieu().etab.valSect.noSectActiv) == -1));
		};

		moment.locale('fr');
		this.pushPatient = function(){
			that.model.setDefaultCurrPatient();
			that.model.addPatientToLst(that.model.currentPatient(), true);
			$scope.ptGridOptions.data.push(that.model.currentPatient());
			that.model.setCurrHistoricBills([]);
			$timeout(function () {
				$scope.ptGridApi.selection.selectRowByVisibleIndex($scope.ptGridOptions.data.length-1);
			}
			, 10);
		};
		this.pushPersAutre = function(){
			that.model.setDefaultCurrPersAutre();
			$scope.changeTypePerson();
			that.model.addPatientToLst(that.model.currentPatient(), true);
			$scope.ptGridOptions.data.push(that.model.currentPatient());
			that.model.setCurrHistoricBills([]);
			$timeout(function () {
				$scope.ptGridApi.selection.selectRowByVisibleIndex($scope.ptGridOptions.data.length-1);
			}
			, 10);
		};

		this.pushDx = function(){
			var dx = {};
			dx.tag = that.model.atomicInt();
			that.setDx(dx);
			that.model.currentPatient().lstDx.put(that.model.currentDx().tag, that.model.currentDx());
			$scope.dxGridOptions.data.push(that.model.currentDx());
			$scope.dxGridApi.core.notifyDataChange( uiGridConstants.dataChange.ROW );			
			$timeout(function () {
				$scope.dxGridApi.selection.selectRowByVisibleIndex($scope.dxGridOptions.data.length-1);
			}
			, 10);
		};

		that.hinLostFocus = function() {
			// fait dans le watch hin car si autocomplete, le model n'est pas updaté - voir directive INPUT dans app.js
		};

		// watch nécessaire pour updater quand on change de facture
		$scope.$watch(
				function(scope) {
					return scope.model.currDemPaimtUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (angular.isDefined(scope.model.currentDemPaimt().serv) && angular.isDefined(scope.model.currentDemPaimt().serv.lstPatients) && (typeof scope.model.currentDemPaimt().serv.lstPatients.values == 'function')) {
						scope.history = scope.model.currentDefault()['see_histTjrs'];
						scope.repIdent = "";
						MyNamespace.helpers.clearAndAddToArray(scope.ptGridOptions.data, scope.model.currentDemPaimt().serv.lstPatients.values())
						scope.model.setCurrHistoricBills([]);
						that.setUiForRechPats();	// pour setter le firstFocus
						$timeout(function () {
							if (angular.isDefined(scope.ptGridApi)) {
								if (scope.ptGridOptions.data.length>0) {
									scope.ptGridApi.selection.selectRowByVisibleIndex(0);
								} else {	// il faut effacer les anciens dx
									that.setDx({});
									helpers.clearAndAddToArray($scope.dxGridOptions.data, []);
									scope.model.setCurrDx({});
								}
							}
						}, 10);
					}
				});
		$scope.$watch(
				function(scope) {
					return scope.model.typEvenePersUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>0) {
						scope.focusOnDatEvenePers();				  
					}
				});
		$scope.$watch(
				function(scope) {
					return scope.model.seeHistFilterUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (newVal>oldVal) {
						scope.patientHistoryGridOptions.enableFiltering = scope.model.currentDefault()['see_histFilter'];
						scope.patientHistoryGridApi.core.notifyDataChange( uiGridConstants.dataChange.COLUMN );
					}
				});

		var currentPatientIsUpdating = false;

		$scope.$watch(
				function(scope) {
					return scope.model.currPatientUpdated().val;
				},
				function(newVal, oldVal, scope) {
					if (!currentPatientIsUpdating && newVal>oldVal && angular.isDefined(scope.ptGridApi)) {
						if (angular.isUndefined(scope.model.currentDemForListe().id)) {
							if (scope.model.currentLieu().typLocEtab=='C' && angular.isDefined(scope.model.currentLieu().etab) && angular.isDefined(scope.model.currentLieu().etab.valEtab)) {
								currentPatientIsUpdating = true;
//								var catgEtab = scope.model.currentLieu().etab.valEtab.catgEtab;
								var typeEtab = scope.model.currentLieu().etab.valEtab.typEtab;
//								$log.log('catgEtab=' + catgEtab + ', typeEtab=' + typeEtab);
//								var isGmf = ('CM'===catgEtab && 'CAB'===typeEtab) || ('CLSC'===catgEtab && 'ETAB'===typeEtab);
								var isGmf = true;// scope.model.currentLieu().etab.noSelectedEtab==that.model.profPrefPropValue(that.model.currentProf().id, 'gmf','');
								if ('ETAB'===typeEtab && angular.isDefined(scope.model.currentLieu().etab.valSect) && angular.isDefined(scope.model.currentLieu().etab.valSect.noSectActiv)) {
									var typeSect = scope.model.currentLieu().etab.valSect.noSectActiv;
									if (that.secteurExterne.indexOf(typeSect)===-1) {
										$http({method : "GET",
											url : "/syra/last_date_entree/get?u=" + clientUid + "&e=" + scope.model.currentLieu().etab.noSelectedEtab
										}).then(function mySucces(response) {
											var v = response.data;
											if (v.severity==='OK') {
												if (helpers.isEmpty(scope.currPt.datEntree())) {
													scope.currPt.datEntree(v.message);									
												} 
											} else if (v.severity==='ERROR') {
												// aucun trouvé
											}
										}, function myError(response) {
											$scope.myWelcome = response.statusText;
										});
									}
								}
								if (scope.model.currentPatient().isInsc===2 && that.isMdTx()===1) {
									// check si a deja eu ce code x début année
									if (isGmf) {
										$http({method : "GET",
											url : "/syra/valid_plafon/get?u=" + clientUid+ "&e=" + scope.model.currentLieu().etab.noSelectedEtab + "&c=8875&g=1"
										}).then(function mySucces(response) {
											var v = response.data;
											if (v.severity=='OK') {
												scope.model.ptInscritAndMdFamUpdated(true);
											} else if (v.severity=='INFO') {
												// on a peut etre un code de rechange... pas pertinent ici. Ou on manque d'info pour tout valider
											} else if (v.severity=='WARNING') {
												$log.log(v.message);
												// non permis
											} else if (v.severity=='ERROR') {
												// une erreur retournée. 
												$log.log(v.message);
											}
											currentPatientIsUpdating = false;
										}, function myError(response) {
											$scope.myWelcome = response.statusText;
											currentPatientIsUpdating = false;
										});
									}
								} else {
									currentPatientIsUpdating = false;
								}

							}
						}
						$timeout(function () {
							scope.history = that.model.currentDefault()['see_histTjrs'];
							scope.ptGridApi.core.notifyDataChange(uiGridConstants.dataChange.ROW);
							scope.ptGridApi.grid.queueGridRefresh();
							if (scope.history) {
								that.model.callForCurrentHistoricBills();
							} else {
								that.model.callForCurrentPlafBills();
							}
						}, 10);
					}
				});

		hotkeys.add({
			combo: 'alt+i',
			description: "Modifier Inscription",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				if (that.model.currentPatient().id) {
					that.updateReg();
				}
			}
		});

		hotkeys.add({
			combo: 'alt+h',
			description: "Afficher l'historique de facturation",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				if ($scope.history) {
					$scope.history = false;
				} else {
					$scope.saveCurrPatientPrn();
					that.model.callForCurrentHistoricBills();
					$scope.history = true;
				}
			}
		});

		hotkeys.add({
			combo: 'alt+p',
			description: "Modifier Patient dans l'index",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				if ($scope.isIndexed()) {
					that.editPat();
				}
			}
		});

		$scope.currPt = {
				typePerson: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typePerson = v;
					}
					return that.model.currentPatient().typePerson;
				},
				hin: function(v) {
					if (arguments.length) {
						that.model.currentPatient().hin = v;
					}
					return that.model.currentPatient().hin;
				},
				typSituConsi: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typSituConsi = v;
					}
					return that.model.currentPatient().typSituConsi;
				},
				typPersAutre: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typPersAutre = v;
					}
					return that.model.currentPatient().typPersAutre;
				},
				typIdPerson: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typIdPerson = v;
					}
					return that.model.currentPatient().typIdPerson;
				},
				typIdPersAutre: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typIdPersAutre = v;
					}
					return that.model.currentPatient().typIdPersAutre;
				},
				idPersAutre: function(v) {
					if (arguments.length) {
						that.model.currentPatient().idPersAutre = v;
					}
					return that.model.currentPatient().idPersAutre;
				},
				ln: function(v) {
					if (arguments.length) {
						that.model.currentPatient().ln = v;
					}
					return that.model.currentPatient().ln;
				},
				fn: function(v) {
					if (arguments.length) {
						that.model.currentPatient().fn = v;
					}
					return that.model.currentPatient().fn;
				},
				bds: function(v) {
					if (arguments.length) {
						that.model.currentPatient().bds = v;
					}
					return that.model.currentPatient().bds;
				},
				no: function(v) {
					if (arguments.length) {
						that.model.currentPatient().no = v;
					}
					return that.model.currentPatient().no;
				},
				gender: function(v) {
					if (arguments.length) {
						that.model.currentPatient().gender = v;
					}
					return that.model.currentPatient().gender;
				},
				adrA1: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().adr)) {
							that.model.currentPatient().adr ={};
						}
						that.model.currentPatient().adr.a1 = v;
					} else if (angular.isDefined(that.model.currentPatient().adr)) {
						return that.model.currentPatient().adr.a1;					
					}
				},
				adrCyN: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().adr)) {
							that.model.currentPatient().adr ={};
						}
						if (angular.isUndefined(that.model.currentPatient().adr.cy)) {
							that.model.currentPatient().adr.cy ={};
						}
						that.model.currentPatient().adr.cy.n = v;
					} else if (angular.isDefined(that.model.currentPatient().adr) && angular.isDefined(that.model.currentPatient().adr.cy)) {
						return that.model.currentPatient().adr.cy.n;
					}
				},
				adrCp: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().adr)) {
							that.model.currentPatient().adr ={};
						}
						that.model.currentPatient().adr.cp = v;
					} else if (angular.isDefined(that.model.currentPatient().adr)) {
						return that.model.currentPatient().adr.cp;					
					}
				},
				persRepdnTypPersAutre: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.typPersAutre = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.typPersAutre;
					}
				},
				persRepdnTypIdPersAutre: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.typIdPersAutre = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.typIdPersAutre;
					}
				},
				persRepdnIdPersAutre: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.idPersAutre = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.idPersAutre;
					}
				},
				persRepdnLn: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.ln = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.ln;
					}
				},
				persRepdnFn: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.fn = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.fn;
					}
				},
				persRepdnBds: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.bds = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.bds;
					}
				},
				persRepdnGender: function(v) {
					if (arguments.length) {
						if (angular.isUndefined(that.model.currentPatient().persRepdn)) {
							that.model.currentPatient().persRepdn = {};
						}
						that.model.currentPatient().persRepdn.gender = v;
					} else if (angular.isDefined(that.model.currentPatient().persRepdn)) {
						return that.model.currentPatient().persRepdn.gender;
					}
				},
				typEvenePers: function(v) {
					if (arguments.length) {
						that.model.currentPatient().typEvenePers = v;
					}
					return that.model.currentPatient().typEvenePers;
				},
				datEvenePers: function(v) {
					if (arguments.length) {
						that.model.currentPatient().datEvenePers = v;
					}
					return that.model.currentPatient().datEvenePers;
				},
				datEntree: function(v) {
					if (arguments.length) {
						that.model.currentPatient().datEntree = v;
					}
					return that.model.currentPatient().datEntree;
				},
				datSortie: function(v) {
					if (arguments.length) {
						that.model.currentPatient().datSortie = v;
					}
					return that.model.currentPatient().datSortie;
				},
				imc: function(v) {
					if (arguments.length) {
						that.model.currentPatient().imc = v;
					}
					return that.model.currentPatient().imc;
				}
		};
//		hotkeys.add({
//		combo: 'alt+d',
//		description: "Effacer Patient de la facture",
//		allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
//		callback: function(event, hotkey) {
//		event.preventDefault();
//		if (that.isIndexed() && that.model.currentPatient().id) {
//		that.removeCurrentPatient();
//		}
//		}
//		});
		that.changeDateEntree = function() {
			$scope.setDirty();
			// $scope.$applyAsync();
		};
		$scope.setDirtyHin = function() {
			$timeout(function() {$scope.setDirty();}, 250);
		};
		$scope.setDirtyLn = function() {
			if (!that.model.currentPatient().hin) {
				that.model.currentPatient().ident = that.model.getIdent();
			}
			$scope.setDirty();
		};
		$scope.setDirtyDdn = function() {
			if (!that.model.currentPatient().hin) {
				that.model.currentPatient().ident = that.model.getIdent();
			}
			$scope.setDirty();
		};
		$scope.setDirtyGender = function() {
			if (!that.model.currentPatient().hin) {
				that.model.currentPatient().ident = that.model.getIdent();
			}
			$scope.setDirty();
		};
		$scope.setDirtyNo = function() {
			if (!that.model.currentPatient().hin) {
				that.model.currentPatient().ident = that.model.getIdent();
			}
			$scope.setDirty();
		};
		$scope.setDirtyRepIdent = function() {
			$scope.setDirty();
		};
		$scope.setDirtyIpPersAutre = function() {
			that.model.currentPatient().ident = that.model.getIdent();
			$scope.setDirty();
		};
		$scope.setDirty = function() {
			if (angular.isDefined(that.model.currentDemPaimt().serv)) {
				if (that.model.currentPatient().typePerson<3) {
					if (that.model.currentPatient().hin) {
						if (that.model.currentPatient().typePerson==2) {
							that.model.currentPatient().typePerson=1;
							$scope.changeTypePerson();
						}
					} else {
						if (that.model.currentPatient().typePerson==1){
							that.model.currentPatient().typePerson=2;
							$scope.changeTypePerson();
							$scope.focusOnTypSituConsi(true);
						}
					}
				}
				that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstPatients, true);
				that.model.setDirtyStatus(that.model.currentPatient(), true);
			}
		};
		that.changeDatEvenePers = function() {
			$scope.setDirty();
		};
		that.setDirtyAndFocusHin = function() {
			$scope.setDirty();
			that.setFocusHin();
		};
		that.setDirtyAndFocusBasedOnTypePerson = function() {
			$scope.setDirty();
			if (that.model.currentPatient().typePerson==1) {
				that.setFocusHin();
			} else if (that.model.currentPatient().typePerson==2) {
				$timeout(function(){$scope.focusOnTypSituConsi(true);},200);
			} else if (that.model.currentPatient().typePerson==3) {
				$timeout(function(){$scope.focusOnTypPersAutre(true);},200);
			} else if (that.model.currentPatient().typePerson==4) {
				$timeout(function(){$scope.focusOnPatientNom();},200);
			}
		};
		$scope.setDirtyAndFocusBaseOnSitu = function() {
			$scope.setDirty();
			$scope.focusOnPatientNom();
		};
		that.setDirtyAndFocusDatEve = function() {
			$scope.setDirty();
			if (that.model.currentPatient().typEvenePers!='0') {
				$scope.focusOnDatEvenePers();
			}
		};
		that.setDirtyTypPersAutre3 = function() {
			$scope.setDirty();
			that.model.setCurrDefaultValues(CONFIG.DEFAUT_ID_PERS_AUTRE, that.model.currentPatient().typPersAutre);
			that.model.saveCurrDefaultValues(CONFIG.DEFAUT_ID_PERS_AUTRE, that.model.currentPatient().typPersAutre);
			setTypIdPersAutreBasedOnTypPersAutre(that.model.currentPatient().typPersAutre);
			$timeout(function(){$scope.focusOnIdPersAutreInput();},200);
		};
		function setTypIdPersAutreBasedOnTypPersAutre(v) {
			if (v==2) {
				that.model.currentPatient().typIdPersAutre=2;	// dentiste
			} else if (v==3) {
				that.model.currentPatient().typIdPersAutre=3;	// sage-femme
			} else if (v==5) {
				that.model.currentPatient().typIdPersAutre=5;	// infirm.
			} else {
				that.model.currentPatient().typIdPersAutre=4;	// CMQ
			}
		}
		that.isMdTx = function() {
			if (angular.isUndefined(that.model.currentPatient().txProfN)) {
				return 2;
			}
			return that.model.currentPatient().txProfN==that.model.currentProf().noProf ? 1 : 0;
		};
		that.mdTxTitle = function() {
			if (angular.isUndefined(that.model.currentPatient().txProfN)) {
				return "Absence du médecin de famille";
			}
			return that.model.currentPatient().txProfN==that.model.currentProf().noProf ? "Le médecin de la facture est le médecin de famille du patient" : "Le médecin de famille a le numéro " + that.model.currentPatient().txProfN;
		};
		that.isInscritTitle = function() {
			if (angular.isUndefined(that.model.currentPatient().isInsc)) {
				return "Aucune donnée d'inscription";
			}
			var i = that.model.currentPatient().isInsc;
			return i===2 ? "Inscrit" : (i===1 ? "Ne jamais inscrire" : "Non inscrit");
		};
		that.getLabelFromId = function(a, i) {
			var v = $.grep(a,
					function(item){
				return item.id === i;
			});
			if (v.length==1) {
				return v[0].label;				
			}
			return '';
		};
		that.setFocusHin = function() {
			if (that.model.currentDefault()['recherchePatients']==4) {
				if (that.showDdnSexeAddr()) {
					$timeout(function(){$scope.focusOnPatientNom();},200);
				} else {
					$timeout(function(){$scope.focusOnHinAdd2Input();},200);
				}
			} else {
				$timeout(function(){$scope.focusOnHinAddInput();},200);
			}
		};

		$scope.persRepdnTypeChanged = function() {
			$scope.setDirty();
			if (that.model.currentPatient().persRepdn.typPersAutre==1 && !that.model.currentPatient().persRepdn.typIdPersAutre) {
				that.model.currentPatient().persRepdn.typIdPersAutre = 1;
			}
		};
		$scope.changeTypePerson = function() {
			if (that.model.currentPatient().typePerson==1) {
				that.model.currentPatient().typSituConsi=1;
				that.model.currentPatient().typIdPerson=1;//RAMQ
			} else if (that.model.currentPatient().typePerson==2) {
				that.model.currentPatient().typSituConsi=-1;
//				that.model.currentPatient().typSituConsi=that.model.currentDefault()[CONFIG.DEFAUT_SANS_NAM];	// je ne mets pas de valeur par défaut car si est bon, l'utilisateur ne fait pas de sélection et pas d'event de ng-change
				delete that.model.currentPatient().typIdPerson;
			} else if (that.model.currentPatient().typePerson==3) {
				that.model.currentPatient().typPersAutre=that.model.currentDefault()[CONFIG.DEFAUT_ID_PERS_AUTRE];
				setTypIdPersAutreBasedOnTypPersAutre(that.model.currentPatient().typPersAutre);
			} else if (that.model.currentPatient().typePerson==4) {
				delete that.model.currentPatient().typIdPersAutre;
				delete that.model.currentPatient().typIdPerson;
				that.model.currentPatient().typPersAutre=1;
			}
		};
		that.lastNameFocus = function() {
			var errorNam = $scope.patientForm.pt2Input.$error.namValid;
			if (!errorNam && angular.isUndefined(that.model.currentPatient().hin) && (angular.isUndefined(that.model.currentPatient().typePerson) || that.model.currentPatient().typePerson==1)) {
				that.model.currentPatient().typePerson=2;
				that.model.currentPatient().typSituConsi=that.model.currentDefault()[CONFIG.DEFAUT_SANS_NAM];
				delete that.model.currentPatient().typIdPerson;
				$scope.focusOnTypSituConsi(true);
			}
		};

//		that.showIdPerson = function() {
//		return that.model.currentPatient().typePerson==1 || that.model.currentPatient().typePerson==3;
//		};
		that.showLnFs = function() {
			return (that.model.currentPatient().typePerson!=3 && (helpers.isEmpty(that.model.currentPatient().hin) && helpers.isEmpty(that.model.currentPatient().idPersAutre))) || that.model.currentDefault()['see_detailsPatient'];
		};
		that.showDdnSexeAddr = function() {
			return that.model.currentPatient().typePerson==2 || that.model.currentPatient().typePerson==4 || that.model.currentDefault()['see_detailsPatient'];
		};
		that.showImc = function() {
			return (that.model.currentDefault()['see_showIMC'] && that.model.currentProf().type===2) || angular.isDefined(that.model.currentPatient().imc);
		};
		that.showEveLabel = function() {
			return that.showCsst() && (that.model.currentProf().type===1 || !that.showImc());
		};
		that.showCsst = function() {
			return !that.model.currentDefault()['see_doNotShowEve'] || that.model.needsCsst();
		};

		var dateAssist = new DynaDate({elem:"sDdn", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		var eventDateEntree = new DynaDate({elem:"datEntree", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, maxDateElm:'datSortie'});
		var eventDateSortie = new DynaDate({elem:"datSortie", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false, minDateElm:'datEntree'});
		var eventDateEve = new DynaDate({elem:"datEvenePers", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:true, useCurrent: false});
		dateAssist.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']);
		};
		eventDateEntree.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']);
		};
		eventDateSortie.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']);
		};
		eventDateEve.getDefault = function(){
			return moment(that.model.currentDefault()['dateDefault']);
		};

		dateAssist.onDateSelected = function(selectedDate) {
			var d;
			if (selectedDate===false) {	// pas une date. donc pas un férié
				delete that.model.currentPatient().bds;
			} else if (selectedDate._isAMomentObject===true) {
				that.model.currentPatient().bds =  selectedDate.format('YYYY-MM-DD');
			} else if (typeof theDate==='string' && theDate.length===10) {
				that.model.currentPatient().bds =  selectedDate;
			}
		}

		//Patient assist input
		$scope.ptAssist = {
				assistId: "autocomplete_patient",
				nextTabOnTab: true,
				nextTabOnEnter: true,
				getAjaxData: function(query){
					return { url:"/syra/patient/search",
						data: { k: query, m: that.model.currentDefault()['recherchePatients'], u:clientUid }};
				},
				getKey: function(pat) {
					var keyItems;
					if (that.model.currentDefault()['recherchePatients']<4) {
						if (pat.id) {
							keyItems = pat.ln + ", " +pat.fn + ' (' + pat.gender + ':' + pat.bds + ") " + pat.dos;
						} else if (pat.length) {
							if (pat[1] && pat[1][0] && pat[1][0].id) {
								var pp = pat[1][0];
								keyItems = pp.ln + ", " +pp.fn + ' (' + pp.gender + ':' + pp.bds + ") " + pp.dos;
							} else {
								keyItems = pat[0];			
							}
						}
					}
					return keyItems;
				},
				actions: [{key: '=', callback: function(){that.commitPt();} },{key: '+', callback: function(){that.commitPt();} }],
				getDescription: function(pat) {
					var description;
					if (that.model.currentDefault()['recherchePatients']<4) {
						description = "<ul style='list-style-type:disc;-webkit-padding-start:12px;margin-bottom:0px;line-height:1.5'>";
						if (pat.id) {
							var adrss = "";
							if (angular.isDefined(pat.adr)) {
								var cyn;
								if (angular.isDefined(pat.adr.cy)) {
									cyn = pat.adr.cy.n;
								}
								adrss = helpers.cleanArray([pat.adr.a1,cyn, pat.adr.cp]).join(', ');
							}
							var adresse = adrss.length==0 ? "" : adrss + "; ";
							var vuln = pat.allDisCodes ? pat.allDisCodes : "";
							var hin = pat.hin ? pat.hin : "";
							var dos = (pat.dos && pat.dos.charAt(0)!='#') ? (' [' + pat.dos + ']') : '';
							var mdfam = (angular.isDefined(pat.txProfN) && pat.txProfN!=null && pat.txProfN!='') ? ' MD Fam: ' + pat.txProfN : '';
							description += "<li style='margin-bottom:3px'>" + hin + dos  + mdfam + "</li>"+ 
							(adrss.length==0 ? "" : "<li style='margin-bottom:3px'>" + adrss + "</li>") +
							"<li style='margin-bottom:3px'>" + (typeof pat.isInsc=='undefined' || pat.isInsc==0 ? 'NON inscrit':'INSCRIT') + '; ' + vuln + "</li>";
						} else {
							var aa = pat[1];	// un array de archive_dpacte
							for (var i = 0; i < aa.length; i++) {
								var a = aa[i];
								if (a.id) {
									var adrss = "";
									if (angular.isDefined(a.adr)) {
										var cyn;
										if (angular.isDefined(a.adr.cy)) {
											cyn = a.adr.cy.n;
										}
										adrss = helpers.cleanArray([a.adr.a1,cyn, a.adr.cp]).join(', ');
									}
									var adresse = adrss.length==0 ? "" : adrss + "; ";
									var vuln = a.allDisCodes ? a.allDisCodes : "";
									var hin = a.hin ? a.hin : "";
									var dos = (a.dos && a.dos.charAt(0)!='#') ? (' [' + a.dos + ']') : '';
									var mdfam = (angular.isDefined(a.txProfN) && a.txProfN!=null && a.txProfN!='') ? ' MD Fam: ' + a.txProfN : '';
									description += "<li style='margin-bottom:3px'>" + hin + dos  + mdfam + "</li>"+ 
									(adrss.length==0 ? "" : "<li style='margin-bottom:3px'>" + adrss + "</li>") +
									"<li style='margin-bottom:3px'>" + (typeof a.isInsc=='undefined' || a.isInsc==0 ? 'NON inscrit':'INSCRIT') + '; ' + vuln + "</li>";									
								} else {
									var mod = "";
									if (angular.isDefined(a.ar_mod)) {
										mod = " (" + a.ar_mod +")";
									}
									var codeDx = "";
									if (angular.isDefined(a.ar_codedx) && a.ar_codedx.length>0) {
										codeDx += "<br><b>Dx</b>: ";
										for (var j = 0; j < a.ar_codedx.length; j++) {
											codeDx += a.ar_codedx[j].replace(/"/g,'') + ", ";
										}
										codeDx = codeDx.substring(0, codeDx.length-2);
									}
									var eve = "";
									if (angular.isDefined(a.typEve) && a.typEve!=0) {
										eve = (codeDx.length==0?"<b>":", <b>")+(a.typEve==1?"CSST ":(a.typEve==2?"DDM ": "DPA "))+"</b>"+ new moment(a.dateEve).format('YYYY-MM-DD');
									}
									description += "<li style='margin-bottom:5px'><u>" + new moment({ y:a.ar_date.year, M: a.ar_date.month, d: a.ar_date.dayOfMonth}).format('YYYY-MM-DD') + "</u>: <b>" + a.ar_code + "</b>" + mod + ", " + a.ar_md + codeDx + eve + "</li>";
								}
							}
						}
						description += "</ul>";
					}
					return description;
				},
				selection: function(pat) {
					this.lockEntry();
					if (that.model.currentDefault()['recherchePatients']<4) {
						if (pat.id) {
							copyValuesToCurrentPatient(pat);							
						} else if (pat.length) {
							if (pat[1] && pat[1][0] && pat[1][0].id) {
								var pp = pat[1][0];
								copyValuesToCurrentPatient(pp, pat[1]);	// pat[1][0] est patient, et pat[1][1+]=les archvies. 
							} else {
								var pp = {};
								pp.hin = pat[0];
								copyValuesToCurrentPatient(pp, pat[1]);	// pat[1] ne contient que des archives		
							}
						}
						return that.model.currentPatient().hin;
					}
				},
				suggestOnDataLoaded: function(listRepdn, queryString) {
					//$log.log("listRepdn.length="+ listRepdn.length +", queryString.length= " + queryString.length)
					if(listRepdn.length === 1 && queryString.length==12){
						this.select(listRepdn[0]);
						this.internal.emulateTabbing(this.baseElement, 1);
						return false;
					}
					return true;
				}
		};

		$scope.rpdnAssist = {
				hasHeader: false, 
				assistId: "autocomplete_rpdn",
				getAjaxData: function(query){
					return { url:"/syra/patient/search",
						data: { k: query, u:clientUid }};
				},
				getKey: function(pat) {
					return pat.ln + ", " +pat.fn + ' (' + pat.gender + ':' + pat.bds + ") " + pat.dos;
				},
				actions: [{key: '=', callback: function(){that.commitPt();} },{key: '+', callback: function(){that.commitPt();} }],
				getDescription: function(pat) {
					var adrss = helpers.cleanArray([pat.adr1,pat.adr2, pat.adr3, pat.cp]).join(', ');
					var adresse = adrss.length==0 ? "" : adrss + "; ";
					var vuln = pat.allDisCodes ? pat.allDisCodes : "";
					var hin = pat.hin ? pat.hin : "";
					var dos = (pat.dos && pat.dos.charAt(0)!='#') ? (', ' + pat.dos + '; ') : '';
					return pat.ln + ", " + pat.fn + ' [' + pat.bds +': ' + pat.gender + '] ' + hin + dos + 
					(typeof pat.isInsc=='undefined' ? '' : pat.isInsc=='0' ? 'NON inscrit; ':'INSCRIT; ') + 
					adresse + vuln;
				},
				selection: function(pat) {
					return pat.hin;
				}
		};

		function copyValuesToCurrentPatient(p, aa) {
			var currPt = that.model.currentPatient();
			delete currPt.id;
			delete currPt.ln;
			delete currPt.fn;
			delete currPt.gender;
			delete currPt.bds;
			delete currPt.txProfN;
			delete currPt.isInsc;
			delete currPt.allDisCodes;
			currPt.dirtyStatus = {};
			currPt.persRepdn = {};
			currPt.adr = {};
			currPt.adr.cy = {};
			currPt.typePerson=1;
			currPt.typSituConsi=1;
			currPt.typIdPerson=1;
			currPt.typEvenePers = "0";
			if (helpers.isNotEmpty(p.hin)) {
				that.model.currentPatient().typIdPerson = "1";	// ??? I ?
				// dans quel cas mettre 'M'??? 
				currPt.typePerson=1;
			} else {
				currPt.typePerson=2;
			}
			currPt.hin = p.hin;			
			if (p.id) {	// donc recherche avec index pt, il faut aller chercher les data d'archives
				currPt.id = p.id;
				currPt.ln = p.ln;
				currPt.fn = p.fn;
				currPt.gender = p.gender;
				currPt.bds = p.bds;
				currPt.adr = p.adr;
				currPt.txProfN = p.txProfN;
				currPt.isInsc = p.isInsc;
				currPt.allDisCodes = p.allDisCodes;
				if (aa && aa.length>1) {
					aa.shift();
					setDxEveToCurrentPatient(aa);
				} else {
					var idClientUid = {'u': clientUid};
					$http({method : "GET",
						url : "/syra/patient/search?u=" + clientUid + "&k=" + p.hin + "&m=2"
					}).then(function mySucces(response) {
						var res = response.data;
						if (res.length && res.length>0 && res[0].length>0) {
							setDxEveToCurrentPatient(res[0][1]);
							// il faut appeler à nouveau le focusIn du dxA de dx.
							$scope.dxAssist.elem.dxA.focusIn();
						}
						//$timeout(function(){$scope.focusOnDxAddInput();}, 250);
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
				}

			} else {
				setDxEveToCurrentPatient(aa);
				//$timeout(function(){$scope.focusOnDxAddInput();}, 250);
			}
			currPt.ident = that.model.getIdent();
			$scope.changeTypePerson();
			that.model.postCurrentPatient();
			//$scope.model.currPatientUpdated(true);	// doit être appelé plus tard - quand le return du post
		}

		function setDxEveToCurrentPatient(aa) {
			var codeDxs = [];
			var eveAcc = [];
			var eveDDM = [];
			var eveDPA = [];
			for (var i = 0; i < aa.length; i++) {
				var a = aa[i];
				if (angular.isDefined(a.ar_codedx) && a.ar_codedx.length>0) {
					for (var j = 0; j < a.ar_codedx.length; j++) {
						codeDxs.push(a.ar_codedx[j].replace(/"/g,''));
					}
				}
				if (angular.isDefined(a.typEve) && a.typEve!=0) {
					var date4Moment = {y: a.dateEve.year, M: a.dateEve.month, d:a.dateEve.dayOfMonth};
					if (a.typEve==1) {
						eveAcc.push(new moment(date4Moment).format('YYYY-MM-D'));
					} else if (a.typEve==2) {	// DDM
						eveDDM.push(new moment(date4Moment).format('YYYY-MM-D'));
					} else if (a.typEve==3) {	// DPA
						eveDPA.push(new moment(date4Moment).format('YYYY-MM-D'));
					}
				}
			}
			if (codeDxs.length>0 && that.model.currentDefault()['see_lastDx']) {
				that.model.currentPatient().codeDx = _.uniq(codeDxs);
			} else {
				delete that.model.currentPatient().codeDx;				
			}
			if (eveAcc.length>0) {
				that.model.currentPatient().eveAcc = _.uniq(eveAcc).sort().reverse();
			} else {
				delete that.model.currentPatient().eveAcc;				
			}
			if (eveDDM.length>0) {
				that.model.currentPatient().eveDDM = _.uniq(eveDDM).sort().reverse();
			} else {
				delete that.model.currentPatient().eveDDM;				
			}
			if (eveDPA.length>0) {
				that.model.currentPatient().eveDPA = _.uniq(eveDPA).sort().reverse();
			} else {
				delete that.model.currentPatient().eveDPA;				
			}
		}

		that.commitPt = function(){
			// pour que le + ou = fonctionne, il faut lui donner un focus autre lors du pushPatient.
			// ce focus doit être dans le même scope. Ici, c'est le bouton de type de recherche patient.
			if ($scope.model.currentDemPaimt().serv.lstPatients.size()>9) {
				$scope.model.warning("Le maximum de 10 items a été atteint.");
			} else {
				$scope.focusPlusOnHinAddInput(true);
				that.pushPatient();
				$scope.focusOnHinAddInput();
			}
		}

		$scope.ptAssist2 = {assistId: "autocomplete_patient2",
				nextTabOnTab: true,
				nextTabOnEnter: true,				
				actions: [{key: '=', callback: function(){that.commitPt2();} }, {key: '+', callback: function(){that.commitPt2();} }]
		};

		that.commitPt2 = function(){
			if ($scope.model.currentDemPaimt().serv.lstPatients.size()>9) {
				$scope.model.warning("Le maximum de 10 items a été atteint.");
			} else {
				$scope.focusPlusOnHinAddInput(true);
				that.pushPatient();
				$scope.focusOnHinAdd2Input();
			}
		}

		$scope.persIdPersAutreKeyUp = [
		                               {key: '=', callback: function(){that.commitIdPersAutre();} },
		                               {key: '+', callback: function(){that.commitIdPersAutre();} },
		                               {key: 61 , callback: function(){that.commitIdPersAutre();} }
		                               ];

		that.commitIdPersAutre = function(){
			if ($scope.model.currentDemPaimt().serv.lstPatients.size()>9) {
				$scope.model.warning("Le maximum de 10 items a été atteint.");
			} else {
				that.pushPersAutre();
				$scope.focusOnIdPersAutreInput();
			}
		}

		$scope.saveCurrPatientPrn = function() {
			if (that.model.currentPatient().dirtyStatus.val) {
				that.model.postCurrentPatient();
				delete that.model.currentPatient().dirtyStatus.val;
			}
		};

		//Repondant assist input
		$scope.repdnAssist = { assistId: "autocomplete_repdn",
				listWidth: 300,
				getAjaxData: function(query){
					return { url:"/syra/repondant/get",
						data: { k: query, u: clientUid }};
				},
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {
					var rep;
					if (elem.length==3) {
						rep = elem[2];
					} else if (elem.length==5) {
						rep = elem[1]+", " + elem[2];					
					}
					return "<div class='divTable'><div class='divRow'><div class='divCellCol2'>" + rep + "</div></div></div>";
				},
				selection: function(elem) {
					this.lockEntry();
					var rep;
					that.model.currentPatient().persRepdn.typPersAutre = +elem[0];
					if (elem.length==3) {
						rep = elem[2];
						$timeout(function() {
							that.model.currentPatient().persRepdn.typIdPersAutre = +elem[1];
							that.model.currentPatient().persRepdn.idPersAutre = elem[2];
							$scope.setDirty();
						},50);
					} else if (elem.length==5) {
						rep = elem[1] + ", " + elem[2];
						$timeout(function() {
							that.model.currentPatient().persRepdn.ln = elem[1];
							that.model.currentPatient().persRepdn.fn = elem[2];
							that.model.currentPatient().persRepdn.bds = elem[3];
							that.model.currentPatient().persRepdn.gender = elem[4];
							$scope.setDirty();
						},50);
					}
					$scope.repIdent = rep;
					return rep;
				},
				suggestOnDataLoaded: function(listRepdn, queryString) {
					if(listRepdn.length === 1){
						this.select(listRepdn[0]);
						return false;
					}
					return true;
				}
		};

		//Diagnostics assist input
		$scope.dxAssist = { assistId: "autocomplete_dx",
				listWidth: 500,
				nextTabOnTab: true,
				getAjaxData: function(query){
					return { url:"/syra/diagnostic/search",
						data: { k: query, u: clientUid }};
				},
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'><b>" + elem.c + "</b></div><div class='divCellCol2'>" + elem.dl + "</div></div></div>";},
				actions : [{key: '=', callback: function(){that.commitDx();} }, {key: '+', callback: function(){that.commitDx()} }],
				selection: function(dx) {
					this.lockEntry();
					$scope.setDirty();	// le ng-change n'est pas appelé quand selection!
					that.model.currentDx().c = dx.c;
					that.model.currentDx().da = dx.da;
					that.model.currentDx().dl = dx.dl;
					$scope.dxGridApi.core.notifyDataChange(uiGridConstants.dataChange.ROW);
					return dx.c;
				},
				suggestOnDataLoaded: function(listCodeDx, queryString) {
					if(listCodeDx.length === 1){
						this.select(listCodeDx[0]);
						return false;
					}
					return true;
				},
				updateDataSourceWithValues: function() {
					//$log.log("dans updateDataSourceWithValues: " + that.model.currentPatient().codeDx);
					if (helpers.isEmpty(that.model.currentDx().c) && angular.isDefined(that.model.currentPatient().codeDx) && that.model.currentPatient().codeDx.length>0) {
						return that.model.currentPatient().codeDx.toString();
					}
				}
		};

		$scope.codeDxBlur = function() {
			if (helpers.isNotEmpty(that.model.currentDx().c)) {
				that.model.currentDx().c = that.model.currentDx().c.trim().toUpperCase();
			}
		};
		//date eve pers assist input - conflit de directive quans a/a date acc. Que faire?
//		$scope.dateeveAssist = { assistId: "autocomplete_dateeve",
//		listWidth: 250,
//		hasHeader: false, hasDetails: false,
//		getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'><b>" + elem.c + "</b></div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
//		selection: function(e) {
//		this.lockEntry();
//		$scope.setDirty();	// le ng-change n'est pas appelé quand selection!
//		return e.d;
//		},
//		updateDataSourceWithValues: function() {
//		var eveAcc = that.model.currentPatient().eveAcc;
//		var eveRet = that.model.currentPatient().eveRet;
//		var eves = (angular.isDefined(eveAcc) ? eveAcc : []).concat(angular.isDefined(eveRet) ? eveRet : []);
//		if (eves.length>0 && angular.isUndefined(that.model.currentPatient().datEvenePers)) {
//		return eves;
//		}
//		}
//		};


		that.commitDx = function(){
			// pour que le + ou = fonctionne, il faut lui donner un focus autre lors du pushPatient.
			// ce focus doit être dans le même scope. Ici, c'est le bouton de type de recherche patient.
			$scope.focusPlusOnHinAddInput(true);
			that.pushDx();
			$scope.focusOnDxAddInput();
		}

		this.getDiagnosticResults = function(n){
			if( this.dxList.length < n ){
				return this.dxList;
			}else{
				return this.dxList.slice(0, n);
			}
			$("#dxInput").setSelectionRange(0, $("#dxInput").value.length);
			$("#dxInput").select();
		};

		$scope.patientHistoryGridOptions =  {
				data : that.model.currentHistoricBills(),
				enableMinHeightCheck:false,
				multiSelect: false,
				enableFiltering: that.model.currentDefault()['see_histFilter'],
				enableSorting:true,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				saveScroll: false,
				enableColumnMenus:false,
				enableHiding: false,
				headerTooltip: true,
				modifierKeysToMultiSelect: false,
				noUnselect: true,
				appScopeProvider: this,
				columnDefs: []
		};
		$scope.patientHistoryGridOptions.onRegisterApi = function(gridApi){
			if (!$scope.patientHistoryGridApi) {
				$scope.patientHistoryGridApi = gridApi;
			}
		};

		$timeout( function() {
			$scope.patientHistoryGridOptions.columnDefs.push(
					{ field: 'ds', displayName: 'Date', width: "100"},
					{ field: 'np', displayName: 'Prof.', width: "80"},
					{ field: 'cod', displayName: 'Code', type:'number', cellClass:'text-right', width: "60"},
					{ field: 'dx', displayName: 'Dx', width: "100"},
					{ field: 'lieu', displayName: 'Lieu', width: "80"},
					{ field: 'tEve', displayName: 'Evénement', width: "100", filter: {
						noTerm: true,
						type: uiGridConstants.filter.SELECT,
						selectOptions: [ { value: '1', label: 'CSST' }, { value: '2', label: 'DDM' }, { value: '3', label: 'DPA' }]
					}, cellFilter: 'mapEve'},
					{ field: 'dEve', displayName: 'Date évén.', width: "100"},
					{ field: 'dEnt', displayName: 'Date entr.', width: "100"},
					{ field: 'id', displayName: 'No fact. RAMQ', type:'number', cellClass:'text-right', width: "130"}
			);
		});

		function removeAllDx(pt) {
			pt.lstDx.clear();
			that.setDx({});
			helpers.clearAndAddToArray($scope.dxGridOptions.data, pt.lstDx.values());
			that.model.setCurrDx({});
		}

		this.setDx = function(dx) {
			that.model.setCurrDx(dx, true);
		};

		function editPatient(){
			if (angular.isUndefined(that.model.currentPatient().id)) {
				// ajout - considérer le patient de la facture comme le md tx.
				that.model.currentPatient().txProfN = that.model.currentProf().noProf;
			}
			if (angular.isUndefined(that.model.currentPatient().hin)) {
				that.model.warning("Veuillez inscrire le NAM avant d'ajouter le patient.");
			} else {
				$scope.inscriptionOpened = true;
				$scope.modalInstance = $uibModal.open({
					animation: $scope.animationsEnabled,
					templateUrl: "/syra/Resources/views/modal.html",
					controller: 'ModalInstanceCtrl',
					size: "md",
					resolve: {
						mObject: function () {
							return {
								title: "Editer Patient",
								templateUrl:'/syra/editpatient?u=' + clientUid,
								modalData : that.model.currentPatient()
							};
						}
					}
				});

				$scope.modalInstance.result.then(function (patient) {
					that.model.currentPatient().id = patient.id;
					that.model.currentPatient().ln = patient.ln;
					that.model.currentPatient().fn= patient.fn;
					that.model.currentPatient().bds= patient.bds;
					that.model.currentPatient().gender= patient.gender;
					that.model.currentPatient().txProfN = patient.txProfN;
					$scope.inscriptionOpened = false;
				}, function () {
					$scope.inscriptionOpened = false;
					$scope.focusOnDxAddInput();
				});
			}
		}

		this.editPat = function(){
			editPatient();
		};

		this.hello = function(m) {
			new jBox('Notice', {
				color : 'green',
				content: m,
				attributes: {
					x: 'right',
					y: 'bottom'
				}
			});
		};

		$scope.ptGridOptions = {
				data: [],
				enableHorizontalScrollbar : 0,
				enableMinHeightCheck:false,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				saveScroll: false,
				enableHiding: false,
				showHeader: false,
				headerTooltip: false,
				modifierKeysToMultiSelect: false,
				noUnselect: true,
				appScopeProvider: that,
				columnDefs:[
				            {field: 'tag', cellClass: 'row-item', width: "40", cellTooltip: true, visible:showTag},
				            {field: 'ident', cellClass: 'row-item' }, 
				            {field: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	"<button class='btn-emoji dxDelBtn' tabindex='-1' title='Retirer' ng-mouseup='grid.appScope.deletePtFromGrid(row.entity);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"}
				            ]
		};

		$scope.ptGridOptions.onRegisterApi = function(gridApi){
			$scope.ptGridApi = gridApi;
			gridApi.grid.registerDataChangeCallback(function(data) {
				$scope.ptGridApi.selection.selectRow(data);
			}, [uiGridConstants.dataChange.ROW]);
			gridApi.selection.on.rowSelectionChanged($scope,function(row){
				that.model.setCurrPatient(row.entity, false);
				helpers.clearAndAddToArray($scope.dxGridOptions.data, row.entity.lstDx.values());
				$timeout(function () {
					if (angular.isDefined($scope.dxGridApi)) {
						if ($scope.dxGridOptions.data.length>0) {
							$scope.dxGridApi.selection.selectRowByVisibleIndex(0);
						}
					}
				}, 10);

				gridApi.activeRowIndex = $scope.ptGridOptions.data.indexOf(row.entity);
				if ($scope.history && helpers.isNotEmpty(row.entity.ident) && row.entity.ident!=='...') {
					that.model.callForCurrentHistoricBills();
				}
			});
		};

		that.deletePtFromGrid = function(p) {
			removeAllDx(p);
			that.model.removePatientFromLst(p, true);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstPatients, true);
			helpers.clearAndAddToArray($scope.ptGridOptions.data, that.model.currentDemPaimt().serv.lstPatients.values());
			$timeout(function () {
				if ($scope.ptGridOptions.data.length==0) {
					that.model.setDefaultCurrPatient();
					that.setDx({});
					helpers.clearAndAddToArray($scope.dxGridOptions.data, pt.lstDx.values());
					that.model.setCurrDx({});
				} else {
					if ($scope.ptGridApi.activeRowIndex) {
						if ($scope.ptGridApi.activeRowIndex>0) {
							$scope.ptGridApi.activeRowIndex--;
						} 
						$scope.ptGridApi.selection.selectRowByVisibleIndex($scope.ptGridApi.activeRowIndex);
					} else {
						$scope.ptGridApi.selection.selectRowByVisibleIndex(0);
					}
				}
			}, 10);
		};

		$scope.dxGridOptions = {
				data:  [],
				enableHorizontalScrollbar : 0,
				enableMinHeightCheck:false,
				multiSelect: false,
				enableRowSelection: true,
				enableRowHeaderSelection: false,
				saveScroll: false,
				enableHiding: false,
				showHeader: false,
				headerTooltip: true,
				modifierKeysToMultiSelect: false,
				noUnselect: true,
				appScopeProvider: that,
				columnDefs:[
				            {field: 'tag', cellClass: 'row-item', width: "40", cellTooltip: true, visible:showTag},
				            {field: 'c', cellClass: 'row-item', width: "40", cellTooltip: true},
				            {field: 'da', cellClass: 'row-item', cellTooltip: true}, 
				            {field: 'index',  cellTemplate: '<div class="grid-action-cell">'+
				            	"<button class='btn-emoji dxDelBtn' tabindex='-1' title='Retirer' ng-mouseup='grid.appScope.deleteDxFromGrid(row);' ng-bind-html=\"'274c' | exposeEmoji\"></button></div>", displayName: '', width: "24"}
				            ]
		};

		$scope.dxGridOptions.onRegisterApi = function(gridApi){
			//set gridApi on scope
			$scope.dxGridApi = gridApi;
			gridApi.selection.on.rowSelectionChanged($scope,function(row){
				that.model.setCurrDx(row.entity);
				gridApi.activeRowIndex = $scope.dxGridOptions.data.indexOf(row.entity);
			});
		};

		that.deleteDxFromGrid = function(d) {
			$scope.dxGridApi.core.setRowInvisible(d);
			that.deleteDx(d.entity);
			that.model.setDirtyStatus(that.model.currentDemPaimt().serv.lstPatients, true);
			var tag = d.entity.tag;
			$timeout(function () {
				if ($scope.dxGridApi.activeRowIndex) {
					if ($scope.dxGridApi.activeRowIndex>0) {
						$scope.dxGridApi.activeRowIndex--;
					} 
					$scope.dxGridApi.selection.selectRowByVisibleIndex($scope.dxGridApi.activeRowIndex);
				} else {
					$scope.dxGridApi.selection.selectRowByVisibleIndex(0);
				}
				var selectedRows = $scope.dxGridApi.selection.getSelectedRows();
				if (angular.isUndefined(selectedRows) || selectedRows.length==0 || tag==selectedRows[0].tag) {
					that.model.setCurrDx({});
				}
			}, 0,1);
		};

		that.deleteDx = function(dx) {
			that.model.currentPatient().lstDx.remove(dx.tag);
		};

		that.setUiForRechPats = function(v) {
			if (angular.isUndefined(v)) {
				v = that.model.currentDefault()['recherchePatients'];
			}
			if (v=='4') {
				that.model.setFirstFocus(function() {
					$scope.focusOnHinAdd2Input();
				});
			} else {
				that.model.setFirstFocus(function() {
					$scope.focusOnHinAddInput();
				});
			}
		};

	}]);
	patient.filter('mapEve', function() {
		var statusHash = {
				1: 'CSST',
				2: 'DDM',
				3: 'DPA'
		};
		return function(input) {
			if (isNaN(input)){
				return '';
			} else {
				return statusHash[input];
			}
		};
	});

})();