(function(){
	var app = angular.module("fav", ['ui.grid','ui.grid.edit', 'ui.grid.cellNav', 'ui.grid.resizeColumns','ngTouch','widget']);
	
	app.directive('favProfValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.favProfValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.fav.prof.lastName) && scope.fav.prof.noProf==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length>4) {
						if (angular.isDefined(scope.fav.prof.id)) {
							delete scope.fav.prof.id;
							delete scope.fav.prof.lastName;
							delete scope.fav.prof.firstName;
						}
						$http({
							method : "GET",
							url : "/syra/professionals/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.fav.prof = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.fav.prof.id)) {
							delete scope.fav.prof.id;
							delete scope.fav.prof.lastName;
							delete scope.fav.prof.firstName;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
		
	app.directive('favCopyValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.favCopyValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.fav.copyProf.lastName) && scope.fav.copyProf.noProf==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length>4) {
						if (angular.isDefined(scope.fav.copyProf.id)) {
							delete scope.fav.copyProf.id;
							delete scope.fav.copyProf.lastName;
							delete scope.fav.copyProf.firstName;
						}
						$http({
							method : "GET",
							url : "/syra/professionals/get?c=" + viewValue +"&u=" + clientUid
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.noProf)) {
									scope.fav.copyProf = res;
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.fav.copyProf.id)) {
							delete scope.fav.copyProf.id;
							delete scope.fav.copyProf.lastName;
							delete scope.fav.copyProf.firstName;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	
	app.controller('FavoriteController', ['$scope', '$http', '$log', '$timeout', 'uiGridConstants', 'clientUid','model','$uibModal', function ($scope, $http, $log, $timeout, uiGridConstants, clientUid, model, $uibModal) {
		this.dataLoading = false;
		this.prof = _.clone(model.currentProf());
		this.copyProf = {};
		this.favType = -1;
		this.clientUid = clientUid;
		//Favorite links mapping
		this.favMap = new Map();
		this.favMap.set(0, "diag");
		this.favMap.set(1, "fact");
		this.favMap.set(2, "elmcontx");
		this.favMap.set(3, "local");
		this.favMap.set(4, "etabl");
		this.favMap.set(5, "sect");
		// le type associé aux datas
		this.favCodeTypeMap = new Map();
		this.favCodeTypeMap.set(0, "string");	// diag
		this.favCodeTypeMap.set(1, "number");
		this.favCodeTypeMap.set(2, "number");
		this.favCodeTypeMap.set(3, "number");
		this.favCodeTypeMap.set(4, "string");
		this.favCodeTypeMap.set(5, "string");
		var that = this;
		$scope.fav_model = {};
		var vthresh = 50;
		var scrollt = 80
		var wheelst = 150;
		var exRows = 100;
		
		$scope.myData = [];

		$scope.removeModel = function() {
			this.favType = -1;
			$scope.fav_model = {};
			$scope.gridOptions.data = [];
		};
		$scope.removeProf = function() {
			this.favType = -1;
			that.prof = {};
			$scope.gridOptions.data = [];
		};

		$scope.modelAssist = {assistId: "autocomplete_favModel", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.fav_model.name)) {
						delete $scope.fav_model.name;
					}
					if (angular.isDefined($scope.fav_model.typefav)) {
						delete $scope.fav_model.typefav;
					}
					return { url:"/syra/fav_model/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 300,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {
					if (angular.isDefined(elem) && elem!=null) {
						return "<div class='divTable'><div class='divRow'><div class='divCellCol2' style='padding:0.5em;'>" + elem.d + "</div></div></div>";
					}
					return null;
				},
				selection: function(elem) {
					this.lockEntry();
					$http({
						method : "GET",
						url : "/syra/fav_model/get?c=" + elem.c +"&u=" + clientUid
					}).then(function mySucces(response) {
						if (angular.isUndefined(response.data.length)) {
							var res = response.data;
							var t = parseInt(elem.c.charAt(0));
							that.favType = t;
							var types = elem.d.split(', ');
							$scope.fav_model.id = res.idProf;
							$scope.fav_model.typefav = types[0];
							$scope.fav_model.typeprof = types[1];							
							loadData(res.idProf);
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return $scope.fav_model.typeprof;
				}
		};
			
		function getHeaderName() {
			
			if ($scope.fav_model.typefav) {
				return $scope.fav_model.typefav + " " + $scope.fav_model.typeprof;
			} else if (that.prof.id) {
				return that.prof.lastName + " " +that.prof.firstName;
			}
		}
		
		$scope.favProfAssist = profAssistInput("autocomplete_favProf");
		$scope.favProfAssist.selection = function(elem) {
			this.lockEntry();
			that.prof = elem;
			$scope.$apply();
			if(that.favType != -1){
				loadData();
			}
			return elem.noProf;
		};
		
		function transferValid(){
			var valid = !(angular.isDefined(that.prof.id) && angular.isDefined($scope.fav_model.id)) && !$.isEmptyObject(that.copyProf)
			&& that.prof.id !== that.copyProf.id && that.favType > -1;
			if(!valid){
				var msg = 'Le médecin de référence et le médecin de destination doivent être saisis et différents';
				jNotice(msg, 'yellow');
			}
			return valid;
		}
		
		function jNotice(msg, color){
			new jBox('Notice', {
				color : color,
				autoClose: 2500,
			    content: msg
			});
		}
		
		$scope.favProfCopyAssist = profAssistInput("autocomplete_favProfCopy");
		$scope.favProfCopyAssist.selection = function(elem) {
			this.lockEntry();
			that.copyProf = elem;
			$scope.$apply();
			return elem.noProf;
		};
		
		function profAssistInput(assistDiv){
			return {assistId: assistDiv, 
				hasHeader: false, hasDetails: false,
				getAjaxData: function(query){
				return { url:"/syra/professionals/search",
					data: { k: query, u:that.clientUid }};
				},
				listWidth: 300,
				getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:70px;'>" + elem.noProf + "</div><div class='divCellCol2'>" + elem.lastName + ", " + elem.firstName + "</div></div></div>";},
				suggestOnDataLoaded: function(data) {
					if(data.length === 1){
						this.select(data[0]);
						return false;
					}
					return true;
				}
			}
		}
		
		$scope.highlightFilteredHeader = function( row, rowRenderIndex, col, colRenderIndex ) {
		    if( col.filters[0].term ){
		      return 'header-filtered';
		    } else {
		      return '';
		    }
		  };
		
		  // la colonne des codes est définie dans une var afin de pouvoir en changer
		  // les caractéristiques suite au chargement des données (comme le type pour dx).
		var codeColumn = { field: 'c', displayName: 'Code', width: "10%" , enableCellEdit: false, enableHiding: true, disableCancelFilterButton: true,
			 filter: {
		          condition: function(searchTerm, cellValue) {
		        	  var st = searchTerm.trim();
		        	  var found = false;
		        	  var search = st.split(' ');
		        	  for (j = 0; j < search.length; j++) {
		        		  found = cellValue == search[j];
		        		  if (found) {
		        			  return true;
		        		  }
		        	}
		        	return false;
		          }, 
		          placeholder: "1 56 5"
		        },
		     headerCellClass: $scope.highlightFilteredHeader
		};
		
		$scope.gridOptions = { data: $scope.myData,
				virtualizationThreshold: vthresh,	// defaut 20
				scrollThreshold:scrollt,
				wheelScrollThrottle:wheelst,
				excessRows:exRows,
				enableCellEdit: false,
				cellEditableCondition: function() {
					return angular.isUndefined($scope.fav_model.typefav);
			    },
				enableColumnResizing: true,
				enableCellSelection: true,
				enableCellEditOnFocus:true,
				enableFiltering: true,
				enableSorting: true,
				saveScroll: false,
				enableHiding: true,
				enableGridMenu: true,
				disableCancelFilterButton: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return getHeaderName().replace(' ','_') + ".csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: getHeaderName(), style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth:480,
			    exportPdfIf: function(gdata){
	            	if(gdata.length < MSG_TEXT['MAX_DATA'])return that.dataLoading = true;
	            	else {
	            		model.warning(MSG_TEXT['TROP_DATA']);
	            		return false;
	            	}
	            },
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "",
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				columnDefs: [
			 { field: 'p', displayName: 'Fav.', width: "10%", enableCellEdit: true, enableHiding: true, disableCancelFilterButton: true,
				 filter: {
			          condition: function(searchTerm, cellValue) {
			        	  var st = searchTerm.trim().replace(/\\/g, '');
			        	  var val = cellValue.trim();
			        	  if (st.indexOf(".")>-1) {
			        		  return val.length>0;
			        	  }
			        	  var search = st.replace(' ', '').split(',');
			        	  for (j = 0; j < search.length; j++) {
			        		  var patt = new RegExp("[" + search[j] + "]",'i');
			        		  var found = patt.test(val);
			        		  if (found) {
			        			  return true;
			        		  }
			        	}
			        	return false;
			          }, 
			          placeholder: "./a/a-z"
			        }, headerCellClass: $scope.highlightFilteredHeader,
				 editableCellTemplate: "<input type=\"INPUT_TYPE\" data-ng-class=\"'colt' + col.uid\" ui-grid-editor data-ng-model=\"MODEL_COL_FIELD\" minlength=0 maxlength=1 pattern=\"(^$)|([a-zA-Z]{1})\" uppercase />"
			 },
			 codeColumn,
			 { field: 'd', displayName: 'Description', enableCellEdit: false, cellTooltip: true, enableHiding: true, disableCancelFilterButton: true,
				 filter: {
			          condition: function(searchTerm, cellValue) {
			        	  var st = searchTerm.trim();
			        	  var found = false;
			        	  var search = st.split(' ');
			        	  for (j = 0; j < search.length; j++) {
			        		  var patt = new RegExp("(" + search[j] + ")",'i');
			        		  found = patt.test(cellValue);
			        		  if (!found) {
			        			  return false;
			        		  }
			        	}
			        	return found;
			          }, 
			          placeholder: "ex.: exam ordi"
			        }, headerCellClass: $scope.highlightFilteredHeader	 
			 }
			 ]};

		$scope.gridOptions.onRegisterApi = function(gridApi){
	       $scope.gridApi = gridApi;
	       gridApi.edit.on.afterCellEdit($scope, function(rowEntity, colDef, newValue, oldValue) {
	    	   $timeout(function() {
//            	   $log.log("oldValue=" + oldValue + ", newValue=" + rowEntity.p)
            	   if(oldValue != rowEntity.p){
	       				$http({url: that.getUrl() + "/mod", method:"GET", async:true,
	         			   params: {id : that.prof.id, pp: oldValue, np : rowEntity.p, c : rowEntity.c, u: that.clientUid}
	    				}).then(function mySucces(response) {
//	    					$log.log("succès du get pour: " + that.getUrl() + "/mod");
	    				}, function myError(response) {
	    					$log.log("Erreur du get pour: " + that.getUrl() + "/mod: " + response.statusText);
	    				});
            	   }
               }, 1000);
	       });
		};
		this.getUrl = function(){
		   	return "/syra/pref/" + that.favMap.get(that.favType);
		};
		
		this.transferFav = function(replace){
			if(transferValid()){
				var id = angular.isDefined($scope.fav_model.id) ? $scope.fav_model.id : that.prof.id;
				$http({url: "/syra/pref/copy",
					async: true,
					params: {id: id , idto :  that.copyProf.id, t : that.favType, u: that.clientUid, r: replace}
					}).then(function successCallback(response) {
						var msg = (replace==1 ? 'Le remplacement' : "L'ajout") + ' des favoris a réussi';
						jNotice(msg, 'green');
					  }, function errorCallback(response) {
							var msg = 'Erreur lors de la copie des favoris';
							jNotice(msg, 'red');
					  });
			}
		};
		
		this.getPref = function(tab){
			if($.isEmptyObject(that.prof)){
				var msg = 'Veuillez choisir un médecin';
				jNotice(msg, 'yellow');
			}else{
				that.favType = tab;
				loadData();
			}
		};
		
		function loadData(id){
			if (!arguments.length) {
				id = that.prof.id;
			}
			that.dataLoading = true;
			$http.get(that.getUrl()+ "?id="+ id + "&u=" + that.clientUid)
			.success(function(data) {
				codeColumn.type = that.favCodeTypeMap.get(that.favType);
				$scope.gridOptions.data = data;
				that.dataLoading = false;
				if (data.length>0) {
					$scope.gridApi.core.scrollToIfNecessary($scope.gridOptions.data[0], $scope.gridOptions.data[0].p);
				}
				$scope.gridApi.core.on.sortChanged( $scope, $scope.sortChanged );
			});
		}
		
	}]);
})();