(function(){
	var app = angular.module("etab", []);
	
	app.directive('etabValid', function($q, $http, clientUid) {
		  return {
			  restrict: 'A',
		    require: 'ngModel',
		    link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.etabValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab) && angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab.nomEtab) && scope.etabCtrl.model.currentLieu().etab.noSelectedEtab==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						scope.model.setCurrLieuNoSelectedEtab(viewValue, false);
						if (angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab) && angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab.nomEtab)) {
							delete scope.etabCtrl.model.currentLieu().etab.valEtab.nomEtab;
						}
						$http({
							method : "GET",
							url : "/syra/etabl/get?c=" + viewValue +"&u=" + clientUid +"&d=1"
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.valEtab.nomEtab) && res.valEtab.nomEtab!='') {
									scope.etabCtrl.model.setCurrLieuValEtab(res.valEtab, false);
									var elem = {};
									elem.c = viewValue;
									elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
									scope.setSectionFromEtab(elem);
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						if (angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab) && angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valEtab.nomEtab)) {
							delete scope.etabCtrl.model.currentLieu().etab.valEtab.nomEtab;
						}
						deferred.reject();
					}
				    return deferred.promise;
		      };
		    }
		  };
		});
			
	app.directive('sectValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.sectValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isUndefined(modelValue) || ''==modelValue) {
						deferred.resolve();
					} else if (angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valSect) && angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valSect.desSectActiv) && scope.etabCtrl.model.currentLieu().etab.valSect.noSectActiv==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null) {
						if (angular.isDefined(scope.etabCtrl.model.currentLieu().etab.valSect.desSectActiv)) {
							delete scope.etabCtrl.model.currentLieu().etab.valSect.desSectActiv;
						}
						$http({
							method : "GET",
							url : "/syra/secteur/get?c=" + viewValue +"&u=" + clientUid +"&d=1"
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.desSectActiv) && res.desSectActiv!='') {
									scope.etabCtrl.setCurrSect(response.data);
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					} else {
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	app.directive('localValid', function($q, $http, clientUid) {
		return {
			restrict: 'A',
			require: 'ngModel',
			link: function(scope, elm, attrs, ctrl) {
				ctrl.$asyncValidators.localValid = function(modelValue, viewValue) {
					var deferred = $q.defer();
					if (angular.isDefined(scope.etabCtrl.model.currentLieu().local.valCodLocal) && angular.isDefined(scope.etabCtrl.model.currentLieu().local.valCodLocal.nomLocal) && scope.etabCtrl.model.currentLieu().local.valCodLocal.codLocal==viewValue) {
						deferred.resolve();
					} else if (angular.isDefined(viewValue) && viewValue.match(/^[0-9]+$/) != null && viewValue.length==5) {
						if (angular.isDefined(scope.etabCtrl.model.currentLieu().local.valCodLocal.nomLocal)) {
							delete scope.etabCtrl.model.currentLieu().local.valCodLocal.nomLocal;
						}
						$http({
							method : "GET",
							url : "/syra/local/get?c="+viewValue+"&u="+clientUid +"&d=1"
						}).then(function mySucces(response) {
							var res = response.data;
							if (angular.isUndefined(res.length)) {
								if (angular.isDefined(res.nomLocal) && res.nomLocal!='') {
									scope.etabCtrl.setCurrValLocal(res);
									deferred.resolve();
								} else {
									deferred.reject();
								}
							} else {
								deferred.reject();
							}
						}, function myError(response) {
						});
					} else {
						if (angular.isDefined(scope.etabCtrl.model.currentLieu().local.valCodLocal) && angular.isDefined(scope.etabCtrl.model.currentLieu().local.valCodLocal.nomLocal)) {
							delete scope.etabCtrl.model.currentLieu().local.valCodLocal.nomLocal;
						}
						deferred.reject();
					}
					return deferred.promise;
				};
			}
		};
	});
	
	app.controller('EtabController', ['$scope','$http', '$timeout', '$log', 'clientUid','model','Codifies',
	                                  function($scope, $http, $timeout, $log, clientUid, model, Codifies){
		var that = this;
		this.codifie = "C";
		this.model = model;
		$scope.model = model;
				
		this.listEtab;
		this.listSect;
		this.listLocal;
		this.localGere = false;
		
		that.codifies = Codifies.list();

		that.typIdLieuGeos = [
		                      {'id': '2', 'label': 'Code postal'},
		                      {'id': '3', 'label': 'Code localité'}
		                      ];	// pref typIdLieuGeo
		
		that.typLieuGeos = [
		                      {'id': 'C', 'label': 'Cabinet'},
		                      {'id': 'D', 'label': 'Domicile'},
		                      {'id': 'A', 'label': 'Autre'},
		                      {'id': 'I', 'label': 'Inconnu'}
		                      ];
		
		that.codPreciSectActivs = [];
		that.codPreciSectActivs[1] = [
                               {'id': 0, 'label': "S/O"},
		                      {'id': 1, 'label': "Salle d'opération"}
		                      ];
		that.codPreciSectActivs[2] = [
		                           {'id': 0, 'label': "S/O"},
		                           {'id': 1, 'label': "Salle d'opération"},
		                           {'id': 2, 'label': "Au chevet du patient"}
		                           ];
		that.getCodPreciSectActivs=function() {
			return that.codPreciSectActivs[(that.model.currentProf().type)];
		};
		
		that.codPreciLieuxPhys = [];
		that.codPreciLieuxPhys[1] = [
	                         	  {'id': '0', 'label': "S/O"},
	                              {'id': 'A', 'label': "Santé publique (Annexe XXIII)"},
	                              {'id': 'B', 'label': "Examen à domicile - programme de gériatrie de courte durée"},
	                              {'id': 'C', 'label': "Visite à domicile - clientèle inscrite"}
	                              ];
		that.codPreciLieuxPhys[2] = [
	                              {'id': '0', 'label': "S/O"},
	                              {'id': 'D', 'label': "Témoignage au tribunal"},
	                              {'id': 'E', 'label': "Médecine communautaire (LE 160)"},
	                              {'id': 'F', 'label': "Santé publique et médecine préventive ou médecine du travail"},
	                              {'id': 'G', 'label': "Visite ou consultation en gériatrie effectuée dans un établissement différent du lieu habituel de pratique"},
	                              {'id': 'L', 'label': "Local sous gestion du gouvernement ou d'un organisme qu'il subventionne"}
	                              ];
		that.codPreciLieuxGeo = [];
		that.codPreciLieuxGeo[1] = [
		                         {'id': '0', 'label': "S/O"}
		                         ];
		that.codPreciLieuxGeo[2] = [
		                         {'id': '0', 'label': "S/O"},
		                         {'id': 'L', 'label': "Local sous gestion du gouvernement ou d'un organisme qu'il subventionne"}
		                         ];
		that.getCodPreciLieux=function() {
			if ('C'===that.model.currentLieu().typLocEtab) {
				return that.codPreciLieuxPhys[(that.model.currentProf().type)];
			} else {
				return that.codPreciLieuxGeo[(that.model.currentProf().type)];
			}
		};
		
		$scope.lieu = {
			typLocEtab: function(newVal) {
				if (arguments.length) {
					that.model.setCurrLieuTypLocEtab(newVal, true);
				} else {
					return that.model.currentLieu().typLocEtab;
				}
			},
			typIdLieuGeo: function(newVal) {
				if ('N'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().local)) {
						that.model.currentLieu().local = {};
					}
					if (arguments.length) {
						that.model.setCurrLieuTypIdLieuGeo(newVal, true);
					} else {
						return that.model.currentLieu().local.typIdLieuGeo;
					}
				}
			},
			typLieuGeo: function(newVal) {
				if ('N'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().local)) {
						that.model.currentLieu().local = {};
					}
					if (arguments.length) {
						that.model.setCurrLieuTypLieuGeo(newVal, true);
					} else {
						return that.model.currentLieu().local.typLieuGeo;
					}
				}
			},
			codLocal: function(newVal) {
				if ('N'===that.model.currentLieu().typLocEtab && angular.isDefined(that.model.currentLieu().local) && that.model.currentLieu().local.typIdLieuGeo==='3') {
					if (arguments.length) {
						that.model.setCurrLieuCodLocal(newVal, true);
					} else {
						return that.model.currentLieu().local.valCodLocal.codLocal;
					}
				}
			},
			codPostal: function(newVal) {
				if ('N'===that.model.currentLieu().typLocEtab && angular.isDefined(that.model.currentLieu().local) && that.model.currentLieu().local.typIdLieuGeo==='2') {
					if (arguments.length) {
						that.model.setCurrLieuCodLocal(newVal, true);
					} else {
						return that.model.currentLieu().local.valCodLocal.codLocal;
					}
				}
			},
			noSelectedEtab: function(newVal) {
				if ('C'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().etab)) {
						that.model.currentLieu().etab = {};
					}
					if (arguments.length) {
						that.model.setCurrLieuNoSelectedEtab(newVal, true);
					} else if (angular.isDefined(that.model.currentLieu().etab)){
						return that.model.currentLieu().etab.noSelectedEtab;
					}
				}
			},
			sect_c: function(newVal) {
				if ('C'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().etab)) {
						that.model.currentLieu().etab = {};
					}
					if (arguments.length) {
						that.model.setCurrLieuSecC(newVal, true);
					} else if (angular.isDefined(that.model.currentLieu().etab.valSect)) {
						return that.model.currentLieu().etab.valSect.noSectActiv;
					}
				}
			},
			codPreciSectActiv: function(newVal) {
				if ('C'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().etab)) {
						that.model.currentLieu().etab = {};
					}
					if (arguments.length) {
						that.model.setCurrLieuCodPreciSectActiv(newVal, true);
					} else {
						return that.model.currentLieu().etab.codPreciSectActiv;
					}
				}
			},
			codPreciLieu: function(newVal) {
				if ('C'===that.model.currentLieu().typLocEtab) {
					if (angular.isUndefined(that.model.currentLieu().etab)) {
						that.model.currentLieu().etab = {};
					}
					if (arguments.length) {
						that.model.currentLieu().etab.codPreciLieu = newVal;
						that.model.setCurrLieuCodPreciLieu(newVal, true);
					} else {
						return that.model.currentLieu().etab.codPreciLieu;
					}
				} else {
					if (angular.isUndefined(that.model.currentLieu().local)) {
						that.model.currentLieu().local = {};
					}
					if (arguments.length) {
						that.model.currentLieu().local.codPreciLieu = newVal;
						that.model.setCurrLieuCodPreciLieu(newVal, true);
					} else {
						return that.model.currentLieu().local.codPreciLieu;
					}					
				}
			}
			
		};
		
		$scope.typLocEtabChange = function() {
			if (that.isCodifie()) {
				$timeout(function(){$scope.focusOnNoEtab();},200);
			} else if (that.model.currentLieu().local.typIdLieuGeo==3) {
				$timeout(function(){$scope.focusOnCodLocal();},200);
			} else if (that.model.currentLieu().local.typIdLieuGeo==2) {
				$timeout(function(){$scope.focusOnCodPostal();},200);
			}
		};
		
		$scope.etabAssist = {assistId: "autocomplete_etab", 
			nextTabOnTab: true,
			nextTabOnEnter: true,
			getAjaxData: function(query){
				if (query.match(/^[0-9]+$/) != null && query.length<5) return;
				if (query!=that.model.currentLieu().etab.noSelectedEtab) {
					if (angular.isDefined(that.model.currentLieu().etab.valEtab) && angular.isDefined(that.model.currentLieu().etab.valEtab.nomEtab)) {
						delete that.model.currentLieu().etab.valEtab.nomEtab;	// ça permet de savoir que nouveau - .d sera undefined si code non trouvé.
					}
					return { url:"/syra/etabl/search",
						data: { k: query, u:clientUid }};
				}
			},
			listWidth: 300,
			hasHeader: false, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
			selection: function(elem) {
				that.setCurrNoEtab(elem.c);
				$http({
					method : "GET",
					url : "/syra/etabl/get?c=" + elem.c +"&u=" + clientUid +"&d=1"
				}).then(function mySucces(response) {
					if (angular.isUndefined(response.data.length)) {
						var res = response.data;
						that.setCurrValEtab(response.data);	//un CEtab
		    			var elem = {};
		    			elem.c = res.noSelectedEtab;
						elem.d = res.valEtab.nomEtab+ " (" + res.valEtab.typEtab + '-' + res.valEtab.catgEtab +")";
		    			$scope.setSectionFromEtab(elem);
					}
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
				return elem.c;
			},
			suggestOnDataLoaded: function(data) {
				if(data.length === 1){
					this.select(data[0]);
					this.lockEntry();
					return false;
				}
				return true;
			}
		};
		
		$scope.setSectionFromEtab = function (elem) {
			if (elem.d.indexOf("ETAB-CH")>-1) {
				// donc dans établ. Prendre last number
				var last = elem.c.slice(-1);
				var lastNo;
				if ('7'==last) {	// urgence hop.
					lastNo = "35";
				} else if ('6'==last) {	// SI ou UC ou...
					lastNo = "16";	// pourrait être 15 aussi... pour UC
				} else if ('9'==last || '0'==last) {
					lastNo = "";
				} else {
					lastNo = '0' + last;
				}
				if (""!=lastNo) {
					$http({
						method : "GET",
						url : "/syra/secteur/get?c=" + lastNo +"&u=" + clientUid +"&d=1"
					}).then(function mySucces(response) {
						if (angular.isUndefined(response.data.length)) {
							that.setCurrSect(response.data);
							that.model.setCurrLieuSecC(response.data.noSectActiv);
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
				}
			}			
		};
		
		$scope.sectAssist = {assistId: "autocomplete_sect", 
			getAjaxData: function(query){
				if (angular.isDefined(that.model.currentLieu().etab.valSect.desSectActiv)) {
					if (query==that.model.currentLieu().etab.valSect.noSectActiv) return;
					delete that.model.currentLieu().etab.valSect.desSectActiv;
				}
				return { url:"/syra/secteur/search",
					data: { k: query, u: clientUid }};
			},
			listWidth: 230,
			hasHeader: false, hasDetails: false,
			getKey: function(elem) {return "<div class='divTable'><div class='divRow'><div class='divCellCol1' style='width:25px;'>" + elem.c + "</div><div class='divCellCol2'>" + elem.d + "</div></div></div>";},
			selection: function(elem) {
				$http({
					method : "GET",
					url : "/syra/secteur/get?c=" + elem.c +"&u=" + clientUid +"&d=1"
				}).then(function mySucces(response) {
					if (angular.isUndefined(response.data.length)) {
						that.setCurrSect(response.data);
					}
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
				return elem.c;
			},
			suggestOnDataLoaded: function(data) {
				if(data.length === 1){
					this.select(data[0]);
					this.lockEntry();
					return false;
				}
				return true;
			}
		};
		
		$scope.factLocalAssist = {assistId: "autocomplete_factLocal", 
			hasHeader: false, hasDetails: false,
			getAjaxData: function(query){
				if (query.match(/^[0-9]+$/) != null && query.length<5) return;
				if (query!=that.model.currentLieu().local.valCodLocal.codLocal) {
					if (angular.isDefined(that.model.currentLieu().local.valCodLocal.nomLocal)) {
						delete that.model.currentLieu().local.valCodLocal.nomLocal;
					}
					return { url:"/syra/local/search",
						data: { k: query, u: clientUid }};
				}
			},
			getKey: function(elem) {
				return elem.c + ": " + elem.d;
			},
			selection: function(elem) {
				$http({
					method : "GET",
					url : "/syra/local/get?c=" + elem.c +"&u=" + clientUid +"&d=1"
				}).then(function mySucces(response) {
					var res = response.data;
					if (angular.isUndefined(res.length)) {
						that.setCurrValLocal(res);
					}
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
				return elem.c;
			},
			suggestOnDataLoaded: function(data) {
				if(data.length === 1){
					this.select(data[0]);
					this.lockEntry();
					return false;
				}
				return true;
			}
		};
		
		this.isCodifie = function() {
			return that.model.currentLieu().typLocEtab == "C";
		};
		
		this.isNonCodifie = function() {
			return that.model.currentLieu().typLocEtab == "N";
		};
		
		this.setCurrNoEtab = function(no){
			that.model.setCurrLieuNoSelectedEtab(no, true);
		};
		
		/**
		 * ds index.htm, quand on clique le X
		 */
		this.setCurrValEtab = function(etab){
			that.model.setCurrLieuValEtab(etab, true);
			// currEtab deja setté du cote serveur quand on a fait la sélection dans la liste.
			// il faut juste savoir si on efface la valeur - PS on n'efface pas ces valeurs. Ne sont pas utilisées si non-codifié
			if (Object.keys(etab).length === 0) {
				that.setCurrNoEtab("");
				$http({
					method : "POST",
					url : "/syra/etabl/post",
					data:  JSON.stringify({u:clientUid, o: {}}),
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
			}
		};
				
		that.setCurrSect = function(s){
			that.model.setCurrLieuValSect(s, true);
		};
		
		/**
		 * ds index.htm, quand on clique le X
		 */
		that.setCurrValLocal = function(s){
			that.model.setCurrLieuValCodLocal(s, true);
			// currLocal deja setté du cote serveur quand on a fait la sélection dans la liste.
//			 il faut juste savoir si on efface la valeur
			if (Object.keys(s).length === 0) {
				$http({
					method : "POST",
					url : "/syra/local/post",
					data:  JSON.stringify({u:clientUid, o: {}}),
					headers: {'Content-Type': 'application/json; charset=utf-8'}
				}).then(function mySucces(response) {
				}, function myError(response) {
					$scope.myWelcome = response.statusText;
				});
			}
		};

		this.editEtab = function(etab){
			if(etab != null && etab != undefined){
				this.newEtab = etab;
			}
		};
		
	}]);
	
	app.factory('Codifies', function(){
		var types = [
         {'id': 'C', 'label': 'Physique'},
         {'id': 'N', 'label': 'Géographique'}
        ];
		return {
			list : function(){
				return types;
				}
		};
	});
		
})();