(function(){
	var dateDefaut = angular.module("dateDefaut", ['cfp.hotkeys']);
	
	dateDefaut.controller('DateDefautController', ['$scope', '$http', 'hotkeys', 'clientUid','model', '$timeout',
	                                               function($scope, $http, hotkeys, clientUid, model, $timeout){
		var that = this;
		this.model = model;
		this.advised = false;
		var dateDefaut = new DynaDate({elem:"datDefaut", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: true});
		
		that.jourFeries = {				
				1:"Jour de l'an",
				2:"Lendemain du jour de l'an",
				3:"Vendredi saint",
				4:"Lundi de Pâques",
				5:"Fête de Dollard et de la Reine",
				6:"Fête Nationnale",
				7:"Fête du Canada",
				8:"Fête du travail",
				9:"Fête de l'action de grâce",
				10:"Veille de Noel",
				11:"Noel",
				12:"Lendemain de Noel",
				13:"Veille du jour de l'an.",
				100:"Samedi",
				200:"Dimanche"
		};
		
		$scope.def = {
				date_defaut: function(newVal) {
					if (arguments.length) {
						var dateString = new moment(newVal).format('YYYY-MM-DD');
						that.model.setCurrDefaultValues(CONFIG.DATE_DEFAULT, dateString);
						that.model.saveCurrDefaultValues(CONFIG.DATE_DEFAULT, dateString);					
						return;
					}
					return that.model.currentDefault()[CONFIG.DATE_DEFAULT];
				}
		};
//		$scope.model = model;
//		$scope.$watch("model.currentDefault()['dateDefault']",
//	      function(newVal) {
//			DateDefautService.setOnlyDateParDefaut(that.model.currentDefault()['dateDefault']);
//	    });
		
		hotkeys.add({
			combo: 'alt+t',
			description: "Aujourd'hui",
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.ResetDef();
			}
		});
		hotkeys.add({
			combo: 'alt+z',
			description: 'Date défaut moins 1 jour',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.MinusOne('day');
			}
		});
		hotkeys.add({
			combo: 'alt+x',
			description: 'Date défaut plus 1 jour',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.PlusOne('day');
			}
		});

		hotkeys.add({
			combo: 'alt+a',
			description: 'Date défaut moins 1 semaine',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.MinusOne('week');
			}
		});
		hotkeys.add({
			combo: 'alt+s',
			description: 'Date défaut plus 1 semaine',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.PlusOne('week');
			}
		});
		
		hotkeys.add({
			combo: 'alt+q',
			description: 'Date défaut moins 1 mois',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.MinusOne('month');
			}
		});
		hotkeys.add({
			combo: 'alt+w',
			description: 'Date défaut plus 1 mois',
			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
			callback: function(event, hotkey) {
				event.preventDefault();
				that.PlusOne('month');
			}
		});
		
		// question de consistance (retrait de h), je retire ce hotkey
//		hotkeys.add({
//			combo: 'alt+m',
//			description: 'Date défaut début du mois',
//			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
//			callback: function(event, hotkey) {
//				event.preventDefault();
//				that.debutMois('month');
//			}
//		});
//		
		// j'en ai besoin pour afficher l'historique - sera plus utile pour que la fin du mois
//		hotkeys.add({
//			combo: 'alt+h',
//			description: 'Date défaut fin du mois',
//			allowIn: ['INPUT', 'SELECT', 'TEXTAREA'],
//			callback: function(event, hotkey) {
//				event.preventDefault();
//				that.finMois('month');
//			}
//		});
		
		var dateAssist = new DynaDate({elem:"defautDate", format: 'YYYY-MM-DD', locale:'fr', acceptFutureDate:false, useCurrent: false});
		dateAssist.onDateSelected = function(selectedDate){
			showJourFerie(that.model.currentLieu(), selectedDate, dateAssist.baseElement);
		}
		function showJourFerie(l, d, o) {
			var type = that.model.isJourFerie(l, d);
			if (type>0) {
				o.addClass("date-ferie");
				o.attr('title',that.jourFeries[type]);		
			} else {
				o.removeClass("date-ferie");				
				o.attr('title',"");		
			}
		}
		
		this.PlusOne = function(t){
			var dateDef = that.model.currentDefault()['dateDefault'];
			if(angular.isDefined(dateDef)){
				var today = moment();
				var newDate = moment(dateDef).add('1', t);
				if (newDate.diff(today)>0){
					that.setDateDefaut(new Date());
					if(!this.advised){
						new jBox('Notice', {
							color : 'yellow',
							content: 'La date par défaut ne peut pas être dans le futur.',
							attributes: {
								x: 'right',
								y: 'bottom'
							}
						});
						this.advised = true;
						setTimeout(function(){ that.advised = false; }, 2500);
					}
				}else{
					that.setDateDefaut(newDate.toDate());
				}
			}
			return true;
		};
		
		this.ResetDef = function(){
			that.setDateDefaut(new Date());
			return true;
		};

		this.MinusOne = function(t){
			var dateDef = that.model.currentDefault()['dateDefault'];
			if(angular.isDefined(dateDef)){
				var newDate = moment(dateDef).subtract('1', t);
				that.setDateDefaut(newDate.toDate());
			}
			return true;
		};

		this.debutMois = function(t){
			var dateDef = that.model.currentDefault()['dateDefault'];
			if(angular.isDefined(dateDef)){
				var newDate = moment(dateDef).startOf(t);
				that.setDateDefaut(newDate.toDate());
			}
			return true;
		};
		
		this.finMois = function(t){
			var dateDef = that.model.currentDefault()['dateDefault'];
			if(angular.isDefined(dateDef)){
				var today = moment();
				var newDate = moment(dateDef).endOf(t);
				if (newDate.diff(today)>0){
					that.setDateDefaut(new Date());
					if(!this.advised){
						new jBox('Notice', {
							color : 'yellow',
							content: 'La date par défaut ne peut pas être dans le futur.',
							attributes: {
								x: 'right',
								y: 'bottom'
							}
						});
						this.advised = true;
						setTimeout(function(){ that.advised = false; }, 2500);
					}
				}else{
					that.setDateDefaut(newDate.toDate());
				}
			}
			return true;
		};
		
		
		this.setDateDefaut = function(newDate) {
			if(angular.isDefined(newDate)){
				$timeout(function() {
					$scope.def.date_defaut(newDate);					
				}, 10);
			}
		};
	}]);
})();