(function(){
	var app = angular.module("concil", ['ui.grid','ui.grid.resizeColumns','ui.grid.grouping', 'ui.grid.infiniteScroll','ngTouch','widget', 'ngSanitize']);
			
	app.controller('ConcilController', ['$scope', '$http', '$filter', 'uiGridConstants', 'uiGridGroupingConstants', 'clientUid','model','$uibModal', '$sanitize', '$timeout',
	                           function ($scope, $http, $filter, uiGridConstants, uiGridGroupingConstants, clientUid, model, $uibModal, $sanitize, $timeout) {		
		this.dataLoading = false;
		this.clientUid = clientUid;
		this.dataLoadingInGrid = false;
		var that = this;
		that.model = model;
		$scope.model = model;
		$scope.hasUpdateFichierStatus = {};
		$scope.fichDejaObtenu = {};
		var fichNewObtenu = {};
		
		$scope.def = {
				force_update_mnt_paye: function(newVal) {
					if (arguments.length) {
						that.model.setCurrDefaultValues('force_update_mnt_paye', newVal);
						that.model.saveCurrDefaultValues('force_update_mnt_paye');
						return;
					}
					return that.model.currentDefault()['force_update_mnt_paye'];
				}
		};
		
		$scope.fichObtenuNew = {
				dateFile: function(v) {
					if (arguments.length) {
						$scope.fichDejaObtenu.dateFile = "";
						$scope.dataLoading=1;
						fichNewObtenu.dateFile = v.dateFile;	// manque les HMS au nom du fichier...
						// quand on demande les fichiers du menu déroulant, ça signifie qu'il s'Agit de nouvelles données. Toujours forcer update mnt pay.
						$http({
							method : "GET",
							url : "/syra/fich_expl/get?c=" + v.dateFile.replace(/-/g,'') +"&u=" + clientUid + "&f=1"
						}).then(function mySucces(response) {
							if (angular.isDefined(response.statusText)) {
								if (200===response.status) {// équivalent à 'OK'
									var status = response.data;
									if ('ERROR'===status.severity) {
										$scope.hasUpdateFichierStatus.message = status.message;
										$scope.dataLoading=0;
									} else if ('OK'==status.severity && status.data) {
										setProfExplPaimt(status.data);
									} else {
										$scope.hasUpdateFichierStatus.message = "Aucune donnée retournée. Problème de fichier?";
										$scope.dataLoading=0;
									}
								} else {
									$scope.hasUpdateFichierStatus.message = response.statusText;
									$scope.dataLoading=0;
								}
							}
						}, function myError(response) {
							$scope.myWelcome = response.statusText;
						});
					}
					return fichNewObtenu;
				}
		};
		
		$scope.factExplPaimt = {};
        $scope.factExplPaimt.noTrnsm=that.model.currentGlobalDefault()['syra_noAgence'];
        $scope.factExplPaimt.datCoupPer=' ';
        $scope.factExplPaimt.datEtatCpt=' ';
        $scope.factExplPaimt.ddPerFact=' ';
        $scope.factExplPaimt.dfPerFact=' ';
        $scope.factExplPaimt.currentLine={};
		
		$scope.explPmts = [];
		$scope.allNoRq = [];
		
		$scope.demanderExplPmt = function() {
			that.model.fichObtenusNew([]);
			$scope.fichDejaObtenu.dateFile = "";
			$scope.dataLoading=1;
			$http({
				method : "GET",
				url : "/syra/fich_expl_new/get?u=" + clientUid + "&f=" + (that.model.currentDefault()['force_update_mnt_paye'] ?'1':'0')
			}).then(function mySucces(response) {
				if (angular.isDefined(response.statusText)) {
					if (200===response.status) {// équivalent à 'OK'
						var status = response.data;
						if ('ERROR'===status.severity) {
							$scope.hasUpdateFichierStatus.message = status.message;
							$scope.dataLoading=0;
						} else if ('OK'==status.severity && status.data) {
							var files = status.data[3];	// 0=données de base, 1=liste des fact., 2=facture loadée, 3=fichiers dispo
							for(var f=0;f<files.length;f++) {
								var elem = {'dateFile': files[f].substr(0,4) + '-' + files[f].substr(4,2) + '-'  + files[f].substr(6,2)};
								that.model.fichObtenusNew().push(elem);
								if (files[f]===status.data[2]) {
									fichNewObtenu.dateFile = elem.dateFile;
								}
							}
							setProfExplPaimt(status.data);
						} else {
							$scope.hasUpdateFichierStatus.message = "Aucune donnée retournée.";
							$scope.dataLoading=0;
						}
					} else {
						$scope.hasUpdateFichierStatus.message = response.statusText;
						$scope.dataLoading=0;
					}
				}
			}, function myError(response) {
				$scope.myWelcome = response.statusText;
			});
		};
		
		$scope.consulterFact = function() {
			// that.model.noRfpsFromConcil([10000801083,10000801893,10000808294,10000808278]);
			that.model.noRfpsFromConcil($scope.allNoRq);
		};
		
		$scope.selectFichier = function() {
			$scope.dataLoading=3;
		};
		
		$scope.fichDejaObtenuAssist = {assistId: "autocomplete_fichDejaObtenu", 
				getAjaxData: function(query){
					if (angular.isDefined($scope.fichDejaObtenu.name)) {
						delete $scope.fichDejaObtenu.name;
					}
					return { url:"/syra/fich_expl/search",
						data: { k: query, u: clientUid }};
				},
				listWidth: 150,
				hasHeader: false, hasDetails: false,
				getKey: function(elem) {
					if (angular.isDefined(elem) && elem!=null && elem.length>8) {
						var data = elem.substr(0,4) + '-' + elem.substr(4,2) + '-'  + elem.substr(6,2);
						return "<div class='divTable'><div class='divRow'><div class='divCellCol2' style='padding:0.5em;'>" + data + "</div></div></div>";
					}
					return null;
				},
				selection: function(elem) {
					fichNewObtenu = {};
					$scope.dataLoading=1;
					$http({
						method : "GET",
						url : "/syra/fich_expl/get?c=" + elem +"&u=" + clientUid + "&f=" + (that.model.currentDefault()['force_update_mnt_paye'] ?'1':'0')
					}).then(function mySucces(response) {
						if (angular.isDefined(response.status)) {
							if (200===response.status) {// équivalent à 'OK'
								var status = response.data;
								if ('ERROR'===status.severity) {
									$scope.hasUpdateFichierStatus.message = status.message;
									$scope.dataLoading=0;
								} else if ('OK'==status.severity && status.data) {
									$scope.fichDejaObtenu.dateFile = elem.substr(0,4) + '-' + elem.substr(4,2) + '-'  + elem.substr(6,2);
									// l'objet dans response.data.data
									setProfExplPaimt(status.data);
								} else {
									$scope.hasUpdateFichierStatus.message = "Aucune donnée retournée. Problème de fichier?";
									$scope.dataLoading=0;
								}
							} else {
								$scope.hasUpdateFichierStatus.message = response.statusText;
								$scope.dataLoading=0;
							}
						}
					}, function myError(response) {
						$scope.myWelcome = response.statusText;
					});
					return $scope.fichDejaObtenu.typeprof;
				}
		};
		
		function setProfExplPaimt(data) {
			var baseData = data[0];
			var explMmt = data[1];
	        $scope.factExplPaimt.datCoupPer=baseData.datCoupPer;
	        $scope.factExplPaimt.datEtatCpt=baseData.datEtatCpt;
	        $scope.factExplPaimt.ddPerFact=baseData.ddPerFact;
	        $scope.factExplPaimt.dfPerFact=baseData.dfPerFact;
			
	        $scope.explPmts = [];
	        $scope.allNoRq = [];
			for (var j=0;j<explMmt.length;j++) {
				var p = explMmt[j];
				for (var k=0;k<p.f.length;k++) {
					var f = p.f[k];
					$scope.allNoRq.push(f.noRq);
					for (var l in f.mapLine) {
						var line = f.mapLine[l]
						var d = {};
						d.np = p.no;
						d.grp = p.grp;
						d.nq = f.noRq;
						d.l = line.no;
						d.ds = line.ds;
						d.dp = line.dp;
						d.mnt = line.mnt;
						d.ex = line.expl.replace(/\n/g, '<br>');
						$scope.explPmts.push(d);
					}
				}
			}
			
			$scope.gridOptions.data = $scope.explPmts;
			$scope.gridApi.grid.modifyRows($scope.gridOptions.data);
			that.dataLoadingInGrid = true;
			$scope.gridApi.core.on.rowsRendered($scope, function() {
				if (that.dataLoadingInGrid) {
					var tree = $scope.gridApi.grid.treeBase.tree;
					for (var i = tree.length-1; i >= 0; i--) {
						$scope.gridApi.treeBase.expandRow(tree[i].row);
						var tree2 = tree[i].children;
						for (var j = tree2.length-1; j >= 0; j--) {
							$scope.gridApi.treeBase.expandRow(tree2[j].row);
						}
					}
					that.dataLoadingInGrid = false;
					$scope.dataLoading=0;
				}
			});
			// quand on clique une ligne, on affiche dans le bas l'expl du pmt.			
		}
		
		var filterWithNot = {
		          condition: function(searchTerm, cellValue) {
		        	  var st = searchTerm.trim().replace(/\\/g, '').toUpperCase();
		        	  if (st.startsWith('!')) {
		        		  var nst = st.substr(1);
		        		  if (nst.length==0) return true;
	        			  return cellValue.toUpperCase().indexOf(nst)===-1;	        			  
		        	  } else {
		        		  return cellValue.toUpperCase().indexOf(st)!==-1;
		        	  }
		        	  return false;
		          }
			};
		
		$scope.gridOptions = { data: $scope.explPmts,
				virtualizationThreshold:myAppGrid.vthresh,	// defaut 20
				scrollThreshold:myAppGrid.scrollt,
				wheelScrollThrottle:myAppGrid.wheelst,
				excessRows:myAppGrid.exRows,
				infiniteScrollRowsFromEnd:20,
			    infiniteScrollUp: true,
			    infiniteScrollDown: true,
				enableColumnResizing: false,
				enableFiltering: false,
				enableSorting: false,
				saveScroll: false,
				enableHiding: false,
				enableGridMenu: true,
				exporterMenuCsv: false,
				exporterCsvFilename: function(){ return "fact_somm.csv";},
			    exporterPdfDefaultStyle: {fontSize: 9},
			    exporterPdfTableStyle: {margin: [0,0,0,0]},
			    exporterPdfTableHeaderStyle: {fontSize: 10, bold: true, italics: true, color: 'blue'},
			    exporterPdfHeader: function () { return {text: "Explication des paiements - " + $scope.factExplPaimt.datEtatCpt, style: 'headerStyle' };},
			    exporterPdfFooter: function ( currentPage, pageCount ) {
			      return { text: currentPage.toString() + ' de ' + pageCount.toString(), style: 'footerStyle' };
			    },
			    exporterPdfCustomFormatter: function ( docDefinition ) {
			      docDefinition.styles.headerStyle = { fontSize: 16, bold: true };
			      docDefinition.styles.footerStyle = { fontSize: 10, bold: true };
			      return docDefinition;
			    },
			    exporterPdfOrientation: 'portrait',
			    exporterPdfPageSize: 'LETTER',
			    exporterPdfMaxGridWidth:480,
			    treeRowHeaderAlwaysVisible: false,
			    enableGroupHeaderSelection: false,
			    enableFullRowSelection:true,
			    multiSelect:false,
			    onPdfExport:function(doc, binarydoc){ 
					$scope.inscriptionOpened = true;
					that.dataLoading = false;
					$scope.modalInstance = $uibModal.open({
						animation: $scope.animationsEnabled,
						templateUrl: "/syra/Resources/views/modal.html",
						controller: 'ModalInstanceCtrl',
						size: "lg",
						resolve: {
							mObject: function () {
								return {
									title: "Explication des paiements - " + $scope.factExplPaimt.datEtatCpt,
									templateUrl:"/syra/Resources/views/pdfviewer.html",
									doc: binarydoc
								};
							}
						}
					});

					$scope.modalInstance.result.then(function () {
						$scope.inscriptionOpened = false;
			        }, function () {
			            $scope.inscriptionOpened = false;
			        });
				},
				appScopeProvider: that,
				columnDefs: [
					{field: 'np', displayName: 'Prof.',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 0 }, sort: { priority: 0, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Numéro du professionnel qui a rendu le service";}, width: '14%', enableHiding: true, cellTooltip: false},
					{field: 'grp', displayName: 'Grp',filter: _.cloneDeep(filterWithNot), grouping: { groupPriority: 1 }, sort: { priority: 1, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Numéro du groupe administratif";}, width: "12%", enableHiding: true, cellTooltip: false},
					{field: 'nq', displayName: 'No RQ', grouping: { groupPriority: 2 }, sort: { priority: 2, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Numéro de la facture de la RAMQ";}, width: "16%", enableHiding: true, cellTooltip: false},
					{field: 'l', displayName: 'L', type:'number', sort: { priority: 3, direction: 'asc' }, treeAggregationType: uiGridGroupingConstants.aggregation.COUNT, headerTooltip: function(col) {return "Ligne de la facture";}, width: "15%", enableHiding: true, cellTooltip: false},
					{field: 'ds', displayName: 'Date serv.',filter: _.cloneDeep(filterWithNot), enableSorting:false, width: "11%", enableHiding: true, cellTooltip: false},
					{field: 'dp', displayName: 'Date pmt',filter: _.cloneDeep(filterWithNot), enableSorting:false, width: "11%", enableHiding: true, cellTooltip: false},
					{field: 'mnt', displayName: 'Mnt pmt', enableSorting:false, aggregationType: uiGridConstants.aggregationTypes.sum, treeAggregationType: uiGridGroupingConstants.aggregation.SUM, customTreeAggregationFinalizerFn: function( aggregation ) {
						aggregation.rendered = aggregation.value;
					}, exporterPdfAlign: 'right', cellFilter: 'currency', width: "13%"}
			 ],
             exporterFieldCallback: function( grid, row, col, input ) {
           	  if (col.cellFilter!=undefined && col.cellFilter.length !=0) {
           	    var filters = col.cellFilter.split('|');
           	    for(i=0; i<filters.length;i++) {
           	      var pars=filters[i].match(/[^\:"']+|'([^']*)'|'([^']*)'+/g);
           	      var filterName=pars[0].trim();
           	      var filterPar = null;
           	      if (pars.length==2) {
//           	    	  filterPar = pars[1].slice(1, -1);
           	        filterPar = eval(pars[1]);
           	        input = $filter(filterName)( input,filterPar);
           	      } else {
           	        input = $filter(filterName)( input );
           	      }
           	    }
           	  }
           	  return input;
            },
			 onRegisterApi: function(gridApi){
				$scope.gridApi = gridApi;
		        gridApi.grid.registerDataChangeCallback(function(data) {
//		        	$scope.servElmCxGridApi.selection.selectRow($scope.activeElmCx);
		        }, [uiGridConstants.dataChange.ROW]);
		        gridApi.selection.on.rowSelectionChanged($scope,function(row){
		        	$scope.factExplPaimt.currentLine = row.isSelected ? row.entity : {};
		        });
			}
		};
		
		$scope.$watch(
			function (scope) {
                return scope.model.fichExplPaimtNew().val;
            },
            function(newVal, oldVal, scope) {
            	// analyser la nouvelle valeur de model.currentFichExplPaimt().
            	// structure : error, String[] date des etats de comptes retournés. active_fich_expl = [] des lignes pour charger les données dans le ui grid
	    });

		var iframeHeight = window.innerHeight;
		
		$timeout(function() {$scope.gridStyle= {height: (Math.max(iframeHeight-500,175)) + 'px'}}, 1);
				
	}]);
})();