/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.dossier.lib.LibPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;

public abstract class Validateur {
    public static final String separator = System.getProperty("file.separator");
    public static final boolean onMac = System.getProperty("os.name").toLowerCase().indexOf("mac") > -1;
    public static final boolean onWin = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
    public static final boolean onLin = System.getProperty("os.name").toLowerCase().indexOf("linux") > -1;
    public static String USER_HOME = String.valueOf(System.getProperty("user.home")) + separator;
    public static String HOME_OF_MEDO = LibPlugin.MEDOFFICE_HOME;
    public static int ACTUAL_LANGUE;
    protected Properties propServeur;
    protected Properties propLocal;
    protected String pathValidFromServer = USER_HOME;
    protected static boolean internetOk;

    static {
        internetOk = true;
    }

    public abstract int doIt();

    protected boolean getNeedsToUpdate(Properties server, Properties local) {
        if (local == null) {
            return true;
        }
        ArrayList<Object> keys = Collections.list(server.keys());
        for (Object e : keys) {
            String dateServer = server.getProperty((String)e);
            if (dateServer == null) {
                return false;
            }
            dateServer = dateServer.trim();
            String dateLocal = local.getProperty((String)e);
            if (dateLocal == null) {
                return true;
            }
            dateLocal = dateLocal.trim();
            if (!(LibPlugin.isInfodata ? dateServer.compareTo(dateLocal) != 0 : dateServer.compareTo(dateLocal) > 0)) continue;
            return true;
        }
        return false;
    }

    protected static Properties getPropertiesFromFile(File f) {
        Properties prop = new Properties();
        if (f.exists()) {
            try {
                FileInputStream fin = new FileInputStream(f);
                prop.load(fin);
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return prop;
    }

    protected static Properties getVersionPropertiesFromServer(String filepath, URL urlFileVersion) {
        boolean ok = false;
        Properties serverProp = new Properties();
        try {
            ok = Validateur.getFileFromServer(urlFileVersion, filepath);
            File versionLocalTxt = new File(filepath);
            if (internetOk && ok && versionLocalTxt.exists()) {
                System.out.println(urlFileVersion + " : " + versionLocalTxt.getAbsolutePath());
                FileInputStream fin = new FileInputStream(versionLocalTxt);
                serverProp.load(fin);
                fin.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return serverProp;
    }

    protected static Properties getfavModelFromServer(URL urlFileVersion) {
        Properties serverProp = new Properties();
        try {
            String r = Validateur.getFileFromServer(urlFileVersion);
            serverProp.load(new StringReader(r));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return serverProp;
    }

    public static void copyVersionFileToMedo(File versionLocalFromServeur, File versionFileLocal) {
        if (versionFileLocal.exists()) {
            versionFileLocal.delete();
        }
        if (versionLocalFromServeur.exists()) {
            Validateur.copyFile(versionLocalFromServeur, versionFileLocal);
        }
    }

    protected static boolean getFileFromServer(URL url, String dstPath) {
        boolean ok = false;
        internetOk = true;
        byte[] buffer = new byte[16384];
        InputStream in = null;
        try {
            in = (InputStream)url.getContent();
        }
        catch (IOException e1) {
            internetOk = false;
        }
        if (in != null) {
            try {
                int count;
                FileOutputStream out = new FileOutputStream(dstPath);
                while ((count = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, count);
                }
                in.close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File dest = new File(dstPath);
            ok = dest.exists();
        }
        return ok;
    }

    protected static String getFileFromServer(URL url) {
        String rep = null;
        InputStream in = null;
        try {
            URLConnection connection = url.openConnection();
            in = connection.getInputStream();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (in != null) {
            try {
                int nread;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[8192];
                while ((nread = in.read(buf, 0, buf.length)) > 0) {
                    baos.write(buf, 0, nread);
                }
                in.close();
                baos.close();
                byte[] bytes = baos.toByteArray();
                rep = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rep;
    }

    private static InArrayFile isInTheArray(String s, String[] a) {
        InArrayFile inArrayResp = new InArrayFile();
        inArrayResp.setRep(false);
        inArrayResp.setS("_____");
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                if (s.toLowerCase().startsWith(a[i].toLowerCase())) {
                    inArrayResp.setRep(true);
                    inArrayResp.setS(a[i].toLowerCase());
                    break;
                }
                ++i;
            }
        }
        return inArrayResp;
    }

    private static void copyFile(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static boolean deleteDirectory(File path, String[] filesToExclude) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    InArrayFile in;
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        in = Validateur.isInTheArray(file.getName(), filesToExclude);
                        if (filesToExclude == null || !in.isRep()) {
                            Validateur.deleteDirectory(file, filesToExclude);
                        }
                    } else {
                        in = Validateur.isInTheArray(file.getName(), filesToExclude);
                        if (filesToExclude == null || !in.isRep()) {
                            file.delete();
                        }
                    }
                    ++n2;
                }
            }
            result = path.delete();
        }
        return result;
    }

    public static void copyFiles(String strPath, String dstPath) throws IOException {
        File src = new File(strPath);
        File dest = new File(dstPath);
        if (dest.exists()) {
            dest.delete();
        }
        if (src.isDirectory()) {
            String[] list;
            dest.mkdirs();
            String[] stringArray = list = src.list();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (!element.startsWith(".")) {
                    String dest1 = String.valueOf(dest.getAbsolutePath()) + "\\" + element;
                    String src1 = String.valueOf(src.getAbsolutePath()) + "\\" + element;
                    Validateur.copyFiles(src1, dest1);
                }
                ++n2;
            }
        } else {
            Validateur.copy(src, dest);
        }
    }

    public static void copy(File source, File target) throws IOException {
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        targetChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        sourceChannel.close();
        targetChannel.close();
    }

    protected static String strTran(String ps, String o, String n) {
        String s = ps;
        int i = s.indexOf(o);
        int h = -1;
        while (i > -1 && i != h) {
            h = i;
            s = String.valueOf(s.substring(0, i)) + n + s.substring(i + o.length());
            i = s.indexOf(o);
        }
        return s;
    }

    public static class InArrayFile {
        boolean rep = false;
        String s = "";

        public final boolean isRep() {
            return this.rep;
        }

        public final void setRep(boolean rep) {
            this.rep = rep;
        }

        public final String getS() {
            return this.s;
        }

        public final void setS(String s) {
            this.s = s;
        }
    }
}

