/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import java.lang.reflect.Array;

public final class ModelUtil {
    public static final int HASH_SEED = 23;
    private static final int fODD_PRIME_NUMBER = 37;

    public static final int hashCodeFor(Object ... aFields) {
        int result = 23;
        Object[] objectArray = aFields;
        int n = aFields.length;
        int n2 = 0;
        while (n2 < n) {
            Object field = objectArray[n2];
            result = ModelUtil.hash(result, field);
            ++n2;
        }
        return result;
    }

    public static int hash(int aSeed, boolean aBoolean) {
        return ModelUtil.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return ModelUtil.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return ModelUtil.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return ModelUtil.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return ModelUtil.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return ModelUtil.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = ModelUtil.hash(result, 0);
        } else if (!ModelUtil.isArray(aObject)) {
            result = ModelUtil.hash(result, aObject.hashCode());
        } else {
            int length = Array.getLength(aObject);
            int idx = 0;
            while (idx < length) {
                Object item = Array.get(aObject, idx);
                result = ModelUtil.hash(result, item);
                ++idx;
            }
        }
        return result;
    }

    public static Boolean quickEquals(Object aThis, Object aThat) {
        Boolean result = null;
        if (aThis == aThat) {
            result = Boolean.TRUE;
        } else {
            Class<?> thisClass = aThis.getClass();
            if (!thisClass.isInstance(aThat)) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    public static boolean equalsFor(Object[] aThisSignificantFields, Object[] aThatSignificantFields) {
        if (aThisSignificantFields.length != aThatSignificantFields.length) {
            throw new IllegalArgumentException("Array lengths do not match. 'This' length is " + aThisSignificantFields.length + ", while 'That' length is " + aThatSignificantFields.length + ".");
        }
        boolean result = true;
        int idx = 0;
        while (idx < aThisSignificantFields.length) {
            if (!ModelUtil.areEqual(aThisSignificantFields[idx], aThatSignificantFields[idx])) {
                result = false;
                break;
            }
            ++idx;
        }
        return result;
    }

    public static boolean areEqual(boolean aThis, boolean aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(char aThis, char aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(long aThis, long aThat) {
        return aThis == aThat;
    }

    public static boolean areEqual(float aThis, float aThat) {
        return Float.floatToIntBits(aThis) == Float.floatToIntBits(aThat);
    }

    public static boolean areEqual(double aThis, double aThat) {
        return Double.doubleToLongBits(aThis) == Double.doubleToLongBits(aThat);
    }

    public static boolean areEqual(Object aThis, Object aThat) {
        if (aThis == aThat) {
            return true;
        }
        if (aThis == null || aThat == null) {
            return aThis == null && aThat == null;
        }
        boolean result = false;
        if (!ModelUtil.isArray(aThis)) {
            result = aThis.equals(aThat);
        } else {
            int length = Array.getLength(aThis);
            int idx = 0;
            while (idx < length) {
                Object thisItem = Array.get(aThis, idx);
                Object thatItem = Array.get(aThat, idx);
                result = ModelUtil.areEqual(thisItem, thatItem);
                ++idx;
            }
        }
        return result;
    }

    public static <T extends Comparable<T>> int comparePossiblyNull(T aThis, T aThat, NullsGo aNullsGo) {
        int EQUAL = 0;
        int BEFORE = -1;
        int AFTER = 1;
        int result = EQUAL;
        if (aThis != null && aThat != null) {
            result = aThis.compareTo(aThat);
        } else {
            if (aThis != null || aThat != null) {
                if (aThis == null && aThat != null) {
                    result = BEFORE;
                } else if (aThis != null && aThat == null) {
                    result = AFTER;
                }
            }
            if (NullsGo.LAST == aNullsGo) {
                result *= -1;
            }
        }
        return result;
    }

    private ModelUtil() {
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject != null && aObject.getClass().isArray();
    }

    public static enum NullsGo {
        FIRST,
        LAST;

    }
}

