/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.util;

import ca.infodata.syra.util.Helper;
import java.util.ArrayList;
import java.util.Collection;

public class JoinList {
    private final ArrayList<String> list;
    private final String sep;
    private int sizeHint;
    private boolean noDuplicate = false;
    private boolean trim;
    private boolean addAll = true;

    public JoinList(String sep, Collection<?> c) {
        this(sep, c == null ? 0 : c.size());
        if (c != null) {
            for (Object e : c) {
                this.genericAdd(e);
            }
        }
    }

    public JoinList(String sep, Object ... items) {
        this(sep, items.length);
        this.addArray(items);
    }

    public JoinList(String sep) {
        if (sep == null) {
            throw new NullPointerException("sep");
        }
        this.sep = sep;
        this.list = new ArrayList();
        this.sizeHint = -1;
    }

    public JoinList(String sep, int size) {
        if (sep == null) {
            throw new NullPointerException("sep");
        }
        this.sep = sep;
        this.list = new ArrayList(size);
        this.sizeHint = -1;
    }

    public JoinList setNoDuplicate(boolean b) {
        this.noDuplicate = b;
        return this;
    }

    public JoinList setAddAll(boolean addAll) {
        this.addAll = addAll;
        return this;
    }

    public JoinList setTrim(boolean b) {
        this.trim = b;
        return this;
    }

    private boolean evaluate(String s) {
        if (!this.addAll && Helper.isBlank(s)) {
            return false;
        }
        return !this.noDuplicate || !this.list.contains(s);
    }

    public JoinList addUpperCase(String s) {
        if (s != null) {
            this.add(s.toUpperCase());
        }
        return this;
    }

    public JoinList add(String prefix, String s) {
        if (this.evaluate(s)) {
            this.internAdd(String.valueOf(prefix) + s);
        }
        return this;
    }

    public JoinList add(String s) {
        if (this.evaluate(s)) {
            this.internAdd(s);
        }
        return this;
    }

    public JoinList add(Class<?> c) {
        if (c != null) {
            return this.add(c.getSimpleName());
        }
        return this;
    }

    public JoinList addArray(Object ... items) {
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.genericAdd(object);
            ++n2;
        }
        return this;
    }

    private void genericAdd(Object object) {
        if (object instanceof String) {
            this.add((String)object);
        } else if (object instanceof Class) {
            this.add((Class)object);
        } else {
            this.add(object == null ? null : object.toString());
        }
    }

    private boolean internAdd(String s) {
        this.sizeHint = -1;
        if (this.trim) {
            this.list.add(s.trim());
        } else {
            this.list.add(s);
        }
        return true;
    }

    public String toString() {
        this.computeSizeHint();
        return Helper.join(this.list, this.sep);
    }

    private void computeSizeHint() {
        if (this.sizeHint == -1) {
            this.sizeHint = this.sep.length() * this.list.size();
            if (this.sizeHint != 0) {
                --this.sizeHint;
            }
            for (String s : this.list) {
                this.sizeHint += s == null ? 0 : s.length();
            }
        }
    }
}

