/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.handlers.PrefixFileLogHandler;
import ca.infodata.syra.services.ObtenirFichValidCriteria;
import ca.infodata.syra.services.ObtenirFichValidResult;
import ca.infodata.syra.services.ObtenirFichValidService;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.JoinList;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.OptimizeAll;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.Commands;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObtenirFichValidServiceTest {
    private ObtenirFichValidService service;
    private final String dbname = "ramq_valid";
    public static String stopWords = "stop_words.fr";
    private final Context context = new Context();

    public void deleteDatabase() {
        this.deleteDb("ramq_valid");
    }

    public void test() throws Exception {
        if (this.dbOpen("ramq_valid")) {
            this.testRequests(1, "doul abdo");
        }
    }

    @Test
    public void testObtenir() throws Exception {
        String noInterv = "16147";
        String userId = "AGR16147";
        String userPswd = "Ramq1234a";
        this.service = new ObtenirFichValidService(PrefixFileLogHandler.create("/Users/pdrolet/Desktop/DSQTEST", "ObtenirFichValid", true), null);
        ObtenirFichValidResult result = this.obtenir(userId, userPswd, noInterv);
        System.out.println("Version des fichiers:" + result.getVersion() + "\nNom du fichier:" + result.getNomFichier());
        if (result.getFiles().size() > 0) {
            for (String f : result.getFiles()) {
                System.out.println(f);
            }
            if (this.deleteDb("ramq_valid") && !this.dbOpen("ramq_valid")) {
                this.createDb("ramq_valid", result.getFiles());
            }
            this.testRequests(0, null);
        }
    }

    private boolean deleteDb(String dbname2) {
        try {
            new DropDB(dbname2).execute(this.context);
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    private ObtenirFichValidResult obtenir(String userId, String uPswd, String noInterv) {
        ObtenirFichValidCriteria criteria = new ObtenirFichValidCriteria(userId, uPswd, noInterv);
        Transaction<ObtenirFichValidCriteria, ObtenirFichValidResult> call = this.service.obtenir(criteria);
        String faults = new JoinList("\n", call.getFaults()).toString();
        if (call.getFaults().size() > 0) {
            System.out.println(faults);
        }
        Assert.assertNotNull((String)faults, (Object)call.getResult());
        return call.getResult();
    }

    @Deprecated
    public void testRequests(int i) {
        this.testRequests(i, null);
    }

    public void testRequests(int i, String name) {
        try {
            switch (i) {
                case 0: {
                    try {
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=1]/val_cod_fact[cod_fact=5 and dd_effec_cod_fact<'2016-01-31' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=2]/val_cod_fact[des_cod_fact contains text {'endosco.*', 'gastro.*'} all using wildcards and dd_effec_cod_fact<='2016-02-01' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=1]/val_cod_fact[cod_fact=8875 and dd_effec_cod_fact<'2016-01-31' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=2]/val_cod_fact[cod_fact=20030 and dd_effec_cod_fact<'2016-01-31' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=1]/val_cod_fact[cod_fact=16158 and dd_effec_cod_fact<'2016-01-31' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                        ObtenirFichValidServiceTest.process((String)"/cod_fact[no_enten=1]/val_cod_fact[cod_fact=56 and dd_effec_cod_fact<'2016-01-31' and (not(df_effec_cod_fact) or df_effec_cod_fact > '2016-01-31')]", (Context)this.context);
                    }
                    catch (QueryException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 1: {
                    try {
                        String names = "";
                        String query = "";
                        if (name != null) {
                            String[] n = name.split("[ ,']");
                            ArrayList<String> l = new ArrayList<String>();
                            String[] stringArray = n;
                            int n2 = n.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String ss = stringArray[n3];
                                if (ss.length() > 2) {
                                    l.add(ss);
                                }
                                ++n3;
                            }
                            names = "'" + new JoinList(".*','", l).toString() + ".*'";
                            query = "/cod_diagn_mdcal/val_cod_diagn_mdcal[des_long_diagn_mdcal contains text {" + names + "} all using wildcards]";
                        } else {
                            query = "/cod_diagn_mdcal/val_cod_diagn_mdcal";
                        }
                        System.out.println(query);
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (QueryProcessor proc = new QueryProcessor(query, this.context);){
                            Item item;
                            Iter iter = proc.iter();
                            while ((item = iter.next()) != null) {
                                String node = new XQuery(item.toString()).execute(this.context).toString();
                                String code = new XQuery(String.valueOf(node) + "/cod_diagn_mdcal/text()").execute(this.context).toString();
                                String desc = new XQuery(String.valueOf(node) + "/des_abr_diagn_mdcal/text()").execute(this.context).toString();
                                System.out.println(String.valueOf(code) + ":" + desc);
                            }
                            break;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
            }
        }
        catch (BaseXException e) {
            e.printStackTrace();
        }
    }

    public void testImportFichiersInNew() {
        if (!this.dbOpen("ramq_valid")) {
            this.createDb("ramq_valid", this.getFiles());
        }
        this.testRequests(1, "doul abdo");
    }

    private boolean dbOpen(String string) {
        try {
            this.setContextOptions();
            new Open(string).execute(this.context);
            System.out.print(new InfoDB().execute(this.context));
            return true;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    public void setContextOptions() throws BaseXException {
        this.context.options.assign("STEMMING", "true");
        this.context.options.assign("LANGUAGE", "fr");
        URL urlStopWords = Thread.currentThread().getContextClassLoader().getResource(stopWords);
        if (urlStopWords != null) {
            this.context.options.assign("STOPWORDS", urlStopWords.getFile());
        }
        this.context.options.assign("INTPARSE", "true");
        this.context.options.assign("XINCLUDE", "true");
        this.context.options.assign("STRIPNS", "true");
        this.context.options.assign("CHOP", "true");
        this.context.options.assign("QUERYINFO", "true");
    }

    private List<String> getFiles() {
        ArrayList<String> lstFiles = new ArrayList<String>();
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/secteurActivite_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/infoEtablissement_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeDiagnostic_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeFacturation_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeFacturation_Specialiste_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/codeLocalite_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/elementContexte_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/elementContexte_Specialiste_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/messageExplicatif_Omnipraticien_V2_20160429.xml");
        lstFiles.add("/Users/pdrolet/BaseXData/valid_xml/messageExplicatif_Specialiste_V2_20160429.xml");
        return lstFiles;
    }

    private void createDb(String dbname, List<String> lstFiles) {
        if (lstFiles != null && lstFiles.size() > 0) {
            try {
                new CreateDB(dbname).execute(this.context);
                for (String dataFile : lstFiles) {
                    new Add("", dataFile).execute(this.context);
                }
                new CreateIndex((Object)Commands.CmdIndex.TEXT).execute(this.context);
                new CreateIndex((Object)Commands.CmdIndex.FULLTEXT).execute(this.context);
                new OptimizeAll().execute(this.context);
                System.out.print(new InfoDB().execute(this.context));
            }
            catch (BaseXException e) {
                e.printStackTrace();
            }
        }
    }

    static void process(String query, Context context) throws QueryException, BaseXException {
        long t1 = System.currentTimeMillis();
        Throwable throwable = null;
        Object var5_5 = null;
        try (QueryProcessor proc = new QueryProcessor(query, context);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                long t2 = System.currentTimeMillis();
                String node = new XQuery(item.toString()).execute(context).toString();
                long t3 = System.currentTimeMillis();
                String code = new XQuery(String.valueOf(node) + "/cod_fact/text()").execute(context).toString();
                String desc = new XQuery(String.valueOf(node) + "/des_cod_fact/text()").execute(context).toString();
                System.out.println(String.valueOf(code) + ":" + desc);
            }
            long t1_1 = System.currentTimeMillis();
            System.out.println("t1_1-t1= " + (t1_1 - t1) + "ms");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

