/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.generated.cxf.ServGenerIdMachn.ConfirmerGenerationIDMachine;
import ca.infodata.syra.generated.cxf.ServGenerIdMachn.ConfirmerGenerationIDMachineResponse;
import ca.infodata.syra.generated.cxf.ServGenerIdMachn.GenererIDMachine;
import ca.infodata.syra.generated.cxf.ServGenerIdMachn.GenererIDMachineResponse;
import ca.infodata.syra.generated.cxf.ServGenerIdMachn.IServGenerIdMachn;
import ca.infodata.syra.generated.cxf.ServGenerIdMachn.ObjectFactory;
import ca.infodata.syra.handlers.ThreadSafeLastCallLogHandler;
import ca.infodata.syra.services.GenererIdMachineCriteria;
import ca.infodata.syra.services.GenererIdMachineResult;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;

public class GenererIdMachineService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServGenerIdMachn_svc/ServGenerIdMachn.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPY_InscSuspAgenc/OPY1_ServGenerIdMachn_svc/ServGenerIdMachn.svc";
    public static final String EVENT_TYPE = "GenererIdMachine";
    private final ObjectFactory objectFactory;
    private final IServGenerIdMachn proxy;
    private Map<String, Object> requestContext;
    private final String endpointAddress;
    private final ThreadSafeLastCallLogHandler threadSafeLastCallLogHandler;
    private final DsMessageParser dsMessageParser;

    public GenererIdMachineService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public GenererIdMachineService(Collection<Handler> handlers, String endpoint) throws Exception {
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlers);
        this.threadSafeLastCallLogHandler = new ThreadSafeLastCallLogHandler();
        handlerChain.add(0, (Handler)this.threadSafeLastCallLogHandler);
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.getInInterceptors().add(new LoggingInInterceptor());
        factory.getOutInterceptors().add(new LoggingOutInterceptor());
        factory.setServiceClass(IServGenerIdMachn.class);
        factory.setAddress(this.endpointAddress);
        this.proxy = (IServGenerIdMachn)factory.create();
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(true);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
    }

    public Transaction<GenererIdMachineCriteria, GenererIdMachineResult> generer(GenererIdMachineCriteria criteria) {
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        Client client = ClientProxy.getClient((Object)this.proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.getAuthorization().setUserName(criteria.getUserId());
        http.getAuthorization().setPassword(criteria.getUserPswd());
        this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getUserId());
        this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getUserPswd());
        Transaction.TransactionBuilder<GenererIdMachineCriteria, GenererIdMachineResult> builder = new Transaction.TransactionBuilder<GenererIdMachineCriteria, GenererIdMachineResult>();
        builder.setEventType(EVENT_TYPE);
        builder.setCriteria(criteria);
        builder.setEndpointAddress(this.endpointAddress);
        builder.setEventId(UUID.randomUUID().toString());
        try {
            GenererIDMachine genererParam = this.objectFactory.createGenererIDMachine();
            genererParam.setStrIDUtilisateur(this.objectFactory.createGenererIDMachineStrIDUtilisateur(criteria.getUserId()));
            genererParam.setStrMotDePasse(this.objectFactory.createGenererIDMachineStrMotDePasse(criteria.getUserPswd()));
            genererParam.setStrNoIntervenant(this.objectFactory.createGenererIDMachineStrNoIntervenant(criteria.getNoIntervenant()));
            GenererIDMachineResponse renewResponse = this.proxy.genererIDMachine(genererParam);
            if (this.isResponseOK(renewResponse, builder)) {
                String strMachineId = (String)renewResponse.getStrIDMachine().getValue();
                String strMachinePswd = (String)renewResponse.getStrMotDePasseMachine().getValue();
                ConfirmerGenerationIDMachine confirmParam = this.objectFactory.createConfirmerGenerationIDMachine();
                confirmParam.setStrIDUtilisateur(this.objectFactory.createConfirmerGenerationIDMachineStrIDUtilisateur(strMachineId));
                confirmParam.setStrMotDePasse(this.objectFactory.createConfirmerGenerationIDMachineStrMotDePasse(strMachinePswd));
                confirmParam.setStrNoIntervenant(this.objectFactory.createConfirmerGenerationIDMachineStrNoIntervenant(criteria.getNoIntervenant()));
                ConfirmerGenerationIDMachineResponse confirmerGenerationIdMachine = this.proxy.confirmerGenerationIDMachine(confirmParam);
                if (this.isResponseOK(confirmerGenerationIdMachine, builder)) {
                    builder.setResult(new GenererIdMachineResult(strMachineId, strMachinePswd));
                }
            }
        }
        catch (Exception e) {
            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
        }
        builder.setRawRequest(this.threadSafeLastCallLogHandler.getRequest());
        builder.setRawResponse(this.threadSafeLastCallLogHandler.getResponse());
        Transaction<GenererIdMachineCriteria, GenererIdMachineResult> r = builder.build();
        return r;
    }

    private boolean isResponseOK(GenererIDMachineResponse result, Transaction.TransactionBuilder<GenererIdMachineCriteria, GenererIdMachineResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de la confirmation"));
        } else {
            String strMessage = (String)result.getCodeErreur().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private boolean isResponseOK(ConfirmerGenerationIDMachineResponse result, Transaction.TransactionBuilder<GenererIdMachineCriteria, GenererIdMachineResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est survenue lors de la demande"));
        } else {
            String strMessage = (String)result.getCodeErreur().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, GenererIdMachineResult> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            try {
                String message = this.dsMessageParser.parse(strMessage, DsMessageParser.TYPE.NO_AND_TEXT_FICHIER);
                builder.getFaults().add(new RequestFault("ERREUR RAMQ", message));
            }
            catch (Exception e) {
                builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Erreur", e));
            }
        }
    }

    protected void setCookie(BindingProvider provider) {
    }
}

