/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.services;

import ca.infodata.syra.SyraPlugin;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.CorrellerEnvoyer;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.CorrellerEnvoyerResponse;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.EnteteRAMQ;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.EnvoyerLotFichier;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.EnvoyerLotFichierResponse;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.IDestinataireEntrant;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.InitierEnvoi;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.InitierEnvoiResponse;
import ca.infodata.syra.generated.cxf.ServEchgLotFichDPEntrant.ObjectFactory;
import ca.infodata.syra.handlers.ThreadSafeLastCallLogHandler;
import ca.infodata.syra.services.EchgLotFichDPEntrantCriteria;
import ca.infodata.syra.services.EchgLotFichDPEntrantResult;
import ca.infodata.syra.services.RequestFault;
import ca.infodata.syra.services.Transaction;
import ca.infodata.syra.util.DsMessageParser;
import ca.infodata.syra.util.Helper;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class EchgLotFichDPEntrantService {
    public static final String ENDPOINT_ADDRESS_PROPERTY_PROD = "https://www4.prod.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichDPEntrant.svc";
    public static final String ENDPOINT_ADDRESS_PROPERTY_PARTE = "https://www4.parte.ramq.gouv.qc.ca/TIP/OP/OPX_GereEchgInfoPaimt/OPX2_ServEchgLotFichDP_svc/ServEchgLotFichDPEntrant.svc";
    public static final String EVENT_TYPE = "EchgLotFichDPEntrant";
    private ObjectFactory objectFactory;
    private IDestinataireEntrant proxy;
    private Map<String, Object> requestContext;
    private String endpointAddress;
    private ThreadSafeLastCallLogHandler threadSafeLastCallLogHandler;
    private DsMessageParser dsMessageParser;

    public EchgLotFichDPEntrantService() throws Exception {
        this(new ArrayList<Handler>(), null);
    }

    public EchgLotFichDPEntrantService(Collection<Handler> handlers, String endpoint) throws Exception {
        if (handlers == null) {
            throw new NullPointerException("customsHandlers");
        }
        this.endpointAddress = endpoint == null ? ENDPOINT_ADDRESS_PROPERTY_PARTE : endpoint;
        ArrayList<Handler> handlerChain = new ArrayList<Handler>(handlers);
        this.threadSafeLastCallLogHandler = new ThreadSafeLastCallLogHandler();
        handlerChain.add(0, (Handler)this.threadSafeLastCallLogHandler);
        this.objectFactory = new ObjectFactory();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(IDestinataireEntrant.class);
        factory.setAddress(this.endpointAddress);
        factory.setHandlers(handlerChain);
        this.proxy = (IDestinataireEntrant)factory.create();
        BindingProvider bindingProvider = (BindingProvider)this.proxy;
        SOAPBinding binding = (SOAPBinding)bindingProvider.getBinding();
        binding.setMTOMEnabled(true);
        this.requestContext = bindingProvider.getRequestContext();
        this.requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        this.dsMessageParser = new DsMessageParser(JAXBContext.newInstance((String)"org.tempuri.erreurs_ds"));
    }

    public Transaction<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> envoyer(EchgLotFichDPEntrantCriteria criteria, byte[] fileBytes) {
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        Client client = ClientProxy.getClient((Object)this.proxy);
        HTTPConduit http = (HTTPConduit)client.getConduit();
        http.getAuthorization().setUserName(criteria.getUserId());
        http.getAuthorization().setPassword(criteria.getUserPswd());
        this.requestContext.put("javax.xml.ws.security.auth.username", criteria.getUserId());
        this.requestContext.put("javax.xml.ws.security.auth.password", criteria.getUserPswd());
        Transaction.TransactionBuilder<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> builder = new Transaction.TransactionBuilder<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult>();
        builder.setEventType(EVENT_TYPE);
        builder.setCriteria(criteria);
        builder.setEndpointAddress(this.endpointAddress);
        builder.setEventId(UUID.randomUUID().toString());
        builder.setResult(SyraPlugin.getDefault().getEchgLotFichDPEntrantResult());
        try {
            EnteteRAMQ enteteRAMQ = this.objectFactory.createEnteteRAMQ();
            enteteRAMQ.setIdEntIntvnEchg(this.objectFactory.createEnteteRAMQIdEntIntvnEchg(criteria.getNoIntervenant()));
            enteteRAMQ.setEtatEchgFich(this.objectFactory.createEnteteRAMQEtatEchgFich(""));
            enteteRAMQ.setNoEchgFich(this.objectFactory.createEnteteRAMQNoEchgFich(""));
            enteteRAMQ.setTypEntIntvnEchg(this.objectFactory.createEnteteRAMQTypEntIntvnEchg("NT"));
            JAXBElement<EnteteRAMQ> enteteRAMQ2 = this.objectFactory.createInitierEnvoiObjEntete(enteteRAMQ);
            InitierEnvoi initierEnvoi = this.objectFactory.createInitierEnvoi();
            initierEnvoi.setObjEntete(enteteRAMQ2);
            initierEnvoi.setStrXmlSortie(this.objectFactory.createInitierEnvoiStrXmlSortie(""));
            InitierEnvoiResponse initierEnvoiResponse = this.proxy.initierEnvoi(initierEnvoi);
            if (this.isResponseOK(initierEnvoiResponse, builder)) {
                EnvoyerLotFichier envoyerLotFichier = this.objectFactory.createEnvoyerLotFichier();
                envoyerLotFichier.setStrXmlEntree(this.objectFactory.createEnvoyerLotFichierStrXmlEntree("<param><nom_fich>log" + System.currentTimeMillis() + ".zip</nom_fich></param>"));
                envoyerLotFichier.setStrXmlSortie(this.objectFactory.createEnvoyerLotFichierStrXmlSortie(""));
                JAXBElement<EnteteRAMQ> enteteRAMQ3 = this.objectFactory.createEnvoyerLotFichierObjEntete((EnteteRAMQ)initierEnvoiResponse.getObjEntete().getValue());
                envoyerLotFichier.setObjEntete(enteteRAMQ3);
                envoyerLotFichier.setBytContFich(this.objectFactory.createEnvoyerLotFichierBytContFich(fileBytes));
                EnvoyerLotFichierResponse lotFichierResponse = this.proxy.envoyerLotFichier(envoyerLotFichier);
                if (this.isResponseOK(lotFichierResponse, builder)) {
                    CorrellerEnvoyer correllerEnvoyer = this.objectFactory.createCorrellerEnvoyer();
                    JAXBElement<EnteteRAMQ> enteteRAMQ4 = this.objectFactory.createCorrellerEnvoyerObjEntete((EnteteRAMQ)lotFichierResponse.getObjEntete().getValue());
                    correllerEnvoyer.setObjEntete(enteteRAMQ4);
                    correllerEnvoyer.setStrXmlEntree(this.objectFactory.createCorrellerEnvoyerStrXmlEntree("<param><no_accu_recept>" + builder.getResult().getNoAccuRecept() + "</no_accu_recept></param>"));
                    correllerEnvoyer.setStrXmlSortie(this.objectFactory.createCorrellerEnvoyerStrXmlSortie(""));
                    CorrellerEnvoyerResponse correllerEnvoyerResponse = this.proxy.correllerEnvoyer(correllerEnvoyer);
                    if (this.isResponseOK(correllerEnvoyerResponse, builder)) {
                        builder.setResult(new EchgLotFichDPEntrantResult(criteria.getNoIntervenant(), criteria.getUserId()));
                    }
                }
            }
        }
        catch (Exception e) {
            builder.getFaults().add(new RequestFault("REQUEST_PROCESSING_FAULT", e.getMessage(), e));
        }
        builder.setRawRequest(this.threadSafeLastCallLogHandler.getRequest());
        builder.setRawResponse(this.threadSafeLastCallLogHandler.getResponse());
        Transaction<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> r = builder.build();
        return r;
    }

    private boolean isResponseOK(CorrellerEnvoyerResponse result, Transaction.TransactionBuilder<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de CorrellerEnvoyer"));
        } else {
            String strMessage = (String)result.getStrXmlSortie().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private boolean isResponseOK(InitierEnvoiResponse result, Transaction.TransactionBuilder<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de InitierEnvoi"));
        } else {
            String strMessage = (String)result.getStrXmlSortie().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private boolean isResponseOK(EnvoyerLotFichierResponse result, Transaction.TransactionBuilder<EchgLotFichDPEntrantCriteria, EchgLotFichDPEntrantResult> builder) {
        if (result == null) {
            builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Une erreur technique est arriv\u00e9 lors de EnvoyerLotFichier"));
        } else {
            String strMessage = (String)result.getStrXmlSortie().getValue();
            this.processStrMessage(builder, strMessage);
        }
        return builder.getFaults().isEmpty();
    }

    private void processStrMessage(Transaction.TransactionBuilder<?, EchgLotFichDPEntrantResult> builder, String strMessage) {
        if (Helper.isNotBlank(strMessage)) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(new InputSource(new ByteArrayInputStream(strMessage.getBytes("utf-8"))));
                String info_err = doc.getElementsByTagName("info_err").item(0).getTextContent();
                if (StringUtils.isNotEmpty((CharSequence)info_err)) {
                    String message = this.dsMessageParser == null ? "dsMessageParser est null: " + info_err : this.dsMessageParser.parse(info_err, DsMessageParser.TYPE.TEXT);
                    builder.getFaults().add(new RequestFault("ERREUR RAMQ", message));
                } else {
                    String no_accu_recept = null;
                    String nom_fich = null;
                    if (doc.getElementsByTagName("no_accu_recept") != null && doc.getElementsByTagName("no_accu_recept").getLength() > 0) {
                        no_accu_recept = doc.getElementsByTagName("no_accu_recept").item(0).getTextContent();
                        builder.getResult().setNoAccuRecept(no_accu_recept);
                    }
                    if (doc.getElementsByTagName("nom_fich") != null && doc.getElementsByTagName("nom_fich").getLength() > 0) {
                        nom_fich = doc.getElementsByTagName("nom_fich").item(0).getTextContent();
                        builder.getResult().setNomFichierZip(nom_fich);
                    }
                }
            }
            catch (Exception e) {
                builder.getFaults().add(new RequestFault("RESPONSE_PROCESSING_FAULT", "Erreur", e));
            }
        }
    }

    protected void setCookie(BindingProvider provider) {
    }
}

