/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.dossier.lib.LibPlugin;
import ca.infodata.syra.models.CProfessionnal;
import ca.infodata.syra.models.FichierAideData;
import ca.infodata.syra.query.IBaseXQuery;
import ca.infodata.syra.query.QueryCriteria;
import ca.infodata.syra.util.DownloadValideur;
import ca.infodata.syra.util.JoinList;
import ca.infodata.syra.util.ValidRamq;
import ca.infodata.util1.StringUtils;
import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.basex.core.Context;
import org.basex.core.cmd.XQuery;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.eclipse.core.runtime.Platform;

public class Versions
extends IBaseXQuery {
    protected static String fileInfoVersion = "fn:string-join((cod_fich_ext_aide_sais/text(),no_versi_fich/text(),dat_extr/text()),':')";
    public static Map<String, Object[]> mapFichierNom = new HashMap<String, Object[]>();
    public static Properties propVersion = new Properties();

    static {
        mapFichierNom.put("1", new Object[]{"1", QueryCriteria.ModelType.COD_FACT, "Code Facturation Omnipraticien"});
        mapFichierNom.put("2", new Object[]{"2", QueryCriteria.ModelType.COD_FACT, "Code Facturation Specialiste"});
        mapFichierNom.put("3", new Object[]{"", QueryCriteria.ModelType.COD_DIAGN_MDCAL, "Code Diagnostic"});
        mapFichierNom.put("4", new Object[]{"", QueryCriteria.ModelType.COD_LOCAL, "Code Localite"});
        mapFichierNom.put("5", new Object[]{"1", QueryCriteria.ModelType.SECT_ACTIV, "Secteur Activite Omnipraticien"});
        mapFichierNom.put("6", new Object[]{"2", QueryCriteria.ModelType.SECT_ACTIV, "Secteur Activite Specialiste"});
        mapFichierNom.put("7", new Object[]{"", QueryCriteria.ModelType.INFO_ETAB, "Info Etablissement"});
        mapFichierNom.put("8", new Object[]{"1", QueryCriteria.ModelType.MSG_EXPL, "Message Explicatif Omnipraticien"});
        mapFichierNom.put("9", new Object[]{"2", QueryCriteria.ModelType.MSG_EXPL, "Message Explicatif Specialiste"});
        mapFichierNom.put("10", new Object[]{"1", QueryCriteria.ModelType.ELM_CONTX, "Element Contexte Omnipraticien"});
        mapFichierNom.put("11", new Object[]{"2", QueryCriteria.ModelType.ELM_CONTX, "Element Contexte Specialiste"});
    }

    public Properties getVersionProp() {
        if (propVersion.isEmpty()) {
            this.getFichierVersion();
        }
        if (propVersion.isEmpty()) {
            return null;
        }
        return propVersion;
    }

    public List<FichierAideData> getFichierVersion() {
        Object entente;
        propVersion.clear();
        ArrayList<FichierAideData> lstVersion = new ArrayList<FichierAideData>();
        String fichiersAide = "";
        boolean hasErrInGetData = false;
        for (String k : mapFichierNom.keySet()) {
            String fichierData;
            Object[] v = mapFichierNom.get(k);
            entente = "";
            String ent = (String)v[0];
            QueryCriteria.ModelType mt = (QueryCriteria.ModelType)((Object)v[1]);
            String nom = (String)v[2];
            String entNo = "";
            if (!ent.isEmpty()) {
                entente = "[no_enten=" + ent + "]";
                entNo = "_" + ent;
            }
            String query = "/" + mt.name().toLowerCase() + (String)entente + "/" + fileInfoVersion;
            String string = fichierData = hasErrInGetData ? "" : this.getFichierData(query);
            if (StringUtils.isEmpty((String)fichierData)) {
                hasErrInGetData = true;
                lstVersion.add(new FichierAideData(nom, new Integer(0), "0", "2000-01-01"));
                propVersion.put(String.valueOf(mt.name().toLowerCase()) + entNo, "2000-01-01");
                continue;
            }
            String[] data = fichierData.split(":");
            if (data.length != 3) continue;
            lstVersion.add(new FichierAideData(nom, new Integer(data[0]), data[1], data[2]));
            propVersion.put(String.valueOf(mt.name().toLowerCase()) + entNo, data[2]);
            String version = String.valueOf(mt.name().toLowerCase()) + entNo + "=" + data[2];
            fichiersAide = String.valueOf(fichiersAide) + version + "/n";
            System.out.println(version);
        }
        if (LibPlugin.isInfodata && DownloadValideur.getInstance().checkIfNewValid()) {
            String fichierAideTxt = String.valueOf(Platform.inDebugMode() ? "debug_" : "") + "fichieraides.txt";
            String userDir = String.valueOf(System.getProperty("user.home")) + "/";
            File fileLocalFromServeur = new File(String.valueOf(userDir) + fichierAideTxt);
            if (fileLocalFromServeur.exists()) {
                fileLocalFromServeur.delete();
            }
            try {
                entente = null;
                Object var8_10 = null;
                try (PrintWriter out = new PrintWriter(fileLocalFromServeur);){
                    out.write(fichiersAide);
                    out.flush();
                    out.close();
                }
                catch (Throwable throwable) {
                    if (entente == null) {
                        entente = throwable;
                    } else if (entente != throwable) {
                        ((Throwable)entente).addSuppressed(throwable);
                    }
                    throw entente;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return lstVersion;
    }

    public String getFichierData(String query) {
        String desc = "";
        try {
            if (ValidRamq.getInstance().getContext() != null && ValidRamq.getInstance().getContext().root()) {
                desc = new XQuery(query).execute(ValidRamq.getInstance().getContext()).toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return desc;
    }

    @Override
    public String getDescription(QueryCriteria criteria) {
        String desc = "";
        try {
            desc = new XQuery(String.valueOf(criteria.node) + "/des_cod_fact/text()").execute(ValidRamq.getInstance().getContext()).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return desc;
    }

    @Override
    public String getDescriptionLong(QueryCriteria criteria) {
        return null;
    }

    @Override
    public List<String> getDataByCriteria(QueryCriteria criteria, IBaseXQuery.DataType dataType) throws QueryException, IOException {
        return null;
    }

    @Override
    public List<String[]> getCodeDescription(QueryCriteria criteria) throws QueryException, IOException {
        ArrayList<String[]> lstNode = new ArrayList<String[]>();
        String query = this.getQueryString(criteria, IBaseXQuery.DataType.CODE_DESCR);
        Context contexte = ValidRamq.getInstance().getContext();
        Throwable throwable = null;
        Object var6_7 = null;
        try (QueryProcessor proc = new QueryProcessor(query, contexte);){
            Item item;
            Iter iter = proc.iter();
            while ((item = iter.next()) != null) {
                String node = new XQuery(item.toString()).execute(contexte).toString();
                int i = node.indexOf(58);
                String code = node.substring(0, i);
                String desc = node.substring(i + 1, node.length());
                lstNode.add(new String[]{code, desc});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return lstNode;
    }

    @Override
    protected String getQueryString(QueryCriteria criteria, IBaseXQuery.DataType dataType) {
        String nn = "";
        String type = "";
        if (IBaseXQuery.DataType.CODE.equals((Object)dataType)) {
            type = "/cod_local/text()";
        } else if (IBaseXQuery.DataType.DESCRIPTION.equals((Object)dataType)) {
            type = "/nom_local/text()";
        } else if (IBaseXQuery.DataType.CODE_DESCR.equals((Object)dataType)) {
            type = "/fn:string-join((cod_local/text(),nom_local/text()),':')";
        } else if (IBaseXQuery.DataType.NODE.equals((Object)dataType)) {
            type = "";
        }
        if (criteria.names != null) {
            nn = this.getNamesWithWildcards(criteria.names);
            return "/cod_local/val_cod_local[(nom_local contains text {" + nn + "} all using wildcards or " + "no_regn contains text {" + nn + "} all using wildcards or " + "nom_munic contains text {" + nn + "} all using wildcards) and " + "dd_effec_cod_local<='" + criteria.date + "' and " + "(not(df_effec_cod_local) or df_effec_cod_local > '" + criteria.date + "')]" + type;
        }
        if (criteria.codes.size() > 0) {
            String names = "'" + new JoinList("','", criteria.codes).toString() + "'";
            return "/cod_local/val_cod_local[cod_local contains text {" + names + "} any and dd_effec_cod_local<='" + criteria.date + "' and (not(df_effec_cod_local) or df_effec_cod_local > '" + criteria.date + "')]" + type;
        }
        if (criteria.date != null && criteria.date.trim().length() == 10) {
            return "/cod_local/val_cod_local[dd_effec_cod_local<='" + criteria.date + "' and (not(df_effec_cod_local) or df_effec_cod_local > '" + criteria.date + "')]" + type;
        }
        return "/cod_local/val_cod_local" + type;
    }

    @Override
    public Object[] getJavaObjects(QueryCriteria criteria) {
        return null;
    }

    @Override
    public Object getJavaObjectFromNode(CProfessionnal.Entente entente, String node, XStream xs) {
        return null;
    }

    public static Properties loadProperties(String file) {
        if (!new File(file).exists()) {
            System.out.println("Fichier non trouv\u00e9 : " + file);
            return null;
        }
        Properties props = new Properties();
        try {
            File propsFile = new File(file);
            props.load(new FileInputStream(propsFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public static Properties loadPropertiesFromString(String String2) {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(String2.getBytes("UTF-8")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }
}

