/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.syra.query;

import ca.infodata.ofys.util.EnumWithValue;
import ca.infodata.syra.models.CPatient;
import ca.infodata.syra.query.IQueryCriteria;
import ca.infodata.syra.query.IQueryCriteriaDate;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.date.LocalDate;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class QueryCriteria
implements IQueryCriteria,
IQueryCriteriaDate {
    final ModelType modelType;
    Set<String> codes = new HashSet<String>();
    Integer role;
    Integer codeFact;
    CodNiveau codNiv;
    String node;
    String names;
    String filterDescr;
    Integer entente;
    String codeSpec;
    String date;
    EtablType etablType;
    private Boolean exactCode;
    private Boolean codePlusLibre;
    Integer ageYears;
    Integer ageMonths;
    Integer ageJours;
    public Long noRfp;

    public QueryCriteria(ModelType mt, String theNode) {
        this.modelType = mt;
        this.node = theNode;
    }

    public QueryCriteria(ModelType mt, String[] codes, String names, EtablType etablType) {
        this.modelType = mt;
        if (codes != null && codes.length > 0) {
            this.codes.addAll(Arrays.asList(codes));
        }
        this.names = names;
        this.etablType = etablType;
    }

    public QueryCriteria(ModelType mt, Integer entente, Integer role, String[] codes, String names, String filterDesc, String date, Integer codeFact, CodNiveau codNiv, EtablType etablType) {
        this.modelType = mt;
        this.entente = entente;
        this.role = role;
        if (codes != null) {
            this.codes.addAll(Arrays.asList(codes));
        }
        this.names = names;
        this.filterDescr = filterDesc;
        this.codeFact = codeFact;
        this.date = date == null ? LocalDate.today().formatHyphen() : date;
        CodNiveau newCodNiv = codNiv;
        if (!CodNiveau.FACTURE_SERV_MDCAL.equals((Object)codNiv) && !CodNiveau.NONE.equals((Object)codNiv)) {
            newCodNiv = CodNiveau.LIGNE_SERV_MDCAL;
        }
        this.codNiv = newCodNiv;
        this.etablType = etablType;
    }

    public final Set<String> getFromAutoCodes() {
        return this.codes;
    }

    public final void setFromAutoCodes(Set<String> fromAutoCodes) {
        this.codes = fromAutoCodes;
    }

    public final void addCodeToFromAutoCodes(String c) {
        this.codes.add(c);
    }

    public final void removeCodeToFromAutoCodes(String c) {
        this.codes.remove(c);
    }

    @Override
    public String[] getCodes() {
        String[] s = new String[this.codes.size()];
        if (s.length > 0) {
            s = this.codes.toArray(s);
        }
        return s;
    }

    @Override
    public String getNames() {
        return this.names;
    }

    public String getFilterDescr() {
        return this.filterDescr;
    }

    public void setFilterDescr(String filterDescr) {
        this.filterDescr = filterDescr;
    }

    @Override
    public Integer getEntente() {
        return this.entente;
    }

    public final String getCodeSpec() {
        return this.codeSpec;
    }

    public final void setCodeSpec(String codeSpec) {
        this.codeSpec = codeSpec;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    public final Integer getRole() {
        return this.role;
    }

    public final void setRole(Integer role) {
        this.role = role;
    }

    public final Integer getCodeFact() {
        return this.codeFact;
    }

    public final void setCodeFact(Integer codeFact) {
        this.codeFact = codeFact;
    }

    public final CodNiveau getCodNiv() {
        return this.codNiv;
    }

    public final void setCodNiv(CodNiveau codNiv) {
        this.codNiv = codNiv;
    }

    public final void setCodes(String[] codes) {
        this.codes.addAll(Arrays.asList(codes));
    }

    public final String getNode() {
        return this.node;
    }

    public final void setNode(String n) {
        this.node = n;
    }

    public final void setNames(String names) {
        this.names = names;
    }

    public final void setEntente(Integer entente) {
        this.entente = entente;
    }

    public final void setDate(String date) {
        this.date = date;
    }

    public final EtablType getEtablType() {
        return this.etablType;
    }

    public final void setEtablType(EtablType etablType) {
        this.etablType = etablType;
    }

    public final Integer getAgeYears() {
        return this.ageYears;
    }

    public final void setAgeYears(Integer ageYears) {
        this.ageYears = ageYears;
    }

    public final Integer getAgeMonths() {
        return this.ageMonths;
    }

    public final void setAgeMonths(Integer ageMonths) {
        this.ageMonths = ageMonths;
    }

    public final Integer getAgeJours() {
        return this.ageJours;
    }

    public final void setAgeJours(Integer ageJours) {
        this.ageJours = ageJours;
    }

    public final void setAges(CPatient.Ages a) {
        if (a != null) {
            this.ageJours = new Integer(a.getJours());
            this.ageMonths = new Integer(a.getMois());
            this.ageYears = new Integer(a.getAns());
        }
    }

    public Boolean getExactCode() {
        return this.exactCode;
    }

    public void setExactCode(Boolean exactCode) {
        this.exactCode = exactCode;
    }

    public Boolean getCodePlusLibre() {
        return this.codePlusLibre;
    }

    public void setCodePlusLibre(Boolean codePlusLibre) {
        this.codePlusLibre = codePlusLibre;
    }

    public final String toString() {
        Field[] fields;
        StringBuffer sb = new StringBuffer();
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                field.setAccessible(true);
                String key = field.getName();
                String value = this.getStringValue(field);
                sb.append(key).append(": ").append(value).append("\n");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return sb.toString();
    }

    public final String getStringForHashcode() {
        Field[] fields;
        StringBuffer sb = new StringBuffer();
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                field.setAccessible(true);
                String key = field.getName();
                String value = this.getStringValue(field);
                sb.append(key.charAt(0)).append(value).append(";");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return sb.toString();
    }

    private String getStringValue(Field field) throws IllegalAccessException {
        String value = "";
        try {
            Object v = field.get(this);
            if (v == null) {
                value = "";
            } else if (v instanceof String) {
                value = (String)field.get(this);
            } else if (v instanceof Integer || v instanceof Boolean || v instanceof Long) {
                value = String.valueOf(field.get(this));
            } else if (v instanceof ModelType) {
                value = String.valueOf(((ModelType)((Object)field.get((Object)this))).value);
            } else if (v instanceof EtablType) {
                value = String.valueOf(((EtablType)((Object)field.get(this))).ordinal());
            } else if (v instanceof CodNiveau) {
                value = String.valueOf(((CodNiveau)((Object)field.get(this))).ordinal());
            } else if (v instanceof Set) {
                Set set = (Set)field.get(this);
                value = new JoinList(",", (Collection)set).toString();
            }
        }
        catch (ClassCastException e) {
            value = "";
        }
        return value;
    }

    public static enum CodNiveau {
        NONE(""),
        LIGNE_SERV_MDCAL("L"),
        FACTURE_SERV_MDCAL("F"),
        DEPL_FORF("O"),
        DEPL_FR_SEJ("S"),
        DEPL_FR_TRSP("T"),
        DEPL_TPS_DEPL("D");

        private final String codNiv;

        private CodNiveau(String t) {
            this.codNiv = t;
        }

        public String getCode() {
            return this.codNiv;
        }

        public static CodNiveau from(String value) {
            if (value != null) {
                CodNiveau[] codNiveauArray = CodNiveau.values();
                int n = codNiveauArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CodNiveau e = codNiveauArray[n2];
                    if (e.codNiv.equals(value)) {
                        return e;
                    }
                    ++n2;
                }
            }
            return NONE;
        }
    }

    public static enum EtablType {
        SO,
        CABINET,
        ETABLISSEMENT;

    }

    public static enum ModelType implements EnumWithValue
    {
        COD_DIAGN_MDCAL(0),
        COD_FACT(1),
        ELM_CONTX(2),
        COD_LOCAL(3),
        INFO_ETAB(4),
        SECT_ACTIV(5),
        MSG_EXPL(6),
        EXPL_PAIMT(7);

        public final int value;

        private ModelType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static ModelType from(Integer value) {
            if (value != null) {
                ModelType[] modelTypeArray = ModelType.values();
                int n = modelTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelType e = modelTypeArray[n2];
                    if (e.value == value) {
                        return e;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

